# typed: strict
# frozen_string_literal: true

########################################################################################################################
# This file is auto-generated. If you have an issue, please create a GitHub issue.                                     #
########################################################################################################################

$VERBOSE = nil
$LOAD_PATH.unshift(File.join(File.dirname(__FILE__), "..", "lib"))

require "minitest/autorun"
require "webmock/minitest"

require "shopify_api"
require_relative "../../test_helper"

class Order202210Test < Test::Unit::TestCase
  def setup
    super

    test_session = ShopifyAPI::Auth::Session.new(id: "id", shop: "test-shop.myshopify.io", access_token: "this_is_a_test_token")
    ShopifyAPI::Context.activate_session(test_session)
    modify_context(api_version: "2022-10")
  end

  def teardown
    super

    ShopifyAPI::Context.deactivate_session
  end

  sig do
    void
  end
  def test_1()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json?status=any")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"orders" => [{"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2008-01-10T11:00:00-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-10-03T13:17:01-04:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}]}), headers: {})

    response = ShopifyAPI::Order.all(
      status: "any",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json?status=any")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_2()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json?since_id=123")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"orders" => [{"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2008-01-10T11:00:00-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-10-03T13:17:01-04:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}]}), headers: {})

    response = ShopifyAPI::Order.all(
      since_id: "123",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json?since_id=123")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_3()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json?fields=created_at%2Cid%2Cname%2Ctotal-price")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"orders" => [{"id" => 450789469, "created_at" => "2008-01-10T11:00:00-05:00", "name" => "#1001", "total_price" => "598.94"}]}), headers: {})

    response = ShopifyAPI::Order.all(
      fields: "created_at,id,name,total-price",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json?fields=created_at%2Cid%2Cname%2Ctotal-price")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_4()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json?updated_at_min=2005-07-31T15%3A57%3A11-04%3A00")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"orders" => [{"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2008-01-10T11:00:00-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-10-03T13:17:01-04:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}]}), headers: {})

    response = ShopifyAPI::Order.all(
      updated_at_min: "2005-07-31T15:57:11-04:00",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json?updated_at_min=2005-07-31T15%3A57%3A11-04%3A00")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_5()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json?financial_status=authorized")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"orders" => [{"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "authorized", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:04-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-10-03T13:17:01-04:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}]}), headers: {})

    response = ShopifyAPI::Order.all(
      financial_status: "authorized",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json?financial_status=authorized")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_6()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json?ids=1073459966")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"orders" => [{"id" => 1073459966, "admin_graphql_api_id" => "gid://shopify/Order/1073459966", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "1Z8Q5G66L", "confirmed" => true, "contact_email" => nil, "created_at" => "2023-10-03T13:17:59-04:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/96911f1c8adf1d996907e2cba3e64ea2/authenticate?key=8df3fba0ba176afd59aecff9ba28ae07", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2023-10-03T13:17:59-04:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "96911f1c8adf1d996907e2cba3e64ea2", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "199.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:17:59-04:00", "user_id" => nil, "billing_address" => nil, "customer" => nil, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823177, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823177", "fulfillable_quantity" => 1, "fulfillment_service" => "shipwire-app", "fulfillment_status" => nil, "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}]}), headers: {})

    response = ShopifyAPI::Order.all(
      ids: "1073459966",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json?ids=1073459966")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_7()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json?fields=id%2Cline_items%2Cname%2Ctotal_price")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "name" => "#1001", "total_price" => "598.94", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}}), headers: {})

    response = ShopifyAPI::Order.find(
      id: 450789469,
      fields: "id,line_items,name,total_price",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json?fields=id%2Cline_items%2Cname%2Ctotal_price")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_8()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2008-01-10T11:00:00-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-10-03T13:17:01-04:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = ShopifyAPI::Order.find(
      id: 450789469,
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_9()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders/count.json?status=any")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"count" => 1}), headers: {})

    response = ShopifyAPI::Order.count(
      status: "any",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders/count.json?status=any")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_10()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders/count.json?financial_status=authorized")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"count" => 1}), headers: {})

    response = ShopifyAPI::Order.count(
      financial_status: "authorized",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2022-10/orders/count.json?financial_status=authorized")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_11()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469/close.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => "2023-10-03T13:18:07-04:00", "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:07-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-10-03T13:17:01-04:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.close

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469/close.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_12()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469/open.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:12-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-10-03T13:17:01-04:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.open

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469/open.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_13()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469/cancel.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2008-01-10T11:00:00-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-10-03T13:17:01-04:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}, "notice" => "Order has been canceled"}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.cancel

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469/cancel.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_14()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469/cancel.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: hash_including({"amount" => "10.00", "currency" => "USD"})
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "587.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "587.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "587.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "10.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "598.94", "current_total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "current_total_tax" => "11.94", "current_total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "598.94", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:10-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-10-03T13:17:01-04:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 929361463, "admin_graphql_api_id" => "gid://shopify/Refund/929361463", "created_at" => "2023-10-03T13:18:10-04:00", "note" => nil, "order_id" => 450789469, "processed_at" => "2023-10-03T13:18:10-04:00", "restock" => false, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => nil, "order_adjustments" => [], "transactions" => [{"id" => 1068278475, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/1068278475", "amount" => "10.00", "authorization" => nil, "created_at" => "2023-10-03T13:18:09-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => "Bogus Gateway: Forced success", "order_id" => 450789469, "parent_id" => 1068278474, "payment_id" => "c901414060.3", "processed_at" => "2023-10-03T13:18:09-04:00", "receipt" => {}, "source_name" => "755357713", "status" => "success", "test" => true, "user_id" => nil}], "refund_line_items" => [{"id" => 1058498308, "line_item_id" => 466157049, "location_id" => nil, "quantity" => 1, "restock_type" => "no_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 1058498309, "line_item_id" => 518995019, "location_id" => nil, "quantity" => 1, "restock_type" => "no_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 1058498310, "line_item_id" => 703073504, "location_id" => nil, "quantity" => 1, "restock_type" => "no_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}, "notice" => "Order has been canceled"}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.cancel(
      body: {"amount" => "10.00", "currency" => "USD"},
    )

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469/cancel.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_15()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469/cancel.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: hash_including({"refund" => {"note" => "Customer made a mistake", "shipping" => {"full_refund" => true}, "refund_line_items" => [{"line_item_id" => 466157049, "quantity" => 1, "restock_type" => "cancel", "location_id" => 24826418}], "transactions" => [{"parent_id" => 1068278468, "amount" => "10.00", "kind" => "refund", "gateway" => "bogus"}, {"parent_id" => 1068278469, "amount" => "100.00", "kind" => "refund", "gateway" => "gift_card"}]}})
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "587.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "587.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "587.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "10.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "598.94", "current_total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "current_total_tax" => "11.94", "current_total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus", "gift_card"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "598.94", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:17:56-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-10-03T13:17:01-04:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 929361462, "admin_graphql_api_id" => "gid://shopify/Refund/929361462", "created_at" => "2023-10-03T13:17:56-04:00", "note" => "Customer made a mistake", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:56-04:00", "restock" => false, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => nil, "order_adjustments" => [{"id" => 1030976842, "amount" => "89.64", "amount_set" => {"shop_money" => {"amount" => "89.64", "currency_code" => "USD"}, "presentment_money" => {"amount" => "89.64", "currency_code" => "USD"}}, "kind" => "refund_discrepancy", "order_id" => 450789469, "reason" => "Refund discrepancy", "refund_id" => 929361462, "tax_amount" => "0.00", "tax_amount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}}], "transactions" => [{"id" => 1068278470, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/1068278470", "amount" => "10.00", "authorization" => nil, "created_at" => "2023-10-03T13:17:56-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => "Bogus Gateway: Forced success", "order_id" => 450789469, "parent_id" => 1068278468, "payment_id" => "c901414060.4", "processed_at" => "2023-10-03T13:17:56-04:00", "receipt" => {}, "source_name" => "755357713", "status" => "success", "test" => true, "user_id" => nil}, {"id" => 1068278471, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/1068278471", "amount" => "100.00", "authorization" => nil, "created_at" => "2023-10-03T13:17:56-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "gift_card", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 1068278469, "payment_id" => "c901414060.5", "processed_at" => "2023-10-03T13:17:56-04:00", "receipt" => {"gift_card_id" => 1035197676, "gift_card_last_characters" => "0d0d"}, "source_name" => "755357713", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 1058498307, "line_item_id" => 466157049, "location_id" => nil, "quantity" => 1, "restock_type" => "no_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}, "notice" => "Order has been canceled"}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.cancel(
      body: {"refund" => {"note" => "Customer made a mistake", "shipping" => {"full_refund" => true}, "refund_line_items" => [{"line_item_id" => 466157049, "quantity" => 1, "restock_type" => "cancel", "location_id" => 24826418}], "transactions" => [{"parent_id" => 1068278468, "amount" => "10.00", "kind" => "refund", "gateway" => "bogus"}, {"parent_id" => 1068278469, "amount" => "100.00", "kind" => "refund", "gateway" => "gift_card"}]}},
    )

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469/cancel.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_16()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"line_items" => [{"title" => "Big Brown Bear Boots", "price" => 74.99, "grams" => "1300", "quantity" => 3, "tax_lines" => [{"price" => 13.5, "rate" => 0.06, "title" => "State tax"}]}], "transactions" => [{"kind" => "sale", "status" => "success", "amount" => 238.47}], "total_tax" => 13.5, "currency" => "EUR"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459969, "admin_graphql_api_id" => "gid://shopify/Order/1073459969", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "HCATKXGIM", "confirmed" => true, "contact_email" => nil, "created_at" => "2023-10-03T13:18:21-04:00", "currency" => "EUR", "current_subtotal_price" => "224.97", "current_subtotal_price_set" => {"shop_money" => {"amount" => "224.97", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "224.97", "currency_code" => "EUR"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "EUR"}}, "current_total_duties_set" => nil, "current_total_price" => "238.47", "current_total_price_set" => {"shop_money" => {"amount" => "238.47", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "238.47", "currency_code" => "EUR"}}, "current_total_tax" => "13.50", "current_total_tax_set" => {"shop_money" => {"amount" => "13.50", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "13.50", "currency_code" => "EUR"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/17c903ffa0a4e400829fe9422ac45c8c/authenticate?key=5776f2049505a41367525bcaf344415d", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [""], "phone" => nil, "po_number" => nil, "presentment_currency" => "EUR", "processed_at" => "2023-10-03T13:18:21-04:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "224.97", "subtotal_price_set" => {"shop_money" => {"amount" => "224.97", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "224.97", "currency_code" => "EUR"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "13.50", "rate" => 0.06, "title" => "State tax", "price_set" => {"shop_money" => {"amount" => "13.50", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "13.50", "currency_code" => "EUR"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "17c903ffa0a4e400829fe9422ac45c8c", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "EUR"}}, "total_line_items_price" => "224.97", "total_line_items_price_set" => {"shop_money" => {"amount" => "224.97", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "224.97", "currency_code" => "EUR"}}, "total_outstanding" => "0.00", "total_price" => "238.47", "total_price_set" => {"shop_money" => {"amount" => "238.47", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "238.47", "currency_code" => "EUR"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "EUR"}}, "total_tax" => "13.50", "total_tax_set" => {"shop_money" => {"amount" => "13.50", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "13.50", "currency_code" => "EUR"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:21-04:00", "user_id" => nil, "billing_address" => nil, "customer" => nil, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823180, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823180", "fulfillable_quantity" => 3, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 1300, "name" => "Big Brown Bear Boots", "price" => "74.99", "price_set" => {"shop_money" => {"amount" => "74.99", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "74.99", "currency_code" => "EUR"}}, "product_exists" => false, "product_id" => nil, "properties" => [], "quantity" => 3, "requires_shipping" => true, "sku" => nil, "taxable" => true, "title" => "Big Brown Bear Boots", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "EUR"}}, "variant_id" => nil, "variant_inventory_management" => nil, "variant_title" => nil, "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "13.50", "price_set" => {"shop_money" => {"amount" => "13.50", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "13.50", "currency_code" => "EUR"}}, "rate" => 0.06, "title" => "State tax"}], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.line_items = [
      {
        "title" => "Big Brown Bear Boots",
        "price" => 74.99,
        "grams" => "1300",
        "quantity" => 3,
        "tax_lines" => [
          {
            "price" => 13.5,
            "rate" => 0.06,
            "title" => "State tax"
          }
        ]
      }
    ]
    order.transactions = [
      {
        "kind" => "sale",
        "status" => "success",
        "amount" => 238.47
      }
    ]
    order.total_tax = 13.5
    order.currency = "EUR"
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_17()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"line_items" => [{"variant_id" => 447654529, "quantity" => 1}], "customer" => {"first_name" => "Paul", "last_name" => "Norman", "email" => "paul.norman@example.com"}, "billing_address" => {"first_name" => "John", "last_name" => "Smith", "address1" => "123 Fake Street", "phone" => "555-555-5555", "city" => "Fakecity", "province" => "Ontario", "country" => "Canada", "zip" => "K2P 1L4"}, "shipping_address" => {"first_name" => "Jane", "last_name" => "Smith", "address1" => "123 Fake Street", "phone" => "777-777-7777", "city" => "Fakecity", "province" => "Ontario", "country" => "Canada", "zip" => "K2P 1L4"}, "email" => "jane@example.com", "transactions" => [{"kind" => "authorization", "status" => "success", "amount" => 50.0}], "financial_status" => "partially_paid"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459968, "admin_graphql_api_id" => "gid://shopify/Order/1073459968", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "H2DZ0CR3A", "confirmed" => true, "contact_email" => "jane@example.com", "created_at" => "2023-10-03T13:18:06-04:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "jane@example.com", "estimated_taxes" => false, "financial_status" => "partially_paid", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/5e91283bcca1476e4c476f74954b6899/authenticate?key=14a0f0f8a589fded0a4bdea38d539c33", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [""], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2023-10-03T13:18:06-04:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "5e91283bcca1476e4c476f74954b6899", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "149.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:06-04:00", "user_id" => nil, "billing_address" => {"first_name" => "John", "address1" => "123 Fake Street", "phone" => "555-555-5555", "city" => "Fakecity", "zip" => "K2P 1L4", "province" => "Ontario", "country" => "Canada", "last_name" => "Smith", "address2" => nil, "company" => nil, "latitude" => nil, "longitude" => nil, "name" => "John Smith", "country_code" => "CA", "province_code" => "ON"}, "customer" => {"id" => 1073339457, "email" => "paul.norman@example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:18:06-04:00", "updated_at" => "2023-10-03T13:18:06-04:00", "first_name" => "John", "last_name" => "Smith", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => nil, "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => nil}, "sms_marketing_consent" => nil, "tags" => "", "currency" => "USD", "accepts_marketing_updated_at" => "2023-10-03T13:18:06-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/1073339457", "default_address" => {"id" => 1053317286, "customer_id" => 1073339457, "first_name" => "Jane", "last_name" => "Smith", "company" => nil, "address1" => "123 Fake Street", "address2" => nil, "city" => "Fakecity", "province" => "Ontario", "country" => "Canada", "zip" => "K2P 1L4", "phone" => "777-777-7777", "name" => "Jane Smith", "province_code" => "ON", "country_code" => "CA", "country_name" => "Canada", "default" => true}}, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823179, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823179", "fulfillable_quantity" => 1, "fulfillment_service" => "shipwire-app", "fulfillment_status" => nil, "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => {"first_name" => "Jane", "address1" => "123 Fake Street", "phone" => "777-777-7777", "city" => "Fakecity", "zip" => "K2P 1L4", "province" => "Ontario", "country" => "Canada", "last_name" => "Smith", "address2" => nil, "company" => nil, "latitude" => nil, "longitude" => nil, "name" => "Jane Smith", "country_code" => "CA", "province_code" => "ON"}, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.line_items = [
      {
        "variant_id" => 447654529,
        "quantity" => 1
      }
    ]
    order.customer = {
      "first_name" => "Paul",
      "last_name" => "Norman",
      "email" => "paul.norman@example.com"
    }
    order.billing_address = {
      "first_name" => "John",
      "last_name" => "Smith",
      "address1" => "123 Fake Street",
      "phone" => "555-555-5555",
      "city" => "Fakecity",
      "province" => "Ontario",
      "country" => "Canada",
      "zip" => "K2P 1L4"
    }
    order.shipping_address = {
      "first_name" => "Jane",
      "last_name" => "Smith",
      "address1" => "123 Fake Street",
      "phone" => "777-777-7777",
      "city" => "Fakecity",
      "province" => "Ontario",
      "country" => "Canada",
      "zip" => "K2P 1L4"
    }
    order.email = "jane@example.com"
    order.transactions = [
      {
        "kind" => "authorization",
        "status" => "success",
        "amount" => 50.0
      }
    ]
    order.financial_status = "partially_paid"
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_18()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"line_items" => [{"variant_id" => 447654529, "quantity" => 1}], "customer" => {"id" => 207119551}, "financial_status" => "pending"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459965, "admin_graphql_api_id" => "gid://shopify/Order/1073459965", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "UMY2WW10T", "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2023-10-03T13:17:50-04:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "pending", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/8f71b7eb6f2cc1b0e194d0c3d2f1beff/authenticate?key=9f74d96121142b3b5cf1b77ef872fe7c", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2023-10-03T13:17:50-04:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "8f71b7eb6f2cc1b0e194d0c3d2f1beff", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "199.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:17:50-04:00", "user_id" => nil, "billing_address" => nil, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:50-04:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-10-03T13:17:01-04:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823176, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823176", "fulfillable_quantity" => 1, "fulfillment_service" => "shipwire-app", "fulfillment_status" => nil, "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.line_items = [
      {
        "variant_id" => 447654529,
        "quantity" => 1
      }
    ]
    order.customer = {
      "id" => 207119551
    }
    order.financial_status = "pending"
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_19()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"email" => "foo@example.com", "fulfillment_status" => "fulfilled", "fulfillments" => [{"location_id" => 24826418}], "line_items" => [{"variant_id" => 447654529, "quantity" => 1}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459970, "admin_graphql_api_id" => "gid://shopify/Order/1073459970", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "WJUZ8F6H0", "confirmed" => true, "contact_email" => "foo@example.com", "created_at" => "2023-10-03T13:18:23-04:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "foo@example.com", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => "fulfilled", "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/ff0ff3c561f846121c82addb0ba6a8cd/authenticate?key=7c5d28ef19f1644c434c76b2ca7f3735", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2023-10-03T13:18:23-04:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "ff0ff3c561f846121c82addb0ba6a8cd", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "199.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:23-04:00", "user_id" => nil, "billing_address" => nil, "customer" => {"id" => 1073339458, "email" => "foo@example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:18:23-04:00", "updated_at" => "2023-10-03T13:18:24-04:00", "first_name" => nil, "last_name" => nil, "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => nil, "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => nil}, "sms_marketing_consent" => nil, "tags" => "", "currency" => "USD", "accepts_marketing_updated_at" => "2023-10-03T13:18:23-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/1073339458"}, "discount_applications" => [], "fulfillments" => [{"id" => 1069019863, "admin_graphql_api_id" => "gid://shopify/Fulfillment/1069019863", "created_at" => "2023-10-03T13:18:24-04:00", "location_id" => 24826418, "name" => "#1002.1", "order_id" => 1073459970, "origin_address" => {}, "receipt" => {}, "service" => "shipwire-app", "shipment_status" => nil, "status" => "success", "tracking_company" => nil, "tracking_number" => nil, "tracking_numbers" => [], "tracking_url" => nil, "tracking_urls" => [], "updated_at" => "2023-10-03T13:18:24-04:00", "line_items" => [{"id" => 1071823181, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823181", "fulfillable_quantity" => 0, "fulfillment_service" => "shipwire-app", "fulfillment_status" => "fulfilled", "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}]}], "line_items" => [{"id" => 1071823181, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823181", "fulfillable_quantity" => 0, "fulfillment_service" => "shipwire-app", "fulfillment_status" => "fulfilled", "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.email = "foo@example.com"
    order.fulfillment_status = "fulfilled"
    order.fulfillments = [
      {
        "location_id" => 24826418
      }
    ]
    order.line_items = [
      {
        "variant_id" => 447654529,
        "quantity" => 1
      }
    ]
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_20()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"line_items" => [{"variant_id" => 447654529, "quantity" => 1}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459971, "admin_graphql_api_id" => "gid://shopify/Order/1073459971", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "ADIP8N15J", "confirmed" => true, "contact_email" => nil, "created_at" => "2023-10-03T13:18:25-04:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/af5793e7f01a4519e51b94f90a72684f/authenticate?key=2e813fd2bd0919571c750cbe57c23045", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2023-10-03T13:18:25-04:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "af5793e7f01a4519e51b94f90a72684f", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "199.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:25-04:00", "user_id" => nil, "billing_address" => nil, "customer" => nil, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823182, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823182", "fulfillable_quantity" => 1, "fulfillment_service" => "shipwire-app", "fulfillment_status" => nil, "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.line_items = [
      {
        "variant_id" => 447654529,
        "quantity" => 1
      }
    ]
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_21()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"email" => "foo@example.com", "fulfillment_status" => "fulfilled", "line_items" => [{"variant_id" => 447654529, "quantity" => 1}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459972, "admin_graphql_api_id" => "gid://shopify/Order/1073459972", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "KPHL5KJ5C", "confirmed" => true, "contact_email" => "foo@example.com", "created_at" => "2023-10-03T13:18:28-04:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "foo@example.com", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => "fulfilled", "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/e82e6ff68a3836cb2691b0159295efdc/authenticate?key=4bb5d0430332646bcbe369b1bf2f666d", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2023-10-03T13:18:28-04:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "e82e6ff68a3836cb2691b0159295efdc", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "199.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:28-04:00", "user_id" => nil, "billing_address" => nil, "customer" => {"id" => 1073339459, "email" => "foo@example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:18:28-04:00", "updated_at" => "2023-10-03T13:18:28-04:00", "first_name" => nil, "last_name" => nil, "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => nil, "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => nil}, "sms_marketing_consent" => nil, "tags" => "", "currency" => "USD", "accepts_marketing_updated_at" => "2023-10-03T13:18:28-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/1073339459"}, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823183, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823183", "fulfillable_quantity" => 0, "fulfillment_service" => "shipwire-app", "fulfillment_status" => nil, "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.email = "foo@example.com"
    order.fulfillment_status = "fulfilled"
    order.line_items = [
      {
        "variant_id" => 447654529,
        "quantity" => 1
      }
    ]
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_22()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"email" => "foo@example.com", "fulfillment_status" => "fulfilled", "send_receipt" => true, "send_fulfillment_receipt" => true, "line_items" => [{"variant_id" => 457924702, "quantity" => 1}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459967, "admin_graphql_api_id" => "gid://shopify/Order/1073459967", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "N58UK290Y", "confirmed" => true, "contact_email" => "foo@example.com", "created_at" => "2023-10-03T13:18:02-04:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "foo@example.com", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => "fulfilled", "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/2ada92cba7a6aea83e7f55896da65fc1/authenticate?key=86b6255115758786760acebd5b1a270c", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2023-10-03T13:18:02-04:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "2ada92cba7a6aea83e7f55896da65fc1", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "199.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:02-04:00", "user_id" => nil, "billing_address" => nil, "customer" => {"id" => 1073339456, "email" => "foo@example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:18:02-04:00", "updated_at" => "2023-10-03T13:18:02-04:00", "first_name" => nil, "last_name" => nil, "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => nil, "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => nil}, "sms_marketing_consent" => nil, "tags" => "", "currency" => "USD", "accepts_marketing_updated_at" => "2023-10-03T13:18:02-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/1073339456"}, "discount_applications" => [], "fulfillments" => [{"id" => 1069019862, "admin_graphql_api_id" => "gid://shopify/Fulfillment/1069019862", "created_at" => "2023-10-03T13:18:02-04:00", "location_id" => 487838322, "name" => "#1002.1", "order_id" => 1073459967, "origin_address" => {}, "receipt" => {}, "service" => "manual", "shipment_status" => nil, "status" => "success", "tracking_company" => nil, "tracking_number" => nil, "tracking_numbers" => [], "tracking_url" => nil, "tracking_urls" => [], "updated_at" => "2023-10-03T13:18:02-04:00", "line_items" => [{"id" => 1071823178, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823178", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => "fulfilled", "gift_card" => false, "grams" => 567, "name" => "IPod Nano - 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}]}], "line_items" => [{"id" => 1071823178, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823178", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => "fulfilled", "gift_card" => false, "grams" => 567, "name" => "IPod Nano - 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.email = "foo@example.com"
    order.fulfillment_status = "fulfilled"
    order.send_receipt = true
    order.send_fulfillment_receipt = true
    order.line_items = [
      {
        "variant_id" => 457924702,
        "quantity" => 1
      }
    ]
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_23()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"line_items" => [{"variant_id" => 447654529, "quantity" => 1}], "email" => "jane@example.com", "phone" => "18885551234", "billing_address" => {"first_name" => "John", "last_name" => "Smith", "address1" => "123 Fake Street", "phone" => "555-555-5555", "city" => "Fakecity", "province" => "Ontario", "country" => "Canada", "zip" => "K2P 1L4"}, "shipping_address" => {"first_name" => "Jane", "last_name" => "Smith", "address1" => "123 Fake Street", "phone" => "777-777-7777", "city" => "Fakecity", "province" => "Ontario", "country" => "Canada", "zip" => "K2P 1L4"}, "transactions" => [{"kind" => "sale", "status" => "success", "amount" => 50.0}], "financial_status" => "paid", "discount_codes" => [{"code" => "FAKE30", "amount" => "9.00", "type" => "percentage"}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459973, "admin_graphql_api_id" => "gid://shopify/Order/1073459973", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "Q9058GJJI", "confirmed" => true, "contact_email" => "jane@example.com", "created_at" => "2023-10-03T13:18:30-04:00", "currency" => "USD", "current_subtotal_price" => "181.09", "current_subtotal_price_set" => {"shop_money" => {"amount" => "181.09", "currency_code" => "USD"}, "presentment_money" => {"amount" => "181.09", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "17.91", "current_total_discounts_set" => {"shop_money" => {"amount" => "17.91", "currency_code" => "USD"}, "presentment_money" => {"amount" => "17.91", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "181.09", "current_total_price_set" => {"shop_money" => {"amount" => "181.09", "currency_code" => "USD"}, "presentment_money" => {"amount" => "181.09", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "FAKE30", "amount" => "17.91", "type" => "percentage"}], "email" => "jane@example.com", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/c831f0b6052eb8f64661c6508f10f496/authenticate?key=eedaaf7010012e473af2105e0ca1db3f", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [""], "phone" => "+18885551234", "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2023-10-03T13:18:30-04:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "181.09", "subtotal_price_set" => {"shop_money" => {"amount" => "181.09", "currency_code" => "USD"}, "presentment_money" => {"amount" => "181.09", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "c831f0b6052eb8f64661c6508f10f496", "total_discounts" => "17.91", "total_discounts_set" => {"shop_money" => {"amount" => "17.91", "currency_code" => "USD"}, "presentment_money" => {"amount" => "17.91", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "131.09", "total_price" => "181.09", "total_price_set" => {"shop_money" => {"amount" => "181.09", "currency_code" => "USD"}, "presentment_money" => {"amount" => "181.09", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:30-04:00", "user_id" => nil, "billing_address" => {"first_name" => "John", "address1" => "123 Fake Street", "phone" => "555-555-5555", "city" => "Fakecity", "zip" => "K2P 1L4", "province" => "Ontario", "country" => "Canada", "last_name" => "Smith", "address2" => nil, "company" => nil, "latitude" => nil, "longitude" => nil, "name" => "John Smith", "country_code" => "CA", "province_code" => "ON"}, "customer" => {"id" => 1073339460, "email" => "jane@example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:18:30-04:00", "updated_at" => "2023-10-03T13:18:30-04:00", "first_name" => "John", "last_name" => "Smith", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => nil, "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => nil}, "sms_marketing_consent" => nil, "tags" => "", "currency" => "USD", "accepts_marketing_updated_at" => "2023-10-03T13:18:30-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/1073339460", "default_address" => {"id" => 1053317288, "customer_id" => 1073339460, "first_name" => "Jane", "last_name" => "Smith", "company" => nil, "address1" => "123 Fake Street", "address2" => nil, "city" => "Fakecity", "province" => "Ontario", "country" => "Canada", "zip" => "K2P 1L4", "phone" => "777-777-7777", "name" => "Jane Smith", "province_code" => "ON", "country_code" => "CA", "country_name" => "Canada", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "manual", "value" => "9.0", "value_type" => "percentage", "allocation_method" => "across", "target_selection" => "all", "title" => "FAKE30", "description" => "FAKE30"}], "fulfillments" => [], "line_items" => [{"id" => 1071823184, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823184", "fulfillable_quantity" => 1, "fulfillment_service" => "shipwire-app", "fulfillment_status" => nil, "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => [{"amount" => "17.91", "amount_set" => {"shop_money" => {"amount" => "17.91", "currency_code" => "USD"}, "presentment_money" => {"amount" => "17.91", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [], "shipping_address" => {"first_name" => "Jane", "address1" => "123 Fake Street", "phone" => "777-777-7777", "city" => "Fakecity", "zip" => "K2P 1L4", "province" => "Ontario", "country" => "Canada", "last_name" => "Smith", "address2" => nil, "company" => nil, "latitude" => nil, "longitude" => nil, "name" => "Jane Smith", "country_code" => "CA", "province_code" => "ON"}, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.line_items = [
      {
        "variant_id" => 447654529,
        "quantity" => 1
      }
    ]
    order.email = "jane@example.com"
    order.phone = "18885551234"
    order.billing_address = {
      "first_name" => "John",
      "last_name" => "Smith",
      "address1" => "123 Fake Street",
      "phone" => "555-555-5555",
      "city" => "Fakecity",
      "province" => "Ontario",
      "country" => "Canada",
      "zip" => "K2P 1L4"
    }
    order.shipping_address = {
      "first_name" => "Jane",
      "last_name" => "Smith",
      "address1" => "123 Fake Street",
      "phone" => "777-777-7777",
      "city" => "Fakecity",
      "province" => "Ontario",
      "country" => "Canada",
      "zip" => "K2P 1L4"
    }
    order.transactions = [
      {
        "kind" => "sale",
        "status" => "success",
        "amount" => 50.0
      }
    ]
    order.financial_status = "paid"
    order.discount_codes = [
      {
        "code" => "FAKE30",
        "amount" => "9.00",
        "type" => "percentage"
      }
    ]
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_24()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"line_items" => [{"title" => "Red Leather Coat", "price" => 129.99, "grams" => "1700", "quantity" => 1}, {"title" => "Blue Suede Shoes", "price" => 85.95, "grams" => "750", "quantity" => 1, "taxable" => false}, {"title" => "Raspberry Beret", "price" => 19.99, "grams" => "320", "quantity" => 2}], "tax_lines" => [{"price" => 10.2, "rate" => 0.06, "title" => "State tax"}, {"price" => 4.25, "rate" => 0.025, "title" => "County tax"}], "total_tax" => 14.45}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459963, "admin_graphql_api_id" => "gid://shopify/Order/1073459963", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "VZ7UWHUTK", "confirmed" => true, "contact_email" => nil, "created_at" => "2023-10-03T13:17:41-04:00", "currency" => "USD", "current_subtotal_price" => "255.92", "current_subtotal_price_set" => {"shop_money" => {"amount" => "255.92", "currency_code" => "USD"}, "presentment_money" => {"amount" => "255.92", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "270.37", "current_total_price_set" => {"shop_money" => {"amount" => "270.37", "currency_code" => "USD"}, "presentment_money" => {"amount" => "270.37", "currency_code" => "USD"}}, "current_total_tax" => "14.45", "current_total_tax_set" => {"shop_money" => {"amount" => "14.45", "currency_code" => "USD"}, "presentment_money" => {"amount" => "14.45", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/98536c1a131b52b906a7421538ce1e21/authenticate?key=d839e4909b43854dad2d14a276bbd0d7", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2023-10-03T13:17:41-04:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "255.92", "subtotal_price_set" => {"shop_money" => {"amount" => "255.92", "currency_code" => "USD"}, "presentment_money" => {"amount" => "255.92", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "10.20", "rate" => 0.06, "title" => "State tax", "price_set" => {"shop_money" => {"amount" => "10.20", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.20", "currency_code" => "USD"}}, "channel_liable" => nil}, {"price" => "4.25", "rate" => 0.025, "title" => "County tax", "price_set" => {"shop_money" => {"amount" => "4.25", "currency_code" => "USD"}, "presentment_money" => {"amount" => "4.25", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "98536c1a131b52b906a7421538ce1e21", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "255.92", "total_line_items_price_set" => {"shop_money" => {"amount" => "255.92", "currency_code" => "USD"}, "presentment_money" => {"amount" => "255.92", "currency_code" => "USD"}}, "total_outstanding" => "270.37", "total_price" => "270.37", "total_price_set" => {"shop_money" => {"amount" => "270.37", "currency_code" => "USD"}, "presentment_money" => {"amount" => "270.37", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "14.45", "total_tax_set" => {"shop_money" => {"amount" => "14.45", "currency_code" => "USD"}, "presentment_money" => {"amount" => "14.45", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:17:41-04:00", "user_id" => nil, "billing_address" => nil, "customer" => nil, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823172, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823172", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 1700, "name" => "Red Leather Coat", "price" => "129.99", "price_set" => {"shop_money" => {"amount" => "129.99", "currency_code" => "USD"}, "presentment_money" => {"amount" => "129.99", "currency_code" => "USD"}}, "product_exists" => false, "product_id" => nil, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => nil, "taxable" => true, "title" => "Red Leather Coat", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => nil, "variant_inventory_management" => nil, "variant_title" => nil, "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "7.81", "price_set" => {"shop_money" => {"amount" => "7.81", "currency_code" => "USD"}, "presentment_money" => {"amount" => "7.81", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State tax"}, {"channel_liable" => nil, "price" => "3.26", "price_set" => {"shop_money" => {"amount" => "3.26", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.26", "currency_code" => "USD"}}, "rate" => 0.025, "title" => "County tax"}], "duties" => [], "discount_allocations" => []}, {"id" => 1071823173, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823173", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 750, "name" => "Blue Suede Shoes", "price" => "85.95", "price_set" => {"shop_money" => {"amount" => "85.95", "currency_code" => "USD"}, "presentment_money" => {"amount" => "85.95", "currency_code" => "USD"}}, "product_exists" => false, "product_id" => nil, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => nil, "taxable" => false, "title" => "Blue Suede Shoes", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => nil, "variant_inventory_management" => nil, "variant_title" => nil, "vendor" => nil, "tax_lines" => [], "duties" => [], "discount_allocations" => []}, {"id" => 1071823174, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823174", "fulfillable_quantity" => 2, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 320, "name" => "Raspberry Beret", "price" => "19.99", "price_set" => {"shop_money" => {"amount" => "19.99", "currency_code" => "USD"}, "presentment_money" => {"amount" => "19.99", "currency_code" => "USD"}}, "product_exists" => false, "product_id" => nil, "properties" => [], "quantity" => 2, "requires_shipping" => true, "sku" => nil, "taxable" => true, "title" => "Raspberry Beret", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => nil, "variant_inventory_management" => nil, "variant_title" => nil, "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "2.39", "price_set" => {"shop_money" => {"amount" => "2.39", "currency_code" => "USD"}, "presentment_money" => {"amount" => "2.39", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State tax"}, {"channel_liable" => nil, "price" => "0.99", "price_set" => {"shop_money" => {"amount" => "0.99", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.99", "currency_code" => "USD"}}, "rate" => 0.025, "title" => "County tax"}], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.line_items = [
      {
        "title" => "Red Leather Coat",
        "price" => 129.99,
        "grams" => "1700",
        "quantity" => 1
      },
      {
        "title" => "Blue Suede Shoes",
        "price" => 85.95,
        "grams" => "750",
        "quantity" => 1,
        "taxable" => false
      },
      {
        "title" => "Raspberry Beret",
        "price" => 19.99,
        "grams" => "320",
        "quantity" => 2
      }
    ]
    order.tax_lines = [
      {
        "price" => 10.2,
        "rate" => 0.06,
        "title" => "State tax"
      },
      {
        "price" => 4.25,
        "rate" => 0.025,
        "title" => "County tax"
      }
    ]
    order.total_tax = 14.45
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2022-10/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_25()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"metafields" => [{"key" => "new", "value" => "newvalue", "type" => "single_line_text_field", "namespace" => "global"}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "gateway" => "authorize_net", "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "processing_method" => "direct", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_price_usd" => "598.94", "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:17:49-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "last_order_name" => "#1001", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_details" => {"credit_card_bin" => nil, "avs_result_code" => nil, "cvv_result_code" => nil, "credit_card_number" => "\u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 4242", "credit_card_company" => "Visa", "buyer_action_info" => nil}, "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "delivery_category" => nil, "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.metafields = [
      {
        "key" => "new",
        "value" => "newvalue",
        "type" => "single_line_text_field",
        "namespace" => "global"
      }
    ]
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_26()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"note" => "Customer contacted us about a custom engraving on this iPod"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "gateway" => "authorize_net", "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "name" => "#1001", "note" => "Customer contacted us about a custom engraving on this iPod", "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "processing_method" => "direct", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_price_usd" => "598.94", "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:32-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "last_order_name" => "#1001", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_details" => {"credit_card_bin" => nil, "avs_result_code" => nil, "cvv_result_code" => nil, "credit_card_number" => "\u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 4242", "credit_card_company" => "Visa", "buyer_action_info" => nil}, "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "delivery_category" => nil, "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.note = "Customer contacted us about a custom engraving on this iPod"
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_27()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"note_attributes" => [{"name" => "colour", "value" => "red"}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "gateway" => "authorize_net", "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "colour", "value" => "red"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "processing_method" => "direct", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_price_usd" => "598.94", "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:17:38-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "last_order_name" => "#1001", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_details" => {"credit_card_bin" => nil, "avs_result_code" => nil, "cvv_result_code" => nil, "credit_card_number" => "\u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 4242", "credit_card_company" => "Visa", "buyer_action_info" => nil}, "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "delivery_category" => nil, "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.note_attributes = [
      {
        "name" => "colour",
        "value" => "red"
      }
    ]
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_28()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"email" => "a-different@email.com"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmed" => true, "contact_email" => "a-different@email.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "a-different@email.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "gateway" => "authorize_net", "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "processing_method" => "direct", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_price_usd" => "598.94", "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:11-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "last_order_name" => "#1001", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_details" => {"credit_card_bin" => nil, "avs_result_code" => nil, "cvv_result_code" => nil, "credit_card_number" => "\u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 4242", "credit_card_company" => "Visa", "buyer_action_info" => nil}, "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "delivery_category" => nil, "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.email = "a-different@email.com"
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_29()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"phone" => "+15145556677"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "gateway" => "authorize_net", "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+15145556677", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "processing_method" => "direct", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_price_usd" => "598.94", "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:17:40-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "last_order_name" => "#1001", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_details" => {"credit_card_bin" => nil, "avs_result_code" => nil, "cvv_result_code" => nil, "credit_card_number" => "\u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 4242", "credit_card_company" => "Visa", "buyer_action_info" => nil}, "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "delivery_category" => nil, "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.phone = "+15145556677"
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_30()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"buyer_accepts_marketing" => true}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => true, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "gateway" => "authorize_net", "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "processing_method" => "direct", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_price_usd" => "598.94", "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:29-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "last_order_name" => "#1001", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_details" => {"credit_card_bin" => nil, "avs_result_code" => nil, "cvv_result_code" => nil, "credit_card_number" => "\u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 4242", "credit_card_company" => "Visa", "buyer_action_info" => nil}, "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "delivery_category" => nil, "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.buyer_accepts_marketing = true
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_31()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"customer" => nil}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "gateway" => "authorize_net", "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "processing_method" => "direct", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_price_usd" => "598.94", "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:17:57-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_details" => {"credit_card_bin" => nil, "avs_result_code" => nil, "cvv_result_code" => nil, "credit_card_number" => "\u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 4242", "credit_card_company" => "Visa", "buyer_action_info" => nil}, "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "delivery_category" => nil, "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.customer = nil
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_32()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"tags" => "External, Inbound, Outbound"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "gateway" => "authorize_net", "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "processing_method" => "direct", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "External, Inbound, Outbound", "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_price_usd" => "598.94", "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:18:22-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "last_order_name" => "#1001", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_details" => {"credit_card_bin" => nil, "avs_result_code" => nil, "cvv_result_code" => nil, "credit_card_number" => "\u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 4242", "credit_card_company" => "Visa", "buyer_action_info" => nil}, "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "delivery_category" => nil, "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.tags = "External, Inbound, Outbound"
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_33()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"shipping_address" => {"address1" => "123 Ship Street", "city" => "Shipsville"}}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "gateway" => "authorize_net", "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "processing_method" => "direct", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_price_usd" => "598.94", "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2023-10-03T13:17:58-04:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-10-03T13:17:01-04:00", "updated_at" => "2023-10-03T13:17:01-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "last_order_name" => "#1001", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => nil, "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2023-10-03T13:17:01-04:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2023-10-03T13:17:01-04:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_details" => {"credit_card_bin" => nil, "avs_result_code" => nil, "cvv_result_code" => nil, "credit_card_number" => "\u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 \u2022\u2022\u2022\u2022 4242", "credit_card_company" => "Visa", "buyer_action_info" => nil}, "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2023-10-03T13:17:01-04:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2023-10-03T13:17:01-04:00", "restock" => true, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "123 Ship Street", "phone" => "+1(502)-459-2181", "city" => "Shipsville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "delivery_category" => nil, "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.shipping_address = {
      "address1" => "123 Ship Street",
      "city" => "Shipsville"
    }
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_34()
    stub_request(:delete, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({}), headers: {})

    response = ShopifyAPI::Order.delete(
      id: 450789469,
    )

    assert_requested(:delete, "https://test-shop.myshopify.io/admin/api/2022-10/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

end
