# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `fakefs` gem.
# Please instead update this file by running `bin/tapioca gem fakefs`.

module FakeFS
  class << self
    def activate!; end
    def activated?; end
    def clear!; end
    def deactivate!; end
    def with; end
    def with_fresh(&block); end
    def without; end
  end
end

class FakeFS::Dir
  include ::Enumerable

  def initialize(string); end

  def close; end
  def each; end
  def ino; end
  def path; end
  def pos; end
  def pos=(integer); end
  def read; end
  def rewind; end
  def seek(integer); end

  private

  def entry_to_relative_path(entry); end

  class << self
    def [](*pattern); end
    def _check_for_valid_file(path); end
    def chdir(dir, &blk); end
    def children(dirname, _options = T.unsafe(nil)); end
    def chroot(_string); end
    def delete(string); end
    def each_child(dirname, &_block); end
    def empty?(dirname); end
    def entries(dirname, _options = T.unsafe(nil)); end
    def exist?(path); end
    def exists?(path); end
    def foreach(dirname, &_block); end
    def getwd; end
    def glob(pattern, _flags = T.unsafe(nil), flags: T.unsafe(nil), base: T.unsafe(nil), &block); end
    def home(user = T.unsafe(nil)); end
    def mkdir(string, _integer = T.unsafe(nil)); end
    def mktmpdir(prefix_suffix = T.unsafe(nil), tmpdir = T.unsafe(nil)); end
    def open(string, &_block); end
    def pwd; end
    def rmdir(string); end
    def tmpdir; end
    def unlink(string); end
  end
end

module FakeFS::Dir::Tmpname
  private

  def create(basename, *rest); end
  def make_tmpname(prefix_suffix, suffix); end
  def tmpdir; end

  class << self
    def create(basename, *rest); end
    def make_tmpname(prefix_suffix, suffix); end
    def tmpdir; end
  end
end

class FakeFS::FakeDir
  def initialize(name = T.unsafe(nil), parent = T.unsafe(nil)); end

  def [](name); end
  def []=(name, value); end
  def atime; end
  def atime=(_arg0); end
  def clone(parent = T.unsafe(nil)); end
  def content; end
  def ctime; end
  def delete(node = T.unsafe(nil)); end
  def empty?; end
  def entries; end
  def entry; end
  def gid; end
  def gid=(_arg0); end
  def inode; end
  def inode=(_arg0); end
  def inspect; end
  def matches(pattern); end
  def mode; end
  def mode=(_arg0); end
  def mtime; end
  def mtime=(_arg0); end
  def name; end
  def name=(_arg0); end
  def parent; end
  def parent=(_arg0); end
  def to_s; end
  def uid; end
  def uid=(_arg0); end
end

class FakeFS::FakeFile
  def initialize(name = T.unsafe(nil), parent = T.unsafe(nil)); end

  def atime; end
  def atime=(_arg0); end
  def birthtime; end
  def clone(parent = T.unsafe(nil)); end
  def content; end
  def content=(str); end
  def ctime; end
  def delete; end
  def entry; end
  def gid; end
  def gid=(_arg0); end
  def inode; end
  def inode=(_arg0); end
  def inspect; end
  def link(other_file); end
  def links; end
  def mode; end
  def mode=(_arg0); end
  def mtime; end
  def mtime=(_arg0); end
  def name; end
  def name=(_arg0); end
  def parent; end
  def parent=(_arg0); end
  def to_s; end
  def uid; end
  def uid=(_arg0); end
end

class FakeFS::FakeInode
  def initialize(file_owner); end

  def assign_inode_num; end
  def clone; end
  def content; end
  def content=(_arg0); end
  def free_inode_num; end
  def inode_num; end
  def inode_num=(_arg0); end
  def link(file); end
  def links; end
  def links=(_arg0); end
  def unlink(file); end

  class << self
    def clear_inode_info_for_tests; end
    def freed_inodes; end
    def freed_inodes=(_arg0); end
    def next_inode_num; end
    def next_inode_num=(_arg0); end
  end
end

class FakeFS::FakeSymlink
  def initialize(target); end

  def delete; end
  def entry; end
  def inspect; end
  def name; end
  def name=(_arg0); end
  def parent; end
  def parent=(_arg0); end
  def target; end
  def target=(_arg0); end
  def to_s; end

  private

  def method_missing(*args, &block); end
  def respond_to_missing?(method, include_private = T.unsafe(nil)); end
end

class FakeFS::File < ::StringIO
  def initialize(path, mode = T.unsafe(nil), _perm = T.unsafe(nil)); end

  def advise(_advice, _offset = T.unsafe(nil), _len = T.unsafe(nil)); end
  def atime; end
  def autoclose; end
  def autoclose=(_arg0); end
  def autoclose?; end
  def binmode?; end
  def birthtime; end
  def chmod(new_mode); end
  def chown(owner_int, group_int); end
  def close_on_exec=(_bool); end
  def close_on_exec?; end
  def ctime; end
  def exists?; end
  def fdatasync; end
  def flock(*_arg0); end
  def ioctl(*_arg0); end
  def is_a?(klass); end
  def lstat; end
  def mtime; end
  def path; end
  def read(length = T.unsafe(nil), buf = T.unsafe(nil)); end
  def read_nonblock; end
  def readpartial(*_arg0); end
  def size; end
  def stat; end
  def string; end
  def sysread(*_arg0); end
  def sysseek(position, whence = T.unsafe(nil)); end
  def syswrite(*args); end
  def tell=(_arg0); end
  def to_i; end
  def to_io; end
  def to_path; end
  def write(*args); end
  def write_nonblock(*_arg0); end

  private

  def binary_mode?; end
  def check_file_existence!; end
  def check_modes!; end
  def create_missing_file; end
  def file_creation_mode?; end
  def mode_in?(list); end
  def mode_in_bitmask?(mask); end

  class << self
    def absolute_path(file_name, dir_name = T.unsafe(nil)); end
    def atime(path); end
    def basename(*args); end
    def binread(file, length = T.unsafe(nil), offset = T.unsafe(nil)); end
    def birthtime(path); end
    def chmod(new_mode, filename); end
    def chown(owner_int, group_int, filename); end
    def const_missing(name); end
    def ctime(path); end
    def delete(*files); end
    def directory?(path); end
    def dirname(path); end
    def empty?(path); end
    def executable?(filename); end
    def exist?(path); end
    def exists?(path); end
    def expand_path(file_name, dir_string = T.unsafe(nil)); end
    def extname(path); end
    def file?(path); end
    def fnmatch(pattern, path, flags = T.unsafe(nil)); end
    def fnmatch?(pattern, path, flags = T.unsafe(nil)); end
    def foreach(path, *args, &block); end
    def ftype(filename); end
    def identical?(one_path, another_path); end
    def join(*parts); end
    def link(source, dest); end
    def lstat(file); end
    def mtime(path); end
    def path(file); end
    def read(path, *args); end
    def readable?(path); end
    def readlines(path, chomp: T.unsafe(nil)); end
    def readlink(path); end
    def realdirpath(*args); end
    def realpath(*args); end
    def rename(source, dest); end
    def size(path); end
    def size?(path); end
    def split(path); end
    def stat(file); end
    def sticky?(_path); end
    def symlink(source, dest); end
    def symlink?(path); end
    def umask(*args); end
    def unlink(*files); end
    def utime(atime, mtime, *paths); end
    def writable?(path); end
    def write(filename, contents, offset = T.unsafe(nil), open_args = T.unsafe(nil)); end
    def zero?(path); end

    private

    def calculate_chmod_amt_for_mode(modes); end
    def convert_symbolic_chmod_to_absolute(new_mode, current_mode); end
    def get_perms_for_group(current_file_mode, group_num); end
    def set_perms_for_group(current_groups_to_vals, group_num, assignment_mode, chmod_perm_num); end
  end
end

FakeFS::File::APPEND_READ_WRITE = T.let(T.unsafe(nil), String)
FakeFS::File::APPEND_WRITE_ONLY = T.let(T.unsafe(nil), String)
FakeFS::File::FILE_CREATION_BITMASK = T.let(T.unsafe(nil), Integer)
FakeFS::File::FILE_CREATION_MODES = T.let(T.unsafe(nil), Array)
FakeFS::File::MODES = T.let(T.unsafe(nil), Array)
FakeFS::File::MODE_BITMASK = T.let(T.unsafe(nil), Integer)
FakeFS::File::READ_ONLY = T.let(T.unsafe(nil), String)
FakeFS::File::READ_WRITE = T.let(T.unsafe(nil), String)
FakeFS::File::READ_WRITE_TRUNCATE = T.let(T.unsafe(nil), String)

class FakeFS::File::Stat
  include ::Comparable

  def initialize(file, lstat = T.unsafe(nil)); end

  def <=>(other); end
  def atime; end
  def birthtime; end
  def ctime; end
  def directory?; end
  def file?; end
  def ftype; end
  def gid; end
  def ino; end
  def mode; end
  def mtime; end
  def nlink; end
  def readable?; end
  def size; end
  def sticky?; end
  def symlink?; end
  def uid; end
  def world_readable?; end
  def world_writable?; end
  def writable?; end
  def zero?; end

  private

  def check_if_bit_set(bit); end
end

FakeFS::File::WRITE_ONLY = T.let(T.unsafe(nil), String)

module FakeFS::FileSystem
  extend ::FakeFS::FileSystem

  def add(path, object = T.unsafe(nil)); end
  def chdir(dir, &blk); end
  def clear; end
  def clone(path, target = T.unsafe(nil)); end
  def current_dir; end
  def delete(path); end
  def dir_levels; end
  def files; end
  def find(path, find_flags = T.unsafe(nil), gave_char_class = T.unsafe(nil), dir: T.unsafe(nil)); end
  def fs; end
  def normalize_path(path, dir: T.unsafe(nil)); end
  def path_parts(path); end

  private

  def assert_dir(dir); end
  def directories_under(dir); end
  def find_recurser(dir, parts, find_flags = T.unsafe(nil), gave_char_class = T.unsafe(nil)); end
end

module FakeFS::FileTest
  extend ::FakeFS::FileTest

  def directory?(file_name); end
  def executable?(file_name); end
  def exist?(file_name); end
  def file?(file_name); end
  def readable?(file_name); end
  def size?(file_name); end
  def sticky?(file_name); end
  def symlink?(file_name); end
  def world_readable?(file_name); end
  def world_writable?(file_name); end
  def writable?(file_name); end
  def zero?(file_name); end

  class << self
    def empty?(file_name); end
  end
end

module FakeFS::FileUtils
  extend ::FakeFS::FileUtils

  def cd(dir, &block); end
  def chdir(dir, &block); end
  def chmod(mode, list, _options = T.unsafe(nil)); end
  def chmod_R(mode, list, _options = T.unsafe(nil)); end
  def chown(user, group, list, _options = T.unsafe(nil)); end
  def chown_R(user, group, list, _options = T.unsafe(nil)); end
  def cmp(file1, file2); end
  def compare_file(file1, file2); end
  def copy(src, dest, options = T.unsafe(nil)); end
  def copy_entry(src, dest, preserve = T.unsafe(nil), dereference_root = T.unsafe(nil), remove_destination = T.unsafe(nil)); end
  def copy_file(src, dest, _preserve = T.unsafe(nil), _dereference = T.unsafe(nil)); end
  def cp(src, dest, options = T.unsafe(nil)); end
  def cp_r(src, dest, options = T.unsafe(nil)); end
  def identical?(file1, file2); end
  def ln_s(target, path, options = T.unsafe(nil)); end
  def ln_sf(target, path); end
  def makedirs(list, options = T.unsafe(nil)); end
  def mkdir(list, _ignored_options = T.unsafe(nil)); end
  def mkdir_p(list, options = T.unsafe(nil)); end
  def mkpath(list, options = T.unsafe(nil)); end
  def move(src, dest, options = T.unsafe(nil)); end
  def mv(src, dest, options = T.unsafe(nil)); end
  def remove(list, options = T.unsafe(nil)); end
  def remove_entry_secure(path, force = T.unsafe(nil)); end
  def rm(list, options = T.unsafe(nil)); end
  def rm_f(list, options = T.unsafe(nil)); end
  def rm_r(list, options = T.unsafe(nil)); end
  def rm_rf(list, options = T.unsafe(nil)); end
  def rmdir(list, _options = T.unsafe(nil)); end
  def rmtree(list, options = T.unsafe(nil)); end
  def safe_unlink(list, options = T.unsafe(nil)); end
  def symlink(target, path, options = T.unsafe(nil)); end
  def touch(list, options = T.unsafe(nil)); end
  def uptodate?(new, old_list); end
end

module FakeFS::Globber
  extend ::FakeFS::Globber

  def expand(pattern); end
  def path_components(pattern); end
  def regexp(pattern, find_flags = T.unsafe(nil), gave_char_class = T.unsafe(nil)); end

  private

  def drop_root(path_parts); end
  def each_char_with_levels(string, level_start, level_end); end
end

module FakeFS::Kernel
  class << self
    def captives; end
    def captives=(_arg0); end
    def hijack(name, &block); end
    def hijack!; end
    def unhijack!; end
  end
end

class FakeFS::Pathname
  def initialize(path); end

  def +(other); end
  def /(other); end
  def <=>(other); end
  def ==(other); end
  def ===(other); end
  def absolute?; end
  def ascend; end
  def atime; end
  def basename(*args); end
  def binread(*args); end
  def blockdev?; end
  def chardev?; end
  def children(with_directory = T.unsafe(nil)); end
  def chmod(mode); end
  def chown(owner, group); end
  def cleanpath(consider_symlink = T.unsafe(nil)); end
  def ctime; end
  def delete; end
  def descend; end
  def directory?; end
  def dirname; end
  def each_child(with_directory = T.unsafe(nil), &block); end
  def each_entry(*_arg0); end
  def each_filename; end
  def each_line(*args, &block); end
  def empty?; end
  def entries; end
  def eql?(other); end
  def executable?; end
  def executable_real?; end
  def exist?; end
  def expand_path(*args); end
  def extname; end
  def file?; end
  def find(*_arg0); end
  def fnmatch(pattern, *args); end
  def fnmatch?(pattern, *args); end
  def freeze; end
  def ftype; end
  def glob(pattern, flags = T.unsafe(nil)); end
  def grpowned?; end
  def hash; end
  def inspect; end
  def join(*args); end
  def lchmod(mode); end
  def lchown(owner, group); end
  def lstat; end
  def make_link(old); end
  def make_symlink(old); end
  def mkdir(*args); end
  def mkpath; end
  def mountpoint?; end
  def mtime; end
  def open(*args, &block); end
  def opendir(&block); end
  def owned?; end
  def parent; end
  def pipe?; end
  def read(*args); end
  def readable?; end
  def readable_real?; end
  def readlines(*args); end
  def readlink; end
  def realdirpath(basedir = T.unsafe(nil)); end
  def realpath(basedir = T.unsafe(nil)); end
  def relative?; end
  def relative_path_from(base_directory); end
  def rename(to); end
  def rmdir; end
  def rmtree; end
  def root?; end
  def setgid?; end
  def setuid?; end
  def size; end
  def size?; end
  def socket?; end
  def split; end
  def stat; end
  def sticky?; end
  def sub(pattern, *rest, &block); end
  def sub_ext(repl); end
  def symlink?; end
  def sysopen(*_args); end
  def to_path; end
  def to_s; end
  def truncate(length); end
  def unlink; end
  def utime(atime, mtime); end
  def world_readable?; end
  def world_writable?; end
  def writable?; end
  def writable_real?; end
  def write(string, *args); end
  def zero?; end

  private

  def add_trailing_separator(path); end
  def chop_basename(path); end
  def cleanpath_aggressive; end
  def cleanpath_conservative; end
  def del_trailing_separator(path); end
  def plus(path1, path2); end
  def prepend_prefix(prefix, relpath); end
  def split_names(path); end
  def trailing_separator?(path); end

  class << self
    def getwd; end
    def glob(*args, **opts); end
    def pwd; end
  end
end

FakeFS::Pathname::SAME_PATHS = T.let(T.unsafe(nil), Proc)
FakeFS::Pathname::SEPARATOR_LIST = T.let(T.unsafe(nil), String)
FakeFS::Pathname::SEPARATOR_PAT = T.let(T.unsafe(nil), Regexp)
FakeFS::Pathname::TO_PATH = T.let(T.unsafe(nil), Symbol)
RealDir = Dir
RealFile = File
RealFileTest = FileTest
RealFileUtils = FileUtils
RealPathname = Pathname
