# typed: strict
# frozen_string_literal: true

########################################################################################################################
# This file is auto-generated. If you have an issue, please create a GitHub issue.                                     #
########################################################################################################################

$VERBOSE = nil
$LOAD_PATH.unshift(File.join(File.dirname(__FILE__), "..", "lib"))

require "minitest/autorun"
require "webmock/minitest"

require "shopify_api"
require_relative "../../test_helper"

class Order202404Test < Test::Unit::TestCase
  def setup
    super

    test_session = ShopifyAPI::Auth::Session.new(id: "id", shop: "test-shop.myshopify.io", access_token: "this_is_a_test_token")
    ShopifyAPI::Context.activate_session(test_session)
    modify_context(api_version: "2024-04")
  end

  def teardown
    super

    ShopifyAPI::Context.deactivate_session
  end

  sig do
    void
  end
  def test_1()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json?status=any")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"orders" => [{"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2008-01-10T11:00:00-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}]}), headers: {})

    response = ShopifyAPI::Order.all(
      status: "any",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json?status=any")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_2()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json?since_id=123")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"orders" => [{"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2008-01-10T11:00:00-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}]}), headers: {})

    response = ShopifyAPI::Order.all(
      since_id: "123",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json?since_id=123")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_3()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json?fields=created_at%2Cid%2Cname%2Ctotal-price")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"orders" => [{"id" => 450789469, "created_at" => "2008-01-10T11:00:00-05:00", "name" => "#1001", "total_price" => "598.94"}]}), headers: {})

    response = ShopifyAPI::Order.all(
      fields: "created_at,id,name,total-price",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json?fields=created_at%2Cid%2Cname%2Ctotal-price")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_4()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json?updated_at_min=2005-07-31T15%3A57%3A11-04%3A00")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"orders" => [{"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2008-01-10T11:00:00-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}]}), headers: {})

    response = ShopifyAPI::Order.all(
      updated_at_min: "2005-07-31T15:57:11-04:00",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json?updated_at_min=2005-07-31T15%3A57%3A11-04%3A00")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_5()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json?financial_status=authorized")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"orders" => [{"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "authorized", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:19-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}]}), headers: {})

    response = ShopifyAPI::Order.all(
      financial_status: "authorized",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json?financial_status=authorized")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_6()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json?ids=1073459972")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"orders" => [{"id" => 1073459972, "admin_graphql_api_id" => "gid://shopify/Order/1073459972", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "MFWM2CZK8", "confirmed" => true, "contact_email" => nil, "created_at" => "2024-04-02T09:04:18-05:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/e6148b4dbdcddf58fe50af960b4aef46/authenticate?key=b0bc2568cd9e91f913293c7d4e703f1d", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2024-04-02T09:04:18-05:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "e6148b4dbdcddf58fe50af960b4aef46", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "199.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:18-05:00", "user_id" => nil, "billing_address" => nil, "customer" => nil, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823202, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823202", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "shipwire-app", "fulfillment_status" => nil, "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}]}), headers: {})

    response = ShopifyAPI::Order.all(
      ids: "1073459972",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json?ids=1073459972")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_7()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json?fields=id%2Cline_items%2Cname%2Ctotal_price")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "name" => "#1001", "total_price" => "598.94", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}}), headers: {})

    response = ShopifyAPI::Order.find(
      id: 450789469,
      fields: "id,line_items,name,total_price",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json?fields=id%2Cline_items%2Cname%2Ctotal_price")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_8()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2008-01-10T11:00:00-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = ShopifyAPI::Order.find(
      id: 450789469,
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_9()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders/count.json?status=any")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"count" => 1}), headers: {})

    response = ShopifyAPI::Order.count(
      status: "any",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders/count.json?status=any")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_10()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders/count.json?financial_status=authorized")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"count" => 1}), headers: {})

    response = ShopifyAPI::Order.count(
      financial_status: "authorized",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2024-04/orders/count.json?financial_status=authorized")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_11()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469/close.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => "2024-04-02T09:04:41-05:00", "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:41-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.close

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469/close.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_12()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469/open.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:03:49-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.open

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469/open.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_13()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469/cancel.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2008-01-10T11:00:00-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}, "notice" => "Order has been canceled"}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.cancel

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469/cancel.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_14()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469/cancel.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: hash_including({"amount" => "10.00", "currency" => "USD"})
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "587.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "587.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "587.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "10.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "598.94", "current_total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "current_total_tax" => "11.94", "current_total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "598.94", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:02-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 929361469, "admin_graphql_api_id" => "gid://shopify/Refund/929361469", "created_at" => "2024-04-02T09:04:02-05:00", "note" => "Order canceled", "order_id" => 450789469, "processed_at" => "2024-04-02T09:04:02-05:00", "restock" => false, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => nil, "order_adjustments" => [], "transactions" => [{"id" => 1068278498, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/1068278498", "amount" => "10.00", "authorization" => nil, "created_at" => "2024-04-02T09:04:02-05:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => "Bogus Gateway: Forced success", "order_id" => 450789469, "parent_id" => 1068278497, "payment_id" => "c901414060.3", "processed_at" => "2024-04-02T09:04:02-05:00", "receipt" => {}, "source_name" => "755357713", "status" => "success", "test" => true, "user_id" => nil}], "refund_line_items" => [{"id" => 1058498313, "line_item_id" => 466157049, "location_id" => nil, "quantity" => 1, "restock_type" => "no_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 1058498314, "line_item_id" => 518995019, "location_id" => nil, "quantity" => 1, "restock_type" => "no_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 1058498315, "line_item_id" => 703073504, "location_id" => nil, "quantity" => 1, "restock_type" => "no_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}, "notice" => "Order has been canceled"}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.cancel(
      body: {"amount" => "10.00", "currency" => "USD"},
    )

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469/cancel.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_15()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469/cancel.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: hash_including({"refund" => {"note" => "Customer made a mistake", "shipping" => {"full_refund" => true}, "refund_line_items" => [{"line_item_id" => 466157049, "quantity" => 1, "restock_type" => "cancel", "location_id" => 24826418}], "transactions" => [{"parent_id" => 1068278486, "amount" => "10.00", "kind" => "refund", "gateway" => "bogus"}, {"parent_id" => 1068278487, "amount" => "100.00", "kind" => "refund", "gateway" => "gift_card"}]}})
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "587.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "587.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "587.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "10.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "598.94", "current_total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "current_total_tax" => "11.94", "current_total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus", "gift_card"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "598.94", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:03:37-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 929361468, "admin_graphql_api_id" => "gid://shopify/Refund/929361468", "created_at" => "2024-04-02T09:03:37-05:00", "note" => "Order canceled", "order_id" => 450789469, "processed_at" => "2024-04-02T09:03:37-05:00", "restock" => false, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => nil, "order_adjustments" => [{"id" => 1030976843, "amount" => "89.64", "amount_set" => {"shop_money" => {"amount" => "89.64", "currency_code" => "USD"}, "presentment_money" => {"amount" => "89.64", "currency_code" => "USD"}}, "kind" => "refund_discrepancy", "order_id" => 450789469, "reason" => "Refund discrepancy", "refund_id" => 929361468, "tax_amount" => "0.00", "tax_amount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}}], "transactions" => [{"id" => 1068278488, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/1068278488", "amount" => "10.00", "authorization" => nil, "created_at" => "2024-04-02T09:03:37-05:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => "Bogus Gateway: Forced success", "order_id" => 450789469, "parent_id" => 1068278486, "payment_id" => "c901414060.4", "processed_at" => "2024-04-02T09:03:37-05:00", "receipt" => {}, "source_name" => "755357713", "status" => "success", "test" => true, "user_id" => nil}, {"id" => 1068278489, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/1068278489", "amount" => "100.00", "authorization" => nil, "created_at" => "2024-04-02T09:03:37-05:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "gift_card", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 1068278487, "payment_id" => "c901414060.5", "processed_at" => "2024-04-02T09:03:37-05:00", "receipt" => {"gift_card_id" => 1035197676, "gift_card_last_characters" => "0d0d"}, "source_name" => "755357713", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 1058498312, "line_item_id" => 466157049, "location_id" => nil, "quantity" => 1, "restock_type" => "no_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}, "notice" => "Order has been canceled"}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.cancel(
      body: {"refund" => {"note" => "Customer made a mistake", "shipping" => {"full_refund" => true}, "refund_line_items" => [{"line_item_id" => 466157049, "quantity" => 1, "restock_type" => "cancel", "location_id" => 24826418}], "transactions" => [{"parent_id" => 1068278486, "amount" => "10.00", "kind" => "refund", "gateway" => "bogus"}, {"parent_id" => 1068278487, "amount" => "100.00", "kind" => "refund", "gateway" => "gift_card"}]}},
    )

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469/cancel.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_16()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"line_items" => [{"title" => "Big Brown Bear Boots", "price" => 74.99, "grams" => "1300", "quantity" => 3, "tax_lines" => [{"price" => 13.5, "rate" => 0.06, "title" => "State tax"}]}], "transactions" => [{"kind" => "sale", "status" => "success", "amount" => 238.47}], "total_tax" => 13.5, "currency" => "EUR"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459975, "admin_graphql_api_id" => "gid://shopify/Order/1073459975", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "0ZW4V9P7W", "confirmed" => true, "contact_email" => nil, "created_at" => "2024-04-02T09:04:31-05:00", "currency" => "EUR", "current_subtotal_price" => "224.97", "current_subtotal_price_set" => {"shop_money" => {"amount" => "224.97", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "224.97", "currency_code" => "EUR"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "EUR"}}, "current_total_duties_set" => nil, "current_total_price" => "238.47", "current_total_price_set" => {"shop_money" => {"amount" => "238.47", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "238.47", "currency_code" => "EUR"}}, "current_total_tax" => "13.50", "current_total_tax_set" => {"shop_money" => {"amount" => "13.50", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "13.50", "currency_code" => "EUR"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/dd4ddd56c817e612ca849e17672417ec/authenticate?key=327b7aa85e06b1de824125bcc1421d0d", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [""], "phone" => nil, "po_number" => nil, "presentment_currency" => "EUR", "processed_at" => "2024-04-02T09:04:31-05:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "224.97", "subtotal_price_set" => {"shop_money" => {"amount" => "224.97", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "224.97", "currency_code" => "EUR"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "13.50", "rate" => 0.06, "title" => "State tax", "price_set" => {"shop_money" => {"amount" => "13.50", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "13.50", "currency_code" => "EUR"}}, "channel_liable" => false}], "taxes_included" => false, "test" => false, "token" => "dd4ddd56c817e612ca849e17672417ec", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "EUR"}}, "total_line_items_price" => "224.97", "total_line_items_price_set" => {"shop_money" => {"amount" => "224.97", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "224.97", "currency_code" => "EUR"}}, "total_outstanding" => "0.00", "total_price" => "238.47", "total_price_set" => {"shop_money" => {"amount" => "238.47", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "238.47", "currency_code" => "EUR"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "EUR"}}, "total_tax" => "13.50", "total_tax_set" => {"shop_money" => {"amount" => "13.50", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "13.50", "currency_code" => "EUR"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:31-05:00", "user_id" => nil, "billing_address" => nil, "customer" => nil, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823207, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823207", "current_quantity" => 3, "fulfillable_quantity" => 3, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 1300, "name" => "Big Brown Bear Boots", "price" => "74.99", "price_set" => {"shop_money" => {"amount" => "74.99", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "74.99", "currency_code" => "EUR"}}, "product_exists" => false, "product_id" => nil, "properties" => [], "quantity" => 3, "requires_shipping" => true, "sku" => nil, "taxable" => true, "title" => "Big Brown Bear Boots", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "EUR"}}, "variant_id" => nil, "variant_inventory_management" => nil, "variant_title" => nil, "vendor" => nil, "tax_lines" => [{"channel_liable" => false, "price" => "13.50", "price_set" => {"shop_money" => {"amount" => "13.50", "currency_code" => "EUR"}, "presentment_money" => {"amount" => "13.50", "currency_code" => "EUR"}}, "rate" => 0.06, "title" => "State tax"}], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.line_items = [
      {
        "title" => "Big Brown Bear Boots",
        "price" => 74.99,
        "grams" => "1300",
        "quantity" => 3,
        "tax_lines" => [
          {
            "price" => 13.5,
            "rate" => 0.06,
            "title" => "State tax"
          }
        ]
      }
    ]
    order.transactions = [
      {
        "kind" => "sale",
        "status" => "success",
        "amount" => 238.47
      }
    ]
    order.total_tax = 13.5
    order.currency = "EUR"
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_17()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"line_items" => [{"variant_id" => 447654529, "quantity" => 1}], "customer" => {"first_name" => "Paul", "last_name" => "Norman", "email" => "paul.norman@example.com"}, "billing_address" => {"first_name" => "John", "last_name" => "Smith", "address1" => "123 Fake Street", "phone" => "555-555-5555", "city" => "Fakecity", "province" => "Ontario", "country" => "Canada", "zip" => "K2P 1L4"}, "shipping_address" => {"first_name" => "Jane", "last_name" => "Smith", "address1" => "123 Fake Street", "phone" => "777-777-7777", "city" => "Fakecity", "province" => "Ontario", "country" => "Canada", "zip" => "K2P 1L4"}, "email" => "jane@example.com", "transactions" => [{"kind" => "authorization", "status" => "success", "amount" => 50.0}], "financial_status" => "partially_paid"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459969, "admin_graphql_api_id" => "gid://shopify/Order/1073459969", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "X7855I5Z8", "confirmed" => true, "contact_email" => "jane@example.com", "created_at" => "2024-04-02T09:04:00-05:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "jane@example.com", "estimated_taxes" => false, "financial_status" => "partially_paid", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/1410b8d45683e2f551d863ce38cfa228/authenticate?key=8b5fda62dfd116d1dca9837ff81e5175", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [""], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2024-04-02T09:04:00-05:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "1410b8d45683e2f551d863ce38cfa228", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "149.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:00-05:00", "user_id" => nil, "billing_address" => {"first_name" => "John", "address1" => "123 Fake Street", "phone" => "555-555-5555", "city" => "Fakecity", "zip" => "K2P 1L4", "province" => "Ontario", "country" => "Canada", "last_name" => "Smith", "address2" => nil, "company" => nil, "latitude" => nil, "longitude" => nil, "name" => "John Smith", "country_code" => "CA", "province_code" => "ON"}, "customer" => {"id" => 1073339463, "email" => "paul.norman@example.com", "created_at" => "2024-04-02T09:04:00-05:00", "updated_at" => "2024-04-02T09:04:00-05:00", "first_name" => "John", "last_name" => "Smith", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => nil, "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => nil}, "sms_marketing_consent" => nil, "tags" => "", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/1073339463", "default_address" => {"id" => 1053317293, "customer_id" => 1073339463, "first_name" => "Jane", "last_name" => "Smith", "company" => nil, "address1" => "123 Fake Street", "address2" => nil, "city" => "Fakecity", "province" => "Ontario", "country" => "Canada", "zip" => "K2P 1L4", "phone" => "777-777-7777", "name" => "Jane Smith", "province_code" => "ON", "country_code" => "CA", "country_name" => "Canada", "default" => true}}, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823199, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823199", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "shipwire-app", "fulfillment_status" => nil, "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => {"first_name" => "Jane", "address1" => "123 Fake Street", "phone" => "777-777-7777", "city" => "Fakecity", "zip" => "K2P 1L4", "province" => "Ontario", "country" => "Canada", "last_name" => "Smith", "address2" => nil, "company" => nil, "latitude" => nil, "longitude" => nil, "name" => "Jane Smith", "country_code" => "CA", "province_code" => "ON"}, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.line_items = [
      {
        "variant_id" => 447654529,
        "quantity" => 1
      }
    ]
    order.customer = {
      "first_name" => "Paul",
      "last_name" => "Norman",
      "email" => "paul.norman@example.com"
    }
    order.billing_address = {
      "first_name" => "John",
      "last_name" => "Smith",
      "address1" => "123 Fake Street",
      "phone" => "555-555-5555",
      "city" => "Fakecity",
      "province" => "Ontario",
      "country" => "Canada",
      "zip" => "K2P 1L4"
    }
    order.shipping_address = {
      "first_name" => "Jane",
      "last_name" => "Smith",
      "address1" => "123 Fake Street",
      "phone" => "777-777-7777",
      "city" => "Fakecity",
      "province" => "Ontario",
      "country" => "Canada",
      "zip" => "K2P 1L4"
    }
    order.email = "jane@example.com"
    order.transactions = [
      {
        "kind" => "authorization",
        "status" => "success",
        "amount" => 50.0
      }
    ]
    order.financial_status = "partially_paid"
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_18()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"line_items" => [{"variant_id" => 447654529, "quantity" => 1}], "customer" => {"id" => 207119551}, "financial_status" => "pending"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459974, "admin_graphql_api_id" => "gid://shopify/Order/1073459974", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "R1TIJIQDF", "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T09:04:27-05:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "pending", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/67087edca78728ca07684bc4a2210e57/authenticate?key=fab624a3f8689b5bf506c7063fee13ee", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2024-04-02T09:04:27-05:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "67087edca78728ca07684bc4a2210e57", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "199.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:27-05:00", "user_id" => nil, "billing_address" => nil, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T09:04:27-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823206, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823206", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "shipwire-app", "fulfillment_status" => nil, "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.line_items = [
      {
        "variant_id" => 447654529,
        "quantity" => 1
      }
    ]
    order.customer = {
      "id" => 207119551
    }
    order.financial_status = "pending"
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_19()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"email" => "foo@example.com", "fulfillment_status" => "fulfilled", "fulfillments" => [{"location_id" => 24826418}], "line_items" => [{"variant_id" => 447654529, "quantity" => 1}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459965, "admin_graphql_api_id" => "gid://shopify/Order/1073459965", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "THCEIXRIL", "confirmed" => true, "contact_email" => "foo@example.com", "created_at" => "2024-04-02T09:03:44-05:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "foo@example.com", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => "fulfilled", "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/1f5645d22cb8e63a7d960147d70766c7/authenticate?key=41badde26dbc157bf732139c55c22c33", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2024-04-02T09:03:44-05:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "1f5645d22cb8e63a7d960147d70766c7", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "199.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:03:44-05:00", "user_id" => nil, "billing_address" => nil, "customer" => {"id" => 1073339460, "email" => "foo@example.com", "created_at" => "2024-04-02T09:03:44-05:00", "updated_at" => "2024-04-02T09:03:45-05:00", "first_name" => nil, "last_name" => nil, "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => nil, "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => nil}, "sms_marketing_consent" => nil, "tags" => "", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/1073339460"}, "discount_applications" => [], "fulfillments" => [{"id" => 1069019890, "admin_graphql_api_id" => "gid://shopify/Fulfillment/1069019890", "created_at" => "2024-04-02T09:03:44-05:00", "location_id" => 24826418, "name" => "#1002.1", "order_id" => 1073459965, "origin_address" => {}, "receipt" => {}, "service" => "shipwire-app", "shipment_status" => nil, "status" => "success", "tracking_company" => nil, "tracking_number" => nil, "tracking_numbers" => [], "tracking_url" => nil, "tracking_urls" => [], "updated_at" => "2024-04-02T09:03:44-05:00", "line_items" => [{"id" => 1071823195, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823195", "current_quantity" => 1, "fulfillable_quantity" => 0, "fulfillment_service" => "shipwire-app", "fulfillment_status" => "fulfilled", "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}]}], "line_items" => [{"id" => 1071823195, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823195", "current_quantity" => 1, "fulfillable_quantity" => 0, "fulfillment_service" => "shipwire-app", "fulfillment_status" => "fulfilled", "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.email = "foo@example.com"
    order.fulfillment_status = "fulfilled"
    order.fulfillments = [
      {
        "location_id" => 24826418
      }
    ]
    order.line_items = [
      {
        "variant_id" => 447654529,
        "quantity" => 1
      }
    ]
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_20()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"line_items" => [{"variant_id" => 447654529, "quantity" => 1}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459984, "admin_graphql_api_id" => "gid://shopify/Order/1073459984", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "YQKT8VFVE", "confirmed" => true, "contact_email" => nil, "created_at" => "2024-04-02T09:04:55-05:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/dd72f73e4b3adafc686efb63314bcc47/authenticate?key=f36a4ef195e4d2ba262760e912f81b62", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2024-04-02T09:04:55-05:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "dd72f73e4b3adafc686efb63314bcc47", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "199.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:55-05:00", "user_id" => nil, "billing_address" => nil, "customer" => nil, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823214, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823214", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "shipwire-app", "fulfillment_status" => nil, "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.line_items = [
      {
        "variant_id" => 447654529,
        "quantity" => 1
      }
    ]
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_21()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"email" => "foo@example.com", "fulfillment_status" => "fulfilled", "line_items" => [{"variant_id" => 447654529, "quantity" => 1}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459964, "admin_graphql_api_id" => "gid://shopify/Order/1073459964", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "JNUA8GGE7", "confirmed" => true, "contact_email" => "foo@example.com", "created_at" => "2024-04-02T09:03:41-05:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "foo@example.com", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => "fulfilled", "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/7065e08289ab835723267728a976ecc7/authenticate?key=5beab51ad4cc281e7cc47ba519c71aa9", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2024-04-02T09:03:41-05:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "7065e08289ab835723267728a976ecc7", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "199.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:03:41-05:00", "user_id" => nil, "billing_address" => nil, "customer" => {"id" => 1073339459, "email" => "foo@example.com", "created_at" => "2024-04-02T09:03:41-05:00", "updated_at" => "2024-04-02T09:03:41-05:00", "first_name" => nil, "last_name" => nil, "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => nil, "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => nil}, "sms_marketing_consent" => nil, "tags" => "", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/1073339459"}, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823194, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823194", "current_quantity" => 1, "fulfillable_quantity" => 0, "fulfillment_service" => "shipwire-app", "fulfillment_status" => nil, "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.email = "foo@example.com"
    order.fulfillment_status = "fulfilled"
    order.line_items = [
      {
        "variant_id" => 447654529,
        "quantity" => 1
      }
    ]
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_22()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"email" => "foo@example.com", "fulfillment_status" => "fulfilled", "send_receipt" => true, "send_fulfillment_receipt" => true, "line_items" => [{"variant_id" => 457924702, "quantity" => 1}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459978, "admin_graphql_api_id" => "gid://shopify/Order/1073459978", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "CX8G0E4H7", "confirmed" => true, "contact_email" => "foo@example.com", "created_at" => "2024-04-02T09:04:38-05:00", "currency" => "USD", "current_subtotal_price" => "199.00", "current_subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.00", "current_total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "foo@example.com", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => "fulfilled", "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/0094cb3cab56374f0e187d9286cec300/authenticate?key=797bf39cee2c897036ad3202b2862bc9", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2024-04-02T09:04:38-05:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "199.00", "subtotal_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "0094cb3cab56374f0e187d9286cec300", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "199.00", "total_price" => "199.00", "total_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:38-05:00", "user_id" => nil, "billing_address" => nil, "customer" => {"id" => 1073339465, "email" => "foo@example.com", "created_at" => "2024-04-02T09:04:38-05:00", "updated_at" => "2024-04-02T09:04:38-05:00", "first_name" => nil, "last_name" => nil, "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => nil, "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => nil}, "sms_marketing_consent" => nil, "tags" => "", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/1073339465"}, "discount_applications" => [], "fulfillments" => [{"id" => 1069019892, "admin_graphql_api_id" => "gid://shopify/Fulfillment/1069019892", "created_at" => "2024-04-02T09:04:38-05:00", "location_id" => 487838322, "name" => "#1002.1", "order_id" => 1073459978, "origin_address" => {}, "receipt" => {}, "service" => "manual", "shipment_status" => nil, "status" => "success", "tracking_company" => nil, "tracking_number" => nil, "tracking_numbers" => [], "tracking_url" => nil, "tracking_urls" => [], "updated_at" => "2024-04-02T09:04:38-05:00", "line_items" => [{"id" => 1071823209, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823209", "current_quantity" => 1, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => "fulfilled", "gift_card" => false, "grams" => 567, "name" => "IPod Nano - 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}]}], "line_items" => [{"id" => 1071823209, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823209", "current_quantity" => 1, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => "fulfilled", "gift_card" => false, "grams" => 567, "name" => "IPod Nano - 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.email = "foo@example.com"
    order.fulfillment_status = "fulfilled"
    order.send_receipt = true
    order.send_fulfillment_receipt = true
    order.line_items = [
      {
        "variant_id" => 457924702,
        "quantity" => 1
      }
    ]
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_23()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"line_items" => [{"variant_id" => 447654529, "quantity" => 1}], "email" => "jane@example.com", "phone" => "18885551234", "billing_address" => {"first_name" => "John", "last_name" => "Smith", "address1" => "123 Fake Street", "phone" => "555-555-5555", "city" => "Fakecity", "province" => "Ontario", "country" => "Canada", "zip" => "K2P 1L4"}, "shipping_address" => {"first_name" => "Jane", "last_name" => "Smith", "address1" => "123 Fake Street", "phone" => "777-777-7777", "city" => "Fakecity", "province" => "Ontario", "country" => "Canada", "zip" => "K2P 1L4"}, "transactions" => [{"kind" => "sale", "status" => "success", "amount" => 50.0}], "financial_status" => "paid", "discount_codes" => [{"code" => "FAKE30", "amount" => "9.00", "type" => "percentage"}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459981, "admin_graphql_api_id" => "gid://shopify/Order/1073459981", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "82C04VDXX", "confirmed" => true, "contact_email" => "jane@example.com", "created_at" => "2024-04-02T09:04:43-05:00", "currency" => "USD", "current_subtotal_price" => "181.09", "current_subtotal_price_set" => {"shop_money" => {"amount" => "181.09", "currency_code" => "USD"}, "presentment_money" => {"amount" => "181.09", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "17.91", "current_total_discounts_set" => {"shop_money" => {"amount" => "17.91", "currency_code" => "USD"}, "presentment_money" => {"amount" => "17.91", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "181.09", "current_total_price_set" => {"shop_money" => {"amount" => "181.09", "currency_code" => "USD"}, "presentment_money" => {"amount" => "181.09", "currency_code" => "USD"}}, "current_total_tax" => "0.00", "current_total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "FAKE30", "amount" => "17.91", "type" => "percentage"}], "email" => "jane@example.com", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/9fd15e7c469e1906e365f0589e5a02d9/authenticate?key=26f47355e74d44c6e49c3854c2dc7be0", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [""], "phone" => "+18885551234", "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2024-04-02T09:04:43-05:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "181.09", "subtotal_price_set" => {"shop_money" => {"amount" => "181.09", "currency_code" => "USD"}, "presentment_money" => {"amount" => "181.09", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [], "taxes_included" => false, "test" => false, "token" => "9fd15e7c469e1906e365f0589e5a02d9", "total_discounts" => "17.91", "total_discounts_set" => {"shop_money" => {"amount" => "17.91", "currency_code" => "USD"}, "presentment_money" => {"amount" => "17.91", "currency_code" => "USD"}}, "total_line_items_price" => "199.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "total_outstanding" => "131.09", "total_price" => "181.09", "total_price_set" => {"shop_money" => {"amount" => "181.09", "currency_code" => "USD"}, "presentment_money" => {"amount" => "181.09", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "0.00", "total_tax_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:43-05:00", "user_id" => nil, "billing_address" => {"first_name" => "John", "address1" => "123 Fake Street", "phone" => "555-555-5555", "city" => "Fakecity", "zip" => "K2P 1L4", "province" => "Ontario", "country" => "Canada", "last_name" => "Smith", "address2" => nil, "company" => nil, "latitude" => nil, "longitude" => nil, "name" => "John Smith", "country_code" => "CA", "province_code" => "ON"}, "customer" => {"id" => 1073339467, "email" => "jane@example.com", "created_at" => "2024-04-02T09:04:43-05:00", "updated_at" => "2024-04-02T09:04:43-05:00", "first_name" => "John", "last_name" => "Smith", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => nil, "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => nil}, "sms_marketing_consent" => nil, "tags" => "", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/1073339467", "default_address" => {"id" => 1053317297, "customer_id" => 1073339467, "first_name" => "Jane", "last_name" => "Smith", "company" => nil, "address1" => "123 Fake Street", "address2" => nil, "city" => "Fakecity", "province" => "Ontario", "country" => "Canada", "zip" => "K2P 1L4", "phone" => "777-777-7777", "name" => "Jane Smith", "province_code" => "ON", "country_code" => "CA", "country_name" => "Canada", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "manual", "value" => "9.0", "value_type" => "percentage", "allocation_method" => "across", "target_selection" => "all", "title" => "FAKE30", "description" => "FAKE30"}], "fulfillments" => [], "line_items" => [{"id" => 1071823212, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823212", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "shipwire-app", "fulfillment_status" => nil, "gift_card" => false, "grams" => 567, "name" => "IPod Touch 8GB - Black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 921728736, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2009BLACK", "taxable" => true, "title" => "IPod Touch 8GB", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 447654529, "variant_inventory_management" => "shipwire-app", "variant_title" => "Black", "vendor" => "Apple", "tax_lines" => [], "duties" => [], "discount_allocations" => [{"amount" => "17.91", "amount_set" => {"shop_money" => {"amount" => "17.91", "currency_code" => "USD"}, "presentment_money" => {"amount" => "17.91", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [], "shipping_address" => {"first_name" => "Jane", "address1" => "123 Fake Street", "phone" => "777-777-7777", "city" => "Fakecity", "zip" => "K2P 1L4", "province" => "Ontario", "country" => "Canada", "last_name" => "Smith", "address2" => nil, "company" => nil, "latitude" => nil, "longitude" => nil, "name" => "Jane Smith", "country_code" => "CA", "province_code" => "ON"}, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.line_items = [
      {
        "variant_id" => 447654529,
        "quantity" => 1
      }
    ]
    order.email = "jane@example.com"
    order.phone = "18885551234"
    order.billing_address = {
      "first_name" => "John",
      "last_name" => "Smith",
      "address1" => "123 Fake Street",
      "phone" => "555-555-5555",
      "city" => "Fakecity",
      "province" => "Ontario",
      "country" => "Canada",
      "zip" => "K2P 1L4"
    }
    order.shipping_address = {
      "first_name" => "Jane",
      "last_name" => "Smith",
      "address1" => "123 Fake Street",
      "phone" => "777-777-7777",
      "city" => "Fakecity",
      "province" => "Ontario",
      "country" => "Canada",
      "zip" => "K2P 1L4"
    }
    order.transactions = [
      {
        "kind" => "sale",
        "status" => "success",
        "amount" => 50.0
      }
    ]
    order.financial_status = "paid"
    order.discount_codes = [
      {
        "code" => "FAKE30",
        "amount" => "9.00",
        "type" => "percentage"
      }
    ]
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_24()
    stub_request(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"line_items" => [{"title" => "Red Leather Coat", "price" => 129.99, "grams" => "1700", "quantity" => 1}, {"title" => "Blue Suede Shoes", "price" => 85.95, "grams" => "750", "quantity" => 1, "taxable" => false}, {"title" => "Raspberry Beret", "price" => 19.99, "grams" => "320", "quantity" => 2}], "tax_lines" => [{"price" => 10.2, "rate" => 0.06, "title" => "State tax"}, {"price" => 4.25, "rate" => 0.025, "title" => "County tax"}], "total_tax" => 14.45}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 1073459962, "admin_graphql_api_id" => "gid://shopify/Order/1073459962", "app_id" => 755357713, "browser_ip" => nil, "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => nil, "checkout_id" => nil, "checkout_token" => nil, "client_details" => nil, "closed_at" => nil, "confirmation_number" => "WRJK6R1YK", "confirmed" => true, "contact_email" => nil, "created_at" => "2024-04-02T09:03:29-05:00", "currency" => "USD", "current_subtotal_price" => "255.92", "current_subtotal_price_set" => {"shop_money" => {"amount" => "255.92", "currency_code" => "USD"}, "presentment_money" => {"amount" => "255.92", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "0.00", "current_total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "270.37", "current_total_price_set" => {"shop_money" => {"amount" => "270.37", "currency_code" => "USD"}, "presentment_money" => {"amount" => "270.37", "currency_code" => "USD"}}, "current_total_tax" => "14.45", "current_total_tax_set" => {"shop_money" => {"amount" => "14.45", "currency_code" => "USD"}, "presentment_money" => {"amount" => "14.45", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [], "email" => "", "estimated_taxes" => false, "financial_status" => "paid", "fulfillment_status" => nil, "landing_site" => nil, "landing_site_ref" => nil, "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1002", "note" => nil, "note_attributes" => [], "number" => 2, "order_number" => 1002, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/068b09bb4f214d81f02b7debbf3b8071/authenticate?key=0f49ccebf2dfc5652e1cbc1a95efcd64", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => [], "phone" => nil, "po_number" => nil, "presentment_currency" => "USD", "processed_at" => "2024-04-02T09:03:29-05:00", "reference" => nil, "referring_site" => nil, "source_identifier" => nil, "source_name" => "755357713", "source_url" => nil, "subtotal_price" => "255.92", "subtotal_price_set" => {"shop_money" => {"amount" => "255.92", "currency_code" => "USD"}, "presentment_money" => {"amount" => "255.92", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "10.20", "rate" => 0.06, "title" => "State tax", "price_set" => {"shop_money" => {"amount" => "10.20", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.20", "currency_code" => "USD"}}, "channel_liable" => false}, {"price" => "4.25", "rate" => 0.025, "title" => "County tax", "price_set" => {"shop_money" => {"amount" => "4.25", "currency_code" => "USD"}, "presentment_money" => {"amount" => "4.25", "currency_code" => "USD"}}, "channel_liable" => false}], "taxes_included" => false, "test" => false, "token" => "068b09bb4f214d81f02b7debbf3b8071", "total_discounts" => "0.00", "total_discounts_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_line_items_price" => "255.92", "total_line_items_price_set" => {"shop_money" => {"amount" => "255.92", "currency_code" => "USD"}, "presentment_money" => {"amount" => "255.92", "currency_code" => "USD"}}, "total_outstanding" => "270.37", "total_price" => "270.37", "total_price_set" => {"shop_money" => {"amount" => "270.37", "currency_code" => "USD"}, "presentment_money" => {"amount" => "270.37", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "14.45", "total_tax_set" => {"shop_money" => {"amount" => "14.45", "currency_code" => "USD"}, "presentment_money" => {"amount" => "14.45", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:03:29-05:00", "user_id" => nil, "billing_address" => nil, "customer" => nil, "discount_applications" => [], "fulfillments" => [], "line_items" => [{"id" => 1071823190, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823190", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 1700, "name" => "Red Leather Coat", "price" => "129.99", "price_set" => {"shop_money" => {"amount" => "129.99", "currency_code" => "USD"}, "presentment_money" => {"amount" => "129.99", "currency_code" => "USD"}}, "product_exists" => false, "product_id" => nil, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => nil, "taxable" => true, "title" => "Red Leather Coat", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => nil, "variant_inventory_management" => nil, "variant_title" => nil, "vendor" => nil, "tax_lines" => [{"channel_liable" => false, "price" => "7.81", "price_set" => {"shop_money" => {"amount" => "7.81", "currency_code" => "USD"}, "presentment_money" => {"amount" => "7.81", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State tax"}, {"channel_liable" => false, "price" => "3.26", "price_set" => {"shop_money" => {"amount" => "3.26", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.26", "currency_code" => "USD"}}, "rate" => 0.025, "title" => "County tax"}], "duties" => [], "discount_allocations" => []}, {"id" => 1071823191, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823191", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 750, "name" => "Blue Suede Shoes", "price" => "85.95", "price_set" => {"shop_money" => {"amount" => "85.95", "currency_code" => "USD"}, "presentment_money" => {"amount" => "85.95", "currency_code" => "USD"}}, "product_exists" => false, "product_id" => nil, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => nil, "taxable" => false, "title" => "Blue Suede Shoes", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => nil, "variant_inventory_management" => nil, "variant_title" => nil, "vendor" => nil, "tax_lines" => [], "duties" => [], "discount_allocations" => []}, {"id" => 1071823192, "admin_graphql_api_id" => "gid://shopify/LineItem/1071823192", "current_quantity" => 2, "fulfillable_quantity" => 2, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 320, "name" => "Raspberry Beret", "price" => "19.99", "price_set" => {"shop_money" => {"amount" => "19.99", "currency_code" => "USD"}, "presentment_money" => {"amount" => "19.99", "currency_code" => "USD"}}, "product_exists" => false, "product_id" => nil, "properties" => [], "quantity" => 2, "requires_shipping" => true, "sku" => nil, "taxable" => true, "title" => "Raspberry Beret", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => nil, "variant_inventory_management" => nil, "variant_title" => nil, "vendor" => nil, "tax_lines" => [{"channel_liable" => false, "price" => "2.39", "price_set" => {"shop_money" => {"amount" => "2.39", "currency_code" => "USD"}, "presentment_money" => {"amount" => "2.39", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State tax"}, {"channel_liable" => false, "price" => "0.99", "price_set" => {"shop_money" => {"amount" => "0.99", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.99", "currency_code" => "USD"}}, "rate" => 0.025, "title" => "County tax"}], "duties" => [], "discount_allocations" => []}], "payment_terms" => nil, "refunds" => [], "shipping_address" => nil, "shipping_lines" => []}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.line_items = [
      {
        "title" => "Red Leather Coat",
        "price" => 129.99,
        "grams" => "1700",
        "quantity" => 1
      },
      {
        "title" => "Blue Suede Shoes",
        "price" => 85.95,
        "grams" => "750",
        "quantity" => 1,
        "taxable" => false
      },
      {
        "title" => "Raspberry Beret",
        "price" => 19.99,
        "grams" => "320",
        "quantity" => 2
      }
    ]
    order.tax_lines = [
      {
        "price" => 10.2,
        "rate" => 0.06,
        "title" => "State tax"
      },
      {
        "price" => 4.25,
        "rate" => 0.025,
        "title" => "County tax"
      }
    ]
    order.total_tax = 14.45
    order.save

    assert_requested(:post, "https://test-shop.myshopify.io/admin/api/2024-04/orders.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_25()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"metafields" => [{"key" => "new", "value" => "newvalue", "type" => "single_line_text_field", "namespace" => "global"}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:03:40-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.metafields = [
      {
        "key" => "new",
        "value" => "newvalue",
        "type" => "single_line_text_field",
        "namespace" => "global"
      }
    ]
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_26()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"note" => "Customer contacted us about a custom engraving on this iPod"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => "Customer contacted us about a custom engraving on this iPod", "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:03:39-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.note = "Customer contacted us about a custom engraving on this iPod"
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_27()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"note_attributes" => [{"name" => "colour", "value" => "red"}]}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "colour", "value" => "red"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:03:51-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.note_attributes = [
      {
        "name" => "colour",
        "value" => "red"
      }
    ]
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_28()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"email" => "a-different@email.com"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "a-different@email.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "a-different@email.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:45-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.email = "a-different@email.com"
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_29()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"phone" => "+15145556677"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+15145556677", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:03:59-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.phone = "+15145556677"
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_30()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"buyer_accepts_marketing" => true}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => true, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:36-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.buyer_accepts_marketing = true
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_31()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"customer" => nil}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:25-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => nil, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.customer = nil
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_32()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"tags" => "External, Inbound, Outbound"}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "External, Inbound, Outbound", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:04:54-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.tags = "External, Inbound, Outbound"
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_33()
    stub_request(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json", "Content-Type"=>"application/json"},
        body: { "order" => hash_including({"shipping_address" => {"address1" => "123 Ship Street", "city" => "Shipsville"}}) }
      )
      .to_return(status: 200, body: JSON.generate({"order" => {"id" => 450789469, "admin_graphql_api_id" => "gid://shopify/Order/450789469", "app_id" => nil, "browser_ip" => "0.0.0.0", "buyer_accepts_marketing" => false, "cancel_reason" => nil, "cancelled_at" => nil, "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "checkout_id" => 901414060, "checkout_token" => "bd5a8aa1ecd019dd3520ff791ee3a24c", "client_details" => {"accept_language" => nil, "browser_height" => nil, "browser_ip" => "0.0.0.0", "browser_width" => nil, "session_hash" => nil, "user_agent" => nil}, "closed_at" => nil, "confirmation_number" => nil, "confirmed" => true, "contact_email" => "bob.norman@mail.example.com", "created_at" => "2008-01-10T11:00:00-05:00", "currency" => "USD", "current_subtotal_price" => "195.67", "current_subtotal_price_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "current_total_additional_fees_set" => nil, "current_total_discounts" => "3.33", "current_total_discounts_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "current_total_duties_set" => nil, "current_total_price" => "199.65", "current_total_price_set" => {"shop_money" => {"amount" => "199.65", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.65", "currency_code" => "USD"}}, "current_total_tax" => "3.98", "current_total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "customer_locale" => nil, "device_id" => nil, "discount_codes" => [{"code" => "TENOFF", "amount" => "10.00", "type" => "fixed_amount"}], "email" => "bob.norman@mail.example.com", "estimated_taxes" => false, "financial_status" => "partially_refunded", "fulfillment_status" => nil, "landing_site" => "http://www.example.com?source=abc", "landing_site_ref" => "abc", "location_id" => nil, "merchant_of_record_app_id" => nil, "name" => "#1001", "note" => nil, "note_attributes" => [{"name" => "custom engraving", "value" => "Happy Birthday"}, {"name" => "colour", "value" => "green"}], "number" => 1, "order_number" => 1001, "order_status_url" => "https://jsmith.myshopify.com/548380009/orders/b1946ac92492d2347c6235b4d2611184/authenticate?key=imasecretipod", "original_total_additional_fees_set" => nil, "original_total_duties_set" => nil, "payment_gateway_names" => ["bogus"], "phone" => "+557734881234", "po_number" => "ABC123", "presentment_currency" => "USD", "processed_at" => "2008-01-10T11:00:00-05:00", "reference" => "fhwdgads", "referring_site" => "http://www.otherexample.com", "source_identifier" => "fhwdgads", "source_name" => "web", "source_url" => nil, "subtotal_price" => "597.00", "subtotal_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "tags" => "", "tax_exempt" => false, "tax_lines" => [{"price" => "11.94", "rate" => 0.06, "title" => "State Tax", "price_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "channel_liable" => nil}], "taxes_included" => false, "test" => false, "token" => "b1946ac92492d2347c6235b4d2611184", "total_discounts" => "10.00", "total_discounts_set" => {"shop_money" => {"amount" => "10.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "10.00", "currency_code" => "USD"}}, "total_line_items_price" => "597.00", "total_line_items_price_set" => {"shop_money" => {"amount" => "597.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "597.00", "currency_code" => "USD"}}, "total_outstanding" => "0.00", "total_price" => "598.94", "total_price_set" => {"shop_money" => {"amount" => "598.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "598.94", "currency_code" => "USD"}}, "total_shipping_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_tax" => "11.94", "total_tax_set" => {"shop_money" => {"amount" => "11.94", "currency_code" => "USD"}, "presentment_money" => {"amount" => "11.94", "currency_code" => "USD"}}, "total_tip_received" => "0.00", "total_weight" => 0, "updated_at" => "2024-04-02T09:03:53-05:00", "user_id" => nil, "billing_address" => {"first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "customer" => {"id" => 207119551, "email" => "bob.norman@mail.example.com", "created_at" => "2024-04-02T08:59:11-05:00", "updated_at" => "2024-04-02T08:59:11-05:00", "first_name" => "Bob", "last_name" => "Norman", "state" => "disabled", "note" => nil, "verified_email" => true, "multipass_identifier" => nil, "tax_exempt" => false, "phone" => "+16136120707", "email_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => nil, "consent_updated_at" => "2004-06-13T11:57:11-04:00"}, "sms_marketing_consent" => {"state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2024-04-02T08:59:11-05:00", "consent_collected_from" => "OTHER"}, "tags" => "L\u00E9on, No\u00EBl", "currency" => "USD", "tax_exemptions" => [], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => {"id" => 207119551, "customer_id" => 207119551, "first_name" => nil, "last_name" => nil, "company" => nil, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true}}, "discount_applications" => [{"target_type" => "line_item", "type" => "discount_code", "value" => "10.0", "value_type" => "fixed_amount", "allocation_method" => "across", "target_selection" => "all", "code" => "TENOFF"}], "fulfillments" => [{"id" => 255858046, "admin_graphql_api_id" => "gid://shopify/Fulfillment/255858046", "created_at" => "2024-04-02T08:59:11-05:00", "location_id" => 655441491, "name" => "#1001.0", "order_id" => 450789469, "origin_address" => {}, "receipt" => {"testcase" => true, "authorization" => "123456"}, "service" => "manual", "shipment_status" => nil, "status" => "failure", "tracking_company" => "USPS", "tracking_number" => "1Z2345", "tracking_numbers" => ["1Z2345"], "tracking_url" => "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345", "tracking_urls" => ["https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=1Z2345"], "updated_at" => "2024-04-02T08:59:11-05:00", "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}]}], "line_items" => [{"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 518995019, "admin_graphql_api_id" => "gid://shopify/LineItem/518995019", "current_quantity" => 1, "fulfillable_quantity" => 1, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - red", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 49148385, "variant_inventory_management" => "shopify", "variant_title" => "red", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}, {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}], "payment_terms" => nil, "refunds" => [{"id" => 509562969, "admin_graphql_api_id" => "gid://shopify/Refund/509562969", "created_at" => "2024-04-02T08:59:11-05:00", "note" => "it broke during shipping", "order_id" => 450789469, "processed_at" => "2024-04-02T08:59:11-05:00", "restock" => true, "total_additional_fees_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "total_duties_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "user_id" => 548380009, "order_adjustments" => [], "transactions" => [{"id" => 179259969, "admin_graphql_api_id" => "gid://shopify/OrderTransaction/179259969", "amount" => "209.00", "authorization" => "authorization-key", "created_at" => "2005-08-05T12:59:12-04:00", "currency" => "USD", "device_id" => nil, "error_code" => nil, "gateway" => "bogus", "kind" => "refund", "location_id" => nil, "message" => nil, "order_id" => 450789469, "parent_id" => 801038806, "payment_id" => "#1001.3", "processed_at" => "2005-08-05T12:59:12-04:00", "receipt" => {}, "source_name" => "web", "status" => "success", "test" => false, "user_id" => nil}], "refund_line_items" => [{"id" => 104689539, "line_item_id" => 703073504, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.66, "subtotal_set" => {"shop_money" => {"amount" => "195.66", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.66", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 703073504, "admin_graphql_api_id" => "gid://shopify/LineItem/703073504", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - black", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008BLACK", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 457924702, "variant_inventory_management" => "shopify", "variant_title" => "black", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.33", "amount_set" => {"shop_money" => {"amount" => "3.33", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.33", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}, {"id" => 709875399, "line_item_id" => 466157049, "location_id" => 487838322, "quantity" => 1, "restock_type" => "legacy_restock", "subtotal" => 195.67, "subtotal_set" => {"shop_money" => {"amount" => "195.67", "currency_code" => "USD"}, "presentment_money" => {"amount" => "195.67", "currency_code" => "USD"}}, "total_tax" => 3.98, "total_tax_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "line_item" => {"id" => 466157049, "admin_graphql_api_id" => "gid://shopify/LineItem/466157049", "current_quantity" => 0, "fulfillable_quantity" => 0, "fulfillment_service" => "manual", "fulfillment_status" => nil, "gift_card" => false, "grams" => 200, "name" => "IPod Nano - 8gb - green", "price" => "199.00", "price_set" => {"shop_money" => {"amount" => "199.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "199.00", "currency_code" => "USD"}}, "product_exists" => true, "product_id" => 632910392, "properties" => [{"name" => "Custom Engraving Front", "value" => "Happy Birthday"}, {"name" => "Custom Engraving Back", "value" => "Merry Christmas"}], "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008GREEN", "taxable" => true, "title" => "IPod Nano - 8gb", "total_discount" => "0.00", "total_discount_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "variant_id" => 39072856, "variant_inventory_management" => "shopify", "variant_title" => "green", "vendor" => nil, "tax_lines" => [{"channel_liable" => nil, "price" => "3.98", "price_set" => {"shop_money" => {"amount" => "3.98", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.98", "currency_code" => "USD"}}, "rate" => 0.06, "title" => "State Tax"}], "duties" => [], "discount_allocations" => [{"amount" => "3.34", "amount_set" => {"shop_money" => {"amount" => "3.34", "currency_code" => "USD"}, "presentment_money" => {"amount" => "3.34", "currency_code" => "USD"}}, "discount_application_index" => 0}]}}], "duties" => [], "additional_fees" => []}], "shipping_address" => {"first_name" => "Bob", "address1" => "123 Ship Street", "phone" => "+1(502)-459-2181", "city" => "Shipsville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => nil, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"}, "shipping_lines" => [{"id" => 369256396, "carrier_identifier" => nil, "code" => "Free Shipping", "discounted_price" => "0.00", "discounted_price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "phone" => nil, "price" => "0.00", "price_set" => {"shop_money" => {"amount" => "0.00", "currency_code" => "USD"}, "presentment_money" => {"amount" => "0.00", "currency_code" => "USD"}}, "requested_fulfillment_service_id" => nil, "source" => "shopify", "title" => "Free Shipping", "tax_lines" => [], "discount_allocations" => []}]}}), headers: {})

    response = order = ShopifyAPI::Order.new
    order.id = 450789469
    order.shipping_address = {
      "address1" => "123 Ship Street",
      "city" => "Shipsville"
    }
    order.save

    assert_requested(:put, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

  sig do
    void
  end
  def test_34()
    stub_request(:delete, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({}), headers: {})

    response = ShopifyAPI::Order.delete(
      id: 450789469,
    )

    assert_requested(:delete, "https://test-shop.myshopify.io/admin/api/2024-04/orders/450789469.json")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

end
