# Contributing

Types of contributions we welcome:

* Reporting issues with existing features
* Bug fixes
* Performance improvements
* Documentation
* Usability improvements

## Things we won't merge

* Additional dependancies that limit its use (e.g. android or relay dependencies)
* Supporting GraphQL variables, directives or named fragments

## Proposing Features

When in doubt about whether we will be interested in including a
new feature in this project, please open an issue to propose the
feature so we can confirm the feature should be in scope for the
project before it is implemented.

## How To Contribute

1. Fork the [repository in github](https://github.com/Shopify/graphql_java_gen)
2. Create your feature branch (`git checkout -b fix-feature`)
3. Commit your changes (`git commit -am 'fix: Summarize change'`)
3. Make sure all tests pass (`bundle exec rake`)
4. Push to the branch (`git push origin fix-feature`)
5. [Create new pull request](https://github.com/Shopify/graphql_java_gen/pulls)
