// Three.js r39 - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!window.Int32Array){window.Int32Array=Array;window.Float32Array=Array}THREE.Color=function(b){this.setHex(b)};
THREE.Color.prototype={autoUpdate:!0,copy:function(b){this.r=b.r;this.g=b.g;this.b=b.b;this.hex=b.hex;this.__styleString=b.__styleString},setRGB:function(b,d,c){this.r=b;this.g=d;this.b=c;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHSV:function(b,d,c){var f,g,h,j,k,m;if(c==0)f=g=h=0;else{j=Math.floor(b*6);k=b*6-j;b=c*(1-d);m=c*(1-d*k);d=c*(1-d*(1-k));switch(j){case 1:f=m;g=c;h=b;break;case 2:f=b;g=c;h=d;break;case 3:f=b;g=m;h=c;break;case 4:f=d;g=b;h=c;break;case 5:f=c;g=b;
h=m;break;case 6:case 0:f=c;g=d;h=b}}this.r=f;this.g=g;this.b=h;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHex:function(b){this.hex=~~b&16777215;if(this.autoUpdate){this.updateRGB();this.updateStyleString()}},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGB:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},updateStyleString:function(){this.__styleString="rgb("+~~(this.r*255)+","+~~(this.g*
255)+","+~~(this.b*255)+")"},clone:function(){return new THREE.Color(this.hex)}};THREE.Vector2=function(b,d){this.set(b||0,d||0)};
THREE.Vector2.prototype={set:function(b,d){this.x=b;this.y=d;return this},copy:function(b){this.set(b.x,b.y);return this},addSelf:function(b){this.set(this.x+b.x,this.y+b.y);return this},add:function(b,d){this.set(b.x+d.x,b.y+d.y);return this},subSelf:function(b){this.set(this.x-b.x,this.y-b.y);return this},sub:function(b,d){this.set(b.x-d.x,b.y-d.y);return this},multiplyScalar:function(b){this.set(this.x*b,this.y*b);return this},negate:function(){this.set(-this.x,-this.y);return this},unit:function(){this.multiplyScalar(1/
this.length());return this},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y},clone:function(){return new THREE.Vector2(this.x,this.y)}};THREE.Vector3=function(b,d,c){this.set(b||0,d||0,c||0)};
THREE.Vector3.prototype={set:function(b,d,c){this.x=b;this.y=d;this.z=c;return this},copy:function(b){this.set(b.x,b.y,b.z);return this},add:function(b,d){this.set(b.x+d.x,b.y+d.y,b.z+d.z);return this},addSelf:function(b){this.set(this.x+b.x,this.y+b.y,this.z+b.z);return this},addScalar:function(b){this.set(this.x+b,this.y+b,this.z+b);return this},sub:function(b,d){this.set(b.x-d.x,b.y-d.y,b.z-d.z);return this},subSelf:function(b){this.set(this.x-b.x,this.y-b.y,this.z-b.z);return this},cross:function(b,
d){this.set(b.y*d.z-b.z*d.y,b.z*d.x-b.x*d.z,b.x*d.y-b.y*d.x);return this},crossSelf:function(b){var d=this.x,c=this.y,f=this.z;this.set(c*b.z-f*b.y,f*b.x-d*b.z,d*b.y-c*b.x);return this},multiply:function(b,d){this.set(b.x*d.x,b.y*d.y,b.z*d.z);return this},multiplySelf:function(b){this.set(this.x*b.x,this.y*b.y,this.z*b.z);return this},multiplyScalar:function(b){this.set(this.x*b,this.y*b,this.z*b);return this},divideSelf:function(b){this.set(this.x/b.x,this.y/b.y,this.z/b.z);return this},divideScalar:function(b){this.set(this.x/
b,this.y/b,this.z/b);return this},negate:function(){this.set(-this.x,-this.y,-this.z);return this},dot:function(b){return this.x*b.x+this.y*b.y+this.z*b.z},distanceTo:function(b){return Math.sqrt(this.distanceToSquared(b))},distanceToSquared:function(b){var d=this.x-b.x,c=this.y-b.y;b=this.z-b.z;return d*d+c*c+b*b},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){var b=
this.length();b>0?this.multiplyScalar(1/b):this.set(0,0,0);return this},setPositionFromMatrix:function(b){this.x=b.n14;this.y=b.n24;this.z=b.n34},setRotationFromMatrix:function(b){this.y=Math.asin(b.n13);var d=Math.cos(this.y);if(Math.abs(d)>1.0E-5){this.x=Math.atan2(-b.n23/d,b.n33/d);this.z=Math.atan2(-b.n13/d,b.n11/d)}else{this.x=0;this.z=Math.atan2(b.n21,b.n22)}},setLength:function(b){return this.normalize().multiplyScalar(b)},isZero:function(){return Math.abs(this.x)<1.0E-4&&Math.abs(this.y)<
1.0E-4&&Math.abs(this.z)<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)}};THREE.Vector4=function(b,d,c,f){this.set(b||0,d||0,c||0,f||1)};
THREE.Vector4.prototype={set:function(b,d,c,f){this.x=b;this.y=d;this.z=c;this.w=f;return this},copy:function(b){this.set(b.x,b.y,b.z,b.w||1);return this},add:function(b,d){this.set(b.x+d.x,b.y+d.y,b.z+d.z,b.w+d.w);return this},addSelf:function(b){this.set(this.x+b.x,this.y+b.y,this.z+b.z,this.w+b.w);return this},sub:function(b,d){this.set(b.x-d.x,b.y-d.y,b.z-d.z,b.w-d.w);return this},subSelf:function(b){this.set(this.x-b.x,this.y-b.y,this.z-b.z,this.w-b.w);return this},multiplyScalar:function(b){this.set(this.x*
b,this.y*b,this.z*b,this.w*b);return this},divideScalar:function(b){this.set(this.x/b,this.y/b,this.z/b,this.w/b);return this},lerpSelf:function(b,d){this.set(this.x+(b.x-this.x)*d,this.y+(b.y-this.y)*d,this.z+(b.z-this.z)*d,this.w+(b.w-this.w)*d)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)}};THREE.Ray=function(b,d){this.origin=b||new THREE.Vector3;this.direction=d||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(b){var d,c,f=b.objects,g=[];b=0;for(d=f.length;b<d;b++){c=f[b];c instanceof THREE.Mesh&&(g=g.concat(this.intersectObject(c)))}g.sort(function(h,j){return h.distance-j.distance});return g},intersectObject:function(b){function d(H,G,X,A){A=A.clone().subSelf(G);X=X.clone().subSelf(G);var M=H.clone().subSelf(G);H=A.dot(A);G=A.dot(X);A=A.dot(M);var Q=X.dot(X);X=X.dot(M);M=1/(H*Q-G*G);Q=(Q*A-G*X)*M;H=(H*X-G*A)*M;return Q>0&&H>0&&Q+H<1}var c,f,g,h,j,k,m,p,o,u,
y,t=b.geometry,B=t.vertices,F=[];c=0;for(f=t.faces.length;c<f;c++){g=t.faces[c];u=this.origin.clone();y=this.direction.clone();m=b.matrixWorld;h=m.multiplyVector3(B[g.a].position.clone());j=m.multiplyVector3(B[g.b].position.clone());k=m.multiplyVector3(B[g.c].position.clone());m=g instanceof THREE.Face4?m.multiplyVector3(B[g.d].position.clone()):null;p=b.matrixRotationWorld.multiplyVector3(g.normal.clone());o=y.dot(p);if(b.doubleSided||(b.flipSided?o>0:o<0)){p=p.dot((new THREE.Vector3).sub(h,u))/
o;u=u.addSelf(y.multiplyScalar(p));if(g instanceof THREE.Face3){if(d(u,h,j,k)){g={distance:this.origin.distanceTo(u),point:u,face:g,object:b};F.push(g)}}else if(g instanceof THREE.Face4&&(d(u,h,j,m)||d(u,j,k,m))){g={distance:this.origin.distanceTo(u),point:u,face:g,object:b};F.push(g)}}}return F}};
THREE.Rectangle=function(){function b(){h=f-d;j=g-c}var d,c,f,g,h,j,k=!0;this.getX=function(){return d};this.getY=function(){return c};this.getWidth=function(){return h};this.getHeight=function(){return j};this.getLeft=function(){return d};this.getTop=function(){return c};this.getRight=function(){return f};this.getBottom=function(){return g};this.set=function(m,p,o,u){k=!1;d=m;c=p;f=o;g=u;b()};this.addPoint=function(m,p){if(k){k=!1;d=m;c=p;f=m;g=p}else{d=d<m?d:m;c=c<p?c:p;f=f>m?f:m;g=g>p?g:p}b()};
this.add3Points=function(m,p,o,u,y,t){if(k){k=!1;d=m<o?m<y?m:y:o<y?o:y;c=p<u?p<t?p:t:u<t?u:t;f=m>o?m>y?m:y:o>y?o:y;g=p>u?p>t?p:t:u>t?u:t}else{d=m<o?m<y?m<d?m:d:y<d?y:d:o<y?o<d?o:d:y<d?y:d;c=p<u?p<t?p<c?p:c:t<c?t:c:u<t?u<c?u:c:t<c?t:c;f=m>o?m>y?m>f?m:f:y>f?y:f:o>y?o>f?o:f:y>f?y:f;g=p>u?p>t?p>g?p:g:t>g?t:g:u>t?u>g?u:g:t>g?t:g}b()};this.addRectangle=function(m){if(k){k=!1;d=m.getLeft();c=m.getTop();f=m.getRight();g=m.getBottom()}else{d=d<m.getLeft()?d:m.getLeft();c=c<m.getTop()?c:m.getTop();f=f>m.getRight()?
f:m.getRight();g=g>m.getBottom()?g:m.getBottom()}b()};this.inflate=function(m){d-=m;c-=m;f+=m;g+=m;b()};this.minSelf=function(m){d=d>m.getLeft()?d:m.getLeft();c=c>m.getTop()?c:m.getTop();f=f<m.getRight()?f:m.getRight();g=g<m.getBottom()?g:m.getBottom();b()};this.instersects=function(m){return Math.min(f,m.getRight())-Math.max(d,m.getLeft())>=0&&Math.min(g,m.getBottom())-Math.max(c,m.getTop())>=0};this.empty=function(){k=!0;g=f=c=d=0;b()};this.isEmpty=function(){return k}};
THREE.Matrix3=function(){this.m=[]};THREE.Matrix3.prototype={transpose:function(){var b,d=this.m;b=d[1];d[1]=d[3];d[3]=b;b=d[2];d[2]=d[6];d[6]=b;b=d[5];d[5]=d[7];d[7]=b;return this},transposeIntoArray:function(b){var d=this.m;b[0]=d[0];b[1]=d[3];b[2]=d[6];b[3]=d[1];b[4]=d[4];b[5]=d[7];b[6]=d[2];b[7]=d[5];b[8]=d[8];return this}};
THREE.Matrix4=function(b,d,c,f,g,h,j,k,m,p,o,u,y,t,B,F){this.set(b||1,d||0,c||0,f||0,g||0,h||1,j||0,k||0,m||0,p||0,o||1,u||0,y||0,t||0,B||0,F||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={set:function(b,d,c,f,g,h,j,k,m,p,o,u,y,t,B,F){this.n11=b;this.n12=d;this.n13=c;this.n14=f;this.n21=g;this.n22=h;this.n23=j;this.n24=k;this.n31=m;this.n32=p;this.n33=o;this.n34=u;this.n41=y;this.n42=t;this.n43=B;this.n44=F;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(b){this.set(b.n11,b.n12,b.n13,b.n14,b.n21,b.n22,b.n23,b.n24,b.n31,b.n32,b.n33,b.n34,b.n41,b.n42,b.n43,b.n44);return this},lookAt:function(b,d,c){var f=THREE.Matrix4.__v1,
g=THREE.Matrix4.__v2,h=THREE.Matrix4.__v3;h.sub(b,d).normalize();if(h.length()===0)h.z=1;f.cross(c,h).normalize();if(f.length()===0){h.x+=1.0E-4;f.cross(c,h).normalize()}g.cross(h,f).normalize();this.n11=f.x;this.n12=g.x;this.n13=h.x;this.n21=f.y;this.n22=g.y;this.n23=h.y;this.n31=f.z;this.n32=g.z;this.n33=h.z;return this},multiplyVector3:function(b){var d=b.x,c=b.y,f=b.z,g=1/(this.n41*d+this.n42*c+this.n43*f+this.n44);b.x=(this.n11*d+this.n12*c+this.n13*f+this.n14)*g;b.y=(this.n21*d+this.n22*c+this.n23*
f+this.n24)*g;b.z=(this.n31*d+this.n32*c+this.n33*f+this.n34)*g;return b},multiplyVector4:function(b){var d=b.x,c=b.y,f=b.z,g=b.w;b.x=this.n11*d+this.n12*c+this.n13*f+this.n14*g;b.y=this.n21*d+this.n22*c+this.n23*f+this.n24*g;b.z=this.n31*d+this.n32*c+this.n33*f+this.n34*g;b.w=this.n41*d+this.n42*c+this.n43*f+this.n44*g;return b},rotateAxis:function(b){var d=b.x,c=b.y,f=b.z;b.x=d*this.n11+c*this.n12+f*this.n13;b.y=d*this.n21+c*this.n22+f*this.n23;b.z=d*this.n31+c*this.n32+f*this.n33;b.normalize();
return b},crossVector:function(b){var d=new THREE.Vector4;d.x=this.n11*b.x+this.n12*b.y+this.n13*b.z+this.n14*b.w;d.y=this.n21*b.x+this.n22*b.y+this.n23*b.z+this.n24*b.w;d.z=this.n31*b.x+this.n32*b.y+this.n33*b.z+this.n34*b.w;d.w=b.w?this.n41*b.x+this.n42*b.y+this.n43*b.z+this.n44*b.w:1;return d},multiply:function(b,d){var c=b.n11,f=b.n12,g=b.n13,h=b.n14,j=b.n21,k=b.n22,m=b.n23,p=b.n24,o=b.n31,u=b.n32,y=b.n33,t=b.n34,B=b.n41,F=b.n42,H=b.n43,G=b.n44,X=d.n11,A=d.n12,M=d.n13,Q=d.n14,R=d.n21,Da=d.n22,
ma=d.n23,va=d.n24,ca=d.n31,e=d.n32,ea=d.n33,ya=d.n34;this.n11=c*X+f*R+g*ca;this.n12=c*A+f*Da+g*e;this.n13=c*M+f*ma+g*ea;this.n14=c*Q+f*va+g*ya+h;this.n21=j*X+k*R+m*ca;this.n22=j*A+k*Da+m*e;this.n23=j*M+k*ma+m*ea;this.n24=j*Q+k*va+m*ya+p;this.n31=o*X+u*R+y*ca;this.n32=o*A+u*Da+y*e;this.n33=o*M+u*ma+y*ea;this.n34=o*Q+u*va+y*ya+t;this.n41=B*X+F*R+H*ca;this.n42=B*A+F*Da+H*e;this.n43=B*M+F*ma+H*ea;this.n44=B*Q+F*va+H*ya+G;return this},multiplyToArray:function(b,d,c){this.multiply(b,d);c[0]=this.n11;c[1]=
this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(b){this.multiply(this,b);return this},multiplyScalar:function(b){this.n11*=b;this.n12*=b;this.n13*=b;this.n14*=b;this.n21*=b;this.n22*=b;this.n23*=b;this.n24*=b;this.n31*=b;this.n32*=b;this.n33*=b;this.n34*=b;this.n41*=b;this.n42*=b;this.n43*=b;this.n44*=
b;return this},determinant:function(){var b=this.n11,d=this.n12,c=this.n13,f=this.n14,g=this.n21,h=this.n22,j=this.n23,k=this.n24,m=this.n31,p=this.n32,o=this.n33,u=this.n34,y=this.n41,t=this.n42,B=this.n43,F=this.n44;return f*j*p*y-c*k*p*y-f*h*o*y+d*k*o*y+c*h*u*y-d*j*u*y-f*j*m*t+c*k*m*t+f*g*o*t-b*k*o*t-c*g*u*t+b*j*u*t+f*h*m*B-d*k*m*B-f*g*p*B+b*k*p*B+d*g*u*B-b*h*u*B-c*h*m*F+d*j*m*F+c*g*p*F-b*j*p*F-d*g*o*F+b*h*o*F},transpose:function(){var b;b=this.n21;this.n21=this.n12;this.n12=b;b=this.n31;this.n31=
this.n13;this.n13=b;b=this.n32;this.n32=this.n23;this.n23=b;b=this.n41;this.n41=this.n14;this.n14=b;b=this.n42;this.n42=this.n24;this.n24=b;b=this.n43;this.n43=this.n34;this.n43=b;return this},clone:function(){var b=new THREE.Matrix4;b.n11=this.n11;b.n12=this.n12;b.n13=this.n13;b.n14=this.n14;b.n21=this.n21;b.n22=this.n22;b.n23=this.n23;b.n24=this.n24;b.n31=this.n31;b.n32=this.n32;b.n33=this.n33;b.n34=this.n34;b.n41=this.n41;b.n42=this.n42;b.n43=this.n43;b.n44=this.n44;return b},flatten:function(){this.flat[0]=
this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(b){b[0]=this.n11;b[1]=this.n21;b[2]=this.n31;b[3]=this.n41;b[4]=this.n12;b[5]=this.n22;b[6]=this.n32;b[7]=this.n42;
b[8]=this.n13;b[9]=this.n23;b[10]=this.n33;b[11]=this.n43;b[12]=this.n14;b[13]=this.n24;b[14]=this.n34;b[15]=this.n44;return b},flattenToArrayOffset:function(b,d){b[d]=this.n11;b[d+1]=this.n21;b[d+2]=this.n31;b[d+3]=this.n41;b[d+4]=this.n12;b[d+5]=this.n22;b[d+6]=this.n32;b[d+7]=this.n42;b[d+8]=this.n13;b[d+9]=this.n23;b[d+10]=this.n33;b[d+11]=this.n43;b[d+12]=this.n14;b[d+13]=this.n24;b[d+14]=this.n34;b[d+15]=this.n44;return b},setTranslation:function(b,d,c){this.set(1,0,0,b,0,1,0,d,0,0,1,c,0,0,
0,1);return this},setScale:function(b,d,c){this.set(b,0,0,0,0,d,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(b){var d=Math.cos(b);b=Math.sin(b);this.set(1,0,0,0,0,d,-b,0,0,b,d,0,0,0,0,1);return this},setRotationY:function(b){var d=Math.cos(b);b=Math.sin(b);this.set(d,0,b,0,0,1,0,0,-b,0,d,0,0,0,0,1);return this},setRotationZ:function(b){var d=Math.cos(b);b=Math.sin(b);this.set(d,-b,0,0,b,d,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(b,d){var c=Math.cos(d),f=Math.sin(d),g=
1-c,h=b.x,j=b.y,k=b.z,m=g*h,p=g*j;this.set(m*h+c,m*j-f*k,m*k+f*j,0,m*j+f*k,p*j+c,p*k-f*h,0,m*k-f*j,p*k+f*h,g*k*k+c,0,0,0,0,1);return this},setPosition:function(b){this.n14=b.x;this.n24=b.y;this.n34=b.z;return this},setRotationFromEuler:function(b){var d=b.x,c=b.y,f=b.z;b=Math.cos(d);d=Math.sin(d);var g=Math.cos(c);c=Math.sin(c);var h=Math.cos(f);f=Math.sin(f);var j=b*c,k=d*c;this.n11=g*h;this.n12=-g*f;this.n13=c;this.n21=k*h+b*f;this.n22=-k*f+b*h;this.n23=-d*g;this.n31=-j*h+d*f;this.n32=j*f+d*h;this.n33=
b*g;return this},setRotationFromQuaternion:function(b){var d=b.x,c=b.y,f=b.z,g=b.w,h=d+d,j=c+c,k=f+f;b=d*h;var m=d*j;d*=k;var p=c*j;c*=k;f*=k;h*=g;j*=g;g*=k;this.n11=1-(p+f);this.n12=m-g;this.n13=d+j;this.n21=m+g;this.n22=1-(b+f);this.n23=c-h;this.n31=d-j;this.n32=c+h;this.n33=1-(b+p);return this},scale:function(b){var d=b.x,c=b.y;b=b.z;this.n11*=d;this.n12*=c;this.n13*=b;this.n21*=d;this.n22*=c;this.n23*=b;this.n31*=d;this.n32*=c;this.n33*=b;this.n41*=d;this.n42*=c;this.n43*=b;return this},extractPosition:function(b){this.n14=
b.n14;this.n24=b.n24;this.n34=b.n34},extractRotation:function(b,d){var c=1/d.x,f=1/d.y,g=1/d.z;this.n11=b.n11*c;this.n21=b.n21*c;this.n31=b.n31*c;this.n12=b.n12*f;this.n22=b.n22*f;this.n32=b.n32*f;this.n13=b.n13*g;this.n23=b.n23*g;this.n33=b.n33*g}};
THREE.Matrix4.makeInvert=function(b,d){var c=b.n11,f=b.n12,g=b.n13,h=b.n14,j=b.n21,k=b.n22,m=b.n23,p=b.n24,o=b.n31,u=b.n32,y=b.n33,t=b.n34,B=b.n41,F=b.n42,H=b.n43,G=b.n44;d===undefined&&(d=new THREE.Matrix4);d.n11=m*t*F-p*y*F+p*u*H-k*t*H-m*u*G+k*y*G;d.n12=h*y*F-g*t*F-h*u*H+f*t*H+g*u*G-f*y*G;d.n13=g*p*F-h*m*F+h*k*H-f*p*H-g*k*G+f*m*G;d.n14=h*m*u-g*p*u-h*k*y+f*p*y+g*k*t-f*m*t;d.n21=p*y*B-m*t*B-p*o*H+j*t*H+m*o*G-j*y*G;d.n22=g*t*B-h*y*B+h*o*H-c*t*H-g*o*G+c*y*G;d.n23=h*m*B-g*p*B-h*j*H+c*p*H+g*j*G-c*m*G;
d.n24=g*p*o-h*m*o+h*j*y-c*p*y-g*j*t+c*m*t;d.n31=k*t*B-p*u*B+p*o*F-j*t*F-k*o*G+j*u*G;d.n32=h*u*B-f*t*B-h*o*F+c*t*F+f*o*G-c*u*G;d.n33=g*p*B-h*k*B+h*j*F-c*p*F-f*j*G+c*k*G;d.n34=h*k*o-f*p*o-h*j*u+c*p*u+f*j*t-c*k*t;d.n41=m*u*B-k*y*B-m*o*F+j*y*F+k*o*H-j*u*H;d.n42=f*y*B-g*u*B+g*o*F-c*y*F-f*o*H+c*u*H;d.n43=g*k*B-f*m*B-g*j*F+c*m*F+f*j*H-c*k*H;d.n44=f*m*o-g*k*o+g*j*u-c*m*u-f*j*y+c*k*y;d.multiplyScalar(1/b.determinant());return d};
THREE.Matrix4.makeInvert3x3=function(b){var d=b.m33,c=d.m,f=b.n33*b.n22-b.n32*b.n23,g=-b.n33*b.n21+b.n31*b.n23,h=b.n32*b.n21-b.n31*b.n22,j=-b.n33*b.n12+b.n32*b.n13,k=b.n33*b.n11-b.n31*b.n13,m=-b.n32*b.n11+b.n31*b.n12,p=b.n23*b.n12-b.n22*b.n13,o=-b.n23*b.n11+b.n21*b.n13,u=b.n22*b.n11-b.n21*b.n12;b=b.n11*f+b.n21*j+b.n31*p;if(b==0)throw"matrix not invertible";b=1/b;c[0]=b*f;c[1]=b*g;c[2]=b*h;c[3]=b*j;c[4]=b*k;c[5]=b*m;c[6]=b*p;c[7]=b*o;c[8]=b*u;return d};
THREE.Matrix4.makeFrustum=function(b,d,c,f,g,h){var j;j=new THREE.Matrix4;j.n11=2*g/(d-b);j.n12=0;j.n13=(d+b)/(d-b);j.n14=0;j.n21=0;j.n22=2*g/(f-c);j.n23=(f+c)/(f-c);j.n24=0;j.n31=0;j.n32=0;j.n33=-(h+g)/(h-g);j.n34=-2*h*g/(h-g);j.n41=0;j.n42=0;j.n43=-1;j.n44=0;return j};THREE.Matrix4.makePerspective=function(b,d,c,f){var g;b=c*Math.tan(b*Math.PI/360);g=-b;return THREE.Matrix4.makeFrustum(g*d,b*d,g,b,c,f)};
THREE.Matrix4.makeOrtho=function(b,d,c,f,g,h){var j,k,m,p;j=new THREE.Matrix4;k=d-b;m=c-f;p=h-g;j.n11=2/k;j.n12=0;j.n13=0;j.n14=-((d+b)/k);j.n21=0;j.n22=2/m;j.n23=0;j.n24=-((c+f)/m);j.n31=0;j.n32=0;j.n33=-2/p;j.n34=-((h+g)/p);j.n41=0;j.n42=0;j.n43=0;j.n44=1;return j};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;
THREE.Object3D=function(){this.parent=undefined;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixAutoUpdate=!0;this.matrixWorldNeedsUpdate=!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=
!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={translate:function(b,d){this.matrix.rotateAxis(d);this.position.addSelf(d.multiplyScalar(b))},translateX:function(b){this.translate(b,this._vector.set(1,0,0))},translateY:function(b){this.translate(b,this._vector.set(0,1,0))},translateZ:function(b){this.translate(b,this._vector.set(0,0,1))},lookAt:function(b){this.matrix.lookAt(this.position,b,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},addChild:function(b){if(this.children.indexOf(b)===-1){b.parent!==
undefined&&b.parent.removeChild(b);b.parent=this;this.children.push(b);for(var d=this;d instanceof THREE.Scene===!1&&d!==undefined;)d=d.parent;d!==undefined&&d.addChildRecurse(b)}},removeChild:function(b){var d=this.children.indexOf(b);if(d!==-1){b.parent=undefined;this.children.splice(d,1)}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation);if(this.scale.x!==1||this.scale.y!==
1||this.scale.z!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z))}this.matrixWorldNeedsUpdate=!0},update:function(b,d,c){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||d){b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale);this.matrixWorldNeedsUpdate=!1;d=!0}b=0;for(var f=this.children.length;b<f;b++)this.children[b].update(this.matrixWorld,
d,c)}};THREE.Quaternion=function(b,d,c,f){this.set(b||0,d||0,c||0,f!==undefined?f:1)};
THREE.Quaternion.prototype={set:function(b,d,c,f){this.x=b;this.y=d;this.z=c;this.w=f;return this},setFromEuler:function(b){var d=0.5*Math.PI/360,c=b.x*d,f=b.y*d,g=b.z*d;b=Math.cos(f);f=Math.sin(f);d=Math.cos(-g);g=Math.sin(-g);var h=Math.cos(c);c=Math.sin(c);var j=b*d,k=f*g;this.w=j*h-k*c;this.x=j*c+k*h;this.y=f*d*h+b*g*c;this.z=b*g*h-f*d*c;return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=
-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var b=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);if(b==0)this.w=this.z=this.y=this.x=0;else{b=1/b;this.x*=b;this.y*=b;this.z*=b;this.w*=b}return this},multiplySelf:function(b){var d=this.x,c=this.y,f=this.z,g=this.w,h=b.x,j=b.y,k=b.z;b=b.w;this.x=d*b+g*h+c*k-f*j;this.y=c*b+g*j+f*h-d*k;this.z=f*b+g*k+d*j-c*h;this.w=g*b-d*h-c*j-f*k;return this},
multiplyVector3:function(b,d){d||(d=b);var c=b.x,f=b.y,g=b.z,h=this.x,j=this.y,k=this.z,m=this.w,p=m*c+j*g-k*f,o=m*f+k*c-h*g,u=m*g+h*f-j*c;c=-h*c-j*f-k*g;d.x=p*m+c*-h+o*-k-u*-j;d.y=o*m+c*-j+u*-h-p*-k;d.z=u*m+c*-k+p*-j-o*-h;return d}};
THREE.Quaternion.slerp=function(b,d,c,f){var g=b.w*d.w+b.x*d.x+b.y*d.y+b.z*d.z;if(Math.abs(g)>=1){c.w=b.w;c.x=b.x;c.y=b.y;c.z=b.z;return c}var h=Math.acos(g),j=Math.sqrt(1-g*g);if(Math.abs(j)<0.001){c.w=0.5*(b.w+d.w);c.x=0.5*(b.x+d.x);c.y=0.5*(b.y+d.y);c.z=0.5*(b.z+d.z);return c}g=Math.sin((1-f)*h)/j;f=Math.sin(f*h)/j;c.w=b.w*g+d.w*f;c.x=b.x*g+d.x*f;c.y=b.y*g+d.y*f;c.z=b.z*g+d.z*f;return c};THREE.Vertex=function(b){this.position=b||new THREE.Vector3};
THREE.Face3=function(b,d,c,f,g,h){this.a=b;this.b=d;this.c=c;this.normal=f instanceof THREE.Vector3?f:new THREE.Vector3;this.vertexNormals=f instanceof Array?f:[];this.color=g instanceof THREE.Color?g:new THREE.Color;this.vertexColors=g instanceof Array?g:[];this.vertexTangents=[];this.materials=h instanceof Array?h:[h];this.centroid=new THREE.Vector3};
THREE.Face4=function(b,d,c,f,g,h,j){this.a=b;this.b=d;this.c=c;this.d=f;this.normal=g instanceof THREE.Vector3?g:new THREE.Vector3;this.vertexNormals=g instanceof Array?g:[];this.color=h instanceof THREE.Color?h:new THREE.Color;this.vertexColors=h instanceof Array?h:[];this.vertexTangents=[];this.materials=j instanceof Array?j:[j];this.centroid=new THREE.Vector3};THREE.UV=function(b,d){this.set(b||0,d||0)};
THREE.UV.prototype={set:function(b,d){this.u=b;this.v=d;return this},copy:function(b){this.set(b.u,b.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.hasTangents=!1};
THREE.Geometry.prototype={computeCentroids:function(){var b,d,c;b=0;for(d=this.faces.length;b<d;b++){c=this.faces[b];c.centroid.set(0,0,0);if(c instanceof THREE.Face3){c.centroid.addSelf(this.vertices[c.a].position);c.centroid.addSelf(this.vertices[c.b].position);c.centroid.addSelf(this.vertices[c.c].position);c.centroid.divideScalar(3)}else if(c instanceof THREE.Face4){c.centroid.addSelf(this.vertices[c.a].position);c.centroid.addSelf(this.vertices[c.b].position);c.centroid.addSelf(this.vertices[c.c].position);
c.centroid.addSelf(this.vertices[c.d].position);c.centroid.divideScalar(4)}}},computeFaceNormals:function(b){var d,c,f,g,h,j,k=new THREE.Vector3,m=new THREE.Vector3;f=0;for(g=this.faces.length;f<g;f++){h=this.faces[f];if(b&&h.vertexNormals.length){k.set(0,0,0);d=0;for(c=h.vertexNormals.length;d<c;d++)k.addSelf(h.vertexNormals[d]);k.divideScalar(3)}else{d=this.vertices[h.a];c=this.vertices[h.b];j=this.vertices[h.c];k.sub(j.position,c.position);m.sub(d.position,c.position);k.crossSelf(m)}k.isZero()||
k.normalize();h.normal.copy(k)}},computeVertexNormals:function(){var b,d,c,f;if(this.__tmpVertices==undefined){f=this.__tmpVertices=Array(this.vertices.length);b=0;for(d=this.vertices.length;b<d;b++)f[b]=new THREE.Vector3;b=0;for(d=this.faces.length;b<d;b++){c=this.faces[b];if(c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}}else{f=
this.__tmpVertices;b=0;for(d=this.vertices.length;b<d;b++)f[b].set(0,0,0)}b=0;for(d=this.faces.length;b<d;b++){c=this.faces[b];if(c instanceof THREE.Face3){f[c.a].addSelf(c.normal);f[c.b].addSelf(c.normal);f[c.c].addSelf(c.normal)}else if(c instanceof THREE.Face4){f[c.a].addSelf(c.normal);f[c.b].addSelf(c.normal);f[c.c].addSelf(c.normal);f[c.d].addSelf(c.normal)}}b=0;for(d=this.vertices.length;b<d;b++)f[b].normalize();b=0;for(d=this.faces.length;b<d;b++){c=this.faces[b];if(c instanceof THREE.Face3){c.vertexNormals[0].copy(f[c.a]);
c.vertexNormals[1].copy(f[c.b]);c.vertexNormals[2].copy(f[c.c])}else if(c instanceof THREE.Face4){c.vertexNormals[0].copy(f[c.a]);c.vertexNormals[1].copy(f[c.b]);c.vertexNormals[2].copy(f[c.c]);c.vertexNormals[3].copy(f[c.d])}}},computeTangents:function(){function b(oa,pa,sa,ga,aa,na,Ea){k=oa.vertices[pa].position;m=oa.vertices[sa].position;p=oa.vertices[ga].position;o=j[aa];u=j[na];y=j[Ea];t=m.x-k.x;B=p.x-k.x;F=m.y-k.y;H=p.y-k.y;G=m.z-k.z;X=p.z-k.z;A=u.u-o.u;M=y.u-o.u;Q=u.v-o.v;R=y.v-o.v;Da=1/(A*
R-M*Q);e.set((R*t-Q*B)*Da,(R*F-Q*H)*Da,(R*G-Q*X)*Da);ea.set((A*B-M*t)*Da,(A*H-M*F)*Da,(A*X-M*G)*Da);va[pa].addSelf(e);va[sa].addSelf(e);va[ga].addSelf(e);ca[pa].addSelf(ea);ca[sa].addSelf(ea);ca[ga].addSelf(ea)}var d,c,f,g,h,j,k,m,p,o,u,y,t,B,F,H,G,X,A,M,Q,R,Da,ma,va=[],ca=[],e=new THREE.Vector3,ea=new THREE.Vector3,ya=new THREE.Vector3,Ba=new THREE.Vector3,Fa=new THREE.Vector3;d=0;for(c=this.vertices.length;d<c;d++){va[d]=new THREE.Vector3;ca[d]=new THREE.Vector3}d=0;for(c=this.faces.length;d<c;d++){h=
this.faces[d];j=this.faceVertexUvs[0][d];if(h instanceof THREE.Face3)b(this,h.a,h.b,h.c,0,1,2);else if(h instanceof THREE.Face4){b(this,h.a,h.b,h.c,0,1,2);b(this,h.a,h.b,h.d,0,1,3)}}var Z=["a","b","c","d"];d=0;for(c=this.faces.length;d<c;d++){h=this.faces[d];for(f=0;f<h.vertexNormals.length;f++){Fa.copy(h.vertexNormals[f]);g=h[Z[f]];ma=va[g];ya.copy(ma);ya.subSelf(Fa.multiplyScalar(Fa.dot(ma))).normalize();Ba.cross(h.vertexNormals[f],ma);g=Ba.dot(ca[g]);g=g<0?-1:1;h.vertexTangents[f]=new THREE.Vector4(ya.x,
ya.y,ya.z,g)}}this.hasTangents=!0},computeBoundingBox:function(){var b;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var d=1,c=this.vertices.length;d<c;d++){b=this.vertices[d];if(b.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=b.position.x;else if(b.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=b.position.x;
if(b.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=b.position.y;else if(b.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=b.position.y;if(b.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=b.position.z;else if(b.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=b.position.z}}},computeBoundingSphere:function(){for(var b=this.boundingSphere===null?0:this.boundingSphere.radius,d=0,c=this.vertices.length;d<c;d++)b=Math.max(b,this.vertices[d].position.length());this.boundingSphere=
{radius:b}},computeEdgeFaces:function(){function b(m,p){return Math.min(m,p)+"_"+Math.max(m,p)}function d(m,p,o){if(m[p]===undefined){m[p]={set:{},array:[]};m[p].set[o]=1;m[p].array.push(o)}else if(m[p].set[o]===undefined){m[p].set[o]=1;m[p].array.push(o)}}var c,f,g,h,j,k={};c=0;for(f=this.faces.length;c<f;c++){j=this.faces[c];if(j instanceof THREE.Face3){g=b(j.a,j.b);d(k,g,c);g=b(j.b,j.c);d(k,g,c);g=b(j.a,j.c);d(k,g,c)}else if(j instanceof THREE.Face4){g=b(j.b,j.d);d(k,g,c);g=b(j.a,j.b);d(k,g,c);
g=b(j.a,j.d);d(k,g,c);g=b(j.b,j.c);d(k,g,c);g=b(j.c,j.d);d(k,g,c)}}c=0;for(f=this.edges.length;c<f;c++){j=this.edges[c];g=j.vertexIndices[0];h=j.vertexIndices[1];j.faceIndices=k[b(g,h)].array;for(g=0;g<j.faceIndices.length;g++){h=j.faceIndices[g];j.faces.push(this.faces[h])}}}};THREE.GeometryIdCounter=0;
THREE.Spline=function(b){function d(t,B,F,H,G,X,A){t=(F-t)*0.5;H=(H-B)*0.5;return(2*(B-F)+t+H)*A+(-3*(B-F)-2*t-H)*X+t*G+B}this.points=b;var c=[],f={x:0,y:0,z:0},g,h,j,k,m,p,o,u,y;this.initFromArray=function(t){this.points=[];for(var B=0;B<t.length;B++)this.points[B]={x:t[B][0],y:t[B][1],z:t[B][2]}};this.getPoint=function(t){g=(this.points.length-1)*t;h=Math.floor(g);j=g-h;c[0]=h==0?h:h-1;c[1]=h;c[2]=h>this.points.length-2?h:h+1;c[3]=h>this.points.length-3?h:h+2;p=this.points[c[0]];o=this.points[c[1]];
u=this.points[c[2]];y=this.points[c[3]];k=j*j;m=j*k;f.x=d(p.x,o.x,u.x,y.x,j,k,m);f.y=d(p.y,o.y,u.y,y.y,j,k,m);f.z=d(p.z,o.z,u.z,y.z,j,k,m);return f};this.getControlPointsArray=function(){var t,B,F=this.points.length,H=[];for(t=0;t<F;t++){B=this.points[t];H[t]=[B.x,B.y,B.z]}return H};this.getLength=function(t){var B,F,H=B=B=0,G=new THREE.Vector3,X=new THREE.Vector3,A=[],M=0;A[0]=0;t||(t=100);F=this.points.length*t;G.copy(this.points[0]);for(t=1;t<F;t++){B=t/F;position=this.getPoint(B);X.copy(position);
M+=X.distanceTo(G);G.copy(position);B*=this.points.length-1;B=Math.floor(B);if(B!=H){A[B]=M;H=B}}A[A.length]=M;return{chunks:A,total:M}};this.reparametrizeByArcLength=function(t){var B,F,H,G,X,A,M=[],Q=new THREE.Vector3,R=this.getLength();M.push(Q.copy(this.points[0]).clone());for(B=1;B<this.points.length;B++){F=R.chunks[B]-R.chunks[B-1];A=Math.ceil(t*F/R.total);G=(B-1)/(this.points.length-1);X=B/(this.points.length-1);for(F=1;F<A-1;F++){H=G+F*(1/A)*(X-G);position=this.getPoint(H);M.push(Q.copy(position).clone())}M.push(Q.copy(this.points[B]).clone())}this.points=
M}};THREE.Edge=function(b,d,c,f){this.vertices=[b,d];this.vertexIndices=[c,f];this.faces=[];this.faceIndices=[]};THREE.Camera=function(b,d,c,f,g){THREE.Object3D.call(this);this.fov=b||50;this.aspect=d||1;this.near=c||0.1;this.far=f||2E3;this.target=g||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;
THREE.Camera.prototype.supr=THREE.Object3D.prototype;THREE.Camera.prototype.translate=function(b,d){this.matrix.rotateAxis(d);this.position.addSelf(d.multiplyScalar(b));this.target.position.addSelf(d.multiplyScalar(b))};THREE.Camera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};THREE.Camera.prototype.updateMatrix=function(){this.update(undefined,!0)};
THREE.Camera.prototype.update=function(b,d,c){if(this.useTarget){this.matrix.lookAt(this.position,this.target.position,this.up);this.matrix.setPosition(this.position);b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix);THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);d=!0}else{this.matrixAutoUpdate&&(d|=this.updateMatrix());if(d||this.matrixWorldNeedsUpdate){b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=
!1;d=!0;THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse)}}for(b=0;b<this.children.length;b++)this.children[b].update(this.matrixWorld,d,c)};THREE.Light=function(b){THREE.Object3D.call(this);this.color=new THREE.Color(b)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(b){THREE.Light.call(this,b)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(b,d,c){THREE.Light.call(this,b);this.position=new THREE.Vector3(0,1,0);this.intensity=d||1;this.distance=c||0};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(b,d,c){THREE.Light.call(this,b);this.position=new THREE.Vector3;this.intensity=d||1;this.distance=c||0};THREE.PointLight.prototype=new THREE.Light;
THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.LensFlare=function(b,d,c,f){THREE.Object3D.call(this);this.positionScreen=new THREE.Vector3;this.lensFlares=[];this.customUpdateCallback=undefined;b!==undefined&&this.add(b,d,c,f)};THREE.LensFlare.prototype=new THREE.Object3D;THREE.LensFlare.prototype.constructor=THREE.LensFlare;THREE.LensFlare.prototype.supr=THREE.Object3D.prototype;
THREE.LensFlare.prototype.add=function(b,d,c,f){d===undefined&&(d=-1);c===undefined&&(c=0);if(f===undefined)f=THREE.BillboardBlending;c=Math.min(c,Math.max(0,c));this.lensFlares.push({texture:b,size:d,distance:c,x:0,y:0,z:0,scale:1,rotation:1,opacity:1,blending:f})};
THREE.LensFlare.prototype.updateLensFlares=function(){var b,d=this.lensFlares.length,c,f=-this.positionScreen.x*2,g=-this.positionScreen.y*2;for(b=0;b<d;b++){c=this.lensFlares[b];c.x=this.positionScreen.x+f*c.distance;c.y=this.positionScreen.y+g*c.distance;c.wantedRotation=c.x*Math.PI*0.25;c.rotation+=(c.wantedRotation-c.rotation)*0.25}};
THREE.Material=function(b){this.id=THREE.MaterialCounter.value++;b=b||{};this.opacity=b.opacity!==undefined?b.opacity:1;this.transparent=b.transparent!==undefined?b.transparent:!1;this.blending=b.blending!==undefined?b.blending:THREE.NormalBlending;this.depthTest=b.depthTest!==undefined?b.depthTest:!0};THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;
THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;THREE.MaterialCounter={value:0};THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};
THREE.LineBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==undefined?new THREE.Color(b.color):new THREE.Color(16777215);this.linewidth=b.linewidth!==undefined?b.linewidth:1;this.linecap=b.linecap!==undefined?b.linecap:"round";this.linejoin=b.linejoin!==undefined?b.linejoin:"round";this.vertexColors=b.vertexColors?b.vertexColors:!1};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==undefined?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==undefined?b.map:null;this.lightMap=b.lightMap!==undefined?b.lightMap:null;this.envMap=b.envMap!==undefined?b.envMap:null;this.combine=b.combine!==undefined?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==undefined?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==undefined?b.refractionRatio:0.98;this.shading=
b.shading!==undefined?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==undefined?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==undefined?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==undefined?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==undefined?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==undefined?b.vertexColors:!1;this.skinning=b.skinning!==undefined?b.skinning:!1;this.morphTargets=b.morphTargets!==undefined?
b.morphTargets:!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==undefined?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==undefined?b.map:null;this.lightMap=b.lightMap!==undefined?b.lightMap:null;this.envMap=b.envMap!==undefined?b.envMap:null;this.combine=b.combine!==undefined?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==undefined?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==undefined?b.refractionRatio:0.98;this.shading=
b.shading!==undefined?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==undefined?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==undefined?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==undefined?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==undefined?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==undefined?b.vertexColors:!1;this.skinning=b.skinning!==undefined?b.skinning:!1;this.morphTargets=b.morphTargets!==undefined?
b.morphTargets:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==undefined?new THREE.Color(b.color):new THREE.Color(16777215);this.ambient=b.ambient!==undefined?new THREE.Color(b.ambient):new THREE.Color(328965);this.specular=b.specular!==undefined?new THREE.Color(b.specular):new THREE.Color(1118481);this.shininess=b.shininess!==undefined?b.shininess:30;this.map=b.map!==undefined?b.map:null;this.lightMap=b.lightMap!==undefined?b.lightMap:null;this.envMap=b.envMap!==undefined?
b.envMap:null;this.combine=b.combine!==undefined?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==undefined?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==undefined?b.refractionRatio:0.98;this.shading=b.shading!==undefined?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==undefined?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==undefined?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==undefined?b.wireframeLinecap:"round";this.wireframeLinejoin=
b.wireframeLinejoin!==undefined?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==undefined?b.vertexColors:!1;this.skinning=b.skinning!==undefined?b.skinning:!1;this.morphTargets=b.morphTargets!==undefined?b.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.shading=b.shading!==undefined?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==undefined?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==undefined?b.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.shading=b.shading?b.shading:THREE.FlatShading;this.wireframe=b.wireframe?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth?b.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.MeshShaderMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.fragmentShader=b.fragmentShader!==undefined?b.fragmentShader:"void main() {}";this.vertexShader=b.vertexShader!==undefined?b.vertexShader:"void main() {}";this.uniforms=b.uniforms!==undefined?b.uniforms:{};this.attributes=b.attributes;this.shading=b.shading!==undefined?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==undefined?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==undefined?b.wireframeLinewidth:
1;this.fog=b.fog!==undefined?b.fog:!1;this.lights=b.lights!==undefined?b.lights:!1;this.vertexColors=b.vertexColors!==undefined?b.vertexColors:!1;this.skinning=b.skinning!==undefined?b.skinning:!1;this.morphTargets=b.morphTargets!==undefined?b.morphTargets:!1};THREE.MeshShaderMaterial.prototype=new THREE.Material;THREE.MeshShaderMaterial.prototype.constructor=THREE.MeshShaderMaterial;
THREE.ShadowVolumeDynamicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==undefined?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==undefined?b.map:null;this.lightMap=b.lightMap!==undefined?b.lightMap:null;this.envMap=b.envMap!==undefined?b.envMap:null;this.combine=b.combine!==undefined?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==undefined?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==undefined?b.refractionRatio:
0.98;this.shading=b.shading!==undefined?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==undefined?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==undefined?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==undefined?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==undefined?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==undefined?b.vertexColors:!1;this.skinning=b.skinning!==undefined?b.skinning:!1;this.morphTargets=b.morphTargets!==
undefined?b.morphTargets:!1};THREE.ShadowVolumeDynamicMaterial.prototype=new THREE.Material;THREE.ShadowVolumeDynamicMaterial.prototype.constructor=THREE.ShadowVolumeDynamicMaterial;
THREE.ParticleBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==undefined?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==undefined?b.map:null;this.size=b.size!==undefined?b.size:1;this.sizeAttenuation=b.sizeAttenuation!==undefined?b.sizeAttenuation:!0;this.vertexColors=b.vertexColors!==undefined?b.vertexColors:!1};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ParticleCanvasMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==undefined?new THREE.Color(b.color):new THREE.Color(16777215);this.program=b.program!==undefined?b.program:function(){}};THREE.ParticleCanvasMaterial.prototype=new THREE.Material;THREE.ParticleCanvasMaterial.prototype.constructor=THREE.ParticleCanvasMaterial;THREE.ParticleDOMMaterial=function(b){THREE.Material.call(this);this.domElement=b};
THREE.Texture=function(b,d,c,f,g,h){this.image=b;this.mapping=d!==undefined?d:new THREE.UVMapping;this.wrapS=c!==undefined?c:THREE.ClampToEdgeWrapping;this.wrapT=f!==undefined?f:THREE.ClampToEdgeWrapping;this.magFilter=g!==undefined?g:THREE.LinearFilter;this.minFilter=h!==undefined?h:THREE.LinearMipMapLinearFilter;this.needsUpdate=!1};THREE.Texture.prototype={clone:function(){return new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter)}};
THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;
THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.Particle=function(b){THREE.Object3D.call(this);this.materials=b instanceof Array?b:[b];this.matrixAutoUpdate=!1};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.ParticleSystem=function(b,d){THREE.Object3D.call(this);this.geometry=b;this.materials=d instanceof Array?d:[d];this.sortParticles=!1};THREE.ParticleSystem.prototype=new THREE.Object3D;
THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;THREE.Line=function(b,d,c){THREE.Object3D.call(this);this.geometry=b;this.materials=d instanceof Array?d:[d];this.type=c!=undefined?c:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(b,d){THREE.Object3D.call(this);this.geometry=b;this.materials=d&&d.length?d:[d];this.flipSided=!1;this.doubleSided=!1;this.overdraw=!1;if(this.geometry){this.geometry.boundingSphere||this.geometry.computeBoundingSphere();this.boundRadius=b.boundingSphere.radius;if(this.geometry.morphTargets.length){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++){this.morphTargetInfluences.push(0);
this.morphTargetDictionary[this.geometry.morphTargets[c].name]=c}}}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(b){if(this.morphTargetDictionary[b]!==undefined)return this.morphTargetDictionary[b];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+b+" does not exist. Returning 0.");return 0};
THREE.Bone=function(b){THREE.Object3D.call(this);this.skin=b;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(b,d,c){this.matrixAutoUpdate&&(d|=this.updateMatrix());if(d||this.matrixWorldNeedsUpdate){b?this.skinMatrix.multiply(b,this.matrix):this.skinMatrix.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;d=!0}var f,g=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(f=0;f<g;f++){b=this.children[f];b instanceof THREE.Bone?b.update(this.skinMatrix,d,c):b.update(this.matrixWorld,!0,c)}}else for(f=0;f<g;f++)this.children[f].update(this.skinMatrix,
d,c)};THREE.Bone.prototype.addChild=function(b){if(this.children.indexOf(b)===-1){b.parent!==undefined&&b.parent.removeChild(b);b.parent=this;this.children.push(b);if(!(b instanceof THREE.Bone))this.hasNoneBoneChildren=!0}};
THREE.SkinnedMesh=function(b,d){THREE.Mesh.call(this,b,d);this.identityMatrix=new THREE.Matrix4;this.bones=[];this.boneMatrices=[];var c,f,g,h,j,k;if(this.geometry.bones!==undefined){for(c=0;c<this.geometry.bones.length;c++){g=this.geometry.bones[c];h=g.pos;j=g.rotq;k=g.scl;f=this.addBone();f.name=g.name;f.position.set(h[0],h[1],h[2]);f.quaternion.set(j[0],j[1],j[2],j[3]);f.useQuaternion=!0;k!==undefined?f.scale.set(k[0],k[1],k[2]):f.scale.set(1,1,1)}for(c=0;c<this.bones.length;c++){g=this.geometry.bones[c];
f=this.bones[c];g.parent===-1?this.addChild(f):this.bones[g.parent].addChild(f)}this.boneMatrices=new Float32Array(16*this.bones.length);this.pose()}};THREE.SkinnedMesh.prototype=new THREE.Mesh;THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;
THREE.SkinnedMesh.prototype.update=function(b,d,c){if(this.visible){this.matrixAutoUpdate&&(d|=this.updateMatrix());if(d||this.matrixWorldNeedsUpdate){b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;d=!0}var f,g=this.children.length;for(f=0;f<g;f++){b=this.children[f];b instanceof THREE.Bone?b.update(this.identityMatrix,!1,c):b.update(this.matrixWorld,d,c)}c=this.bones.length;ba=this.bones;bm=this.boneMatrices;for(d=0;d<c;d++)ba[d].skinMatrix.flattenToArrayOffset(bm,
d*16)}};THREE.SkinnedMesh.prototype.addBone=function(b){b===undefined&&(b=new THREE.Bone(this));this.bones.push(b);return b};
THREE.SkinnedMesh.prototype.pose=function(){this.update(undefined,!0);for(var b,d=[],c=0;c<this.bones.length;c++){b=this.bones[c];d.push(THREE.Matrix4.makeInvert(b.skinMatrix));b.skinMatrix.flattenToArrayOffset(this.boneMatrices,c*16)}if(this.geometry.skinVerticesA===undefined){this.geometry.skinVerticesA=[];this.geometry.skinVerticesB=[];var f;for(b=0;b<this.geometry.skinIndices.length;b++){c=this.geometry.vertices[b].position;var g=this.geometry.skinIndices[b].x,h=this.geometry.skinIndices[b].y;
f=new THREE.Vector3(c.x,c.y,c.z);this.geometry.skinVerticesA.push(d[g].multiplyVector3(f));f=new THREE.Vector3(c.x,c.y,c.z);this.geometry.skinVerticesB.push(d[h].multiplyVector3(f));if(this.geometry.skinWeights[b].x+this.geometry.skinWeights[b].y!==1){c=(1-(this.geometry.skinWeights[b].x+this.geometry.skinWeights[b].y))*0.5;this.geometry.skinWeights[b].x+=c;this.geometry.skinWeights[b].y+=c}}}};
THREE.Ribbon=function(b,d){THREE.Object3D.call(this);this.geometry=b;this.materials=d instanceof Array?d:[d];this.flipSided=!1;this.doubleSided=!1};THREE.Ribbon.prototype=new THREE.Object3D;THREE.Ribbon.prototype.constructor=THREE.Ribbon;
THREE.Sound=function(b,d,c,f){THREE.Object3D.call(this);this.isLoaded=!1;this.isAddedToDOM=!1;this.isPlaying=!1;this.duration=-1;this.radius=d!==undefined?Math.abs(d):100;this.volume=Math.min(1,Math.max(0,c!==undefined?c:1));this.domElement=document.createElement("audio");this.domElement.volume=0;this.domElement.pan=0;this.domElement.loop=f!==undefined?f:!0;this.sources=b instanceof Array?b:[b];var g;c=this.sources.length;for(b=0;b<c;b++){d=this.sources[b];d.toLowerCase();if(d.indexOf(".mp3")!==-1)g=
"audio/mpeg";else if(d.indexOf(".ogg")!==-1)g="audio/ogg";else d.indexOf(".wav")!==-1&&(g="audio/wav");if(this.domElement.canPlayType(g)){g=document.createElement("source");g.src=this.sources[b];this.domElement.THREESound=this;this.domElement.appendChild(g);this.domElement.addEventListener("canplay",this.onLoad,!0);this.domElement.load();break}}};THREE.Sound.prototype=new THREE.Object3D;THREE.Sound.prototype.constructor=THREE.Sound;THREE.Sound.prototype.supr=THREE.Object3D.prototype;
THREE.Sound.prototype.onLoad=function(){var b=this.THREESound;if(!b.isLoaded){this.removeEventListener("canplay",this.onLoad,!0);b.isLoaded=!0;b.duration=this.duration;b.isPlaying&&b.play()}};THREE.Sound.prototype.addToDOM=function(b){this.isAddedToDOM=!0;b.appendChild(this.domElement)};THREE.Sound.prototype.play=function(b){this.isPlaying=!0;if(this.isLoaded){this.domElement.play();if(b)this.domElement.currentTime=b%this.duration}};THREE.Sound.prototype.pause=function(){this.isPlaying=!1;this.domElement.pause()};
THREE.Sound.prototype.stop=function(){this.isPlaying=!1;this.domElement.pause();this.domElement.currentTime=0};THREE.Sound.prototype.calculateVolumeAndPan=function(b){b=b.length();this.domElement.volume=b<=this.radius?this.volume*(1-b/this.radius):0};
THREE.Sound.prototype.update=function(b,d,c){if(this.matrixAutoUpdate){this.matrix.setPosition(this.position);d=!0}if(d||this.matrixWorldNeedsUpdate){b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;d=!0}var f=this.children.length;for(b=0;b<f;b++)this.children[b].update(this.matrixWorld,d,c)};THREE.LOD=function(){THREE.Object3D.call(this);this.LODs=[]};THREE.LOD.prototype=new THREE.Object3D;THREE.LOD.prototype.constructor=THREE.LOD;
THREE.LOD.prototype.supr=THREE.Object3D.prototype;THREE.LOD.prototype.add=function(b,d){d===undefined&&(d=0);d=Math.abs(d);for(var c=0;c<this.LODs.length;c++)if(d<this.LODs[c].visibleAtDistance)break;this.LODs.splice(c,0,{visibleAtDistance:d,object3D:b});this.addChild(b)};
THREE.LOD.prototype.update=function(b,d,c){this.matrixAutoUpdate&&(d|=this.updateMatrix());if(d||this.matrixWorldNeedsUpdate){b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;d=!0}if(this.LODs.length>1){b=c.matrixWorldInverse;b=-(b.n31*this.position.x+b.n32*this.position.y+b.n33*this.position.z+b.n34);this.LODs[0].object3D.visible=!0;for(var f=1;f<this.LODs.length;f++)if(b>=this.LODs[f].visibleAtDistance){this.LODs[f-1].object3D.visible=
!1;this.LODs[f].object3D.visible=!0}else break;for(;f<this.LODs.length;f++)this.LODs[f].object3D.visible=!1}for(b=0;b<this.children.length;b++)this.children[b].update(this.matrixWorld,d,c)};THREE.ShadowVolume=function(b,d){if(b instanceof THREE.Mesh){THREE.Mesh.call(this,b.geometry,d?[new THREE.ShadowVolumeDynamicMaterial]:[new THREE.ShadowVolumeDynamicMaterial]);b.addChild(this)}else THREE.Mesh.call(this,b,d?[new THREE.ShadowVolumeDynamicMaterial]:[new THREE.ShadowVolumeDynamicMaterial]);this.calculateShadowVolumeGeometry()};
THREE.ShadowVolume.prototype=new THREE.Mesh;THREE.ShadowVolume.prototype.constructor=THREE.ShadowVolume;THREE.ShadowVolume.prototype.supr=THREE.Mesh.prototype;
THREE.ShadowVolume.prototype.calculateShadowVolumeGeometry=function(){if(this.geometry.edges&&this.geometry.edges.length){var b,d,c,f,g,h,j,k,m,p,o,u,y,t,B=new THREE.Geometry;B.vertices=this.geometry.vertices;f=B.faces=this.geometry.faces;var F=B.egdes=this.geometry.edges,H=B.edgeFaces=[];g=0;var G=[];b=0;for(d=f.length;b<d;b++){c=f[b];G.push(g);g+=c instanceof THREE.Face3?3:4;c.vertexNormals[0]=c.normal;c.vertexNormals[1]=c.normal;c.vertexNormals[2]=c.normal;if(c instanceof THREE.Face4)c.vertexNormals[3]=
c.normal}b=0;for(d=F.length;b<d;b++){k=F[b];c=k.faces[0];f=k.faces[1];g=k.faceIndices[0];h=k.faceIndices[1];j=k.vertexIndices[0];k=k.vertexIndices[1];if(c.a===j){m="a";o=G[g]+0}else if(c.b===j){m="b";o=G[g]+1}else if(c.c===j){m="c";o=G[g]+2}else if(c.d===j){m="d";o=G[g]+3}if(c.a===k){m+="a";u=G[g]+0}else if(c.b===k){m+="b";u=G[g]+1}else if(c.c===k){m+="c";u=G[g]+2}else if(c.d===k){m+="d";u=G[g]+3}if(f.a===j){p="a";y=G[h]+0}else if(f.b===j){p="b";y=G[h]+1}else if(f.c===j){p="c";y=G[h]+2}else if(f.d===
j){p="d";y=G[h]+3}if(f.a===k){p+="a";t=G[h]+0}else if(f.b===k){p+="b";t=G[h]+1}else if(f.c===k){p+="c";t=G[h]+2}else if(f.d===k){p+="d";t=G[h]+3}if(m==="ac"||m==="ad"||m==="ca"||m==="da"){if(o>u){c=o;o=u;u=c}}else if(o<u){c=o;o=u;u=c}if(p==="ac"||p==="ad"||p==="ca"||p==="da"){if(y>t){c=y;y=t;t=c}}else if(y<t){c=y;y=t;t=c}c=new THREE.Face4(o,u,y,t);c.normal.set(1,0,0);H.push(c)}this.geometry=B}else this.calculateShadowVolumeGeometryWithoutEdgeInfo(this.geometry)};
THREE.ShadowVolume.prototype.calculateShadowVolumeGeometryWithoutEdgeInfo=function(b){this.geometry=new THREE.Geometry;this.geometry.boundingSphere=b.boundingSphere;this.geometry.edgeFaces=[];var d=this.geometry.vertices,c=this.geometry.faces,f=this.geometry.edgeFaces,g=b.faces;b=b.vertices;var h=g.length,j,k,m,p,o,u=["a","b","c","d"];for(m=0;m<h;m++){k=d.length;j=g[m];if(j instanceof THREE.Face4){p=4;k=new THREE.Face4(k,k+1,k+2,k+3)}else{p=3;k=new THREE.Face3(k,k+1,k+2)}k.normal.copy(j.normal);c.push(k);
for(k=0;k<p;k++){o=b[j[u[k]]];d.push(new THREE.Vertex(o.position.clone()))}}for(h=0;h<g.length-1;h++){b=c[h];for(j=h+1;j<g.length;j++){k=c[j];k=this.facesShareEdge(d,b,k);if(k!==undefined){k=new THREE.Face4(k.indices[0],k.indices[3],k.indices[2],k.indices[1]);k.normal.set(1,0,0);f.push(k)}}}};
THREE.ShadowVolume.prototype.facesShareEdge=function(b,d,c){var f,g,h,j,k,m,p,o,u,y,t,B,F,H=0,G=["a","b","c","d"];f=d instanceof THREE.Face4?4:3;g=c instanceof THREE.Face4?4:3;for(B=0;B<f;B++){h=d[G[B]];k=b[h];for(F=0;F<g;F++){j=c[G[F]];m=b[j];if(Math.abs(k.position.x-m.position.x)<1.0E-4&&Math.abs(k.position.y-m.position.y)<1.0E-4&&Math.abs(k.position.z-m.position.z)<1.0E-4){H++;if(H===1){p=k;o=m;u=h;y=j;t=G[B]}if(H===2){t+=G[B];return t==="ad"||t==="ac"?{faces:[d,c],vertices:[p,o,m,k],indices:[u,
y,j,h],vertexTypes:[1,2,2,1],extrudable:!0}:{faces:[d,c],vertices:[p,k,m,o],indices:[u,h,j,y],vertexTypes:[1,1,2,2],extrudable:!0}}}}}};
THREE.Sprite=function(b){THREE.Object3D.call(this);if(b.material!==undefined){this.material=b.material;this.map=undefined;this.blending=material.blending}else if(b.map!==undefined){this.map=b.map instanceof THREE.Texture?b.map:ImageUtils.loadTexture(b.map);this.material=undefined;this.blending=b.blending!==undefined?b.blending:THREE.NormalBlending}this.useScreenCoordinates=b.useScreenCoordinates!==undefined?b.useScreenCoordinates:!0;this.mergeWith3D=b.mergeWith3D!==undefined?b.mergeWith3D:!this.useScreenCoordinates;
this.affectedByDistance=b.affectedByDistance!==undefined?b.affectedByDistance:!this.useScreenCoordinates;this.alignment=b.alignment instanceof THREE.Vector2?b.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;THREE.Sprite.prototype.supr=THREE.Object3D.prototype;
THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(this.scale.x!==1||this.scale.y!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,this.scale.y)}this.matrixWorldNeedsUpdate=!0};THREE.SpriteAlignment={};THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);
THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);
THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.fog=null;this.objects=[];this.lights=[];this.sounds=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(b){this.supr.addChild.call(this,b);this.addChildRecurse(b)};
THREE.Scene.prototype.addChildRecurse=function(b){if(b instanceof THREE.Light)this.lights.indexOf(b)===-1&&this.lights.push(b);else if(b instanceof THREE.Sound)this.sounds.indexOf(b)===-1&&this.sounds.push(b);else if(!(b instanceof THREE.Camera||b instanceof THREE.Bone)&&this.objects.indexOf(b)===-1){this.objects.push(b);this.__objectsAdded.push(b)}for(var d=0;d<b.children.length;d++)this.addChildRecurse(b.children[d])};
THREE.Scene.prototype.removeChild=function(b){this.supr.removeChild.call(this,b);this.removeChildRecurse(b)};THREE.Scene.prototype.removeChildRecurse=function(b){if(b instanceof THREE.Light){var d=this.lights.indexOf(b);d!==-1&&this.lights.splice(d,1)}else if(b instanceof THREE.Sound){d=this.sounds.indexOf(b);d!==-1&&this.sounds.splice(d,1)}else if(!(b instanceof THREE.Camera)){d=this.objects.indexOf(b);if(d!==-1){this.objects.splice(d,1);this.__objectsRemoved.push(b)}}for(d=0;d<b.children.length;d++)this.removeChildRecurse(b.children[d])};
THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;THREE.Fog=function(b,d,c){this.color=new THREE.Color(b);this.near=d||1;this.far=c||1E3};THREE.FogExp2=function(b,d){this.color=new THREE.Color(b);this.density=d!==undefined?d:2.5E-4};
THREE.Projector=function(){function b(){var e=m[k]=m[k]||new THREE.RenderableVertex;k++;return e}function d(e,ea){return ea.z-e.z}function c(e,ea){var ya=0,Ba=1,Fa=e.z+e.w,Z=ea.z+ea.w,oa=-e.z+e.w,pa=-ea.z+ea.w;if(Fa>=0&&Z>=0&&oa>=0&&pa>=0)return!0;else if(Fa<0&&Z<0||oa<0&&pa<0)return!1;else{if(Fa<0)ya=Math.max(ya,Fa/(Fa-Z));else Z<0&&(Ba=Math.min(Ba,Fa/(Fa-Z)));if(oa<0)ya=Math.max(ya,oa/(oa-pa));else pa<0&&(Ba=Math.min(Ba,oa/(oa-pa)));if(Ba<ya)return!1;else{e.lerpSelf(ea,ya);ea.lerpSelf(e,1-Ba);return!0}}}
var f,g,h=[],j,k,m=[],p,o,u=[],y,t=[],B,F,H=[],G,X,A=[],M=new THREE.Vector4,Q=new THREE.Vector4,R=new THREE.Matrix4,Da=new THREE.Matrix4,ma=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],va=new THREE.Vector4,ca=new THREE.Vector4;this.projectVector=function(e,ea){R.multiply(ea.projectionMatrix,ea.matrixWorldInverse);R.multiplyVector3(e);return e};this.unprojectVector=function(e,ea){R.multiply(ea.matrixWorld,THREE.Matrix4.makeInvert(ea.projectionMatrix));
R.multiplyVector3(e);return e};this.projectObjects=function(e,ea,ya){ea=[];var Ba,Fa,Z;g=0;Fa=e.objects;e=0;for(Ba=Fa.length;e<Ba;e++){Z=Fa[e];var oa;if(!(oa=!Z.visible))if(oa=Z instanceof THREE.Mesh){a:{oa=void 0;for(var pa=Z.matrixWorld,sa=-Z.geometry.boundingSphere.radius*Math.max(Z.scale.x,Math.max(Z.scale.y,Z.scale.z)),ga=0;ga<6;ga++){oa=ma[ga].x*pa.n14+ma[ga].y*pa.n24+ma[ga].z*pa.n34+ma[ga].w;if(oa<=sa){oa=!1;break a}}oa=!0}oa=!oa}if(!oa){oa=h[g]=h[g]||new THREE.RenderableObject;g++;f=oa;M.copy(Z.position);
R.multiplyVector3(M);f.object=Z;f.z=M.z;ea.push(f)}}ya&&ea.sort(d);return ea};this.projectScene=function(e,ea,ya){var Ba=[],Fa=ea.near,Z=ea.far,oa,pa,sa,ga,aa,na,Ea,ja,la,ua,Ra,Ya,Za,Na,T,P,N;X=F=y=o=0;ea.matrixAutoUpdate&&ea.updateMatrix();e.update(undefined,!1,ea);R.multiply(ea.projectionMatrix,ea.matrixWorldInverse);ma[0].set(R.n41-R.n11,R.n42-R.n12,R.n43-R.n13,R.n44-R.n14);ma[1].set(R.n41+R.n11,R.n42+R.n12,R.n43+R.n13,R.n44+R.n14);ma[2].set(R.n41+R.n21,R.n42+R.n22,R.n43+R.n23,R.n44+R.n24);ma[3].set(R.n41-
R.n21,R.n42-R.n22,R.n43-R.n23,R.n44-R.n24);ma[4].set(R.n41-R.n31,R.n42-R.n32,R.n43-R.n33,R.n44-R.n34);ma[5].set(R.n41+R.n31,R.n42+R.n32,R.n43+R.n33,R.n44+R.n34);for(oa=0;oa<6;oa++){la=ma[oa];la.divideScalar(Math.sqrt(la.x*la.x+la.y*la.y+la.z*la.z))}la=this.projectObjects(e,ea,!0);e=0;for(oa=la.length;e<oa;e++){ua=la[e].object;if(ua.visible){Ra=ua.matrixWorld;Ya=ua.matrixRotationWorld;Za=ua.materials;Na=ua.overdraw;k=0;if(ua instanceof THREE.Mesh){T=ua.geometry;ga=T.vertices;P=T.faces;T=T.faceVertexUvs;
pa=0;for(sa=ga.length;pa<sa;pa++){j=b();j.positionWorld.copy(ga[pa].position);Ra.multiplyVector3(j.positionWorld);j.positionScreen.copy(j.positionWorld);R.multiplyVector4(j.positionScreen);j.positionScreen.x/=j.positionScreen.w;j.positionScreen.y/=j.positionScreen.w;j.visible=j.positionScreen.z>Fa&&j.positionScreen.z<Z}ga=0;for(pa=P.length;ga<pa;ga++){sa=P[ga];if(sa instanceof THREE.Face3){aa=m[sa.a];na=m[sa.b];Ea=m[sa.c];if(aa.visible&&na.visible&&Ea.visible&&(ua.doubleSided||ua.flipSided!=(Ea.positionScreen.x-
aa.positionScreen.x)*(na.positionScreen.y-aa.positionScreen.y)-(Ea.positionScreen.y-aa.positionScreen.y)*(na.positionScreen.x-aa.positionScreen.x)<0)){ja=u[o]=u[o]||new THREE.RenderableFace3;o++;p=ja;p.v1.copy(aa);p.v2.copy(na);p.v3.copy(Ea)}else continue}else if(sa instanceof THREE.Face4){aa=m[sa.a];na=m[sa.b];Ea=m[sa.c];ja=m[sa.d];if(aa.visible&&na.visible&&Ea.visible&&ja.visible&&(ua.doubleSided||ua.flipSided!=((ja.positionScreen.x-aa.positionScreen.x)*(na.positionScreen.y-aa.positionScreen.y)-
(ja.positionScreen.y-aa.positionScreen.y)*(na.positionScreen.x-aa.positionScreen.x)<0||(na.positionScreen.x-Ea.positionScreen.x)*(ja.positionScreen.y-Ea.positionScreen.y)-(na.positionScreen.y-Ea.positionScreen.y)*(ja.positionScreen.x-Ea.positionScreen.x)<0))){N=t[y]=t[y]||new THREE.RenderableFace4;y++;p=N;p.v1.copy(aa);p.v2.copy(na);p.v3.copy(Ea);p.v4.copy(ja)}else continue}p.normalWorld.copy(sa.normal);Ya.multiplyVector3(p.normalWorld);p.centroidWorld.copy(sa.centroid);Ra.multiplyVector3(p.centroidWorld);
p.centroidScreen.copy(p.centroidWorld);R.multiplyVector3(p.centroidScreen);Ea=sa.vertexNormals;aa=0;for(na=Ea.length;aa<na;aa++){ja=p.vertexNormalsWorld[aa];ja.copy(Ea[aa]);Ya.multiplyVector3(ja)}aa=0;for(na=T.length;aa<na;aa++)if(N=T[aa][ga]){Ea=0;for(ja=N.length;Ea<ja;Ea++)p.uvs[aa][Ea]=N[Ea]}p.meshMaterials=Za;p.faceMaterials=sa.materials;p.overdraw=Na;p.z=p.centroidScreen.z;Ba.push(p)}}else if(ua instanceof THREE.Line){Da.multiply(R,Ra);ga=ua.geometry.vertices;aa=b();aa.positionScreen.copy(ga[0].position);
Da.multiplyVector4(aa.positionScreen);pa=1;for(sa=ga.length;pa<sa;pa++){aa=b();aa.positionScreen.copy(ga[pa].position);Da.multiplyVector4(aa.positionScreen);na=m[k-2];va.copy(aa.positionScreen);ca.copy(na.positionScreen);if(c(va,ca)){va.multiplyScalar(1/va.w);ca.multiplyScalar(1/ca.w);Ra=H[F]=H[F]||new THREE.RenderableLine;F++;B=Ra;B.v1.positionScreen.copy(va);B.v2.positionScreen.copy(ca);B.z=Math.max(va.z,ca.z);B.materials=ua.materials;Ba.push(B)}}}else if(ua instanceof THREE.Particle){Q.set(ua.position.x,
ua.position.y,ua.position.z,1);R.multiplyVector4(Q);Q.z/=Q.w;if(Q.z>0&&Q.z<1){Ra=A[X]=A[X]||new THREE.RenderableParticle;X++;G=Ra;G.x=Q.x/Q.w;G.y=Q.y/Q.w;G.z=Q.z;G.rotation=ua.rotation.z;G.scale.x=ua.scale.x*Math.abs(G.x-(Q.x+ea.projectionMatrix.n11)/(Q.w+ea.projectionMatrix.n14));G.scale.y=ua.scale.y*Math.abs(G.y-(Q.y+ea.projectionMatrix.n22)/(Q.w+ea.projectionMatrix.n24));G.materials=ua.materials;Ba.push(G)}}}}ya&&Ba.sort(d);return Ba}};
THREE.DOMRenderer=function(){THREE.Renderer.call(this);var b=null,d=new THREE.Projector,c,f,g,h;this.domElement=document.createElement("div");this.setSize=function(j,k){c=j;f=k;g=c/2;h=f/2};this.render=function(j,k){var m,p,o,u,y,t,B,F;b=d.projectScene(j,k);m=0;for(p=b.length;m<p;m++){y=b[m];if(y instanceof THREE.RenderableParticle){B=y.x*g+g;F=y.y*h+h;o=0;for(u=y.material.length;o<u;o++){t=y.material[o];if(t instanceof THREE.ParticleDOMMaterial){t=t.domElement;t.style.left=B+"px";t.style.top=F+"px"}}}}}};
THREE.CanvasRenderer=function(){function b(ta){if(t!=ta)o.globalAlpha=t=ta}function d(ta){if(B!=ta){switch(ta){case THREE.NormalBlending:o.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:o.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:o.globalCompositeOperation="darker"}B=ta}}function c(ta){if(F!=ta)o.strokeStyle=F=ta}var f=null,g=new THREE.Projector,h=document.createElement("canvas"),j,k,m,p,o=h.getContext("2d"),u=new THREE.Color(0),y=0,t=1,B=0,
F=null,H=null,G=null,X=null,A=null,M,Q,R,Da,ma=new THREE.RenderableVertex,va=new THREE.RenderableVertex,ca,e,ea,ya,Ba,Fa,Z,oa,pa,sa,ga,aa,na=new THREE.Color,Ea=new THREE.Color,ja=new THREE.Color,la=new THREE.Color,ua=new THREE.Color,Ra,Ya,Za,Na,T,P,N,Ca,Ka,n,C=new THREE.Rectangle,w=new THREE.Rectangle,x=new THREE.Rectangle,z=!1,J=new THREE.Color,K=new THREE.Color,I=new THREE.Color,S=new THREE.Color,D=new THREE.Vector3,O,L,$,V,xa,Ja,za=16;O=document.createElement("canvas");O.width=O.height=2;L=O.getContext("2d");
L.fillStyle="rgba(0,0,0,1)";L.fillRect(0,0,2,2);$=L.getImageData(0,0,2,2);V=$.data;xa=document.createElement("canvas");xa.width=xa.height=za;Ja=xa.getContext("2d");Ja.translate(-za/2,-za/2);Ja.scale(za,za);za--;this.domElement=h;this.autoClear=!0;this.sortObjects=!0;this.sortElements=!0;this.setSize=function(ta,Oa){j=ta;k=Oa;m=j/2;p=k/2;h.width=j;h.height=k;C.set(-m,-p,m,p);t=1;B=0;A=X=G=H=F=null};this.setClearColor=function(ta,Oa){u=ta;y=Oa};this.setClearColorHex=function(ta,Oa){u.setHex(ta);y=Oa};
this.clear=function(){o.setTransform(1,0,0,-1,m,p);if(!w.isEmpty()){w.inflate(1);w.minSelf(C);if(u.hex==0&&y==0)o.clearRect(w.getX(),w.getY(),w.getWidth(),w.getHeight());else{d(THREE.NormalBlending);b(1);o.fillStyle="rgba("+Math.floor(u.r*255)+","+Math.floor(u.g*255)+","+Math.floor(u.b*255)+","+y+")";o.fillRect(w.getX(),w.getY(),w.getWidth(),w.getHeight())}w.empty()}};this.render=function(ta,Oa){function Ga(W){var ia,ka,da,ra=W.lights;K.setRGB(0,0,0);I.setRGB(0,0,0);S.setRGB(0,0,0);W=0;for(ia=ra.length;W<
ia;W++){ka=ra[W];da=ka.color;if(ka instanceof THREE.AmbientLight){K.r+=da.r;K.g+=da.g;K.b+=da.b}else if(ka instanceof THREE.DirectionalLight){I.r+=da.r;I.g+=da.g;I.b+=da.b}else if(ka instanceof THREE.PointLight){S.r+=da.r;S.g+=da.g;S.b+=da.b}}}function wa(W,ia,ka,da){var ra,qa,ha,Y,Ia=W.lights;W=0;for(ra=Ia.length;W<ra;W++){qa=Ia[W];ha=qa.color;if(qa instanceof THREE.DirectionalLight){Y=ka.dot(qa.position);if(!(Y<=0)){Y*=qa.intensity;da.r+=ha.r*Y;da.g+=ha.g*Y;da.b+=ha.b*Y}}else if(qa instanceof THREE.PointLight){Y=
ka.dot(D.sub(qa.position,ia).normalize());if(!(Y<=0)){Y*=qa.distance==0?1:1-Math.min(ia.distanceTo(qa.position)/qa.distance,1);if(Y!=0){Y*=qa.intensity;da.r+=ha.r*Y;da.g+=ha.g*Y;da.b+=ha.b*Y}}}}}function Ha(W,ia,ka){b(ka.opacity);d(ka.blending);var da,ra,qa,ha,Y,Ia;if(ka instanceof THREE.ParticleBasicMaterial){if(ka.map){ha=ka.map.image;Y=ha.width>>1;Ia=ha.height>>1;ka=ia.scale.x*m;qa=ia.scale.y*p;da=ka*Y;ra=qa*Ia;x.set(W.x-da,W.y-ra,W.x+da,W.y+ra);if(C.instersects(x)){o.save();o.translate(W.x,W.y);
o.rotate(-ia.rotation);o.scale(ka,-qa);o.translate(-Y,-Ia);o.drawImage(ha,0,0);o.restore()}}}else if(ka instanceof THREE.ParticleCanvasMaterial){da=ia.scale.x*m;ra=ia.scale.y*p;x.set(W.x-da,W.y-ra,W.x+da,W.y+ra);if(C.instersects(x)){c(ka.color.__styleString);qa=ka.color.__styleString;if(H!=qa)o.fillStyle=H=qa;o.save();o.translate(W.x,W.y);o.rotate(-ia.rotation);o.scale(da,ra);ka.program(o);o.restore()}}}function Ua(W,ia,ka,da){b(da.opacity);d(da.blending);o.beginPath();o.moveTo(W.positionScreen.x,
W.positionScreen.y);o.lineTo(ia.positionScreen.x,ia.positionScreen.y);o.closePath();if(da instanceof THREE.LineBasicMaterial){na.__styleString=da.color.__styleString;W=da.linewidth;if(G!=W)o.lineWidth=G=W;W=da.linecap;if(X!=W)o.lineCap=X=W;W=da.linejoin;if(A!=W)o.lineJoin=A=W;c(na.__styleString);o.stroke();x.inflate(da.linewidth*2)}}function E(W,ia,ka,da,ra,qa,ha,Y,Ia){b(Y.opacity);d(Y.blending);ca=W.positionScreen.x;e=W.positionScreen.y;ea=ia.positionScreen.x;ya=ia.positionScreen.y;Ba=ka.positionScreen.x;
Fa=ka.positionScreen.y;v(ca,e,ea,ya,Ba,Fa);if(Y instanceof THREE.MeshBasicMaterial)if(Y.map){if(Y.map.mapping instanceof THREE.UVMapping){Na=ha.uvs[0];Pa(ca,e,ea,ya,Ba,Fa,Y.map.image,Na[da].u,Na[da].v,Na[ra].u,Na[ra].v,Na[qa].u,Na[qa].v)}}else if(Y.envMap){if(Y.envMap.mapping instanceof THREE.SphericalReflectionMapping){W=Oa.matrixWorldInverse;D.copy(ha.vertexNormalsWorld[0]);T=(D.x*W.n11+D.y*W.n12+D.z*W.n13)*0.5+0.5;P=-(D.x*W.n21+D.y*W.n22+D.z*W.n23)*0.5+0.5;D.copy(ha.vertexNormalsWorld[1]);N=(D.x*
W.n11+D.y*W.n12+D.z*W.n13)*0.5+0.5;Ca=-(D.x*W.n21+D.y*W.n22+D.z*W.n23)*0.5+0.5;D.copy(ha.vertexNormalsWorld[2]);Ka=(D.x*W.n11+D.y*W.n12+D.z*W.n13)*0.5+0.5;n=-(D.x*W.n21+D.y*W.n22+D.z*W.n23)*0.5+0.5;Pa(ca,e,ea,ya,Ba,Fa,Y.envMap.image,T,P,N,Ca,Ka,n)}}else Y.wireframe?db(Y.color.__styleString,Y.wireframeLinewidth,Y.wireframeLinecap,Y.wireframeLinejoin):Ma(Y.color.__styleString);else if(Y instanceof THREE.MeshLambertMaterial){if(Y.map&&!Y.wireframe){if(Y.map.mapping instanceof THREE.UVMapping){Na=ha.uvs[0];
Pa(ca,e,ea,ya,Ba,Fa,Y.map.image,Na[da].u,Na[da].v,Na[ra].u,Na[ra].v,Na[qa].u,Na[qa].v)}d(THREE.SubtractiveBlending)}if(z)if(!Y.wireframe&&Y.shading==THREE.SmoothShading&&ha.vertexNormalsWorld.length==3){Ea.r=ja.r=la.r=K.r;Ea.g=ja.g=la.g=K.g;Ea.b=ja.b=la.b=K.b;wa(Ia,ha.v1.positionWorld,ha.vertexNormalsWorld[0],Ea);wa(Ia,ha.v2.positionWorld,ha.vertexNormalsWorld[1],ja);wa(Ia,ha.v3.positionWorld,ha.vertexNormalsWorld[2],la);ua.r=(ja.r+la.r)*0.5;ua.g=(ja.g+la.g)*0.5;ua.b=(ja.b+la.b)*0.5;Za=hb(Ea,ja,la,
ua);Pa(ca,e,ea,ya,Ba,Fa,Za,0,0,1,0,0,1)}else{J.r=K.r;J.g=K.g;J.b=K.b;wa(Ia,ha.centroidWorld,ha.normalWorld,J);na.r=Y.color.r*J.r;na.g=Y.color.g*J.g;na.b=Y.color.b*J.b;na.updateStyleString();Y.wireframe?db(na.__styleString,Y.wireframeLinewidth,Y.wireframeLinecap,Y.wireframeLinejoin):Ma(na.__styleString)}else Y.wireframe?db(Y.color.__styleString,Y.wireframeLinewidth,Y.wireframeLinecap,Y.wireframeLinejoin):Ma(Y.color.__styleString)}else if(Y instanceof THREE.MeshDepthMaterial){Ra=Oa.near;Ya=Oa.far;Ea.r=
Ea.g=Ea.b=1-eb(W.positionScreen.z,Ra,Ya);ja.r=ja.g=ja.b=1-eb(ia.positionScreen.z,Ra,Ya);la.r=la.g=la.b=1-eb(ka.positionScreen.z,Ra,Ya);ua.r=(ja.r+la.r)*0.5;ua.g=(ja.g+la.g)*0.5;ua.b=(ja.b+la.b)*0.5;Za=hb(Ea,ja,la,ua);Pa(ca,e,ea,ya,Ba,Fa,Za,0,0,1,0,0,1)}else if(Y instanceof THREE.MeshNormalMaterial){na.r=$a(ha.normalWorld.x);na.g=$a(ha.normalWorld.y);na.b=$a(ha.normalWorld.z);na.updateStyleString();Y.wireframe?db(na.__styleString,Y.wireframeLinewidth,Y.wireframeLinecap,Y.wireframeLinejoin):Ma(na.__styleString)}}
function fa(W,ia,ka,da,ra,qa,ha,Y,Ia){b(Y.opacity);d(Y.blending);if(Y.map||Y.envMap){E(W,ia,da,0,1,3,ha,Y,Ia);E(ra,ka,qa,1,2,3,ha,Y,Ia)}else{ca=W.positionScreen.x;e=W.positionScreen.y;ea=ia.positionScreen.x;ya=ia.positionScreen.y;Ba=ka.positionScreen.x;Fa=ka.positionScreen.y;Z=da.positionScreen.x;oa=da.positionScreen.y;pa=ra.positionScreen.x;sa=ra.positionScreen.y;ga=qa.positionScreen.x;aa=qa.positionScreen.y;if(Y instanceof THREE.MeshBasicMaterial){bb(ca,e,ea,ya,Ba,Fa,Z,oa);Y.wireframe?db(Y.color.__styleString,
Y.wireframeLinewidth,Y.wireframeLinecap,Y.wireframeLinejoin):Ma(Y.color.__styleString)}else if(Y instanceof THREE.MeshLambertMaterial)if(z)if(!Y.wireframe&&Y.shading==THREE.SmoothShading&&ha.vertexNormalsWorld.length==4){Ea.r=ja.r=la.r=ua.r=K.r;Ea.g=ja.g=la.g=ua.g=K.g;Ea.b=ja.b=la.b=ua.b=K.b;wa(Ia,ha.v1.positionWorld,ha.vertexNormalsWorld[0],Ea);wa(Ia,ha.v2.positionWorld,ha.vertexNormalsWorld[1],ja);wa(Ia,ha.v4.positionWorld,ha.vertexNormalsWorld[3],la);wa(Ia,ha.v3.positionWorld,ha.vertexNormalsWorld[2],
ua);Za=hb(Ea,ja,la,ua);v(ca,e,ea,ya,Z,oa);Pa(ca,e,ea,ya,Z,oa,Za,0,0,1,0,0,1);v(pa,sa,Ba,Fa,ga,aa);Pa(pa,sa,Ba,Fa,ga,aa,Za,1,0,1,1,0,1)}else{J.r=K.r;J.g=K.g;J.b=K.b;wa(Ia,ha.centroidWorld,ha.normalWorld,J);na.r=Y.color.r*J.r;na.g=Y.color.g*J.g;na.b=Y.color.b*J.b;na.updateStyleString();bb(ca,e,ea,ya,Ba,Fa,Z,oa);Y.wireframe?db(na.__styleString,Y.wireframeLinewidth,Y.wireframeLinecap,Y.wireframeLinejoin):Ma(na.__styleString)}else{bb(ca,e,ea,ya,Ba,Fa,Z,oa);Y.wireframe?db(Y.color.__styleString,Y.wireframeLinewidth,
Y.wireframeLinecap,Y.wireframeLinejoin):Ma(Y.color.__styleString)}else if(Y instanceof THREE.MeshNormalMaterial){na.r=$a(ha.normalWorld.x);na.g=$a(ha.normalWorld.y);na.b=$a(ha.normalWorld.z);na.updateStyleString();bb(ca,e,ea,ya,Ba,Fa,Z,oa);Y.wireframe?db(na.__styleString,Y.wireframeLinewidth,Y.wireframeLinecap,Y.wireframeLinejoin):Ma(na.__styleString)}else if(Y instanceof THREE.MeshDepthMaterial){Ra=Oa.near;Ya=Oa.far;Ea.r=Ea.g=Ea.b=1-eb(W.positionScreen.z,Ra,Ya);ja.r=ja.g=ja.b=1-eb(ia.positionScreen.z,
Ra,Ya);la.r=la.g=la.b=1-eb(da.positionScreen.z,Ra,Ya);ua.r=ua.g=ua.b=1-eb(ka.positionScreen.z,Ra,Ya);Za=hb(Ea,ja,la,ua);v(ca,e,ea,ya,Z,oa);Pa(ca,e,ea,ya,Z,oa,Za,0,0,1,0,0,1);v(pa,sa,Ba,Fa,ga,aa);Pa(pa,sa,Ba,Fa,ga,aa,Za,1,0,1,1,0,1)}}}function v(W,ia,ka,da,ra,qa){o.beginPath();o.moveTo(W,ia);o.lineTo(ka,da);o.lineTo(ra,qa);o.lineTo(W,ia);o.closePath()}function bb(W,ia,ka,da,ra,qa,ha,Y){o.beginPath();o.moveTo(W,ia);o.lineTo(ka,da);o.lineTo(ra,qa);o.lineTo(ha,Y);o.lineTo(W,ia);o.closePath()}function db(W,
ia,ka,da){if(G!=ia)o.lineWidth=G=ia;if(X!=ka)o.lineCap=X=ka;if(A!=da)o.lineJoin=A=da;c(W);o.stroke();x.inflate(ia*2)}function Ma(W){if(H!=W)o.fillStyle=H=W;o.fill()}function Pa(W,ia,ka,da,ra,qa,ha,Y,Ia,Va,Ta,ib,Wa){var fb,gb;fb=ha.width-1;gb=ha.height-1;Y*=fb;Ia*=gb;Va*=fb;Ta*=gb;ib*=fb;Wa*=gb;ka-=W;da-=ia;ra-=W;qa-=ia;Va-=Y;Ta-=Ia;ib-=Y;Wa-=Ia;fb=Va*Wa-ib*Ta;if(fb!=0){gb=1/fb;fb=(Wa*ka-Ta*ra)*gb;Ta=(Wa*da-Ta*qa)*gb;ka=(Va*ra-ib*ka)*gb;da=(Va*qa-ib*da)*gb;W=W-fb*Y-ka*Ia;ia=ia-Ta*Y-da*Ia;o.save();
o.transform(fb,Ta,ka,da,W,ia);o.clip();o.drawImage(ha,0,0);o.restore()}}function hb(W,ia,ka,da){var ra=~~(W.r*255),qa=~~(W.g*255);W=~~(W.b*255);var ha=~~(ia.r*255),Y=~~(ia.g*255);ia=~~(ia.b*255);var Ia=~~(ka.r*255),Va=~~(ka.g*255);ka=~~(ka.b*255);var Ta=~~(da.r*255),ib=~~(da.g*255);da=~~(da.b*255);V[0]=ra<0?0:ra>255?255:ra;V[1]=qa<0?0:qa>255?255:qa;V[2]=W<0?0:W>255?255:W;V[4]=ha<0?0:ha>255?255:ha;V[5]=Y<0?0:Y>255?255:Y;V[6]=ia<0?0:ia>255?255:ia;V[8]=Ia<0?0:Ia>255?255:Ia;V[9]=Va<0?0:Va>255?255:Va;
V[10]=ka<0?0:ka>255?255:ka;V[12]=Ta<0?0:Ta>255?255:Ta;V[13]=ib<0?0:ib>255?255:ib;V[14]=da<0?0:da>255?255:da;L.putImageData($,0,0);Ja.drawImage(O,0,0);return xa}function eb(W,ia,ka){W=(W-ia)/(ka-ia);return W*W*(3-2*W)}function $a(W){W=(W+1)*0.5;return W<0?0:W>1?1:W}function ab(W,ia){var ka=ia.x-W.x,da=ia.y-W.y,ra=1/Math.sqrt(ka*ka+da*da);ka*=ra;da*=ra;ia.x+=ka;ia.y+=da;W.x-=ka;W.y-=da}var La,cb,Aa,U,Qa,Sa,jb,Xa;this.autoClear?this.clear():o.setTransform(1,0,0,-1,m,p);f=g.projectScene(ta,Oa,this.sortElements);
(z=ta.lights.length>0)&&Ga(ta);La=0;for(cb=f.length;La<cb;La++){Aa=f[La];x.empty();if(Aa instanceof THREE.RenderableParticle){M=Aa;M.x*=m;M.y*=p;U=0;for(Qa=Aa.materials.length;U<Qa;){Xa=Aa.materials[U++];Xa.opacity!=0&&Ha(M,Aa,Xa,ta)}}else if(Aa instanceof THREE.RenderableLine){M=Aa.v1;Q=Aa.v2;M.positionScreen.x*=m;M.positionScreen.y*=p;Q.positionScreen.x*=m;Q.positionScreen.y*=p;x.addPoint(M.positionScreen.x,M.positionScreen.y);x.addPoint(Q.positionScreen.x,Q.positionScreen.y);if(C.instersects(x)){U=
0;for(Qa=Aa.materials.length;U<Qa;){Xa=Aa.materials[U++];Xa.opacity!=0&&Ua(M,Q,Aa,Xa,ta)}}}else if(Aa instanceof THREE.RenderableFace3){M=Aa.v1;Q=Aa.v2;R=Aa.v3;M.positionScreen.x*=m;M.positionScreen.y*=p;Q.positionScreen.x*=m;Q.positionScreen.y*=p;R.positionScreen.x*=m;R.positionScreen.y*=p;if(Aa.overdraw){ab(M.positionScreen,Q.positionScreen);ab(Q.positionScreen,R.positionScreen);ab(R.positionScreen,M.positionScreen)}x.add3Points(M.positionScreen.x,M.positionScreen.y,Q.positionScreen.x,Q.positionScreen.y,
R.positionScreen.x,R.positionScreen.y);if(C.instersects(x)){U=0;for(Qa=Aa.meshMaterials.length;U<Qa;){Xa=Aa.meshMaterials[U++];if(Xa instanceof THREE.MeshFaceMaterial){Sa=0;for(jb=Aa.faceMaterials.length;Sa<jb;)(Xa=Aa.faceMaterials[Sa++])&&Xa.opacity!=0&&E(M,Q,R,0,1,2,Aa,Xa,ta)}else Xa.opacity!=0&&E(M,Q,R,0,1,2,Aa,Xa,ta)}}}else if(Aa instanceof THREE.RenderableFace4){M=Aa.v1;Q=Aa.v2;R=Aa.v3;Da=Aa.v4;M.positionScreen.x*=m;M.positionScreen.y*=p;Q.positionScreen.x*=m;Q.positionScreen.y*=p;R.positionScreen.x*=
m;R.positionScreen.y*=p;Da.positionScreen.x*=m;Da.positionScreen.y*=p;ma.positionScreen.copy(Q.positionScreen);va.positionScreen.copy(Da.positionScreen);if(Aa.overdraw){ab(M.positionScreen,Q.positionScreen);ab(Q.positionScreen,Da.positionScreen);ab(Da.positionScreen,M.positionScreen);ab(R.positionScreen,ma.positionScreen);ab(R.positionScreen,va.positionScreen)}x.addPoint(M.positionScreen.x,M.positionScreen.y);x.addPoint(Q.positionScreen.x,Q.positionScreen.y);x.addPoint(R.positionScreen.x,R.positionScreen.y);
x.addPoint(Da.positionScreen.x,Da.positionScreen.y);if(C.instersects(x)){U=0;for(Qa=Aa.meshMaterials.length;U<Qa;){Xa=Aa.meshMaterials[U++];if(Xa instanceof THREE.MeshFaceMaterial){Sa=0;for(jb=Aa.faceMaterials.length;Sa<jb;)(Xa=Aa.faceMaterials[Sa++])&&Xa.opacity!=0&&fa(M,Q,R,Da,ma,va,Aa,Xa,ta)}else Xa.opacity!=0&&fa(M,Q,R,Da,ma,va,Aa,Xa,ta)}}}w.addRectangle(x)}o.setTransform(1,0,0,1,0,0)}};
THREE.SVGRenderer=function(){function b(Z,oa,pa){var sa,ga,aa,na;sa=0;for(ga=Z.lights.length;sa<ga;sa++){aa=Z.lights[sa];if(aa instanceof THREE.DirectionalLight){na=oa.normalWorld.dot(aa.position)*aa.intensity;if(na>0){pa.r+=aa.color.r*na;pa.g+=aa.color.g*na;pa.b+=aa.color.b*na}}else if(aa instanceof THREE.PointLight){va.sub(aa.position,oa.centroidWorld);va.normalize();na=oa.normalWorld.dot(va)*aa.intensity;if(na>0){pa.r+=aa.color.r*na;pa.g+=aa.color.g*na;pa.b+=aa.color.b*na}}}}function d(Z,oa,pa,
sa,ga,aa){ea=f(ya++);ea.setAttribute("d","M "+Z.positionScreen.x+" "+Z.positionScreen.y+" L "+oa.positionScreen.x+" "+oa.positionScreen.y+" L "+pa.positionScreen.x+","+pa.positionScreen.y+"z");if(ga instanceof THREE.MeshBasicMaterial)A.__styleString=ga.color.__styleString;else if(ga instanceof THREE.MeshLambertMaterial)if(X){M.r=Q.r;M.g=Q.g;M.b=Q.b;b(aa,sa,M);A.r=ga.color.r*M.r;A.g=ga.color.g*M.g;A.b=ga.color.b*M.b;A.updateStyleString()}else A.__styleString=ga.color.__styleString;else if(ga instanceof
THREE.MeshDepthMaterial){ma=1-ga.__2near/(ga.__farPlusNear-sa.z*ga.__farMinusNear);A.setRGB(ma,ma,ma)}else ga instanceof THREE.MeshNormalMaterial&&A.setRGB(g(sa.normalWorld.x),g(sa.normalWorld.y),g(sa.normalWorld.z));ga.wireframe?ea.setAttribute("style","fill: none; stroke: "+A.__styleString+"; stroke-width: "+ga.wireframeLinewidth+"; stroke-opacity: "+ga.opacity+"; stroke-linecap: "+ga.wireframeLinecap+"; stroke-linejoin: "+ga.wireframeLinejoin):ea.setAttribute("style","fill: "+A.__styleString+"; fill-opacity: "+
ga.opacity);k.appendChild(ea)}function c(Z,oa,pa,sa,ga,aa,na){ea=f(ya++);ea.setAttribute("d","M "+Z.positionScreen.x+" "+Z.positionScreen.y+" L "+oa.positionScreen.x+" "+oa.positionScreen.y+" L "+pa.positionScreen.x+","+pa.positionScreen.y+" L "+sa.positionScreen.x+","+sa.positionScreen.y+"z");if(aa instanceof THREE.MeshBasicMaterial)A.__styleString=aa.color.__styleString;else if(aa instanceof THREE.MeshLambertMaterial)if(X){M.r=Q.r;M.g=Q.g;M.b=Q.b;b(na,ga,M);A.r=aa.color.r*M.r;A.g=aa.color.g*M.g;
A.b=aa.color.b*M.b;A.updateStyleString()}else A.__styleString=aa.color.__styleString;else if(aa instanceof THREE.MeshDepthMaterial){ma=1-aa.__2near/(aa.__farPlusNear-ga.z*aa.__farMinusNear);A.setRGB(ma,ma,ma)}else aa instanceof THREE.MeshNormalMaterial&&A.setRGB(g(ga.normalWorld.x),g(ga.normalWorld.y),g(ga.normalWorld.z));aa.wireframe?ea.setAttribute("style","fill: none; stroke: "+A.__styleString+"; stroke-width: "+aa.wireframeLinewidth+"; stroke-opacity: "+aa.opacity+"; stroke-linecap: "+aa.wireframeLinecap+
"; stroke-linejoin: "+aa.wireframeLinejoin):ea.setAttribute("style","fill: "+A.__styleString+"; fill-opacity: "+aa.opacity);k.appendChild(ea)}function f(Z){if(ca[Z]==null){ca[Z]=document.createElementNS("http://www.w3.org/2000/svg","path");Fa==0&&ca[Z].setAttribute("shape-rendering","crispEdges")}return ca[Z]}function g(Z){return Z<0?Math.min((1+Z)*0.5,0.5):0.5+Math.min(Z*0.5,0.5)}var h=null,j=new THREE.Projector,k=document.createElementNS("http://www.w3.org/2000/svg","svg"),m,p,o,u,y,t,B,F,H=new THREE.Rectangle,
G=new THREE.Rectangle,X=!1,A=new THREE.Color(16777215),M=new THREE.Color(16777215),Q=new THREE.Color(0),R=new THREE.Color(0),Da=new THREE.Color(0),ma,va=new THREE.Vector3,ca=[],e=[],ea,ya,Ba,Fa=1;this.domElement=k;this.autoClear=!0;this.sortObjects=!0;this.sortElements=!0;this.setQuality=function(Z){switch(Z){case "high":Fa=1;break;case "low":Fa=0}};this.setSize=function(Z,oa){m=Z;p=oa;o=m/2;u=p/2;k.setAttribute("viewBox",-o+" "+-u+" "+m+" "+p);k.setAttribute("width",m);k.setAttribute("height",p);
H.set(-o,-u,o,u)};this.clear=function(){for(;k.childNodes.length>0;)k.removeChild(k.childNodes[0])};this.render=function(Z,oa){var pa,sa,ga,aa,na,Ea,ja,la;this.autoClear&&this.clear();h=j.projectScene(Z,oa,this.sortElements);Ba=ya=0;if(X=Z.lights.length>0){ja=Z.lights;Q.setRGB(0,0,0);R.setRGB(0,0,0);Da.setRGB(0,0,0);pa=0;for(sa=ja.length;pa<sa;pa++){ga=ja[pa];aa=ga.color;if(ga instanceof THREE.AmbientLight){Q.r+=aa.r;Q.g+=aa.g;Q.b+=aa.b}else if(ga instanceof THREE.DirectionalLight){R.r+=aa.r;R.g+=
aa.g;R.b+=aa.b}else if(ga instanceof THREE.PointLight){Da.r+=aa.r;Da.g+=aa.g;Da.b+=aa.b}}}pa=0;for(sa=h.length;pa<sa;pa++){ja=h[pa];G.empty();if(ja instanceof THREE.RenderableParticle){y=ja;y.x*=o;y.y*=-u;ga=0;for(aa=ja.materials.length;ga<aa;)ga++}else if(ja instanceof THREE.RenderableLine){y=ja.v1;t=ja.v2;y.positionScreen.x*=o;y.positionScreen.y*=-u;t.positionScreen.x*=o;t.positionScreen.y*=-u;G.addPoint(y.positionScreen.x,y.positionScreen.y);G.addPoint(t.positionScreen.x,t.positionScreen.y);if(H.instersects(G)){ga=
0;for(aa=ja.materials.length;ga<aa;)if((la=ja.materials[ga++])&&la.opacity!=0){na=y;Ea=t;var ua=Ba++;if(e[ua]==null){e[ua]=document.createElementNS("http://www.w3.org/2000/svg","line");Fa==0&&e[ua].setAttribute("shape-rendering","crispEdges")}ea=e[ua];ea.setAttribute("x1",na.positionScreen.x);ea.setAttribute("y1",na.positionScreen.y);ea.setAttribute("x2",Ea.positionScreen.x);ea.setAttribute("y2",Ea.positionScreen.y);if(la instanceof THREE.LineBasicMaterial){A.__styleString=la.color.__styleString;
ea.setAttribute("style","fill: none; stroke: "+A.__styleString+"; stroke-width: "+la.linewidth+"; stroke-opacity: "+la.opacity+"; stroke-linecap: "+la.linecap+"; stroke-linejoin: "+la.linejoin);k.appendChild(ea)}}}}else if(ja instanceof THREE.RenderableFace3){y=ja.v1;t=ja.v2;B=ja.v3;y.positionScreen.x*=o;y.positionScreen.y*=-u;t.positionScreen.x*=o;t.positionScreen.y*=-u;B.positionScreen.x*=o;B.positionScreen.y*=-u;G.addPoint(y.positionScreen.x,y.positionScreen.y);G.addPoint(t.positionScreen.x,t.positionScreen.y);
G.addPoint(B.positionScreen.x,B.positionScreen.y);if(H.instersects(G)){ga=0;for(aa=ja.meshMaterials.length;ga<aa;){la=ja.meshMaterials[ga++];if(la instanceof THREE.MeshFaceMaterial){na=0;for(Ea=ja.faceMaterials.length;na<Ea;)(la=ja.faceMaterials[na++])&&la.opacity!=0&&d(y,t,B,ja,la,Z)}else la&&la.opacity!=0&&d(y,t,B,ja,la,Z)}}}else if(ja instanceof THREE.RenderableFace4){y=ja.v1;t=ja.v2;B=ja.v3;F=ja.v4;y.positionScreen.x*=o;y.positionScreen.y*=-u;t.positionScreen.x*=o;t.positionScreen.y*=-u;B.positionScreen.x*=
o;B.positionScreen.y*=-u;F.positionScreen.x*=o;F.positionScreen.y*=-u;G.addPoint(y.positionScreen.x,y.positionScreen.y);G.addPoint(t.positionScreen.x,t.positionScreen.y);G.addPoint(B.positionScreen.x,B.positionScreen.y);G.addPoint(F.positionScreen.x,F.positionScreen.y);if(H.instersects(G)){ga=0;for(aa=ja.meshMaterials.length;ga<aa;){la=ja.meshMaterials[ga++];if(la instanceof THREE.MeshFaceMaterial){na=0;for(Ea=ja.faceMaterials.length;na<Ea;)(la=ja.faceMaterials[na++])&&la.opacity!=0&&c(y,t,B,F,ja,
la,Z)}else la&&la.opacity!=0&&c(y,t,B,F,ja,la,Z)}}}}}};
THREE.ShaderChunk={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform int combine;\n#endif",
envmap_fragment:"#ifdef USE_ENVMAP\nvec4 cubeColor = textureCube( envMap, vec3( -vReflect.x, vReflect.yz ) );\nif ( combine == 1 ) {\ngl_FragColor = vec4( mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity ), opacity );\n} else {\ngl_FragColor = gl_FragColor * cubeColor;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",
map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\n#endif",map_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv;\n#endif",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",
lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_pars_vertex:"uniform bool enableLighting;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#ifdef PHONG\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#endif",
lights_vertex:"if ( !enableLighting ) {\nvLightWeighting = vec3( 1.0 );\n} else {\nvLightWeighting = ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nfloat directionalLightWeighting = max( dot( transformedNormal, normalize( lDirection.xyz ) ), 0.0 );\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nfloat pointLightWeighting = max( dot( transformedNormal, lVector ), 0.0 );\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting * lDistance;\n#ifdef PHONG\nvPointLight[ i ] = vec4( lVector, lDistance );\n#endif\n}\n#endif\n}",
lights_pars_fragment:"#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",lights_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 mColor = vec4( diffuse, opacity );\nvec4 mSpecular = vec4( specular, opacity );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointDiffuse  = vec4( 0.0 );\nvec4 pointSpecular = vec4( 0.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec3 pointVector = normalize( vPointLight[ i ].xyz );\nvec3 pointHalfVector = normalize( vPointLight[ i ].xyz + vViewPosition );\nfloat pointDistance = vPointLight[ i ].w;\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, shininess );\npointDiffuse  += mColor * pointDiffuseWeight * pointDistance;\npointSpecular += mSpecular * pointSpecularWeight * pointDistance;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirDiffuse  = vec4( 0.0 );\nvec4 dirSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, shininess );\ndirDiffuse  += mColor * dirDiffuseWeight;\ndirSpecular += mSpecular * dirSpecularWeight;\n}\n#endif\nvec4 totalLight = vec4( ambient, opacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirDiffuse + dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointDiffuse + pointSpecular;\n#endif\ngl_FragColor = gl_FragColor * totalLight;",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\nvColor = color;\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[ MAX_BONES ];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * viewMatrix * objectMatrix * gl_Position;\n#endif",
morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\nuniform float morphTargetInfluences[ 8 ];\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\nvec3 morphed = vec3( 0.0, 0.0, 0.0 );\nmorphed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\nmorphed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\nmorphed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\nmorphed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\nmorphed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\nmorphed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\nmorphed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\nmorphed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\nmorphed += position;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( morphed, 1.0 );\n#endif",
default_vertex:"#ifndef USE_MORPHTARGETS\n#ifndef USE_SKINNING\ngl_Position = projectionMatrix * mvPosition;\n#endif\n#endif"};THREE.UniformsUtils={merge:function(b){var d,c,f,g={};for(d=0;d<b.length;d++){f=this.clone(b[d]);for(c in f)g[c]=f[c]}return g},clone:function(b){var d,c,f,g={};for(d in b){g[d]={};for(c in b[d]){f=b[d][c];g[d][c]=f instanceof THREE.Color||f instanceof THREE.Vector3||f instanceof THREE.Texture?f.clone():f}}return g}};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)},morphTargetInfluences:{type:"f",
value:0}},lights:{enableLighting:{type:"i",value:1},ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightDistance:{type:"fv1",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},scale:{type:"f",value:1},map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},
fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}}};
THREE.ShaderLib={lensFlareVertexTexture:{vertexShader:"uniform \tvec3 \tscreenPosition;\nuniform\tvec2\tscale;\nuniform\tfloat\trotation;\nuniform    int     renderType;\nuniform\tsampler2D\tocclusionMap;\nattribute \tvec2 \tposition;\nattribute  vec2\tUV;\nvarying\tvec2\tvUV;\nvarying\tfloat\tvVisibility;\nvoid main(void)\n{\nvUV = UV;\nvec2 pos = position;\nif( renderType == 2 ) {\nvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 )) +\ntexture2D( occlusionMap, vec2( 0.5, 0.1 )) +\ntexture2D( occlusionMap, vec2( 0.9, 0.1 )) +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 )) +\ntexture2D( occlusionMap, vec2( 0.9, 0.9 )) +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 )) +\ntexture2D( occlusionMap, vec2( 0.1, 0.9 )) +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 )) +\ntexture2D( occlusionMap, vec2( 0.5, 0.5 ));\nvVisibility = (       visibility.r / 9.0 ) *\n( 1.0 - visibility.g / 9.0 ) *\n(       visibility.b / 9.0 ) *\n( 1.0 - visibility.a / 9.0 );\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4(( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform\tsampler2D\tmap;\nuniform\tfloat\t\topacity;\nuniform    int         renderType;\nvarying\tvec2\t\tvUV;\nvarying\tfloat\t\tvVisibility;\nvoid main( void )\n{\nif( renderType == 0 ) {\ngl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity * vVisibility;\ngl_FragColor = color;\n}\n}"},
lensFlare:{vertexShader:"uniform \tvec3 \tscreenPosition;\nuniform\tvec2\tscale;\nuniform\tfloat\trotation;\nuniform    int     renderType;\nattribute \tvec2 \tposition;\nattribute  vec2\tUV;\nvarying\tvec2\tvUV;\nvoid main(void)\n{\nvUV = UV;\nvec2 pos = position;\nif( renderType == 2 ) {\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4(( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",
fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform\tsampler2D\tmap;\nuniform\tsampler2D\tocclusionMap;\nuniform\tfloat\t\topacity;\nuniform    int         renderType;\nvarying\tvec2\t\tvUV;\nvoid main( void )\n{\nif( renderType == 0 ) {\ngl_FragColor = vec4( texture2D( map, vUV ).rgb, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nfloat visibility = texture2D( occlusionMap, vec2( 0.5, 0.1 )).a +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 )).a +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 )).a +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 )).a;\nvisibility = ( 1.0 - visibility / 4.0 );\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity * visibility;\ngl_FragColor = color;\n}\n}"},
sprite:{vertexShader:"uniform\tint\t\tuseScreenCoordinates;\nuniform    int     affectedByDistance;\nuniform\tvec3\tscreenPosition;\nuniform \tmat4 \tmodelViewMatrix;\nuniform \tmat4 \tprojectionMatrix;\nuniform    float   rotation;\nuniform    vec2    scale;\nuniform    vec2    alignment;\nuniform    vec2    uvOffset;\nuniform\tvec2    uvScale;\nattribute \tvec2 \tposition;\nattribute  vec2\tuv;\nvarying\tvec2\tvUV;\nvoid main(void)\n{\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position + alignment;\nvec2 rotatedPosition;\nrotatedPosition.x = ( cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y ) * scale.x;\nrotatedPosition.y = ( sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y ) * scale.y;\nvec4 finalPosition;\nif( useScreenCoordinates != 0 ) {\nfinalPosition = vec4( screenPosition.xy + rotatedPosition, screenPosition.z, 1.0 );\n} else {\nfinalPosition = projectionMatrix * modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition * ( affectedByDistance == 1 ? 1.0 : finalPosition.z );\n}\ngl_Position = finalPosition;\n}",
fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform\tsampler2D\tmap;\nuniform\tfloat\t\topacity;\nvarying\tvec2\t\tvUV;\nvoid main( void )\n{\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity;\ngl_FragColor = color;\n}"},shadowPost:{vertexShader:"uniform \tmat4 \tprojectionMatrix;\nattribute \tvec3 \tposition;\nvoid main(void)\n{\ngl_Position = projectionMatrix * vec4( position, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform \tfloat \tdarkness;\nvoid main( void )\n{\ngl_FragColor = vec4( 0, 0, 0, darkness );\n}"},
shadowVolumeDynamic:{uniforms:{directionalLightDirection:{type:"fv",value:[]}},vertexShader:"uniform \tvec3 \tdirectionalLightDirection;\nvoid main() {\nvec4 pos      = objectMatrix * vec4( position, 1.0 );\nvec3 norm     = mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal;\nvec4 extruded = vec4( directionalLightDirection * 5000.0 * step( 0.0, dot( directionalLightDirection, norm )), 0.0 );\ngl_Position   = projectionMatrix * viewMatrix * ( pos + extruded );\n}",fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0 );\n}"},
depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}",vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"},normal:{uniforms:{opacity:{type:"f",value:1}},
fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}",vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}"},basic:{uniforms:THREE.UniformsLib.common,fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,
THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:[THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.color_pars_vertex,
THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n")},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights]),
fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );\ngl_FragColor = gl_FragColor * vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,
THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["varying vec3 vLightWeighting;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,
THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"vec3 transformedNormal = normalize( normalMatrix * normal );",THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n")},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights,{ambient:{type:"c",value:new THREE.Color(328965)},specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30}}]),
fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.lights_pars_fragment,"void main() {\ngl_FragColor = vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.lights_fragment,THREE.ShaderChunk.map_fragment,
THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["#define PHONG\nvarying vec3 vLightWeighting;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,
"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = cameraPosition - mPosition.xyz;\nvec3 transformedNormal = normalize( normalMatrix * normal );\nvNormal = transformedNormal;",THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,
THREE.ShaderChunk.default_vertex,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsLib.particle,fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_particle_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.ShaderChunk.map_particle_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["uniform float size;\nuniform float scale;",
THREE.ShaderChunk.color_pars_vertex,"void main() {",THREE.ShaderChunk.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * ( scale / length( mvPosition.xyz ) );\n#else\ngl_PointSize = size;\n#endif\ngl_Position = projectionMatrix * mvPosition;\n}"].join("\n")}};
THREE.WebGLRenderer=function(b){function d(n,C,w){var x,z,J,K=n.vertices,I=K.length,S=n.colors,D=S.length,O=n.__vertexArray,L=n.__colorArray,$=n.__sortArray,V=n.__dirtyVertices,xa=n.__dirtyColors;if(w.sortParticles){Ra.multiplySelf(w.matrixWorld);for(x=0;x<I;x++){z=K[x].position;Na.copy(z);Ra.multiplyVector3(Na);$[x]=[Na.z,x]}$.sort(function(Ja,za){return za[0]-Ja[0]});for(x=0;x<I;x++){z=K[$[x][1]].position;J=x*3;O[J]=z.x;O[J+1]=z.y;O[J+2]=z.z}for(x=0;x<D;x++){J=x*3;color=S[$[x][1]];L[J]=color.r;
L[J+1]=color.g;L[J+2]=color.b}}else{if(V)for(x=0;x<I;x++){z=K[x].position;J=x*3;O[J]=z.x;O[J+1]=z.y;O[J+2]=z.z}if(xa)for(x=0;x<D;x++){color=S[x];J=x*3;L[J]=color.r;L[J+1]=color.g;L[J+2]=color.b}}if(V||w.sortParticles){e.bindBuffer(e.ARRAY_BUFFER,n.__webglVertexBuffer);e.bufferData(e.ARRAY_BUFFER,O,C)}if(xa||w.sortParticles){e.bindBuffer(e.ARRAY_BUFFER,n.__webglColorBuffer);e.bufferData(e.ARRAY_BUFFER,L,C)}}function c(n,C,w,x,z){x.program||oa.initMaterial(x,C,w,z);var J=x.program,K=J.uniforms,I=x.uniforms;
if(J!=Ba){e.useProgram(J);Ba=J}e.uniformMatrix4fv(K.projectionMatrix,!1,Ya);if(w&&(x instanceof THREE.MeshBasicMaterial||x instanceof THREE.MeshLambertMaterial||x instanceof THREE.MeshPhongMaterial||x instanceof THREE.LineBasicMaterial||x instanceof THREE.ParticleBasicMaterial||x.fog)){I.fogColor.value=w.color;if(w instanceof THREE.Fog){I.fogNear.value=w.near;I.fogFar.value=w.far}else if(w instanceof THREE.FogExp2)I.fogDensity.value=w.density}if(x instanceof THREE.MeshPhongMaterial||x instanceof THREE.MeshLambertMaterial||
x.lights){var S,D,O=0,L=0,$=0,V,xa,Ja,za,ta=T,Oa=ta.directional.colors,Ga=ta.directional.positions,wa=ta.point.colors,Ha=ta.point.positions,Ua=ta.point.distances,E=0,fa=0;w=D=za=0;for(S=C.length;w<S;w++){D=C[w];V=D.color;xa=D.position;Ja=D.intensity;za=D.distance;if(D instanceof THREE.AmbientLight){O+=V.r;L+=V.g;$+=V.b}else if(D instanceof THREE.DirectionalLight){za=E*3;Oa[za]=V.r*Ja;Oa[za+1]=V.g*Ja;Oa[za+2]=V.b*Ja;Ga[za]=xa.x;Ga[za+1]=xa.y;Ga[za+2]=xa.z;E+=1}else if(D instanceof THREE.PointLight){D=
fa*3;wa[D]=V.r*Ja;wa[D+1]=V.g*Ja;wa[D+2]=V.b*Ja;Ha[D]=xa.x;Ha[D+1]=xa.y;Ha[D+2]=xa.z;Ua[fa]=za;fa+=1}}for(w=E*3;w<Oa.length;w++)Oa[w]=0;for(w=fa*3;w<wa.length;w++)wa[w]=0;ta.point.length=fa;ta.directional.length=E;ta.ambient[0]=O;ta.ambient[1]=L;ta.ambient[2]=$;w=T;I.enableLighting.value=w.directional.length+w.point.length;I.ambientLightColor.value=w.ambient;I.directionalLightColor.value=w.directional.colors;I.directionalLightDirection.value=w.directional.positions;I.pointLightColor.value=w.point.colors;
I.pointLightPosition.value=w.point.positions;I.pointLightDistance.value=w.point.distances}if(x instanceof THREE.MeshBasicMaterial||x instanceof THREE.MeshLambertMaterial||x instanceof THREE.MeshPhongMaterial){I.diffuse.value=x.color;I.opacity.value=x.opacity;I.map.texture=x.map;I.lightMap.texture=x.lightMap;I.envMap.texture=x.envMap;I.reflectivity.value=x.reflectivity;I.refractionRatio.value=x.refractionRatio;I.combine.value=x.combine;I.useRefract.value=x.envMap&&x.envMap.mapping instanceof THREE.CubeRefractionMapping}if(x instanceof
THREE.LineBasicMaterial){I.diffuse.value=x.color;I.opacity.value=x.opacity}else if(x instanceof THREE.ParticleBasicMaterial){I.psColor.value=x.color;I.opacity.value=x.opacity;I.size.value=x.size;I.scale.value=ea.height/2;I.map.texture=x.map}else if(x instanceof THREE.MeshPhongMaterial){I.ambient.value=x.ambient;I.specular.value=x.specular;I.shininess.value=x.shininess}else if(x instanceof THREE.MeshDepthMaterial){I.mNear.value=n.near;I.mFar.value=n.far;I.opacity.value=x.opacity}else if(x instanceof
THREE.MeshNormalMaterial)I.opacity.value=x.opacity;for(var v in I)if(L=J.uniforms[v]){S=I[v];O=S.type;w=S.value;if(O=="i")e.uniform1i(L,w);else if(O=="f")e.uniform1f(L,w);else if(O=="fv1")e.uniform1fv(L,w);else if(O=="fv")e.uniform3fv(L,w);else if(O=="v2")e.uniform2f(L,w.x,w.y);else if(O=="v3")e.uniform3f(L,w.x,w.y,w.z);else if(O=="v4")e.uniform4f(L,w.x,w.y,w.z,w.w);else if(O=="c")e.uniform3f(L,w.r,w.g,w.b);else if(O=="t"){e.uniform1i(L,w);if(S=S.texture)if(S.image instanceof Array&&S.image.length==
6){if(S.image.length==6){if(S.needsUpdate){if(S.__webglInit){e.bindTexture(e.TEXTURE_CUBE_MAP,S.image.__webglTextureCube);for(O=0;O<6;++O)e.texSubImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+O,0,0,0,e.RGBA,e.UNSIGNED_BYTE,S.image[O])}else{S.image.__webglTextureCube=e.createTexture();e.bindTexture(e.TEXTURE_CUBE_MAP,S.image.__webglTextureCube);for(O=0;O<6;++O)e.texImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+O,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,S.image[O]);S.__webglInit=!0}Q(e.TEXTURE_CUBE_MAP,S,S.image[0]);e.bindTexture(e.TEXTURE_CUBE_MAP,
null);S.needsUpdate=!1}e.activeTexture(e.TEXTURE0+w);e.bindTexture(e.TEXTURE_CUBE_MAP,S.image.__webglTextureCube)}}else R(S,w)}}e.uniformMatrix4fv(K.modelViewMatrix,!1,z._modelViewMatrixArray);e.uniformMatrix3fv(K.normalMatrix,!1,z._normalMatrixArray);(x instanceof THREE.MeshShaderMaterial||x instanceof THREE.MeshPhongMaterial||x.envMap)&&e.uniform3f(K.cameraPosition,n.position.x,n.position.y,n.position.z);(x instanceof THREE.MeshShaderMaterial||x.envMap||x.skinning)&&e.uniformMatrix4fv(K.objectMatrix,
!1,z._objectMatrixArray);(x instanceof THREE.MeshPhongMaterial||x instanceof THREE.MeshLambertMaterial||x instanceof THREE.MeshShaderMaterial||x.skinning)&&e.uniformMatrix4fv(K.viewMatrix,!1,Za);if(x instanceof THREE.ShadowVolumeDynamicMaterial){n=I.directionalLightDirection.value;n[0]=-C[1].position.x;n[1]=-C[1].position.y;n[2]=-C[1].position.z;e.uniform3fv(K.directionalLightDirection,n);e.uniformMatrix4fv(K.objectMatrix,!1,z._objectMatrixArray);e.uniformMatrix4fv(K.viewMatrix,!1,Za)}if(x.skinning){e.uniformMatrix4fv(K.cameraInverseMatrix,
!1,Za);e.uniformMatrix4fv(K.boneGlobalMatrices,!1,z.boneMatrices)}return J}function f(n,C,w,x,z,J){if(x.opacity!=0){var K;n=c(n,C,w,x,J).attributes;if(x.morphTargets){C=x.program.attributes;J.morphTargetBase!==-1?e.bindBuffer(e.ARRAY_BUFFER,z.__webglMorphTargetsBuffers[J.morphTargetBase]):e.bindBuffer(e.ARRAY_BUFFER,z.__webglVertexBuffer);e.vertexAttribPointer(C.position,3,e.FLOAT,!1,0,0);if(J.morphTargetForcedOrder.length){w=0;for(var I=J.morphTargetForcedOrder,S=J.morphTargetInfluences;w<x.numSupportedMorphTargets&&
w<I.length;){e.bindBuffer(e.ARRAY_BUFFER,z.__webglMorphTargetsBuffers[I[w]]);e.vertexAttribPointer(C["morphTarget"+w],3,e.FLOAT,!1,0,0);J.__webglMorphTargetInfluences[w]=S[I[w]];w++}}else{I=[];var D=-1,O=0;S=J.morphTargetInfluences;var L,$=S.length;w=0;for(J.morphTargetBase!==-1&&(I[J.morphTargetBase]=!0);w<x.numSupportedMorphTargets;){for(L=0;L<$;L++)if(!I[L]&&S[L]>D){O=L;D=S[O]}e.bindBuffer(e.ARRAY_BUFFER,z.__webglMorphTargetsBuffers[O]);e.vertexAttribPointer(C["morphTarget"+w],3,e.FLOAT,!1,0,0);
J.__webglMorphTargetInfluences[w]=D;I[O]=1;D=-1;w++}}e.uniform1fv(x.program.uniforms.morphTargetInfluences,J.__webglMorphTargetInfluences)}else{e.bindBuffer(e.ARRAY_BUFFER,z.__webglVertexBuffer);e.vertexAttribPointer(n.position,3,e.FLOAT,!1,0,0)}if(z.__webglCustomAttributes)for(K in z.__webglCustomAttributes)if(n[K]>=0){C=z.__webglCustomAttributes[K];e.bindBuffer(e.ARRAY_BUFFER,C.buffer);e.vertexAttribPointer(n[K],C.size,e.FLOAT,!1,0,0)}if(n.color>=0){e.bindBuffer(e.ARRAY_BUFFER,z.__webglColorBuffer);
e.vertexAttribPointer(n.color,3,e.FLOAT,!1,0,0)}if(n.normal>=0){e.bindBuffer(e.ARRAY_BUFFER,z.__webglNormalBuffer);e.vertexAttribPointer(n.normal,3,e.FLOAT,!1,0,0)}if(n.tangent>=0){e.bindBuffer(e.ARRAY_BUFFER,z.__webglTangentBuffer);e.vertexAttribPointer(n.tangent,4,e.FLOAT,!1,0,0)}if(n.uv>=0)if(z.__webglUVBuffer){e.bindBuffer(e.ARRAY_BUFFER,z.__webglUVBuffer);e.vertexAttribPointer(n.uv,2,e.FLOAT,!1,0,0);e.enableVertexAttribArray(n.uv)}else e.disableVertexAttribArray(n.uv);if(n.uv2>=0)if(z.__webglUV2Buffer){e.bindBuffer(e.ARRAY_BUFFER,
z.__webglUV2Buffer);e.vertexAttribPointer(n.uv2,2,e.FLOAT,!1,0,0);e.enableVertexAttribArray(n.uv2)}else e.disableVertexAttribArray(n.uv2);if(x.skinning&&n.skinVertexA>=0&&n.skinVertexB>=0&&n.skinIndex>=0&&n.skinWeight>=0){e.bindBuffer(e.ARRAY_BUFFER,z.__webglSkinVertexABuffer);e.vertexAttribPointer(n.skinVertexA,4,e.FLOAT,!1,0,0);e.bindBuffer(e.ARRAY_BUFFER,z.__webglSkinVertexBBuffer);e.vertexAttribPointer(n.skinVertexB,4,e.FLOAT,!1,0,0);e.bindBuffer(e.ARRAY_BUFFER,z.__webglSkinIndicesBuffer);e.vertexAttribPointer(n.skinIndex,
4,e.FLOAT,!1,0,0);e.bindBuffer(e.ARRAY_BUFFER,z.__webglSkinWeightsBuffer);e.vertexAttribPointer(n.skinWeight,4,e.FLOAT,!1,0,0)}if(J instanceof THREE.Mesh)if(x.wireframe){e.lineWidth(x.wireframeLinewidth);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,z.__webglLineBuffer);e.drawElements(e.LINES,z.__webglLineCount,e.UNSIGNED_SHORT,0)}else{e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,z.__webglFaceBuffer);e.drawElements(e.TRIANGLES,z.__webglFaceCount,e.UNSIGNED_SHORT,0)}else if(J instanceof THREE.Line){J=J.type==THREE.LineStrip?
e.LINE_STRIP:e.LINES;e.lineWidth(x.linewidth);e.drawArrays(J,0,z.__webglLineCount)}else if(J instanceof THREE.ParticleSystem)e.drawArrays(e.POINTS,0,z.__webglParticleCount);else J instanceof THREE.Ribbon&&e.drawArrays(e.TRIANGLE_STRIP,0,z.__webglVertexCount)}}function g(n,C,w){if(!n.__webglVertexBuffer)n.__webglVertexBuffer=e.createBuffer();if(!n.__webglNormalBuffer)n.__webglNormalBuffer=e.createBuffer();if(n.hasPos){e.bindBuffer(e.ARRAY_BUFFER,n.__webglVertexBuffer);e.bufferData(e.ARRAY_BUFFER,n.positionArray,
e.DYNAMIC_DRAW);e.enableVertexAttribArray(C.attributes.position);e.vertexAttribPointer(C.attributes.position,3,e.FLOAT,!1,0,0)}if(n.hasNormal){e.bindBuffer(e.ARRAY_BUFFER,n.__webglNormalBuffer);if(w==THREE.FlatShading){var x,z,J,K,I,S,D,O,L,$,V=n.count*3;for($=0;$<V;$+=9){w=n.normalArray;x=w[$];z=w[$+1];J=w[$+2];K=w[$+3];S=w[$+4];O=w[$+5];I=w[$+6];D=w[$+7];L=w[$+8];x=(x+K+I)/3;z=(z+S+D)/3;J=(J+O+L)/3;w[$]=x;w[$+1]=z;w[$+2]=J;w[$+3]=x;w[$+4]=z;w[$+5]=J;w[$+6]=x;w[$+7]=z;w[$+8]=J}}e.bufferData(e.ARRAY_BUFFER,
n.normalArray,e.DYNAMIC_DRAW);e.enableVertexAttribArray(C.attributes.normal);e.vertexAttribPointer(C.attributes.normal,3,e.FLOAT,!1,0,0)}e.drawArrays(e.TRIANGLES,0,n.count);n.count=0}function h(n){if(pa!=n.doubleSided){n.doubleSided?e.disable(e.CULL_FACE):e.enable(e.CULL_FACE);pa=n.doubleSided}if(sa!=n.flipSided){n.flipSided?e.frontFace(e.CW):e.frontFace(e.CCW);sa=n.flipSided}}function j(n){if(aa!=n){n?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST);aa=n}}function k(n){ua[0].set(n.n41-n.n11,n.n42-
n.n12,n.n43-n.n13,n.n44-n.n14);ua[1].set(n.n41+n.n11,n.n42+n.n12,n.n43+n.n13,n.n44+n.n14);ua[2].set(n.n41+n.n21,n.n42+n.n22,n.n43+n.n23,n.n44+n.n24);ua[3].set(n.n41-n.n21,n.n42-n.n22,n.n43-n.n23,n.n44-n.n24);ua[4].set(n.n41-n.n31,n.n42-n.n32,n.n43-n.n33,n.n44-n.n34);ua[5].set(n.n41+n.n31,n.n42+n.n32,n.n43+n.n33,n.n44+n.n34);var C;for(n=0;n<6;n++){C=ua[n];C.divideScalar(Math.sqrt(C.x*C.x+C.y*C.y+C.z*C.z))}}function m(n){for(var C=n.matrixWorld,w=-n.geometry.boundingSphere.radius*Math.max(n.scale.x,
Math.max(n.scale.y,n.scale.z)),x=0;x<6;x++){n=ua[x].x*C.n14+ua[x].y*C.n24+ua[x].z*C.n34+ua[x].w;if(n<=w)return!1}return!0}function p(n,C){n.list[n.count]=C;n.count+=1}function o(n){var C,w,x=n.object,z=n.opaque,J=n.transparent;J.count=0;n=z.count=0;for(C=x.materials.length;n<C;n++){w=x.materials[n];w.transparent?p(J,w):p(z,w)}}function u(n){var C,w,x,z,J=n.object,K=n.buffer,I=n.opaque,S=n.transparent;S.count=0;n=I.count=0;for(x=J.materials.length;n<x;n++){C=J.materials[n];if(C instanceof THREE.MeshFaceMaterial){C=
0;for(w=K.materials.length;C<w;C++)(z=K.materials[C])&&(z.transparent?p(S,z):p(I,z))}else(z=C)&&(z.transparent?p(S,z):p(I,z))}}function y(n,C){return C.z-n.z}function t(n){e.enable(e.POLYGON_OFFSET_FILL);e.polygonOffset(0.1,1);e.enable(e.STENCIL_TEST);e.enable(e.DEPTH_TEST);e.depthMask(!1);e.colorMask(!1,!1,!1,!1);e.stencilFunc(e.ALWAYS,1,255);e.stencilOpSeparate(e.BACK,e.KEEP,e.INCR,e.KEEP);e.stencilOpSeparate(e.FRONT,e.KEEP,e.DECR,e.KEEP);var C,w=n.lights.length,x,z=n.lights,J=[],K,I,S,D,O,L=n.__webglShadowVolumes.length;
for(C=0;C<w;C++){x=n.lights[C];if(x instanceof THREE.DirectionalLight){J[0]=-x.position.x;J[1]=-x.position.y;J[2]=-x.position.z;for(O=0;O<L;O++){x=n.__webglShadowVolumes[O].object;K=n.__webglShadowVolumes[O].buffer;I=x.materials[0];I.program||oa.initMaterial(I,z,undefined,x);I=I.program;S=I.uniforms;D=I.attributes;if(Ba!==I){e.useProgram(I);Ba=I;e.uniformMatrix4fv(S.projectionMatrix,!1,Ya);e.uniformMatrix4fv(S.viewMatrix,!1,Za);e.uniform3fv(S.directionalLightDirection,J)}x.matrixWorld.flattenToArray(x._objectMatrixArray);
e.uniformMatrix4fv(S.objectMatrix,!1,x._objectMatrixArray);e.bindBuffer(e.ARRAY_BUFFER,K.__webglVertexBuffer);e.vertexAttribPointer(D.position,3,e.FLOAT,!1,0,0);e.bindBuffer(e.ARRAY_BUFFER,K.__webglNormalBuffer);e.vertexAttribPointer(D.normal,3,e.FLOAT,!1,0,0);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,K.__webglFaceBuffer);e.cullFace(e.FRONT);e.drawElements(e.TRIANGLES,K.__webglFaceCount,e.UNSIGNED_SHORT,0);e.cullFace(e.BACK);e.drawElements(e.TRIANGLES,K.__webglFaceCount,e.UNSIGNED_SHORT,0)}}}e.disable(e.POLYGON_OFFSET_FILL);
e.colorMask(!0,!0,!0,!0);e.stencilFunc(e.NOTEQUAL,0,255);e.stencilOp(e.KEEP,e.KEEP,e.KEEP);e.disable(e.DEPTH_TEST);ga="";Ba=P.program;e.useProgram(P.program);e.uniformMatrix4fv(P.projectionLocation,!1,Ya);e.uniform1f(P.darknessLocation,P.darkness);e.bindBuffer(e.ARRAY_BUFFER,P.vertexBuffer);e.vertexAttribPointer(P.vertexLocation,3,e.FLOAT,!1,0,0);e.enableVertexAttribArray(P.vertexLocation);e.blendFunc(e.ONE,e.ONE_MINUS_SRC_ALPHA);e.blendEquation(e.FUNC_ADD);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,P.elementBuffer);
e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0);e.disable(e.STENCIL_TEST);e.enable(e.DEPTH_TEST);e.depthMask(Z)}function B(n,C){var w,x,z;w=_sprite.attributes;var J=_sprite.uniforms,K=la/ja,I,S=[],D=ja*0.5,O=la*0.5,L=!0;e.useProgram(_sprite.program);Ba=_sprite.program;ga="";if(!Ka){e.enableVertexAttribArray(_sprite.attributes.position);e.enableVertexAttribArray(_sprite.attributes.uv);Ka=!0}e.disable(e.CULL_FACE);e.enable(e.BLEND);e.depthMask(!0);e.bindBuffer(e.ARRAY_BUFFER,_sprite.vertexBuffer);
e.vertexAttribPointer(w.position,2,e.FLOAT,!1,16,0);e.vertexAttribPointer(w.uv,2,e.FLOAT,!1,16,8);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,_sprite.elementBuffer);e.uniformMatrix4fv(J.projectionMatrix,!1,Ya);e.activeTexture(e.TEXTURE0);e.uniform1i(J.map,0);w=0;for(x=n.__webglSprites.length;w<x;w++){z=n.__webglSprites[w];if(z.useScreenCoordinates)z.z=-z.position.z;else{z._modelViewMatrix.multiplyToArray(C.matrixWorldInverse,z.matrixWorld,z._modelViewMatrixArray);z.z=-z._modelViewMatrix.n34}}n.__webglSprites.sort(y);
w=0;for(x=n.__webglSprites.length;w<x;w++){z=n.__webglSprites[w];if(z.material===undefined&&z.map&&z.map.image&&z.map.image.width){if(z.useScreenCoordinates){e.uniform1i(J.useScreenCoordinates,1);e.uniform3f(J.screenPosition,(z.position.x-D)/D,(O-z.position.y)/O,Math.max(0,Math.min(1,z.position.z)))}else{e.uniform1i(J.useScreenCoordinates,0);e.uniform1i(J.affectedByDistance,z.affectedByDistance?1:0);e.uniformMatrix4fv(J.modelViewMatrix,!1,z._modelViewMatrixArray)}I=z.map.image.width/(z.affectedByDistance?
1:la);S[0]=I*K*z.scale.x;S[1]=I*z.scale.y;e.uniform2f(J.uvScale,z.uvScale.x,z.uvScale.y);e.uniform2f(J.uvOffset,z.uvOffset.x,z.uvOffset.y);e.uniform2f(J.alignment,z.alignment.x,z.alignment.y);e.uniform1f(J.opacity,z.opacity);e.uniform1f(J.rotation,z.rotation);e.uniform2fv(J.scale,S);if(z.mergeWith3D&&!L){e.enable(e.DEPTH_TEST);L=!0}else if(!z.mergeWith3D&&L){e.disable(e.DEPTH_TEST);L=!1}M(z.blending);R(z.map,0);e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0)}}e.enable(e.CULL_FACE);e.enable(e.DEPTH_TEST);
e.depthMask(Z)}function F(n,C){var w,x,z=n.__webglLensFlares.length,J,K,I,S=new THREE.Vector3,D=la/ja,O=ja*0.5,L=la*0.5,$=16/la,V=[$*D,$],xa=[1,1,0],Ja=[1,1],za=N.uniforms;w=N.attributes;e.useProgram(N.program);Ba=N.program;ga="";if(!Ca){e.enableVertexAttribArray(N.attributes.vertex);e.enableVertexAttribArray(N.attributes.uv);Ca=!0}e.uniform1i(za.occlusionMap,0);e.uniform1i(za.map,1);e.bindBuffer(e.ARRAY_BUFFER,N.vertexBuffer);e.vertexAttribPointer(w.vertex,2,e.FLOAT,!1,16,0);e.vertexAttribPointer(w.uv,
2,e.FLOAT,!1,16,8);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,N.elementBuffer);e.disable(e.CULL_FACE);e.depthMask(!1);e.activeTexture(e.TEXTURE0);e.bindTexture(e.TEXTURE_2D,N.occlusionTexture);e.activeTexture(e.TEXTURE1);for(x=0;x<z;x++){w=n.__webglLensFlares[x].object;S.set(w.matrixWorld.n14,w.matrixWorld.n24,w.matrixWorld.n34);C.matrixWorldInverse.multiplyVector3(S);C.projectionMatrix.multiplyVector3(S);xa[0]=S.x;xa[1]=S.y;xa[2]=S.z;Ja[0]=xa[0]*O+O;Ja[1]=xa[1]*L+L;if(N.hasVertexTexture||Ja[0]>0&&Ja[0]<
ja&&Ja[1]>0&&Ja[1]<la){e.bindTexture(e.TEXTURE_2D,N.tempTexture);e.copyTexImage2D(e.TEXTURE_2D,0,e.RGB,Ja[0]-8,Ja[1]-8,16,16,0);e.uniform1i(za.renderType,0);e.uniform2fv(za.scale,V);e.uniform3fv(za.screenPosition,xa);e.disable(e.BLEND);e.enable(e.DEPTH_TEST);e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0);e.bindTexture(e.TEXTURE_2D,N.occlusionTexture);e.copyTexImage2D(e.TEXTURE_2D,0,e.RGBA,Ja[0]-8,Ja[1]-8,16,16,0);e.uniform1i(za.renderType,1);e.disable(e.DEPTH_TEST);e.bindTexture(e.TEXTURE_2D,N.tempTexture);
e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0);w.positionScreen.x=xa[0];w.positionScreen.y=xa[1];w.positionScreen.z=xa[2];w.customUpdateCallback?w.customUpdateCallback(w):w.updateLensFlares();e.uniform1i(za.renderType,2);e.enable(e.BLEND);J=0;for(K=w.lensFlares.length;J<K;J++){I=w.lensFlares[J];if(I.opacity>0.001&&I.scale>0.001){xa[0]=I.x;xa[1]=I.y;xa[2]=I.z;$=I.size*I.scale/la;V[0]=$*D;V[1]=$;e.uniform3fv(za.screenPosition,xa);e.uniform2fv(za.scale,V);e.uniform1f(za.rotation,I.rotation);e.uniform1f(za.opacity,
I.opacity);M(I.blending);R(I.texture,1);e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0)}}}}e.enable(e.CULL_FACE);e.enable(e.DEPTH_TEST);e.depthMask(Z)}function H(n,C){n._modelViewMatrix.multiplyToArray(C.matrixWorldInverse,n.matrixWorld,n._modelViewMatrixArray);THREE.Matrix4.makeInvert3x3(n._modelViewMatrix).transposeIntoArray(n._normalMatrixArray)}function G(n){var C,w,x,z,J;if(n instanceof THREE.Mesh){w=n.geometry;for(C in w.geometryGroups){x=w.geometryGroups[C];J=!1;for(z in x.__webglCustomAttributes)if(x.__webglCustomAttributes[z].needsUpdate){J=
!0;break}if(w.__dirtyVertices||w.__dirtyMorphTargets||w.__dirtyElements||w.__dirtyUvs||w.__dirtyNormals||w.__dirtyColors||w.__dirtyTangents||J){J=e.DYNAMIC_DRAW;var K=void 0,I=void 0,S=void 0,D=void 0;S=void 0;var O=void 0,L=void 0,$=void 0,V=void 0,xa=void 0,Ja=void 0,za=void 0,ta=void 0,Oa=void 0,Ga=void 0,wa=void 0,Ha=void 0,Ua=void 0;L=void 0;$=void 0;D=void 0;V=void 0;D=void 0;var E=void 0,fa=void 0;L=void 0;E=void 0;fa=void 0;var v=void 0,bb=void 0;E=void 0;fa=void 0;v=void 0;bb=void 0;E=void 0;
fa=void 0;v=void 0;bb=void 0;E=void 0;fa=void 0;v=void 0;D=void 0;V=void 0;O=void 0;S=void 0;S=void 0;E=void 0;fa=void 0;v=void 0;var db=void 0,Ma=0,Pa=0,hb=0,eb=0,$a=0,ab=0,La=0,cb=0,Aa=0,U=0,Qa=0;fa=E=0;var Sa=x.__vertexArray,jb=x.__uvArray,Xa=x.__uv2Array,W=x.__normalArray,ia=x.__tangentArray,ka=x.__colorArray,da=x.__skinVertexAArray,ra=x.__skinVertexBArray,qa=x.__skinIndexArray,ha=x.__skinWeightArray,Y=x.__morphTargetsArrays,Ia=x.__webglCustomAttributes;v=void 0;var Va=x.__faceArray,Ta=x.__lineArray,
ib=x.__needsSmoothNormals;Ja=x.__vertexColorType;xa=x.__uvType;za=x.__normalType;var Wa=n.geometry,fb=Wa.__dirtyVertices,gb=Wa.__dirtyElements,qb=Wa.__dirtyUvs,rb=Wa.__dirtyNormals,sb=Wa.__dirtyTangents,tb=Wa.__dirtyColors,ub=Wa.__dirtyMorphTargets,mb=Wa.vertices,vb=x.faces,yb=Wa.faces,wb=Wa.faceVertexUvs[0],xb=Wa.faceVertexUvs[1],nb=Wa.skinVerticesA,ob=Wa.skinVerticesB,pb=Wa.skinIndices,kb=Wa.skinWeights,lb=n instanceof THREE.ShadowVolume?Wa.edgeFaces:undefined;morphTargets=Wa.morphTargets;if(Ia)for(db in Ia){Ia[db].offset=
0;Ia[db].offsetSrc=0}K=0;for(I=vb.length;K<I;K++){S=vb[K];D=yb[S];wb&&(ta=wb[S]);xb&&(Oa=xb[S]);S=D.vertexNormals;O=D.normal;L=D.vertexColors;$=D.color;V=D.vertexTangents;if(D instanceof THREE.Face3){if(fb){Ga=mb[D.a].position;wa=mb[D.b].position;Ha=mb[D.c].position;Sa[Pa]=Ga.x;Sa[Pa+1]=Ga.y;Sa[Pa+2]=Ga.z;Sa[Pa+3]=wa.x;Sa[Pa+4]=wa.y;Sa[Pa+5]=wa.z;Sa[Pa+6]=Ha.x;Sa[Pa+7]=Ha.y;Sa[Pa+8]=Ha.z;Pa+=9}if(Ia)for(db in Ia){v=Ia[db];if(v.needsUpdate){E=v.offset;fa=v.offsetSrc;if(v.size===1){if(v.boundTo===undefined||
v.boundTo==="vertices"){v.array[E+0]=v.value[D.a];v.array[E+1]=v.value[D.b];v.array[E+2]=v.value[D.c]}else if(v.boundTo==="faces"){v.array[E+0]=v.value[fa];v.array[E+1]=v.value[fa];v.array[E+2]=v.value[fa];v.offsetSrc++}else if(v.boundTo==="faceVertices"){v.array[E+0]=v.value[fa+0];v.array[E+1]=v.value[fa+1];v.array[E+2]=v.value[fa+2];v.offsetSrc+=3}v.offset+=3}else{if(v.boundTo===undefined||v.boundTo==="vertices"){Ga=v.value[D.a];wa=v.value[D.b];Ha=v.value[D.c]}else if(v.boundTo==="faces"){Ga=v.value[fa];
wa=v.value[fa];Ha=v.value[fa];v.offsetSrc++}else if(v.boundTo==="faceVertices"){Ga=v.value[fa+0];wa=v.value[fa+1];Ha=v.value[fa+2];v.offsetSrc+=3}if(v.size===2){v.array[E+0]=Ga.x;v.array[E+1]=Ga.y;v.array[E+2]=wa.x;v.array[E+3]=wa.y;v.array[E+4]=Ha.x;v.array[E+5]=Ha.y;v.offset+=6}else if(v.size===3){if(v.type==="c"){v.array[E+0]=Ga.r;v.array[E+1]=Ga.g;v.array[E+2]=Ga.b;v.array[E+3]=wa.r;v.array[E+4]=wa.g;v.array[E+5]=wa.b;v.array[E+6]=Ha.r;v.array[E+7]=Ha.g;v.array[E+8]=Ha.b}else{v.array[E+0]=Ga.x;
v.array[E+1]=Ga.y;v.array[E+2]=Ga.z;v.array[E+3]=wa.x;v.array[E+4]=wa.y;v.array[E+5]=wa.z;v.array[E+6]=Ha.x;v.array[E+7]=Ha.y;v.array[E+8]=Ha.z}v.offset+=9}else{v.array[E+0]=Ga.x;v.array[E+1]=Ga.y;v.array[E+2]=Ga.z;v.array[E+3]=Ga.w;v.array[E+4]=wa.x;v.array[E+5]=wa.y;v.array[E+6]=wa.z;v.array[E+7]=wa.w;v.array[E+8]=Ha.x;v.array[E+9]=Ha.y;v.array[E+10]=Ha.z;v.array[E+11]=Ha.w;v.offset+=12}}}}if(ub){E=0;for(fa=morphTargets.length;E<fa;E++){Ga=morphTargets[E].vertices[D.a].position;wa=morphTargets[E].vertices[D.b].position;
Ha=morphTargets[E].vertices[D.c].position;v=Y[E];v[Qa+0]=Ga.x;v[Qa+1]=Ga.y;v[Qa+2]=Ga.z;v[Qa+3]=wa.x;v[Qa+4]=wa.y;v[Qa+5]=wa.z;v[Qa+6]=Ha.x;v[Qa+7]=Ha.y;v[Qa+8]=Ha.z}Qa+=9}if(kb.length){E=kb[D.a];fa=kb[D.b];v=kb[D.c];ha[U]=E.x;ha[U+1]=E.y;ha[U+2]=E.z;ha[U+3]=E.w;ha[U+4]=fa.x;ha[U+5]=fa.y;ha[U+6]=fa.z;ha[U+7]=fa.w;ha[U+8]=v.x;ha[U+9]=v.y;ha[U+10]=v.z;ha[U+11]=v.w;E=pb[D.a];fa=pb[D.b];v=pb[D.c];qa[U]=E.x;qa[U+1]=E.y;qa[U+2]=E.z;qa[U+3]=E.w;qa[U+4]=fa.x;qa[U+5]=fa.y;qa[U+6]=fa.z;qa[U+7]=fa.w;qa[U+8]=
v.x;qa[U+9]=v.y;qa[U+10]=v.z;qa[U+11]=v.w;E=nb[D.a];fa=nb[D.b];v=nb[D.c];da[U]=E.x;da[U+1]=E.y;da[U+2]=E.z;da[U+3]=1;da[U+4]=fa.x;da[U+5]=fa.y;da[U+6]=fa.z;da[U+7]=1;da[U+8]=v.x;da[U+9]=v.y;da[U+10]=v.z;da[U+11]=1;E=ob[D.a];fa=ob[D.b];v=ob[D.c];ra[U]=E.x;ra[U+1]=E.y;ra[U+2]=E.z;ra[U+3]=1;ra[U+4]=fa.x;ra[U+5]=fa.y;ra[U+6]=fa.z;ra[U+7]=1;ra[U+8]=v.x;ra[U+9]=v.y;ra[U+10]=v.z;ra[U+11]=1;U+=12}if(tb&&Ja){if(L.length==3&&Ja==THREE.VertexColors){D=L[0];E=L[1];fa=L[2]}else fa=E=D=$;ka[Aa]=D.r;ka[Aa+1]=D.g;
ka[Aa+2]=D.b;ka[Aa+3]=E.r;ka[Aa+4]=E.g;ka[Aa+5]=E.b;ka[Aa+6]=fa.r;ka[Aa+7]=fa.g;ka[Aa+8]=fa.b;Aa+=9}if(sb&&Wa.hasTangents){L=V[0];$=V[1];D=V[2];ia[La]=L.x;ia[La+1]=L.y;ia[La+2]=L.z;ia[La+3]=L.w;ia[La+4]=$.x;ia[La+5]=$.y;ia[La+6]=$.z;ia[La+7]=$.w;ia[La+8]=D.x;ia[La+9]=D.y;ia[La+10]=D.z;ia[La+11]=D.w;La+=12}if(rb&&za)if(S.length==3&&ib)for(V=0;V<3;V++){O=S[V];W[ab]=O.x;W[ab+1]=O.y;W[ab+2]=O.z;ab+=3}else for(V=0;V<3;V++){W[ab]=O.x;W[ab+1]=O.y;W[ab+2]=O.z;ab+=3}if(qb&&ta!==undefined&&xa)for(V=0;V<3;V++){S=
ta[V];jb[hb]=S.u;jb[hb+1]=S.v;hb+=2}if(qb&&Oa!==undefined&&xa)for(V=0;V<3;V++){S=Oa[V];Xa[eb]=S.u;Xa[eb+1]=S.v;eb+=2}if(gb){Va[$a]=Ma;Va[$a+1]=Ma+1;Va[$a+2]=Ma+2;$a+=3;Ta[cb]=Ma;Ta[cb+1]=Ma+1;Ta[cb+2]=Ma;Ta[cb+3]=Ma+2;Ta[cb+4]=Ma+1;Ta[cb+5]=Ma+2;cb+=6;Ma+=3}}else if(D instanceof THREE.Face4){if(fb){Ga=mb[D.a].position;wa=mb[D.b].position;Ha=mb[D.c].position;Ua=mb[D.d].position;Sa[Pa]=Ga.x;Sa[Pa+1]=Ga.y;Sa[Pa+2]=Ga.z;Sa[Pa+3]=wa.x;Sa[Pa+4]=wa.y;Sa[Pa+5]=wa.z;Sa[Pa+6]=Ha.x;Sa[Pa+7]=Ha.y;Sa[Pa+8]=Ha.z;
Sa[Pa+9]=Ua.x;Sa[Pa+10]=Ua.y;Sa[Pa+11]=Ua.z;Pa+=12}if(Ia)for(db in Ia){v=Ia[db];if(v.needsUpdate){E=v.offset;fa=v.offsetSrc;if(v.size===1){if(v.boundTo===undefined||v.boundTo==="vertices"){v.array[E+0]=v.value[D.a];v.array[E+1]=v.value[D.b];v.array[E+2]=v.value[D.c];v.array[E+2]=v.value[D.d]}else if(v.boundTo==="faces"){v.array[E+0]=v.value[fa];v.array[E+1]=v.value[fa];v.array[E+2]=v.value[fa];v.array[E+2]=v.value[fa];v.offsetSrc++}else if(v.boundTo==="faceVertices"){v.array[E+0]=v.value[fa+0];v.array[E+
1]=v.value[fa+1];v.array[E+2]=v.value[fa+2];v.array[E+2]=v.value[fa+3];v.offsetSrc+=4}v.offset+=4}else{if(v.boundTo===undefined||v.boundTo==="vertices"){Ga=v.value[D.a];wa=v.value[D.b];Ha=v.value[D.c];Ua=v.value[D.d]}else if(v.boundTo==="faces"){Ga=v.value[fa];wa=v.value[fa];Ha=v.value[fa];Ua=v.value[fa];v.offsetSrc++}else if(v.boundTo==="faceVertices"){Ga=v.value[fa+0];wa=v.value[fa+1];Ha=v.value[fa+2];Ua=v.value[fa+3];v.offsetSrc+=4}if(v.size===2){v.array[E+0]=Ga.x;v.array[E+1]=Ga.y;v.array[E+2]=
wa.x;v.array[E+3]=wa.y;v.array[E+4]=Ha.x;v.array[E+5]=Ha.y;v.array[E+6]=Ua.x;v.array[E+7]=Ua.y;v.offset+=8}else if(v.size===3){if(v.type==="c"){v.array[E+0]=Ga.r;v.array[E+1]=Ga.g;v.array[E+2]=Ga.b;v.array[E+3]=wa.r;v.array[E+4]=wa.g;v.array[E+5]=wa.b;v.array[E+6]=Ha.r;v.array[E+7]=Ha.g;v.array[E+8]=Ha.b;v.array[E+9]=Ua.r;v.array[E+10]=Ua.g;v.array[E+11]=Ua.b}else{v.array[E+0]=Ga.x;v.array[E+1]=Ga.y;v.array[E+2]=Ga.z;v.array[E+3]=wa.x;v.array[E+4]=wa.y;v.array[E+5]=wa.z;v.array[E+6]=Ha.x;v.array[E+
7]=Ha.y;v.array[E+8]=Ha.z;v.array[E+9]=Ua.x;v.array[E+10]=Ua.y;v.array[E+11]=Ua.z}v.offset+=12}else{v.array[E+0]=Ga.x;v.array[E+1]=Ga.y;v.array[E+2]=Ga.z;v.array[E+3]=Ga.w;v.array[E+4]=wa.x;v.array[E+5]=wa.y;v.array[E+6]=wa.z;v.array[E+7]=wa.w;v.array[E+8]=Ha.x;v.array[E+9]=Ha.y;v.array[E+10]=Ha.z;v.array[E+11]=Ha.w;v.array[E+12]=Ua.x;v.array[E+13]=Ua.y;v.array[E+14]=Ua.z;v.array[E+15]=Ua.w;v.offset+=16}}}}if(ub){E=0;for(fa=morphTargets.length;E<fa;E++){Ga=morphTargets[E].vertices[D.a].position;wa=
morphTargets[E].vertices[D.b].position;Ha=morphTargets[E].vertices[D.c].position;Ua=morphTargets[E].vertices[D.d].position;v=Y[E];v[Qa+0]=Ga.x;v[Qa+1]=Ga.y;v[Qa+2]=Ga.z;v[Qa+3]=wa.x;v[Qa+4]=wa.y;v[Qa+5]=wa.z;v[Qa+6]=Ha.x;v[Qa+7]=Ha.y;v[Qa+8]=Ha.z;v[Qa+9]=Ua.x;v[Qa+10]=Ua.y;v[Qa+11]=Ua.z}Qa+=12}if(kb.length){E=kb[D.a];fa=kb[D.b];v=kb[D.c];bb=kb[D.d];ha[U]=E.x;ha[U+1]=E.y;ha[U+2]=E.z;ha[U+3]=E.w;ha[U+4]=fa.x;ha[U+5]=fa.y;ha[U+6]=fa.z;ha[U+7]=fa.w;ha[U+8]=v.x;ha[U+9]=v.y;ha[U+10]=v.z;ha[U+11]=v.w;ha[U+
12]=bb.x;ha[U+13]=bb.y;ha[U+14]=bb.z;ha[U+15]=bb.w;E=pb[D.a];fa=pb[D.b];v=pb[D.c];bb=pb[D.d];qa[U]=E.x;qa[U+1]=E.y;qa[U+2]=E.z;qa[U+3]=E.w;qa[U+4]=fa.x;qa[U+5]=fa.y;qa[U+6]=fa.z;qa[U+7]=fa.w;qa[U+8]=v.x;qa[U+9]=v.y;qa[U+10]=v.z;qa[U+11]=v.w;qa[U+12]=bb.x;qa[U+13]=bb.y;qa[U+14]=bb.z;qa[U+15]=bb.w;E=nb[D.a];fa=nb[D.b];v=nb[D.c];bb=nb[D.d];da[U]=E.x;da[U+1]=E.y;da[U+2]=E.z;da[U+3]=1;da[U+4]=fa.x;da[U+5]=fa.y;da[U+6]=fa.z;da[U+7]=1;da[U+8]=v.x;da[U+9]=v.y;da[U+10]=v.z;da[U+11]=1;da[U+12]=bb.x;da[U+13]=
bb.y;da[U+14]=bb.z;da[U+15]=1;E=ob[D.a];fa=ob[D.b];v=ob[D.c];D=ob[D.d];ra[U]=E.x;ra[U+1]=E.y;ra[U+2]=E.z;ra[U+3]=1;ra[U+4]=fa.x;ra[U+5]=fa.y;ra[U+6]=fa.z;ra[U+7]=1;ra[U+8]=v.x;ra[U+9]=v.y;ra[U+10]=v.z;ra[U+11]=1;ra[U+12]=D.x;ra[U+13]=D.y;ra[U+14]=D.z;ra[U+15]=1;U+=16}if(tb&&Ja){if(L.length==4&&Ja==THREE.VertexColors){D=L[0];E=L[1];fa=L[2];L=L[3]}else L=fa=E=D=$;ka[Aa]=D.r;ka[Aa+1]=D.g;ka[Aa+2]=D.b;ka[Aa+3]=E.r;ka[Aa+4]=E.g;ka[Aa+5]=E.b;ka[Aa+6]=fa.r;ka[Aa+7]=fa.g;ka[Aa+8]=fa.b;ka[Aa+9]=L.r;ka[Aa+
10]=L.g;ka[Aa+11]=L.b;Aa+=12}if(sb&&Wa.hasTangents){L=V[0];$=V[1];D=V[2];V=V[3];ia[La]=L.x;ia[La+1]=L.y;ia[La+2]=L.z;ia[La+3]=L.w;ia[La+4]=$.x;ia[La+5]=$.y;ia[La+6]=$.z;ia[La+7]=$.w;ia[La+8]=D.x;ia[La+9]=D.y;ia[La+10]=D.z;ia[La+11]=D.w;ia[La+12]=V.x;ia[La+13]=V.y;ia[La+14]=V.z;ia[La+15]=V.w;La+=16}if(rb&&za)if(S.length==4&&ib)for(V=0;V<4;V++){O=S[V];W[ab]=O.x;W[ab+1]=O.y;W[ab+2]=O.z;ab+=3}else for(V=0;V<4;V++){W[ab]=O.x;W[ab+1]=O.y;W[ab+2]=O.z;ab+=3}if(qb&&ta!==undefined&&xa)for(V=0;V<4;V++){S=ta[V];
jb[hb]=S.u;jb[hb+1]=S.v;hb+=2}if(qb&&Oa!==undefined&&xa)for(V=0;V<4;V++){S=Oa[V];Xa[eb]=S.u;Xa[eb+1]=S.v;eb+=2}if(gb){Va[$a]=Ma;Va[$a+1]=Ma+1;Va[$a+2]=Ma+3;Va[$a+3]=Ma+1;Va[$a+4]=Ma+2;Va[$a+5]=Ma+3;$a+=6;Ta[cb]=Ma;Ta[cb+1]=Ma+1;Ta[cb+2]=Ma;Ta[cb+3]=Ma+3;Ta[cb+4]=Ma+1;Ta[cb+5]=Ma+2;Ta[cb+6]=Ma+2;Ta[cb+7]=Ma+3;cb+=8;Ma+=4}}}if(lb){K=0;for(I=lb.length;K<I;K++){Va[$a]=lb[K].a;Va[$a+1]=lb[K].b;Va[$a+2]=lb[K].c;Va[$a+3]=lb[K].a;Va[$a+4]=lb[K].c;Va[$a+5]=lb[K].d;$a+=6}}if(fb){e.bindBuffer(e.ARRAY_BUFFER,
x.__webglVertexBuffer);e.bufferData(e.ARRAY_BUFFER,Sa,J)}if(Ia)for(db in Ia){v=Ia[db];if(v.needsUpdate){e.bindBuffer(e.ARRAY_BUFFER,v.buffer);e.bufferData(e.ARRAY_BUFFER,v.array,J);v.needsUpdate=!1}}if(ub){E=0;for(fa=morphTargets.length;E<fa;E++){e.bindBuffer(e.ARRAY_BUFFER,x.__webglMorphTargetsBuffers[E]);e.bufferData(e.ARRAY_BUFFER,Y[E],J)}}if(tb&&Aa>0){e.bindBuffer(e.ARRAY_BUFFER,x.__webglColorBuffer);e.bufferData(e.ARRAY_BUFFER,ka,J)}if(rb){e.bindBuffer(e.ARRAY_BUFFER,x.__webglNormalBuffer);e.bufferData(e.ARRAY_BUFFER,
W,J)}if(sb&&Wa.hasTangents){e.bindBuffer(e.ARRAY_BUFFER,x.__webglTangentBuffer);e.bufferData(e.ARRAY_BUFFER,ia,J)}if(qb&&hb>0){e.bindBuffer(e.ARRAY_BUFFER,x.__webglUVBuffer);e.bufferData(e.ARRAY_BUFFER,jb,J)}if(qb&&eb>0){e.bindBuffer(e.ARRAY_BUFFER,x.__webglUV2Buffer);e.bufferData(e.ARRAY_BUFFER,Xa,J)}if(gb){e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,x.__webglFaceBuffer);e.bufferData(e.ELEMENT_ARRAY_BUFFER,Va,J);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,x.__webglLineBuffer);e.bufferData(e.ELEMENT_ARRAY_BUFFER,
Ta,J)}if(U>0){e.bindBuffer(e.ARRAY_BUFFER,x.__webglSkinVertexABuffer);e.bufferData(e.ARRAY_BUFFER,da,J);e.bindBuffer(e.ARRAY_BUFFER,x.__webglSkinVertexBBuffer);e.bufferData(e.ARRAY_BUFFER,ra,J);e.bindBuffer(e.ARRAY_BUFFER,x.__webglSkinIndicesBuffer);e.bufferData(e.ARRAY_BUFFER,qa,J);e.bindBuffer(e.ARRAY_BUFFER,x.__webglSkinWeightsBuffer);e.bufferData(e.ARRAY_BUFFER,ha,J)}}}w.__dirtyVertices=!1;w.__dirtyMorphTargets=!1;w.__dirtyElements=!1;w.__dirtyUvs=!1;w.__dirtyNormals=!1;w.__dirtyTangents=!1;w.__dirtyColors=
!1}else if(n instanceof THREE.Ribbon){w=n.geometry;if(w.__dirtyVertices||w.__dirtyColors){n=w;C=e.DYNAMIC_DRAW;Ja=n.vertices;x=n.colors;za=Ja.length;J=x.length;ta=n.__vertexArray;K=n.__colorArray;Oa=n.__dirtyColors;if(n.__dirtyVertices){for(I=0;I<za;I++){xa=Ja[I].position;z=I*3;ta[z]=xa.x;ta[z+1]=xa.y;ta[z+2]=xa.z}e.bindBuffer(e.ARRAY_BUFFER,n.__webglVertexBuffer);e.bufferData(e.ARRAY_BUFFER,ta,C)}if(Oa){for(I=0;I<J;I++){color=x[I];z=I*3;K[z]=color.r;K[z+1]=color.g;K[z+2]=color.b}e.bindBuffer(e.ARRAY_BUFFER,
n.__webglColorBuffer);e.bufferData(e.ARRAY_BUFFER,K,C)}}w.__dirtyVertices=!1;w.__dirtyColors=!1}else if(n instanceof THREE.Line){w=n.geometry;if(w.__dirtyVertices||w.__dirtyColors){n=w;C=e.DYNAMIC_DRAW;Ja=n.vertices;x=n.colors;za=Ja.length;J=x.length;ta=n.__vertexArray;K=n.__colorArray;Oa=n.__dirtyColors;if(n.__dirtyVertices){for(I=0;I<za;I++){xa=Ja[I].position;z=I*3;ta[z]=xa.x;ta[z+1]=xa.y;ta[z+2]=xa.z}e.bindBuffer(e.ARRAY_BUFFER,n.__webglVertexBuffer);e.bufferData(e.ARRAY_BUFFER,ta,C)}if(Oa){for(I=
0;I<J;I++){color=x[I];z=I*3;K[z]=color.r;K[z+1]=color.g;K[z+2]=color.b}e.bindBuffer(e.ARRAY_BUFFER,n.__webglColorBuffer);e.bufferData(e.ARRAY_BUFFER,K,C)}}w.__dirtyVertices=!1;w.__dirtyColors=!1}else if(n instanceof THREE.ParticleSystem){w=n.geometry;(w.__dirtyVertices||w.__dirtyColors||n.sortParticles)&&d(w,e.DYNAMIC_DRAW,n);w.__dirtyVertices=!1;w.__dirtyColors=!1}}function X(n){function C($){var V=[];w=0;for(x=$.length;w<x;w++)$[w]==undefined?V.push("undefined"):V.push($[w].id);return V.join("_")}
var w,x,z,J,K,I,S,D,O={},L=n.morphTargets!==undefined?n.morphTargets.length:0;n.geometryGroups={};z=0;for(J=n.faces.length;z<J;z++){K=n.faces[z];I=K.materials;S=C(I);O[S]==undefined&&(O[S]={hash:S,counter:0});D=O[S].hash+"_"+O[S].counter;n.geometryGroups[D]==undefined&&(n.geometryGroups[D]={faces:[],materials:I,vertices:0,numMorphTargets:L});K=K instanceof THREE.Face3?3:4;if(n.geometryGroups[D].vertices+K>65535){O[S].counter+=1;D=O[S].hash+"_"+O[S].counter;n.geometryGroups[D]==undefined&&(n.geometryGroups[D]=
{faces:[],materials:I,vertices:0,numMorphTargets:L})}n.geometryGroups[D].faces.push(z);n.geometryGroups[D].vertices+=K}}function A(n,C,w){n.push({buffer:C,object:w,opaque:{list:[],count:0},transparent:{list:[],count:0}})}function M(n){if(n!=ga){switch(n){case THREE.AdditiveBlending:e.blendEquation(e.FUNC_ADD);e.blendFunc(e.SRC_ALPHA,e.ONE);break;case THREE.SubtractiveBlending:e.blendEquation(e.FUNC_ADD);e.blendFunc(e.ZERO,e.ONE_MINUS_SRC_COLOR);break;case THREE.MultiplyBlending:e.blendEquation(e.FUNC_ADD);
e.blendFunc(e.ZERO,e.SRC_COLOR);break;default:e.blendEquationSeparate(e.FUNC_ADD,e.FUNC_ADD);e.blendFuncSeparate(e.SRC_ALPHA,e.ONE_MINUS_SRC_ALPHA,e.ONE,e.ONE_MINUS_SRC_ALPHA)}ga=n}}function Q(n,C,w){if((w.width&w.width-1)==0&&(w.height&w.height-1)==0){e.texParameteri(n,e.TEXTURE_WRAP_S,ca(C.wrapS));e.texParameteri(n,e.TEXTURE_WRAP_T,ca(C.wrapT));e.texParameteri(n,e.TEXTURE_MAG_FILTER,ca(C.magFilter));e.texParameteri(n,e.TEXTURE_MIN_FILTER,ca(C.minFilter));e.generateMipmap(n)}else{e.texParameteri(n,
e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE);e.texParameteri(n,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE);e.texParameteri(n,e.TEXTURE_MAG_FILTER,va(C.magFilter));e.texParameteri(n,e.TEXTURE_MIN_FILTER,va(C.minFilter))}}function R(n,C){if(n.needsUpdate){if(n.__webglInit){e.bindTexture(e.TEXTURE_2D,n.__webglTexture);e.texSubImage2D(e.TEXTURE_2D,0,0,0,e.RGBA,e.UNSIGNED_BYTE,n.image)}else{n.__webglTexture=e.createTexture();e.bindTexture(e.TEXTURE_2D,n.__webglTexture);e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,
n.image);n.__webglInit=!0}Q(e.TEXTURE_2D,n,n.image);e.bindTexture(e.TEXTURE_2D,null);n.needsUpdate=!1}e.activeTexture(e.TEXTURE0+C);e.bindTexture(e.TEXTURE_2D,n.__webglTexture)}function Da(n){if(n&&!n.__webglFramebuffer){if(n.depthBuffer===undefined)n.depthBuffer=!0;if(n.stencilBuffer===undefined)n.stencilBuffer=!0;n.__webglFramebuffer=e.createFramebuffer();n.__webglRenderbuffer=e.createRenderbuffer();n.__webglTexture=e.createTexture();e.bindTexture(e.TEXTURE_2D,n.__webglTexture);e.texParameteri(e.TEXTURE_2D,
e.TEXTURE_WRAP_S,ca(n.wrapS));e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,ca(n.wrapT));e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,ca(n.magFilter));e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,ca(n.minFilter));e.texImage2D(e.TEXTURE_2D,0,ca(n.format),n.width,n.height,0,ca(n.format),ca(n.type),null);e.bindRenderbuffer(e.RENDERBUFFER,n.__webglRenderbuffer);e.bindFramebuffer(e.FRAMEBUFFER,n.__webglFramebuffer);e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,n.__webglTexture,
0);if(n.depthBuffer&&!n.stencilBuffer){e.renderbufferStorage(e.RENDERBUFFER,e.DEPTH_COMPONENT16,n.width,n.height);e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_ATTACHMENT,e.RENDERBUFFER,n.__webglRenderbuffer)}else if(n.depthBuffer&&n.stencilBuffer){e.renderbufferStorage(e.RENDERBUFFER,e.DEPTH_STENCIL,n.width,n.height);e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_STENCIL_ATTACHMENT,e.RENDERBUFFER,n.__webglRenderbuffer)}else e.renderbufferStorage(e.RENDERBUFFER,e.RGBA4,n.width,n.height);e.bindTexture(e.TEXTURE_2D,
null);e.bindRenderbuffer(e.RENDERBUFFER,null);e.bindFramebuffer(e.FRAMEBUFFER,null)}var C,w;if(n){C=n.__webglFramebuffer;w=n.width;n=n.height}else{C=null;w=ja;n=la}if(C!=Fa){e.bindFramebuffer(e.FRAMEBUFFER,C);e.viewport(na,Ea,w,n);Fa=C}}function ma(n,C){var w;if(n=="fragment")w=e.createShader(e.FRAGMENT_SHADER);else n=="vertex"&&(w=e.createShader(e.VERTEX_SHADER));e.shaderSource(w,C);e.compileShader(w);if(!e.getShaderParameter(w,e.COMPILE_STATUS)){console.error(e.getShaderInfoLog(w));console.error(C);
return null}return w}function va(n){switch(n){case THREE.NearestFilter:case THREE.NearestMipMapNearestFilter:case THREE.NearestMipMapLinearFilter:return e.NEAREST;default:return e.LINEAR}}function ca(n){switch(n){case THREE.RepeatWrapping:return e.REPEAT;case THREE.ClampToEdgeWrapping:return e.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return e.MIRRORED_REPEAT;case THREE.NearestFilter:return e.NEAREST;case THREE.NearestMipMapNearestFilter:return e.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return e.NEAREST_MIPMAP_LINEAR;
case THREE.LinearFilter:return e.LINEAR;case THREE.LinearMipMapNearestFilter:return e.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return e.LINEAR_MIPMAP_LINEAR;case THREE.ByteType:return e.BYTE;case THREE.UnsignedByteType:return e.UNSIGNED_BYTE;case THREE.ShortType:return e.SHORT;case THREE.UnsignedShortType:return e.UNSIGNED_SHORT;case THREE.IntType:return e.INT;case THREE.UnsignedShortType:return e.UNSIGNED_INT;case THREE.FloatType:return e.FLOAT;case THREE.AlphaFormat:return e.ALPHA;
case THREE.RGBFormat:return e.RGB;case THREE.RGBAFormat:return e.RGBA;case THREE.LuminanceFormat:return e.LUMINANCE;case THREE.LuminanceAlphaFormat:return e.LUMINANCE_ALPHA}return 0}var e,ea=document.createElement("canvas"),ya=[],Ba=null,Fa=null,Z=!0,oa=this,pa=null,sa=null,ga=null,aa=null,na=0,Ea=0,ja=0,la=0,ua=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],Ra=new THREE.Matrix4,Ya=new Float32Array(16),Za=new Float32Array(16),Na=new THREE.Vector4,
T={ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[],distances:[]}};b=b||{};stencil=b.stencil!==undefined?b.stencil:!0;antialias=b.antialias!==undefined?b.antialias:!1;clearColor=b.clearColor!==undefined?new THREE.Color(b.clearColor):new THREE.Color(0);clearAlpha=b.clearAlpha!==undefined?b.clearAlpha:0;this.maxMorphTargets=8;this.domElement=ea;this.autoClear=!0;this.sortObjects=!0;(function(n,C,w,x){try{if(!(e=ea.getContext("experimental-webgl",{antialias:n,
stencil:x})))throw"Error creating WebGL context.";}catch(z){console.error(z)}console.log(navigator.userAgent+" | "+e.getParameter(e.VERSION)+" | "+e.getParameter(e.VENDOR)+" | "+e.getParameter(e.RENDERER)+" | "+e.getParameter(e.SHADING_LANGUAGE_VERSION));e.clearColor(0,0,0,1);e.clearDepth(1);e.enable(e.DEPTH_TEST);e.depthFunc(e.LEQUAL);e.frontFace(e.CCW);e.cullFace(e.BACK);e.enable(e.CULL_FACE);e.enable(e.BLEND);e.blendEquation(e.FUNC_ADD);e.blendFunc(e.SRC_ALPHA,e.ONE_MINUS_SRC_ALPHA);e.clearColor(C.r,
C.g,C.b,w)})(antialias,clearColor,clearAlpha,stencil);this.context=e;if(stencil){var P={};P.vertices=new Float32Array(12);P.faces=new Uint16Array(6);P.darkness=0.5;P.vertices[0]=-20;P.vertices[1]=-20;P.vertices[2]=-1;P.vertices[3]=20;P.vertices[4]=-20;P.vertices[5]=-1;P.vertices[6]=20;P.vertices[7]=20;P.vertices[8]=-1;P.vertices[9]=-20;P.vertices[10]=20;P.vertices[11]=-1;P.faces[0]=0;P.faces[1]=1;P.faces[2]=2;P.faces[3]=0;P.faces[4]=2;P.faces[5]=3;P.vertexBuffer=e.createBuffer();P.elementBuffer=e.createBuffer();
e.bindBuffer(e.ARRAY_BUFFER,P.vertexBuffer);e.bufferData(e.ARRAY_BUFFER,P.vertices,e.STATIC_DRAW);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,P.elementBuffer);e.bufferData(e.ELEMENT_ARRAY_BUFFER,P.faces,e.STATIC_DRAW);P.program=e.createProgram();e.attachShader(P.program,ma("fragment",THREE.ShaderLib.shadowPost.fragmentShader));e.attachShader(P.program,ma("vertex",THREE.ShaderLib.shadowPost.vertexShader));e.linkProgram(P.program);P.vertexLocation=e.getAttribLocation(P.program,"position");P.projectionLocation=
e.getUniformLocation(P.program,"projectionMatrix");P.darknessLocation=e.getUniformLocation(P.program,"darkness")}var N={};N.vertices=new Float32Array(16);N.faces=new Uint16Array(6);b=0;N.vertices[b++]=-1;N.vertices[b++]=-1;N.vertices[b++]=0;N.vertices[b++]=0;N.vertices[b++]=1;N.vertices[b++]=-1;N.vertices[b++]=1;N.vertices[b++]=0;N.vertices[b++]=1;N.vertices[b++]=1;N.vertices[b++]=1;N.vertices[b++]=1;N.vertices[b++]=-1;N.vertices[b++]=1;N.vertices[b++]=0;N.vertices[b++]=1;b=0;N.faces[b++]=0;N.faces[b++]=
1;N.faces[b++]=2;N.faces[b++]=0;N.faces[b++]=2;N.faces[b++]=3;N.vertexBuffer=e.createBuffer();N.elementBuffer=e.createBuffer();N.tempTexture=e.createTexture();N.occlusionTexture=e.createTexture();e.bindBuffer(e.ARRAY_BUFFER,N.vertexBuffer);e.bufferData(e.ARRAY_BUFFER,N.vertices,e.STATIC_DRAW);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,N.elementBuffer);e.bufferData(e.ELEMENT_ARRAY_BUFFER,N.faces,e.STATIC_DRAW);e.bindTexture(e.TEXTURE_2D,N.tempTexture);e.texImage2D(e.TEXTURE_2D,0,e.RGB,16,16,0,e.RGB,e.UNSIGNED_BYTE,
null);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.NEAREST);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.NEAREST);e.bindTexture(e.TEXTURE_2D,N.occlusionTexture);e.texImage2D(e.TEXTURE_2D,0,e.RGBA,16,16,0,e.RGBA,e.UNSIGNED_BYTE,null);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE);e.texParameteri(e.TEXTURE_2D,
e.TEXTURE_MAG_FILTER,e.NEAREST);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.NEAREST);if(e.getParameter(e.MAX_VERTEX_TEXTURE_IMAGE_UNITS)<=0){N.hasVertexTexture=!1;N.program=e.createProgram();e.attachShader(N.program,ma("fragment",THREE.ShaderLib.lensFlare.fragmentShader));e.attachShader(N.program,ma("vertex",THREE.ShaderLib.lensFlare.vertexShader))}else{N.hasVertexTexture=!0;N.program=e.createProgram();e.attachShader(N.program,ma("fragment",THREE.ShaderLib.lensFlareVertexTexture.fragmentShader));
e.attachShader(N.program,ma("vertex",THREE.ShaderLib.lensFlareVertexTexture.vertexShader))}e.linkProgram(N.program);N.attributes={};N.uniforms={};N.attributes.vertex=e.getAttribLocation(N.program,"position");N.attributes.uv=e.getAttribLocation(N.program,"UV");N.uniforms.renderType=e.getUniformLocation(N.program,"renderType");N.uniforms.map=e.getUniformLocation(N.program,"map");N.uniforms.occlusionMap=e.getUniformLocation(N.program,"occlusionMap");N.uniforms.opacity=e.getUniformLocation(N.program,
"opacity");N.uniforms.scale=e.getUniformLocation(N.program,"scale");N.uniforms.rotation=e.getUniformLocation(N.program,"rotation");N.uniforms.screenPosition=e.getUniformLocation(N.program,"screenPosition");var Ca=!1;_sprite={};_sprite.vertices=new Float32Array(16);_sprite.faces=new Uint16Array(6);b=0;_sprite.vertices[b++]=-1;_sprite.vertices[b++]=-1;_sprite.vertices[b++]=0;_sprite.vertices[b++]=0;_sprite.vertices[b++]=1;_sprite.vertices[b++]=-1;_sprite.vertices[b++]=1;_sprite.vertices[b++]=0;_sprite.vertices[b++]=
1;_sprite.vertices[b++]=1;_sprite.vertices[b++]=1;_sprite.vertices[b++]=1;_sprite.vertices[b++]=-1;_sprite.vertices[b++]=1;_sprite.vertices[b++]=0;_sprite.vertices[b++]=1;b=0;_sprite.faces[b++]=0;_sprite.faces[b++]=1;_sprite.faces[b++]=2;_sprite.faces[b++]=0;_sprite.faces[b++]=2;_sprite.faces[b++]=3;_sprite.vertexBuffer=e.createBuffer();_sprite.elementBuffer=e.createBuffer();e.bindBuffer(e.ARRAY_BUFFER,_sprite.vertexBuffer);e.bufferData(e.ARRAY_BUFFER,_sprite.vertices,e.STATIC_DRAW);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,
_sprite.elementBuffer);e.bufferData(e.ELEMENT_ARRAY_BUFFER,_sprite.faces,e.STATIC_DRAW);_sprite.program=e.createProgram();e.attachShader(_sprite.program,ma("fragment",THREE.ShaderLib.sprite.fragmentShader));e.attachShader(_sprite.program,ma("vertex",THREE.ShaderLib.sprite.vertexShader));e.linkProgram(_sprite.program);_sprite.attributes={};_sprite.uniforms={};_sprite.attributes.position=e.getAttribLocation(_sprite.program,"position");_sprite.attributes.uv=e.getAttribLocation(_sprite.program,"uv");
_sprite.uniforms.uvOffset=e.getUniformLocation(_sprite.program,"uvOffset");_sprite.uniforms.uvScale=e.getUniformLocation(_sprite.program,"uvScale");_sprite.uniforms.rotation=e.getUniformLocation(_sprite.program,"rotation");_sprite.uniforms.scale=e.getUniformLocation(_sprite.program,"scale");_sprite.uniforms.alignment=e.getUniformLocation(_sprite.program,"alignment");_sprite.uniforms.map=e.getUniformLocation(_sprite.program,"map");_sprite.uniforms.opacity=e.getUniformLocation(_sprite.program,"opacity");
_sprite.uniforms.useScreenCoordinates=e.getUniformLocation(_sprite.program,"useScreenCoordinates");_sprite.uniforms.affectedByDistance=e.getUniformLocation(_sprite.program,"affectedByDistance");_sprite.uniforms.screenPosition=e.getUniformLocation(_sprite.program,"screenPosition");_sprite.uniforms.modelViewMatrix=e.getUniformLocation(_sprite.program,"modelViewMatrix");_sprite.uniforms.projectionMatrix=e.getUniformLocation(_sprite.program,"projectionMatrix");var Ka=!1;this.setSize=function(n,C){ea.width=
n;ea.height=C;this.setViewport(0,0,ea.width,ea.height)};this.setViewport=function(n,C,w,x){na=n;Ea=C;ja=w;la=x;e.viewport(na,Ea,ja,la)};this.setScissor=function(n,C,w,x){e.scissor(n,C,w,x)};this.enableScissorTest=function(n){n?e.enable(e.SCISSOR_TEST):e.disable(e.SCISSOR_TEST)};this.enableDepthBufferWrite=function(n){Z=n;e.depthMask(n)};this.setClearColorHex=function(n,C){var w=new THREE.Color(n);e.clearColor(w.r,w.g,w.b,C)};this.setClearColor=function(n,C){e.clearColor(n.r,n.g,n.b,C)};this.clear=
function(){e.clear(e.COLOR_BUFFER_BIT|e.DEPTH_BUFFER_BIT|e.STENCIL_BUFFER_BIT)};this.setStencilShadowDarkness=function(n){P.darkness=n};this.initMaterial=function(n,C,w,x){var z,J,K;if(n instanceof THREE.MeshDepthMaterial)K="depth";else if(n instanceof THREE.ShadowVolumeDynamicMaterial)K="shadowVolumeDynamic";else if(n instanceof THREE.MeshNormalMaterial)K="normal";else if(n instanceof THREE.MeshBasicMaterial)K="basic";else if(n instanceof THREE.MeshLambertMaterial)K="lambert";else if(n instanceof
THREE.MeshPhongMaterial)K="phong";else if(n instanceof THREE.LineBasicMaterial)K="basic";else n instanceof THREE.ParticleBasicMaterial&&(K="particle_basic");if(K){var I=THREE.ShaderLib[K];n.uniforms=THREE.UniformsUtils.clone(I.uniforms);n.vertexShader=I.vertexShader;n.fragmentShader=I.fragmentShader}var S,D,O;S=O=I=0;for(D=C.length;S<D;S++){J=C[S];J instanceof THREE.DirectionalLight&&O++;J instanceof THREE.PointLight&&I++}if(I+O<=4)C=O;else{C=Math.ceil(4*O/(I+O));I=4-C}J={directional:C,point:I};O=
50;if(x!==undefined&&x instanceof THREE.SkinnedMesh)O=x.bones.length;var L;a:{S=n.fragmentShader;D=n.vertexShader;I=n.uniforms;C=n.attributes;w={map:!!n.map,envMap:!!n.envMap,lightMap:!!n.lightMap,vertexColors:n.vertexColors,fog:w,sizeAttenuation:n.sizeAttenuation,skinning:n.skinning,morphTargets:n.morphTargets,maxMorphTargets:this.maxMorphTargets,maxDirLights:J.directional,maxPointLights:J.point,maxBones:O};var $;J=[];if(K)J.push(K);else{J.push(S);J.push(D)}for($ in w){J.push($);J.push(w[$])}K=J.join();
$=0;for(J=ya.length;$<J;$++)if(ya[$].code==K){L=ya[$].program;break a}$=e.createProgram();prefix_fragment=["#ifdef GL_ES\nprecision highp float;\n#endif","#define MAX_DIR_LIGHTS "+w.maxDirLights,"#define MAX_POINT_LIGHTS "+w.maxPointLights,w.fog?"#define USE_FOG":"",w.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",w.map?"#define USE_MAP":"",w.envMap?"#define USE_ENVMAP":"",w.lightMap?"#define USE_LIGHTMAP":"",w.vertexColors?"#define USE_COLOR":"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");
prefix_vertex=[e.getParameter(e.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0?"#define VERTEX_TEXTURES":"","#define MAX_DIR_LIGHTS "+w.maxDirLights,"#define MAX_POINT_LIGHTS "+w.maxPointLights,"#define MAX_BONES "+w.maxBones,w.map?"#define USE_MAP":"",w.envMap?"#define USE_ENVMAP":"",w.lightMap?"#define USE_LIGHTMAP":"",w.vertexColors?"#define USE_COLOR":"",w.skinning?"#define USE_SKINNING":"",w.morphTargets?"#define USE_MORPHTARGETS":"",w.sizeAttenuation?"#define USE_SIZEATTENUATION":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nuniform mat4 cameraInverseMatrix;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nattribute vec2 uv2;\n#ifdef USE_COLOR\nattribute vec3 color;\n#endif\n#ifdef USE_MORPHTARGETS\nattribute vec3 morphTarget0;\nattribute vec3 morphTarget1;\nattribute vec3 morphTarget2;\nattribute vec3 morphTarget3;\nattribute vec3 morphTarget4;\nattribute vec3 morphTarget5;\nattribute vec3 morphTarget6;\nattribute vec3 morphTarget7;\n#endif\n#ifdef USE_SKINNING\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n#endif\n"].join("\n");
e.attachShader($,ma("fragment",prefix_fragment+S));e.attachShader($,ma("vertex",prefix_vertex+D));e.linkProgram($);e.getProgramParameter($,e.LINK_STATUS)||console.error("Could not initialise shader\nVALIDATE_STATUS: "+e.getProgramParameter($,e.VALIDATE_STATUS)+", gl error ["+e.getError()+"]");$.uniforms={};$.attributes={};var V;S=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition","cameraInverseMatrix","boneGlobalMatrices","morphTargetInfluences"];for(V in I)S.push(V);
V=S;I=0;for(S=V.length;I<S;I++){D=V[I];$.uniforms[D]=e.getUniformLocation($,D)}S=["position","normal","uv","uv2","tangent","color","skinVertexA","skinVertexB","skinIndex","skinWeight"];for(V=0;V<w.maxMorphTargets;V++)S.push("morphTarget"+V);for(L in C)S.push(L);L=S;V=0;for(C=L.length;V<C;V++){w=L[V];$.attributes[w]=e.getAttribLocation($,w)}ya.push({program:$,code:K});L=$}n.program=L;L=n.program.attributes;e.enableVertexAttribArray(L.position);L.color>=0&&e.enableVertexAttribArray(L.color);L.normal>=
0&&e.enableVertexAttribArray(L.normal);L.tangent>=0&&e.enableVertexAttribArray(L.tangent);if(n.skinning&&L.skinVertexA>=0&&L.skinVertexB>=0&&L.skinIndex>=0&&L.skinWeight>=0){e.enableVertexAttribArray(L.skinVertexA);e.enableVertexAttribArray(L.skinVertexB);e.enableVertexAttribArray(L.skinIndex);e.enableVertexAttribArray(L.skinWeight)}for(z in n.attributes)L[z]>=0&&e.enableVertexAttribArray(L[z]);if(n.morphTargets){n.numSupportedMorphTargets=0;if(L.morphTarget0>=0){e.enableVertexAttribArray(L.morphTarget0);
n.numSupportedMorphTargets++}if(L.morphTarget1>=0){e.enableVertexAttribArray(L.morphTarget1);n.numSupportedMorphTargets++}if(L.morphTarget2>=0){e.enableVertexAttribArray(L.morphTarget2);n.numSupportedMorphTargets++}if(L.morphTarget3>=0){e.enableVertexAttribArray(L.morphTarget3);n.numSupportedMorphTargets++}if(L.morphTarget4>=0){e.enableVertexAttribArray(L.morphTarget4);n.numSupportedMorphTargets++}if(L.morphTarget5>=0){e.enableVertexAttribArray(L.morphTarget5);n.numSupportedMorphTargets++}if(L.morphTarget6>=
0){e.enableVertexAttribArray(L.morphTarget6);n.numSupportedMorphTargets++}if(L.morphTarget7>=0){e.enableVertexAttribArray(L.morphTarget7);n.numSupportedMorphTargets++}x.__webglMorphTargetInfluences=new Float32Array(this.maxMorphTargets);n=0;for(z=this.maxMorphTargets;n<z;n++)x.__webglMorphTargetInfluences[n]=0}};this.render=function(n,C,w,x){var z,J,K,I,S,D,O,L,$=n.lights,V=n.fog;C.matrixAutoUpdate&&C.updateMatrix();n.update(undefined,!1,C);C.matrixWorldInverse.flattenToArray(Za);C.projectionMatrix.flattenToArray(Ya);
Ra.multiply(C.projectionMatrix,C.matrixWorldInverse);k(Ra);this.initWebGLObjects(n);Da(w);(this.autoClear||x)&&this.clear();S=n.__webglObjects.length;for(x=0;x<S;x++){z=n.__webglObjects[x];O=z.object;if(O.visible)if(!(O instanceof THREE.Mesh)||m(O)){O.matrixWorld.flattenToArray(O._objectMatrixArray);H(O,C);u(z);z.render=!0;if(this.sortObjects){Na.copy(O.position);Ra.multiplyVector3(Na);z.z=Na.z}}else z.render=!1;else z.render=!1}this.sortObjects&&n.__webglObjects.sort(y);D=n.__webglObjectsImmediate.length;
for(x=0;x<D;x++){z=n.__webglObjectsImmediate[x];O=z.object;if(O.visible){O.matrixAutoUpdate&&O.matrixWorld.flattenToArray(O._objectMatrixArray);H(O,C);o(z)}}M(THREE.NormalBlending);for(x=0;x<S;x++){z=n.__webglObjects[x];if(z.render){O=z.object;L=z.buffer;K=z.opaque;h(O);for(z=0;z<K.count;z++){I=K.list[z];j(I.depthTest);f(C,$,V,I,L,O)}}}for(x=0;x<D;x++){z=n.__webglObjectsImmediate[x];O=z.object;if(O.visible){K=z.opaque;h(O);for(z=0;z<K.count;z++){I=K.list[z];j(I.depthTest);J=c(C,$,V,I,O);O.render(function(xa){g(xa,
J,I.shading)})}}}for(x=0;x<S;x++){z=n.__webglObjects[x];if(z.render){O=z.object;L=z.buffer;K=z.transparent;h(O);for(z=0;z<K.count;z++){I=K.list[z];M(I.blending);j(I.depthTest);f(C,$,V,I,L,O)}}}for(x=0;x<D;x++){z=n.__webglObjectsImmediate[x];O=z.object;if(O.visible){K=z.transparent;h(O);for(z=0;z<K.count;z++){I=K.list[z];M(I.blending);j(I.depthTest);J=c(C,$,V,I,O);O.render(function(xa){g(xa,J,I.shading)})}}}n.__webglSprites.length&&B(n,C);stencil&&n.__webglShadowVolumes.length&&n.lights.length&&t(n);
n.__webglLensFlares.length&&F(n,C);if(w&&w.minFilter!==THREE.NearestFilter&&w.minFilter!==THREE.LinearFilter){e.bindTexture(e.TEXTURE_2D,w.__webglTexture);e.generateMipmap(e.TEXTURE_2D);e.bindTexture(e.TEXTURE_2D,null)}};this.initWebGLObjects=function(n){if(!n.__webglObjects){n.__webglObjects=[];n.__webglObjectsImmediate=[];n.__webglShadowVolumes=[];n.__webglLensFlares=[];n.__webglSprites=[]}for(;n.__objectsAdded.length;){var C=n.__objectsAdded[0],w=n,x=void 0,z=void 0,J=void 0;if(C._modelViewMatrix==
undefined){C._modelViewMatrix=new THREE.Matrix4;C._normalMatrixArray=new Float32Array(9);C._modelViewMatrixArray=new Float32Array(16);C._objectMatrixArray=new Float32Array(16);C.matrixWorld.flattenToArray(C._objectMatrixArray)}if(C instanceof THREE.Mesh){z=C.geometry;z.geometryGroups==undefined&&X(z);for(x in z.geometryGroups){J=z.geometryGroups[x];if(!J.__webglVertexBuffer){var K=J;K.__webglVertexBuffer=e.createBuffer();K.__webglNormalBuffer=e.createBuffer();K.__webglTangentBuffer=e.createBuffer();
K.__webglColorBuffer=e.createBuffer();K.__webglUVBuffer=e.createBuffer();K.__webglUV2Buffer=e.createBuffer();K.__webglSkinVertexABuffer=e.createBuffer();K.__webglSkinVertexBBuffer=e.createBuffer();K.__webglSkinIndicesBuffer=e.createBuffer();K.__webglSkinWeightsBuffer=e.createBuffer();K.__webglFaceBuffer=e.createBuffer();K.__webglLineBuffer=e.createBuffer();if(K.numMorphTargets){var I=void 0,S=void 0;K.__webglMorphTargetsBuffers=[];I=0;for(S=K.numMorphTargets;I<S;I++)K.__webglMorphTargetsBuffers.push(e.createBuffer())}K=
J;I=C;var D=void 0,O=void 0,L=void 0;L=void 0;var $=void 0,V=void 0,xa=void 0,Ja=xa=S=0;O=void 0;L=void 0;var za=void 0;D=void 0;O=void 0;$=I.geometry;za=$.faces;V=K.faces;D=0;for(O=V.length;D<O;D++){L=V[D];L=za[L];if(L instanceof THREE.Face3){S+=3;xa+=1;Ja+=3}else if(L instanceof THREE.Face4){S+=4;xa+=2;Ja+=4}}D=K;O=I;za=void 0;V=void 0;var ta=void 0,Oa=void 0;ta=void 0;L=[];za=0;for(V=O.materials.length;za<V;za++){ta=O.materials[za];if(ta instanceof THREE.MeshFaceMaterial){ta=0;for(l=D.materials.length;ta<
l;ta++)(Oa=D.materials[ta])&&L.push(Oa)}else(Oa=ta)&&L.push(Oa)}D=L;a:{O=void 0;za=void 0;V=D.length;for(O=0;O<V;O++){za=D[O];if(za.map||za.lightMap||za instanceof THREE.MeshShaderMaterial){O=!0;break a}}O=!1}a:{za=D;V=void 0;L=void 0;ta=za.length;for(V=0;V<ta;V++){L=za[V];if(!(L instanceof THREE.MeshBasicMaterial&&!L.envMap||L instanceof THREE.MeshDepthMaterial)){za=L&&L.shading!=undefined&&L.shading==THREE.SmoothShading?THREE.SmoothShading:THREE.FlatShading;break a}}za=!1}a:{V=void 0;L=void 0;ta=
D.length;for(V=0;V<ta;V++){L=D[V];if(L.vertexColors){L=L.vertexColors;break a}}L=!1}K.__vertexArray=new Float32Array(S*3);if(za)K.__normalArray=new Float32Array(S*3);if($.hasTangents)K.__tangentArray=new Float32Array(S*4);if(L)K.__colorArray=new Float32Array(S*3);if(O){if($.faceUvs.length>0||$.faceVertexUvs.length>0)K.__uvArray=new Float32Array(S*2);if($.faceUvs.length>1||$.faceVertexUvs.length>1)K.__uv2Array=new Float32Array(S*2)}if(I.geometry.skinWeights.length&&I.geometry.skinIndices.length){K.__skinVertexAArray=
new Float32Array(S*4);K.__skinVertexBArray=new Float32Array(S*4);K.__skinIndexArray=new Float32Array(S*4);K.__skinWeightArray=new Float32Array(S*4)}K.__faceArray=new Uint16Array(xa*3+(I.geometry.edgeFaces?I.geometry.edgeFaces.length*6:0));K.__lineArray=new Uint16Array(Ja*2);if(K.numMorphTargets){K.__morphTargetsArrays=[];$=0;for(V=K.numMorphTargets;$<V;$++)K.__morphTargetsArrays.push(new Float32Array(S*3))}K.__needsSmoothNormals=za==THREE.SmoothShading;K.__uvType=O;K.__vertexColorType=L;K.__normalType=
za;K.__webglFaceCount=xa*3+(I.geometry.edgeFaces?I.geometry.edgeFaces.length*6:0);K.__webglLineCount=Ja*2;$=0;for(V=D.length;$<V;$++)if(D[$].attributes){K.__webglCustomAttributes={};for(a in D[$].attributes){O=D[$].attributes[a];xa=1;if(O.type==="v2")xa=2;else if(O.type==="v3")xa=3;else if(O.type==="v4")xa=4;else O.type==="c"&&(xa=3);O.size=xa;O.needsUpdate=!0;O.array=new Float32Array(S*xa);O.buffer=e.createBuffer();K.__webglCustomAttributes[a]=O}}z.__dirtyVertices=!0;z.__dirtyMorphTargets=!0;z.__dirtyElements=
!0;z.__dirtyUvs=!0;z.__dirtyNormals=!0;z.__dirtyTangents=!0;z.__dirtyColors=!0}C instanceof THREE.ShadowVolume?A(w.__webglShadowVolumes,J,C):A(w.__webglObjects,J,C)}}else if(C instanceof THREE.LensFlare)A(w.__webglLensFlares,undefined,C);else if(C instanceof THREE.Ribbon){z=C.geometry;if(!z.__webglVertexBuffer){x=z;x.__webglVertexBuffer=e.createBuffer();x.__webglColorBuffer=e.createBuffer();x=z;J=x.vertices.length;x.__vertexArray=new Float32Array(J*3);x.__colorArray=new Float32Array(J*3);x.__webglVertexCount=
J;z.__dirtyVertices=!0;z.__dirtyColors=!0}A(w.__webglObjects,z,C)}else if(C instanceof THREE.Line){z=C.geometry;if(!z.__webglVertexBuffer){x=z;x.__webglVertexBuffer=e.createBuffer();x.__webglColorBuffer=e.createBuffer();x=z;J=x.vertices.length;x.__vertexArray=new Float32Array(J*3);x.__colorArray=new Float32Array(J*3);x.__webglLineCount=J;z.__dirtyVertices=!0;z.__dirtyColors=!0}A(w.__webglObjects,z,C)}else if(C instanceof THREE.ParticleSystem){z=C.geometry;if(!z.__webglVertexBuffer){x=z;x.__webglVertexBuffer=
e.createBuffer();x.__webglColorBuffer=e.createBuffer();x=z;J=x.vertices.length;x.__vertexArray=new Float32Array(J*3);x.__colorArray=new Float32Array(J*3);x.__sortArray=[];x.__webglParticleCount=J;z.__dirtyVertices=!0;z.__dirtyColors=!0}A(w.__webglObjects,z,C)}else if(THREE.MarchingCubes!==undefined&&C instanceof THREE.MarchingCubes)w.__webglObjectsImmediate.push({object:C,opaque:{list:[],count:0},transparent:{list:[],count:0}});else C instanceof THREE.Sprite&&w.__webglSprites.push(C);n.__objectsAdded.splice(0,
1)}for(;n.__objectsRemoved.length;){C=n.__objectsRemoved[0];w=n;z=void 0;x=void 0;for(z=w.__webglObjects.length-1;z>=0;z--){x=w.__webglObjects[z].object;if(C==x){w.__webglObjects.splice(z,1);break}}n.__objectsRemoved.splice(0,1)}C=0;for(w=n.__webglObjects.length;C<w;C++)G(n.__webglObjects[C].object,n);C=0;for(w=n.__webglShadowVolumes.length;C<w;C++)G(n.__webglShadowVolumes[C].object,n);C=0;for(w=n.__webglLensFlares.length;C<w;C++)G(n.__webglLensFlares[C].object,n)};this.setFaceCulling=function(n,
C){if(n){!C||C=="ccw"?e.frontFace(e.CCW):e.frontFace(e.CW);if(n=="back")e.cullFace(e.BACK);else n=="front"?e.cullFace(e.FRONT):e.cullFace(e.FRONT_AND_BACK);e.enable(e.CULL_FACE)}else e.disable(e.CULL_FACE)};this.supportsVertexTextures=function(){return e.getParameter(e.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0}};
THREE.WebGLRenderTarget=function(b,d,c){this.width=b;this.height=d;c=c||{};this.wrapS=c.wrapS!==undefined?c.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=c.wrapT!==undefined?c.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=c.magFilter!==undefined?c.magFilter:THREE.LinearFilter;this.minFilter=c.minFilter!==undefined?c.minFilter:THREE.LinearMipMapLinearFilter;this.format=c.format!==undefined?c.format:THREE.RGBAFormat;this.type=c.type!==undefined?c.type:THREE.UnsignedByteType;this.depthBuffer=c.depthBuffer!==
undefined?c.depthBuffer:!0;this.stencilBuffer=c.stencilBuffer!==undefined?c.stencilBuffer:!0};
THREE.SoundRenderer=function(){this.volume=1;this.domElement=document.createElement("div");this.domElement.id="THREESound";this.cameraPosition=new THREE.Vector3;this.soundPosition=new THREE.Vector3;this.render=function(b,d,c){c&&b.update(undefined,!1,d);c=b.sounds;var f,g=c.length;for(f=0;f<g;f++){b=c[f];this.soundPosition.set(b.matrixWorld.n14,b.matrixWorld.n24,b.matrixWorld.n34);this.soundPosition.subSelf(d.position);if(b.isPlaying&&b.isLoaded){b.isAddedToDOM||b.addToDOM(this.domElement);b.calculateVolumeAndPan(this.soundPosition)}}}};
THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(b){this.positionWorld.copy(b.positionWorld);this.positionScreen.copy(b.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.materials=null};
THREE.AnimationHandler=function(){var b=[],d={},c={};c.update=function(g){for(var h=0;h<b.length;h++)b[h].update(g)};c.addToUpdate=function(g){b.indexOf(g)===-1&&b.push(g)};c.removeFromUpdate=function(g){g=b.indexOf(g);g!==-1&&b.splice(g,1)};c.add=function(g){d[g.name]!==undefined&&console.log("THREE.AnimationHandler.add: Warning! "+g.name+" already exists in library. Overwriting.");d[g.name]=g;if(g.initialized!==!0){for(var h=0;h<g.hierarchy.length;h++){for(var j=0;j<g.hierarchy[h].keys.length;j++){if(g.hierarchy[h].keys[j].time<
0)g.hierarchy[h].keys[j].time=0;if(g.hierarchy[h].keys[j].rot!==undefined&&!(g.hierarchy[h].keys[j].rot instanceof THREE.Quaternion)){var k=g.hierarchy[h].keys[j].rot;g.hierarchy[h].keys[j].rot=new THREE.Quaternion(k[0],k[1],k[2],k[3])}}if(g.hierarchy[h].keys[0].morphTargets!==undefined){k={};for(j=0;j<g.hierarchy[h].keys.length;j++)for(var m=0;m<g.hierarchy[h].keys[j].morphTargets.length;m++){var p=g.hierarchy[h].keys[j].morphTargets[m];k[p]=-1}g.hierarchy[h].usedMorphTargets=k;for(j=0;j<g.hierarchy[h].keys.length;j++){var o=
{};for(p in k){for(m=0;m<g.hierarchy[h].keys[j].morphTargets.length;m++)if(g.hierarchy[h].keys[j].morphTargets[m]===p){o[p]=g.hierarchy[h].keys[j].morphTargetsInfluences[m];break}m===g.hierarchy[h].keys[j].morphTargets.length&&(o[p]=0)}g.hierarchy[h].keys[j].morphTargetsInfluences=o}}for(j=1;j<g.hierarchy[h].keys.length;j++)if(g.hierarchy[h].keys[j].time===g.hierarchy[h].keys[j-1].time){g.hierarchy[h].keys.splice(j,1);j--}for(j=1;j<g.hierarchy[h].keys.length;j++)g.hierarchy[h].keys[j].index=j}j=parseInt(g.length*
g.fps,10);g.JIT={};g.JIT.hierarchy=[];for(h=0;h<g.hierarchy.length;h++)g.JIT.hierarchy.push(Array(j));g.initialized=!0}};c.get=function(g){if(typeof g==="string")if(d[g])return d[g];else{console.log("THREE.AnimationHandler.get: Couldn't find animation "+g);return null}};c.parse=function(g){var h=[];if(g instanceof THREE.SkinnedMesh)for(var j=0;j<g.bones.length;j++)h.push(g.bones[j]);else f(g,h);return h};var f=function(g,h){h.push(g);for(var j=0;j<g.children.length;j++)f(g.children[j],h)};c.LINEAR=
0;c.CATMULLROM=1;c.CATMULLROM_FORWARD=2;return c}();THREE.Animation=function(b,d,c,f){this.root=b;this.data=THREE.AnimationHandler.get(d);this.hierarchy=THREE.AnimationHandler.parse(b);this.currentTime=0;this.timeScale=1;this.isPlaying=!1;this.isPaused=!0;this.loop=!0;this.interpolationType=c!==undefined?c:THREE.AnimationHandler.LINEAR;this.JITCompile=f!==undefined?f:!0;this.points=[];this.target=new THREE.Vector3};
THREE.Animation.prototype.play=function(b,d){if(!this.isPlaying){this.isPlaying=!0;this.loop=b!==undefined?b:!0;this.currentTime=d!==undefined?d:0;var c,f=this.hierarchy.length,g;for(c=0;c<f;c++){g=this.hierarchy[c];if(this.interpolationType!==THREE.AnimationHandler.CATMULLROM_FORWARD)g.useQuaternion=!0;g.matrixAutoUpdate=!0;if(g.animationCache===undefined){g.animationCache={};g.animationCache.prevKey={pos:0,rot:0,scl:0};g.animationCache.nextKey={pos:0,rot:0,scl:0};g.animationCache.originalMatrix=
g instanceof THREE.Bone?g.skinMatrix:g.matrix}var h=g.animationCache.prevKey;g=g.animationCache.nextKey;h.pos=this.data.hierarchy[c].keys[0];h.rot=this.data.hierarchy[c].keys[0];h.scl=this.data.hierarchy[c].keys[0];g.pos=this.getNextKeyWith("pos",c,1);g.rot=this.getNextKeyWith("rot",c,1);g.scl=this.getNextKeyWith("scl",c,1)}this.update(0)}this.isPaused=!1;THREE.AnimationHandler.addToUpdate(this)};
THREE.Animation.prototype.pause=function(){this.isPaused?THREE.AnimationHandler.addToUpdate(this):THREE.AnimationHandler.removeFromUpdate(this);this.isPaused=!this.isPaused};
THREE.Animation.prototype.stop=function(){this.isPlaying=!1;this.isPaused=!1;THREE.AnimationHandler.removeFromUpdate(this);for(var b=0;b<this.hierarchy.length;b++)if(this.hierarchy[b].animationCache!==undefined){if(this.hierarchy[b]instanceof THREE.Bone)this.hierarchy[b].skinMatrix=this.hierarchy[b].animationCache.originalMatrix;else this.hierarchy[b].matrix=this.hierarchy[b].animationCache.originalMatrix;delete this.hierarchy[b].animationCache}};
THREE.Animation.prototype.update=function(b){if(this.isPlaying){var d=["pos","rot","scl"],c,f,g,h,j,k,m,p,o=this.data.JIT.hierarchy,u,y;this.currentTime+=b*this.timeScale;y=this.currentTime;u=this.currentTime%=this.data.length;p=parseInt(Math.min(u*this.data.fps,this.data.length*this.data.fps),10);for(var t=0,B=this.hierarchy.length;t<B;t++){b=this.hierarchy[t];m=b.animationCache;if(this.JITCompile&&o[t][p]!==undefined)if(b instanceof THREE.Bone){b.skinMatrix=o[t][p];b.matrixAutoUpdate=!1;b.matrixWorldNeedsUpdate=
!1}else{b.matrix=o[t][p];b.matrixAutoUpdate=!1;b.matrixWorldNeedsUpdate=!0}else{if(this.JITCompile)if(b instanceof THREE.Bone)b.skinMatrix=b.animationCache.originalMatrix;else b.matrix=b.animationCache.originalMatrix;for(var F=0;F<3;F++){c=d[F];j=m.prevKey[c];k=m.nextKey[c];if(k.time<=y){if(u<y)if(this.loop){j=this.data.hierarchy[t].keys[0];for(k=this.getNextKeyWith(c,t,1);k.time<u;){j=k;k=this.getNextKeyWith(c,t,k.index+1)}}else{this.stop();return}else{do{j=k;k=this.getNextKeyWith(c,t,k.index+1)}while(k.time<
u)}m.prevKey[c]=j;m.nextKey[c]=k}b.matrixAutoUpdate=!0;b.matrixWorldNeedsUpdate=!0;f=(u-j.time)/(k.time-j.time);g=j[c];h=k[c];if(f<0||f>1){console.log("THREE.Animation.update: Warning! Scale out of bounds:"+f+" on bone "+t);f=f<0?0:1}if(c==="pos"){c=b.position;if(this.interpolationType===THREE.AnimationHandler.LINEAR){c.x=g[0]+(h[0]-g[0])*f;c.y=g[1]+(h[1]-g[1])*f;c.z=g[2]+(h[2]-g[2])*f}else if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){this.points[0]=
this.getPrevKeyWith("pos",t,j.index-1).pos;this.points[1]=g;this.points[2]=h;this.points[3]=this.getNextKeyWith("pos",t,k.index+1).pos;f=f*0.33+0.33;g=this.interpolateCatmullRom(this.points,f);c.x=g[0];c.y=g[1];c.z=g[2];if(this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){f=this.interpolateCatmullRom(this.points,f*1.01);this.target.set(f[0],f[1],f[2]);this.target.subSelf(c);this.target.y=0;this.target.normalize();f=Math.atan2(this.target.x,this.target.z);b.rotation.set(0,f,0)}}}else if(c===
"rot")THREE.Quaternion.slerp(g,h,b.quaternion,f);else if(c==="scl"){c=b.scale;c.x=g[0]+(h[0]-g[0])*f;c.y=g[1]+(h[1]-g[1])*f;c.z=g[2]+(h[2]-g[2])*f}}}}if(this.JITCompile&&o[0][p]===undefined){this.hierarchy[0].update(undefined,!0);for(t=0;t<this.hierarchy.length;t++)o[t][p]=this.hierarchy[t]instanceof THREE.Bone?this.hierarchy[t].skinMatrix.clone():this.hierarchy[t].matrix.clone()}}};
THREE.Animation.prototype.interpolateCatmullRom=function(b,d){var c=[],f=[],g,h,j,k,m,p;g=(b.length-1)*d;h=Math.floor(g);g-=h;c[0]=h==0?h:h-1;c[1]=h;c[2]=h>b.length-2?h:h+1;c[3]=h>b.length-3?h:h+2;h=b[c[0]];k=b[c[1]];m=b[c[2]];p=b[c[3]];c=g*g;j=g*c;f[0]=this.interpolate(h[0],k[0],m[0],p[0],g,c,j);f[1]=this.interpolate(h[1],k[1],m[1],p[1],g,c,j);f[2]=this.interpolate(h[2],k[2],m[2],p[2],g,c,j);return f};
THREE.Animation.prototype.interpolate=function(b,d,c,f,g,h,j){b=(c-b)*0.5;f=(f-d)*0.5;return(2*(d-c)+b+f)*j+(-3*(d-c)-2*b-f)*h+b*g+d};THREE.Animation.prototype.getNextKeyWith=function(b,d,c){var f=this.data.hierarchy[d].keys;if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)c=c<f.length-1?c:f.length-1;else c%=f.length;for(;c<f.length;c++)if(f[c][b]!==undefined)return f[c];return this.data.hierarchy[d].keys[0]};
THREE.Animation.prototype.getPrevKeyWith=function(b,d,c){var f=this.data.hierarchy[d].keys;for(c=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?c>0?c:0:c>=0?c:c+f.length;c>=0;c--)if(f[c][b]!==undefined)return f[c];return this.data.hierarchy[d].keys[f.length-1]};
var GeometryUtils={merge:function(b,d){var c=d instanceof THREE.Mesh,f=b.vertices.length,g=c?d.geometry:d,h=b.vertices,j=g.vertices,k=b.faces,m=g.faces,p=b.faceVertexUvs[0];g=g.faceVertexUvs[0];c&&d.matrixAutoUpdate&&d.updateMatrix();for(var o=0,u=j.length;o<u;o++){var y=new THREE.Vertex(j[o].position.clone());c&&d.matrix.multiplyVector3(y.position);h.push(y)}o=0;for(u=m.length;o<u;o++){j=m[o];var t,B,F=j.vertexNormals;y=j.vertexColors;if(j instanceof THREE.Face3)t=new THREE.Face3(j.a+f,j.b+f,j.c+
f);else j instanceof THREE.Face4&&(t=new THREE.Face4(j.a+f,j.b+f,j.c+f,j.d+f));t.normal.copy(j.normal);c=0;for(h=F.length;c<h;c++){B=F[c];t.vertexNormals.push(B.clone())}t.color.copy(j.color);c=0;for(h=y.length;c<h;c++){B=y[c];t.vertexColors.push(B.clone())}t.materials=j.materials.slice();t.centroid.copy(j.centroid);k.push(t)}o=0;for(u=g.length;o<u;o++){f=g[o];k=[];c=0;for(h=f.length;c<h;c++)k.push(new THREE.UV(f[c].u,f[c].v));p.push(k)}}};
THREE.ImageUtils={loadTexture:function(b,d,c){var f=new Image,g=new THREE.Texture(f,d);f.onload=function(){g.needsUpdate=!0;c&&c(this)};f.src=b;return g},loadTextureCube:function(b,d,c){var f,g=[],h=new THREE.Texture(g,d);d=g.loadCount=0;for(f=b.length;d<f;++d){g[d]=new Image;g[d].onload=function(){g.loadCount+=1;if(g.loadCount==6)h.needsUpdate=!0;c&&c(this)};g[d].src=b[d]}return h}};
THREE.SceneUtils={addMesh:function(b,d,c,f,g,h,j,k,m,p){d=new THREE.Mesh(d,p);d.scale.x=d.scale.y=d.scale.z=c;d.position.x=f;d.position.y=g;d.position.z=h;d.rotation.x=j;d.rotation.y=k;d.rotation.z=m;b.addObject(d);return d},addPanoramaCubeWebGL:function(b,d,c){var f=THREE.ShaderUtils.lib.cube;f.uniforms.tCube.texture=c;c=new THREE.MeshShaderMaterial({fragmentShader:f.fragmentShader,vertexShader:f.vertexShader,uniforms:f.uniforms});d=new THREE.Mesh(new THREE.Cube(d,d,d,1,1,1,null,!0),c);b.addObject(d);
return d},addPanoramaCube:function(b,d,c){var f=[];f.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[0])}));f.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[1])}));f.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[2])}));f.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[3])}));f.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[4])}));f.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[5])}));d=new THREE.Mesh(new THREE.Cube(d,d,d,1,1,f,!0),
new THREE.MeshFaceMaterial);b.addObject(d);return d},addPanoramaCubePlanes:function(b,d,c){var f=d/2;d=new THREE.Plane(d,d);var g=Math.PI,h=Math.PI/2;THREE.SceneUtils.addMesh(b,d,1,0,0,-f,0,0,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[5])}));THREE.SceneUtils.addMesh(b,d,1,-f,0,0,0,h,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[0])}));THREE.SceneUtils.addMesh(b,d,1,f,0,0,0,-h,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[1])}));THREE.SceneUtils.addMesh(b,d,1,0,f,0,h,
0,g,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[2])}));THREE.SceneUtils.addMesh(b,d,1,0,-f,0,-h,0,g,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[3])}))},showHierarchy:function(b,d){THREE.SceneUtils.traverseHierarchy(b,function(c){c.visible=d})},traverseHierarchy:function(b,d){var c,f,g=b.children.length;for(f=0;f<g;f++){c=b.children[f];d(c);THREE.SceneUtils.traverseHierarchy(c,d)}}};
THREE.ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",
vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tNormal:{type:"t",value:2,texture:null},tAO:{type:"t",value:3,texture:null},uNormalScale:{type:"f",value:1},tDisplacement:{type:"t",value:4,texture:null},uDisplacementBias:{type:"f",value:-0.5},uDisplacementScale:{type:"f",value:2.5},uPointLightPos:{type:"v3",value:new THREE.Vector3},uPointLightColor:{type:"c",value:new THREE.Color(15658734)},uDirLightPos:{type:"v3",value:new THREE.Vector3},
uDirLightColor:{type:"c",value:new THREE.Color(15658734)},uAmbientLightColor:{type:"c",value:new THREE.Color(328965)},uDiffuseColor:{type:"c",value:new THREE.Color(15658734)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(328965)},uShininess:{type:"f",value:30}},fragmentShader:"uniform vec3 uDirLightPos;\nuniform vec3 uAmbientLightColor;\nuniform vec3 uDirLightColor;\nuniform vec3 uPointLightColor;\nuniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform bool enableDiffuse;\nuniform bool enableAO;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tAO;\nuniform float uNormalScale;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 diffuseTex = vec3( 1.0, 1.0, 1.0 );\nvec3 aoTex = vec3( 1.0, 1.0, 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse )\ndiffuseTex = texture2D( tDiffuse, vUv ).xyz;\nif( enableAO )\naoTex = texture2D( tAO, vUv ).xyz;\nmat3 tsb = mat3( vTangent, vBinormal, vNormal );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 pointDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 pointSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec3 pointVector = normalize( vPointLightVector );\nvec3 pointHalfVector = normalize( vPointLightVector + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, uShininess );\npointDiffuse  += vec4( uDiffuseColor, 1.0 ) * pointDiffuseWeight;\npointSpecular += vec4( uSpecularColor, 1.0 ) * pointSpecularWeight;\nvec4 dirDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 dirSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 lDirection = viewMatrix * vec4( uDirLightPos, 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, uShininess );\ndirDiffuse  += vec4( uDiffuseColor, 1.0 ) * dirDiffuseWeight;\ndirSpecular += vec4( uSpecularColor, 1.0 ) * dirSpecularWeight;\nvec4 totalLight = vec4( uAmbientLightColor * uAmbientColor, 1.0 );\ntotalLight += vec4( uDirLightColor, 1.0 ) * ( dirDiffuse + dirSpecular );\ntotalLight += vec4( uPointLightColor, 1.0 ) * ( pointDiffuse + pointSpecular );\ngl_FragColor = vec4( totalLight.xyz * aoTex * diffuseTex, 1.0 );\n}",
vertexShader:"attribute vec4 tangent;\nuniform vec3 uPointLightPos;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvBinormal = normalize( vBinormal );\nvUv = uv;\nvec4 lPosition = viewMatrix * vec4( uPointLightPos, 1.0 );\nvPointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( vNormal.xyz * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif\n}"},
cube:{uniforms:{tCube:{type:"t",value:1,texture:null}},vertexShader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( - wPos.x, wPos.yz ) );\n}"},convolution:{uniforms:{tDiffuse:{type:"t",
value:0,texture:null},uImageIncrement:{type:"v2",value:new THREE.Vector2(0.001953125,0)},cKernel:{type:"fv1",value:[]}},vertexShader:"varying vec2 vUv;\nuniform vec2 uImageIncrement;\nvoid main(void) {\nvUv = uv - ((KERNEL_SIZE - 1.0) / 2.0) * uImageIncrement;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform vec2 uImageIncrement;\nuniform float cKernel[KERNEL_SIZE];\nvoid main(void) {\nvec2 imageCoord = vUv;\nvec4 sum = vec4( 0.0, 0.0, 0.0, 0.0 );\nfor( int i=0; i<KERNEL_SIZE; ++i ) {\nsum += texture2D( tDiffuse, imageCoord ) * cKernel[i];\nimageCoord += uImageIncrement;\n}\ngl_FragColor = sum;\n}"},
film:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},time:{type:"f",value:0},nIntensity:{type:"f",value:0.5},sIntensity:{type:"f",value:0.05},sCount:{type:"f",value:4096},grayscale:{type:"i",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float time;\nuniform bool grayscale;\nuniform float nIntensity;\nuniform float sIntensity;\nuniform float sCount;\nvoid main() {\nvec4 cTextureScreen = texture2D( tDiffuse, vUv );\nfloat x = vUv.x * vUv.y * time *  1000.0;\nx = mod( x, 13.0 ) * mod( x, 123.0 );\nfloat dx = mod( x, 0.01 );\nvec3 cResult = cTextureScreen.rgb + cTextureScreen.rgb * clamp( 0.1 + dx * 100.0, 0.0, 1.0 );\nvec2 sc = vec2( sin( vUv.y * sCount ), cos( vUv.y * sCount ) );\ncResult += cTextureScreen.rgb * vec3( sc.x, sc.y, sc.x ) * sIntensity;\ncResult = cTextureScreen.rgb + clamp( nIntensity, 0.0,1.0 ) * ( cResult - cTextureScreen.rgb );\nif( grayscale ) {\ncResult = vec3( cResult.r * 0.3 + cResult.g * 0.59 + cResult.b * 0.11 );\n}\ngl_FragColor =  vec4( cResult, cTextureScreen.a );\n}"},
screen:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},opacity:{type:"f",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float opacity;\nvoid main() {\nvec4 texel = texture2D( tDiffuse, vUv );\ngl_FragColor = opacity * texel;\n}"},basic:{uniforms:{},vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0, 0.0, 0.0, 0.5 );\n}"}},buildKernel:function(b){var d,c,f,g,h=2*Math.ceil(b*3)+1;h>25&&(h=25);g=(h-1)*0.5;c=Array(h);for(d=f=0;d<h;++d){c[d]=Math.exp(-((d-g)*(d-g))/(2*b*b));f+=c[d]}for(d=0;d<h;++d)c[d]/=f;return c}};
THREE.QuakeCamera=function(b){function d(c,f){return function(){f.apply(c,arguments)}}THREE.Camera.call(this,b.fov,b.aspect,b.near,b.far,b.target);this.movementSpeed=1;this.lookSpeed=0.005;this.noFly=!1;this.lookVertical=!0;this.autoForward=!1;this.activeLook=!0;this.heightSpeed=!1;this.heightCoef=1;this.heightMin=0;this.constrainVertical=!1;this.verticalMin=0;this.verticalMax=3.14;this.domElement=document;if(b){if(b.movementSpeed!==undefined)this.movementSpeed=b.movementSpeed;if(b.lookSpeed!==undefined)this.lookSpeed=
b.lookSpeed;if(b.noFly!==undefined)this.noFly=b.noFly;if(b.lookVertical!==undefined)this.lookVertical=b.lookVertical;if(b.autoForward!==undefined)this.autoForward=b.autoForward;if(b.activeLook!==undefined)this.activeLook=b.activeLook;if(b.heightSpeed!==undefined)this.heightSpeed=b.heightSpeed;if(b.heightCoef!==undefined)this.heightCoef=b.heightCoef;if(b.heightMin!==undefined)this.heightMin=b.heightMin;if(b.heightMax!==undefined)this.heightMax=b.heightMax;if(b.constrainVertical!==undefined)this.constrainVertical=
b.constrainVertical;if(b.verticalMin!==undefined)this.verticalMin=b.verticalMin;if(b.verticalMax!==undefined)this.verticalMax=b.verticalMax;if(b.domElement!==undefined)this.domElement=b.domElement}this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=this.autoSpeedFactor=0;this.moveForward=!1;this.moveBackward=!1;this.moveLeft=!1;this.moveRight=!1;this.freeze=!1;this.mouseDragOn=!1;this.windowHalfX=window.innerWidth/2;this.windowHalfY=window.innerHeight/2;this.onMouseDown=function(c){c.preventDefault();
c.stopPropagation();if(this.activeLook)switch(c.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}this.mouseDragOn=!0};this.onMouseUp=function(c){c.preventDefault();c.stopPropagation();if(this.activeLook)switch(c.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}this.mouseDragOn=!1};this.onMouseMove=function(c){this.mouseX=c.clientX-this.windowHalfX;this.mouseY=c.clientY-this.windowHalfY};this.onKeyDown=function(c){switch(c.keyCode){case 38:case 87:this.moveForward=
!0;break;case 37:case 65:this.moveLeft=!0;break;case 40:case 83:this.moveBackward=!0;break;case 39:case 68:this.moveRight=!0;break;case 81:this.freeze=!this.freeze}};this.onKeyUp=function(c){switch(c.keyCode){case 38:case 87:this.moveForward=!1;break;case 37:case 65:this.moveLeft=!1;break;case 40:case 83:this.moveBackward=!1;break;case 39:case 68:this.moveRight=!1}};this.update=function(){if(!this.freeze){this.autoSpeedFactor=this.heightSpeed?((this.position.y<this.heightMin?this.heightMin:this.position.y>
this.heightMax?this.heightMax:this.position.y)-this.heightMin)*this.heightCoef:0;(this.moveForward||this.autoForward)&&this.translateZ(-(this.movementSpeed+this.autoSpeedFactor));this.moveBackward&&this.translateZ(this.movementSpeed);this.moveLeft&&this.translateX(-this.movementSpeed);this.moveRight&&this.translateX(this.movementSpeed);var c=this.lookSpeed;this.activeLook||(c=0);this.lon+=this.mouseX*c;this.lookVertical&&(this.lat-=this.mouseY*c);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=
(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;var f=this.target.position,g=this.position;f.x=g.x+100*Math.sin(this.phi)*Math.cos(this.theta);f.y=g.y+100*Math.cos(this.phi);f.z=g.z+100*Math.sin(this.phi)*Math.sin(this.theta)}this.lon+=this.mouseX*c;this.lookVertical&&(this.lat-=this.mouseY*c);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;if(this.constrainVertical)this.phi=(this.phi-0)*(this.verticalMax-this.verticalMin)/
3.14+this.verticalMin;f=this.target.position;g=this.position;f.x=g.x+100*Math.sin(this.phi)*Math.cos(this.theta);f.y=g.y+100*Math.cos(this.phi);f.z=g.z+100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this)};this.domElement.addEventListener("contextmenu",function(c){c.preventDefault()},!1);this.domElement.addEventListener("mousemove",d(this,this.onMouseMove),!1);this.domElement.addEventListener("mousedown",d(this,this.onMouseDown),!1);this.domElement.addEventListener("mouseup",d(this,
this.onMouseUp),!1);this.domElement.addEventListener("keydown",d(this,this.onKeyDown),!1);this.domElement.addEventListener("keyup",d(this,this.onKeyUp),!1)};THREE.QuakeCamera.prototype=new THREE.Camera;THREE.QuakeCamera.prototype.constructor=THREE.QuakeCamera;THREE.QuakeCamera.prototype.supr=THREE.Camera.prototype;THREE.QuakeCamera.prototype.translate=function(b,d){this.matrix.rotateAxis(d);if(this.noFly)d.y=0;this.position.addSelf(d.multiplyScalar(b));this.target.position.addSelf(d.multiplyScalar(b))};
THREE.PathCamera=function(b){function d(p,o,u,y){var t={name:u,fps:0.6,length:y,hierarchy:[]},B,F=o.getControlPointsArray(),H=o.getLength(),G=F.length,X=0;B=G-1;o={parent:-1,keys:[]};o.keys[0]={time:0,pos:F[0],rot:[0,0,0,1],scl:[1,1,1]};o.keys[B]={time:y,pos:F[B],rot:[0,0,0,1],scl:[1,1,1]};for(B=1;B<G-1;B++){X=y*H.chunks[B]/H.total;o.keys[B]={time:X,pos:F[B]}}t.hierarchy[0]=o;THREE.AnimationHandler.add(t);return new THREE.Animation(p,u,THREE.AnimationHandler.CATMULLROM_FORWARD,!1)}function c(p,o){var u,
y,t=new THREE.Geometry;for(u=0;u<p.points.length*o;u++){y=u/(p.points.length*o);y=p.getPoint(y);t.vertices[u]=new THREE.Vertex(new THREE.Vector3(y.x,y.y,y.z))}return t}function f(p,o){var u=c(o,10),y=c(o,10),t=new THREE.LineBasicMaterial({color:16711680,linewidth:3});lineObj=new THREE.Line(u,t);particleObj=new THREE.ParticleSystem(y,new THREE.ParticleBasicMaterial({color:16755200,size:3}));lineObj.scale.set(1,1,1);p.addChild(lineObj);particleObj.scale.set(1,1,1);p.addChild(particleObj);y=new Sphere(1,
16,8);t=new THREE.MeshBasicMaterial({color:65280});for(i=0;i<o.points.length;i++){u=new THREE.Mesh(y,t);u.position.copy(o.points[i]);u.updateMatrix();p.addChild(u)}}THREE.Camera.call(this,b.fov,b.aspect,b.near,b.far,b.target);this.id="PathCamera"+THREE.PathCameraIdCounter++;this.duration=1E4;this.waypoints=[];this.useConstantSpeed=!0;this.resamplingCoef=50;this.debugPath=new THREE.Object3D;this.debugDummy=new THREE.Object3D;this.animationParent=new THREE.Object3D;this.lookSpeed=0.005;this.lookVertical=
!0;this.lookHorizontal=!0;this.verticalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.horizontalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.domElement=document;if(b){if(b.duration!==undefined)this.duration=b.duration*1E3;if(b.waypoints!==undefined)this.waypoints=b.waypoints;if(b.useConstantSpeed!==undefined)this.useConstantSpeed=b.useConstantSpeed;if(b.resamplingCoef!==undefined)this.resamplingCoef=b.resamplingCoef;if(b.createDebugPath!==undefined)this.createDebugPath=b.createDebugPath;
if(b.createDebugDummy!==undefined)this.createDebugDummy=b.createDebugDummy;if(b.lookSpeed!==undefined)this.lookSpeed=b.lookSpeed;if(b.lookVertical!==undefined)this.lookVertical=b.lookVertical;if(b.lookHorizontal!==undefined)this.lookHorizontal=b.lookHorizontal;if(b.verticalAngleMap!==undefined)this.verticalAngleMap=b.verticalAngleMap;if(b.horizontalAngleMap!==undefined)this.horizontalAngleMap=b.horizontalAngleMap;if(b.domElement!==undefined)this.domElement=b.domElement}this.theta=this.phi=this.lon=
this.lat=this.mouseY=this.mouseX=0;this.windowHalfX=window.innerWidth/2;this.windowHalfY=window.innerHeight/2;var g=Math.PI*2,h=Math.PI/180;this.update=function(p,o,u){var y,t;this.lookHorizontal&&(this.lon+=this.mouseX*this.lookSpeed);this.lookVertical&&(this.lat-=this.mouseY*this.lookSpeed);this.lon=Math.max(0,Math.min(360,this.lon));this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*h;this.theta=this.lon*h;y=this.phi%g;this.phi=y>=0?y:y+g;y=this.verticalAngleMap.srcRange;t=this.verticalAngleMap.dstRange;
this.phi=(this.phi-y[0])*(t[1]-t[0])/(y[1]-y[0])+t[0];y=this.horizontalAngleMap.srcRange;t=this.horizontalAngleMap.dstRange;this.theta=(this.theta-y[0])*(t[1]-t[0])/(y[1]-y[0])+t[0];y=this.target.position;y.x=100*Math.sin(this.phi)*Math.cos(this.theta);y.y=100*Math.cos(this.phi);y.z=100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this,p,o,u)};this.onMouseMove=function(p){this.mouseX=p.clientX-this.windowHalfX;this.mouseY=p.clientY-this.windowHalfY};this.spline=new THREE.Spline;this.spline.initFromArray(this.waypoints);
this.useConstantSpeed&&this.spline.reparametrizeByArcLength(this.resamplingCoef);if(this.createDebugDummy){b=new THREE.MeshLambertMaterial({color:30719});var j=new THREE.MeshLambertMaterial({color:65280}),k=new THREE.Cube(10,10,20),m=new THREE.Cube(2,2,10);this.animationParent=new THREE.Mesh(k,b);b=new THREE.Mesh(m,j);b.position.set(0,10,0);this.animation=d(this.animationParent,this.spline,this.id,this.duration);this.animationParent.addChild(this);this.animationParent.addChild(this.target);this.animationParent.addChild(b)}else{this.animation=
d(this.animationParent,this.spline,this.id,this.duration);this.animationParent.addChild(this.target);this.animationParent.addChild(this)}this.createDebugPath&&f(this.debugPath,this.spline);this.domElement.addEventListener("mousemove",function(p,o){return function(){o.apply(p,arguments)}}(this,this.onMouseMove),!1)};THREE.PathCamera.prototype=new THREE.Camera;THREE.PathCamera.prototype.constructor=THREE.PathCamera;THREE.PathCamera.prototype.supr=THREE.Camera.prototype;THREE.PathCameraIdCounter=0;
THREE.Cube=function(b,d,c,f,g,h,j,k,m){function p(H,G,X,A,M,Q,R,Da){var ma,va,ca=f||1,e=g||1,ea=M/2,ya=Q/2,Ba=o.vertices.length;if(H=="x"&&G=="y"||H=="y"&&G=="x")ma="z";else if(H=="x"&&G=="z"||H=="z"&&G=="x"){ma="y";e=h||1}else if(H=="z"&&G=="y"||H=="y"&&G=="z"){ma="x";ca=h||1}var Fa=ca+1,Z=e+1;M/=ca;var oa=Q/e;for(va=0;va<Z;va++)for(Q=0;Q<Fa;Q++){var pa=new THREE.Vector3;pa[H]=(Q*M-ea)*X;pa[G]=(va*oa-ya)*A;pa[ma]=R;o.vertices.push(new THREE.Vertex(pa))}for(va=0;va<e;va++)for(Q=0;Q<ca;Q++){o.faces.push(new THREE.Face4(Q+
Fa*va+Ba,Q+Fa*(va+1)+Ba,Q+1+Fa*(va+1)+Ba,Q+1+Fa*va+Ba,null,null,Da));o.faceVertexUvs[0].push([new THREE.UV(Q/ca,va/e),new THREE.UV(Q/ca,(va+1)/e),new THREE.UV((Q+1)/ca,(va+1)/e),new THREE.UV((Q+1)/ca,va/e)])}}THREE.Geometry.call(this);var o=this,u=b/2,y=d/2,t=c/2;k=k?-1:1;if(j!==undefined)if(j instanceof Array)this.materials=j;else{this.materials=[];for(var B=0;B<6;B++)this.materials.push([j])}else this.materials=[];this.sides={px:!0,nx:!0,py:!0,ny:!0,pz:!0,nz:!0};if(m!=undefined)for(var F in m)this.sides[F]!=
undefined&&(this.sides[F]=m[F]);this.sides.px&&p("z","y",1*k,-1,c,d,-u,this.materials[0]);this.sides.nx&&p("z","y",-1*k,-1,c,d,u,this.materials[1]);this.sides.py&&p("x","z",1*k,1,b,c,y,this.materials[2]);this.sides.ny&&p("x","z",1*k,-1,b,c,-y,this.materials[3]);this.sides.pz&&p("x","y",1*k,-1,b,d,t,this.materials[4]);this.sides.nz&&p("x","y",-1*k,-1,b,d,-t,this.materials[5]);(function(){for(var H=[],G=[],X=0,A=o.vertices.length;X<A;X++){for(var M=o.vertices[X],Q=!1,R=0,Da=H.length;R<Da;R++){var ma=
H[R];if(M.position.x==ma.position.x&&M.position.y==ma.position.y&&M.position.z==ma.position.z){G[X]=R;Q=!0;break}}if(!Q){G[X]=H.length;H.push(new THREE.Vertex(M.position.clone()))}}X=0;for(A=o.faces.length;X<A;X++){M=o.faces[X];M.a=G[M.a];M.b=G[M.b];M.c=G[M.c];M.d=G[M.d]}o.vertices=H})();this.computeCentroids();this.computeFaceNormals()};THREE.Cube.prototype=new THREE.Geometry;THREE.Cube.prototype.constructor=THREE.Cube;
THREE.Cylinder=function(b,d,c,f,g,h){function j(y,t,B){k.vertices.push(new THREE.Vertex(new THREE.Vector3(y,t,B)))}THREE.Geometry.call(this);var k=this,m,p=Math.PI*2,o=f/2;for(m=0;m<b;m++)j(Math.sin(p*m/b)*d,Math.cos(p*m/b)*d,-o);for(m=0;m<b;m++)j(Math.sin(p*m/b)*c,Math.cos(p*m/b)*c,o);for(m=0;m<b;m++)k.faces.push(new THREE.Face4(m,m+b,b+(m+1)%b,(m+1)%b));if(c>0){j(0,0,-o-(h||0));for(m=b;m<b+b/2;m++)k.faces.push(new THREE.Face4(2*b,(2*m-2*b)%b,(2*m-2*b+1)%b,(2*m-2*b+2)%b))}if(d>0){j(0,0,o+(g||0));
for(m=b+b/2;m<2*b;m++)k.faces.push(new THREE.Face4(2*b+1,(2*m-2*b+2)%b+b,(2*m-2*b+1)%b+b,(2*m-2*b)%b+b))}m=0;for(b=this.faces.length;m<b;m++){d=[];c=this.faces[m];g=this.vertices[c.a];h=this.vertices[c.b];o=this.vertices[c.c];var u=this.vertices[c.d];d.push(new THREE.UV(0.5+Math.atan2(g.position.x,g.position.y)/p,0.5+g.position.z/f));d.push(new THREE.UV(0.5+Math.atan2(h.position.x,h.position.y)/p,0.5+h.position.z/f));d.push(new THREE.UV(0.5+Math.atan2(o.position.x,o.position.y)/p,0.5+o.position.z/
f));c instanceof THREE.Face4&&d.push(new THREE.UV(0.5+Math.atan2(u.position.x,u.position.y)/p,0.5+u.position.z/f));this.faceVertexUvs[0].push(d)}this.computeCentroids();this.computeFaceNormals()};THREE.Cylinder.prototype=new THREE.Geometry;THREE.Cylinder.prototype.constructor=THREE.Cylinder;
THREE.Icosahedron=function(b){function d(u,y,t){var B=Math.sqrt(u*u+y*y+t*t);return g.vertices.push(new THREE.Vertex(new THREE.Vector3(u/B,y/B,t/B)))-1}function c(u,y,t,B){B.faces.push(new THREE.Face3(u,y,t))}function f(u,y){var t=g.vertices[u].position,B=g.vertices[y].position;return d((t.x+B.x)/2,(t.y+B.y)/2,(t.z+B.z)/2)}var g=this,h=new THREE.Geometry,j;this.subdivisions=b||0;THREE.Geometry.call(this);b=(1+Math.sqrt(5))/2;d(-1,b,0);d(1,b,0);d(-1,-b,0);d(1,-b,0);d(0,-1,b);d(0,1,b);d(0,-1,-b);d(0,
1,-b);d(b,0,-1);d(b,0,1);d(-b,0,-1);d(-b,0,1);c(0,11,5,h);c(0,5,1,h);c(0,1,7,h);c(0,7,10,h);c(0,10,11,h);c(1,5,9,h);c(5,11,4,h);c(11,10,2,h);c(10,7,6,h);c(7,1,8,h);c(3,9,4,h);c(3,4,2,h);c(3,2,6,h);c(3,6,8,h);c(3,8,9,h);c(4,9,5,h);c(2,4,11,h);c(6,2,10,h);c(8,6,7,h);c(9,8,1,h);for(b=0;b<this.subdivisions;b++){j=new THREE.Geometry;for(var k in h.faces){var m=f(h.faces[k].a,h.faces[k].b),p=f(h.faces[k].b,h.faces[k].c),o=f(h.faces[k].c,h.faces[k].a);c(h.faces[k].a,m,o,j);c(h.faces[k].b,p,m,j);c(h.faces[k].c,
o,p,j);c(m,p,o,j)}h.faces=j.faces}g.faces=h.faces;delete h;delete j;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.Icosahedron.prototype=new THREE.Geometry;THREE.Icosahedron.prototype.constructor=THREE.Icosahedron;
THREE.Lathe=function(b,d,c){THREE.Geometry.call(this);this.steps=d||12;this.angle=c||2*Math.PI;d=this.angle/this.steps;c=[];for(var f=[],g=[],h=[],j=(new THREE.Matrix4).setRotationZ(d),k=0;k<b.length;k++){this.vertices.push(new THREE.Vertex(b[k]));c[k]=b[k].clone();f[k]=this.vertices.length-1}for(var m=0;m<=this.angle+0.001;m+=d){for(k=0;k<c.length;k++)if(m<this.angle){c[k]=j.multiplyVector3(c[k].clone());this.vertices.push(new THREE.Vertex(c[k]));g[k]=this.vertices.length-1}else g=h;m==0&&(h=f);
for(k=0;k<f.length-1;k++){this.faces.push(new THREE.Face4(g[k],g[k+1],f[k+1],f[k]));this.faceVertexUvs[0].push([new THREE.UV(1-m/this.angle,k/b.length),new THREE.UV(1-m/this.angle,(k+1)/b.length),new THREE.UV(1-(m-d)/this.angle,(k+1)/b.length),new THREE.UV(1-(m-d)/this.angle,k/b.length)])}f=g;g=[]}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.Lathe.prototype=new THREE.Geometry;THREE.Lathe.prototype.constructor=THREE.Lathe;
THREE.Plane=function(b,d,c,f){THREE.Geometry.call(this);var g,h=b/2,j=d/2;c=c||1;f=f||1;var k=c+1,m=f+1;b/=c;var p=d/f;for(g=0;g<m;g++)for(d=0;d<k;d++)this.vertices.push(new THREE.Vertex(new THREE.Vector3(d*b-h,-(g*p-j),0)));for(g=0;g<f;g++)for(d=0;d<c;d++){this.faces.push(new THREE.Face4(d+k*g,d+k*(g+1),d+1+k*(g+1),d+1+k*g));this.faceVertexUvs[0].push([new THREE.UV(d/c,g/f),new THREE.UV(d/c,(g+1)/f),new THREE.UV((d+1)/c,(g+1)/f),new THREE.UV((d+1)/c,g/f)])}this.computeCentroids();this.computeFaceNormals()};
THREE.Plane.prototype=new THREE.Geometry;THREE.Plane.prototype.constructor=THREE.Plane;
THREE.Sphere=function(b,d,c){THREE.Geometry.call(this);var f,g=Math.PI,h=Math.max(3,d||8),j=Math.max(2,c||6);d=[];for(c=0;c<j+1;c++){f=c/j;var k=b*Math.cos(f*g),m=b*Math.sin(f*g),p=[],o=0;for(f=0;f<h;f++){var u=2*f/h,y=m*Math.sin(u*g);u=m*Math.cos(u*g);(c==0||c==j)&&f>0||(o=this.vertices.push(new THREE.Vertex(new THREE.Vector3(u,k,y)))-1);p.push(o)}d.push(p)}var t,B,F;g=d.length;for(c=0;c<g;c++){h=d[c].length;if(c>0)for(f=0;f<h;f++){p=f==h-1;j=d[c][p?0:f+1];k=d[c][p?h-1:f];m=d[c-1][p?h-1:f];p=d[c-
1][p?0:f+1];y=c/(g-1);t=(c-1)/(g-1);B=(f+1)/h;u=f/h;o=new THREE.UV(1-B,y);y=new THREE.UV(1-u,y);u=new THREE.UV(1-u,t);var H=new THREE.UV(1-B,t);if(c<d.length-1){t=this.vertices[j].position.clone();B=this.vertices[k].position.clone();F=this.vertices[m].position.clone();t.normalize();B.normalize();F.normalize();this.faces.push(new THREE.Face3(j,k,m,[new THREE.Vector3(t.x,t.y,t.z),new THREE.Vector3(B.x,B.y,B.z),new THREE.Vector3(F.x,F.y,F.z)]));this.faceVertexUvs[0].push([o,y,u])}if(c>1){t=this.vertices[j].position.clone();
B=this.vertices[m].position.clone();F=this.vertices[p].position.clone();t.normalize();B.normalize();F.normalize();this.faces.push(new THREE.Face3(j,m,p,[new THREE.Vector3(t.x,t.y,t.z),new THREE.Vector3(B.x,B.y,B.z),new THREE.Vector3(F.x,F.y,F.z)]));this.faceVertexUvs[0].push([o,u,H])}}}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.boundingSphere={radius:b}};THREE.Sphere.prototype=new THREE.Geometry;THREE.Sphere.prototype.constructor=THREE.Sphere;
THREE.Torus=function(b,d,c,f){THREE.Geometry.call(this);this.radius=b||100;this.tube=d||40;this.segmentsR=c||8;this.segmentsT=f||6;b=[];for(d=0;d<=this.segmentsR;++d)for(c=0;c<=this.segmentsT;++c){f=c/this.segmentsT*2*Math.PI;var g=d/this.segmentsR*2*Math.PI;this.vertices.push(new THREE.Vertex(new THREE.Vector3((this.radius+this.tube*Math.cos(g))*Math.cos(f),(this.radius+this.tube*Math.cos(g))*Math.sin(f),this.tube*Math.sin(g))));b.push([c/this.segmentsT,1-d/this.segmentsR])}for(d=1;d<=this.segmentsR;++d)for(c=
1;c<=this.segmentsT;++c){f=(this.segmentsT+1)*d+c;g=(this.segmentsT+1)*d+c-1;var h=(this.segmentsT+1)*(d-1)+c-1,j=(this.segmentsT+1)*(d-1)+c;this.faces.push(new THREE.Face4(f,g,h,j));this.faceVertexUvs[0].push([new THREE.UV(b[f][0],b[f][1]),new THREE.UV(b[g][0],b[g][1]),new THREE.UV(b[h][0],b[h][1]),new THREE.UV(b[j][0],b[j][1])])}delete b;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.Torus.prototype=new THREE.Geometry;THREE.Torus.prototype.constructor=THREE.Torus;
THREE.TorusKnot=function(b,d,c,f,g,h,j){function k(u,y,t,B,F,H){y=t/B*u;t=Math.cos(y);return new THREE.Vector3(F*(2+t)*0.5*Math.cos(u),F*(2+t)*Math.sin(u)*0.5,H*F*Math.sin(y)*0.5)}THREE.Geometry.call(this);this.radius=b||200;this.tube=d||40;this.segmentsR=c||64;this.segmentsT=f||8;this.p=g||2;this.q=h||3;this.heightScale=j||1;this.grid=Array(this.segmentsR);c=new THREE.Vector3;f=new THREE.Vector3;h=new THREE.Vector3;for(b=0;b<this.segmentsR;++b){this.grid[b]=Array(this.segmentsT);for(d=0;d<this.segmentsT;++d){var m=
b/this.segmentsR*2*this.p*Math.PI;j=d/this.segmentsT*2*Math.PI;g=k(m,j,this.q,this.p,this.radius,this.heightScale);m=k(m+0.01,j,this.q,this.p,this.radius,this.heightScale);c.x=m.x-g.x;c.y=m.y-g.y;c.z=m.z-g.z;f.x=m.x+g.x;f.y=m.y+g.y;f.z=m.z+g.z;h.cross(c,f);f.cross(h,c);h.normalize();f.normalize();m=-this.tube*Math.cos(j);j=this.tube*Math.sin(j);g.x+=m*f.x+j*h.x;g.y+=m*f.y+j*h.y;g.z+=m*f.z+j*h.z;this.grid[b][d]=this.vertices.push(new THREE.Vertex(new THREE.Vector3(g.x,g.y,g.z)))-1}}for(b=0;b<this.segmentsR;++b)for(d=
0;d<this.segmentsT;++d){f=(b+1)%this.segmentsR;h=(d+1)%this.segmentsT;g=this.grid[b][d];c=this.grid[f][d];f=this.grid[f][h];h=this.grid[b][h];j=new THREE.UV(b/this.segmentsR,d/this.segmentsT);m=new THREE.UV((b+1)/this.segmentsR,d/this.segmentsT);var p=new THREE.UV((b+1)/this.segmentsR,(d+1)/this.segmentsT),o=new THREE.UV(b/this.segmentsR,(d+1)/this.segmentsT);this.faces.push(new THREE.Face4(g,c,f,h));this.faceVertexUvs[0].push([j,m,p,o])}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};
THREE.TorusKnot.prototype=new THREE.Geometry;THREE.TorusKnot.prototype.constructor=THREE.TorusKnot;THREE.Loader=function(b){this.statusDomElement=(this.showStatus=b)?THREE.Loader.prototype.addStatusElement():null;this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){}};
THREE.Loader.prototype={addStatusElement:function(){var b=document.createElement("div");b.style.position="absolute";b.style.right="0px";b.style.top="0px";b.style.fontSize="0.8em";b.style.textAlign="left";b.style.background="rgba(0,0,0,0.25)";b.style.color="#fff";b.style.width="120px";b.style.padding="0.5em 0.5em 0.5em 0.5em";b.style.zIndex=1E3;b.innerHTML="Loading ...";return b},updateProgress:function(b){var d="Loaded ";d+=b.total?(100*b.loaded/b.total).toFixed(0)+"%":(b.loaded/1E3).toFixed(2)+" KB";
this.statusDomElement.innerHTML=d},extractUrlbase:function(b){b=b.split("/");b.pop();return b.join("/")},init_materials:function(b,d,c){b.materials=[];for(var f=0;f<d.length;++f)b.materials[f]=[THREE.Loader.prototype.createMaterial(d[f],c)]},createMaterial:function(b,d){function c(k){k=Math.log(k)/Math.LN2;return Math.floor(k)==k}function f(k,m){var p=new Image;p.onload=function(){if(!c(this.width)||!c(this.height)){var o=Math.pow(2,Math.round(Math.log(this.width)/Math.LN2)),u=Math.pow(2,Math.round(Math.log(this.height)/
Math.LN2));k.image.width=o;k.image.height=u;k.image.getContext("2d").drawImage(this,0,0,o,u)}else k.image=this;k.needsUpdate=!0};p.src=m}var g,h,j;g="MeshLambertMaterial";h={color:15658734,opacity:1,map:null,lightMap:null,wireframe:b.wireframe};if(b.shading)if(b.shading=="Phong")g="MeshPhongMaterial";else b.shading=="Basic"&&(g="MeshBasicMaterial");if(b.blending)if(b.blending=="Additive")h.blending=THREE.AdditiveBlending;else if(b.blending=="Subtractive")h.blending=THREE.SubtractiveBlending;else if(b.blending==
"Multiply")h.blending=THREE.MultiplyBlending;if(b.transparent!==undefined)h.transparent=b.transparent;if(b.depthTest!==undefined)h.depthTest=b.depthTest;if(b.vertexColors!==undefined)if(b.vertexColors=="face")h.vertexColors=THREE.FaceColors;else if(b.vertexColors)h.vertexColors=THREE.VertexColors;if(b.mapDiffuse&&d){j=document.createElement("canvas");h.map=new THREE.Texture(j);h.map.sourceFile=b.mapDiffuse;f(h.map,d+"/"+b.mapDiffuse)}else if(b.colorDiffuse){j=(b.colorDiffuse[0]*255<<16)+(b.colorDiffuse[1]*
255<<8)+b.colorDiffuse[2]*255;h.color=j;h.opacity=b.transparency}else if(b.DbgColor)h.color=b.DbgColor;if(b.mapLightmap&&d){j=document.createElement("canvas");h.lightMap=new THREE.Texture(j);h.lightMap.sourceFile=b.mapLightmap;f(h.lightMap,d+"/"+b.mapLightmap)}return new THREE[g](h)}};THREE.JSONLoader=function(b){THREE.Loader.call(this,b)};THREE.JSONLoader.prototype=new THREE.Loader;THREE.JSONLoader.prototype.constructor=THREE.JSONLoader;THREE.JSONLoader.prototype.supr=THREE.Loader.prototype;
THREE.JSONLoader.prototype.load=function(b){var d=this,c=b.model,f=b.callback,g=b.texture_path?b.texture_path:this.extractUrlbase(c);b=new Worker(c);b.onmessage=function(h){d.createModel(h.data,f,g);d.onLoadComplete()};this.onLoadStart();b.postMessage((new Date).getTime())};
THREE.JSONLoader.prototype.createModel=function(b,d,c){var f=new THREE.Geometry;this.init_materials(f,b.materials,c);(function(){if(b.version===undefined||b.version!=2)console.error("Deprecated file format.");else{var g,h,j,k,m,p,o,u,y,t,B,F,H,G,X,A=b.faces;t=b.vertices;var M=b.normals,Q=b.colors;p=b.scale!==undefined?b.scale:1;var R=0;for(g=0;g<b.uvs.length;g++)b.uvs[g].length&&R++;for(g=0;g<R;g++){f.faceUvs[g]=[];f.faceVertexUvs[g]=[]}k=0;for(m=t.length;k<m;){o=new THREE.Vertex;o.position.x=t[k++]/
p;o.position.y=t[k++]/p;o.position.z=t[k++]/p;f.vertices.push(o)}k=0;for(m=A.length;k<m;){t=A[k++];p=t&1;j=t&2;g=t&4;h=t&8;u=t&16;o=t&32;B=t&64;t&=128;if(p){F=new THREE.Face4;F.a=A[k++];F.b=A[k++];F.c=A[k++];F.d=A[k++];p=4}else{F=new THREE.Face3;F.a=A[k++];F.b=A[k++];F.c=A[k++];p=3}if(j){j=A[k++];F.materials=f.materials[j]}j=f.faces.length;if(g)for(g=0;g<R;g++){H=b.uvs[g];y=A[k++];X=H[y*2];y=H[y*2+1];f.faceUvs[g][j]=new THREE.UV(X,y)}if(h)for(g=0;g<R;g++){H=b.uvs[g];G=[];for(h=0;h<p;h++){y=A[k++];
X=H[y*2];y=H[y*2+1];G[h]=new THREE.UV(X,y)}f.faceVertexUvs[g][j]=G}if(u){u=A[k++]*3;h=new THREE.Vector3;h.x=M[u++];h.y=M[u++];h.z=M[u];F.normal=h}if(o)for(g=0;g<p;g++){u=A[k++]*3;h=new THREE.Vector3;h.x=M[u++];h.y=M[u++];h.z=M[u];F.vertexNormals.push(h)}if(B){o=A[k++];o=new THREE.Color(Q[o]);F.color=o}if(t)for(g=0;g<p;g++){o=A[k++];o=new THREE.Color(Q[o]);F.vertexColors.push(o)}f.faces.push(F)}}})();(function(){var g,h,j,k;if(b.skinWeights){g=0;for(h=b.skinWeights.length;g<h;g+=2){j=b.skinWeights[g];
k=b.skinWeights[g+1];f.skinWeights.push(new THREE.Vector4(j,k,0,0))}}if(b.skinIndices){g=0;for(h=b.skinIndices.length;g<h;g+=2){j=b.skinIndices[g];k=b.skinIndices[g+1];f.skinIndices.push(new THREE.Vector4(j,k,0,0))}}f.bones=b.bones;f.animation=b.animation})();(function(){if(b.morphTargets!==undefined){var g,h,j,k,m,p;g=0;for(h=b.morphTargets.length;g<h;g++){f.morphTargets[g]={};f.morphTargets[g].name=b.morphTargets[g].name;f.morphTargets[g].vertices=[];m=f.morphTargets[g].vertices;p=b.morphTargets[g].vertices;
j=0;for(k=p.length;j<k;j+=3)m.push(new THREE.Vertex(new THREE.Vector3(p[j],p[j+1],p[j+2])))}}if(b.morphColors!==undefined){var o,u;g=0;for(h=b.morphColors.length;g<h;g++){f.morphColors[g]={};f.morphColors[g].name=b.morphColors[g].name;f.morphColors[g].colors=[];p=f.morphColors[g].colors;o=b.morphColors[g].colors;k=0;for(m=o.length;k<m;k+=3){u=new THREE.Color(16755200);u.setRGB(o[j],o[j+1],o[j+2]);p.push(u)}}}})();(function(){if(b.edges!==undefined){var g,h,j;for(g=0;g<b.edges.length;g+=2){h=b.edges[g];
j=b.edges[g+1];f.edges.push(new THREE.Edge(f.vertices[h],f.vertices[j],h,j))}}})();f.computeCentroids();f.computeFaceNormals();f.computeEdgeFaces();d(f)};THREE.BinaryLoader=function(b){THREE.Loader.call(this,b)};THREE.BinaryLoader.prototype=new THREE.Loader;THREE.BinaryLoader.prototype.constructor=THREE.BinaryLoader;THREE.BinaryLoader.prototype.supr=THREE.Loader.prototype;
THREE.BinaryLoader.prototype={load:function(b){var d=b.model,c=b.callback,f=b.texture_path?b.texture_path:THREE.Loader.prototype.extractUrlbase(d),g=b.bin_path?b.bin_path:THREE.Loader.prototype.extractUrlbase(d);b=(new Date).getTime();d=new Worker(d);var h=this.showProgress?THREE.Loader.prototype.updateProgress:null;d.onmessage=function(j){THREE.BinaryLoader.prototype.loadAjaxBuffers(j.data.buffers,j.data.materials,c,g,f,h)};d.onerror=function(j){alert("worker.onerror: "+j.message+"\n"+j.data);j.preventDefault()};
d.postMessage(b)},loadAjaxBuffers:function(b,d,c,f,g,h){var j=new XMLHttpRequest,k=f+"/"+b,m=0;j.onreadystatechange=function(){if(j.readyState==4)j.status==200||j.status==0?THREE.BinaryLoader.prototype.createBinModel(j.responseText,c,g,d):alert("Couldn't load ["+k+"] ["+j.status+"]");else if(j.readyState==3){if(h){m==0&&(m=j.getResponseHeader("Content-Length"));h({total:m,loaded:j.responseText.length})}}else j.readyState==2&&(m=j.getResponseHeader("Content-Length"))};j.open("GET",k,!0);j.overrideMimeType("text/plain; charset=x-user-defined");
j.setRequestHeader("Content-Type","text/plain");j.send(null)},createBinModel:function(b,d,c,f){var g=function(h){function j(T,P){var N=o(T,P),Ca=o(T,P+1),Ka=o(T,P+2),n=o(T,P+3),C=(n<<1&255|Ka>>7)-127;N|=(Ka&127)<<16|Ca<<8;if(N==0&&C==-127)return 0;return(1-2*(n>>7))*(1+N*Math.pow(2,-23))*Math.pow(2,C)}function k(T,P){var N=o(T,P),Ca=o(T,P+1),Ka=o(T,P+2);return(o(T,P+3)<<24)+(Ka<<16)+(Ca<<8)+N}function m(T,P){var N=o(T,P);return(o(T,P+1)<<8)+N}function p(T,P){var N=o(T,P);return N>127?N-256:N}function o(T,
P){return T.charCodeAt(P)&255}function u(T){var P,N,Ca;P=k(b,T);N=k(b,T+R);Ca=k(b,T+Da);T=m(b,T+ma);THREE.BinaryLoader.prototype.f3(G,P,N,Ca,T)}function y(T){var P,N,Ca,Ka,n,C;P=k(b,T);N=k(b,T+R);Ca=k(b,T+Da);Ka=m(b,T+ma);n=k(b,T+va);C=k(b,T+ca);T=k(b,T+e);THREE.BinaryLoader.prototype.f3n(G,M,P,N,Ca,Ka,n,C,T)}function t(T){var P,N,Ca,Ka;P=k(b,T);N=k(b,T+ea);Ca=k(b,T+ya);Ka=k(b,T+Ba);T=m(b,T+Fa);THREE.BinaryLoader.prototype.f4(G,P,N,Ca,Ka,T)}function B(T){var P,N,Ca,Ka,n,C,w,x;P=k(b,T);N=k(b,T+ea);
Ca=k(b,T+ya);Ka=k(b,T+Ba);n=m(b,T+Fa);C=k(b,T+Z);w=k(b,T+oa);x=k(b,T+pa);T=k(b,T+sa);THREE.BinaryLoader.prototype.f4n(G,M,P,N,Ca,Ka,n,C,w,x,T)}function F(T){var P,N;P=k(b,T);N=k(b,T+ga);T=k(b,T+aa);THREE.BinaryLoader.prototype.uv3(G.faceVertexUvs[0],Q[P*2],Q[P*2+1],Q[N*2],Q[N*2+1],Q[T*2],Q[T*2+1])}function H(T){var P,N,Ca;P=k(b,T);N=k(b,T+na);Ca=k(b,T+Ea);T=k(b,T+ja);THREE.BinaryLoader.prototype.uv4(G.faceVertexUvs[0],Q[P*2],Q[P*2+1],Q[N*2],Q[N*2+1],Q[Ca*2],Q[Ca*2+1],Q[T*2],Q[T*2+1])}var G=this,X=
0,A,M=[],Q=[],R,Da,ma,va,ca,e,ea,ya,Ba,Fa,Z,oa,pa,sa,ga,aa,na,Ea,ja,la,ua,Ra,Ya,Za,Na;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(G,f,h);A={signature:b.substr(X,8),header_bytes:o(b,X+8),vertex_coordinate_bytes:o(b,X+9),normal_coordinate_bytes:o(b,X+10),uv_coordinate_bytes:o(b,X+11),vertex_index_bytes:o(b,X+12),normal_index_bytes:o(b,X+13),uv_index_bytes:o(b,X+14),material_index_bytes:o(b,X+15),nvertices:k(b,X+16),nnormals:k(b,X+16+4),nuvs:k(b,X+16+8),ntri_flat:k(b,X+16+12),ntri_smooth:k(b,
X+16+16),ntri_flat_uv:k(b,X+16+20),ntri_smooth_uv:k(b,X+16+24),nquad_flat:k(b,X+16+28),nquad_smooth:k(b,X+16+32),nquad_flat_uv:k(b,X+16+36),nquad_smooth_uv:k(b,X+16+40)};X+=A.header_bytes;R=A.vertex_index_bytes;Da=A.vertex_index_bytes*2;ma=A.vertex_index_bytes*3;va=A.vertex_index_bytes*3+A.material_index_bytes;ca=A.vertex_index_bytes*3+A.material_index_bytes+A.normal_index_bytes;e=A.vertex_index_bytes*3+A.material_index_bytes+A.normal_index_bytes*2;ea=A.vertex_index_bytes;ya=A.vertex_index_bytes*
2;Ba=A.vertex_index_bytes*3;Fa=A.vertex_index_bytes*4;Z=A.vertex_index_bytes*4+A.material_index_bytes;oa=A.vertex_index_bytes*4+A.material_index_bytes+A.normal_index_bytes;pa=A.vertex_index_bytes*4+A.material_index_bytes+A.normal_index_bytes*2;sa=A.vertex_index_bytes*4+A.material_index_bytes+A.normal_index_bytes*3;ga=A.uv_index_bytes;aa=A.uv_index_bytes*2;na=A.uv_index_bytes;Ea=A.uv_index_bytes*2;ja=A.uv_index_bytes*3;h=A.vertex_index_bytes*3+A.material_index_bytes;Na=A.vertex_index_bytes*4+A.material_index_bytes;
la=A.ntri_flat*h;ua=A.ntri_smooth*(h+A.normal_index_bytes*3);Ra=A.ntri_flat_uv*(h+A.uv_index_bytes*3);Ya=A.ntri_smooth_uv*(h+A.normal_index_bytes*3+A.uv_index_bytes*3);Za=A.nquad_flat*Na;h=A.nquad_smooth*(Na+A.normal_index_bytes*4);Na=A.nquad_flat_uv*(Na+A.uv_index_bytes*4);X+=function(T){for(var P,N,Ca,Ka=A.vertex_coordinate_bytes*3,n=T+A.nvertices*Ka;T<n;T+=Ka){P=j(b,T);N=j(b,T+A.vertex_coordinate_bytes);Ca=j(b,T+A.vertex_coordinate_bytes*2);THREE.BinaryLoader.prototype.v(G,P,N,Ca)}return A.nvertices*
Ka}(X);X+=function(T){for(var P,N,Ca,Ka=A.normal_coordinate_bytes*3,n=T+A.nnormals*Ka;T<n;T+=Ka){P=p(b,T);N=p(b,T+A.normal_coordinate_bytes);Ca=p(b,T+A.normal_coordinate_bytes*2);M.push(P/127,N/127,Ca/127)}return A.nnormals*Ka}(X);X+=function(T){for(var P,N,Ca=A.uv_coordinate_bytes*2,Ka=T+A.nuvs*Ca;T<Ka;T+=Ca){P=j(b,T);N=j(b,T+A.uv_coordinate_bytes);Q.push(P,N)}return A.nuvs*Ca}(X);la=X+la;ua=la+ua;Ra=ua+Ra;Ya=Ra+Ya;Za=Ya+Za;h=Za+h;Na=h+Na;(function(T){var P,N=A.vertex_index_bytes*3+A.material_index_bytes,
Ca=N+A.uv_index_bytes*3,Ka=T+A.ntri_flat_uv*Ca;for(P=T;P<Ka;P+=Ca){u(P);F(P+N)}return Ka-T})(ua);(function(T){var P,N=A.vertex_index_bytes*3+A.material_index_bytes+A.normal_index_bytes*3,Ca=N+A.uv_index_bytes*3,Ka=T+A.ntri_smooth_uv*Ca;for(P=T;P<Ka;P+=Ca){y(P);F(P+N)}return Ka-T})(Ra);(function(T){var P,N=A.vertex_index_bytes*4+A.material_index_bytes,Ca=N+A.uv_index_bytes*4,Ka=T+A.nquad_flat_uv*Ca;for(P=T;P<Ka;P+=Ca){t(P);H(P+N)}return Ka-T})(h);(function(T){var P,N=A.vertex_index_bytes*4+A.material_index_bytes+
A.normal_index_bytes*4,Ca=N+A.uv_index_bytes*4,Ka=T+A.nquad_smooth_uv*Ca;for(P=T;P<Ka;P+=Ca){B(P);H(P+N)}return Ka-T})(Na);(function(T){var P,N=A.vertex_index_bytes*3+A.material_index_bytes,Ca=T+A.ntri_flat*N;for(P=T;P<Ca;P+=N)u(P);return Ca-T})(X);(function(T){var P,N=A.vertex_index_bytes*3+A.material_index_bytes+A.normal_index_bytes*3,Ca=T+A.ntri_smooth*N;for(P=T;P<Ca;P+=N)y(P);return Ca-T})(la);(function(T){var P,N=A.vertex_index_bytes*4+A.material_index_bytes,Ca=T+A.nquad_flat*N;for(P=T;P<Ca;P+=
N)t(P);return Ca-T})(Ya);(function(T){var P,N=A.vertex_index_bytes*4+A.material_index_bytes+A.normal_index_bytes*4,Ca=T+A.nquad_smooth*N;for(P=T;P<Ca;P+=N)B(P);return Ca-T})(Za);this.computeCentroids();this.computeFaceNormals()};g.prototype=new THREE.Geometry;g.prototype.constructor=g;d(new g(c))},v:function(b,d,c,f){b.vertices.push(new THREE.Vertex(new THREE.Vector3(d,c,f)))},f3:function(b,d,c,f,g){b.faces.push(new THREE.Face3(d,c,f,null,null,b.materials[g]))},f4:function(b,d,c,f,g,h){b.faces.push(new THREE.Face4(d,
c,f,g,null,null,b.materials[h]))},f3n:function(b,d,c,f,g,h,j,k,m){h=b.materials[h];var p=d[k*3],o=d[k*3+1];k=d[k*3+2];var u=d[m*3],y=d[m*3+1];m=d[m*3+2];b.faces.push(new THREE.Face3(c,f,g,[new THREE.Vector3(d[j*3],d[j*3+1],d[j*3+2]),new THREE.Vector3(p,o,k),new THREE.Vector3(u,y,m)],null,h))},f4n:function(b,d,c,f,g,h,j,k,m,p,o){j=b.materials[j];var u=d[m*3],y=d[m*3+1];m=d[m*3+2];var t=d[p*3],B=d[p*3+1];p=d[p*3+2];var F=d[o*3],H=d[o*3+1];o=d[o*3+2];b.faces.push(new THREE.Face4(c,f,g,h,[new THREE.Vector3(d[k*
3],d[k*3+1],d[k*3+2]),new THREE.Vector3(u,y,m),new THREE.Vector3(t,B,p),new THREE.Vector3(F,H,o)],null,j))},uv3:function(b,d,c,f,g,h,j){var k=[];k.push(new THREE.UV(d,c));k.push(new THREE.UV(f,g));k.push(new THREE.UV(h,j));b.push(k)},uv4:function(b,d,c,f,g,h,j,k,m){var p=[];p.push(new THREE.UV(d,c));p.push(new THREE.UV(f,g));p.push(new THREE.UV(h,j));p.push(new THREE.UV(k,m));b.push(p)}};THREE.SceneLoader=function(){};
THREE.SceneLoader.prototype={load:function(b,d,c,f){var g=new Worker(b);g.postMessage(0);var h=THREE.Loader.prototype.extractUrlbase(b);g.onmessage=function(j){function k(ga,aa){return aa=="relativeToHTML"?ga:h+"/"+ga}function m(){for(t in ca.objects)if(!Z.objects[t]){X=ca.objects[t];if(R=Z.geometries[X.geometry]){va=[];for(sa=0;sa<X.materials.length;sa++)va[sa]=Z.materials[X.materials[sa]];A=X.position;r=X.rotation;q=X.quaternion;s=X.scale;q=0;va.length==0&&(va[0]=new THREE.MeshFaceMaterial);object=
new THREE.Mesh(R,va);object.position.set(A[0],A[1],A[2]);if(q){object.quaternion.set(q[0],q[1],q[2],q[3]);object.useQuaternion=!0}else object.rotation.set(r[0],r[1],r[2]);object.scale.set(s[0],s[1],s[2]);object.visible=X.visible;Z.scene.addObject(object);Z.objects[t]=object;if(X.meshCollider){var ga=THREE.CollisionUtils.MeshColliderWBox(object);THREE.Collisions.colliders.push(ga)}}}}function p(ga){return function(aa){Z.geometries[ga]=aa;m();ea-=1;o()}}function o(){f({total_models:Ba,total_textures:Fa,
loaded_models:Ba-ea,loaded_textures:Fa-ya},Z);ea==0&&ya==0&&c(Z)}var u,y,t,B,F,H,G,X,A,M,Q,R,Da,ma,va,ca,e,ea,ya,Ba,Fa,Z;ca=j.data;j=new THREE.BinaryLoader;e=new THREE.JSONLoader;ya=ea=0;Z={scene:new THREE.Scene,geometries:{},materials:{},textures:{},objects:{},cameras:{},lights:{},fogs:{}};if(ca.transform){var oa=ca.transform.position;M=ca.transform.rotation;var pa=ca.transform.scale;oa&&Z.scene.position.set(oa[0],oa[1],oa[2]);M&&Z.scene.rotation.set(M[0],M[1],M[2]);pa&&Z.scene.scale.set(pa[0],pa[1],
pa[2]);(oa||M||pa)&&Z.scene.updateMatrix()}oa=function(){ya-=1;o()};for(F in ca.cameras){M=ca.cameras[F];if(M.type=="perspective")Da=new THREE.Camera(M.fov,M.aspect,M.near,M.far);else if(M.type=="ortho"){Da=new THREE.Camera;Da.projectionMatrix=THREE.Matrix4.makeOrtho(M.left,M.right,M.top,M.bottom,M.near,M.far)}A=M.position;M=M.target;Da.position.set(A[0],A[1],A[2]);Da.target.position.set(M[0],M[1],M[2]);Z.cameras[F]=Da}for(B in ca.lights){F=ca.lights[B];Da=F.color!==undefined?F.color:16777215;M=F.intensity!==
undefined?F.intensity:1;if(F.type=="directional"){A=F.direction;light=new THREE.DirectionalLight(Da,M);light.position.set(A[0],A[1],A[2]);light.position.normalize()}else if(F.type=="point"){A=F.position;light=new THREE.PointLight(Da,M);light.position.set(A[0],A[1],A[2])}Z.scene.addLight(light);Z.lights[B]=light}for(H in ca.fogs){B=ca.fogs[H];if(B.type=="linear")ma=new THREE.Fog(0,B.near,B.far);else B.type=="exp2"&&(ma=new THREE.FogExp2(0,B.density));M=B.color;ma.color.setRGB(M[0],M[1],M[2]);Z.fogs[H]=
ma}if(Z.cameras&&ca.defaults.camera)Z.currentCamera=Z.cameras[ca.defaults.camera];if(Z.fogs&&ca.defaults.fog)Z.scene.fog=Z.fogs[ca.defaults.fog];M=ca.defaults.bgcolor;Z.bgColor=new THREE.Color;Z.bgColor.setRGB(M[0],M[1],M[2]);Z.bgColorAlpha=ca.defaults.bgalpha;for(u in ca.geometries){H=ca.geometries[u];if(H.type=="bin_mesh"||H.type=="ascii_mesh")ea+=1}Ba=ea;for(u in ca.geometries){H=ca.geometries[u];if(H.type=="cube"){R=new THREE.Cube(H.width,H.height,H.depth,H.segmentsWidth,H.segmentsHeight,H.segmentsDepth,
null,H.flipped,H.sides);Z.geometries[u]=R}else if(H.type=="plane"){R=new THREE.Plane(H.width,H.height,H.segmentsWidth,H.segmentsHeight);Z.geometries[u]=R}else if(H.type=="sphere"){R=new THREE.Sphere(H.radius,H.segmentsWidth,H.segmentsHeight);Z.geometries[u]=R}else if(H.type=="cylinder"){R=new THREE.Cylinder(H.numSegs,H.topRad,H.botRad,H.height,H.topOffset,H.botOffset);Z.geometries[u]=R}else if(H.type=="torus"){R=new THREE.Torus(H.radius,H.tube,H.segmentsR,H.segmentsT);Z.geometries[u]=R}else if(H.type==
"icosahedron"){R=new THREE.Icosahedron(H.subdivisions);Z.geometries[u]=R}else if(H.type=="bin_mesh")j.load({model:k(H.url,ca.urlBaseType),callback:p(u)});else H.type=="ascii_mesh"&&e.load({model:k(H.url,ca.urlBaseType),callback:p(u)})}for(G in ca.textures){u=ca.textures[G];ya+=u.url instanceof Array?u.url.length:1}Fa=ya;for(G in ca.textures){u=ca.textures[G];if(u.mapping!=undefined&&THREE[u.mapping]!=undefined)u.mapping=new THREE[u.mapping];if(u.url instanceof Array){H=[];for(var sa=0;sa<u.url.length;sa++)H[sa]=
k(u.url[sa],ca.urlBaseType);H=THREE.ImageUtils.loadTextureCube(H,u.mapping,oa)}else{H=THREE.ImageUtils.loadTexture(k(u.url,ca.urlBaseType),u.mapping,oa);if(THREE[u.minFilter]!=undefined)H.minFilter=THREE[u.minFilter];if(THREE[u.magFilter]!=undefined)H.magFilter=THREE[u.magFilter]}Z.textures[G]=H}for(y in ca.materials){G=ca.materials[y];for(Q in G.parameters)if(Q=="envMap"||Q=="map"||Q=="lightMap")G.parameters[Q]=Z.textures[G.parameters[Q]];else if(Q=="shading")G.parameters[Q]=G.parameters[Q]=="flat"?
THREE.FlatShading:THREE.SmoothShading;else if(Q=="blending")G.parameters[Q]=THREE[G.parameters[Q]]?THREE[G.parameters[Q]]:THREE.NormalBlending;else Q=="combine"&&(G.parameters[Q]=G.parameters[Q]=="MixOperation"?THREE.MixOperation:THREE.MultiplyOperation);G=new THREE[G.type](G.parameters);Z.materials[y]=G}m();d(Z)}}};
THREE.MarchingCubes=function(b,d){THREE.Object3D.call(this);this.materials=d instanceof Array?d:[d];this.init=function(c){this.isolation=80;this.size=c;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(this.size3*3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=
0;this.hasPos=!1;this.hasNormal=!1;this.positionArray=new Float32Array(this.maxCount*3);this.normalArray=new Float32Array(this.maxCount*3)};this.lerp=function(c,f,g){return c+(f-c)*g};this.VIntX=function(c,f,g,h,j,k,m,p,o,u){j=(j-o)/(u-o);o=this.normal_cache;f[h]=k+j*this.delta;f[h+1]=m;f[h+2]=p;g[h]=this.lerp(o[c],o[c+3],j);g[h+1]=this.lerp(o[c+1],o[c+4],j);g[h+2]=this.lerp(o[c+2],o[c+5],j)};this.VIntY=function(c,f,g,h,j,k,m,p,o,u){j=(j-o)/(u-o);o=this.normal_cache;f[h]=k;f[h+1]=m+j*this.delta;f[h+
2]=p;f=c+this.yd*3;g[h]=this.lerp(o[c],o[f],j);g[h+1]=this.lerp(o[c+1],o[f+1],j);g[h+2]=this.lerp(o[c+2],o[f+2],j)};this.VIntZ=function(c,f,g,h,j,k,m,p,o,u){j=(j-o)/(u-o);o=this.normal_cache;f[h]=k;f[h+1]=m;f[h+2]=p+j*this.delta;f=c+this.zd*3;g[h]=this.lerp(o[c],o[f],j);g[h+1]=this.lerp(o[c+1],o[f+1],j);g[h+2]=this.lerp(o[c+2],o[f+2],j)};this.compNorm=function(c){var f=c*3;if(this.normal_cache[f]==0){this.normal_cache[f]=this.field[c-1]-this.field[c+1];this.normal_cache[f+1]=this.field[c-this.yd]-
this.field[c+this.yd];this.normal_cache[f+2]=this.field[c-this.zd]-this.field[c+this.zd]}};this.polygonize=function(c,f,g,h,j,k){var m=h+1,p=h+this.yd,o=h+this.zd,u=m+this.yd,y=m+this.zd,t=h+this.yd+this.zd,B=m+this.yd+this.zd,F=0,H=this.field[h],G=this.field[m],X=this.field[p],A=this.field[u],M=this.field[o],Q=this.field[y],R=this.field[t],Da=this.field[B];H<j&&(F|=1);G<j&&(F|=2);X<j&&(F|=8);A<j&&(F|=4);M<j&&(F|=16);Q<j&&(F|=32);R<j&&(F|=128);Da<j&&(F|=64);var ma=THREE.edgeTable[F];if(ma==0)return 0;
var va=this.delta,ca=c+va,e=f+va;va=g+va;if(ma&1){this.compNorm(h);this.compNorm(m);this.VIntX(h*3,this.vlist,this.nlist,0,j,c,f,g,H,G)}if(ma&2){this.compNorm(m);this.compNorm(u);this.VIntY(m*3,this.vlist,this.nlist,3,j,ca,f,g,G,A)}if(ma&4){this.compNorm(p);this.compNorm(u);this.VIntX(p*3,this.vlist,this.nlist,6,j,c,e,g,X,A)}if(ma&8){this.compNorm(h);this.compNorm(p);this.VIntY(h*3,this.vlist,this.nlist,9,j,c,f,g,H,X)}if(ma&16){this.compNorm(o);this.compNorm(y);this.VIntX(o*3,this.vlist,this.nlist,
12,j,c,f,va,M,Q)}if(ma&32){this.compNorm(y);this.compNorm(B);this.VIntY(y*3,this.vlist,this.nlist,15,j,ca,f,va,Q,Da)}if(ma&64){this.compNorm(t);this.compNorm(B);this.VIntX(t*3,this.vlist,this.nlist,18,j,c,e,va,R,Da)}if(ma&128){this.compNorm(o);this.compNorm(t);this.VIntY(o*3,this.vlist,this.nlist,21,j,c,f,va,M,R)}if(ma&256){this.compNorm(h);this.compNorm(o);this.VIntZ(h*3,this.vlist,this.nlist,24,j,c,f,g,H,M)}if(ma&512){this.compNorm(m);this.compNorm(y);this.VIntZ(m*3,this.vlist,this.nlist,27,j,ca,
f,g,G,Q)}if(ma&1024){this.compNorm(u);this.compNorm(B);this.VIntZ(u*3,this.vlist,this.nlist,30,j,ca,e,g,A,Da)}if(ma&2048){this.compNorm(p);this.compNorm(t);this.VIntZ(p*3,this.vlist,this.nlist,33,j,c,e,g,X,R)}F<<=4;for(j=h=0;THREE.triTable[F+j]!=-1;){c=F+j;f=c+1;g=c+2;this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[c],3*THREE.triTable[f],3*THREE.triTable[g],k);j+=3;h++}return h};this.posnormtriv=function(c,f,g,h,j,k){var m=this.count*3;this.positionArray[m]=c[g];this.positionArray[m+1]=c[g+
1];this.positionArray[m+2]=c[g+2];this.positionArray[m+3]=c[h];this.positionArray[m+4]=c[h+1];this.positionArray[m+5]=c[h+2];this.positionArray[m+6]=c[j];this.positionArray[m+7]=c[j+1];this.positionArray[m+8]=c[j+2];this.normalArray[m]=f[g];this.normalArray[m+1]=f[g+1];this.normalArray[m+2]=f[g+2];this.normalArray[m+3]=f[h];this.normalArray[m+4]=f[h+1];this.normalArray[m+5]=f[h+2];this.normalArray[m+6]=f[j];this.normalArray[m+7]=f[j+1];this.normalArray[m+8]=f[j+2];this.hasPos=!0;this.hasNormal=!0;
this.count+=3;this.count>=this.maxCount-3&&k(this)};this.begin=function(){this.count=0;this.hasPos=!1;this.hasNormal=!1};this.end=function(c){if(this.count!=0){for(var f=this.count*3;f<this.positionArray.length;f++)this.positionArray[f]=0;c(this)}};this.addBall=function(c,f,g,h,j){var k=this.size*Math.sqrt(h/j),m=g*this.size,p=f*this.size,o=c*this.size,u=Math.floor(m-k);u<1&&(u=1);m=Math.floor(m+k);m>this.size-1&&(m=this.size-1);var y=Math.floor(p-k);y<1&&(y=1);p=Math.floor(p+k);p>this.size-1&&(p=
this.size-1);var t=Math.floor(o-k);t<1&&(t=1);k=Math.floor(o+k);k>this.size-1&&(k=this.size-1);for(var B,F,H,G,X,A;u<m;u++){o=this.size2*u;F=u/this.size-g;X=F*F;for(F=y;F<p;F++){H=o+this.size*F;B=F/this.size-f;A=B*B;for(B=t;B<k;B++){G=B/this.size-c;G=h/(1.0E-6+G*G+A+X)-j;G>0&&(this.field[H+B]+=G)}}}};this.addPlaneX=function(c,f){var g,h,j,k,m,p=this.size,o=this.yd,u=this.zd,y=this.field,t=p*Math.sqrt(c/f);t>p&&(t=p);for(g=0;g<t;g++){h=g/p;h*=h;k=c/(1.0E-4+h)-f;if(k>0)for(h=0;h<p;h++){m=g+h*o;for(j=
0;j<p;j++)y[u*j+m]+=k}}};this.addPlaneY=function(c,f){var g,h,j,k,m,p,o=this.size,u=this.yd,y=this.zd,t=this.field,B=o*Math.sqrt(c/f);B>o&&(B=o);for(h=0;h<B;h++){g=h/o;g*=g;k=c/(1.0E-4+g)-f;if(k>0){m=h*u;for(g=0;g<o;g++){p=m+g;for(j=0;j<o;j++)t[y*j+p]+=k}}}};this.addPlaneZ=function(c,f){var g,h,j,k,m,p;size=this.size;yd=this.yd;zd=this.zd;field=this.field;dist=size*Math.sqrt(c/f);dist>size&&(dist=size);for(j=0;j<dist;j++){g=j/size;g*=g;k=c/(1.0E-4+g)-f;if(k>0){m=zd*j;for(h=0;h<size;h++){p=m+h*yd;
for(g=0;g<size;g++)field[p+g]+=k}}}};this.reset=function(){var c;for(c=0;c<this.size3;c++){this.normal_cache[c*3]=0;this.field[c]=0}};this.render=function(c){this.begin();var f,g,h,j,k,m,p,o,u,y=this.size-2;for(j=1;j<y;j++){u=this.size2*j;p=(j-this.halfsize)/this.halfsize;for(h=1;h<y;h++){o=u+this.size*h;m=(h-this.halfsize)/this.halfsize;for(g=1;g<y;g++){k=(g-this.halfsize)/this.halfsize;f=o+g;this.polygonize(k,m,p,f,this.isolation,c)}}}this.end(c)};this.generateGeometry=function(){var c=0,f=new THREE.Geometry,
g=[];this.render(function(h){var j,k,m,p,o,u,y,t;for(j=0;j<h.count;j++){y=j*3;o=y+1;t=y+2;k=h.positionArray[y];m=h.positionArray[o];p=h.positionArray[t];u=new THREE.Vector3(k,m,p);k=h.normalArray[y];m=h.normalArray[o];p=h.normalArray[t];y=new THREE.Vector3(k,m,p);y.normalize();o=new THREE.Vertex(u);f.vertices.push(o);g.push(y)}nfaces=h.count/3;for(j=0;j<nfaces;j++){y=(c+j)*3;o=y+1;t=y+2;u=g[y];k=g[o];m=g[t];y=new THREE.Face3(y,o,t,[u,k,m]);f.faces.push(y)}c+=nfaces;h.count=0});return f};this.init(b)};
THREE.MarchingCubes.prototype=new THREE.Object3D;THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);THREE.PlaneCollider=function(b,d){this.point=b;this.normal=d};THREE.SphereCollider=function(b,d){this.center=b;this.radius=d;this.radiusSq=d*d};THREE.BoxCollider=function(b,d){this.min=b;this.max=d;this.dynamic=!0};
THREE.MeshCollider=function(b,d,c,f){this.vertices=b;this.faces=d;this.normals=c;this.box=f;this.numFaces=this.faces.length};THREE.CollisionSystem=function(){this.colliders=[];this.hits=[]};THREE.Collisions=new THREE.CollisionSystem;
THREE.CollisionSystem.prototype.rayCastAll=function(b){b.direction.normalize();this.hits.length=0;var d,c,f,g,h=0;d=0;for(c=this.colliders.length;d<c;d++){g=this.colliders[d];f=this.rayCast(b,g);if(f<Number.MAX_VALUE){g.distance=f;f>h?this.hits.push(g):this.hits.unshift(g);h=f}}return this.hits};
THREE.CollisionSystem.prototype.rayCastNearest=function(b){var d=this.rayCastAll(b);if(d.length==0)return null;for(var c=0;d[c]instanceof THREE.MeshCollider;){var f=this.rayMesh(b,d[c]);if(f<Number.MAX_VALUE){d[c].distance=f;break}c++}if(c>d.length)return null;return d[c]};
THREE.CollisionSystem.prototype.rayCast=function(b,d){if(d instanceof THREE.PlaneCollider)return this.rayPlane(b,d);else if(d instanceof THREE.SphereCollider)return this.raySphere(b,d);else if(d instanceof THREE.BoxCollider)return this.rayBox(b,d);else if(d instanceof THREE.MeshCollider&&d.box)return this.rayBox(b,d.box)};
THREE.CollisionSystem.prototype.rayMesh=function(b,d){for(var c=this.makeRayLocal(b,d.mesh),f=Number.MAX_VALUE,g=0;g<d.numFaces/3;g++){var h=g*3;f=Math.min(f,this.rayTriangle(c,d.vertices[d.faces[h+0]],d.vertices[d.faces[h+1]],d.vertices[d.faces[h+2]],d.normals[d.faces[g]],f))}return f};
THREE.CollisionSystem.prototype.rayTriangle=function(b,d,c,f,g,h){var j=THREE.CollisionSystem.__v1,k=THREE.CollisionSystem.__v2;j.sub(c,d);k.sub(f,c);g.cross(j,k);k=g.dot(b.direction);if(!(k<0))return Number.MAX_VALUE;j=g.dot(d)-g.dot(b.origin);if(!(j<=0))return Number.MAX_VALUE;if(!(j>=k*h))return Number.MAX_VALUE;j/=k;k=THREE.CollisionSystem.__v3;k.copy(b.direction);k.multiplyScalar(j);k.addSelf(b.origin);if(Math.abs(g.x)>Math.abs(g.y))if(Math.abs(g.x)>Math.abs(g.z)){b=k.y-d.y;g=c.y-d.y;h=f.y-d.y;
k=k.z-d.z;c=c.z-d.z;f=f.z-d.z}else{b=k.x-d.x;g=c.x-d.x;h=f.x-d.x;k=k.y-d.y;c=c.y-d.y;f=f.y-d.y}else if(Math.abs(g.y)>Math.abs(g.z)){b=k.x-d.x;g=c.x-d.x;h=f.x-d.x;k=k.z-d.z;c=c.z-d.z;f=f.z-d.z}else{b=k.x-d.x;g=c.x-d.x;h=f.x-d.x;k=k.y-d.y;c=c.y-d.y;f=f.y-d.y}d=g*f-c*h;if(d==0)return Number.MAX_VALUE;d=1/d;f=(b*f-k*h)*d;if(!(f>=0))return Number.MAX_VALUE;d*=g*k-c*b;if(!(d>=0))return Number.MAX_VALUE;if(!(1-f-d>=0))return Number.MAX_VALUE;return j};
THREE.CollisionSystem.prototype.makeRayLocal=function(b,d){var c=new THREE.Ray(b.origin.clone(),b.direction.clone()),f=THREE.Matrix4.makeInvert(d.matrixWorld);f.multiplyVector3(c.origin);f.rotateAxis(c.direction);c.direction.normalize();return c};
THREE.CollisionSystem.prototype.rayBox=function(b,d){var c;c=d.dynamic&&d.mesh&&d.mesh.matrixWorld?this.makeRayLocal(b,d.mesh):new THREE.Ray(b.origin.clone(),b.direction.clone());var f=0,g=0,h=0,j=0,k=0,m=0,p=!0;if(c.origin.x<d.min.x){f=d.min.x-c.origin.x;f/=c.direction.x;p=!1;j=-1}else if(c.origin.x>d.max.x){f=d.max.x-c.origin.x;f/=c.direction.x;p=!1;j=1}if(c.origin.y<d.min.y){g=d.min.y-c.origin.y;g/=c.direction.y;p=!1;k=-1}else if(c.origin.y>d.max.y){g=d.max.y-c.origin.y;g/=c.direction.y;p=!1;k=
1}if(c.origin.z<d.min.z){h=d.min.z-c.origin.z;h/=c.direction.z;p=!1;m=-1}else if(c.origin.z>d.max.z){h=d.max.z-c.origin.z;h/=c.direction.z;p=!1;m=1}if(p)return-1;p=0;if(g>f){p=1;f=g}if(h>f){p=2;f=h}switch(p){case 0:k=c.origin.y+c.direction.y*f;if(k<d.min.y||k>d.max.y)return Number.MAX_VALUE;c=c.origin.z+c.direction.z*f;if(c<d.min.z||c>d.max.z)return Number.MAX_VALUE;d.normal=new THREE.Vector3(j,0,0);break;case 1:j=c.origin.x+c.direction.x*f;if(j<d.min.x||j>d.max.x)return Number.MAX_VALUE;c=c.origin.z+
c.direction.z*f;if(c<d.min.z||c>d.max.z)return Number.MAX_VALUE;d.normal=new THREE.Vector3(0,k,0);break;case 2:j=c.origin.x+c.direction.x*f;if(j<d.min.x||j>d.max.x)return Number.MAX_VALUE;k=c.origin.y+c.direction.y*f;if(k<d.min.y||k>d.max.y)return Number.MAX_VALUE;d.normal=new THREE.Vector3(0,0,m)}return f};THREE.CollisionSystem.prototype.rayPlane=function(b,d){var c=b.direction.dot(d.normal),f=d.point.dot(d.normal);if(c<0)c=(f-b.origin.dot(d.normal))/c;else return Number.MAX_VALUE;return c>0?c:Number.MAX_VALUE};
THREE.CollisionSystem.prototype.raySphere=function(b,d){var c=d.center.clone().subSelf(b.origin);if(c.lengthSq<d.radiusSq)return-1;var f=c.dot(b.direction.clone());if(f<=0)return Number.MAX_VALUE;c=d.radiusSq-(c.lengthSq()-f*f);if(c>=0)return Math.abs(f)-Math.sqrt(c);return Number.MAX_VALUE};THREE.CollisionSystem.__v1=new THREE.Vector3;THREE.CollisionSystem.__v2=new THREE.Vector3;THREE.CollisionSystem.__v3=new THREE.Vector3;THREE.CollisionUtils={};
THREE.CollisionUtils.MeshOBB=function(b){b.geometry.computeBoundingBox();var d=b.geometry.boundingBox,c=new THREE.Vector3(d.x[0],d.y[0],d.z[0]);d=new THREE.Vector3(d.x[1],d.y[1],d.z[1]);c=new THREE.BoxCollider(c,d);c.mesh=b;return c};THREE.CollisionUtils.MeshAABB=function(b){var d=THREE.CollisionUtils.MeshOBB(b);d.min.addSelf(b.position);d.max.addSelf(b.position);d.dynamic=!1;return d};
THREE.CollisionUtils.MeshColliderWBox=function(b){for(var d=b.geometry.vertices,c=d.length,f=b.geometry.faces,g=f.length,h=[],j=[],k=[],m=0;m<c;m++)h.push(new THREE.Vector3(d[m].position.x,d[m].position.y,d[m].position.z));for(m=0;m<g;m++){j.push(f[m].a,f[m].b,f[m].c);k.push(new THREE.Vector3(f[m].normal.x,f[m].normal.y,f[m].normal.z))}d=new THREE.MeshCollider(h,j,k,THREE.CollisionUtils.MeshOBB(b));d.mesh=b;return d};
