// ThreeExtras.js r32 - http://github.com/mrdoob/three.js
var THREE=THREE||{};THREE.Color=function(a){this.autoUpdate=true;this.setHex(a)};
THREE.Color.prototype={setRGB:function(a,c,f){this.r=a;this.g=c;this.b=f;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHex:function(a){this.hex=~~a&16777215;if(this.autoUpdate){this.updateRGBA();this.updateStyleString()}},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGBA:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},updateStyleString:function(){this.__styleString="rgb("+~~(this.r*255)+
","+~~(this.g*255)+","+~~(this.b*255)+")"},clone:function(){return new THREE.Color(this.hex)},toString:function(){return"THREE.Color ( r: "+this.r+", g: "+this.g+", b: "+this.b+", hex: "+this.hex+" )"}};THREE.Vector2=function(a,c){this.x=a||0;this.y=c||0};
THREE.Vector2.prototype={set:function(a,c){this.x=a;this.y=c;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},add:function(a,c){this.x=a.x+c.x;this.y=a.y+c.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},sub:function(a,c){this.x=a.x-c.x;this.y=a.y-c.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},unit:function(){this.multiplyScalar(1/this.length());return this},length:function(){return Math.sqrt(this.x*
this.x+this.y*this.y)},lengthSq:function(){return this.x*this.x+this.y*this.y},negate:function(){this.x=-this.x;this.y=-this.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},toString:function(){return"THREE.Vector2 ("+this.x+", "+this.y+")"}};THREE.Vector3=function(a,c,f){this.x=a||0;this.y=c||0;this.z=f||0};
THREE.Vector3.prototype={set:function(a,c,f){this.x=a;this.y=c;this.z=f;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},add:function(a,c){this.x=a.x+c.x;this.y=a.y+c.y;this.z=a.z+c.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,c){this.x=a.x-c.x;this.y=a.y-c.y;this.z=a.z-c.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},
cross:function(a,c){this.x=a.y*c.z-a.z*c.y;this.y=a.z*c.x-a.x*c.z;this.z=a.x*c.y-a.y*c.x;return this},crossSelf:function(a){var c=this.x,f=this.y,e=this.z;this.x=f*a.z-e*a.y;this.y=e*a.x-c*a.z;this.z=c*a.y-f*a.x;return this},multiply:function(a,c){this.x=a.x*c.x;this.y=a.y*c.y;this.z=a.z*c.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideScalar:function(a){this.x/=a;this.y/=a;this.z/=
a;return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},distanceTo:function(a){var c=this.x-a.x,f=this.y-a.y;a=this.z-a.z;return Math.sqrt(c*c+f*f+a*a)},distanceToSquared:function(a){var c=this.x-a.x,f=this.y-a.y;a=this.z-a.z;return c*c+f*f+a*a},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},negate:function(){this.x=-this.x;this.y=-this.y;this.z=-this.z;return this},normalize:function(){var a=
Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z);a>0?this.multiplyScalar(1/a):this.set(0,0,0);return this},setLength:function(a){return this.normalize().multiplyScalar(a)},isZero:function(){return Math.abs(this.x)<1.0E-4&&Math.abs(this.y)<1.0E-4&&Math.abs(this.z)<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},toString:function(){return"THREE.Vector3 ( "+this.x+", "+this.y+", "+this.z+" )"}};
THREE.Vector4=function(a,c,f,e){this.x=a||0;this.y=c||0;this.z=f||0;this.w=e||1};
THREE.Vector4.prototype={set:function(a,c,f,e){this.x=a;this.y=c;this.z=f;this.w=e;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w||1;return this},add:function(a,c){this.x=a.x+c.x;this.y=a.y+c.y;this.z=a.z+c.z;this.w=a.w+c.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,c){this.x=a.x-c.x;this.y=a.y-c.y;this.z=a.z-c.z;this.w=a.w-c.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;
return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){this.x/=a;this.y/=a;this.z/=a;this.w/=a;return this},lerpSelf:function(a,c){this.x+=(a.x-this.x)*c;this.y+=(a.y-this.y)*c;this.z+=(a.z-this.z)*c;this.w+=(a.w-this.w)*c},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},toString:function(){return"THREE.Vector4 ("+this.x+", "+this.y+", "+this.z+", "+this.w+")"}};
THREE.Ray=function(a,c){this.origin=a||new THREE.Vector3;this.direction=c||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){var c,f,e=a.objects,i=[];a=0;for(c=e.length;a<c;a++){f=e[a];if(f instanceof THREE.Mesh)i=i.concat(this.intersectObject(f))}i.sort(function(k,d){return k.distance-d.distance});return i},intersectObject:function(a){function c(L,u,j,h){h=h.clone().subSelf(u);j=j.clone().subSelf(u);var v=L.clone().subSelf(u);L=h.dot(h);u=h.dot(j);h=h.dot(v);var r=j.dot(j);j=j.dot(v);v=1/(L*r-u*u);r=(r*h-u*j)*v;L=(L*j-u*h)*v;return r>0&&L>0&&r+L<1}var f,e,i,k,d,m,l,n,w,E,
s,x=a.geometry,B=x.vertices,C=[];f=0;for(e=x.faces.length;f<e;f++){i=x.faces[f];E=this.origin.clone();s=this.direction.clone();k=a.matrix.multiplyVector3(B[i.a].position.clone());d=a.matrix.multiplyVector3(B[i.b].position.clone());m=a.matrix.multiplyVector3(B[i.c].position.clone());l=i instanceof THREE.Face4?a.matrix.multiplyVector3(B[i.d].position.clone()):null;n=a.rotationMatrix.multiplyVector3(i.normal.clone());w=s.dot(n);if(w<0){n=n.dot((new THREE.Vector3).sub(k,E))/w;E=E.addSelf(s.multiplyScalar(n));
if(i instanceof THREE.Face3){if(c(E,k,d,m)){i={distance:this.origin.distanceTo(E),point:E,face:i,object:a};C.push(i)}}else if(i instanceof THREE.Face4)if(c(E,k,d,l)||c(E,d,m,l)){i={distance:this.origin.distanceTo(E),point:E,face:i,object:a};C.push(i)}}}return C}};
THREE.Rectangle=function(){function a(){k=e-c;d=i-f}var c,f,e,i,k,d,m=true;this.getX=function(){return c};this.getY=function(){return f};this.getWidth=function(){return k};this.getHeight=function(){return d};this.getLeft=function(){return c};this.getTop=function(){return f};this.getRight=function(){return e};this.getBottom=function(){return i};this.set=function(l,n,w,E){m=false;c=l;f=n;e=w;i=E;a()};this.addPoint=function(l,n){if(m){m=false;c=l;f=n;e=l;i=n}else{c=c<l?c:l;f=f<n?f:n;e=e>l?e:l;i=i>n?
i:n}a()};this.add3Points=function(l,n,w,E,s,x){if(m){m=false;c=l<w?l<s?l:s:w<s?w:s;f=n<E?n<x?n:x:E<x?E:x;e=l>w?l>s?l:s:w>s?w:s;i=n>E?n>x?n:x:E>x?E:x}else{c=l<w?l<s?l<c?l:c:s<c?s:c:w<s?w<c?w:c:s<c?s:c;f=n<E?n<x?n<f?n:f:x<f?x:f:E<x?E<f?E:f:x<f?x:f;e=l>w?l>s?l>e?l:e:s>e?s:e:w>s?w>e?w:e:s>e?s:e;i=n>E?n>x?n>i?n:i:x>i?x:i:E>x?E>i?E:i:x>i?x:i}a()};this.addRectangle=function(l){if(m){m=false;c=l.getLeft();f=l.getTop();e=l.getRight();i=l.getBottom()}else{c=c<l.getLeft()?c:l.getLeft();f=f<l.getTop()?f:l.getTop();
e=e>l.getRight()?e:l.getRight();i=i>l.getBottom()?i:l.getBottom()}a()};this.inflate=function(l){c-=l;f-=l;e+=l;i+=l;a()};this.minSelf=function(l){c=c>l.getLeft()?c:l.getLeft();f=f>l.getTop()?f:l.getTop();e=e<l.getRight()?e:l.getRight();i=i<l.getBottom()?i:l.getBottom();a()};this.instersects=function(l){return Math.min(e,l.getRight())-Math.max(c,l.getLeft())>=0&&Math.min(i,l.getBottom())-Math.max(f,l.getTop())>=0};this.empty=function(){m=true;i=e=f=c=0;a()};this.isEmpty=function(){return m};this.toString=
function(){return"THREE.Rectangle ( left: "+c+", right: "+e+", top: "+f+", bottom: "+i+", width: "+k+", height: "+d+" )"}};THREE.Matrix3=function(){this.m=[]};THREE.Matrix3.prototype={transpose:function(){var a;a=this.m[1];this.m[1]=this.m[3];this.m[3]=a;a=this.m[2];this.m[2]=this.m[6];this.m[6]=a;a=this.m[5];this.m[5]=this.m[7];this.m[7]=a;return this}};
THREE.Matrix4=function(a,c,f,e,i,k,d,m,l,n,w,E,s,x,B,C){this.n11=a||1;this.n12=c||0;this.n13=f||0;this.n14=e||0;this.n21=i||0;this.n22=k||1;this.n23=d||0;this.n24=m||0;this.n31=l||0;this.n32=n||0;this.n33=w||1;this.n34=E||0;this.n41=s||0;this.n42=x||0;this.n43=B||0;this.n44=C||1};
THREE.Matrix4.prototype={identity:function(){this.n11=1;this.n21=this.n14=this.n13=this.n12=0;this.n22=1;this.n32=this.n31=this.n24=this.n23=0;this.n33=1;this.n43=this.n42=this.n41=this.n34=0;this.n44=1;return this},set:function(a,c,f,e,i,k,d,m,l,n,w,E,s,x,B,C){this.n11=a;this.n12=c;this.n13=f;this.n14=e;this.n21=i;this.n22=k;this.n23=d;this.n24=m;this.n31=l;this.n32=n;this.n33=w;this.n34=E;this.n41=s;this.n42=x;this.n43=B;this.n44=C;return this},copy:function(a){this.n11=a.n11;this.n12=a.n12;this.n13=
a.n13;this.n14=a.n14;this.n21=a.n21;this.n22=a.n22;this.n23=a.n23;this.n24=a.n24;this.n31=a.n31;this.n32=a.n32;this.n33=a.n33;this.n34=a.n34;this.n41=a.n41;this.n42=a.n42;this.n43=a.n43;this.n44=a.n44;return this},lookAt:function(a,c,f){var e=new THREE.Vector3,i=new THREE.Vector3,k=new THREE.Vector3;k.sub(a,c).normalize();e.cross(f,k).normalize();i.cross(k,e).normalize();this.n11=e.x;this.n12=e.y;this.n13=e.z;this.n14=-e.dot(a);this.n21=i.x;this.n22=i.y;this.n23=i.z;this.n24=-i.dot(a);this.n31=k.x;
this.n32=k.y;this.n33=k.z;this.n34=-k.dot(a);this.n43=this.n42=this.n41=0;this.n44=1;return this},multiplyVector3:function(a){var c=a.x,f=a.y,e=a.z,i=1/(this.n41*c+this.n42*f+this.n43*e+this.n44);a.x=(this.n11*c+this.n12*f+this.n13*e+this.n14)*i;a.y=(this.n21*c+this.n22*f+this.n23*e+this.n24)*i;a.z=(this.n31*c+this.n32*f+this.n33*e+this.n34)*i;return a},multiplyVector4:function(a){var c=a.x,f=a.y,e=a.z,i=a.w;a.x=this.n11*c+this.n12*f+this.n13*e+this.n14*i;a.y=this.n21*c+this.n22*f+this.n23*e+this.n24*
i;a.z=this.n31*c+this.n32*f+this.n33*e+this.n34*i;a.w=this.n41*c+this.n42*f+this.n43*e+this.n44*i;return a},crossVector:function(a){var c=new THREE.Vector4;c.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;c.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;c.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;c.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return c},multiply:function(a,c){var f=a.n11,e=a.n12,i=a.n13,k=a.n14,d=a.n21,m=a.n22,l=a.n23,n=a.n24,w=a.n31,E=a.n32,
s=a.n33,x=a.n34,B=a.n41,C=a.n42,L=a.n43,u=a.n44,j=c.n11,h=c.n12,v=c.n13,r=c.n14,A=c.n21,q=c.n22,t=c.n23,F=c.n24,y=c.n31,H=c.n32,G=c.n33,D=c.n34,M=c.n41,$=c.n42,N=c.n43,U=c.n44;this.n11=f*j+e*A+i*y+k*M;this.n12=f*h+e*q+i*H+k*$;this.n13=f*v+e*t+i*G+k*N;this.n14=f*r+e*F+i*D+k*U;this.n21=d*j+m*A+l*y+n*M;this.n22=d*h+m*q+l*H+n*$;this.n23=d*v+m*t+l*G+n*N;this.n24=d*r+m*F+l*D+n*U;this.n31=w*j+E*A+s*y+x*M;this.n32=w*h+E*q+s*H+x*$;this.n33=w*v+E*t+s*G+x*N;this.n34=w*r+E*F+s*D+x*U;this.n41=B*j+C*A+L*y+u*M;
this.n42=B*h+C*q+L*H+u*$;this.n43=B*v+C*t+L*G+u*N;this.n44=B*r+C*F+L*D+u*U;return this},multiplySelf:function(a){var c=this.n11,f=this.n12,e=this.n13,i=this.n14,k=this.n21,d=this.n22,m=this.n23,l=this.n24,n=this.n31,w=this.n32,E=this.n33,s=this.n34,x=this.n41,B=this.n42,C=this.n43,L=this.n44,u=a.n11,j=a.n21,h=a.n31,v=a.n41,r=a.n12,A=a.n22,q=a.n32,t=a.n42,F=a.n13,y=a.n23,H=a.n33,G=a.n43,D=a.n14,M=a.n24,$=a.n34;a=a.n44;this.n11=c*u+f*j+e*h+i*v;this.n12=c*r+f*A+e*q+i*t;this.n13=c*F+f*y+e*H+i*G;this.n14=
c*D+f*M+e*$+i*a;this.n21=k*u+d*j+m*h+l*v;this.n22=k*r+d*A+m*q+l*t;this.n23=k*F+d*y+m*H+l*G;this.n24=k*D+d*M+m*$+l*a;this.n31=n*u+w*j+E*h+s*v;this.n32=n*r+w*A+E*q+s*t;this.n33=n*F+w*y+E*H+s*G;this.n34=n*D+w*M+E*$+s*a;this.n41=x*u+B*j+C*h+L*v;this.n42=x*r+B*A+C*q+L*t;this.n43=x*F+B*y+C*H+L*G;this.n44=x*D+B*M+C*$+L*a;return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=
a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){return this.n14*this.n23*this.n32*this.n41-this.n13*this.n24*this.n32*this.n41-this.n14*this.n22*this.n33*this.n41+this.n12*this.n24*this.n33*this.n41+this.n13*this.n22*this.n34*this.n41-this.n12*this.n23*this.n34*this.n41-this.n14*this.n23*this.n31*this.n42+this.n13*this.n24*this.n31*this.n42+this.n14*this.n21*this.n33*this.n42-this.n11*this.n24*this.n33*this.n42-this.n13*this.n21*this.n34*this.n42+this.n11*this.n23*this.n34*
this.n42+this.n14*this.n22*this.n31*this.n43-this.n12*this.n24*this.n31*this.n43-this.n14*this.n21*this.n32*this.n43+this.n11*this.n24*this.n32*this.n43+this.n12*this.n21*this.n34*this.n43-this.n11*this.n22*this.n34*this.n43-this.n13*this.n22*this.n31*this.n44+this.n12*this.n23*this.n31*this.n44+this.n13*this.n21*this.n32*this.n44-this.n11*this.n23*this.n32*this.n44-this.n12*this.n21*this.n33*this.n44+this.n11*this.n22*this.n33*this.n44},transpose:function(){function a(c,f,e){var i=c[f];c[f]=c[e];
c[e]=i}a(this,"n21","n12");a(this,"n31","n13");a(this,"n32","n23");a(this,"n41","n14");a(this,"n42","n24");a(this,"n43","n34");return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){return[this.n11,this.n21,this.n31,this.n41,this.n12,
this.n22,this.n32,this.n42,this.n13,this.n23,this.n33,this.n43,this.n14,this.n24,this.n34,this.n44]},toString:function(){return"| "+this.n11+" "+this.n12+" "+this.n13+" "+this.n14+" |\n| "+this.n21+" "+this.n22+" "+this.n23+" "+this.n24+" |\n| "+this.n31+" "+this.n32+" "+this.n33+" "+this.n34+" |\n| "+this.n41+" "+this.n42+" "+this.n43+" "+this.n44+" |"}};THREE.Matrix4.translationMatrix=function(a,c,f){var e=new THREE.Matrix4;e.n14=a;e.n24=c;e.n34=f;return e};
THREE.Matrix4.scaleMatrix=function(a,c,f){var e=new THREE.Matrix4;e.n11=a;e.n22=c;e.n33=f;return e};THREE.Matrix4.rotationXMatrix=function(a){var c=new THREE.Matrix4;c.n22=c.n33=Math.cos(a);c.n32=Math.sin(a);c.n23=-c.n32;return c};THREE.Matrix4.rotationYMatrix=function(a){var c=new THREE.Matrix4;c.n11=c.n33=Math.cos(a);c.n13=Math.sin(a);c.n31=-c.n13;return c};THREE.Matrix4.rotationZMatrix=function(a){var c=new THREE.Matrix4;c.n11=c.n22=Math.cos(a);c.n21=Math.sin(a);c.n12=-c.n21;return c};
THREE.Matrix4.rotationAxisAngleMatrix=function(a,c){var f=new THREE.Matrix4,e=Math.cos(c),i=Math.sin(c),k=1-e,d=a.x,m=a.y,l=a.z;f.n11=k*d*d+e;f.n12=k*d*m-i*l;f.n13=k*d*l+i*m;f.n21=k*d*m+i*l;f.n22=k*m*m+e;f.n23=k*m*l-i*d;f.n31=k*d*l-i*m;f.n32=k*m*l+i*d;f.n33=k*l*l+e;return f};
THREE.Matrix4.makeInvert=function(a){var c=new THREE.Matrix4;c.n11=a.n23*a.n34*a.n42-a.n24*a.n33*a.n42+a.n24*a.n32*a.n43-a.n22*a.n34*a.n43-a.n23*a.n32*a.n44+a.n22*a.n33*a.n44;c.n12=a.n14*a.n33*a.n42-a.n13*a.n34*a.n42-a.n14*a.n32*a.n43+a.n12*a.n34*a.n43+a.n13*a.n32*a.n44-a.n12*a.n33*a.n44;c.n13=a.n13*a.n24*a.n42-a.n14*a.n23*a.n42+a.n14*a.n22*a.n43-a.n12*a.n24*a.n43-a.n13*a.n22*a.n44+a.n12*a.n23*a.n44;c.n14=a.n14*a.n23*a.n32-a.n13*a.n24*a.n32-a.n14*a.n22*a.n33+a.n12*a.n24*a.n33+a.n13*a.n22*a.n34-a.n12*
a.n23*a.n34;c.n21=a.n24*a.n33*a.n41-a.n23*a.n34*a.n41-a.n24*a.n31*a.n43+a.n21*a.n34*a.n43+a.n23*a.n31*a.n44-a.n21*a.n33*a.n44;c.n22=a.n13*a.n34*a.n41-a.n14*a.n33*a.n41+a.n14*a.n31*a.n43-a.n11*a.n34*a.n43-a.n13*a.n31*a.n44+a.n11*a.n33*a.n44;c.n23=a.n14*a.n23*a.n41-a.n13*a.n24*a.n41-a.n14*a.n21*a.n43+a.n11*a.n24*a.n43+a.n13*a.n21*a.n44-a.n11*a.n23*a.n44;c.n24=a.n13*a.n24*a.n31-a.n14*a.n23*a.n31+a.n14*a.n21*a.n33-a.n11*a.n24*a.n33-a.n13*a.n21*a.n34+a.n11*a.n23*a.n34;c.n31=a.n22*a.n34*a.n41-a.n24*a.n32*
a.n41+a.n24*a.n31*a.n42-a.n21*a.n34*a.n42-a.n22*a.n31*a.n44+a.n21*a.n32*a.n44;c.n32=a.n14*a.n32*a.n41-a.n12*a.n34*a.n41-a.n14*a.n31*a.n42+a.n11*a.n34*a.n42+a.n12*a.n31*a.n44-a.n11*a.n32*a.n44;c.n33=a.n13*a.n24*a.n41-a.n14*a.n22*a.n41+a.n14*a.n21*a.n42-a.n11*a.n24*a.n42-a.n12*a.n21*a.n44+a.n11*a.n22*a.n44;c.n34=a.n14*a.n22*a.n31-a.n12*a.n24*a.n31-a.n14*a.n21*a.n32+a.n11*a.n24*a.n32+a.n12*a.n21*a.n34-a.n11*a.n22*a.n34;c.n41=a.n23*a.n32*a.n41-a.n22*a.n33*a.n41-a.n23*a.n31*a.n42+a.n21*a.n33*a.n42+a.n22*
a.n31*a.n43-a.n21*a.n32*a.n43;c.n42=a.n12*a.n33*a.n41-a.n13*a.n32*a.n41+a.n13*a.n31*a.n42-a.n11*a.n33*a.n42-a.n12*a.n31*a.n43+a.n11*a.n32*a.n43;c.n43=a.n13*a.n22*a.n41-a.n12*a.n23*a.n41-a.n13*a.n21*a.n42+a.n11*a.n23*a.n42+a.n12*a.n21*a.n43-a.n11*a.n22*a.n43;c.n44=a.n12*a.n23*a.n31-a.n13*a.n22*a.n31+a.n13*a.n21*a.n32-a.n11*a.n23*a.n32-a.n12*a.n21*a.n33+a.n11*a.n22*a.n33;c.multiplyScalar(1/a.determinant());return c};
THREE.Matrix4.makeInvert3x3=function(a){var c=a.flatten();a=new THREE.Matrix3;var f=c[10]*c[5]-c[6]*c[9],e=-c[10]*c[1]+c[2]*c[9],i=c[6]*c[1]-c[2]*c[5],k=-c[10]*c[4]+c[6]*c[8],d=c[10]*c[0]-c[2]*c[8],m=-c[6]*c[0]+c[2]*c[4],l=c[9]*c[4]-c[5]*c[8],n=-c[9]*c[0]+c[1]*c[8],w=c[5]*c[0]-c[1]*c[4];c=c[0]*f+c[1]*k+c[2]*l;if(c==0)throw"matrix not invertible";c=1/c;a.m[0]=c*f;a.m[1]=c*e;a.m[2]=c*i;a.m[3]=c*k;a.m[4]=c*d;a.m[5]=c*m;a.m[6]=c*l;a.m[7]=c*n;a.m[8]=c*w;return a};
THREE.Matrix4.makeFrustum=function(a,c,f,e,i,k){var d,m,l;d=new THREE.Matrix4;m=2*i/(c-a);l=2*i/(e-f);a=(c+a)/(c-a);f=(e+f)/(e-f);e=-(k+i)/(k-i);i=-2*k*i/(k-i);d.n11=m;d.n12=0;d.n13=a;d.n14=0;d.n21=0;d.n22=l;d.n23=f;d.n24=0;d.n31=0;d.n32=0;d.n33=e;d.n34=i;d.n41=0;d.n42=0;d.n43=-1;d.n44=0;return d};THREE.Matrix4.makePerspective=function(a,c,f,e){var i;a=f*Math.tan(a*Math.PI/360);i=-a;return THREE.Matrix4.makeFrustum(i*c,a*c,i,a,f,e)};
THREE.Matrix4.makeOrtho=function(a,c,f,e,i,k){var d,m,l,n;d=new THREE.Matrix4;m=c-a;l=f-e;n=k-i;a=(c+a)/m;f=(f+e)/l;i=(k+i)/n;d.n11=2/m;d.n12=0;d.n13=0;d.n14=-a;d.n21=0;d.n22=2/l;d.n23=0;d.n24=-f;d.n31=0;d.n32=0;d.n33=-2/n;d.n34=-i;d.n41=0;d.n42=0;d.n43=0;d.n44=1;return d};
THREE.Vertex=function(a,c){this.position=a||new THREE.Vector3;this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.normal=c||new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.normalScreen=new THREE.Vector3;this.tangent=new THREE.Vector4;this.__visible=true};THREE.Vertex.prototype={toString:function(){return"THREE.Vertex ( position: "+this.position+", normal: "+this.normal+" )"}};
THREE.Face3=function(a,c,f,e,i){this.a=a;this.b=c;this.c=f;this.centroid=new THREE.Vector3;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.materials=i instanceof Array?i:[i]};THREE.Face3.prototype={toString:function(){return"THREE.Face3 ( "+this.a+", "+this.b+", "+this.c+" )"}};
THREE.Face4=function(a,c,f,e,i,k){this.a=a;this.b=c;this.c=f;this.d=e;this.centroid=new THREE.Vector3;this.normal=i instanceof THREE.Vector3?i:new THREE.Vector3;this.vertexNormals=i instanceof Array?i:[];this.materials=k instanceof Array?k:[k]};THREE.Face4.prototype={toString:function(){return"THREE.Face4 ( "+this.a+", "+this.b+", "+this.c+" "+this.d+" )"}};THREE.UV=function(a,c){this.u=a||0;this.v=c||0};
THREE.UV.prototype={copy:function(a){this.u=a.u;this.v=a.v},toString:function(){return"THREE.UV ("+this.u+", "+this.v+")"}};THREE.Geometry=function(){this.vertices=[];this.faces=[];this.uvs=[];this.boundingSphere=this.boundingBox=null;this.geometryChunks={};this.hasTangents=false};
THREE.Geometry.prototype={computeCentroids:function(){var a,c,f;a=0;for(c=this.faces.length;a<c;a++){f=this.faces[a];f.centroid.set(0,0,0);if(f instanceof THREE.Face3){f.centroid.addSelf(this.vertices[f.a].position);f.centroid.addSelf(this.vertices[f.b].position);f.centroid.addSelf(this.vertices[f.c].position);f.centroid.divideScalar(3)}else if(f instanceof THREE.Face4){f.centroid.addSelf(this.vertices[f.a].position);f.centroid.addSelf(this.vertices[f.b].position);f.centroid.addSelf(this.vertices[f.c].position);
f.centroid.addSelf(this.vertices[f.d].position);f.centroid.divideScalar(4)}}},computeFaceNormals:function(a){var c,f,e,i,k,d,m=new THREE.Vector3,l=new THREE.Vector3;e=0;for(i=this.vertices.length;e<i;e++){k=this.vertices[e];k.normal.set(0,0,0)}e=0;for(i=this.faces.length;e<i;e++){k=this.faces[e];if(a&&k.vertexNormals.length){m.set(0,0,0);c=0;for(f=k.normal.length;c<f;c++)m.addSelf(k.vertexNormals[c]);m.divideScalar(3)}else{c=this.vertices[k.a];f=this.vertices[k.b];d=this.vertices[k.c];m.sub(d.position,
f.position);l.sub(c.position,f.position);m.crossSelf(l)}m.isZero()||m.normalize();k.normal.copy(m)}},computeVertexNormals:function(){var a,c,f=[],e;a=0;for(c=this.vertices.length;a<c;a++)f[a]=new THREE.Vector3;a=0;for(c=this.faces.length;a<c;a++){e=this.faces[a];if(e instanceof THREE.Face3){f[e.a].addSelf(e.normal);f[e.b].addSelf(e.normal);f[e.c].addSelf(e.normal)}else if(e instanceof THREE.Face4){f[e.a].addSelf(e.normal);f[e.b].addSelf(e.normal);f[e.c].addSelf(e.normal);f[e.d].addSelf(e.normal)}}a=
0;for(c=this.vertices.length;a<c;a++)f[a].normalize();a=0;for(c=this.faces.length;a<c;a++){e=this.faces[a];if(e instanceof THREE.Face3){e.vertexNormals[0]=f[e.a].clone();e.vertexNormals[1]=f[e.b].clone();e.vertexNormals[2]=f[e.c].clone()}else if(e instanceof THREE.Face4){e.vertexNormals[0]=f[e.a].clone();e.vertexNormals[1]=f[e.b].clone();e.vertexNormals[2]=f[e.c].clone();e.vertexNormals[3]=f[e.d].clone()}}},computeTangents:function(){function a(D,M,$,N,U,X,O){k=D.vertices[M].position;d=D.vertices[$].position;
m=D.vertices[N].position;l=i[U];n=i[X];w=i[O];E=d.x-k.x;s=m.x-k.x;x=d.y-k.y;B=m.y-k.y;C=d.z-k.z;L=m.z-k.z;u=n.u-l.u;j=w.u-l.u;h=n.v-l.v;v=w.v-l.v;r=1/(u*v-j*h);t.set((v*E-h*s)*r,(v*x-h*B)*r,(v*C-h*L)*r);F.set((u*s-j*E)*r,(u*B-j*x)*r,(u*L-j*C)*r);A[M].addSelf(t);A[$].addSelf(t);A[N].addSelf(t);q[M].addSelf(F);q[$].addSelf(F);q[N].addSelf(F)}var c,f,e,i,k,d,m,l,n,w,E,s,x,B,C,L,u,j,h,v,r,A=[],q=[],t=new THREE.Vector3,F=new THREE.Vector3,y=new THREE.Vector3,H=new THREE.Vector3,G=new THREE.Vector3;c=0;
for(f=this.vertices.length;c<f;c++){A[c]=new THREE.Vector3;q[c]=new THREE.Vector3}c=0;for(f=this.faces.length;c<f;c++){e=this.faces[c];i=this.uvs[c];if(e instanceof THREE.Face3){a(this,e.a,e.b,e.c,0,1,2);this.vertices[e.a].normal.copy(e.vertexNormals[0]);this.vertices[e.b].normal.copy(e.vertexNormals[1]);this.vertices[e.c].normal.copy(e.vertexNormals[2])}else if(e instanceof THREE.Face4){a(this,e.a,e.b,e.c,0,1,2);a(this,e.a,e.b,e.d,0,1,3);this.vertices[e.a].normal.copy(e.vertexNormals[0]);this.vertices[e.b].normal.copy(e.vertexNormals[1]);
this.vertices[e.c].normal.copy(e.vertexNormals[2]);this.vertices[e.d].normal.copy(e.vertexNormals[3])}}c=0;for(f=this.vertices.length;c<f;c++){G.copy(this.vertices[c].normal);e=A[c];y.copy(e);y.subSelf(G.multiplyScalar(G.dot(e))).normalize();H.cross(this.vertices[c].normal,e);e=H.dot(q[c]);e=e<0?-1:1;this.vertices[c].tangent.set(y.x,y.y,y.z,e)}this.hasTangents=true},computeBoundingBox:function(){var a;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],
y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var c=1,f=this.vertices.length;c<f;c++){a=this.vertices[c];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<
this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=this.boundingSphere===null?0:this.boundingSphere.radius,c=0,f=this.vertices.length;c<f;c++)a=Math.max(a,this.vertices[c].position.length());this.boundingSphere={radius:a}},sortFacesByMaterial:function(){function a(w){var E=[];c=0;for(f=w.length;c<f;c++)w[c]==undefined?E.push("undefined"):E.push(w[c].toString());return E.join("_")}
var c,f,e,i,k,d,m,l,n={};e=0;for(i=this.faces.length;e<i;e++){k=this.faces[e];d=k.materials;m=a(d);if(n[m]==undefined)n[m]={hash:m,counter:0};l=n[m].hash+"_"+n[m].counter;if(this.geometryChunks[l]==undefined)this.geometryChunks[l]={faces:[],materials:d,vertices:0};k=k instanceof THREE.Face3?3:4;if(this.geometryChunks[l].vertices+k>65535){n[m].counter+=1;l=n[m].hash+"_"+n[m].counter;if(this.geometryChunks[l]==undefined)this.geometryChunks[l]={faces:[],materials:d,vertices:0}}this.geometryChunks[l].faces.push(e);
this.geometryChunks[l].vertices+=k}},toString:function(){return"THREE.Geometry ( vertices: "+this.vertices+", faces: "+this.faces+", uvs: "+this.uvs+" )"}};
THREE.Camera=function(a,c,f,e){this.fov=a;this.aspect=c;this.near=f;this.far=e;this.position=new THREE.Vector3;this.target={position:new THREE.Vector3};this.autoUpdateMatrix=true;this.projectionMatrix=null;this.matrix=new THREE.Matrix4;this.up=new THREE.Vector3(0,1,0);this.translateX=function(i){i=this.target.position.clone().subSelf(this.position).normalize().multiplyScalar(i);i.cross(i.clone(),this.up);this.position.addSelf(i);this.target.position.addSelf(i)};this.translateZ=function(i){i=this.target.position.clone().subSelf(this.position).normalize().multiplyScalar(i);
this.position.subSelf(i);this.target.position.subSelf(i)};this.updateMatrix=function(){this.matrix.lookAt(this.position,this.target.position,this.up)};this.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};this.updateProjectionMatrix()};THREE.Camera.prototype={toString:function(){return"THREE.Camera ( "+this.position+", "+this.target.position+" )"}};THREE.Light=function(a){this.color=new THREE.Color(a)};
THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=c||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;
THREE.PointLight=function(a,c){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=c||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.PointLight;
THREE.Object3D=function(){this.id=THREE.Object3DCounter.value++;this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.matrix=new THREE.Matrix4;this.translationMatrix=new THREE.Matrix4;this.rotationMatrix=new THREE.Matrix4;this.scaleMatrix=new THREE.Matrix4;this.screen=new THREE.Vector3;this.visible=this.autoUpdateMatrix=true};
THREE.Object3D.prototype={updateMatrix:function(){this.matrixPosition=THREE.Matrix4.translationMatrix(this.position.x,this.position.y,this.position.z);this.rotationMatrix=THREE.Matrix4.rotationXMatrix(this.rotation.x);this.rotationMatrix.multiplySelf(THREE.Matrix4.rotationYMatrix(this.rotation.y));this.rotationMatrix.multiplySelf(THREE.Matrix4.rotationZMatrix(this.rotation.z));this.scaleMatrix=THREE.Matrix4.scaleMatrix(this.scale.x,this.scale.y,this.scale.z);this.matrix.copy(this.matrixPosition);
this.matrix.multiplySelf(this.rotationMatrix);this.matrix.multiplySelf(this.scaleMatrix)}};THREE.Object3DCounter={value:0};THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a];this.autoUpdateMatrix=false};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,c){THREE.Object3D.call(this);this.geometry=a;this.materials=c instanceof Array?c:[c]};THREE.Line.prototype=new THREE.Object3D;
THREE.Line.prototype.constructor=THREE.Line;THREE.Mesh=function(a,c){THREE.Object3D.call(this);this.geometry=a;this.materials=c instanceof Array?c:[c];this.overdraw=this.doubleSided=this.flipSided=false;this.geometry.boundingSphere||this.geometry.computeBoundingSphere()};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.FlatShading=0;THREE.SmoothShading=1;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;
THREE.LineBasicMaterial=function(a){this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;this.linewidth=1;this.linejoin=this.linecap="round";if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending;if(a.linewidth!==undefined)this.linewidth=a.linewidth;if(a.linecap!==undefined)this.linecap=a.linecap;if(a.linejoin!==undefined)this.linejoin=a.linejoin}};
THREE.LineBasicMaterial.prototype={toString:function(){return"THREE.LineBasicMaterial (<br/>color: "+this.color+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>linewidth: "+this.linewidth+"<br/>linecap: "+this.linecap+"<br/>linejoin: "+this.linejoin+"<br/>)"}};
THREE.MeshBasicMaterial=function(a){this.id=THREE.MeshBasicMaterialCounter.value++;this.color=new THREE.Color(16777215);this.env_map=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refraction_ratio=0.98;this.fog=true;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;this.wireframe_linejoin=this.wireframe_linecap="round";if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.map!==undefined)this.map=
a.map;if(a.env_map!==undefined)this.env_map=a.env_map;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refraction_ratio!==undefined)this.refraction_ratio=a.refraction_ratio;if(a.fog!==undefined)this.fog=a.fog;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==
undefined)this.wireframe_linewidth=a.wireframe_linewidth;if(a.wireframe_linecap!==undefined)this.wireframe_linecap=a.wireframe_linecap;if(a.wireframe_linejoin!==undefined)this.wireframe_linejoin=a.wireframe_linejoin}};
THREE.MeshBasicMaterial.prototype={toString:function(){return"THREE.MeshBasicMaterial (<br/>id: "+this.id+"<br/>color: "+this.color+"<br/>map: "+this.map+"<br/>env_map: "+this.env_map+"<br/>combine: "+this.combine+"<br/>reflectivity: "+this.reflectivity+"<br/>refraction_ratio: "+this.refraction_ratio+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>wireframe: "+this.wireframe+"<br/>wireframe_linewidth: "+this.wireframe_linewidth+"<br/>wireframe_linecap: "+this.wireframe_linecap+
"<br/>wireframe_linejoin: "+this.wireframe_linejoin+"<br/>)"}};THREE.MeshBasicMaterialCounter={value:0};
THREE.MeshLambertMaterial=function(a){this.id=THREE.MeshLambertMaterialCounter.value++;this.color=new THREE.Color(16777215);this.env_map=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refraction_ratio=0.98;this.fog=true;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;this.wireframe_linejoin=this.wireframe_linecap="round";if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.map!==undefined)this.map=
a.map;if(a.env_map!==undefined)this.env_map=a.env_map;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refraction_ratio!==undefined)this.refraction_ratio=a.refraction_ratio;if(a.fog!==undefined)this.fog=a.fog;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==
undefined)this.wireframe_linewidth=a.wireframe_linewidth;if(a.wireframe_linecap!==undefined)this.wireframe_linecap=a.wireframe_linecap;if(a.wireframe_linejoin!==undefined)this.wireframe_linejoin=a.wireframe_linejoin}};
THREE.MeshLambertMaterial.prototype={toString:function(){return"THREE.MeshLambertMaterial (<br/>id: "+this.id+"<br/>color: "+this.color+"<br/>map: "+this.map+"<br/>env_map: "+this.env_map+"<br/>combine: "+this.combine+"<br/>reflectivity: "+this.reflectivity+"<br/>refraction_ratio: "+this.refraction_ratio+"<br/>opacity: "+this.opacity+"<br/>shading: "+this.shading+"<br/>blending: "+this.blending+"<br/>wireframe: "+this.wireframe+"<br/>wireframe_linewidth: "+this.wireframe_linewidth+"<br/>wireframe_linecap: "+
this.wireframe_linecap+"<br/>wireframe_linejoin: "+this.wireframe_linejoin+"<br/> )"}};THREE.MeshLambertMaterialCounter={value:0};
THREE.MeshPhongMaterial=function(a){this.id=THREE.MeshPhongMaterialCounter.value++;this.color=new THREE.Color(16777215);this.ambient=new THREE.Color(328965);this.specular=new THREE.Color(1118481);this.shininess=30;this.env_map=this.specular_map=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refraction_ratio=0.98;this.fog=true;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;this.wireframe_linejoin=
this.wireframe_linecap="round";if(a){if(a.color!==undefined)this.color=new THREE.Color(a.color);if(a.ambient!==undefined)this.ambient=new THREE.Color(a.ambient);if(a.specular!==undefined)this.specular=new THREE.Color(a.specular);if(a.shininess!==undefined)this.shininess=a.shininess;if(a.map!==undefined)this.map=a.map;if(a.specular_map!==undefined)this.specular_map=a.specular_map;if(a.env_map!==undefined)this.env_map=a.env_map;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=
a.reflectivity;if(a.refraction_ratio!==undefined)this.refraction_ratio=a.refraction_ratio;if(a.fog!==undefined)this.fog=a.fog;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==undefined)this.wireframe_linewidth=a.wireframe_linewidth;if(a.wireframe_linecap!==undefined)this.wireframe_linecap=a.wireframe_linecap;if(a.wireframe_linejoin!==
undefined)this.wireframe_linejoin=a.wireframe_linejoin}};
THREE.MeshPhongMaterial.prototype={toString:function(){return"THREE.MeshPhongMaterial (<br/>id: "+this.id+"<br/>color: "+this.color+"<br/>ambient: "+this.ambient+"<br/>specular: "+this.specular+"<br/>shininess: "+this.shininess+"<br/>map: "+this.map+"<br/>specular_map: "+this.specular_map+"<br/>env_map: "+this.env_map+"<br/>combine: "+this.combine+"<br/>reflectivity: "+this.reflectivity+"<br/>refraction_ratio: "+this.refraction_ratio+"<br/>opacity: "+this.opacity+"<br/>shading: "+this.shading+"<br/>wireframe: "+
this.wireframe+"<br/>wireframe_linewidth: "+this.wireframe_linewidth+"<br/>wireframe_linecap: "+this.wireframe_linecap+"<br/>wireframe_linejoin: "+this.wireframe_linejoin+"<br/>)"}};THREE.MeshPhongMaterialCounter={value:0};
THREE.MeshDepthMaterial=function(a){this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;this.wireframe_linejoin=this.wireframe_linecap="round";if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}};THREE.MeshDepthMaterial.prototype={toString:function(){return"THREE.MeshDepthMaterial"}};
THREE.MeshNormalMaterial=function(a){this.opacity=1;this.shading=THREE.FlatShading;this.blending=THREE.NormalBlending;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending}};THREE.MeshNormalMaterial.prototype={toString:function(){return"THREE.MeshNormalMaterial"}};THREE.MeshFaceMaterial=function(){};THREE.MeshFaceMaterial.prototype={toString:function(){return"THREE.MeshFaceMaterial"}};
THREE.MeshShaderMaterial=function(a){this.id=THREE.MeshShaderMaterialCounter.value++;this.vertex_shader=this.fragment_shader="void main() {}";this.uniforms={};this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;this.wireframe_linejoin=this.wireframe_linecap="round";if(a){if(a.fragment_shader!==undefined)this.fragment_shader=a.fragment_shader;if(a.vertex_shader!==undefined)this.vertex_shader=a.vertex_shader;if(a.uniforms!==
undefined)this.uniforms=a.uniforms;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==undefined)this.wireframe_linewidth=a.wireframe_linewidth;if(a.wireframe_linecap!==undefined)this.wireframe_linecap=a.wireframe_linecap;if(a.wireframe_linejoin!==undefined)this.wireframe_linejoin=a.wireframe_linejoin}};
THREE.MeshShaderMaterial.prototype={toString:function(){return"THREE.MeshShaderMaterial (<br/>id: "+this.id+"<br/>blending: "+this.blending+"<br/>wireframe: "+this.wireframe+"<br/>wireframe_linewidth: "+this.wireframe_linewidth+"<br/>wireframe_linecap: "+this.wireframe_linecap+"<br/>wireframe_linejoin: "+this.wireframe_linejoin+"<br/>)"}};THREE.MeshShaderMaterialCounter={value:0};
THREE.ParticleBasicMaterial=function(a){this.color=new THREE.Color(16777215);this.map=null;this.opacity=1;this.blending=THREE.NormalBlending;this.offset=new THREE.Vector2;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.map!==undefined)this.map=a.map;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}};
THREE.ParticleBasicMaterial.prototype={toString:function(){return"THREE.ParticleBasicMaterial (<br/>color: "+this.color+"<br/>map: "+this.map+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>)"}};THREE.ParticleCircleMaterial=function(a){this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}};
THREE.ParticleCircleMaterial.prototype={toString:function(){return"THREE.ParticleCircleMaterial (<br/>color: "+this.color+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>)"}};THREE.ParticleDOMMaterial=function(a){this.domElement=a};THREE.ParticleDOMMaterial.prototype={toString:function(){return"THREE.ParticleDOMMaterial ( domElement: "+this.domElement+" )"}};
THREE.Texture=function(a,c,f,e,i,k){this.image=a;this.mapping=c!==undefined?c:new THREE.UVMapping;this.wrap_s=f!==undefined?f:THREE.ClampToEdgeWrapping;this.wrap_t=e!==undefined?e:THREE.ClampToEdgeWrapping;this.mag_filter=i!==undefined?i:THREE.LinearFilter;this.min_filter=k!==undefined?k:THREE.LinearMipMapLinearFilter};
THREE.Texture.prototype={clone:function(){return new THREE.Texture(this.image,this.mapping,this.wrap_s,this.wrap_t,this.mag_filter,this.min_filter)},toString:function(){return"THREE.Texture (<br/>image: "+this.image+"<br/>wrap_s: "+this.wrap_s+"<br/>wrap_t: "+this.wrap_t+"<br/>mag_filter: "+this.mag_filter+"<br/>min_filter: "+this.min_filter+"<br/>)"}};THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;
THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;var Uniforms={clone:function(a){var c,f,e,i={};for(c in a){i[c]={};for(f in a[c]){e=a[c][f];i[c][f]=e instanceof THREE.Color||e instanceof THREE.Vector3||e instanceof THREE.Texture?e.clone():e}}return i},merge:function(a){var c,f,e,i={};for(c=0;c<a.length;c++){e=this.clone(a[c]);for(f in e)i[f]=e[f]}return i}};
THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};
THREE.Scene=function(){this.objects=[];this.lights=[];this.fog=null;this.addObject=function(a){this.objects.indexOf(a)===-1&&this.objects.push(a)};this.removeObject=function(a){a=this.objects.indexOf(a);a!==-1&&this.objects.splice(a,1)};this.addLight=function(a){this.lights.indexOf(a)===-1&&this.lights.push(a)};this.removeLight=function(a){a=this.lights.indexOf(a);a!==-1&&this.lights.splice(a,1)};this.toString=function(){return"THREE.Scene ( "+this.objects+" )"}};
THREE.Fog=function(a,c,f){this.color=new THREE.Color(a);this.near=c||1;this.far=f||1E3};THREE.FogExp2=function(a,c){this.color=new THREE.Color(a);this.density=c||2.5E-4};
THREE.Projector=function(){function a(q,t){return t.z-q.z}function c(q,t){var F=0,y=1,H=q.z+q.w,G=t.z+t.w,D=-q.z+q.w,M=-t.z+t.w;if(H>=0&&G>=0&&D>=0&&M>=0)return true;else if(H<0&&G<0||D<0&&M<0)return false;else{if(H<0)F=Math.max(F,H/(H-G));else if(G<0)y=Math.min(y,H/(H-G));if(D<0)F=Math.max(F,D/(D-M));else if(M<0)y=Math.min(y,D/(D-M));if(y<F)return false;else{q.lerpSelf(t,F);t.lerpSelf(q,1-y);return true}}}var f,e,i=[],k,d,m,l=[],n,w,E=[],s,x,B=[],C=new THREE.Vector4,L=new THREE.Vector4,u=new THREE.Matrix4,
j=new THREE.Matrix4,h=[],v=new THREE.Vector4,r=new THREE.Vector4,A;this.projectObjects=function(q,t,F){var y=[],H,G;e=0;u.multiply(t.projectionMatrix,t.matrix);h[0]=new THREE.Vector4(u.n41-u.n11,u.n42-u.n12,u.n43-u.n13,u.n44-u.n14);h[1]=new THREE.Vector4(u.n41+u.n11,u.n42+u.n12,u.n43+u.n13,u.n44+u.n14);h[2]=new THREE.Vector4(u.n41+u.n21,u.n42+u.n22,u.n43+u.n23,u.n44+u.n24);h[3]=new THREE.Vector4(u.n41-u.n21,u.n42-u.n22,u.n43-u.n23,u.n44-u.n24);h[4]=new THREE.Vector4(u.n41-u.n31,u.n42-u.n32,u.n43-
u.n33,u.n44-u.n34);h[5]=new THREE.Vector4(u.n41+u.n31,u.n42+u.n32,u.n43+u.n33,u.n44+u.n34);t=0;for(H=h.length;t<H;t++){G=h[t];G.divideScalar(Math.sqrt(G.x*G.x+G.y*G.y+G.z*G.z))}H=q.objects;q=0;for(t=H.length;q<t;q++){G=H[q];var D;if(!(D=!G.visible)){if(D=G instanceof THREE.Mesh){a:{D=void 0;for(var M=G.position,$=-G.geometry.boundingSphere.radius*Math.max(G.scale.x,Math.max(G.scale.y,G.scale.z)),N=0;N<6;N++){D=h[N].x*M.x+h[N].y*M.y+h[N].z*M.z+h[N].w;if(D<=$){D=false;break a}}D=true}D=!D}D=D}if(!D){f=
i[e]=i[e]||new THREE.RenderableObject;C.copy(G.position);u.multiplyVector3(C);f.object=G;f.z=C.z;y.push(f);e++}}F&&y.sort(a);return y};this.projectScene=function(q,t,F){var y=[],H=t.near,G=t.far,D,M,$,N,U,X,O,R,V,Q,P,Z,p,o,z,J;m=w=x=0;t.autoUpdateMatrix&&t.updateMatrix();u.multiply(t.projectionMatrix,t.matrix);X=this.projectObjects(q,t,true);q=0;for(D=X.length;q<D;q++){O=X[q].object;if(O.visible){O.autoUpdateMatrix&&O.updateMatrix();R=O.matrix;V=O.rotationMatrix;Q=O.materials;P=O.overdraw;if(O instanceof
THREE.Mesh){Z=O.geometry;p=Z.vertices;M=0;for($=p.length;M<$;M++){o=p[M];o.positionWorld.copy(o.position);R.multiplyVector3(o.positionWorld);N=o.positionScreen;N.copy(o.positionWorld);u.multiplyVector4(N);N.x/=N.w;N.y/=N.w;o.__visible=N.z>H&&N.z<G}Z=Z.faces;M=0;for($=Z.length;M<$;M++){o=Z[M];if(o instanceof THREE.Face3){N=p[o.a];U=p[o.b];z=p[o.c];if(N.__visible&&U.__visible&&z.__visible)if(O.doubleSided||O.flipSided!=(z.positionScreen.x-N.positionScreen.x)*(U.positionScreen.y-N.positionScreen.y)-
(z.positionScreen.y-N.positionScreen.y)*(U.positionScreen.x-N.positionScreen.x)<0){k=l[m]=l[m]||new THREE.RenderableFace3;k.v1.positionWorld.copy(N.positionWorld);k.v2.positionWorld.copy(U.positionWorld);k.v3.positionWorld.copy(z.positionWorld);k.v1.positionScreen.copy(N.positionScreen);k.v2.positionScreen.copy(U.positionScreen);k.v3.positionScreen.copy(z.positionScreen);k.normalWorld.copy(o.normal);V.multiplyVector3(k.normalWorld);k.centroidWorld.copy(o.centroid);R.multiplyVector3(k.centroidWorld);
k.centroidScreen.copy(k.centroidWorld);u.multiplyVector3(k.centroidScreen);z=o.vertexNormals;A=k.vertexNormalsWorld;N=0;for(U=z.length;N<U;N++){J=A[N]=A[N]||new THREE.Vector3;J.copy(z[N]);V.multiplyVector3(J)}k.z=k.centroidScreen.z;k.meshMaterials=Q;k.faceMaterials=o.materials;k.overdraw=P;if(O.geometry.uvs[M]){k.uvs[0]=O.geometry.uvs[M][0];k.uvs[1]=O.geometry.uvs[M][1];k.uvs[2]=O.geometry.uvs[M][2]}y.push(k);m++}}else if(o instanceof THREE.Face4){N=p[o.a];U=p[o.b];z=p[o.c];J=p[o.d];if(N.__visible&&
U.__visible&&z.__visible&&J.__visible)if(O.doubleSided||O.flipSided!=((J.positionScreen.x-N.positionScreen.x)*(U.positionScreen.y-N.positionScreen.y)-(J.positionScreen.y-N.positionScreen.y)*(U.positionScreen.x-N.positionScreen.x)<0||(U.positionScreen.x-z.positionScreen.x)*(J.positionScreen.y-z.positionScreen.y)-(U.positionScreen.y-z.positionScreen.y)*(J.positionScreen.x-z.positionScreen.x)<0)){k=l[m]=l[m]||new THREE.RenderableFace3;k.v1.positionWorld.copy(N.positionWorld);k.v2.positionWorld.copy(U.positionWorld);
k.v3.positionWorld.copy(J.positionWorld);k.v1.positionScreen.copy(N.positionScreen);k.v2.positionScreen.copy(U.positionScreen);k.v3.positionScreen.copy(J.positionScreen);k.normalWorld.copy(o.normal);V.multiplyVector3(k.normalWorld);k.centroidWorld.copy(o.centroid);R.multiplyVector3(k.centroidWorld);k.centroidScreen.copy(k.centroidWorld);u.multiplyVector3(k.centroidScreen);k.z=k.centroidScreen.z;k.meshMaterials=Q;k.faceMaterials=o.materials;k.overdraw=P;if(O.geometry.uvs[M]){k.uvs[0]=O.geometry.uvs[M][0];
k.uvs[1]=O.geometry.uvs[M][1];k.uvs[2]=O.geometry.uvs[M][3]}y.push(k);m++;d=l[m]=l[m]||new THREE.RenderableFace3;d.v1.positionWorld.copy(U.positionWorld);d.v2.positionWorld.copy(z.positionWorld);d.v3.positionWorld.copy(J.positionWorld);d.v1.positionScreen.copy(U.positionScreen);d.v2.positionScreen.copy(z.positionScreen);d.v3.positionScreen.copy(J.positionScreen);d.normalWorld.copy(k.normalWorld);d.centroidWorld.copy(k.centroidWorld);d.centroidScreen.copy(k.centroidScreen);d.z=d.centroidScreen.z;d.meshMaterials=
Q;d.faceMaterials=o.materials;d.overdraw=P;if(O.geometry.uvs[M]){d.uvs[0]=O.geometry.uvs[M][1];d.uvs[1]=O.geometry.uvs[M][2];d.uvs[2]=O.geometry.uvs[M][3]}y.push(d);m++}}}}else if(O instanceof THREE.Line){j.multiply(u,R);p=O.geometry.vertices;o=p[0];o.positionScreen.copy(o.position);j.multiplyVector4(o.positionScreen);M=1;for($=p.length;M<$;M++){N=p[M];N.positionScreen.copy(N.position);j.multiplyVector4(N.positionScreen);U=p[M-1];v.copy(N.positionScreen);r.copy(U.positionScreen);if(c(v,r)){v.multiplyScalar(1/
v.w);r.multiplyScalar(1/r.w);n=E[w]=E[w]||new THREE.RenderableLine;n.v1.positionScreen.copy(v);n.v2.positionScreen.copy(r);n.z=Math.max(v.z,r.z);n.materials=O.materials;y.push(n);w++}}}else if(O instanceof THREE.Particle){L.set(O.position.x,O.position.y,O.position.z,1);u.multiplyVector4(L);L.z/=L.w;if(L.z>0&&L.z<1){s=B[x]=B[x]||new THREE.RenderableParticle;s.x=L.x/L.w;s.y=L.y/L.w;s.z=L.z;s.rotation=O.rotation.z;s.scale.x=O.scale.x*Math.abs(s.x-(L.x+t.projectionMatrix.n11)/(L.w+t.projectionMatrix.n14));
s.scale.y=O.scale.y*Math.abs(s.y-(L.y+t.projectionMatrix.n22)/(L.w+t.projectionMatrix.n24));s.materials=O.materials;y.push(s);x++}}}}F&&y.sort(a);return y};this.unprojectVector=function(q,t){var F=new THREE.Matrix4;F.multiply(THREE.Matrix4.makeInvert(t.matrix),THREE.Matrix4.makeInvert(t.projectionMatrix));F.multiplyVector3(q);return q}};
THREE.DOMRenderer=function(){THREE.Renderer.call(this);var a=null,c=new THREE.Projector,f,e,i,k;this.domElement=document.createElement("div");this.setSize=function(d,m){f=d;e=m;i=f/2;k=e/2};this.render=function(d,m){var l,n,w,E,s,x,B,C;a=c.projectScene(d,m);l=0;for(n=a.length;l<n;l++){s=a[l];if(s instanceof THREE.RenderableParticle){B=s.x*i+i;C=s.y*k+k;w=0;for(E=s.material.length;w<E;w++){x=s.material[w];if(x instanceof THREE.ParticleDOMMaterial){x=x.domElement;x.style.left=B+"px";x.style.top=C+"px"}}}}}};
THREE.CanvasRenderer=function(){function a(fa){if(s!=fa)n.globalAlpha=s=fa}function c(fa){if(x!=fa){switch(fa){case THREE.NormalBlending:n.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:n.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:n.globalCompositeOperation="darker"}x=fa}}var f=null,e=new THREE.Projector,i=document.createElement("canvas"),k,d,m,l,n=i.getContext("2d"),w=null,E=null,s=1,x=0,B=null,C=null,L=1,u,j,h,v,r,A,q,t,F,y=new THREE.Color,
H=new THREE.Color,G=new THREE.Color,D=new THREE.Color,M=new THREE.Color,$,N,U,X,O,R,V,Q,P,Z=new THREE.Rectangle,p=new THREE.Rectangle,o=new THREE.Rectangle,z=false,J=new THREE.Color,W=new THREE.Color,da=new THREE.Color,ha=new THREE.Color,za=Math.PI*2,ba=new THREE.Vector3,ta,ua,Fa,ja,va,Aa,ra=16;ta=document.createElement("canvas");ta.width=ta.height=2;ua=ta.getContext("2d");ua.fillStyle="rgba(0,0,0,1)";ua.fillRect(0,0,2,2);Fa=ua.getImageData(0,0,2,2);ja=Fa.data;va=document.createElement("canvas");
va.width=va.height=ra;Aa=va.getContext("2d");Aa.translate(-ra/2,-ra/2);Aa.scale(ra,ra);ra--;this.domElement=i;this.sortElements=this.sortObjects=this.autoClear=true;this.setSize=function(fa,pa){k=fa;d=pa;m=k/2;l=d/2;i.width=k;i.height=d;Z.set(-m,-l,m,l)};this.setClearColor=function(fa,pa){w=fa!==null?new THREE.Color(fa):null;E=pa;p.set(-m,-l,m,l);n.setTransform(1,0,0,-1,m,l);this.clear()};this.clear=function(){if(!p.isEmpty()){p.inflate(1);p.minSelf(Z);if(w!==null){c(THREE.NormalBlending);a(1);n.fillStyle=
"rgba("+Math.floor(w.r*255)+","+Math.floor(w.g*255)+","+Math.floor(w.b*255)+","+E+")";n.fillRect(p.getX(),p.getY(),p.getWidth(),p.getHeight())}else n.clearRect(p.getX(),p.getY(),p.getWidth(),p.getHeight());p.empty()}};this.render=function(fa,pa){function Oa(I){var Y,T,K,S=I.lights;W.setRGB(0,0,0);da.setRGB(0,0,0);ha.setRGB(0,0,0);I=0;for(Y=S.length;I<Y;I++){T=S[I];K=T.color;if(T instanceof THREE.AmbientLight){W.r+=K.r;W.g+=K.g;W.b+=K.b}else if(T instanceof THREE.DirectionalLight){da.r+=K.r;da.g+=
K.g;da.b+=K.b}else if(T instanceof THREE.PointLight){ha.r+=K.r;ha.g+=K.g;ha.b+=K.b}}}function Ba(I,Y,T,K){var S,aa,ea,ga,ia=I.lights;I=0;for(S=ia.length;I<S;I++){aa=ia[I];ea=aa.color;ga=aa.intensity;if(aa instanceof THREE.DirectionalLight){aa=T.dot(aa.position)*ga;if(aa>0){K.r+=ea.r*aa;K.g+=ea.g*aa;K.b+=ea.b*aa}}else if(aa instanceof THREE.PointLight){ba.sub(aa.position,Y);ba.normalize();aa=T.dot(ba)*ga;if(aa>0){K.r+=ea.r*aa;K.g+=ea.g*aa;K.b+=ea.b*aa}}}}function Pa(I,Y,T){if(T.opacity!=0){a(T.opacity);
c(T.blending);var K,S,aa,ea,ga,ia;if(T instanceof THREE.ParticleBasicMaterial){if(T.map){ea=T.map;ga=ea.width>>1;ia=ea.height>>1;S=Y.scale.x*m;aa=Y.scale.y*l;T=S*ga;K=aa*ia;o.set(I.x-T,I.y-K,I.x+T,I.y+K);if(Z.instersects(o)){n.save();n.translate(I.x,I.y);n.rotate(-Y.rotation);n.scale(S,-aa);n.translate(-ga,-ia);n.drawImage(ea,0,0);n.restore()}}}else if(T instanceof THREE.ParticleCircleMaterial){if(z){J.r=W.r+da.r+ha.r;J.g=W.g+da.g+ha.g;J.b=W.b+da.b+ha.b;y.r=T.color.r*J.r;y.g=T.color.g*J.g;y.b=T.color.b*
J.b;y.updateStyleString()}else y.__styleString=T.color.__styleString;T=Y.scale.x*m;K=Y.scale.y*l;o.set(I.x-T,I.y-K,I.x+T,I.y+K);if(Z.instersects(o)){S=y.__styleString;if(C!=S)n.fillStyle=C=S;n.save();n.translate(I.x,I.y);n.rotate(-Y.rotation);n.scale(T,K);n.beginPath();n.arc(0,0,1,0,za,true);n.closePath();n.fill();n.restore()}}}}function Qa(I,Y,T,K){if(K.opacity!=0){a(K.opacity);c(K.blending);n.beginPath();n.moveTo(I.positionScreen.x,I.positionScreen.y);n.lineTo(Y.positionScreen.x,Y.positionScreen.y);
n.closePath();if(K instanceof THREE.LineBasicMaterial){y.__styleString=K.color.__styleString;I=K.linewidth;if(L!=I)n.lineWidth=L=I;I=y.__styleString;if(B!=I)n.strokeStyle=B=I;n.stroke();o.inflate(K.linewidth*2)}}}function Ka(I,Y,T,K,S,aa){if(S.opacity!=0){a(S.opacity);c(S.blending);v=I.positionScreen.x;r=I.positionScreen.y;A=Y.positionScreen.x;q=Y.positionScreen.y;t=T.positionScreen.x;F=T.positionScreen.y;n.beginPath();n.moveTo(v,r);n.lineTo(A,q);n.lineTo(t,F);n.lineTo(v,r);n.closePath();if(S instanceof
THREE.MeshBasicMaterial)if(S.map)S.map.image.loaded&&S.map.mapping instanceof THREE.UVMapping&&wa(v,r,A,q,t,F,S.map.image,K.uvs[0].u,K.uvs[0].v,K.uvs[1].u,K.uvs[1].v,K.uvs[2].u,K.uvs[2].v);else if(S.env_map){if(S.env_map.image.loaded)if(S.env_map.mapping instanceof THREE.SphericalReflectionMapping){I=pa.matrix;ba.copy(K.vertexNormalsWorld[0]);X=(ba.x*I.n11+ba.y*I.n12+ba.z*I.n13)*0.5+0.5;O=-(ba.x*I.n21+ba.y*I.n22+ba.z*I.n23)*0.5+0.5;ba.copy(K.vertexNormalsWorld[1]);R=(ba.x*I.n11+ba.y*I.n12+ba.z*I.n13)*
0.5+0.5;V=-(ba.x*I.n21+ba.y*I.n22+ba.z*I.n23)*0.5+0.5;ba.copy(K.vertexNormalsWorld[2]);Q=(ba.x*I.n11+ba.y*I.n12+ba.z*I.n13)*0.5+0.5;P=-(ba.x*I.n21+ba.y*I.n22+ba.z*I.n23)*0.5+0.5;wa(v,r,A,q,t,F,S.env_map.image,X,O,R,V,Q,P)}}else S.wireframe?Ca(S.color.__styleString,S.wireframe_linewidth):Da(S.color.__styleString);else if(S instanceof THREE.MeshLambertMaterial){if(S.map&&!S.wireframe){S.map.mapping instanceof THREE.UVMapping&&wa(v,r,A,q,t,F,S.map.image,K.uvs[0].u,K.uvs[0].v,K.uvs[1].u,K.uvs[1].v,K.uvs[2].u,
K.uvs[2].v);c(THREE.SubtractiveBlending)}if(z)if(!S.wireframe&&S.shading==THREE.SmoothShading&&K.vertexNormalsWorld.length==3){H.r=G.r=D.r=W.r;H.g=G.g=D.g=W.g;H.b=G.b=D.b=W.b;Ba(aa,K.v1.positionWorld,K.vertexNormalsWorld[0],H);Ba(aa,K.v2.positionWorld,K.vertexNormalsWorld[1],G);Ba(aa,K.v3.positionWorld,K.vertexNormalsWorld[2],D);M.r=(G.r+D.r)*0.5;M.g=(G.g+D.g)*0.5;M.b=(G.b+D.b)*0.5;U=La(H,G,D,M);wa(v,r,A,q,t,F,U,0,0,1,0,0,1)}else{J.r=W.r;J.g=W.g;J.b=W.b;Ba(aa,K.centroidWorld,K.normalWorld,J);y.r=
S.color.r*J.r;y.g=S.color.g*J.g;y.b=S.color.b*J.b;y.updateStyleString();S.wireframe?Ca(y.__styleString,S.wireframe_linewidth):Da(y.__styleString)}else S.wireframe?Ca(S.color.__styleString,S.wireframe_linewidth):Da(S.color.__styleString)}else if(S instanceof THREE.MeshDepthMaterial){$=pa.near;N=pa.far;H.r=H.g=H.b=1-Ga(I.positionScreen.z,$,N);G.r=G.g=G.b=1-Ga(Y.positionScreen.z,$,N);D.r=D.g=D.b=1-Ga(T.positionScreen.z,$,N);M.r=(G.r+D.r)*0.5;M.g=(G.g+D.g)*0.5;M.b=(G.b+D.b)*0.5;U=La(H,G,D,M);wa(v,r,A,
q,t,F,U,0,0,1,0,0,1)}else if(S instanceof THREE.MeshNormalMaterial){y.r=Ha(K.normalWorld.x);y.g=Ha(K.normalWorld.y);y.b=Ha(K.normalWorld.z);y.updateStyleString();S.wireframe?Ca(y.__styleString,S.wireframe_linewidth):Da(y.__styleString)}}}function Ca(I,Y){if(B!=I)n.strokeStyle=B=I;if(L!=Y)n.lineWidth=L=Y;n.stroke();o.inflate(Y*2)}function Da(I){if(C!=I)n.fillStyle=C=I;n.fill()}function wa(I,Y,T,K,S,aa,ea,ga,ia,ma,ka,na,xa){var qa,oa;qa=ea.width-1;oa=ea.height-1;ga*=qa;ia*=oa;ma*=qa;ka*=oa;na*=qa;xa*=
oa;T-=I;K-=Y;S-=I;aa-=Y;ma-=ga;ka-=ia;na-=ga;xa-=ia;oa=1/(ma*xa-na*ka);qa=(xa*T-ka*S)*oa;ka=(xa*K-ka*aa)*oa;T=(ma*S-na*T)*oa;K=(ma*aa-na*K)*oa;I=I-qa*ga-T*ia;Y=Y-ka*ga-K*ia;n.save();n.transform(qa,ka,T,K,I,Y);n.clip();n.drawImage(ea,0,0);n.restore()}function La(I,Y,T,K){var S=~~(I.r*255),aa=~~(I.g*255);I=~~(I.b*255);var ea=~~(Y.r*255),ga=~~(Y.g*255);Y=~~(Y.b*255);var ia=~~(T.r*255),ma=~~(T.g*255);T=~~(T.b*255);var ka=~~(K.r*255),na=~~(K.g*255);K=~~(K.b*255);ja[0]=S<0?0:S>255?255:S;ja[1]=aa<0?0:aa>
255?255:aa;ja[2]=I<0?0:I>255?255:I;ja[4]=ea<0?0:ea>255?255:ea;ja[5]=ga<0?0:ga>255?255:ga;ja[6]=Y<0?0:Y>255?255:Y;ja[8]=ia<0?0:ia>255?255:ia;ja[9]=ma<0?0:ma>255?255:ma;ja[10]=T<0?0:T>255?255:T;ja[12]=ka<0?0:ka>255?255:ka;ja[13]=na<0?0:na>255?255:na;ja[14]=K<0?0:K>255?255:K;ua.putImageData(Fa,0,0);Aa.drawImage(ta,0,0);return va}function Ga(I,Y,T){I=(I-Y)/(T-Y);return I*I*(3-2*I)}function Ha(I){I=(I+1)*0.5;return I<0?0:I>1?1:I}function Ia(I,Y){var T=Y.x-I.x,K=Y.y-I.y,S=1/Math.sqrt(T*T+K*K);T*=S;K*=S;
Y.x+=T;Y.y+=K;I.x-=T;I.y-=K}var Ea,Ma,ca,la,sa,Ja,Na,ya;n.setTransform(1,0,0,-1,m,l);this.autoClear&&this.clear();f=e.projectScene(fa,pa,this.sortElements);(z=fa.lights.length>0)&&Oa(fa);Ea=0;for(Ma=f.length;Ea<Ma;Ea++){ca=f[Ea];o.empty();if(ca instanceof THREE.RenderableParticle){u=ca;u.x*=m;u.y*=l;la=0;for(sa=ca.materials.length;la<sa;la++)Pa(u,ca,ca.materials[la],fa)}else if(ca instanceof THREE.RenderableLine){u=ca.v1;j=ca.v2;u.positionScreen.x*=m;u.positionScreen.y*=l;j.positionScreen.x*=m;j.positionScreen.y*=
l;o.addPoint(u.positionScreen.x,u.positionScreen.y);o.addPoint(j.positionScreen.x,j.positionScreen.y);if(Z.instersects(o)){la=0;for(sa=ca.materials.length;la<sa;)Qa(u,j,ca,ca.materials[la++],fa)}}else if(ca instanceof THREE.RenderableFace3){u=ca.v1;j=ca.v2;h=ca.v3;u.positionScreen.x*=m;u.positionScreen.y*=l;j.positionScreen.x*=m;j.positionScreen.y*=l;h.positionScreen.x*=m;h.positionScreen.y*=l;if(ca.overdraw){Ia(u.positionScreen,j.positionScreen);Ia(j.positionScreen,h.positionScreen);Ia(h.positionScreen,
u.positionScreen)}o.add3Points(u.positionScreen.x,u.positionScreen.y,j.positionScreen.x,j.positionScreen.y,h.positionScreen.x,h.positionScreen.y);if(Z.instersects(o)){la=0;for(sa=ca.meshMaterials.length;la<sa;){ya=ca.meshMaterials[la++];if(ya instanceof THREE.MeshFaceMaterial){Ja=0;for(Na=ca.faceMaterials.length;Ja<Na;)(ya=ca.faceMaterials[Ja++])&&Ka(u,j,h,ca,ya,fa)}else Ka(u,j,h,ca,ya,fa)}}}p.addRectangle(o)}n.setTransform(1,0,0,1,0,0)}};
THREE.SVGRenderer=function(){function a(X,O,R){var V,Q,P,Z;V=0;for(Q=X.lights.length;V<Q;V++){P=X.lights[V];if(P instanceof THREE.DirectionalLight){Z=O.normalWorld.dot(P.position)*P.intensity;if(Z>0){R.r+=P.color.r*Z;R.g+=P.color.g*Z;R.b+=P.color.b*Z}}else if(P instanceof THREE.PointLight){F.sub(P.position,O.centroidWorld);F.normalize();Z=O.normalWorld.dot(F)*P.intensity;if(Z>0){R.r+=P.color.r*Z;R.g+=P.color.g*Z;R.b+=P.color.b*Z}}}}function c(X,O,R,V,Q,P){D=e(M++);D.setAttribute("d","M "+X.positionScreen.x+
" "+X.positionScreen.y+" L "+O.positionScreen.x+" "+O.positionScreen.y+" L "+R.positionScreen.x+","+R.positionScreen.y+"z");if(Q instanceof THREE.MeshBasicMaterial)h.__styleString=Q.color.__styleString;else if(Q instanceof THREE.MeshLambertMaterial)if(j){v.r=r.r;v.g=r.g;v.b=r.b;a(P,V,v);h.r=Q.color.r*v.r;h.g=Q.color.g*v.g;h.b=Q.color.b*v.b;h.updateStyleString()}else h.__styleString=Q.color.__styleString;else if(Q instanceof THREE.MeshDepthMaterial){t=1-Q.__2near/(Q.__farPlusNear-V.z*Q.__farMinusNear);
h.setRGB(t,t,t)}else Q instanceof THREE.MeshNormalMaterial&&h.setRGB(i(V.normalWorld.x),i(V.normalWorld.y),i(V.normalWorld.z));Q.wireframe?D.setAttribute("style","fill: none; stroke: "+h.__styleString+"; stroke-width: "+Q.wireframe_linewidth+"; stroke-opacity: "+Q.opacity+"; stroke-linecap: "+Q.wireframe_linecap+"; stroke-linejoin: "+Q.wireframe_linejoin):D.setAttribute("style","fill: "+h.__styleString+"; fill-opacity: "+Q.opacity);m.appendChild(D)}function f(X,O,R,V,Q,P,Z){D=e(M++);D.setAttribute("d",
"M "+X.positionScreen.x+" "+X.positionScreen.y+" L "+O.positionScreen.x+" "+O.positionScreen.y+" L "+R.positionScreen.x+","+R.positionScreen.y+" L "+V.positionScreen.x+","+V.positionScreen.y+"z");if(P instanceof THREE.MeshBasicMaterial)h.__styleString=P.color.__styleString;else if(P instanceof THREE.MeshLambertMaterial)if(j){v.r=r.r;v.g=r.g;v.b=r.b;a(Z,Q,v);h.r=P.color.r*v.r;h.g=P.color.g*v.g;h.b=P.color.b*v.b;h.updateStyleString()}else h.__styleString=P.color.__styleString;else if(P instanceof THREE.MeshDepthMaterial){t=
1-P.__2near/(P.__farPlusNear-Q.z*P.__farMinusNear);h.setRGB(t,t,t)}else P instanceof THREE.MeshNormalMaterial&&h.setRGB(i(Q.normalWorld.x),i(Q.normalWorld.y),i(Q.normalWorld.z));P.wireframe?D.setAttribute("style","fill: none; stroke: "+h.__styleString+"; stroke-width: "+P.wireframe_linewidth+"; stroke-opacity: "+P.opacity+"; stroke-linecap: "+P.wireframe_linecap+"; stroke-linejoin: "+P.wireframe_linejoin):D.setAttribute("style","fill: "+h.__styleString+"; fill-opacity: "+P.opacity);m.appendChild(D)}
function e(X){if(y[X]==null){y[X]=document.createElementNS("http://www.w3.org/2000/svg","path");U==0&&y[X].setAttribute("shape-rendering","crispEdges");return y[X]}return y[X]}function i(X){return X<0?Math.min((1+X)*0.5,0.5):0.5+Math.min(X*0.5,0.5)}var k=null,d=new THREE.Projector,m=document.createElementNS("http://www.w3.org/2000/svg","svg"),l,n,w,E,s,x,B,C,L=new THREE.Rectangle,u=new THREE.Rectangle,j=false,h=new THREE.Color(16777215),v=new THREE.Color(16777215),r=new THREE.Color(0),A=new THREE.Color(0),
q=new THREE.Color(0),t,F=new THREE.Vector3,y=[],H=[],G=[],D,M,$,N,U=1;this.domElement=m;this.sortElements=this.sortObjects=this.autoClear=true;this.setQuality=function(X){switch(X){case "high":U=1;break;case "low":U=0}};this.setSize=function(X,O){l=X;n=O;w=l/2;E=n/2;m.setAttribute("viewBox",-w+" "+-E+" "+l+" "+n);m.setAttribute("width",l);m.setAttribute("height",n);L.set(-w,-E,w,E)};this.clear=function(){for(;m.childNodes.length>0;)m.removeChild(m.childNodes[0])};this.render=function(X,O){var R,V,
Q,P,Z,p,o,z;this.autoClear&&this.clear();k=d.projectScene(X,O,this.sortElements);N=$=M=0;if(j=X.lights.length>0){o=X.lights;r.setRGB(0,0,0);A.setRGB(0,0,0);q.setRGB(0,0,0);R=0;for(V=o.length;R<V;R++){Q=o[R];P=Q.color;if(Q instanceof THREE.AmbientLight){r.r+=P.r;r.g+=P.g;r.b+=P.b}else if(Q instanceof THREE.DirectionalLight){A.r+=P.r;A.g+=P.g;A.b+=P.b}else if(Q instanceof THREE.PointLight){q.r+=P.r;q.g+=P.g;q.b+=P.b}}}R=0;for(V=k.length;R<V;R++){o=k[R];u.empty();if(o instanceof THREE.RenderableParticle){s=
o;s.x*=w;s.y*=-E;Q=0;for(P=o.materials.length;Q<P;Q++)if(z=o.materials[Q]){Z=s;p=o;z=z;var J=$++;if(H[J]==null){H[J]=document.createElementNS("http://www.w3.org/2000/svg","circle");U==0&&H[J].setAttribute("shape-rendering","crispEdges")}D=H[J];D.setAttribute("cx",Z.x);D.setAttribute("cy",Z.y);D.setAttribute("r",p.scale.x*w);if(z instanceof THREE.ParticleCircleMaterial){if(j){v.r=r.r+A.r+q.r;v.g=r.g+A.g+q.g;v.b=r.b+A.b+q.b;h.r=z.color.r*v.r;h.g=z.color.g*v.g;h.b=z.color.b*v.b;h.updateStyleString()}else h=
z.color;D.setAttribute("style","fill: "+h.__styleString)}m.appendChild(D)}}else if(o instanceof THREE.RenderableLine){s=o.v1;x=o.v2;s.positionScreen.x*=w;s.positionScreen.y*=-E;x.positionScreen.x*=w;x.positionScreen.y*=-E;u.addPoint(s.positionScreen.x,s.positionScreen.y);u.addPoint(x.positionScreen.x,x.positionScreen.y);if(L.instersects(u)){Q=0;for(P=o.materials.length;Q<P;)if(z=o.materials[Q++]){Z=s;p=x;z=z;J=N++;if(G[J]==null){G[J]=document.createElementNS("http://www.w3.org/2000/svg","line");U==
0&&G[J].setAttribute("shape-rendering","crispEdges")}D=G[J];D.setAttribute("x1",Z.positionScreen.x);D.setAttribute("y1",Z.positionScreen.y);D.setAttribute("x2",p.positionScreen.x);D.setAttribute("y2",p.positionScreen.y);if(z instanceof THREE.LineBasicMaterial){h.__styleString=z.color.__styleString;D.setAttribute("style","fill: none; stroke: "+h.__styleString+"; stroke-width: "+z.linewidth+"; stroke-opacity: "+z.opacity+"; stroke-linecap: "+z.linecap+"; stroke-linejoin: "+z.linejoin);m.appendChild(D)}}}}else if(o instanceof
THREE.RenderableFace3){s=o.v1;x=o.v2;B=o.v3;s.positionScreen.x*=w;s.positionScreen.y*=-E;x.positionScreen.x*=w;x.positionScreen.y*=-E;B.positionScreen.x*=w;B.positionScreen.y*=-E;u.addPoint(s.positionScreen.x,s.positionScreen.y);u.addPoint(x.positionScreen.x,x.positionScreen.y);u.addPoint(B.positionScreen.x,B.positionScreen.y);if(L.instersects(u)){Q=0;for(P=o.meshMaterials.length;Q<P;){z=o.meshMaterials[Q++];if(z instanceof THREE.MeshFaceMaterial){Z=0;for(p=o.faceMaterials.length;Z<p;)(z=o.faceMaterials[Z++])&&
c(s,x,B,o,z,X)}else z&&c(s,x,B,o,z,X)}}}else if(o instanceof THREE.RenderableFace4){s=o.v1;x=o.v2;B=o.v3;C=o.v4;s.positionScreen.x*=w;s.positionScreen.y*=-E;x.positionScreen.x*=w;x.positionScreen.y*=-E;B.positionScreen.x*=w;B.positionScreen.y*=-E;C.positionScreen.x*=w;C.positionScreen.y*=-E;u.addPoint(s.positionScreen.x,s.positionScreen.y);u.addPoint(x.positionScreen.x,x.positionScreen.y);u.addPoint(B.positionScreen.x,B.positionScreen.y);u.addPoint(C.positionScreen.x,C.positionScreen.y);if(L.instersects(u)){Q=
0;for(P=o.meshMaterials.length;Q<P;){z=o.meshMaterials[Q++];if(z instanceof THREE.MeshFaceMaterial){Z=0;for(p=o.faceMaterials.length;Z<p;)(z=o.faceMaterials[Z++])&&f(s,x,B,C,o,z,X)}else z&&f(s,x,B,C,o,z,X)}}}}}};
THREE.WebGLRenderer=function(a){function c(j,h){j.fragment_shader=h.fragment_shader;j.vertex_shader=h.vertex_shader;j.uniforms=Uniforms.clone(h.uniforms)}function f(j,h){j.uniforms.color.value.setRGB(j.color.r*j.opacity,j.color.g*j.opacity,j.color.b*j.opacity);j.uniforms.opacity.value=j.opacity;j.uniforms.map.texture=j.map;j.uniforms.env_map.texture=j.env_map;j.uniforms.reflectivity.value=j.reflectivity;j.uniforms.refraction_ratio.value=j.refraction_ratio;j.uniforms.combine.value=j.combine;j.uniforms.useRefract.value=
j.env_map&&j.env_map.mapping instanceof THREE.CubeRefractionMapping;if(h){j.uniforms.fogColor.value.setHex(h.color.hex);if(h instanceof THREE.Fog){j.uniforms.fogNear.value=h.near;j.uniforms.fogFar.value=h.far}else if(h instanceof THREE.FogExp2)j.uniforms.fogDensity.value=h.density}}function e(j,h){var v;if(j=="fragment")v=d.createShader(d.FRAGMENT_SHADER);else if(j=="vertex")v=d.createShader(d.VERTEX_SHADER);d.shaderSource(v,h);d.compileShader(v);if(!d.getShaderParameter(v,d.COMPILE_STATUS)){alert(d.getShaderInfoLog(v));
return null}return v}function i(j){switch(j){case THREE.RepeatWrapping:return d.REPEAT;case THREE.ClampToEdgeWrapping:return d.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return d.MIRRORED_REPEAT;case THREE.NearestFilter:return d.NEAREST;case THREE.NearestMipMapNearestFilter:return d.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return d.NEAREST_MIPMAP_LINEAR;case THREE.LinearFilter:return d.LINEAR;case THREE.LinearMipMapNearestFilter:return d.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return d.LINEAR_MIPMAP_LINEAR}return 0}
var k=document.createElement("canvas"),d,m=null,l=new THREE.Matrix4,n,w=new Float32Array(16),E=new Float32Array(16),s=new Float32Array(16),x=new Float32Array(9),B=new Float32Array(16),C=true,L=new THREE.Color(0),u=0;if(a){if(a.antialias!==undefined)C=a.antialias;a.clearColor!==undefined&&L.setHex(a.clearColor);if(a.clearAlpha!==undefined)u=a.clearAlpha}this.domElement=k;this.autoClear=true;(function(j,h,v){try{d=k.getContext("experimental-webgl",{antialias:j})}catch(r){}if(!d){alert("WebGL not supported");
throw"cannot create webgl context";}d.clearColor(0,0,0,1);d.clearDepth(1);d.enable(d.DEPTH_TEST);d.depthFunc(d.LEQUAL);d.frontFace(d.CCW);d.cullFace(d.BACK);d.enable(d.CULL_FACE);d.enable(d.BLEND);d.blendFunc(d.ONE,d.ONE_MINUS_SRC_ALPHA);d.clearColor(h.r,h.g,h.b,v)})(C,L,u);this.setSize=function(j,h){k.width=j;k.height=h;d.viewport(0,0,k.width,k.height)};this.setClearColor=function(j,h){var v=new THREE.Color(j);d.clearColor(v.r,v.g,v.b,h)};this.clear=function(){d.clear(d.COLOR_BUFFER_BIT|d.DEPTH_BUFFER_BIT)};
this.setupLights=function(j,h){var v,r,A,q=g=b=0,t=[],F=[],y=[],H=[];v=0;for(r=h.length;v<r;v++){A=h[v];if(A instanceof THREE.AmbientLight){q+=A.color.r;g+=A.color.g;b+=A.color.b}else if(A instanceof THREE.DirectionalLight){t.push(A.color.r*A.intensity,A.color.g*A.intensity,A.color.b*A.intensity);F.push(A.position.x,A.position.y,A.position.z)}else if(A instanceof THREE.PointLight){y.push(A.color.r*A.intensity,A.color.g*A.intensity,A.color.b*A.intensity);H.push(A.position.x,A.position.y,A.position.z)}}return{ambient:[q,
g,b],directional:{colors:t,positions:F},point:{colors:y,positions:H}}};this.createBuffers=function(j,h){var v,r,A,q,t,F,y,H,G,D,M=[],$=[],N=[],U=[],X=[],O=[],R=0,V=j.geometry.geometryChunks[h],Q;t=false;v=0;for(r=j.materials.length;v<r;v++){F=j.materials[v];if(F instanceof THREE.MeshFaceMaterial){F=0;for(Q=V.materials.length;F<Q;F++)if(V.materials[F]&&V.materials[F].shading!=undefined&&V.materials[F].shading==THREE.SmoothShading){t=true;break}}else if(F&&F.shading!=undefined&&F.shading==THREE.SmoothShading){t=
true;break}if(t)break}Q=t;v=0;for(r=V.faces.length;v<r;v++){A=V.faces[v];q=j.geometry.faces[A];t=q.vertexNormals;F=q.normal;A=j.geometry.uvs[A];if(q instanceof THREE.Face3){y=j.geometry.vertices[q.a].position;H=j.geometry.vertices[q.b].position;G=j.geometry.vertices[q.c].position;N.push(y.x,y.y,y.z,H.x,H.y,H.z,G.x,G.y,G.z);if(j.geometry.hasTangents){y=j.geometry.vertices[q.a].tangent;H=j.geometry.vertices[q.b].tangent;G=j.geometry.vertices[q.c].tangent;X.push(y.x,y.y,y.z,y.w,H.x,H.y,H.z,H.w,G.x,G.y,
G.z,G.w)}if(t.length==3&&Q)for(q=0;q<3;q++)U.push(t[q].x,t[q].y,t[q].z);else for(q=0;q<3;q++)U.push(F.x,F.y,F.z);if(A)for(q=0;q<3;q++)O.push(A[q].u,A[q].v);M.push(R,R+1,R+2);$.push(R,R+1,R,R+2,R+1,R+2);R+=3}else if(q instanceof THREE.Face4){y=j.geometry.vertices[q.a].position;H=j.geometry.vertices[q.b].position;G=j.geometry.vertices[q.c].position;D=j.geometry.vertices[q.d].position;N.push(y.x,y.y,y.z,H.x,H.y,H.z,G.x,G.y,G.z,D.x,D.y,D.z);if(j.geometry.hasTangents){y=j.geometry.vertices[q.a].tangent;
H=j.geometry.vertices[q.b].tangent;G=j.geometry.vertices[q.c].tangent;q=j.geometry.vertices[q.d].tangent;X.push(y.x,y.y,y.z,y.w,H.x,H.y,H.z,H.w,G.x,G.y,G.z,G.w,q.x,q.y,q.z,q.w)}if(t.length==4&&Q)for(q=0;q<4;q++)U.push(t[q].x,t[q].y,t[q].z);else for(q=0;q<4;q++)U.push(F.x,F.y,F.z);if(A)for(q=0;q<4;q++)O.push(A[q].u,A[q].v);M.push(R,R+1,R+2,R,R+2,R+3);$.push(R,R+1,R,R+2,R,R+3,R+1,R+2,R+2,R+3);R+=4}}if(N.length){V.__webGLVertexBuffer=d.createBuffer();d.bindBuffer(d.ARRAY_BUFFER,V.__webGLVertexBuffer);
d.bufferData(d.ARRAY_BUFFER,new Float32Array(N),d.STATIC_DRAW);V.__webGLNormalBuffer=d.createBuffer();d.bindBuffer(d.ARRAY_BUFFER,V.__webGLNormalBuffer);d.bufferData(d.ARRAY_BUFFER,new Float32Array(U),d.STATIC_DRAW);if(j.geometry.hasTangents){V.__webGLTangentBuffer=d.createBuffer();d.bindBuffer(d.ARRAY_BUFFER,V.__webGLTangentBuffer);d.bufferData(d.ARRAY_BUFFER,new Float32Array(X),d.STATIC_DRAW)}if(O.length>0){V.__webGLUVBuffer=d.createBuffer();d.bindBuffer(d.ARRAY_BUFFER,V.__webGLUVBuffer);d.bufferData(d.ARRAY_BUFFER,
new Float32Array(O),d.STATIC_DRAW)}V.__webGLFaceBuffer=d.createBuffer();d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,V.__webGLFaceBuffer);d.bufferData(d.ELEMENT_ARRAY_BUFFER,new Uint16Array(M),d.STATIC_DRAW);V.__webGLLineBuffer=d.createBuffer();d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,V.__webGLLineBuffer);d.bufferData(d.ELEMENT_ARRAY_BUFFER,new Uint16Array($),d.STATIC_DRAW);V.__webGLFaceCount=M.length;V.__webGLLineCount=$.length}};this.renderBuffer=function(j,h,v,r,A){var q,t,F,y;if(!r.program){if(r instanceof
THREE.MeshDepthMaterial){c(r,THREE.ShaderLib.depth);r.uniforms.mNear.value=j.near;r.uniforms.mFar.value=j.far}else if(r instanceof THREE.MeshNormalMaterial)c(r,THREE.ShaderLib.normal);else if(r instanceof THREE.MeshBasicMaterial){c(r,THREE.ShaderLib.basic);f(r,v)}else if(r instanceof THREE.MeshLambertMaterial){c(r,THREE.ShaderLib.lambert);f(r,v)}else if(r instanceof THREE.MeshPhongMaterial){c(r,THREE.ShaderLib.phong);f(r,v)}if(scene){var H,G,D;H=y=t=0;for(G=h.length;H<G;H++){D=h[H];D instanceof THREE.DirectionalLight&&
y++;D instanceof THREE.PointLight&&t++}if(t+y<=4){H=y;t=t}else{H=Math.ceil(4*y/(t+y));t=4-H}t={directional:H,point:t}}else t={directional:1,point:3};y={fog:v,map:r.map,env_map:r.env_map,maxDirLights:t.directional,maxPointLights:t.point};t=r.fragment_shader;H=r.vertex_shader;G=d.createProgram();D=["#ifdef GL_ES\nprecision highp float;\n#endif","#define MAX_DIR_LIGHTS "+y.maxDirLights,"#define MAX_POINT_LIGHTS "+y.maxPointLights,y.fog?"#define USE_FOG":"",y.fog instanceof THREE.FogExp2?"#define FOG_EXP2":
"",y.map?"#define USE_MAP":"",y.env_map?"#define USE_ENVMAP":"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");y=[d.getParameter(d.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0?"#define VERTEX_TEXTURES":"","#define MAX_DIR_LIGHTS "+y.maxDirLights,"#define MAX_POINT_LIGHTS "+y.maxPointLights,y.map?"#define USE_MAP":"",y.env_map?"#define USE_ENVMAP":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\n"].join("\n");
d.attachShader(G,e("fragment",D+t));d.attachShader(G,e("vertex",y+H));d.linkProgram(G);d.getProgramParameter(G,d.LINK_STATUS)||alert("Could not initialise shaders\nVALIDATE_STATUS: "+d.getProgramParameter(G,d.VALIDATE_STATUS)+", gl error ["+d.getError()+"]");G.uniforms={};G.attributes={};r.program=G;t=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition"];for(q in r.uniforms)t.push(q);q=r.program;H=0;for(G=t.length;H<G;H++){D=t[H];q.uniforms[D]=d.getUniformLocation(q,
D)}q=r.program;t=["position","normal","uv","tangent"];H=0;for(G=t.length;H<G;H++){D=t[H];q.attributes[D]=d.getAttribLocation(q,D)}}q=r.program;if(q!=m){d.useProgram(q);m=q}this.loadCamera(q,j);this.loadMatrices(q);if(r instanceof THREE.MeshPhongMaterial||r instanceof THREE.MeshLambertMaterial){j=this.setupLights(q,h);r.uniforms.enableLighting.value=j.directional.positions.length+j.point.positions.length;r.uniforms.ambientLightColor.value=j.ambient;r.uniforms.directionalLightColor.value=j.directional.colors;
r.uniforms.directionalLightDirection.value=j.directional.positions;r.uniforms.pointLightColor.value=j.point.colors;r.uniforms.pointLightPosition.value=j.point.positions}if(r instanceof THREE.MeshBasicMaterial||r instanceof THREE.MeshLambertMaterial||r instanceof THREE.MeshPhongMaterial)f(r,v);if(r instanceof THREE.MeshPhongMaterial){r.uniforms.ambient.value.setRGB(r.ambient.r,r.ambient.g,r.ambient.b);r.uniforms.specular.value.setRGB(r.specular.r,r.specular.g,r.specular.b);r.uniforms.shininess.value=
r.shininess}v=r.uniforms;for(F in v){h=v[F].type;j=v[F].value;t=q.uniforms[F];if(h=="i")d.uniform1i(t,j);else if(h=="f")d.uniform1f(t,j);else if(h=="fv")d.uniform3fv(t,j);else if(h=="v2")d.uniform2f(t,j.x,j.y);else if(h=="v3")d.uniform3f(t,j.x,j.y,j.z);else if(h=="c")d.uniform3f(t,j.r,j.g,j.b);else if(h=="t"){d.uniform1i(t,j);if(h=v[F].texture)if(h.image instanceof Array&&h.image.length==6){h=h;j=j;if(h.image.length==6){if(!h.image.__webGLTextureCube&&!h.image.__cubeMapInitialized&&h.image.loadCount==
6){h.image.__webGLTextureCube=d.createTexture();d.bindTexture(d.TEXTURE_CUBE_MAP,h.image.__webGLTextureCube);d.texParameteri(d.TEXTURE_CUBE_MAP,d.TEXTURE_WRAP_S,d.CLAMP_TO_EDGE);d.texParameteri(d.TEXTURE_CUBE_MAP,d.TEXTURE_WRAP_T,d.CLAMP_TO_EDGE);d.texParameteri(d.TEXTURE_CUBE_MAP,d.TEXTURE_MAG_FILTER,d.LINEAR);d.texParameteri(d.TEXTURE_CUBE_MAP,d.TEXTURE_MIN_FILTER,d.LINEAR_MIPMAP_LINEAR);for(t=0;t<6;++t)d.texImage2D(d.TEXTURE_CUBE_MAP_POSITIVE_X+t,0,d.RGBA,d.RGBA,d.UNSIGNED_BYTE,h.image[t]);d.generateMipmap(d.TEXTURE_CUBE_MAP);
d.bindTexture(d.TEXTURE_CUBE_MAP,null);h.image.__cubeMapInitialized=true}d.activeTexture(d.TEXTURE0+j);d.bindTexture(d.TEXTURE_CUBE_MAP,h.image.__webGLTextureCube)}}else{h=h;j=j;if(!h.__webGLTexture&&h.image.loaded){h.__webGLTexture=d.createTexture();d.bindTexture(d.TEXTURE_2D,h.__webGLTexture);d.texImage2D(d.TEXTURE_2D,0,d.RGBA,d.RGBA,d.UNSIGNED_BYTE,h.image);d.texParameteri(d.TEXTURE_2D,d.TEXTURE_WRAP_S,i(h.wrap_s));d.texParameteri(d.TEXTURE_2D,d.TEXTURE_WRAP_T,i(h.wrap_t));d.texParameteri(d.TEXTURE_2D,
d.TEXTURE_MAG_FILTER,i(h.mag_filter));d.texParameteri(d.TEXTURE_2D,d.TEXTURE_MIN_FILTER,i(h.min_filter));d.generateMipmap(d.TEXTURE_2D);d.bindTexture(d.TEXTURE_2D,null)}d.activeTexture(d.TEXTURE0+j);d.bindTexture(d.TEXTURE_2D,h.__webGLTexture)}}}F=q.attributes;d.bindBuffer(d.ARRAY_BUFFER,A.__webGLVertexBuffer);d.vertexAttribPointer(F.position,3,d.FLOAT,false,0,0);d.enableVertexAttribArray(F.position);if(F.normal>=0){d.bindBuffer(d.ARRAY_BUFFER,A.__webGLNormalBuffer);d.vertexAttribPointer(F.normal,
3,d.FLOAT,false,0,0);d.enableVertexAttribArray(F.normal)}if(F.tangent>=0){d.bindBuffer(d.ARRAY_BUFFER,A.__webGLTangentBuffer);d.vertexAttribPointer(F.tangent,4,d.FLOAT,false,0,0);d.enableVertexAttribArray(F.tangent)}if(F.uv>=0)if(A.__webGLUVBuffer){d.bindBuffer(d.ARRAY_BUFFER,A.__webGLUVBuffer);d.vertexAttribPointer(F.uv,2,d.FLOAT,false,0,0);d.enableVertexAttribArray(F.uv)}else d.disableVertexAttribArray(F.uv);if(r.wireframe){d.lineWidth(r.wireframe_linewidth);d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,
A.__webGLLineBuffer);d.drawElements(d.LINES,A.__webGLLineCount,d.UNSIGNED_SHORT,0)}else{d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,A.__webGLFaceBuffer);d.drawElements(d.TRIANGLES,A.__webGLFaceCount,d.UNSIGNED_SHORT,0)}};this.renderPass=function(j,h,v,r,A,q,t){var F,y,H,G,D;H=0;for(G=r.materials.length;H<G;H++){F=r.materials[H];if(F instanceof THREE.MeshFaceMaterial){F=0;for(y=A.materials.length;F<y;F++)if((D=A.materials[F])&&D.blending==q&&D.opacity<1==t){this.setBlending(D.blending);this.renderBuffer(j,
h,v,D,A)}}else if((D=F)&&D.blending==q&&D.opacity<1==t){this.setBlending(D.blending);this.renderBuffer(j,h,v,D,A)}}};this.render=function(j,h){var v,r,A,q,t=j.lights,F=j.fog;this.initWebGLObjects(j);this.autoClear&&this.clear();h.autoUpdateMatrix&&h.updateMatrix();w.set(h.matrix.flatten());s.set(h.projectionMatrix.flatten());v=0;for(r=j.__webGLObjects.length;v<r;v++){A=j.__webGLObjects[v];q=A.object;A=A.buffer;if(q.visible){this.setupMatrices(q,h);this.renderPass(h,t,F,q,A,THREE.NormalBlending,false)}}v=
0;for(r=j.__webGLObjects.length;v<r;v++){A=j.__webGLObjects[v];q=A.object;A=A.buffer;if(q.visible){this.setupMatrices(q,h);this.renderPass(h,t,F,q,A,THREE.AdditiveBlending,false);this.renderPass(h,t,F,q,A,THREE.SubtractiveBlending,false);this.renderPass(h,t,F,q,A,THREE.AdditiveBlending,true);this.renderPass(h,t,F,q,A,THREE.SubtractiveBlending,true);this.renderPass(h,t,F,q,A,THREE.NormalBlending,true)}}};this.initWebGLObjects=function(j){var h,v,r,A,q,t;if(!j.__webGLObjects){j.__webGLObjects=[];j.__webGLObjectsMap=
{}}h=0;for(v=j.objects.length;h<v;h++){r=j.objects[h];if(j.__webGLObjectsMap[r.id]==undefined)j.__webGLObjectsMap[r.id]={};t=j.__webGLObjectsMap[r.id];if(r instanceof THREE.Mesh)for(q in r.geometry.geometryChunks){A=r.geometry.geometryChunks[q];A.__webGLVertexBuffer||this.createBuffers(r,q);if(t[q]==undefined){A={buffer:A,object:r};j.__webGLObjects.push(A);t[q]=1}}}};this.removeObject=function(j,h){var v,r;for(v=j.__webGLObjects.length-1;v>=0;v--){r=j.__webGLObjects[v].object;h==r&&j.__webGLObjects.splice(v,
1)}};this.setupMatrices=function(j,h){j.autoUpdateMatrix&&j.updateMatrix();l.multiply(h.matrix,j.matrix);E.set(l.flatten());n=THREE.Matrix4.makeInvert3x3(l).transpose();x.set(n.m);B.set(j.matrix.flatten())};this.loadMatrices=function(j){d.uniformMatrix4fv(j.uniforms.viewMatrix,false,w);d.uniformMatrix4fv(j.uniforms.modelViewMatrix,false,E);d.uniformMatrix4fv(j.uniforms.projectionMatrix,false,s);d.uniformMatrix3fv(j.uniforms.normalMatrix,false,x);d.uniformMatrix4fv(j.uniforms.objectMatrix,false,B)};
this.loadCamera=function(j,h){d.uniform3f(j.uniforms.cameraPosition,h.position.x,h.position.y,h.position.z)};this.setBlending=function(j){switch(j){case THREE.AdditiveBlending:d.blendEquation(d.FUNC_ADD);d.blendFunc(d.ONE,d.ONE);break;case THREE.SubtractiveBlending:d.blendFunc(d.DST_COLOR,d.ZERO);break;default:d.blendEquation(d.FUNC_ADD);d.blendFunc(d.ONE,d.ONE_MINUS_SRC_ALPHA)}};this.setFaceCulling=function(j,h){if(j){!h||h=="ccw"?d.frontFace(d.CCW):d.frontFace(d.CW);if(j=="back")d.cullFace(d.BACK);
else j=="front"?d.cullFace(d.FRONT):d.cullFace(d.FRONT_AND_BACK);d.enable(d.CULL_FACE)}else d.disable(d.CULL_FACE)};this.supportsVertexTextures=function(){return d.getParameter(d.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0}};
THREE.Snippets={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, 1.0 ), fogFactor );\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube env_map;\nuniform int combine;\n#endif",
envmap_fragment:"#ifdef USE_ENVMAP\ncubeColor = textureCube( env_map, vec3( -vReflect.x, vReflect.yz ) );\nif ( combine == 1 ) {\ngl_FragColor = mix( gl_FragColor, cubeColor, reflectivity );\n} else {\ngl_FragColor = gl_FragColor * cubeColor;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refraction_ratio;\nuniform bool useRefract;\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refraction_ratio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",
map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\n#endif",map_fragment:"#ifdef USE_MAP\nmapColor = texture2D( map, vUv );\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv;\n#endif",lights_pars_vertex:"uniform bool enableLighting;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\n#ifdef PHONG\nvarying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];\n#endif\n#endif",
lights_vertex:"if ( !enableLighting ) {\nvLightWeighting = vec3( 1.0 );\n} else {\nvLightWeighting = ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nfloat directionalLightWeighting = max( dot( transformedNormal, normalize( lDirection.xyz ) ), 0.0 );\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 pointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\nfloat pointLightWeighting = max( dot( transformedNormal, pointLightVector ), 0.0 );\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting;\n#ifdef PHONG\nvPointLightVector[ i ] = pointLightVector;\n#endif\n}\n#endif\n}",
lights_pars_fragment:"#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nvarying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",lights_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 mSpecular = vec4( specular, opacity );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointDiffuse  = vec4( 0.0 );\nvec4 pointSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec3 pointVector = normalize( vPointLightVector[ i ] );\nvec3 pointHalfVector = normalize( vPointLightVector[ i ] + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, shininess );\npointDiffuse  += mColor * pointDiffuseWeight;\npointSpecular += mSpecular * pointSpecularWeight;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirDiffuse  = vec4( 0.0 );\nvec4 dirSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, shininess );\ndirDiffuse  += mColor * dirDiffuseWeight;\ndirSpecular += mSpecular * dirSpecularWeight;\n}\n#endif\nvec4 totalLight = vec4( ambient, opacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirDiffuse + dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointDiffuse + pointSpecular;\n#endif"};
THREE.UniformsLib={common:{color:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},env_map:{type:"t",value:1,texture:null},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refraction_ratio:{type:"f",value:0.98},combine:{type:"i",value:0},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{enableLighting:{type:"i",value:1},ambientLightColor:{type:"fv",
value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]}}};
THREE.ShaderLib={depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3}},fragment_shader:"uniform float mNear;\nuniform float mFar;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), 1.0 );\n}",vertex_shader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"},normal:{uniforms:{},fragment_shader:"varying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, 1.0 );\n}",
vertex_shader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}"},basic:{uniforms:THREE.UniformsLib.common,fragment_shader:["uniform vec3 color;\nuniform float opacity;",THREE.Snippets.map_pars_fragment,THREE.Snippets.envmap_pars_fragment,THREE.Snippets.fog_pars_fragment,"void main() {\nvec4 mColor = vec4( color, opacity );\nvec4 mapColor = vec4( 1.0 );\nvec4 cubeColor = vec4( 1.0 );",
THREE.Snippets.map_fragment,"gl_FragColor = mColor * mapColor;",THREE.Snippets.envmap_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertex_shader:[THREE.Snippets.map_pars_vertex,THREE.Snippets.envmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.Snippets.map_vertex,THREE.Snippets.envmap_vertex,"gl_Position = projectionMatrix * mvPosition;\n}"].join("\n")},lambert:{uniforms:Uniforms.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights]),fragment_shader:["uniform vec3 color;\nuniform float opacity;\nvarying vec3 vLightWeighting;",
THREE.Snippets.map_pars_fragment,THREE.Snippets.envmap_pars_fragment,THREE.Snippets.fog_pars_fragment,"void main() {\nvec4 mColor = vec4( color, opacity );\nvec4 mapColor = vec4( 1.0 );\nvec4 cubeColor = vec4( 1.0 );",THREE.Snippets.map_fragment,"gl_FragColor =  mColor * mapColor * vec4( vLightWeighting, 1.0 );",THREE.Snippets.envmap_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertex_shader:["varying vec3 vLightWeighting;",THREE.Snippets.map_pars_vertex,THREE.Snippets.envmap_pars_vertex,
THREE.Snippets.lights_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.Snippets.map_vertex,THREE.Snippets.envmap_vertex,"vec3 transformedNormal = normalize( normalMatrix * normal );",THREE.Snippets.lights_vertex,"gl_Position = projectionMatrix * mvPosition;\n}"].join("\n")},phong:{uniforms:Uniforms.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights,{ambient:{type:"c",value:new THREE.Color(328965)},specular:{type:"c",value:new THREE.Color(1118481)},
shininess:{type:"f",value:30}}]),fragment_shader:["uniform vec3 color;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;\nvarying vec3 vLightWeighting;",THREE.Snippets.map_pars_fragment,THREE.Snippets.envmap_pars_fragment,THREE.Snippets.fog_pars_fragment,THREE.Snippets.lights_pars_fragment,"void main() {\nvec4 mColor = vec4( color, opacity );\nvec4 mapColor = vec4( 1.0 );\nvec4 cubeColor = vec4( 1.0 );",THREE.Snippets.map_fragment,THREE.Snippets.lights_fragment,
"gl_FragColor =  mapColor * totalLight * vec4( vLightWeighting, 1.0 );",THREE.Snippets.envmap_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertex_shader:["#define PHONG\nvarying vec3 vLightWeighting;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.Snippets.map_pars_vertex,THREE.Snippets.envmap_pars_vertex,THREE.Snippets.lights_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.Snippets.map_vertex,THREE.Snippets.envmap_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = cameraPosition - mPosition.xyz;\nvec3 transformedNormal = normalize( normalMatrix * normal );\nvNormal = transformedNormal;",
THREE.Snippets.lights_vertex,"gl_Position = projectionMatrix * mvPosition;\n}"].join("\n")}};THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableFace3=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.v3=new THREE.Vertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[];this.faceMaterials=this.meshMaterials=null;this.overdraw=false;this.uvs=[null,null,null]};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.materials=null};
var GeometryUtils={merge:function(a,c){var f=c instanceof THREE.Mesh,e=a.vertices.length,i=f?c.geometry:c,k=a.vertices,d=i.vertices,m=a.faces,l=i.faces,n=a.uvs;i=i.uvs;f&&c.updateMatrix();for(var w=0,E=d.length;w<E;w++){var s=new THREE.Vertex(d[w].position.clone());f&&c.matrix.multiplyVector3(s.position);k.push(s)}w=0;for(E=l.length;w<E;w++){d=l[w];var x,B=d.vertexNormals;if(d instanceof THREE.Face3)x=new THREE.Face3(d.a+e,d.b+e,d.c+e);else if(d instanceof THREE.Face4)x=new THREE.Face4(d.a+e,d.b+
e,d.c+e,d.d+e);x.centroid.copy(d.centroid);x.normal.copy(d.normal);f=0;for(k=B.length;f<k;f++){s=B[f];x.vertexNormals.push(s.clone())}x.materials=d.materials.slice();m.push(x)}w=0;for(E=i.length;w<E;w++){e=i[w];m=[];f=0;for(k=e.length;f<k;f++)m.push(new THREE.UV(e[f].u,e[f].v));n.push(m)}}},ImageUtils={loadTexture:function(a,c){var f=new Image;f.onload=function(){this.loaded=true};f.src=a;return new THREE.Texture(f,c)},loadArray:function(a){var c,f,e=[];c=e.loadCount=0;for(f=a.length;c<f;++c){e[c]=
new Image;e[c].loaded=0;e[c].onload=function(){e.loadCount+=1;this.loaded=true};e[c].src=a[c]}return e}},SceneUtils={addMesh:function(a,c,f,e,i,k,d,m,l,n){c=new THREE.Mesh(c,n);c.scale.x=c.scale.y=c.scale.z=f;c.position.x=e;c.position.y=i;c.position.z=k;c.rotation.x=d;c.rotation.y=m;c.rotation.z=l;a.addObject(c);return c},addPanoramaCubeWebGL:function(a,c,f){var e=ShaderUtils.lib.cube;e.uniforms.tCube.texture=f;f=new THREE.MeshShaderMaterial({fragment_shader:e.fragment_shader,vertex_shader:e.vertex_shader,
uniforms:e.uniforms});c=new THREE.Mesh(new Cube(c,c,c,1,1,null,true),f);a.addObject(c);return c},addPanoramaCube:function(a,c,f){var e=[];e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(f[0])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(f[1])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(f[2])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(f[3])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(f[4])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(f[5])}));
c=new THREE.Mesh(new Cube(c,c,c,1,1,e,true),new THREE.MeshFaceMaterial);a.addObject(c);return c},addPanoramaCubePlanes:function(a,c,f){var e=c/2;c=new Plane(c,c);var i=Math.PI/2,k=Math.PI;SceneUtils.addMesh(a,c,1,0,0,-e,0,0,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(f[5])}));SceneUtils.addMesh(a,c,1,-e,0,0,0,i,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(f[0])}));SceneUtils.addMesh(a,c,1,e,0,0,0,-i,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(f[1])}));SceneUtils.addMesh(a,
c,1,0,e,0,i,0,k,new THREE.MeshBasicMaterial({map:new THREE.Texture(f[2])}));SceneUtils.addMesh(a,c,1,0,-e,0,-i,0,k,new THREE.MeshBasicMaterial({map:new THREE.Texture(f[3])}))}},ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragment_shader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",
vertex_shader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main(void) {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tNormal:{type:"t",value:2,texture:null},tAO:{type:"t",value:3,texture:null},uNormalScale:{type:"f",value:1},tDisplacement:{type:"t",value:4,texture:null},uDisplacementBias:{type:"f",value:-0.5},uDisplacementScale:{type:"f",value:2.5},uPointLightPos:{type:"v3",value:new THREE.Vector3},uPointLightColor:{type:"c",value:new THREE.Color(15658734)},uDirLightPos:{type:"v3",value:new THREE.Vector3},
uDirLightColor:{type:"c",value:new THREE.Color(15658734)},uAmbientLightColor:{type:"c",value:new THREE.Color(328965)},uDiffuseColor:{type:"c",value:new THREE.Color(15658734)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(328965)},uShininess:{type:"f",value:30}},fragment_shader:"uniform vec3 uDirLightPos;\nuniform vec3 uAmbientLightColor;\nuniform vec3 uDirLightColor;\nuniform vec3 uPointLightColor;\nuniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform bool enableDiffuse;\nuniform bool enableAO;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tAO;\nuniform float uNormalScale;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 diffuseTex = vec3( 1.0, 1.0, 1.0 );\nvec3 aoTex = vec3( 1.0, 1.0, 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse )\ndiffuseTex = texture2D( tDiffuse, vUv ).xyz;\nif( enableAO )\naoTex = texture2D( tAO, vUv ).xyz;\nmat3 tsb = mat3( vTangent, vBinormal, vNormal );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 pointDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 pointSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec3 pointVector = normalize( vPointLightVector );\nvec3 pointHalfVector = normalize( vPointLightVector + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, uShininess );\npointDiffuse  += vec4( uDiffuseColor, 1.0 ) * pointDiffuseWeight;\npointSpecular += vec4( uSpecularColor, 1.0 ) * pointSpecularWeight;\nvec4 dirDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 dirSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 lDirection = viewMatrix * vec4( uDirLightPos, 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, uShininess );\ndirDiffuse  += vec4( uDiffuseColor, 1.0 ) * dirDiffuseWeight;\ndirSpecular += vec4( uSpecularColor, 1.0 ) * dirSpecularWeight;\nvec4 totalLight = vec4( uAmbientLightColor * uAmbientColor, 1.0 );\ntotalLight += vec4( uDirLightColor, 1.0 ) * ( dirDiffuse + dirSpecular );\ntotalLight += vec4( uPointLightColor, 1.0 ) * ( pointDiffuse + pointSpecular );\ngl_FragColor = vec4( totalLight.xyz * aoTex * diffuseTex, 1.0 );\n}",
vertex_shader:"attribute vec4 tangent;\nuniform vec3 uPointLightPos;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvBinormal = normalize( vBinormal );\nvUv = uv;\nvec4 lPosition = viewMatrix * vec4( uPointLightPos, 1.0 );\nvPointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( vNormal.xyz * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif\n}"},
basic:{uniforms:{},vertex_shader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragment_shader:"void main() {\ngl_FragColor = vec4(1.0, 0.0, 0.0, 0.5);\n}"},cube:{uniforms:{tCube:{type:"t",value:1,texture:null}},vertex_shader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragment_shader:"uniform samplerCube tCube;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( - wPos.x, wPos.yz ) );\n}"}}},Cube=function(a,c,f,e,i,k,d,m){function l(C,L,u,j,h,v,r,A){var q,t,F=e||1,y=i||1,H=F+1,G=y+1,D=h/2,M=v/2;h=h/F;var $=v/y,N=n.vertices.length;if(C=="x"&&L=="y"||C=="y"&&L=="x")q="z";else if(C=="x"&&L=="z"||C=="z"&&L=="x")q="y";else if(C=="z"&&L=="y"||C=="y"&&L=="z")q="x";for(t=0;t<G;t++)for(v=0;v<
H;v++){var U=new THREE.Vector3;U[C]=(v*h-D)*u;U[L]=(t*$-M)*j;U[q]=r;n.vertices.push(new THREE.Vertex(U))}for(t=0;t<y;t++)for(v=0;v<F;v++){n.faces.push(new THREE.Face4(v+H*t+N,v+H*(t+1)+N,v+1+H*(t+1)+N,v+1+H*t+N,null,A));n.uvs.push([new THREE.UV(v/F,t/y),new THREE.UV(v/F,(t+1)/y),new THREE.UV((v+1)/F,(t+1)/y),new THREE.UV((v+1)/F,t/y)])}}THREE.Geometry.call(this);var n=this,w=a/2,E=c/2,s=f/2;d=d?-1:1;if(k!==undefined)if(k instanceof Array)this.materials=k;else{this.materials=[];for(var x=0;x<6;x++)this.materials.push([k])}else this.materials=
[];this.sides={px:true,nx:true,py:true,ny:true,pz:true,nz:true};if(m!=undefined)for(var B in m)if(this.sides[B]!=undefined)this.sides[B]=m[B];this.sides.px&&l("z","y",1*d,-1,f,c,-w,this.materials[0]);this.sides.nx&&l("z","y",-1*d,-1,f,c,w,this.materials[1]);this.sides.py&&l("x","z",1*d,1,a,f,E,this.materials[2]);this.sides.ny&&l("x","z",1*d,-1,a,f,-E,this.materials[3]);this.sides.pz&&l("x","y",1*d,-1,a,c,s,this.materials[4]);this.sides.nz&&l("x","y",-1*d,-1,a,c,-s,this.materials[5]);(function(){for(var C=
[],L=[],u=0,j=n.vertices.length;u<j;u++){for(var h=n.vertices[u],v=false,r=0,A=C.length;r<A;r++){var q=C[r];if(h.position.x==q.position.x&&h.position.y==q.position.y&&h.position.z==q.position.z){L[u]=r;v=true;break}}if(!v){L[u]=C.length;C.push(new THREE.Vertex(h.position.clone()))}}u=0;for(j=n.faces.length;u<j;u++){h=n.faces[u];h.a=L[h.a];h.b=L[h.b];h.c=L[h.c];h.d=L[h.d]}n.vertices=C})();this.computeCentroids();this.computeFaceNormals();this.sortFacesByMaterial()};Cube.prototype=new THREE.Geometry;
Cube.prototype.constructor=Cube;
var Cylinder=function(a,c,f,e,i){function k(n,w,E){d.vertices.push(new THREE.Vertex(new THREE.Vector3(n,w,E)))}THREE.Geometry.call(this);var d=this,m=Math.PI,l;for(l=0;l<a;l++)k(Math.sin(2*m*l/a)*c,Math.cos(2*m*l/a)*c,0);for(l=0;l<a;l++)k(Math.sin(2*m*l/a)*f,Math.cos(2*m*l/a)*f,e);for(l=0;l<a;l++)d.faces.push(new THREE.Face4(l,l+a,a+(l+1)%a,(l+1)%a));if(f!=0){k(0,0,-i);for(l=a;l<a+a/2;l++)d.faces.push(new THREE.Face4(2*a,(2*l-2*a)%a,(2*l-2*a+1)%a,(2*l-2*a+2)%a))}if(c!=0){k(0,0,e+i);for(l=a+a/2;l<
2*a;l++)d.faces.push(new THREE.Face4((2*l-2*a+2)%a+a,(2*l-2*a+1)%a+a,(2*l-2*a)%a+a,2*a+1))}this.computeCentroids();this.computeFaceNormals();this.sortFacesByMaterial()};Cylinder.prototype=new THREE.Geometry;Cylinder.prototype.constructor=Cylinder;
var Plane=function(a,c,f,e){THREE.Geometry.call(this);var i,k=a/2,d=c/2;f=f||1;e=e||1;var m=f+1,l=e+1;a=a/f;var n=c/e;for(i=0;i<l;i++)for(c=0;c<m;c++)this.vertices.push(new THREE.Vertex(new THREE.Vector3(c*a-k,-(i*n-d),0)));for(i=0;i<e;i++)for(c=0;c<f;c++){this.faces.push(new THREE.Face4(c+m*i,c+m*(i+1),c+1+m*(i+1),c+1+m*i));this.uvs.push([new THREE.UV(c/f,i/e),new THREE.UV(c/f,(i+1)/e),new THREE.UV((c+1)/f,(i+1)/e),new THREE.UV((c+1)/f,i/e)])}this.computeCentroids();this.computeFaceNormals();this.sortFacesByMaterial()};
Plane.prototype=new THREE.Geometry;Plane.prototype.constructor=Plane;
var Sphere=function(a,c,f){THREE.Geometry.call(this);var e,i=Math.PI,k=Math.max(3,c||8),d=Math.max(2,f||6);c=[];for(f=0;f<d+1;f++){e=f/d;var m=a*Math.cos(e*i),l=a*Math.sin(e*i),n=[],w=0;for(e=0;e<k;e++){var E=2*e/k,s=l*Math.sin(E*i);E=l*Math.cos(E*i);(f==0||f==d)&&e>0||(w=this.vertices.push(new THREE.Vertex(new THREE.Vector3(E,m,s)))-1);n.push(w)}c.push(n)}var x,B,C;i=c.length;for(f=0;f<i;f++){k=c[f].length;if(f>0)for(e=0;e<k;e++){n=e==k-1;d=c[f][n?0:e+1];m=c[f][n?k-1:e];l=c[f-1][n?k-1:e];n=c[f-1][n?
0:e+1];s=f/(i-1);x=(f-1)/(i-1);B=(e+1)/k;E=e/k;w=new THREE.UV(1-B,s);s=new THREE.UV(1-E,s);E=new THREE.UV(1-E,x);var L=new THREE.UV(1-B,x);if(f<c.length-1){x=this.vertices[d].position.clone();B=this.vertices[m].position.clone();C=this.vertices[l].position.clone();x.normalize();B.normalize();C.normalize();this.faces.push(new THREE.Face3(d,m,l,[new THREE.Vector3(x.x,x.y,x.z),new THREE.Vector3(B.x,B.y,B.z),new THREE.Vector3(C.x,C.y,C.z)]));this.uvs.push([w,s,E])}if(f>1){x=this.vertices[d].position.clone();
B=this.vertices[l].position.clone();C=this.vertices[n].position.clone();x.normalize();B.normalize();C.normalize();this.faces.push(new THREE.Face3(d,l,n,[new THREE.Vector3(x.x,x.y,x.z),new THREE.Vector3(B.x,B.y,B.z),new THREE.Vector3(C.x,C.y,C.z)]));this.uvs.push([w,E,L])}}}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.sortFacesByMaterial();this.boundingSphere={radius:a}};Sphere.prototype=new THREE.Geometry;Sphere.prototype.constructor=Sphere;
THREE.Loader=function(a){this.statusDomElement=(this.showStatus=a)?this.addStatusElement():null};
THREE.Loader.prototype={addStatusElement:function(){var a=document.createElement("div");a.style.fontSize="0.8em";a.style.textAlign="left";a.style.background="#b00";a.style.color="#fff";a.style.width="140px";a.style.padding="0.25em 0.25em 0.25em 0.5em";a.style.position="absolute";a.style.right="0px";a.style.top="0px";a.style.zIndex=1E3;a.innerHTML="Loading ...";return a},updateProgress:function(a){var c="Loaded ";c+=a.total?(100*a.loaded/a.total).toFixed(0)+"%":(a.loaded/1E3).toFixed(2)+" KB";this.statusDomElement.innerHTML=
c},loadAsciiOld:function(a,c){var f=document.createElement("script");f.type="text/javascript";f.onload=c;f.src=a;document.getElementsByTagName("head")[0].appendChild(f)},loadAscii:function(a,c,f){var e=(new Date).getTime();a=new Worker(a);a.onmessage=function(i){THREE.Loader.prototype.createModel(i.data,c,f)};a.postMessage(e)},loadBinary:function(a,c,f){var e=(new Date).getTime();a=new Worker(a);var i=this.showProgress?THREE.Loader.prototype.updateProgress:null;a.onmessage=function(k){THREE.Loader.prototype.loadAjaxBuffers(k.data.buffers,
k.data.materials,c,f,i)};a.onerror=function(k){alert("worker.onerror: "+k.message+"\n"+k.data);k.preventDefault()};a.postMessage(e)},loadAjaxBuffers:function(a,c,f,e,i){var k=new XMLHttpRequest,d=e+"/"+a,m=0;k.onreadystatechange=function(){if(k.readyState==4)k.status==200||k.status==0?THREE.Loader.prototype.createBinModel(k.responseText,f,e,c):alert("Couldn't load ["+d+"] ["+k.status+"]");else if(k.readyState==3){if(i){if(m==0)m=k.getResponseHeader("Content-Length");i({total:m,loaded:k.responseText.length})}}else if(k.readyState==
2)m=k.getResponseHeader("Content-Length")};k.open("GET",d,true);k.overrideMimeType("text/plain; charset=x-user-defined");k.setRequestHeader("Content-Type","text/plain");k.send(null)},createBinModel:function(a,c,f,e){var i=function(k){function d(p,o){var z=w(p,o),J=w(p,o+1),W=w(p,o+2),da=w(p,o+3),ha=(da<<1&255|W>>7)-127;z=(W&127)<<16|J<<8|z;if(z==0&&ha==-127)return 0;return(1-2*(da>>7))*(1+z*Math.pow(2,-23))*Math.pow(2,ha)}function m(p,o){var z=w(p,o),J=w(p,o+1),W=w(p,o+2);return(w(p,o+3)<<24)+(W<<
16)+(J<<8)+z}function l(p,o){var z=w(p,o);return(w(p,o+1)<<8)+z}function n(p,o){var z=w(p,o);return z>127?z-256:z}function w(p,o){return p.charCodeAt(o)&255}function E(p){var o,z,J;o=m(a,p);z=m(a,p+A);J=m(a,p+q);p=l(a,p+t);THREE.Loader.prototype.f3(u,o,z,J,p)}function s(p){var o,z,J,W,da,ha;o=m(a,p);z=m(a,p+A);J=m(a,p+q);W=l(a,p+t);da=m(a,p+F);ha=m(a,p+y);p=m(a,p+H);THREE.Loader.prototype.f3n(u,v,o,z,J,W,da,ha,p)}function x(p){var o,z,J,W;o=m(a,p);z=m(a,p+G);J=m(a,p+D);W=m(a,p+M);p=l(a,p+$);THREE.Loader.prototype.f4(u,
o,z,J,W,p)}function B(p){var o,z,J,W,da,ha,za,ba;o=m(a,p);z=m(a,p+G);J=m(a,p+D);W=m(a,p+M);da=l(a,p+$);ha=m(a,p+N);za=m(a,p+U);ba=m(a,p+X);p=m(a,p+O);THREE.Loader.prototype.f4n(u,v,o,z,J,W,da,ha,za,ba,p)}function C(p){var o,z;o=m(a,p);z=m(a,p+R);p=m(a,p+V);THREE.Loader.prototype.uv3(u,r[o*2],r[o*2+1],r[z*2],r[z*2+1],r[p*2],r[p*2+1])}function L(p){var o,z,J;o=m(a,p);z=m(a,p+Q);J=m(a,p+P);p=m(a,p+Z);THREE.Loader.prototype.uv4(u,r[o*2],r[o*2+1],r[z*2],r[z*2+1],r[J*2],r[J*2+1],r[p*2],r[p*2+1])}var u=
this,j=0,h,v=[],r=[],A,q,t,F,y,H,G,D,M,$,N,U,X,O,R,V,Q,P,Z;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(u,e,k);h={signature:a.substr(j,8),header_bytes:w(a,j+8),vertex_coordinate_bytes:w(a,j+9),normal_coordinate_bytes:w(a,j+10),uv_coordinate_bytes:w(a,j+11),vertex_index_bytes:w(a,j+12),normal_index_bytes:w(a,j+13),uv_index_bytes:w(a,j+14),material_index_bytes:w(a,j+15),nvertices:m(a,j+16),nnormals:m(a,j+16+4),nuvs:m(a,j+16+8),ntri_flat:m(a,j+16+12),ntri_smooth:m(a,j+16+16),ntri_flat_uv:m(a,
j+16+20),ntri_smooth_uv:m(a,j+16+24),nquad_flat:m(a,j+16+28),nquad_smooth:m(a,j+16+32),nquad_flat_uv:m(a,j+16+36),nquad_smooth_uv:m(a,j+16+40)};j+=h.header_bytes;A=h.vertex_index_bytes;q=h.vertex_index_bytes*2;t=h.vertex_index_bytes*3;F=h.vertex_index_bytes*3+h.material_index_bytes;y=h.vertex_index_bytes*3+h.material_index_bytes+h.normal_index_bytes;H=h.vertex_index_bytes*3+h.material_index_bytes+h.normal_index_bytes*2;G=h.vertex_index_bytes;D=h.vertex_index_bytes*2;M=h.vertex_index_bytes*3;$=h.vertex_index_bytes*
4;N=h.vertex_index_bytes*4+h.material_index_bytes;U=h.vertex_index_bytes*4+h.material_index_bytes+h.normal_index_bytes;X=h.vertex_index_bytes*4+h.material_index_bytes+h.normal_index_bytes*2;O=h.vertex_index_bytes*4+h.material_index_bytes+h.normal_index_bytes*3;R=h.uv_index_bytes;V=h.uv_index_bytes*2;Q=h.uv_index_bytes;P=h.uv_index_bytes*2;Z=h.uv_index_bytes*3;j+=function(p){var o,z,J,W=h.vertex_coordinate_bytes*3,da=p+h.nvertices*W;for(p=p;p<da;p+=W){o=d(a,p);z=d(a,p+h.vertex_coordinate_bytes);J=
d(a,p+h.vertex_coordinate_bytes*2);THREE.Loader.prototype.v(u,o,z,J)}return h.nvertices*W}(j);j+=function(p){var o,z,J,W=h.normal_coordinate_bytes*3,da=p+h.nnormals*W;for(p=p;p<da;p+=W){o=n(a,p);z=n(a,p+h.normal_coordinate_bytes);J=n(a,p+h.normal_coordinate_bytes*2);v.push(o/127,z/127,J/127)}return h.nnormals*W}(j);j+=function(p){var o,z,J=h.uv_coordinate_bytes*2,W=p+h.nuvs*J;for(p=p;p<W;p+=J){o=d(a,p);z=d(a,p+h.uv_coordinate_bytes);r.push(o,z)}return h.nuvs*J}(j);j+=function(p){var o,z=h.vertex_index_bytes*
3+h.material_index_bytes,J=p+h.ntri_flat*z;for(o=p;o<J;o+=z)E(o);return J-p}(j);j+=function(p){var o,z=h.vertex_index_bytes*3+h.material_index_bytes+h.normal_index_bytes*3,J=p+h.ntri_smooth*z;for(o=p;o<J;o+=z)s(o);return J-p}(j);j+=function(p){var o,z=h.vertex_index_bytes*3+h.material_index_bytes,J=z+h.uv_index_bytes*3,W=p+h.ntri_flat_uv*J;for(o=p;o<W;o+=J){E(o);C(o+z)}return W-p}(j);j+=function(p){var o,z=h.vertex_index_bytes*3+h.material_index_bytes+h.normal_index_bytes*3,J=z+h.uv_index_bytes*3,
W=p+h.ntri_smooth_uv*J;for(o=p;o<W;o+=J){s(o);C(o+z)}return W-p}(j);j+=function(p){var o,z=h.vertex_index_bytes*4+h.material_index_bytes,J=p+h.nquad_flat*z;for(o=p;o<J;o+=z)x(o);return J-p}(j);j+=function(p){var o,z=h.vertex_index_bytes*4+h.material_index_bytes+h.normal_index_bytes*4,J=p+h.nquad_smooth*z;for(o=p;o<J;o+=z)B(o);return J-p}(j);j+=function(p){var o,z=h.vertex_index_bytes*4+h.material_index_bytes,J=z+h.uv_index_bytes*4,W=p+h.nquad_flat_uv*J;for(o=p;o<W;o+=J){x(o);L(o+z)}return W-p}(j);
j+=function(p){var o,z=h.vertex_index_bytes*4+h.material_index_bytes+h.normal_index_bytes*4,J=z+h.uv_index_bytes*4,W=p+h.nquad_smooth_uv*J;for(o=p;o<W;o+=J){B(o);L(o+z)}return W-p}(j);this.computeCentroids();this.computeFaceNormals();this.sortFacesByMaterial()};i.prototype=new THREE.Geometry;i.prototype.constructor=i;c(new i(f))},createModel:function(a,c,f){var e=function(i){var k=this;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(k,a.materials,i);(function(){var d,m,l,n,w;d=0;for(m=
a.vertices.length;d<m;d+=3){l=a.vertices[d];n=a.vertices[d+1];w=a.vertices[d+2];THREE.Loader.prototype.v(k,l,n,w)}})();(function(){function d(B,C){THREE.Loader.prototype.f3(k,B[C],B[C+1],B[C+2],B[C+3])}function m(B,C){THREE.Loader.prototype.f3n(k,a.normals,B[C],B[C+1],B[C+2],B[C+3],B[C+4],B[C+5],B[C+6])}function l(B,C){THREE.Loader.prototype.f4(k,B[C],B[C+1],B[C+2],B[C+3],B[C+4])}function n(B,C){THREE.Loader.prototype.f4n(k,a.normals,B[C],B[C+1],B[C+2],B[C+3],B[C+4],B[C+5],B[C+6],B[C+7],B[C+8])}function w(B,
C){var L,u,j;L=B[C];u=B[C+1];j=B[C+2];THREE.Loader.prototype.uv3(k,a.uvs[L*2],a.uvs[L*2+1],a.uvs[u*2],a.uvs[u*2+1],a.uvs[j*2],a.uvs[j*2+1])}function E(B,C){var L,u,j,h;L=B[C];u=B[C+1];j=B[C+2];h=B[C+3];THREE.Loader.prototype.uv4(k,a.uvs[L*2],a.uvs[L*2+1],a.uvs[u*2],a.uvs[u*2+1],a.uvs[j*2],a.uvs[j*2+1],a.uvs[h*2],a.uvs[h*2+1])}var s,x;s=0;for(x=a.triangles.length;s<x;s+=4)d(a.triangles,s);s=0;for(x=a.triangles_uv.length;s<x;s+=7){d(a.triangles_uv,s);w(a.triangles_uv,s+4)}s=0;for(x=a.triangles_n.length;s<
x;s+=7)m(a.triangles_n,s);s=0;for(x=a.triangles_n_uv.length;s<x;s+=10){m(a.triangles_n_uv,s);w(a.triangles_n_uv,s+7)}s=0;for(x=a.quads.length;s<x;s+=5)l(a.quads,s);s=0;for(x=a.quads_uv.length;s<x;s+=9){l(a.quads_uv,s);E(a.quads_uv,s+5)}s=0;for(x=a.quads_n.length;s<x;s+=9)n(a.quads_n,s);s=0;for(x=a.quads_n_uv.length;s<x;s+=13){n(a.quads_n_uv,s);E(a.quads_n_uv,s+9)}})();this.computeCentroids();this.computeFaceNormals();this.sortFacesByMaterial()};e.prototype=new THREE.Geometry;e.prototype.constructor=
e;c(new e(f))},v:function(a,c,f,e){a.vertices.push(new THREE.Vertex(new THREE.Vector3(c,f,e)))},f3:function(a,c,f,e,i){a.faces.push(new THREE.Face3(c,f,e,null,a.materials[i]))},f4:function(a,c,f,e,i,k){a.faces.push(new THREE.Face4(c,f,e,i,null,a.materials[k]))},f3n:function(a,c,f,e,i,k,d,m,l){k=a.materials[k];var n=c[m*3],w=c[m*3+1];m=c[m*3+2];var E=c[l*3],s=c[l*3+1];l=c[l*3+2];a.faces.push(new THREE.Face3(f,e,i,[new THREE.Vector3(c[d*3],c[d*3+1],c[d*3+2]),new THREE.Vector3(n,w,m),new THREE.Vector3(E,
s,l)],k))},f4n:function(a,c,f,e,i,k,d,m,l,n,w){d=a.materials[d];var E=c[l*3],s=c[l*3+1];l=c[l*3+2];var x=c[n*3],B=c[n*3+1];n=c[n*3+2];var C=c[w*3],L=c[w*3+1];w=c[w*3+2];a.faces.push(new THREE.Face4(f,e,i,k,[new THREE.Vector3(c[m*3],c[m*3+1],c[m*3+2]),new THREE.Vector3(E,s,l),new THREE.Vector3(x,B,n),new THREE.Vector3(C,L,w)],d))},uv3:function(a,c,f,e,i,k,d){var m=[];m.push(new THREE.UV(c,f));m.push(new THREE.UV(e,i));m.push(new THREE.UV(k,d));a.uvs.push(m)},uv4:function(a,c,f,e,i,k,d,m,l){var n=[];
n.push(new THREE.UV(c,f));n.push(new THREE.UV(e,i));n.push(new THREE.UV(k,d));n.push(new THREE.UV(m,l));a.uvs.push(n)},init_materials:function(a,c,f){a.materials=[];for(var e=0;e<c.length;++e)a.materials[e]=[THREE.Loader.prototype.createMaterial(c[e],f)]},createMaterial:function(a,c){function f(k){k=Math.log(k)/Math.LN2;return Math.floor(k)==k}var e,i;if(a.map_diffuse&&c){i=document.createElement("canvas");e=new THREE.MeshLambertMaterial({map:new THREE.Texture(i)});i=new Image;i.onload=function(){if(!f(this.width)||
!f(this.height)){var k=Math.pow(2,Math.round(Math.log(this.width)/Math.LN2)),d=Math.pow(2,Math.round(Math.log(this.height)/Math.LN2));e.map.image.width=k;e.map.image.height=d;e.map.image.getContext("2d").drawImage(this,0,0,k,d)}else e.map.image=this;e.map.image.loaded=1};i.src=c+"/"+a.map_diffuse}else if(a.col_diffuse){i=(a.col_diffuse[0]*255<<16)+(a.col_diffuse[1]*255<<8)+a.col_diffuse[2]*255;e=new THREE.MeshLambertMaterial({color:i,opacity:a.transparency})}else e=a.a_dbg_color?new THREE.MeshLambertMaterial({color:a.a_dbg_color}):
new THREE.MeshLambertMaterial({color:15658734});return e}};
