// Three.js r32 - http://github.com/mrdoob/three.js
var THREE=THREE||{};THREE.Color=function(a){this.autoUpdate=true;this.setHex(a)};
THREE.Color.prototype={setRGB:function(a,c,f){this.r=a;this.g=c;this.b=f;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHex:function(a){this.hex=~~a&16777215;if(this.autoUpdate){this.updateRGBA();this.updateStyleString()}},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGBA:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},updateStyleString:function(){this.__styleString="rgb("+~~(this.r*255)+
","+~~(this.g*255)+","+~~(this.b*255)+")"},clone:function(){return new THREE.Color(this.hex)},toString:function(){return"THREE.Color ( r: "+this.r+", g: "+this.g+", b: "+this.b+", hex: "+this.hex+" )"}};THREE.Vector2=function(a,c){this.x=a||0;this.y=c||0};
THREE.Vector2.prototype={set:function(a,c){this.x=a;this.y=c;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},add:function(a,c){this.x=a.x+c.x;this.y=a.y+c.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},sub:function(a,c){this.x=a.x-c.x;this.y=a.y-c.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},unit:function(){this.multiplyScalar(1/this.length());return this},length:function(){return Math.sqrt(this.x*
this.x+this.y*this.y)},lengthSq:function(){return this.x*this.x+this.y*this.y},negate:function(){this.x=-this.x;this.y=-this.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},toString:function(){return"THREE.Vector2 ("+this.x+", "+this.y+")"}};THREE.Vector3=function(a,c,f){this.x=a||0;this.y=c||0;this.z=f||0};
THREE.Vector3.prototype={set:function(a,c,f){this.x=a;this.y=c;this.z=f;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},add:function(a,c){this.x=a.x+c.x;this.y=a.y+c.y;this.z=a.z+c.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,c){this.x=a.x-c.x;this.y=a.y-c.y;this.z=a.z-c.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},
cross:function(a,c){this.x=a.y*c.z-a.z*c.y;this.y=a.z*c.x-a.x*c.z;this.z=a.x*c.y-a.y*c.x;return this},crossSelf:function(a){var c=this.x,f=this.y,e=this.z;this.x=f*a.z-e*a.y;this.y=e*a.x-c*a.z;this.z=c*a.y-f*a.x;return this},multiply:function(a,c){this.x=a.x*c.x;this.y=a.y*c.y;this.z=a.z*c.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideScalar:function(a){this.x/=a;this.y/=a;this.z/=
a;return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},distanceTo:function(a){var c=this.x-a.x,f=this.y-a.y;a=this.z-a.z;return Math.sqrt(c*c+f*f+a*a)},distanceToSquared:function(a){var c=this.x-a.x,f=this.y-a.y;a=this.z-a.z;return c*c+f*f+a*a},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},negate:function(){this.x=-this.x;this.y=-this.y;this.z=-this.z;return this},normalize:function(){var a=
Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z);a>0?this.multiplyScalar(1/a):this.set(0,0,0);return this},setLength:function(a){return this.normalize().multiplyScalar(a)},isZero:function(){return Math.abs(this.x)<1.0E-4&&Math.abs(this.y)<1.0E-4&&Math.abs(this.z)<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},toString:function(){return"THREE.Vector3 ( "+this.x+", "+this.y+", "+this.z+" )"}};
THREE.Vector4=function(a,c,f,e){this.x=a||0;this.y=c||0;this.z=f||0;this.w=e||1};
THREE.Vector4.prototype={set:function(a,c,f,e){this.x=a;this.y=c;this.z=f;this.w=e;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w||1;return this},add:function(a,c){this.x=a.x+c.x;this.y=a.y+c.y;this.z=a.z+c.z;this.w=a.w+c.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,c){this.x=a.x-c.x;this.y=a.y-c.y;this.z=a.z-c.z;this.w=a.w-c.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;
return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){this.x/=a;this.y/=a;this.z/=a;this.w/=a;return this},lerpSelf:function(a,c){this.x+=(a.x-this.x)*c;this.y+=(a.y-this.y)*c;this.z+=(a.z-this.z)*c;this.w+=(a.w-this.w)*c},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},toString:function(){return"THREE.Vector4 ("+this.x+", "+this.y+", "+this.z+", "+this.w+")"}};
THREE.Ray=function(a,c){this.origin=a||new THREE.Vector3;this.direction=c||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){var c,f,e=a.objects,i=[];a=0;for(c=e.length;a<c;a++){f=e[a];if(f instanceof THREE.Mesh)i=i.concat(this.intersectObject(f))}i.sort(function(k,d){return k.distance-d.distance});return i},intersectObject:function(a){function c(Q,q,h,j){j=j.clone().subSelf(q);h=h.clone().subSelf(q);var r=Q.clone().subSelf(q);Q=j.dot(j);q=j.dot(h);j=j.dot(r);var n=h.dot(h);h=h.dot(r);r=1/(Q*n-q*q);n=(n*j-q*h)*r;Q=(Q*h-q*j)*r;return n>0&&Q>0&&n+Q<1}var f,e,i,k,d,s,m,p,D,F,
z,C=a.geometry,O=C.vertices,S=[];f=0;for(e=C.faces.length;f<e;f++){i=C.faces[f];F=this.origin.clone();z=this.direction.clone();k=a.matrix.multiplyVector3(O[i.a].position.clone());d=a.matrix.multiplyVector3(O[i.b].position.clone());s=a.matrix.multiplyVector3(O[i.c].position.clone());m=i instanceof THREE.Face4?a.matrix.multiplyVector3(O[i.d].position.clone()):null;p=a.rotationMatrix.multiplyVector3(i.normal.clone());D=z.dot(p);if(D<0){p=p.dot((new THREE.Vector3).sub(k,F))/D;F=F.addSelf(z.multiplyScalar(p));
if(i instanceof THREE.Face3){if(c(F,k,d,s)){i={distance:this.origin.distanceTo(F),point:F,face:i,object:a};S.push(i)}}else if(i instanceof THREE.Face4)if(c(F,k,d,m)||c(F,d,s,m)){i={distance:this.origin.distanceTo(F),point:F,face:i,object:a};S.push(i)}}}return S}};
THREE.Rectangle=function(){function a(){k=e-c;d=i-f}var c,f,e,i,k,d,s=true;this.getX=function(){return c};this.getY=function(){return f};this.getWidth=function(){return k};this.getHeight=function(){return d};this.getLeft=function(){return c};this.getTop=function(){return f};this.getRight=function(){return e};this.getBottom=function(){return i};this.set=function(m,p,D,F){s=false;c=m;f=p;e=D;i=F;a()};this.addPoint=function(m,p){if(s){s=false;c=m;f=p;e=m;i=p}else{c=c<m?c:m;f=f<p?f:p;e=e>m?e:m;i=i>p?
i:p}a()};this.add3Points=function(m,p,D,F,z,C){if(s){s=false;c=m<D?m<z?m:z:D<z?D:z;f=p<F?p<C?p:C:F<C?F:C;e=m>D?m>z?m:z:D>z?D:z;i=p>F?p>C?p:C:F>C?F:C}else{c=m<D?m<z?m<c?m:c:z<c?z:c:D<z?D<c?D:c:z<c?z:c;f=p<F?p<C?p<f?p:f:C<f?C:f:F<C?F<f?F:f:C<f?C:f;e=m>D?m>z?m>e?m:e:z>e?z:e:D>z?D>e?D:e:z>e?z:e;i=p>F?p>C?p>i?p:i:C>i?C:i:F>C?F>i?F:i:C>i?C:i}a()};this.addRectangle=function(m){if(s){s=false;c=m.getLeft();f=m.getTop();e=m.getRight();i=m.getBottom()}else{c=c<m.getLeft()?c:m.getLeft();f=f<m.getTop()?f:m.getTop();
e=e>m.getRight()?e:m.getRight();i=i>m.getBottom()?i:m.getBottom()}a()};this.inflate=function(m){c-=m;f-=m;e+=m;i+=m;a()};this.minSelf=function(m){c=c>m.getLeft()?c:m.getLeft();f=f>m.getTop()?f:m.getTop();e=e<m.getRight()?e:m.getRight();i=i<m.getBottom()?i:m.getBottom();a()};this.instersects=function(m){return Math.min(e,m.getRight())-Math.max(c,m.getLeft())>=0&&Math.min(i,m.getBottom())-Math.max(f,m.getTop())>=0};this.empty=function(){s=true;i=e=f=c=0;a()};this.isEmpty=function(){return s};this.toString=
function(){return"THREE.Rectangle ( left: "+c+", right: "+e+", top: "+f+", bottom: "+i+", width: "+k+", height: "+d+" )"}};THREE.Matrix3=function(){this.m=[]};THREE.Matrix3.prototype={transpose:function(){var a;a=this.m[1];this.m[1]=this.m[3];this.m[3]=a;a=this.m[2];this.m[2]=this.m[6];this.m[6]=a;a=this.m[5];this.m[5]=this.m[7];this.m[7]=a;return this}};
THREE.Matrix4=function(a,c,f,e,i,k,d,s,m,p,D,F,z,C,O,S){this.n11=a||1;this.n12=c||0;this.n13=f||0;this.n14=e||0;this.n21=i||0;this.n22=k||1;this.n23=d||0;this.n24=s||0;this.n31=m||0;this.n32=p||0;this.n33=D||1;this.n34=F||0;this.n41=z||0;this.n42=C||0;this.n43=O||0;this.n44=S||1};
THREE.Matrix4.prototype={identity:function(){this.n11=1;this.n21=this.n14=this.n13=this.n12=0;this.n22=1;this.n32=this.n31=this.n24=this.n23=0;this.n33=1;this.n43=this.n42=this.n41=this.n34=0;this.n44=1;return this},set:function(a,c,f,e,i,k,d,s,m,p,D,F,z,C,O,S){this.n11=a;this.n12=c;this.n13=f;this.n14=e;this.n21=i;this.n22=k;this.n23=d;this.n24=s;this.n31=m;this.n32=p;this.n33=D;this.n34=F;this.n41=z;this.n42=C;this.n43=O;this.n44=S;return this},copy:function(a){this.n11=a.n11;this.n12=a.n12;this.n13=
a.n13;this.n14=a.n14;this.n21=a.n21;this.n22=a.n22;this.n23=a.n23;this.n24=a.n24;this.n31=a.n31;this.n32=a.n32;this.n33=a.n33;this.n34=a.n34;this.n41=a.n41;this.n42=a.n42;this.n43=a.n43;this.n44=a.n44;return this},lookAt:function(a,c,f){var e=new THREE.Vector3,i=new THREE.Vector3,k=new THREE.Vector3;k.sub(a,c).normalize();e.cross(f,k).normalize();i.cross(k,e).normalize();this.n11=e.x;this.n12=e.y;this.n13=e.z;this.n14=-e.dot(a);this.n21=i.x;this.n22=i.y;this.n23=i.z;this.n24=-i.dot(a);this.n31=k.x;
this.n32=k.y;this.n33=k.z;this.n34=-k.dot(a);this.n43=this.n42=this.n41=0;this.n44=1;return this},multiplyVector3:function(a){var c=a.x,f=a.y,e=a.z,i=1/(this.n41*c+this.n42*f+this.n43*e+this.n44);a.x=(this.n11*c+this.n12*f+this.n13*e+this.n14)*i;a.y=(this.n21*c+this.n22*f+this.n23*e+this.n24)*i;a.z=(this.n31*c+this.n32*f+this.n33*e+this.n34)*i;return a},multiplyVector4:function(a){var c=a.x,f=a.y,e=a.z,i=a.w;a.x=this.n11*c+this.n12*f+this.n13*e+this.n14*i;a.y=this.n21*c+this.n22*f+this.n23*e+this.n24*
i;a.z=this.n31*c+this.n32*f+this.n33*e+this.n34*i;a.w=this.n41*c+this.n42*f+this.n43*e+this.n44*i;return a},crossVector:function(a){var c=new THREE.Vector4;c.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;c.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;c.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;c.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return c},multiply:function(a,c){var f=a.n11,e=a.n12,i=a.n13,k=a.n14,d=a.n21,s=a.n22,m=a.n23,p=a.n24,D=a.n31,F=a.n32,
z=a.n33,C=a.n34,O=a.n41,S=a.n42,Q=a.n43,q=a.n44,h=c.n11,j=c.n12,r=c.n13,n=c.n14,t=c.n21,l=c.n22,o=c.n23,x=c.n24,u=c.n31,A=c.n32,w=c.n33,v=c.n34,G=c.n41,Z=c.n42,H=c.n43,T=c.n44;this.n11=f*h+e*t+i*u+k*G;this.n12=f*j+e*l+i*A+k*Z;this.n13=f*r+e*o+i*w+k*H;this.n14=f*n+e*x+i*v+k*T;this.n21=d*h+s*t+m*u+p*G;this.n22=d*j+s*l+m*A+p*Z;this.n23=d*r+s*o+m*w+p*H;this.n24=d*n+s*x+m*v+p*T;this.n31=D*h+F*t+z*u+C*G;this.n32=D*j+F*l+z*A+C*Z;this.n33=D*r+F*o+z*w+C*H;this.n34=D*n+F*x+z*v+C*T;this.n41=O*h+S*t+Q*u+q*G;
this.n42=O*j+S*l+Q*A+q*Z;this.n43=O*r+S*o+Q*w+q*H;this.n44=O*n+S*x+Q*v+q*T;return this},multiplySelf:function(a){var c=this.n11,f=this.n12,e=this.n13,i=this.n14,k=this.n21,d=this.n22,s=this.n23,m=this.n24,p=this.n31,D=this.n32,F=this.n33,z=this.n34,C=this.n41,O=this.n42,S=this.n43,Q=this.n44,q=a.n11,h=a.n21,j=a.n31,r=a.n41,n=a.n12,t=a.n22,l=a.n32,o=a.n42,x=a.n13,u=a.n23,A=a.n33,w=a.n43,v=a.n14,G=a.n24,Z=a.n34;a=a.n44;this.n11=c*q+f*h+e*j+i*r;this.n12=c*n+f*t+e*l+i*o;this.n13=c*x+f*u+e*A+i*w;this.n14=
c*v+f*G+e*Z+i*a;this.n21=k*q+d*h+s*j+m*r;this.n22=k*n+d*t+s*l+m*o;this.n23=k*x+d*u+s*A+m*w;this.n24=k*v+d*G+s*Z+m*a;this.n31=p*q+D*h+F*j+z*r;this.n32=p*n+D*t+F*l+z*o;this.n33=p*x+D*u+F*A+z*w;this.n34=p*v+D*G+F*Z+z*a;this.n41=C*q+O*h+S*j+Q*r;this.n42=C*n+O*t+S*l+Q*o;this.n43=C*x+O*u+S*A+Q*w;this.n44=C*v+O*G+S*Z+Q*a;return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=
a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){return this.n14*this.n23*this.n32*this.n41-this.n13*this.n24*this.n32*this.n41-this.n14*this.n22*this.n33*this.n41+this.n12*this.n24*this.n33*this.n41+this.n13*this.n22*this.n34*this.n41-this.n12*this.n23*this.n34*this.n41-this.n14*this.n23*this.n31*this.n42+this.n13*this.n24*this.n31*this.n42+this.n14*this.n21*this.n33*this.n42-this.n11*this.n24*this.n33*this.n42-this.n13*this.n21*this.n34*this.n42+this.n11*this.n23*this.n34*
this.n42+this.n14*this.n22*this.n31*this.n43-this.n12*this.n24*this.n31*this.n43-this.n14*this.n21*this.n32*this.n43+this.n11*this.n24*this.n32*this.n43+this.n12*this.n21*this.n34*this.n43-this.n11*this.n22*this.n34*this.n43-this.n13*this.n22*this.n31*this.n44+this.n12*this.n23*this.n31*this.n44+this.n13*this.n21*this.n32*this.n44-this.n11*this.n23*this.n32*this.n44-this.n12*this.n21*this.n33*this.n44+this.n11*this.n22*this.n33*this.n44},transpose:function(){function a(c,f,e){var i=c[f];c[f]=c[e];
c[e]=i}a(this,"n21","n12");a(this,"n31","n13");a(this,"n32","n23");a(this,"n41","n14");a(this,"n42","n24");a(this,"n43","n34");return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){return[this.n11,this.n21,this.n31,this.n41,this.n12,
this.n22,this.n32,this.n42,this.n13,this.n23,this.n33,this.n43,this.n14,this.n24,this.n34,this.n44]},toString:function(){return"| "+this.n11+" "+this.n12+" "+this.n13+" "+this.n14+" |\n| "+this.n21+" "+this.n22+" "+this.n23+" "+this.n24+" |\n| "+this.n31+" "+this.n32+" "+this.n33+" "+this.n34+" |\n| "+this.n41+" "+this.n42+" "+this.n43+" "+this.n44+" |"}};THREE.Matrix4.translationMatrix=function(a,c,f){var e=new THREE.Matrix4;e.n14=a;e.n24=c;e.n34=f;return e};
THREE.Matrix4.scaleMatrix=function(a,c,f){var e=new THREE.Matrix4;e.n11=a;e.n22=c;e.n33=f;return e};THREE.Matrix4.rotationXMatrix=function(a){var c=new THREE.Matrix4;c.n22=c.n33=Math.cos(a);c.n32=Math.sin(a);c.n23=-c.n32;return c};THREE.Matrix4.rotationYMatrix=function(a){var c=new THREE.Matrix4;c.n11=c.n33=Math.cos(a);c.n13=Math.sin(a);c.n31=-c.n13;return c};THREE.Matrix4.rotationZMatrix=function(a){var c=new THREE.Matrix4;c.n11=c.n22=Math.cos(a);c.n21=Math.sin(a);c.n12=-c.n21;return c};
THREE.Matrix4.rotationAxisAngleMatrix=function(a,c){var f=new THREE.Matrix4,e=Math.cos(c),i=Math.sin(c),k=1-e,d=a.x,s=a.y,m=a.z;f.n11=k*d*d+e;f.n12=k*d*s-i*m;f.n13=k*d*m+i*s;f.n21=k*d*s+i*m;f.n22=k*s*s+e;f.n23=k*s*m-i*d;f.n31=k*d*m-i*s;f.n32=k*s*m+i*d;f.n33=k*m*m+e;return f};
THREE.Matrix4.makeInvert=function(a){var c=new THREE.Matrix4;c.n11=a.n23*a.n34*a.n42-a.n24*a.n33*a.n42+a.n24*a.n32*a.n43-a.n22*a.n34*a.n43-a.n23*a.n32*a.n44+a.n22*a.n33*a.n44;c.n12=a.n14*a.n33*a.n42-a.n13*a.n34*a.n42-a.n14*a.n32*a.n43+a.n12*a.n34*a.n43+a.n13*a.n32*a.n44-a.n12*a.n33*a.n44;c.n13=a.n13*a.n24*a.n42-a.n14*a.n23*a.n42+a.n14*a.n22*a.n43-a.n12*a.n24*a.n43-a.n13*a.n22*a.n44+a.n12*a.n23*a.n44;c.n14=a.n14*a.n23*a.n32-a.n13*a.n24*a.n32-a.n14*a.n22*a.n33+a.n12*a.n24*a.n33+a.n13*a.n22*a.n34-a.n12*
a.n23*a.n34;c.n21=a.n24*a.n33*a.n41-a.n23*a.n34*a.n41-a.n24*a.n31*a.n43+a.n21*a.n34*a.n43+a.n23*a.n31*a.n44-a.n21*a.n33*a.n44;c.n22=a.n13*a.n34*a.n41-a.n14*a.n33*a.n41+a.n14*a.n31*a.n43-a.n11*a.n34*a.n43-a.n13*a.n31*a.n44+a.n11*a.n33*a.n44;c.n23=a.n14*a.n23*a.n41-a.n13*a.n24*a.n41-a.n14*a.n21*a.n43+a.n11*a.n24*a.n43+a.n13*a.n21*a.n44-a.n11*a.n23*a.n44;c.n24=a.n13*a.n24*a.n31-a.n14*a.n23*a.n31+a.n14*a.n21*a.n33-a.n11*a.n24*a.n33-a.n13*a.n21*a.n34+a.n11*a.n23*a.n34;c.n31=a.n22*a.n34*a.n41-a.n24*a.n32*
a.n41+a.n24*a.n31*a.n42-a.n21*a.n34*a.n42-a.n22*a.n31*a.n44+a.n21*a.n32*a.n44;c.n32=a.n14*a.n32*a.n41-a.n12*a.n34*a.n41-a.n14*a.n31*a.n42+a.n11*a.n34*a.n42+a.n12*a.n31*a.n44-a.n11*a.n32*a.n44;c.n33=a.n13*a.n24*a.n41-a.n14*a.n22*a.n41+a.n14*a.n21*a.n42-a.n11*a.n24*a.n42-a.n12*a.n21*a.n44+a.n11*a.n22*a.n44;c.n34=a.n14*a.n22*a.n31-a.n12*a.n24*a.n31-a.n14*a.n21*a.n32+a.n11*a.n24*a.n32+a.n12*a.n21*a.n34-a.n11*a.n22*a.n34;c.n41=a.n23*a.n32*a.n41-a.n22*a.n33*a.n41-a.n23*a.n31*a.n42+a.n21*a.n33*a.n42+a.n22*
a.n31*a.n43-a.n21*a.n32*a.n43;c.n42=a.n12*a.n33*a.n41-a.n13*a.n32*a.n41+a.n13*a.n31*a.n42-a.n11*a.n33*a.n42-a.n12*a.n31*a.n43+a.n11*a.n32*a.n43;c.n43=a.n13*a.n22*a.n41-a.n12*a.n23*a.n41-a.n13*a.n21*a.n42+a.n11*a.n23*a.n42+a.n12*a.n21*a.n43-a.n11*a.n22*a.n43;c.n44=a.n12*a.n23*a.n31-a.n13*a.n22*a.n31+a.n13*a.n21*a.n32-a.n11*a.n23*a.n32-a.n12*a.n21*a.n33+a.n11*a.n22*a.n33;c.multiplyScalar(1/a.determinant());return c};
THREE.Matrix4.makeInvert3x3=function(a){var c=a.flatten();a=new THREE.Matrix3;var f=c[10]*c[5]-c[6]*c[9],e=-c[10]*c[1]+c[2]*c[9],i=c[6]*c[1]-c[2]*c[5],k=-c[10]*c[4]+c[6]*c[8],d=c[10]*c[0]-c[2]*c[8],s=-c[6]*c[0]+c[2]*c[4],m=c[9]*c[4]-c[5]*c[8],p=-c[9]*c[0]+c[1]*c[8],D=c[5]*c[0]-c[1]*c[4];c=c[0]*f+c[1]*k+c[2]*m;if(c==0)throw"matrix not invertible";c=1/c;a.m[0]=c*f;a.m[1]=c*e;a.m[2]=c*i;a.m[3]=c*k;a.m[4]=c*d;a.m[5]=c*s;a.m[6]=c*m;a.m[7]=c*p;a.m[8]=c*D;return a};
THREE.Matrix4.makeFrustum=function(a,c,f,e,i,k){var d,s,m;d=new THREE.Matrix4;s=2*i/(c-a);m=2*i/(e-f);a=(c+a)/(c-a);f=(e+f)/(e-f);e=-(k+i)/(k-i);i=-2*k*i/(k-i);d.n11=s;d.n12=0;d.n13=a;d.n14=0;d.n21=0;d.n22=m;d.n23=f;d.n24=0;d.n31=0;d.n32=0;d.n33=e;d.n34=i;d.n41=0;d.n42=0;d.n43=-1;d.n44=0;return d};THREE.Matrix4.makePerspective=function(a,c,f,e){var i;a=f*Math.tan(a*Math.PI/360);i=-a;return THREE.Matrix4.makeFrustum(i*c,a*c,i,a,f,e)};
THREE.Matrix4.makeOrtho=function(a,c,f,e,i,k){var d,s,m,p;d=new THREE.Matrix4;s=c-a;m=f-e;p=k-i;a=(c+a)/s;f=(f+e)/m;i=(k+i)/p;d.n11=2/s;d.n12=0;d.n13=0;d.n14=-a;d.n21=0;d.n22=2/m;d.n23=0;d.n24=-f;d.n31=0;d.n32=0;d.n33=-2/p;d.n34=-i;d.n41=0;d.n42=0;d.n43=0;d.n44=1;return d};
THREE.Vertex=function(a,c){this.position=a||new THREE.Vector3;this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.normal=c||new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.normalScreen=new THREE.Vector3;this.tangent=new THREE.Vector4;this.__visible=true};THREE.Vertex.prototype={toString:function(){return"THREE.Vertex ( position: "+this.position+", normal: "+this.normal+" )"}};
THREE.Face3=function(a,c,f,e,i){this.a=a;this.b=c;this.c=f;this.centroid=new THREE.Vector3;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.materials=i instanceof Array?i:[i]};THREE.Face3.prototype={toString:function(){return"THREE.Face3 ( "+this.a+", "+this.b+", "+this.c+" )"}};
THREE.Face4=function(a,c,f,e,i,k){this.a=a;this.b=c;this.c=f;this.d=e;this.centroid=new THREE.Vector3;this.normal=i instanceof THREE.Vector3?i:new THREE.Vector3;this.vertexNormals=i instanceof Array?i:[];this.materials=k instanceof Array?k:[k]};THREE.Face4.prototype={toString:function(){return"THREE.Face4 ( "+this.a+", "+this.b+", "+this.c+" "+this.d+" )"}};THREE.UV=function(a,c){this.u=a||0;this.v=c||0};
THREE.UV.prototype={copy:function(a){this.u=a.u;this.v=a.v},toString:function(){return"THREE.UV ("+this.u+", "+this.v+")"}};THREE.Geometry=function(){this.vertices=[];this.faces=[];this.uvs=[];this.boundingSphere=this.boundingBox=null;this.geometryChunks={};this.hasTangents=false};
THREE.Geometry.prototype={computeCentroids:function(){var a,c,f;a=0;for(c=this.faces.length;a<c;a++){f=this.faces[a];f.centroid.set(0,0,0);if(f instanceof THREE.Face3){f.centroid.addSelf(this.vertices[f.a].position);f.centroid.addSelf(this.vertices[f.b].position);f.centroid.addSelf(this.vertices[f.c].position);f.centroid.divideScalar(3)}else if(f instanceof THREE.Face4){f.centroid.addSelf(this.vertices[f.a].position);f.centroid.addSelf(this.vertices[f.b].position);f.centroid.addSelf(this.vertices[f.c].position);
f.centroid.addSelf(this.vertices[f.d].position);f.centroid.divideScalar(4)}}},computeFaceNormals:function(a){var c,f,e,i,k,d,s=new THREE.Vector3,m=new THREE.Vector3;e=0;for(i=this.vertices.length;e<i;e++){k=this.vertices[e];k.normal.set(0,0,0)}e=0;for(i=this.faces.length;e<i;e++){k=this.faces[e];if(a&&k.vertexNormals.length){s.set(0,0,0);c=0;for(f=k.normal.length;c<f;c++)s.addSelf(k.vertexNormals[c]);s.divideScalar(3)}else{c=this.vertices[k.a];f=this.vertices[k.b];d=this.vertices[k.c];s.sub(d.position,
f.position);m.sub(c.position,f.position);s.crossSelf(m)}s.isZero()||s.normalize();k.normal.copy(s)}},computeVertexNormals:function(){var a,c,f=[],e;a=0;for(c=this.vertices.length;a<c;a++)f[a]=new THREE.Vector3;a=0;for(c=this.faces.length;a<c;a++){e=this.faces[a];if(e instanceof THREE.Face3){f[e.a].addSelf(e.normal);f[e.b].addSelf(e.normal);f[e.c].addSelf(e.normal)}else if(e instanceof THREE.Face4){f[e.a].addSelf(e.normal);f[e.b].addSelf(e.normal);f[e.c].addSelf(e.normal);f[e.d].addSelf(e.normal)}}a=
0;for(c=this.vertices.length;a<c;a++)f[a].normalize();a=0;for(c=this.faces.length;a<c;a++){e=this.faces[a];if(e instanceof THREE.Face3){e.vertexNormals[0]=f[e.a].clone();e.vertexNormals[1]=f[e.b].clone();e.vertexNormals[2]=f[e.c].clone()}else if(e instanceof THREE.Face4){e.vertexNormals[0]=f[e.a].clone();e.vertexNormals[1]=f[e.b].clone();e.vertexNormals[2]=f[e.c].clone();e.vertexNormals[3]=f[e.d].clone()}}},computeTangents:function(){function a(v,G,Z,H,T,V,I){k=v.vertices[G].position;d=v.vertices[Z].position;
s=v.vertices[H].position;m=i[T];p=i[V];D=i[I];F=d.x-k.x;z=s.x-k.x;C=d.y-k.y;O=s.y-k.y;S=d.z-k.z;Q=s.z-k.z;q=p.u-m.u;h=D.u-m.u;j=p.v-m.v;r=D.v-m.v;n=1/(q*r-h*j);o.set((r*F-j*z)*n,(r*C-j*O)*n,(r*S-j*Q)*n);x.set((q*z-h*F)*n,(q*O-h*C)*n,(q*Q-h*S)*n);t[G].addSelf(o);t[Z].addSelf(o);t[H].addSelf(o);l[G].addSelf(x);l[Z].addSelf(x);l[H].addSelf(x)}var c,f,e,i,k,d,s,m,p,D,F,z,C,O,S,Q,q,h,j,r,n,t=[],l=[],o=new THREE.Vector3,x=new THREE.Vector3,u=new THREE.Vector3,A=new THREE.Vector3,w=new THREE.Vector3;c=0;
for(f=this.vertices.length;c<f;c++){t[c]=new THREE.Vector3;l[c]=new THREE.Vector3}c=0;for(f=this.faces.length;c<f;c++){e=this.faces[c];i=this.uvs[c];if(e instanceof THREE.Face3){a(this,e.a,e.b,e.c,0,1,2);this.vertices[e.a].normal.copy(e.vertexNormals[0]);this.vertices[e.b].normal.copy(e.vertexNormals[1]);this.vertices[e.c].normal.copy(e.vertexNormals[2])}else if(e instanceof THREE.Face4){a(this,e.a,e.b,e.c,0,1,2);a(this,e.a,e.b,e.d,0,1,3);this.vertices[e.a].normal.copy(e.vertexNormals[0]);this.vertices[e.b].normal.copy(e.vertexNormals[1]);
this.vertices[e.c].normal.copy(e.vertexNormals[2]);this.vertices[e.d].normal.copy(e.vertexNormals[3])}}c=0;for(f=this.vertices.length;c<f;c++){w.copy(this.vertices[c].normal);e=t[c];u.copy(e);u.subSelf(w.multiplyScalar(w.dot(e))).normalize();A.cross(this.vertices[c].normal,e);e=A.dot(l[c]);e=e<0?-1:1;this.vertices[c].tangent.set(u.x,u.y,u.z,e)}this.hasTangents=true},computeBoundingBox:function(){var a;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],
y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var c=1,f=this.vertices.length;c<f;c++){a=this.vertices[c];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<
this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=this.boundingSphere===null?0:this.boundingSphere.radius,c=0,f=this.vertices.length;c<f;c++)a=Math.max(a,this.vertices[c].position.length());this.boundingSphere={radius:a}},sortFacesByMaterial:function(){function a(D){var F=[];c=0;for(f=D.length;c<f;c++)D[c]==undefined?F.push("undefined"):F.push(D[c].toString());return F.join("_")}
var c,f,e,i,k,d,s,m,p={};e=0;for(i=this.faces.length;e<i;e++){k=this.faces[e];d=k.materials;s=a(d);if(p[s]==undefined)p[s]={hash:s,counter:0};m=p[s].hash+"_"+p[s].counter;if(this.geometryChunks[m]==undefined)this.geometryChunks[m]={faces:[],materials:d,vertices:0};k=k instanceof THREE.Face3?3:4;if(this.geometryChunks[m].vertices+k>65535){p[s].counter+=1;m=p[s].hash+"_"+p[s].counter;if(this.geometryChunks[m]==undefined)this.geometryChunks[m]={faces:[],materials:d,vertices:0}}this.geometryChunks[m].faces.push(e);
this.geometryChunks[m].vertices+=k}},toString:function(){return"THREE.Geometry ( vertices: "+this.vertices+", faces: "+this.faces+", uvs: "+this.uvs+" )"}};
THREE.Camera=function(a,c,f,e){this.fov=a;this.aspect=c;this.near=f;this.far=e;this.position=new THREE.Vector3;this.target={position:new THREE.Vector3};this.autoUpdateMatrix=true;this.projectionMatrix=null;this.matrix=new THREE.Matrix4;this.up=new THREE.Vector3(0,1,0);this.translateX=function(i){i=this.target.position.clone().subSelf(this.position).normalize().multiplyScalar(i);i.cross(i.clone(),this.up);this.position.addSelf(i);this.target.position.addSelf(i)};this.translateZ=function(i){i=this.target.position.clone().subSelf(this.position).normalize().multiplyScalar(i);
this.position.subSelf(i);this.target.position.subSelf(i)};this.updateMatrix=function(){this.matrix.lookAt(this.position,this.target.position,this.up)};this.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};this.updateProjectionMatrix()};THREE.Camera.prototype={toString:function(){return"THREE.Camera ( "+this.position+", "+this.target.position+" )"}};THREE.Light=function(a){this.color=new THREE.Color(a)};
THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=c||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;
THREE.PointLight=function(a,c){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=c||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.PointLight;
THREE.Object3D=function(){this.id=THREE.Object3DCounter.value++;this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.matrix=new THREE.Matrix4;this.translationMatrix=new THREE.Matrix4;this.rotationMatrix=new THREE.Matrix4;this.scaleMatrix=new THREE.Matrix4;this.screen=new THREE.Vector3;this.visible=this.autoUpdateMatrix=true};
THREE.Object3D.prototype={updateMatrix:function(){this.matrixPosition=THREE.Matrix4.translationMatrix(this.position.x,this.position.y,this.position.z);this.rotationMatrix=THREE.Matrix4.rotationXMatrix(this.rotation.x);this.rotationMatrix.multiplySelf(THREE.Matrix4.rotationYMatrix(this.rotation.y));this.rotationMatrix.multiplySelf(THREE.Matrix4.rotationZMatrix(this.rotation.z));this.scaleMatrix=THREE.Matrix4.scaleMatrix(this.scale.x,this.scale.y,this.scale.z);this.matrix.copy(this.matrixPosition);
this.matrix.multiplySelf(this.rotationMatrix);this.matrix.multiplySelf(this.scaleMatrix)}};THREE.Object3DCounter={value:0};THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a];this.autoUpdateMatrix=false};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,c){THREE.Object3D.call(this);this.geometry=a;this.materials=c instanceof Array?c:[c]};THREE.Line.prototype=new THREE.Object3D;
THREE.Line.prototype.constructor=THREE.Line;THREE.Mesh=function(a,c){THREE.Object3D.call(this);this.geometry=a;this.materials=c instanceof Array?c:[c];this.overdraw=this.doubleSided=this.flipSided=false;this.geometry.boundingSphere||this.geometry.computeBoundingSphere()};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.FlatShading=0;THREE.SmoothShading=1;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;
THREE.LineBasicMaterial=function(a){this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;this.linewidth=1;this.linejoin=this.linecap="round";if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending;if(a.linewidth!==undefined)this.linewidth=a.linewidth;if(a.linecap!==undefined)this.linecap=a.linecap;if(a.linejoin!==undefined)this.linejoin=a.linejoin}};
THREE.LineBasicMaterial.prototype={toString:function(){return"THREE.LineBasicMaterial (<br/>color: "+this.color+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>linewidth: "+this.linewidth+"<br/>linecap: "+this.linecap+"<br/>linejoin: "+this.linejoin+"<br/>)"}};
THREE.MeshBasicMaterial=function(a){this.id=THREE.MeshBasicMaterialCounter.value++;this.color=new THREE.Color(16777215);this.env_map=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refraction_ratio=0.98;this.fog=true;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;this.wireframe_linejoin=this.wireframe_linecap="round";if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.map!==undefined)this.map=
a.map;if(a.env_map!==undefined)this.env_map=a.env_map;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refraction_ratio!==undefined)this.refraction_ratio=a.refraction_ratio;if(a.fog!==undefined)this.fog=a.fog;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==
undefined)this.wireframe_linewidth=a.wireframe_linewidth;if(a.wireframe_linecap!==undefined)this.wireframe_linecap=a.wireframe_linecap;if(a.wireframe_linejoin!==undefined)this.wireframe_linejoin=a.wireframe_linejoin}};
THREE.MeshBasicMaterial.prototype={toString:function(){return"THREE.MeshBasicMaterial (<br/>id: "+this.id+"<br/>color: "+this.color+"<br/>map: "+this.map+"<br/>env_map: "+this.env_map+"<br/>combine: "+this.combine+"<br/>reflectivity: "+this.reflectivity+"<br/>refraction_ratio: "+this.refraction_ratio+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>wireframe: "+this.wireframe+"<br/>wireframe_linewidth: "+this.wireframe_linewidth+"<br/>wireframe_linecap: "+this.wireframe_linecap+
"<br/>wireframe_linejoin: "+this.wireframe_linejoin+"<br/>)"}};THREE.MeshBasicMaterialCounter={value:0};
THREE.MeshLambertMaterial=function(a){this.id=THREE.MeshLambertMaterialCounter.value++;this.color=new THREE.Color(16777215);this.env_map=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refraction_ratio=0.98;this.fog=true;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;this.wireframe_linejoin=this.wireframe_linecap="round";if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.map!==undefined)this.map=
a.map;if(a.env_map!==undefined)this.env_map=a.env_map;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refraction_ratio!==undefined)this.refraction_ratio=a.refraction_ratio;if(a.fog!==undefined)this.fog=a.fog;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==
undefined)this.wireframe_linewidth=a.wireframe_linewidth;if(a.wireframe_linecap!==undefined)this.wireframe_linecap=a.wireframe_linecap;if(a.wireframe_linejoin!==undefined)this.wireframe_linejoin=a.wireframe_linejoin}};
THREE.MeshLambertMaterial.prototype={toString:function(){return"THREE.MeshLambertMaterial (<br/>id: "+this.id+"<br/>color: "+this.color+"<br/>map: "+this.map+"<br/>env_map: "+this.env_map+"<br/>combine: "+this.combine+"<br/>reflectivity: "+this.reflectivity+"<br/>refraction_ratio: "+this.refraction_ratio+"<br/>opacity: "+this.opacity+"<br/>shading: "+this.shading+"<br/>blending: "+this.blending+"<br/>wireframe: "+this.wireframe+"<br/>wireframe_linewidth: "+this.wireframe_linewidth+"<br/>wireframe_linecap: "+
this.wireframe_linecap+"<br/>wireframe_linejoin: "+this.wireframe_linejoin+"<br/> )"}};THREE.MeshLambertMaterialCounter={value:0};
THREE.MeshPhongMaterial=function(a){this.id=THREE.MeshPhongMaterialCounter.value++;this.color=new THREE.Color(16777215);this.ambient=new THREE.Color(328965);this.specular=new THREE.Color(1118481);this.shininess=30;this.env_map=this.specular_map=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refraction_ratio=0.98;this.fog=true;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;this.wireframe_linejoin=
this.wireframe_linecap="round";if(a){if(a.color!==undefined)this.color=new THREE.Color(a.color);if(a.ambient!==undefined)this.ambient=new THREE.Color(a.ambient);if(a.specular!==undefined)this.specular=new THREE.Color(a.specular);if(a.shininess!==undefined)this.shininess=a.shininess;if(a.map!==undefined)this.map=a.map;if(a.specular_map!==undefined)this.specular_map=a.specular_map;if(a.env_map!==undefined)this.env_map=a.env_map;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=
a.reflectivity;if(a.refraction_ratio!==undefined)this.refraction_ratio=a.refraction_ratio;if(a.fog!==undefined)this.fog=a.fog;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==undefined)this.wireframe_linewidth=a.wireframe_linewidth;if(a.wireframe_linecap!==undefined)this.wireframe_linecap=a.wireframe_linecap;if(a.wireframe_linejoin!==
undefined)this.wireframe_linejoin=a.wireframe_linejoin}};
THREE.MeshPhongMaterial.prototype={toString:function(){return"THREE.MeshPhongMaterial (<br/>id: "+this.id+"<br/>color: "+this.color+"<br/>ambient: "+this.ambient+"<br/>specular: "+this.specular+"<br/>shininess: "+this.shininess+"<br/>map: "+this.map+"<br/>specular_map: "+this.specular_map+"<br/>env_map: "+this.env_map+"<br/>combine: "+this.combine+"<br/>reflectivity: "+this.reflectivity+"<br/>refraction_ratio: "+this.refraction_ratio+"<br/>opacity: "+this.opacity+"<br/>shading: "+this.shading+"<br/>wireframe: "+
this.wireframe+"<br/>wireframe_linewidth: "+this.wireframe_linewidth+"<br/>wireframe_linecap: "+this.wireframe_linecap+"<br/>wireframe_linejoin: "+this.wireframe_linejoin+"<br/>)"}};THREE.MeshPhongMaterialCounter={value:0};
THREE.MeshDepthMaterial=function(a){this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;this.wireframe_linejoin=this.wireframe_linecap="round";if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}};THREE.MeshDepthMaterial.prototype={toString:function(){return"THREE.MeshDepthMaterial"}};
THREE.MeshNormalMaterial=function(a){this.opacity=1;this.shading=THREE.FlatShading;this.blending=THREE.NormalBlending;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending}};THREE.MeshNormalMaterial.prototype={toString:function(){return"THREE.MeshNormalMaterial"}};THREE.MeshFaceMaterial=function(){};THREE.MeshFaceMaterial.prototype={toString:function(){return"THREE.MeshFaceMaterial"}};
THREE.MeshShaderMaterial=function(a){this.id=THREE.MeshShaderMaterialCounter.value++;this.vertex_shader=this.fragment_shader="void main() {}";this.uniforms={};this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;this.wireframe_linejoin=this.wireframe_linecap="round";if(a){if(a.fragment_shader!==undefined)this.fragment_shader=a.fragment_shader;if(a.vertex_shader!==undefined)this.vertex_shader=a.vertex_shader;if(a.uniforms!==
undefined)this.uniforms=a.uniforms;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==undefined)this.wireframe_linewidth=a.wireframe_linewidth;if(a.wireframe_linecap!==undefined)this.wireframe_linecap=a.wireframe_linecap;if(a.wireframe_linejoin!==undefined)this.wireframe_linejoin=a.wireframe_linejoin}};
THREE.MeshShaderMaterial.prototype={toString:function(){return"THREE.MeshShaderMaterial (<br/>id: "+this.id+"<br/>blending: "+this.blending+"<br/>wireframe: "+this.wireframe+"<br/>wireframe_linewidth: "+this.wireframe_linewidth+"<br/>wireframe_linecap: "+this.wireframe_linecap+"<br/>wireframe_linejoin: "+this.wireframe_linejoin+"<br/>)"}};THREE.MeshShaderMaterialCounter={value:0};
THREE.ParticleBasicMaterial=function(a){this.color=new THREE.Color(16777215);this.map=null;this.opacity=1;this.blending=THREE.NormalBlending;this.offset=new THREE.Vector2;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.map!==undefined)this.map=a.map;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}};
THREE.ParticleBasicMaterial.prototype={toString:function(){return"THREE.ParticleBasicMaterial (<br/>color: "+this.color+"<br/>map: "+this.map+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>)"}};THREE.ParticleCircleMaterial=function(a){this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}};
THREE.ParticleCircleMaterial.prototype={toString:function(){return"THREE.ParticleCircleMaterial (<br/>color: "+this.color+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>)"}};THREE.ParticleDOMMaterial=function(a){this.domElement=a};THREE.ParticleDOMMaterial.prototype={toString:function(){return"THREE.ParticleDOMMaterial ( domElement: "+this.domElement+" )"}};
THREE.Texture=function(a,c,f,e,i,k){this.image=a;this.mapping=c!==undefined?c:new THREE.UVMapping;this.wrap_s=f!==undefined?f:THREE.ClampToEdgeWrapping;this.wrap_t=e!==undefined?e:THREE.ClampToEdgeWrapping;this.mag_filter=i!==undefined?i:THREE.LinearFilter;this.min_filter=k!==undefined?k:THREE.LinearMipMapLinearFilter};
THREE.Texture.prototype={clone:function(){return new THREE.Texture(this.image,this.mapping,this.wrap_s,this.wrap_t,this.mag_filter,this.min_filter)},toString:function(){return"THREE.Texture (<br/>image: "+this.image+"<br/>wrap_s: "+this.wrap_s+"<br/>wrap_t: "+this.wrap_t+"<br/>mag_filter: "+this.mag_filter+"<br/>min_filter: "+this.min_filter+"<br/>)"}};THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;
THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;var Uniforms={clone:function(a){var c,f,e,i={};for(c in a){i[c]={};for(f in a[c]){e=a[c][f];i[c][f]=e instanceof THREE.Color||e instanceof THREE.Vector3||e instanceof THREE.Texture?e.clone():e}}return i},merge:function(a){var c,f,e,i={};for(c=0;c<a.length;c++){e=this.clone(a[c]);for(f in e)i[f]=e[f]}return i}};
THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};
THREE.Scene=function(){this.objects=[];this.lights=[];this.fog=null;this.addObject=function(a){this.objects.indexOf(a)===-1&&this.objects.push(a)};this.removeObject=function(a){a=this.objects.indexOf(a);a!==-1&&this.objects.splice(a,1)};this.addLight=function(a){this.lights.indexOf(a)===-1&&this.lights.push(a)};this.removeLight=function(a){a=this.lights.indexOf(a);a!==-1&&this.lights.splice(a,1)};this.toString=function(){return"THREE.Scene ( "+this.objects+" )"}};
THREE.Fog=function(a,c,f){this.color=new THREE.Color(a);this.near=c||1;this.far=f||1E3};THREE.FogExp2=function(a,c){this.color=new THREE.Color(a);this.density=c||2.5E-4};
THREE.Projector=function(){function a(l,o){return o.z-l.z}function c(l,o){var x=0,u=1,A=l.z+l.w,w=o.z+o.w,v=-l.z+l.w,G=-o.z+o.w;if(A>=0&&w>=0&&v>=0&&G>=0)return true;else if(A<0&&w<0||v<0&&G<0)return false;else{if(A<0)x=Math.max(x,A/(A-w));else if(w<0)u=Math.min(u,A/(A-w));if(v<0)x=Math.max(x,v/(v-G));else if(G<0)u=Math.min(u,v/(v-G));if(u<x)return false;else{l.lerpSelf(o,x);o.lerpSelf(l,1-u);return true}}}var f,e,i=[],k,d,s,m=[],p,D,F=[],z,C,O=[],S=new THREE.Vector4,Q=new THREE.Vector4,q=new THREE.Matrix4,
h=new THREE.Matrix4,j=[],r=new THREE.Vector4,n=new THREE.Vector4,t;this.projectObjects=function(l,o,x){var u=[],A,w;e=0;q.multiply(o.projectionMatrix,o.matrix);j[0]=new THREE.Vector4(q.n41-q.n11,q.n42-q.n12,q.n43-q.n13,q.n44-q.n14);j[1]=new THREE.Vector4(q.n41+q.n11,q.n42+q.n12,q.n43+q.n13,q.n44+q.n14);j[2]=new THREE.Vector4(q.n41+q.n21,q.n42+q.n22,q.n43+q.n23,q.n44+q.n24);j[3]=new THREE.Vector4(q.n41-q.n21,q.n42-q.n22,q.n43-q.n23,q.n44-q.n24);j[4]=new THREE.Vector4(q.n41-q.n31,q.n42-q.n32,q.n43-
q.n33,q.n44-q.n34);j[5]=new THREE.Vector4(q.n41+q.n31,q.n42+q.n32,q.n43+q.n33,q.n44+q.n34);o=0;for(A=j.length;o<A;o++){w=j[o];w.divideScalar(Math.sqrt(w.x*w.x+w.y*w.y+w.z*w.z))}A=l.objects;l=0;for(o=A.length;l<o;l++){w=A[l];var v;if(!(v=!w.visible)){if(v=w instanceof THREE.Mesh){a:{v=void 0;for(var G=w.position,Z=-w.geometry.boundingSphere.radius*Math.max(w.scale.x,Math.max(w.scale.y,w.scale.z)),H=0;H<6;H++){v=j[H].x*G.x+j[H].y*G.y+j[H].z*G.z+j[H].w;if(v<=Z){v=false;break a}}v=true}v=!v}v=v}if(!v){f=
i[e]=i[e]||new THREE.RenderableObject;S.copy(w.position);q.multiplyVector3(S);f.object=w;f.z=S.z;u.push(f);e++}}x&&u.sort(a);return u};this.projectScene=function(l,o,x){var u=[],A=o.near,w=o.far,v,G,Z,H,T,V,I,M,R,K,J,X,W,E,P,Y;s=D=C=0;o.autoUpdateMatrix&&o.updateMatrix();q.multiply(o.projectionMatrix,o.matrix);V=this.projectObjects(l,o,true);l=0;for(v=V.length;l<v;l++){I=V[l].object;if(I.visible){I.autoUpdateMatrix&&I.updateMatrix();M=I.matrix;R=I.rotationMatrix;K=I.materials;J=I.overdraw;if(I instanceof
THREE.Mesh){X=I.geometry;W=X.vertices;G=0;for(Z=W.length;G<Z;G++){E=W[G];E.positionWorld.copy(E.position);M.multiplyVector3(E.positionWorld);H=E.positionScreen;H.copy(E.positionWorld);q.multiplyVector4(H);H.x/=H.w;H.y/=H.w;E.__visible=H.z>A&&H.z<w}X=X.faces;G=0;for(Z=X.length;G<Z;G++){E=X[G];if(E instanceof THREE.Face3){H=W[E.a];T=W[E.b];P=W[E.c];if(H.__visible&&T.__visible&&P.__visible)if(I.doubleSided||I.flipSided!=(P.positionScreen.x-H.positionScreen.x)*(T.positionScreen.y-H.positionScreen.y)-
(P.positionScreen.y-H.positionScreen.y)*(T.positionScreen.x-H.positionScreen.x)<0){k=m[s]=m[s]||new THREE.RenderableFace3;k.v1.positionWorld.copy(H.positionWorld);k.v2.positionWorld.copy(T.positionWorld);k.v3.positionWorld.copy(P.positionWorld);k.v1.positionScreen.copy(H.positionScreen);k.v2.positionScreen.copy(T.positionScreen);k.v3.positionScreen.copy(P.positionScreen);k.normalWorld.copy(E.normal);R.multiplyVector3(k.normalWorld);k.centroidWorld.copy(E.centroid);M.multiplyVector3(k.centroidWorld);
k.centroidScreen.copy(k.centroidWorld);q.multiplyVector3(k.centroidScreen);P=E.vertexNormals;t=k.vertexNormalsWorld;H=0;for(T=P.length;H<T;H++){Y=t[H]=t[H]||new THREE.Vector3;Y.copy(P[H]);R.multiplyVector3(Y)}k.z=k.centroidScreen.z;k.meshMaterials=K;k.faceMaterials=E.materials;k.overdraw=J;if(I.geometry.uvs[G]){k.uvs[0]=I.geometry.uvs[G][0];k.uvs[1]=I.geometry.uvs[G][1];k.uvs[2]=I.geometry.uvs[G][2]}u.push(k);s++}}else if(E instanceof THREE.Face4){H=W[E.a];T=W[E.b];P=W[E.c];Y=W[E.d];if(H.__visible&&
T.__visible&&P.__visible&&Y.__visible)if(I.doubleSided||I.flipSided!=((Y.positionScreen.x-H.positionScreen.x)*(T.positionScreen.y-H.positionScreen.y)-(Y.positionScreen.y-H.positionScreen.y)*(T.positionScreen.x-H.positionScreen.x)<0||(T.positionScreen.x-P.positionScreen.x)*(Y.positionScreen.y-P.positionScreen.y)-(T.positionScreen.y-P.positionScreen.y)*(Y.positionScreen.x-P.positionScreen.x)<0)){k=m[s]=m[s]||new THREE.RenderableFace3;k.v1.positionWorld.copy(H.positionWorld);k.v2.positionWorld.copy(T.positionWorld);
k.v3.positionWorld.copy(Y.positionWorld);k.v1.positionScreen.copy(H.positionScreen);k.v2.positionScreen.copy(T.positionScreen);k.v3.positionScreen.copy(Y.positionScreen);k.normalWorld.copy(E.normal);R.multiplyVector3(k.normalWorld);k.centroidWorld.copy(E.centroid);M.multiplyVector3(k.centroidWorld);k.centroidScreen.copy(k.centroidWorld);q.multiplyVector3(k.centroidScreen);k.z=k.centroidScreen.z;k.meshMaterials=K;k.faceMaterials=E.materials;k.overdraw=J;if(I.geometry.uvs[G]){k.uvs[0]=I.geometry.uvs[G][0];
k.uvs[1]=I.geometry.uvs[G][1];k.uvs[2]=I.geometry.uvs[G][3]}u.push(k);s++;d=m[s]=m[s]||new THREE.RenderableFace3;d.v1.positionWorld.copy(T.positionWorld);d.v2.positionWorld.copy(P.positionWorld);d.v3.positionWorld.copy(Y.positionWorld);d.v1.positionScreen.copy(T.positionScreen);d.v2.positionScreen.copy(P.positionScreen);d.v3.positionScreen.copy(Y.positionScreen);d.normalWorld.copy(k.normalWorld);d.centroidWorld.copy(k.centroidWorld);d.centroidScreen.copy(k.centroidScreen);d.z=d.centroidScreen.z;d.meshMaterials=
K;d.faceMaterials=E.materials;d.overdraw=J;if(I.geometry.uvs[G]){d.uvs[0]=I.geometry.uvs[G][1];d.uvs[1]=I.geometry.uvs[G][2];d.uvs[2]=I.geometry.uvs[G][3]}u.push(d);s++}}}}else if(I instanceof THREE.Line){h.multiply(q,M);W=I.geometry.vertices;E=W[0];E.positionScreen.copy(E.position);h.multiplyVector4(E.positionScreen);G=1;for(Z=W.length;G<Z;G++){H=W[G];H.positionScreen.copy(H.position);h.multiplyVector4(H.positionScreen);T=W[G-1];r.copy(H.positionScreen);n.copy(T.positionScreen);if(c(r,n)){r.multiplyScalar(1/
r.w);n.multiplyScalar(1/n.w);p=F[D]=F[D]||new THREE.RenderableLine;p.v1.positionScreen.copy(r);p.v2.positionScreen.copy(n);p.z=Math.max(r.z,n.z);p.materials=I.materials;u.push(p);D++}}}else if(I instanceof THREE.Particle){Q.set(I.position.x,I.position.y,I.position.z,1);q.multiplyVector4(Q);Q.z/=Q.w;if(Q.z>0&&Q.z<1){z=O[C]=O[C]||new THREE.RenderableParticle;z.x=Q.x/Q.w;z.y=Q.y/Q.w;z.z=Q.z;z.rotation=I.rotation.z;z.scale.x=I.scale.x*Math.abs(z.x-(Q.x+o.projectionMatrix.n11)/(Q.w+o.projectionMatrix.n14));
z.scale.y=I.scale.y*Math.abs(z.y-(Q.y+o.projectionMatrix.n22)/(Q.w+o.projectionMatrix.n24));z.materials=I.materials;u.push(z);C++}}}}x&&u.sort(a);return u};this.unprojectVector=function(l,o){var x=new THREE.Matrix4;x.multiply(THREE.Matrix4.makeInvert(o.matrix),THREE.Matrix4.makeInvert(o.projectionMatrix));x.multiplyVector3(l);return l}};
THREE.DOMRenderer=function(){THREE.Renderer.call(this);var a=null,c=new THREE.Projector,f,e,i,k;this.domElement=document.createElement("div");this.setSize=function(d,s){f=d;e=s;i=f/2;k=e/2};this.render=function(d,s){var m,p,D,F,z,C,O,S;a=c.projectScene(d,s);m=0;for(p=a.length;m<p;m++){z=a[m];if(z instanceof THREE.RenderableParticle){O=z.x*i+i;S=z.y*k+k;D=0;for(F=z.material.length;D<F;D++){C=z.material[D];if(C instanceof THREE.ParticleDOMMaterial){C=C.domElement;C.style.left=O+"px";C.style.top=S+"px"}}}}}};
THREE.CanvasRenderer=function(){function a(da){if(z!=da)p.globalAlpha=z=da}function c(da){if(C!=da){switch(da){case THREE.NormalBlending:p.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:p.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:p.globalCompositeOperation="darker"}C=da}}var f=null,e=new THREE.Projector,i=document.createElement("canvas"),k,d,s,m,p=i.getContext("2d"),D=null,F=null,z=1,C=0,O=null,S=null,Q=1,q,h,j,r,n,t,l,o,x,u=new THREE.Color,
A=new THREE.Color,w=new THREE.Color,v=new THREE.Color,G=new THREE.Color,Z,H,T,V,I,M,R,K,J,X=new THREE.Rectangle,W=new THREE.Rectangle,E=new THREE.Rectangle,P=false,Y=new THREE.Color,ga=new THREE.Color,oa=new THREE.Color,pa=new THREE.Color,Na=Math.PI*2,aa=new THREE.Vector3,ta,ua,Ea,ha,va,za,ra=16;ta=document.createElement("canvas");ta.width=ta.height=2;ua=ta.getContext("2d");ua.fillStyle="rgba(0,0,0,1)";ua.fillRect(0,0,2,2);Ea=ua.getImageData(0,0,2,2);ha=Ea.data;va=document.createElement("canvas");
va.width=va.height=ra;za=va.getContext("2d");za.translate(-ra/2,-ra/2);za.scale(ra,ra);ra--;this.domElement=i;this.sortElements=this.sortObjects=this.autoClear=true;this.setSize=function(da,na){k=da;d=na;s=k/2;m=d/2;i.width=k;i.height=d;X.set(-s,-m,s,m)};this.setClearColor=function(da,na){D=da!==null?new THREE.Color(da):null;F=na;W.set(-s,-m,s,m);p.setTransform(1,0,0,-1,s,m);this.clear()};this.clear=function(){if(!W.isEmpty()){W.inflate(1);W.minSelf(X);if(D!==null){c(THREE.NormalBlending);a(1);p.fillStyle=
"rgba("+Math.floor(D.r*255)+","+Math.floor(D.g*255)+","+Math.floor(D.b*255)+","+F+")";p.fillRect(W.getX(),W.getY(),W.getWidth(),W.getHeight())}else p.clearRect(W.getX(),W.getY(),W.getWidth(),W.getHeight());W.empty()}};this.render=function(da,na){function Oa(y){var U,N,B,L=y.lights;ga.setRGB(0,0,0);oa.setRGB(0,0,0);pa.setRGB(0,0,0);y=0;for(U=L.length;y<U;y++){N=L[y];B=N.color;if(N instanceof THREE.AmbientLight){ga.r+=B.r;ga.g+=B.g;ga.b+=B.b}else if(N instanceof THREE.DirectionalLight){oa.r+=B.r;oa.g+=
B.g;oa.b+=B.b}else if(N instanceof THREE.PointLight){pa.r+=B.r;pa.g+=B.g;pa.b+=B.b}}}function Aa(y,U,N,B){var L,$,ca,ea,fa=y.lights;y=0;for(L=fa.length;y<L;y++){$=fa[y];ca=$.color;ea=$.intensity;if($ instanceof THREE.DirectionalLight){$=N.dot($.position)*ea;if($>0){B.r+=ca.r*$;B.g+=ca.g*$;B.b+=ca.b*$}}else if($ instanceof THREE.PointLight){aa.sub($.position,U);aa.normalize();$=N.dot(aa)*ea;if($>0){B.r+=ca.r*$;B.g+=ca.g*$;B.b+=ca.b*$}}}}function Pa(y,U,N){if(N.opacity!=0){a(N.opacity);c(N.blending);
var B,L,$,ca,ea,fa;if(N instanceof THREE.ParticleBasicMaterial){if(N.map){ca=N.map;ea=ca.width>>1;fa=ca.height>>1;L=U.scale.x*s;$=U.scale.y*m;N=L*ea;B=$*fa;E.set(y.x-N,y.y-B,y.x+N,y.y+B);if(X.instersects(E)){p.save();p.translate(y.x,y.y);p.rotate(-U.rotation);p.scale(L,-$);p.translate(-ea,-fa);p.drawImage(ca,0,0);p.restore()}}}else if(N instanceof THREE.ParticleCircleMaterial){if(P){Y.r=ga.r+oa.r+pa.r;Y.g=ga.g+oa.g+pa.g;Y.b=ga.b+oa.b+pa.b;u.r=N.color.r*Y.r;u.g=N.color.g*Y.g;u.b=N.color.b*Y.b;u.updateStyleString()}else u.__styleString=
N.color.__styleString;N=U.scale.x*s;B=U.scale.y*m;E.set(y.x-N,y.y-B,y.x+N,y.y+B);if(X.instersects(E)){L=u.__styleString;if(S!=L)p.fillStyle=S=L;p.save();p.translate(y.x,y.y);p.rotate(-U.rotation);p.scale(N,B);p.beginPath();p.arc(0,0,1,0,Na,true);p.closePath();p.fill();p.restore()}}}}function Qa(y,U,N,B){if(B.opacity!=0){a(B.opacity);c(B.blending);p.beginPath();p.moveTo(y.positionScreen.x,y.positionScreen.y);p.lineTo(U.positionScreen.x,U.positionScreen.y);p.closePath();if(B instanceof THREE.LineBasicMaterial){u.__styleString=
B.color.__styleString;y=B.linewidth;if(Q!=y)p.lineWidth=Q=y;y=u.__styleString;if(O!=y)p.strokeStyle=O=y;p.stroke();E.inflate(B.linewidth*2)}}}function Ja(y,U,N,B,L,$){if(L.opacity!=0){a(L.opacity);c(L.blending);r=y.positionScreen.x;n=y.positionScreen.y;t=U.positionScreen.x;l=U.positionScreen.y;o=N.positionScreen.x;x=N.positionScreen.y;p.beginPath();p.moveTo(r,n);p.lineTo(t,l);p.lineTo(o,x);p.lineTo(r,n);p.closePath();if(L instanceof THREE.MeshBasicMaterial)if(L.map)L.map.image.loaded&&L.map.mapping instanceof
THREE.UVMapping&&wa(r,n,t,l,o,x,L.map.image,B.uvs[0].u,B.uvs[0].v,B.uvs[1].u,B.uvs[1].v,B.uvs[2].u,B.uvs[2].v);else if(L.env_map){if(L.env_map.image.loaded)if(L.env_map.mapping instanceof THREE.SphericalReflectionMapping){y=na.matrix;aa.copy(B.vertexNormalsWorld[0]);V=(aa.x*y.n11+aa.y*y.n12+aa.z*y.n13)*0.5+0.5;I=-(aa.x*y.n21+aa.y*y.n22+aa.z*y.n23)*0.5+0.5;aa.copy(B.vertexNormalsWorld[1]);M=(aa.x*y.n11+aa.y*y.n12+aa.z*y.n13)*0.5+0.5;R=-(aa.x*y.n21+aa.y*y.n22+aa.z*y.n23)*0.5+0.5;aa.copy(B.vertexNormalsWorld[2]);
K=(aa.x*y.n11+aa.y*y.n12+aa.z*y.n13)*0.5+0.5;J=-(aa.x*y.n21+aa.y*y.n22+aa.z*y.n23)*0.5+0.5;wa(r,n,t,l,o,x,L.env_map.image,V,I,M,R,K,J)}}else L.wireframe?Ba(L.color.__styleString,L.wireframe_linewidth):Ca(L.color.__styleString);else if(L instanceof THREE.MeshLambertMaterial){if(L.map&&!L.wireframe){L.map.mapping instanceof THREE.UVMapping&&wa(r,n,t,l,o,x,L.map.image,B.uvs[0].u,B.uvs[0].v,B.uvs[1].u,B.uvs[1].v,B.uvs[2].u,B.uvs[2].v);c(THREE.SubtractiveBlending)}if(P)if(!L.wireframe&&L.shading==THREE.SmoothShading&&
B.vertexNormalsWorld.length==3){A.r=w.r=v.r=ga.r;A.g=w.g=v.g=ga.g;A.b=w.b=v.b=ga.b;Aa($,B.v1.positionWorld,B.vertexNormalsWorld[0],A);Aa($,B.v2.positionWorld,B.vertexNormalsWorld[1],w);Aa($,B.v3.positionWorld,B.vertexNormalsWorld[2],v);G.r=(w.r+v.r)*0.5;G.g=(w.g+v.g)*0.5;G.b=(w.b+v.b)*0.5;T=Ka(A,w,v,G);wa(r,n,t,l,o,x,T,0,0,1,0,0,1)}else{Y.r=ga.r;Y.g=ga.g;Y.b=ga.b;Aa($,B.centroidWorld,B.normalWorld,Y);u.r=L.color.r*Y.r;u.g=L.color.g*Y.g;u.b=L.color.b*Y.b;u.updateStyleString();L.wireframe?Ba(u.__styleString,
L.wireframe_linewidth):Ca(u.__styleString)}else L.wireframe?Ba(L.color.__styleString,L.wireframe_linewidth):Ca(L.color.__styleString)}else if(L instanceof THREE.MeshDepthMaterial){Z=na.near;H=na.far;A.r=A.g=A.b=1-Fa(y.positionScreen.z,Z,H);w.r=w.g=w.b=1-Fa(U.positionScreen.z,Z,H);v.r=v.g=v.b=1-Fa(N.positionScreen.z,Z,H);G.r=(w.r+v.r)*0.5;G.g=(w.g+v.g)*0.5;G.b=(w.b+v.b)*0.5;T=Ka(A,w,v,G);wa(r,n,t,l,o,x,T,0,0,1,0,0,1)}else if(L instanceof THREE.MeshNormalMaterial){u.r=Ga(B.normalWorld.x);u.g=Ga(B.normalWorld.y);
u.b=Ga(B.normalWorld.z);u.updateStyleString();L.wireframe?Ba(u.__styleString,L.wireframe_linewidth):Ca(u.__styleString)}}}function Ba(y,U){if(O!=y)p.strokeStyle=O=y;if(Q!=U)p.lineWidth=Q=U;p.stroke();E.inflate(U*2)}function Ca(y){if(S!=y)p.fillStyle=S=y;p.fill()}function wa(y,U,N,B,L,$,ca,ea,fa,ka,ia,la,xa){var qa,ma;qa=ca.width-1;ma=ca.height-1;ea*=qa;fa*=ma;ka*=qa;ia*=ma;la*=qa;xa*=ma;N-=y;B-=U;L-=y;$-=U;ka-=ea;ia-=fa;la-=ea;xa-=fa;ma=1/(ka*xa-la*ia);qa=(xa*N-ia*L)*ma;ia=(xa*B-ia*$)*ma;N=(ka*L-
la*N)*ma;B=(ka*$-la*B)*ma;y=y-qa*ea-N*fa;U=U-ia*ea-B*fa;p.save();p.transform(qa,ia,N,B,y,U);p.clip();p.drawImage(ca,0,0);p.restore()}function Ka(y,U,N,B){var L=~~(y.r*255),$=~~(y.g*255);y=~~(y.b*255);var ca=~~(U.r*255),ea=~~(U.g*255);U=~~(U.b*255);var fa=~~(N.r*255),ka=~~(N.g*255);N=~~(N.b*255);var ia=~~(B.r*255),la=~~(B.g*255);B=~~(B.b*255);ha[0]=L<0?0:L>255?255:L;ha[1]=$<0?0:$>255?255:$;ha[2]=y<0?0:y>255?255:y;ha[4]=ca<0?0:ca>255?255:ca;ha[5]=ea<0?0:ea>255?255:ea;ha[6]=U<0?0:U>255?255:U;ha[8]=fa<
0?0:fa>255?255:fa;ha[9]=ka<0?0:ka>255?255:ka;ha[10]=N<0?0:N>255?255:N;ha[12]=ia<0?0:ia>255?255:ia;ha[13]=la<0?0:la>255?255:la;ha[14]=B<0?0:B>255?255:B;ua.putImageData(Ea,0,0);za.drawImage(ta,0,0);return va}function Fa(y,U,N){y=(y-U)/(N-U);return y*y*(3-2*y)}function Ga(y){y=(y+1)*0.5;return y<0?0:y>1?1:y}function Ha(y,U){var N=U.x-y.x,B=U.y-y.y,L=1/Math.sqrt(N*N+B*B);N*=L;B*=L;U.x+=N;U.y+=B;y.x-=N;y.y-=B}var Da,La,ba,ja,sa,Ia,Ma,ya;p.setTransform(1,0,0,-1,s,m);this.autoClear&&this.clear();f=e.projectScene(da,
na,this.sortElements);(P=da.lights.length>0)&&Oa(da);Da=0;for(La=f.length;Da<La;Da++){ba=f[Da];E.empty();if(ba instanceof THREE.RenderableParticle){q=ba;q.x*=s;q.y*=m;ja=0;for(sa=ba.materials.length;ja<sa;ja++)Pa(q,ba,ba.materials[ja],da)}else if(ba instanceof THREE.RenderableLine){q=ba.v1;h=ba.v2;q.positionScreen.x*=s;q.positionScreen.y*=m;h.positionScreen.x*=s;h.positionScreen.y*=m;E.addPoint(q.positionScreen.x,q.positionScreen.y);E.addPoint(h.positionScreen.x,h.positionScreen.y);if(X.instersects(E)){ja=
0;for(sa=ba.materials.length;ja<sa;)Qa(q,h,ba,ba.materials[ja++],da)}}else if(ba instanceof THREE.RenderableFace3){q=ba.v1;h=ba.v2;j=ba.v3;q.positionScreen.x*=s;q.positionScreen.y*=m;h.positionScreen.x*=s;h.positionScreen.y*=m;j.positionScreen.x*=s;j.positionScreen.y*=m;if(ba.overdraw){Ha(q.positionScreen,h.positionScreen);Ha(h.positionScreen,j.positionScreen);Ha(j.positionScreen,q.positionScreen)}E.add3Points(q.positionScreen.x,q.positionScreen.y,h.positionScreen.x,h.positionScreen.y,j.positionScreen.x,
j.positionScreen.y);if(X.instersects(E)){ja=0;for(sa=ba.meshMaterials.length;ja<sa;){ya=ba.meshMaterials[ja++];if(ya instanceof THREE.MeshFaceMaterial){Ia=0;for(Ma=ba.faceMaterials.length;Ia<Ma;)(ya=ba.faceMaterials[Ia++])&&Ja(q,h,j,ba,ya,da)}else Ja(q,h,j,ba,ya,da)}}}W.addRectangle(E)}p.setTransform(1,0,0,1,0,0)}};
THREE.SVGRenderer=function(){function a(V,I,M){var R,K,J,X;R=0;for(K=V.lights.length;R<K;R++){J=V.lights[R];if(J instanceof THREE.DirectionalLight){X=I.normalWorld.dot(J.position)*J.intensity;if(X>0){M.r+=J.color.r*X;M.g+=J.color.g*X;M.b+=J.color.b*X}}else if(J instanceof THREE.PointLight){x.sub(J.position,I.centroidWorld);x.normalize();X=I.normalWorld.dot(x)*J.intensity;if(X>0){M.r+=J.color.r*X;M.g+=J.color.g*X;M.b+=J.color.b*X}}}}function c(V,I,M,R,K,J){v=e(G++);v.setAttribute("d","M "+V.positionScreen.x+
" "+V.positionScreen.y+" L "+I.positionScreen.x+" "+I.positionScreen.y+" L "+M.positionScreen.x+","+M.positionScreen.y+"z");if(K instanceof THREE.MeshBasicMaterial)j.__styleString=K.color.__styleString;else if(K instanceof THREE.MeshLambertMaterial)if(h){r.r=n.r;r.g=n.g;r.b=n.b;a(J,R,r);j.r=K.color.r*r.r;j.g=K.color.g*r.g;j.b=K.color.b*r.b;j.updateStyleString()}else j.__styleString=K.color.__styleString;else if(K instanceof THREE.MeshDepthMaterial){o=1-K.__2near/(K.__farPlusNear-R.z*K.__farMinusNear);
j.setRGB(o,o,o)}else K instanceof THREE.MeshNormalMaterial&&j.setRGB(i(R.normalWorld.x),i(R.normalWorld.y),i(R.normalWorld.z));K.wireframe?v.setAttribute("style","fill: none; stroke: "+j.__styleString+"; stroke-width: "+K.wireframe_linewidth+"; stroke-opacity: "+K.opacity+"; stroke-linecap: "+K.wireframe_linecap+"; stroke-linejoin: "+K.wireframe_linejoin):v.setAttribute("style","fill: "+j.__styleString+"; fill-opacity: "+K.opacity);s.appendChild(v)}function f(V,I,M,R,K,J,X){v=e(G++);v.setAttribute("d",
"M "+V.positionScreen.x+" "+V.positionScreen.y+" L "+I.positionScreen.x+" "+I.positionScreen.y+" L "+M.positionScreen.x+","+M.positionScreen.y+" L "+R.positionScreen.x+","+R.positionScreen.y+"z");if(J instanceof THREE.MeshBasicMaterial)j.__styleString=J.color.__styleString;else if(J instanceof THREE.MeshLambertMaterial)if(h){r.r=n.r;r.g=n.g;r.b=n.b;a(X,K,r);j.r=J.color.r*r.r;j.g=J.color.g*r.g;j.b=J.color.b*r.b;j.updateStyleString()}else j.__styleString=J.color.__styleString;else if(J instanceof THREE.MeshDepthMaterial){o=
1-J.__2near/(J.__farPlusNear-K.z*J.__farMinusNear);j.setRGB(o,o,o)}else J instanceof THREE.MeshNormalMaterial&&j.setRGB(i(K.normalWorld.x),i(K.normalWorld.y),i(K.normalWorld.z));J.wireframe?v.setAttribute("style","fill: none; stroke: "+j.__styleString+"; stroke-width: "+J.wireframe_linewidth+"; stroke-opacity: "+J.opacity+"; stroke-linecap: "+J.wireframe_linecap+"; stroke-linejoin: "+J.wireframe_linejoin):v.setAttribute("style","fill: "+j.__styleString+"; fill-opacity: "+J.opacity);s.appendChild(v)}
function e(V){if(u[V]==null){u[V]=document.createElementNS("http://www.w3.org/2000/svg","path");T==0&&u[V].setAttribute("shape-rendering","crispEdges");return u[V]}return u[V]}function i(V){return V<0?Math.min((1+V)*0.5,0.5):0.5+Math.min(V*0.5,0.5)}var k=null,d=new THREE.Projector,s=document.createElementNS("http://www.w3.org/2000/svg","svg"),m,p,D,F,z,C,O,S,Q=new THREE.Rectangle,q=new THREE.Rectangle,h=false,j=new THREE.Color(16777215),r=new THREE.Color(16777215),n=new THREE.Color(0),t=new THREE.Color(0),
l=new THREE.Color(0),o,x=new THREE.Vector3,u=[],A=[],w=[],v,G,Z,H,T=1;this.domElement=s;this.sortElements=this.sortObjects=this.autoClear=true;this.setQuality=function(V){switch(V){case "high":T=1;break;case "low":T=0}};this.setSize=function(V,I){m=V;p=I;D=m/2;F=p/2;s.setAttribute("viewBox",-D+" "+-F+" "+m+" "+p);s.setAttribute("width",m);s.setAttribute("height",p);Q.set(-D,-F,D,F)};this.clear=function(){for(;s.childNodes.length>0;)s.removeChild(s.childNodes[0])};this.render=function(V,I){var M,R,
K,J,X,W,E,P;this.autoClear&&this.clear();k=d.projectScene(V,I,this.sortElements);H=Z=G=0;if(h=V.lights.length>0){E=V.lights;n.setRGB(0,0,0);t.setRGB(0,0,0);l.setRGB(0,0,0);M=0;for(R=E.length;M<R;M++){K=E[M];J=K.color;if(K instanceof THREE.AmbientLight){n.r+=J.r;n.g+=J.g;n.b+=J.b}else if(K instanceof THREE.DirectionalLight){t.r+=J.r;t.g+=J.g;t.b+=J.b}else if(K instanceof THREE.PointLight){l.r+=J.r;l.g+=J.g;l.b+=J.b}}}M=0;for(R=k.length;M<R;M++){E=k[M];q.empty();if(E instanceof THREE.RenderableParticle){z=
E;z.x*=D;z.y*=-F;K=0;for(J=E.materials.length;K<J;K++)if(P=E.materials[K]){X=z;W=E;P=P;var Y=Z++;if(A[Y]==null){A[Y]=document.createElementNS("http://www.w3.org/2000/svg","circle");T==0&&A[Y].setAttribute("shape-rendering","crispEdges")}v=A[Y];v.setAttribute("cx",X.x);v.setAttribute("cy",X.y);v.setAttribute("r",W.scale.x*D);if(P instanceof THREE.ParticleCircleMaterial){if(h){r.r=n.r+t.r+l.r;r.g=n.g+t.g+l.g;r.b=n.b+t.b+l.b;j.r=P.color.r*r.r;j.g=P.color.g*r.g;j.b=P.color.b*r.b;j.updateStyleString()}else j=
P.color;v.setAttribute("style","fill: "+j.__styleString)}s.appendChild(v)}}else if(E instanceof THREE.RenderableLine){z=E.v1;C=E.v2;z.positionScreen.x*=D;z.positionScreen.y*=-F;C.positionScreen.x*=D;C.positionScreen.y*=-F;q.addPoint(z.positionScreen.x,z.positionScreen.y);q.addPoint(C.positionScreen.x,C.positionScreen.y);if(Q.instersects(q)){K=0;for(J=E.materials.length;K<J;)if(P=E.materials[K++]){X=z;W=C;P=P;Y=H++;if(w[Y]==null){w[Y]=document.createElementNS("http://www.w3.org/2000/svg","line");T==
0&&w[Y].setAttribute("shape-rendering","crispEdges")}v=w[Y];v.setAttribute("x1",X.positionScreen.x);v.setAttribute("y1",X.positionScreen.y);v.setAttribute("x2",W.positionScreen.x);v.setAttribute("y2",W.positionScreen.y);if(P instanceof THREE.LineBasicMaterial){j.__styleString=P.color.__styleString;v.setAttribute("style","fill: none; stroke: "+j.__styleString+"; stroke-width: "+P.linewidth+"; stroke-opacity: "+P.opacity+"; stroke-linecap: "+P.linecap+"; stroke-linejoin: "+P.linejoin);s.appendChild(v)}}}}else if(E instanceof
THREE.RenderableFace3){z=E.v1;C=E.v2;O=E.v3;z.positionScreen.x*=D;z.positionScreen.y*=-F;C.positionScreen.x*=D;C.positionScreen.y*=-F;O.positionScreen.x*=D;O.positionScreen.y*=-F;q.addPoint(z.positionScreen.x,z.positionScreen.y);q.addPoint(C.positionScreen.x,C.positionScreen.y);q.addPoint(O.positionScreen.x,O.positionScreen.y);if(Q.instersects(q)){K=0;for(J=E.meshMaterials.length;K<J;){P=E.meshMaterials[K++];if(P instanceof THREE.MeshFaceMaterial){X=0;for(W=E.faceMaterials.length;X<W;)(P=E.faceMaterials[X++])&&
c(z,C,O,E,P,V)}else P&&c(z,C,O,E,P,V)}}}else if(E instanceof THREE.RenderableFace4){z=E.v1;C=E.v2;O=E.v3;S=E.v4;z.positionScreen.x*=D;z.positionScreen.y*=-F;C.positionScreen.x*=D;C.positionScreen.y*=-F;O.positionScreen.x*=D;O.positionScreen.y*=-F;S.positionScreen.x*=D;S.positionScreen.y*=-F;q.addPoint(z.positionScreen.x,z.positionScreen.y);q.addPoint(C.positionScreen.x,C.positionScreen.y);q.addPoint(O.positionScreen.x,O.positionScreen.y);q.addPoint(S.positionScreen.x,S.positionScreen.y);if(Q.instersects(q)){K=
0;for(J=E.meshMaterials.length;K<J;){P=E.meshMaterials[K++];if(P instanceof THREE.MeshFaceMaterial){X=0;for(W=E.faceMaterials.length;X<W;)(P=E.faceMaterials[X++])&&f(z,C,O,S,E,P,V)}else P&&f(z,C,O,S,E,P,V)}}}}}};
THREE.WebGLRenderer=function(a){function c(h,j){h.fragment_shader=j.fragment_shader;h.vertex_shader=j.vertex_shader;h.uniforms=Uniforms.clone(j.uniforms)}function f(h,j){h.uniforms.color.value.setRGB(h.color.r*h.opacity,h.color.g*h.opacity,h.color.b*h.opacity);h.uniforms.opacity.value=h.opacity;h.uniforms.map.texture=h.map;h.uniforms.env_map.texture=h.env_map;h.uniforms.reflectivity.value=h.reflectivity;h.uniforms.refraction_ratio.value=h.refraction_ratio;h.uniforms.combine.value=h.combine;h.uniforms.useRefract.value=
h.env_map&&h.env_map.mapping instanceof THREE.CubeRefractionMapping;if(j){h.uniforms.fogColor.value.setHex(j.color.hex);if(j instanceof THREE.Fog){h.uniforms.fogNear.value=j.near;h.uniforms.fogFar.value=j.far}else if(j instanceof THREE.FogExp2)h.uniforms.fogDensity.value=j.density}}function e(h,j){var r;if(h=="fragment")r=d.createShader(d.FRAGMENT_SHADER);else if(h=="vertex")r=d.createShader(d.VERTEX_SHADER);d.shaderSource(r,j);d.compileShader(r);if(!d.getShaderParameter(r,d.COMPILE_STATUS)){alert(d.getShaderInfoLog(r));
return null}return r}function i(h){switch(h){case THREE.RepeatWrapping:return d.REPEAT;case THREE.ClampToEdgeWrapping:return d.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return d.MIRRORED_REPEAT;case THREE.NearestFilter:return d.NEAREST;case THREE.NearestMipMapNearestFilter:return d.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return d.NEAREST_MIPMAP_LINEAR;case THREE.LinearFilter:return d.LINEAR;case THREE.LinearMipMapNearestFilter:return d.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return d.LINEAR_MIPMAP_LINEAR}return 0}
var k=document.createElement("canvas"),d,s=null,m=new THREE.Matrix4,p,D=new Float32Array(16),F=new Float32Array(16),z=new Float32Array(16),C=new Float32Array(9),O=new Float32Array(16),S=true,Q=new THREE.Color(0),q=0;if(a){if(a.antialias!==undefined)S=a.antialias;a.clearColor!==undefined&&Q.setHex(a.clearColor);if(a.clearAlpha!==undefined)q=a.clearAlpha}this.domElement=k;this.autoClear=true;(function(h,j,r){try{d=k.getContext("experimental-webgl",{antialias:h})}catch(n){}if(!d){alert("WebGL not supported");
throw"cannot create webgl context";}d.clearColor(0,0,0,1);d.clearDepth(1);d.enable(d.DEPTH_TEST);d.depthFunc(d.LEQUAL);d.frontFace(d.CCW);d.cullFace(d.BACK);d.enable(d.CULL_FACE);d.enable(d.BLEND);d.blendFunc(d.ONE,d.ONE_MINUS_SRC_ALPHA);d.clearColor(j.r,j.g,j.b,r)})(S,Q,q);this.setSize=function(h,j){k.width=h;k.height=j;d.viewport(0,0,k.width,k.height)};this.setClearColor=function(h,j){var r=new THREE.Color(h);d.clearColor(r.r,r.g,r.b,j)};this.clear=function(){d.clear(d.COLOR_BUFFER_BIT|d.DEPTH_BUFFER_BIT)};
this.setupLights=function(h,j){var r,n,t,l=g=b=0,o=[],x=[],u=[],A=[];r=0;for(n=j.length;r<n;r++){t=j[r];if(t instanceof THREE.AmbientLight){l+=t.color.r;g+=t.color.g;b+=t.color.b}else if(t instanceof THREE.DirectionalLight){o.push(t.color.r*t.intensity,t.color.g*t.intensity,t.color.b*t.intensity);x.push(t.position.x,t.position.y,t.position.z)}else if(t instanceof THREE.PointLight){u.push(t.color.r*t.intensity,t.color.g*t.intensity,t.color.b*t.intensity);A.push(t.position.x,t.position.y,t.position.z)}}return{ambient:[l,
g,b],directional:{colors:o,positions:x},point:{colors:u,positions:A}}};this.createBuffers=function(h,j){var r,n,t,l,o,x,u,A,w,v,G=[],Z=[],H=[],T=[],V=[],I=[],M=0,R=h.geometry.geometryChunks[j],K;o=false;r=0;for(n=h.materials.length;r<n;r++){x=h.materials[r];if(x instanceof THREE.MeshFaceMaterial){x=0;for(K=R.materials.length;x<K;x++)if(R.materials[x]&&R.materials[x].shading!=undefined&&R.materials[x].shading==THREE.SmoothShading){o=true;break}}else if(x&&x.shading!=undefined&&x.shading==THREE.SmoothShading){o=
true;break}if(o)break}K=o;r=0;for(n=R.faces.length;r<n;r++){t=R.faces[r];l=h.geometry.faces[t];o=l.vertexNormals;x=l.normal;t=h.geometry.uvs[t];if(l instanceof THREE.Face3){u=h.geometry.vertices[l.a].position;A=h.geometry.vertices[l.b].position;w=h.geometry.vertices[l.c].position;H.push(u.x,u.y,u.z,A.x,A.y,A.z,w.x,w.y,w.z);if(h.geometry.hasTangents){u=h.geometry.vertices[l.a].tangent;A=h.geometry.vertices[l.b].tangent;w=h.geometry.vertices[l.c].tangent;V.push(u.x,u.y,u.z,u.w,A.x,A.y,A.z,A.w,w.x,w.y,
w.z,w.w)}if(o.length==3&&K)for(l=0;l<3;l++)T.push(o[l].x,o[l].y,o[l].z);else for(l=0;l<3;l++)T.push(x.x,x.y,x.z);if(t)for(l=0;l<3;l++)I.push(t[l].u,t[l].v);G.push(M,M+1,M+2);Z.push(M,M+1,M,M+2,M+1,M+2);M+=3}else if(l instanceof THREE.Face4){u=h.geometry.vertices[l.a].position;A=h.geometry.vertices[l.b].position;w=h.geometry.vertices[l.c].position;v=h.geometry.vertices[l.d].position;H.push(u.x,u.y,u.z,A.x,A.y,A.z,w.x,w.y,w.z,v.x,v.y,v.z);if(h.geometry.hasTangents){u=h.geometry.vertices[l.a].tangent;
A=h.geometry.vertices[l.b].tangent;w=h.geometry.vertices[l.c].tangent;l=h.geometry.vertices[l.d].tangent;V.push(u.x,u.y,u.z,u.w,A.x,A.y,A.z,A.w,w.x,w.y,w.z,w.w,l.x,l.y,l.z,l.w)}if(o.length==4&&K)for(l=0;l<4;l++)T.push(o[l].x,o[l].y,o[l].z);else for(l=0;l<4;l++)T.push(x.x,x.y,x.z);if(t)for(l=0;l<4;l++)I.push(t[l].u,t[l].v);G.push(M,M+1,M+2,M,M+2,M+3);Z.push(M,M+1,M,M+2,M,M+3,M+1,M+2,M+2,M+3);M+=4}}if(H.length){R.__webGLVertexBuffer=d.createBuffer();d.bindBuffer(d.ARRAY_BUFFER,R.__webGLVertexBuffer);
d.bufferData(d.ARRAY_BUFFER,new Float32Array(H),d.STATIC_DRAW);R.__webGLNormalBuffer=d.createBuffer();d.bindBuffer(d.ARRAY_BUFFER,R.__webGLNormalBuffer);d.bufferData(d.ARRAY_BUFFER,new Float32Array(T),d.STATIC_DRAW);if(h.geometry.hasTangents){R.__webGLTangentBuffer=d.createBuffer();d.bindBuffer(d.ARRAY_BUFFER,R.__webGLTangentBuffer);d.bufferData(d.ARRAY_BUFFER,new Float32Array(V),d.STATIC_DRAW)}if(I.length>0){R.__webGLUVBuffer=d.createBuffer();d.bindBuffer(d.ARRAY_BUFFER,R.__webGLUVBuffer);d.bufferData(d.ARRAY_BUFFER,
new Float32Array(I),d.STATIC_DRAW)}R.__webGLFaceBuffer=d.createBuffer();d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,R.__webGLFaceBuffer);d.bufferData(d.ELEMENT_ARRAY_BUFFER,new Uint16Array(G),d.STATIC_DRAW);R.__webGLLineBuffer=d.createBuffer();d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,R.__webGLLineBuffer);d.bufferData(d.ELEMENT_ARRAY_BUFFER,new Uint16Array(Z),d.STATIC_DRAW);R.__webGLFaceCount=G.length;R.__webGLLineCount=Z.length}};this.renderBuffer=function(h,j,r,n,t){var l,o,x,u;if(!n.program){if(n instanceof
THREE.MeshDepthMaterial){c(n,THREE.ShaderLib.depth);n.uniforms.mNear.value=h.near;n.uniforms.mFar.value=h.far}else if(n instanceof THREE.MeshNormalMaterial)c(n,THREE.ShaderLib.normal);else if(n instanceof THREE.MeshBasicMaterial){c(n,THREE.ShaderLib.basic);f(n,r)}else if(n instanceof THREE.MeshLambertMaterial){c(n,THREE.ShaderLib.lambert);f(n,r)}else if(n instanceof THREE.MeshPhongMaterial){c(n,THREE.ShaderLib.phong);f(n,r)}if(scene){var A,w,v;A=u=o=0;for(w=j.length;A<w;A++){v=j[A];v instanceof THREE.DirectionalLight&&
u++;v instanceof THREE.PointLight&&o++}if(o+u<=4){A=u;o=o}else{A=Math.ceil(4*u/(o+u));o=4-A}o={directional:A,point:o}}else o={directional:1,point:3};u={fog:r,map:n.map,env_map:n.env_map,maxDirLights:o.directional,maxPointLights:o.point};o=n.fragment_shader;A=n.vertex_shader;w=d.createProgram();v=["#ifdef GL_ES\nprecision highp float;\n#endif","#define MAX_DIR_LIGHTS "+u.maxDirLights,"#define MAX_POINT_LIGHTS "+u.maxPointLights,u.fog?"#define USE_FOG":"",u.fog instanceof THREE.FogExp2?"#define FOG_EXP2":
"",u.map?"#define USE_MAP":"",u.env_map?"#define USE_ENVMAP":"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");u=[d.getParameter(d.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0?"#define VERTEX_TEXTURES":"","#define MAX_DIR_LIGHTS "+u.maxDirLights,"#define MAX_POINT_LIGHTS "+u.maxPointLights,u.map?"#define USE_MAP":"",u.env_map?"#define USE_ENVMAP":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\n"].join("\n");
d.attachShader(w,e("fragment",v+o));d.attachShader(w,e("vertex",u+A));d.linkProgram(w);d.getProgramParameter(w,d.LINK_STATUS)||alert("Could not initialise shaders\nVALIDATE_STATUS: "+d.getProgramParameter(w,d.VALIDATE_STATUS)+", gl error ["+d.getError()+"]");w.uniforms={};w.attributes={};n.program=w;o=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition"];for(l in n.uniforms)o.push(l);l=n.program;A=0;for(w=o.length;A<w;A++){v=o[A];l.uniforms[v]=d.getUniformLocation(l,
v)}l=n.program;o=["position","normal","uv","tangent"];A=0;for(w=o.length;A<w;A++){v=o[A];l.attributes[v]=d.getAttribLocation(l,v)}}l=n.program;if(l!=s){d.useProgram(l);s=l}this.loadCamera(l,h);this.loadMatrices(l);if(n instanceof THREE.MeshPhongMaterial||n instanceof THREE.MeshLambertMaterial){h=this.setupLights(l,j);n.uniforms.enableLighting.value=h.directional.positions.length+h.point.positions.length;n.uniforms.ambientLightColor.value=h.ambient;n.uniforms.directionalLightColor.value=h.directional.colors;
n.uniforms.directionalLightDirection.value=h.directional.positions;n.uniforms.pointLightColor.value=h.point.colors;n.uniforms.pointLightPosition.value=h.point.positions}if(n instanceof THREE.MeshBasicMaterial||n instanceof THREE.MeshLambertMaterial||n instanceof THREE.MeshPhongMaterial)f(n,r);if(n instanceof THREE.MeshPhongMaterial){n.uniforms.ambient.value.setRGB(n.ambient.r,n.ambient.g,n.ambient.b);n.uniforms.specular.value.setRGB(n.specular.r,n.specular.g,n.specular.b);n.uniforms.shininess.value=
n.shininess}r=n.uniforms;for(x in r){j=r[x].type;h=r[x].value;o=l.uniforms[x];if(j=="i")d.uniform1i(o,h);else if(j=="f")d.uniform1f(o,h);else if(j=="fv")d.uniform3fv(o,h);else if(j=="v2")d.uniform2f(o,h.x,h.y);else if(j=="v3")d.uniform3f(o,h.x,h.y,h.z);else if(j=="c")d.uniform3f(o,h.r,h.g,h.b);else if(j=="t"){d.uniform1i(o,h);if(j=r[x].texture)if(j.image instanceof Array&&j.image.length==6){j=j;h=h;if(j.image.length==6){if(!j.image.__webGLTextureCube&&!j.image.__cubeMapInitialized&&j.image.loadCount==
6){j.image.__webGLTextureCube=d.createTexture();d.bindTexture(d.TEXTURE_CUBE_MAP,j.image.__webGLTextureCube);d.texParameteri(d.TEXTURE_CUBE_MAP,d.TEXTURE_WRAP_S,d.CLAMP_TO_EDGE);d.texParameteri(d.TEXTURE_CUBE_MAP,d.TEXTURE_WRAP_T,d.CLAMP_TO_EDGE);d.texParameteri(d.TEXTURE_CUBE_MAP,d.TEXTURE_MAG_FILTER,d.LINEAR);d.texParameteri(d.TEXTURE_CUBE_MAP,d.TEXTURE_MIN_FILTER,d.LINEAR_MIPMAP_LINEAR);for(o=0;o<6;++o)d.texImage2D(d.TEXTURE_CUBE_MAP_POSITIVE_X+o,0,d.RGBA,d.RGBA,d.UNSIGNED_BYTE,j.image[o]);d.generateMipmap(d.TEXTURE_CUBE_MAP);
d.bindTexture(d.TEXTURE_CUBE_MAP,null);j.image.__cubeMapInitialized=true}d.activeTexture(d.TEXTURE0+h);d.bindTexture(d.TEXTURE_CUBE_MAP,j.image.__webGLTextureCube)}}else{j=j;h=h;if(!j.__webGLTexture&&j.image.loaded){j.__webGLTexture=d.createTexture();d.bindTexture(d.TEXTURE_2D,j.__webGLTexture);d.texImage2D(d.TEXTURE_2D,0,d.RGBA,d.RGBA,d.UNSIGNED_BYTE,j.image);d.texParameteri(d.TEXTURE_2D,d.TEXTURE_WRAP_S,i(j.wrap_s));d.texParameteri(d.TEXTURE_2D,d.TEXTURE_WRAP_T,i(j.wrap_t));d.texParameteri(d.TEXTURE_2D,
d.TEXTURE_MAG_FILTER,i(j.mag_filter));d.texParameteri(d.TEXTURE_2D,d.TEXTURE_MIN_FILTER,i(j.min_filter));d.generateMipmap(d.TEXTURE_2D);d.bindTexture(d.TEXTURE_2D,null)}d.activeTexture(d.TEXTURE0+h);d.bindTexture(d.TEXTURE_2D,j.__webGLTexture)}}}x=l.attributes;d.bindBuffer(d.ARRAY_BUFFER,t.__webGLVertexBuffer);d.vertexAttribPointer(x.position,3,d.FLOAT,false,0,0);d.enableVertexAttribArray(x.position);if(x.normal>=0){d.bindBuffer(d.ARRAY_BUFFER,t.__webGLNormalBuffer);d.vertexAttribPointer(x.normal,
3,d.FLOAT,false,0,0);d.enableVertexAttribArray(x.normal)}if(x.tangent>=0){d.bindBuffer(d.ARRAY_BUFFER,t.__webGLTangentBuffer);d.vertexAttribPointer(x.tangent,4,d.FLOAT,false,0,0);d.enableVertexAttribArray(x.tangent)}if(x.uv>=0)if(t.__webGLUVBuffer){d.bindBuffer(d.ARRAY_BUFFER,t.__webGLUVBuffer);d.vertexAttribPointer(x.uv,2,d.FLOAT,false,0,0);d.enableVertexAttribArray(x.uv)}else d.disableVertexAttribArray(x.uv);if(n.wireframe){d.lineWidth(n.wireframe_linewidth);d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,
t.__webGLLineBuffer);d.drawElements(d.LINES,t.__webGLLineCount,d.UNSIGNED_SHORT,0)}else{d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,t.__webGLFaceBuffer);d.drawElements(d.TRIANGLES,t.__webGLFaceCount,d.UNSIGNED_SHORT,0)}};this.renderPass=function(h,j,r,n,t,l,o){var x,u,A,w,v;A=0;for(w=n.materials.length;A<w;A++){x=n.materials[A];if(x instanceof THREE.MeshFaceMaterial){x=0;for(u=t.materials.length;x<u;x++)if((v=t.materials[x])&&v.blending==l&&v.opacity<1==o){this.setBlending(v.blending);this.renderBuffer(h,
j,r,v,t)}}else if((v=x)&&v.blending==l&&v.opacity<1==o){this.setBlending(v.blending);this.renderBuffer(h,j,r,v,t)}}};this.render=function(h,j){var r,n,t,l,o=h.lights,x=h.fog;this.initWebGLObjects(h);this.autoClear&&this.clear();j.autoUpdateMatrix&&j.updateMatrix();D.set(j.matrix.flatten());z.set(j.projectionMatrix.flatten());r=0;for(n=h.__webGLObjects.length;r<n;r++){t=h.__webGLObjects[r];l=t.object;t=t.buffer;if(l.visible){this.setupMatrices(l,j);this.renderPass(j,o,x,l,t,THREE.NormalBlending,false)}}r=
0;for(n=h.__webGLObjects.length;r<n;r++){t=h.__webGLObjects[r];l=t.object;t=t.buffer;if(l.visible){this.setupMatrices(l,j);this.renderPass(j,o,x,l,t,THREE.AdditiveBlending,false);this.renderPass(j,o,x,l,t,THREE.SubtractiveBlending,false);this.renderPass(j,o,x,l,t,THREE.AdditiveBlending,true);this.renderPass(j,o,x,l,t,THREE.SubtractiveBlending,true);this.renderPass(j,o,x,l,t,THREE.NormalBlending,true)}}};this.initWebGLObjects=function(h){var j,r,n,t,l,o;if(!h.__webGLObjects){h.__webGLObjects=[];h.__webGLObjectsMap=
{}}j=0;for(r=h.objects.length;j<r;j++){n=h.objects[j];if(h.__webGLObjectsMap[n.id]==undefined)h.__webGLObjectsMap[n.id]={};o=h.__webGLObjectsMap[n.id];if(n instanceof THREE.Mesh)for(l in n.geometry.geometryChunks){t=n.geometry.geometryChunks[l];t.__webGLVertexBuffer||this.createBuffers(n,l);if(o[l]==undefined){t={buffer:t,object:n};h.__webGLObjects.push(t);o[l]=1}}}};this.removeObject=function(h,j){var r,n;for(r=h.__webGLObjects.length-1;r>=0;r--){n=h.__webGLObjects[r].object;j==n&&h.__webGLObjects.splice(r,
1)}};this.setupMatrices=function(h,j){h.autoUpdateMatrix&&h.updateMatrix();m.multiply(j.matrix,h.matrix);F.set(m.flatten());p=THREE.Matrix4.makeInvert3x3(m).transpose();C.set(p.m);O.set(h.matrix.flatten())};this.loadMatrices=function(h){d.uniformMatrix4fv(h.uniforms.viewMatrix,false,D);d.uniformMatrix4fv(h.uniforms.modelViewMatrix,false,F);d.uniformMatrix4fv(h.uniforms.projectionMatrix,false,z);d.uniformMatrix3fv(h.uniforms.normalMatrix,false,C);d.uniformMatrix4fv(h.uniforms.objectMatrix,false,O)};
this.loadCamera=function(h,j){d.uniform3f(h.uniforms.cameraPosition,j.position.x,j.position.y,j.position.z)};this.setBlending=function(h){switch(h){case THREE.AdditiveBlending:d.blendEquation(d.FUNC_ADD);d.blendFunc(d.ONE,d.ONE);break;case THREE.SubtractiveBlending:d.blendFunc(d.DST_COLOR,d.ZERO);break;default:d.blendEquation(d.FUNC_ADD);d.blendFunc(d.ONE,d.ONE_MINUS_SRC_ALPHA)}};this.setFaceCulling=function(h,j){if(h){!j||j=="ccw"?d.frontFace(d.CCW):d.frontFace(d.CW);if(h=="back")d.cullFace(d.BACK);
else h=="front"?d.cullFace(d.FRONT):d.cullFace(d.FRONT_AND_BACK);d.enable(d.CULL_FACE)}else d.disable(d.CULL_FACE)};this.supportsVertexTextures=function(){return d.getParameter(d.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0}};
THREE.Snippets={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, 1.0 ), fogFactor );\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube env_map;\nuniform int combine;\n#endif",
envmap_fragment:"#ifdef USE_ENVMAP\ncubeColor = textureCube( env_map, vec3( -vReflect.x, vReflect.yz ) );\nif ( combine == 1 ) {\ngl_FragColor = mix( gl_FragColor, cubeColor, reflectivity );\n} else {\ngl_FragColor = gl_FragColor * cubeColor;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refraction_ratio;\nuniform bool useRefract;\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refraction_ratio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",
map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\n#endif",map_fragment:"#ifdef USE_MAP\nmapColor = texture2D( map, vUv );\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv;\n#endif",lights_pars_vertex:"uniform bool enableLighting;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\n#ifdef PHONG\nvarying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];\n#endif\n#endif",
lights_vertex:"if ( !enableLighting ) {\nvLightWeighting = vec3( 1.0 );\n} else {\nvLightWeighting = ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nfloat directionalLightWeighting = max( dot( transformedNormal, normalize( lDirection.xyz ) ), 0.0 );\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 pointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\nfloat pointLightWeighting = max( dot( transformedNormal, pointLightVector ), 0.0 );\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting;\n#ifdef PHONG\nvPointLightVector[ i ] = pointLightVector;\n#endif\n}\n#endif\n}",
lights_pars_fragment:"#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nvarying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",lights_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 mSpecular = vec4( specular, opacity );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointDiffuse  = vec4( 0.0 );\nvec4 pointSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec3 pointVector = normalize( vPointLightVector[ i ] );\nvec3 pointHalfVector = normalize( vPointLightVector[ i ] + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, shininess );\npointDiffuse  += mColor * pointDiffuseWeight;\npointSpecular += mSpecular * pointSpecularWeight;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirDiffuse  = vec4( 0.0 );\nvec4 dirSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, shininess );\ndirDiffuse  += mColor * dirDiffuseWeight;\ndirSpecular += mSpecular * dirSpecularWeight;\n}\n#endif\nvec4 totalLight = vec4( ambient, opacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirDiffuse + dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointDiffuse + pointSpecular;\n#endif"};
THREE.UniformsLib={common:{color:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},env_map:{type:"t",value:1,texture:null},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refraction_ratio:{type:"f",value:0.98},combine:{type:"i",value:0},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{enableLighting:{type:"i",value:1},ambientLightColor:{type:"fv",
value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]}}};
THREE.ShaderLib={depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3}},fragment_shader:"uniform float mNear;\nuniform float mFar;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), 1.0 );\n}",vertex_shader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"},normal:{uniforms:{},fragment_shader:"varying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, 1.0 );\n}",
vertex_shader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}"},basic:{uniforms:THREE.UniformsLib.common,fragment_shader:["uniform vec3 color;\nuniform float opacity;",THREE.Snippets.map_pars_fragment,THREE.Snippets.envmap_pars_fragment,THREE.Snippets.fog_pars_fragment,"void main() {\nvec4 mColor = vec4( color, opacity );\nvec4 mapColor = vec4( 1.0 );\nvec4 cubeColor = vec4( 1.0 );",
THREE.Snippets.map_fragment,"gl_FragColor = mColor * mapColor;",THREE.Snippets.envmap_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertex_shader:[THREE.Snippets.map_pars_vertex,THREE.Snippets.envmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.Snippets.map_vertex,THREE.Snippets.envmap_vertex,"gl_Position = projectionMatrix * mvPosition;\n}"].join("\n")},lambert:{uniforms:Uniforms.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights]),fragment_shader:["uniform vec3 color;\nuniform float opacity;\nvarying vec3 vLightWeighting;",
THREE.Snippets.map_pars_fragment,THREE.Snippets.envmap_pars_fragment,THREE.Snippets.fog_pars_fragment,"void main() {\nvec4 mColor = vec4( color, opacity );\nvec4 mapColor = vec4( 1.0 );\nvec4 cubeColor = vec4( 1.0 );",THREE.Snippets.map_fragment,"gl_FragColor =  mColor * mapColor * vec4( vLightWeighting, 1.0 );",THREE.Snippets.envmap_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertex_shader:["varying vec3 vLightWeighting;",THREE.Snippets.map_pars_vertex,THREE.Snippets.envmap_pars_vertex,
THREE.Snippets.lights_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.Snippets.map_vertex,THREE.Snippets.envmap_vertex,"vec3 transformedNormal = normalize( normalMatrix * normal );",THREE.Snippets.lights_vertex,"gl_Position = projectionMatrix * mvPosition;\n}"].join("\n")},phong:{uniforms:Uniforms.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights,{ambient:{type:"c",value:new THREE.Color(328965)},specular:{type:"c",value:new THREE.Color(1118481)},
shininess:{type:"f",value:30}}]),fragment_shader:["uniform vec3 color;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;\nvarying vec3 vLightWeighting;",THREE.Snippets.map_pars_fragment,THREE.Snippets.envmap_pars_fragment,THREE.Snippets.fog_pars_fragment,THREE.Snippets.lights_pars_fragment,"void main() {\nvec4 mColor = vec4( color, opacity );\nvec4 mapColor = vec4( 1.0 );\nvec4 cubeColor = vec4( 1.0 );",THREE.Snippets.map_fragment,THREE.Snippets.lights_fragment,
"gl_FragColor =  mapColor * totalLight * vec4( vLightWeighting, 1.0 );",THREE.Snippets.envmap_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertex_shader:["#define PHONG\nvarying vec3 vLightWeighting;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.Snippets.map_pars_vertex,THREE.Snippets.envmap_pars_vertex,THREE.Snippets.lights_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.Snippets.map_vertex,THREE.Snippets.envmap_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = cameraPosition - mPosition.xyz;\nvec3 transformedNormal = normalize( normalMatrix * normal );\nvNormal = transformedNormal;",
THREE.Snippets.lights_vertex,"gl_Position = projectionMatrix * mvPosition;\n}"].join("\n")}};THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableFace3=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.v3=new THREE.Vertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[];this.faceMaterials=this.meshMaterials=null;this.overdraw=false;this.uvs=[null,null,null]};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.materials=null};
