// ThreeCanvas.js - http://github.com/mrdoob/three.js
'use strict';var THREE=THREE||{REVISION:"48"};if(!self.Int32Array)self.Int32Array=Array,self.Float32Array=Array;
(function(){for(var a=0,b=["ms","moz","webkit","o"],c=0;c<b.length&&!window.requestAnimationFrame;++c)window.requestAnimationFrame=window[b[c]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[b[c]+"CancelAnimationFrame"]||window[b[c]+"CancelRequestAnimationFrame"];if(!window.requestAnimationFrame)window.requestAnimationFrame=function(b){var c=(new Date).getTime(),f=Math.max(0,16-(c-a)),g=window.setTimeout(function(){b(c+f)},f);a=c+f;return g};if(!window.cancelAnimationFrame)window.cancelAnimationFrame=
function(a){clearTimeout(a)}})();THREE.Color=function(a){void 0!==a&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},copyGammaToLinear:function(a){this.r=a.r*a.r;this.g=a.g*a.g;this.b=a.b*a.b;return this},copyLinearToGamma:function(a){this.r=Math.sqrt(a.r);this.g=Math.sqrt(a.g);this.b=Math.sqrt(a.b);return this},convertGammaToLinear:function(){var a=this.r,b=this.g,c=this.b;this.r=a*a;this.g=b*b;this.b=c*c;return this},convertLinearToGamma:function(){this.r=Math.sqrt(this.r);this.g=Math.sqrt(this.g);
this.b=Math.sqrt(this.b);return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var d,e,f;if(0===c)this.r=this.g=this.b=0;else switch(d=Math.floor(6*a),e=6*a-d,a=c*(1-b),f=c*(1-b*e),b=c*(1-b*(1-e)),d){case 1:this.r=f;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=f;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=c;this.g=a;this.b=f;break;case 6:case 0:this.r=c,this.g=b,this.b=a}return this},setHex:function(a){a=
Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},getHex:function(){return Math.floor(255*this.r)<<16^Math.floor(255*this.g)<<8^Math.floor(255*this.b)},getContextStyle:function(){return"rgb("+Math.floor(255*this.r)+","+Math.floor(255*this.g)+","+Math.floor(255*this.b)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;return this},equals:function(a){return a.x===this.x&&a.y===this.y},isZero:function(){return 1.0E-4>this.lengthSq()}};THREE.Vector3=function(a,b,c){this.x=a||0;this.y=b||0;this.z=c||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},
addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){this.x/=a.x;this.y/=a.y;this.z/=a.z;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.z=this.y=this.x=0;return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},
lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;return this},cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){var b=this.x,c=this.y,d=this.z;this.x=c*a.z-d*a.y;this.y=d*a.x-b*a.z;this.z=b*a.y-c*a.x;return this},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},getPositionFromMatrix:function(a){this.x=
a.n14;this.y=a.n24;this.z=a.n34;return this},getRotationFromMatrix:function(a,b){var c=b?b.x:1,d=b?b.y:1,e=b?b.z:1,f=a.n11/c,g=a.n12/d,c=a.n21/c,d=a.n22/d,h=a.n23/e,l=a.n33/e;this.y=Math.asin(a.n13/e);e=Math.cos(this.y);1.0E-5<Math.abs(e)?(this.x=Math.atan2(-h/e,l/e),this.z=Math.atan2(-g/e,f/e)):(this.x=0,this.z=Math.atan2(c,d));return this},getScaleFromMatrix:function(a){var b=this.set(a.n11,a.n21,a.n31).length(),c=this.set(a.n12,a.n22,a.n32).length(),a=this.set(a.n13,a.n23,a.n33).length();this.x=
b;this.y=c;this.z=a},equals:function(a){return a.x===this.x&&a.y===this.y&&a.z===this.z},isZero:function(){return 1.0E-4>this.lengthSq()}};THREE.Vector4=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=void 0!==d?d:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=void 0!==a.w?a.w:1;return this},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;
this.z=a.z-b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):(this.z=this.y=this.x=0,this.w=1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Frustum=function(){this.planes=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4]};
THREE.Frustum.prototype.setFromMatrix=function(a){var b,c=this.planes;c[0].set(a.n41-a.n11,a.n42-a.n12,a.n43-a.n13,a.n44-a.n14);c[1].set(a.n41+a.n11,a.n42+a.n12,a.n43+a.n13,a.n44+a.n14);c[2].set(a.n41+a.n21,a.n42+a.n22,a.n43+a.n23,a.n44+a.n24);c[3].set(a.n41-a.n21,a.n42-a.n22,a.n43-a.n23,a.n44-a.n24);c[4].set(a.n41-a.n31,a.n42-a.n32,a.n43-a.n33,a.n44-a.n34);c[5].set(a.n41+a.n31,a.n42+a.n32,a.n43+a.n33,a.n44+a.n34);for(a=0;6>a;a++)b=c[a],b.divideScalar(Math.sqrt(b.x*b.x+b.y*b.y+b.z*b.z))};
THREE.Frustum.prototype.contains=function(a){for(var b=this.planes,c=a.matrixWorld,d=THREE.Frustum.__v1.set(c.getColumnX().length(),c.getColumnY().length(),c.getColumnZ().length()),d=-a.geometry.boundingSphere.radius*Math.max(d.x,Math.max(d.y,d.z)),e=0;6>e;e++)if(a=b[e].x*c.n14+b[e].y*c.n24+b[e].z*c.n34+b[e].w,a<=d)return!1;return!0};THREE.Frustum.__v1=new THREE.Vector3;
THREE.Ray=function(a,b){function c(a,b,c){p.sub(c,a);H=p.dot(b);C=k.add(a,u.copy(b).multiplyScalar(H));return L=c.distanceTo(C)}function d(a,b,c,d){p.sub(d,b);k.sub(c,b);u.sub(a,b);F=p.dot(p);t=p.dot(k);G=p.dot(u);z=k.dot(k);E=k.dot(u);r=1/(F*z-t*t);v=(z*G-t*E)*r;y=(F*E-t*G)*r;return 0<=v&&0<=y&&1>v+y}this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3;this.intersectObjects=function(a){var b,c,d=[];for(b=0,c=a.length;b<c;b++)Array.prototype.push.apply(d,this.intersectObject(a[b]));
d.sort(function(a,b){return a.distance-b.distance});return d};var e=1.0E-4;this.setPrecision=function(a){e=a};var f=new THREE.Vector3,g=new THREE.Vector3,h=new THREE.Vector3,l=new THREE.Vector3,i=new THREE.Vector3,j=new THREE.Vector3,n=new THREE.Vector3,m=new THREE.Vector3,o=new THREE.Vector3;this.intersectObject=function(a){var b,k=[];if(a instanceof THREE.Particle){var p=c(this.origin,this.direction,a.matrixWorld.getPosition());if(p>a.scale.x)return[];b={distance:p,point:a.position,face:null,object:a};
k.push(b)}else if(a instanceof THREE.Mesh){var p=c(this.origin,this.direction,a.matrixWorld.getPosition()),I=THREE.Frustum.__v1.set(a.matrixWorld.getColumnX().length(),a.matrixWorld.getColumnY().length(),a.matrixWorld.getColumnZ().length());if(p>a.geometry.boundingSphere.radius*Math.max(I.x,Math.max(I.y,I.z)))return k;var r,u,v=a.geometry,D=v.vertices,t;a.matrixRotationWorld.extractRotation(a.matrixWorld);for(p=0,I=v.faces.length;p<I;p++)if(b=v.faces[p],i.copy(this.origin),j.copy(this.direction),
t=a.matrixWorld,n=t.multiplyVector3(n.copy(b.centroid)).subSelf(i),m=a.matrixRotationWorld.multiplyVector3(m.copy(b.normal)),r=j.dot(m),!(Math.abs(r)<e)&&(u=m.dot(n)/r,!(0>u)&&(a.doubleSided||(a.flipSided?0<r:0>r))))if(o.add(i,j.multiplyScalar(u)),b instanceof THREE.Face3)f=t.multiplyVector3(f.copy(D[b.a].position)),g=t.multiplyVector3(g.copy(D[b.b].position)),h=t.multiplyVector3(h.copy(D[b.c].position)),d(o,f,g,h)&&(b={distance:i.distanceTo(o),point:o.clone(),face:b,object:a},k.push(b));else if(b instanceof
THREE.Face4&&(f=t.multiplyVector3(f.copy(D[b.a].position)),g=t.multiplyVector3(g.copy(D[b.b].position)),h=t.multiplyVector3(h.copy(D[b.c].position)),l=t.multiplyVector3(l.copy(D[b.d].position)),d(o,f,g,l)||d(o,g,h,l)))b={distance:i.distanceTo(o),point:o.clone(),face:b,object:a},k.push(b)}return k};var p=new THREE.Vector3,k=new THREE.Vector3,u=new THREE.Vector3,H,C,L,F,t,G,z,E,r,v,y};
THREE.Rectangle=function(){function a(){f=d-b;g=e-c}var b,c,d,e,f,g,h=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return f};this.getHeight=function(){return g};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(f,g,j,n){h=!1;b=f;c=g;d=j;e=n;a()};this.addPoint=function(f,g){h?(h=!1,b=f,c=g,d=f,e=g):(b=b<f?b:f,c=c<g?c:g,d=d>f?d:f,e=e>g?e:g);a()};this.add3Points=
function(f,g,j,n,m,o){h?(h=!1,b=f<j?f<m?f:m:j<m?j:m,c=g<n?g<o?g:o:n<o?n:o,d=f>j?f>m?f:m:j>m?j:m,e=g>n?g>o?g:o:n>o?n:o):(b=f<j?f<m?f<b?f:b:m<b?m:b:j<m?j<b?j:b:m<b?m:b,c=g<n?g<o?g<c?g:c:o<c?o:c:n<o?n<c?n:c:o<c?o:c,d=f>j?f>m?f>d?f:d:m>d?m:d:j>m?j>d?j:d:m>d?m:d,e=g>n?g>o?g>e?g:e:o>e?o:e:n>o?n>e?n:e:o>e?o:e);a()};this.addRectangle=function(f){h?(h=!1,b=f.getLeft(),c=f.getTop(),d=f.getRight(),e=f.getBottom()):(b=b<f.getLeft()?b:f.getLeft(),c=c<f.getTop()?c:f.getTop(),d=d>f.getRight()?d:f.getRight(),e=e>
f.getBottom()?e:f.getBottom());a()};this.inflate=function(f){b-=f;c-=f;d+=f;e+=f;a()};this.minSelf=function(f){b=b>f.getLeft()?b:f.getLeft();c=c>f.getTop()?c:f.getTop();d=d<f.getRight()?d:f.getRight();e=e<f.getBottom()?e:f.getBottom();a()};this.intersects=function(a){return d<a.getLeft()||b>a.getRight()||e<a.getTop()||c>a.getBottom()?!1:!0};this.empty=function(){h=!0;e=d=c=b=0;a()};this.isEmpty=function(){return h}};
THREE.Math={clamp:function(a,b,c){return a<b?b:a>c?c:a},clampBottom:function(a,b){return a<b?b:a},mapLinear:function(a,b,c,d,e){return d+(a-b)*(e-d)/(c-b)},random16:function(){return(65280*Math.random()+255*Math.random())/65535},randInt:function(a,b){return a+Math.floor(Math.random()*(b-a+1))},randFloat:function(a,b){return a+Math.random()*(b-a)},randFloatSpread:function(a){return a*(0.5-Math.random())},sign:function(a){return 0>a?-1:0<a?1:0}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};THREE.Matrix4=function(a,b,c,d,e,f,g,h,l,i,j,n,m,o,p,k){this.set(void 0!==a?a:1,b||0,c||0,d||0,e||0,void 0!==f?f:1,g||0,h||0,l||0,i||0,void 0!==j?j:1,n||0,m||0,o||0,p||0,void 0!==k?k:1);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,e,f,g,h,l,i,j,n,m,o,p,k){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=f;this.n23=g;this.n24=h;this.n31=l;this.n32=i;this.n33=j;this.n34=n;this.n41=m;this.n42=o;this.n43=p;this.n44=k;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,
b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,f=THREE.Matrix4.__v3;f.sub(a,b).normalize();if(0===f.length())f.z=1;d.cross(c,f).normalize();0===d.length()&&(f.x+=1.0E-4,d.cross(c,f).normalize());e.cross(f,d);this.n11=d.x;this.n12=e.x;this.n13=f.x;this.n21=d.y;this.n22=e.y;this.n23=f.y;this.n31=d.z;this.n32=e.z;this.n33=f.z;return this},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,f=a.n14,g=a.n21,h=a.n22,l=a.n23,i=a.n24,j=a.n31,n=a.n32,m=a.n33,o=a.n34,p=a.n41,k=a.n42,u=a.n43,H=a.n44,C=b.n11,
L=b.n12,F=b.n13,t=b.n14,G=b.n21,z=b.n22,E=b.n23,r=b.n24,v=b.n31,y=b.n32,K=b.n33,$=b.n34,da=b.n41,O=b.n42,I=b.n43,T=b.n44;this.n11=c*C+d*G+e*v+f*da;this.n12=c*L+d*z+e*y+f*O;this.n13=c*F+d*E+e*K+f*I;this.n14=c*t+d*r+e*$+f*T;this.n21=g*C+h*G+l*v+i*da;this.n22=g*L+h*z+l*y+i*O;this.n23=g*F+h*E+l*K+i*I;this.n24=g*t+h*r+l*$+i*T;this.n31=j*C+n*G+m*v+o*da;this.n32=j*L+n*z+m*y+o*O;this.n33=j*F+n*E+m*K+o*I;this.n34=j*t+n*r+m*$+o*T;this.n41=p*C+k*G+u*v+H*da;this.n42=p*L+k*z+u*y+H*O;this.n43=p*F+k*E+u*K+H*I;this.n44=
p*t+k*r+u*$+H*T;return this},multiplySelf:function(a){return this.multiply(this,a)},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;
this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*e;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=this.n21*b+this.n22*c+this.n23*
d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+c*this.n32+d*this.n33;a.normalize();return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+
this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,f=this.n22,g=this.n23,h=this.n24,l=this.n31,i=this.n32,j=this.n33,n=this.n34,m=this.n41,o=this.n42,p=this.n43,k=this.n44;return d*g*i*m-c*h*i*m-d*f*j*m+b*h*j*m+c*f*n*m-b*g*n*m-d*g*l*o+c*h*l*o+d*e*j*o-a*h*j*o-c*e*n*o+a*g*n*o+d*f*l*p-b*h*l*p-d*e*i*p+a*h*i*p+b*e*n*p-a*f*n*p-c*f*l*k+b*g*l*k+c*e*i*k-a*g*i*k-b*e*j*k+a*f*j*k},transpose:function(){var a;
a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n34=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;
a.n43=this.n43;a.n44=this.n44;return a},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+
10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=
Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,f=a.x,g=a.y,h=a.z,l=e*f,i=e*g;this.set(l*f+c,l*g-d*h,l*h+d*g,0,l*g+d*h,i*g+c,i*h-d*f,0,l*h-d*g,i*h+d*f,e*h*h+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){return THREE.Matrix4.__v1.set(this.n14,this.n24,this.n34)},getColumnX:function(){return THREE.Matrix4.__v1.set(this.n11,
this.n21,this.n31)},getColumnY:function(){return THREE.Matrix4.__v1.set(this.n12,this.n22,this.n32)},getColumnZ:function(){return THREE.Matrix4.__v1.set(this.n13,this.n23,this.n33)},getInverse:function(a){var b=a.n11,c=a.n12,d=a.n13,e=a.n14,f=a.n21,g=a.n22,h=a.n23,l=a.n24,i=a.n31,j=a.n32,n=a.n33,m=a.n34,o=a.n41,p=a.n42,k=a.n43,u=a.n44;this.n11=h*m*p-l*n*p+l*j*k-g*m*k-h*j*u+g*n*u;this.n12=e*n*p-d*m*p-e*j*k+c*m*k+d*j*u-c*n*u;this.n13=d*l*p-e*h*p+e*g*k-c*l*k-d*g*u+c*h*u;this.n14=e*h*j-d*l*j-e*g*n+c*
l*n+d*g*m-c*h*m;this.n21=l*n*o-h*m*o-l*i*k+f*m*k+h*i*u-f*n*u;this.n22=d*m*o-e*n*o+e*i*k-b*m*k-d*i*u+b*n*u;this.n23=e*h*o-d*l*o-e*f*k+b*l*k+d*f*u-b*h*u;this.n24=d*l*i-e*h*i+e*f*n-b*l*n-d*f*m+b*h*m;this.n31=g*m*o-l*j*o+l*i*p-f*m*p-g*i*u+f*j*u;this.n32=e*j*o-c*m*o-e*i*p+b*m*p+c*i*u-b*j*u;this.n33=c*l*o-e*g*o+e*f*p-b*l*p-c*f*u+b*g*u;this.n34=e*g*i-c*l*i-e*f*j+b*l*j+c*f*m-b*g*m;this.n41=h*j*o-g*n*o-h*i*p+f*n*p+g*i*k-f*j*k;this.n42=c*n*o-d*j*o+d*i*p-b*n*p-c*i*k+b*j*k;this.n43=d*g*o-c*h*o-d*f*p+b*h*p+c*
f*k-b*g*k;this.n44=c*h*i-d*g*i+d*f*j-b*h*j-c*f*n+b*g*n;this.multiplyScalar(1/a.determinant());return this},setRotationFromEuler:function(a,b){var c=a.x,d=a.y,e=a.z,f=Math.cos(c),c=Math.sin(c),g=Math.cos(d),d=Math.sin(d),h=Math.cos(e),e=Math.sin(e);switch(b){case "YXZ":var l=g*h,i=g*e,j=d*h,n=d*e;this.n11=l+n*c;this.n12=j*c-i;this.n13=f*d;this.n21=f*e;this.n22=f*h;this.n23=-c;this.n31=i*c-j;this.n32=n+l*c;this.n33=f*g;break;case "ZXY":l=g*h;i=g*e;j=d*h;n=d*e;this.n11=l-n*c;this.n12=-f*e;this.n13=j+
i*c;this.n21=i+j*c;this.n22=f*h;this.n23=n-l*c;this.n31=-f*d;this.n32=c;this.n33=f*g;break;case "ZYX":l=f*h;i=f*e;j=c*h;n=c*e;this.n11=g*h;this.n12=j*d-i;this.n13=l*d+n;this.n21=g*e;this.n22=n*d+l;this.n23=i*d-j;this.n31=-d;this.n32=c*g;this.n33=f*g;break;case "YZX":l=f*g;i=f*d;j=c*g;n=c*d;this.n11=g*h;this.n12=n-l*e;this.n13=j*e+i;this.n21=e;this.n22=f*h;this.n23=-c*h;this.n31=-d*h;this.n32=i*e+j;this.n33=l-n*e;break;case "XZY":l=f*g;i=f*d;j=c*g;n=c*d;this.n11=g*h;this.n12=-e;this.n13=d*h;this.n21=
l*e+n;this.n22=f*h;this.n23=i*e-j;this.n31=j*e-i;this.n32=c*h;this.n33=n*e+l;break;default:l=f*h,i=f*e,j=c*h,n=c*e,this.n11=g*h,this.n12=-g*e,this.n13=d,this.n21=i+j*d,this.n22=l-n*d,this.n23=-c*g,this.n31=n-l*d,this.n32=j+i*d,this.n33=f*g}return this},setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,e=a.w,f=b+b,g=c+c,h=d+d,a=b*f,l=b*g,b=b*h,i=c*g,c=c*h,d=d*h,f=e*f,g=e*g,e=e*h;this.n11=1-(i+d);this.n12=l-e;this.n13=b+g;this.n21=l+e;this.n22=1-(a+d);this.n23=c-f;this.n31=b-g;this.n32=c+
f;this.n33=1-(a+i);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},compose:function(a,b,c){var d=THREE.Matrix4.__m1,e=THREE.Matrix4.__m2;d.identity();d.setRotationFromQuaternion(b);e.setScale(c.x,c.y,c.z);this.multiply(d,e);this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},decompose:function(a,b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,
f=THREE.Matrix4.__v3;d.set(this.n11,this.n21,this.n31);e.set(this.n12,this.n22,this.n32);f.set(this.n13,this.n23,this.n33);a=a instanceof THREE.Vector3?a:new THREE.Vector3;b=b instanceof THREE.Quaternion?b:new THREE.Quaternion;c=c instanceof THREE.Vector3?c:new THREE.Vector3;c.x=d.length();c.y=e.length();c.z=f.length();a.x=this.n14;a.y=this.n24;a.z=this.n34;d=THREE.Matrix4.__m1;d.copy(this);d.n11/=c.x;d.n21/=c.x;d.n31/=c.x;d.n12/=c.y;d.n22/=c.y;d.n32/=c.y;d.n13/=c.z;d.n23/=c.z;d.n33/=c.z;b.setFromRotationMatrix(d);
return[a,b,c]},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34;return this},extractRotation:function(a){var b=THREE.Matrix4.__v1,c=1/b.set(a.n11,a.n21,a.n31).length(),d=1/b.set(a.n12,a.n22,a.n32).length(),b=1/b.set(a.n13,a.n23,a.n33).length();this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*b;this.n23=a.n23*b;this.n33=a.n33*b;return this},rotateByAxis:function(a,b){if(1===a.x&&0===a.y&&0===a.z)return this.rotateX(b);
if(0===a.x&&1===a.y&&0===a.z)return this.rotateY(b);if(0===a.x&&0===a.y&&1===a.z)return this.rotateZ(b);var c=a.x,d=a.y,e=a.z,f=Math.sqrt(c*c+d*d+e*e),c=c/f,d=d/f,e=e/f,f=c*c,g=d*d,h=e*e,l=Math.cos(b),i=Math.sin(b),j=1-l,n=c*d*j,m=c*e*j,j=d*e*j,c=c*i,o=d*i,i=e*i,e=f+(1-f)*l,f=n+i,d=m-o,n=n-i,g=g+(1-g)*l,i=j+c,m=m+o,j=j-c,h=h+(1-h)*l,l=this.n11,c=this.n21,o=this.n31,p=this.n41,k=this.n12,u=this.n22,H=this.n32,C=this.n42,L=this.n13,F=this.n23,t=this.n33,G=this.n43;this.n11=e*l+f*k+d*L;this.n21=e*c+
f*u+d*F;this.n31=e*o+f*H+d*t;this.n41=e*p+f*C+d*G;this.n12=n*l+g*k+i*L;this.n22=n*c+g*u+i*F;this.n32=n*o+g*H+i*t;this.n42=n*p+g*C+i*G;this.n13=m*l+j*k+h*L;this.n23=m*c+j*u+h*F;this.n33=m*o+j*H+h*t;this.n43=m*p+j*C+h*G;return this},rotateX:function(a){var b=this.n12,c=this.n22,d=this.n32,e=this.n42,f=this.n13,g=this.n23,h=this.n33,l=this.n43,i=Math.cos(a),a=Math.sin(a);this.n12=i*b+a*f;this.n22=i*c+a*g;this.n32=i*d+a*h;this.n42=i*e+a*l;this.n13=i*f-a*b;this.n23=i*g-a*c;this.n33=i*h-a*d;this.n43=i*
l-a*e;return this},rotateY:function(a){var b=this.n11,c=this.n21,d=this.n31,e=this.n41,f=this.n13,g=this.n23,h=this.n33,l=this.n43,i=Math.cos(a),a=Math.sin(a);this.n11=i*b-a*f;this.n21=i*c-a*g;this.n31=i*d-a*h;this.n41=i*e-a*l;this.n13=i*f+a*b;this.n23=i*g+a*c;this.n33=i*h+a*d;this.n43=i*l+a*e;return this},rotateZ:function(a){var b=this.n11,c=this.n21,d=this.n31,e=this.n41,f=this.n12,g=this.n22,h=this.n32,l=this.n42,i=Math.cos(a),a=Math.sin(a);this.n11=i*b+a*f;this.n21=i*c+a*g;this.n31=i*d+a*h;this.n41=
i*e+a*l;this.n12=i*f-a*b;this.n22=i*g-a*c;this.n32=i*h-a*d;this.n42=i*l-a*e;return this},translate:function(a){var b=a.x,c=a.y,a=a.z;this.n14=this.n11*b+this.n12*c+this.n13*a+this.n14;this.n24=this.n21*b+this.n22*c+this.n23*a+this.n24;this.n34=this.n31*b+this.n32*c+this.n33*a+this.n34;this.n44=this.n41*b+this.n42*c+this.n43*a+this.n44;return this}};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,f=a.n32*a.n21-a.n31*a.n22,g=-a.n33*a.n12+a.n32*a.n13,h=a.n33*a.n11-a.n31*a.n13,l=-a.n32*a.n11+a.n31*a.n12,i=a.n23*a.n12-a.n22*a.n13,j=-a.n23*a.n11+a.n21*a.n13,n=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*g+a.n31*i;if(0===a)return null;a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*f;c[3]=a*g;c[4]=a*h;c[5]=a*l;c[6]=a*i;c[7]=a*j;c[8]=a*n;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,f){var g;g=new THREE.Matrix4;g.n11=2*e/(b-a);g.n12=0;g.n13=(b+a)/(b-a);g.n14=0;g.n21=0;g.n22=2*e/(d-c);g.n23=(d+c)/(d-c);g.n24=0;g.n31=0;g.n32=0;g.n33=-(f+e)/(f-e);g.n34=-2*f*e/(f-e);g.n41=0;g.n42=0;g.n43=-1;g.n44=0;return g};THREE.Matrix4.makePerspective=function(a,b,c,d){var e,a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,f){var g,h,l,i;g=new THREE.Matrix4;h=b-a;l=c-d;i=f-e;g.n11=2/h;g.n12=0;g.n13=0;g.n14=-((b+a)/h);g.n21=0;g.n22=2/l;g.n23=0;g.n24=-((c+d)/l);g.n31=0;g.n32=0;g.n33=-2/i;g.n34=-((f+e)/i);g.n41=0;g.n42=0;g.n43=0;g.n44=1;return g};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.id=THREE.Object3DCount++;this.name="";this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,applyMatrix:function(a){this.matrix.multiply(a,this.matrix);this.scale.getScaleFromMatrix(this.matrix);this.rotation.getRotationFromMatrix(this.matrix,this.scale);this.position.getPositionFromMatrix(this.matrix)},translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,
this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.getRotationFromMatrix(this.matrix)},add:function(a){if(a===this)console.warn("THREE.Object3D.add: An object can't be added as a child of itself.");else if(-1===this.children.indexOf(a)){void 0!==a.parent&&a.parent.remove(a);a.parent=this;this.children.push(a);for(var b=this;void 0!==b.parent;)b=b.parent;void 0!==b&&b instanceof THREE.Scene&&b.__addObject(a)}},remove:function(a){var b=
this.children.indexOf(a);if(-1!==b){a.parent=void 0;this.children.splice(b,1);for(b=this;void 0!==b.parent;)b=b.parent;void 0!==b&&b instanceof THREE.Scene&&b.__removeObject(a)}},getChildByName:function(a,b){var c,d,e;for(c=0,d=this.children.length;c<d;c++){e=this.children[c];if(e.name===a||b&&(e=e.getChildByName(a,b),void 0!==e))return e}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,
this.eulerOrder);if(1!==this.scale.x||1!==this.scale.y||1!==this.scale.z)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(a){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||a)this.parent?this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,a=!0;for(var b=0,c=this.children.length;b<
c;b++)this.children[b].updateMatrixWorld(a)}};THREE.Object3DCount=0;
THREE.Projector=function(){function a(){var a=g[f]=g[f]||new THREE.RenderableObject;f++;return a}function b(){var a=i[l]=i[l]||new THREE.RenderableVertex;l++;return a}function c(a,b){return b.z-a.z}function d(a,b){var c=0,d=1,e=a.z+a.w,f=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;if(0<=e&&0<=f&&0<=g&&0<=h)return!0;if(0>e&&0>f||0>g&&0>h)return!1;0>e?c=Math.max(c,e/(e-f)):0>f&&(d=Math.min(d,e/(e-f)));0>g?c=Math.max(c,g/(g-h)):0>h&&(d=Math.min(d,g/(g-h)));if(d<c)return!1;a.lerpSelf(b,c);b.lerpSelf(a,1-d);return!0}
var e,f,g=[],h,l,i=[],j,n,m=[],o,p=[],k,u,H=[],C,L,F=[],t={objects:[],sprites:[],lights:[],elements:[]},G=new THREE.Vector3,z=new THREE.Vector4,E=new THREE.Matrix4,r=new THREE.Matrix4,v=new THREE.Frustum,y=new THREE.Vector4,K=new THREE.Vector4;this.projectVector=function(a,b){b.matrixWorldInverse.getInverse(b.matrixWorld);E.multiply(b.projectionMatrix,b.matrixWorldInverse);E.multiplyVector3(a);return a};this.unprojectVector=function(a,b){b.projectionMatrixInverse.getInverse(b.projectionMatrix);E.multiply(b.matrixWorld,
b.projectionMatrixInverse);E.multiplyVector3(a);return a};this.pickingRay=function(a,b){var c;a.z=-1;c=new THREE.Vector3(a.x,a.y,1);this.unprojectVector(a,b);this.unprojectVector(c,b);c.subSelf(a).normalize();return new THREE.Ray(a,c)};this.projectGraph=function(b,d){f=0;t.objects.length=0;t.sprites.length=0;t.lights.length=0;var g=function(b){if(!1!==b.visible){(b instanceof THREE.Mesh||b instanceof THREE.Line)&&(!1===b.frustumCulled||v.contains(b))?(E.multiplyVector3(G.copy(b.position)),e=a(),e.object=
b,e.z=G.z,t.objects.push(e)):b instanceof THREE.Sprite||b instanceof THREE.Particle?(E.multiplyVector3(G.copy(b.position)),e=a(),e.object=b,e.z=G.z,t.sprites.push(e)):b instanceof THREE.Light&&t.lights.push(b);for(var c=0,d=b.children.length;c<d;c++)g(b.children[c])}};g(b);d&&t.objects.sort(c);return t};this.projectScene=function(a,e,f){var g=e.near,G=e.far,Q=!1,U,D,J,R,A,P,N,V,s,x,w,B,M,la,fa;L=u=o=n=0;t.elements.length=0;void 0===e.parent&&(console.warn("DEPRECATED: Camera hasn't been added to a Scene. Adding it..."),
a.add(e));a.updateMatrixWorld();e.matrixWorldInverse.getInverse(e.matrixWorld);E.multiply(e.projectionMatrix,e.matrixWorldInverse);v.setFromMatrix(E);t=this.projectGraph(a,!1);for(a=0,U=t.objects.length;a<U;a++)if(s=t.objects[a].object,x=s.matrixWorld,l=0,s instanceof THREE.Mesh){w=s.geometry;B=s.geometry.materials;R=w.vertices;M=w.faces;la=w.faceVertexUvs;w=s.matrixRotationWorld.extractRotation(x);for(D=0,J=R.length;D<J;D++)h=b(),h.positionWorld.copy(R[D].position),x.multiplyVector3(h.positionWorld),
h.positionScreen.copy(h.positionWorld),E.multiplyVector4(h.positionScreen),h.positionScreen.x/=h.positionScreen.w,h.positionScreen.y/=h.positionScreen.w,h.visible=h.positionScreen.z>g&&h.positionScreen.z<G;for(R=0,D=M.length;R<D;R++){J=M[R];if(J instanceof THREE.Face3)if(A=i[J.a],P=i[J.b],N=i[J.c],A.visible&&P.visible&&N.visible)if(Q=0>(N.positionScreen.x-A.positionScreen.x)*(P.positionScreen.y-A.positionScreen.y)-(N.positionScreen.y-A.positionScreen.y)*(P.positionScreen.x-A.positionScreen.x),s.doubleSided||
Q!=s.flipSided)V=m[n]=m[n]||new THREE.RenderableFace3,n++,j=V,j.v1.copy(A),j.v2.copy(P),j.v3.copy(N);else continue;else continue;else if(J instanceof THREE.Face4)if(A=i[J.a],P=i[J.b],N=i[J.c],V=i[J.d],A.visible&&P.visible&&N.visible&&V.visible)if(Q=0>(V.positionScreen.x-A.positionScreen.x)*(P.positionScreen.y-A.positionScreen.y)-(V.positionScreen.y-A.positionScreen.y)*(P.positionScreen.x-A.positionScreen.x)||0>(P.positionScreen.x-N.positionScreen.x)*(V.positionScreen.y-N.positionScreen.y)-(P.positionScreen.y-
N.positionScreen.y)*(V.positionScreen.x-N.positionScreen.x),s.doubleSided||Q!=s.flipSided)fa=p[o]=p[o]||new THREE.RenderableFace4,o++,j=fa,j.v1.copy(A),j.v2.copy(P),j.v3.copy(N),j.v4.copy(V);else continue;else continue;j.normalWorld.copy(J.normal);!Q&&(s.flipSided||s.doubleSided)&&j.normalWorld.negate();w.multiplyVector3(j.normalWorld);j.centroidWorld.copy(J.centroid);x.multiplyVector3(j.centroidWorld);j.centroidScreen.copy(j.centroidWorld);E.multiplyVector3(j.centroidScreen);N=J.vertexNormals;for(A=
0,P=N.length;A<P;A++)V=j.vertexNormalsWorld[A],V.copy(N[A]),!Q&&(s.flipSided||s.doubleSided)&&V.negate(),w.multiplyVector3(V);for(A=0,P=la.length;A<P;A++)if(fa=la[A][R])for(N=0,V=fa.length;N<V;N++)j.uvs[A][N]=fa[N];j.material=s.material;j.faceMaterial=null!==J.materialIndex?B[J.materialIndex]:null;j.z=j.centroidScreen.z;t.elements.push(j)}}else if(s instanceof THREE.Line){r.multiply(E,x);R=s.geometry.vertices;A=b();A.positionScreen.copy(R[0].position);r.multiplyVector4(A.positionScreen);for(D=1,J=
R.length;D<J;D++)if(A=b(),A.positionScreen.copy(R[D].position),r.multiplyVector4(A.positionScreen),P=i[l-2],y.copy(A.positionScreen),K.copy(P.positionScreen),d(y,K))y.multiplyScalar(1/y.w),K.multiplyScalar(1/K.w),x=H[u]=H[u]||new THREE.RenderableLine,u++,k=x,k.v1.positionScreen.copy(y),k.v2.positionScreen.copy(K),k.z=Math.max(y.z,K.z),k.material=s.material,t.elements.push(k)}for(a=0,U=t.sprites.length;a<U;a++)if(s=t.sprites[a].object,x=s.matrixWorld,s instanceof THREE.Particle&&(z.set(x.n14,x.n24,
x.n34,1),E.multiplyVector4(z),z.z/=z.w,0<z.z&&1>z.z))g=F[L]=F[L]||new THREE.RenderableParticle,L++,C=g,C.x=z.x/z.w,C.y=z.y/z.w,C.z=z.z,C.rotation=s.rotation.z,C.scale.x=s.scale.x*Math.abs(C.x-(z.x+e.projectionMatrix.n11)/(z.w+e.projectionMatrix.n14)),C.scale.y=s.scale.y*Math.abs(C.y-(z.y+e.projectionMatrix.n22)/(z.w+e.projectionMatrix.n24)),C.material=s.material,t.elements.push(C);f&&t.elements.sort(c);return t}};
THREE.Quaternion=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=void 0!==d?d:1};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},clone:function(){return new THREE.Quaternion(this.x,this.y,this.z,this.w)},setFromEuler:function(a){var b=Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-e),e=Math.sin(-e),f=Math.cos(c),c=Math.sin(c),g=a*b,h=d*e;this.w=g*f-h*c;this.x=g*c+h*f;this.y=d*b*f+a*e*c;this.z=a*e*
f-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);this.x=a.x*d;this.y=a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},setFromRotationMatrix:function(a){var b=Math.pow(a.determinant(),1/3);this.w=Math.sqrt(Math.max(0,b+a.n11+a.n22+a.n33))/2;this.x=Math.sqrt(Math.max(0,b+a.n11-a.n22-a.n33))/2;this.y=Math.sqrt(Math.max(0,b-a.n11+a.n22-a.n33))/2;this.z=Math.sqrt(Math.max(0,b-a.n11-a.n22+a.n33))/2;this.x=0>a.n32-a.n23?-Math.abs(this.x):Math.abs(this.x);this.y=0>a.n13-a.n31?
-Math.abs(this.y):Math.abs(this.y);this.z=0>a.n21-a.n12?-Math.abs(this.z):Math.abs(this.z);this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);0===a?this.w=this.z=
this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=a,this.w*=a);return this},multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,e=this.w,f=a.x,g=a.y,h=a.z,a=a.w;this.x=b*a+e*f+c*h-d*g;this.y=c*a+e*g+d*f-b*h;this.z=d*a+e*h+b*g-c*f;this.w=e*a-b*f-c*g-d*h;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=
a);var c=a.x,d=a.y,e=a.z,f=this.x,g=this.y,h=this.z,l=this.w,i=l*c+g*e-h*d,j=l*d+h*c-f*e,n=l*e+f*d-g*c,c=-f*c-g*d-h*e;b.x=i*l+c*-f+j*-h-n*-g;b.y=j*l+c*-g+n*-f-i*-h;b.z=n*l+c*-h+i*-g-j*-f;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;0>e?(c.w=-b.w,c.x=-b.x,c.y=-b.y,c.z=-b.z,e=-e):c.copy(b);if(1<=Math.abs(e))return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var f=Math.acos(e),e=Math.sqrt(1-e*e);if(0.001>Math.abs(e))return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;b=Math.sin((1-d)*f)/e;d=Math.sin(d*f)/e;c.w=a.w*b+c.w*d;c.x=a.x*b+c.x*d;c.y=a.y*b+c.y*d;c.z=a.z*b+c.z*d;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Vertex.prototype={constructor:THREE.Vertex,clone:function(){return new THREE.Vertex(this.position.clone())}};THREE.Face3=function(a,b,c,d,e,f){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materialIndex=f;this.centroid=new THREE.Vector3};
THREE.Face3.prototype={constructor:THREE.Face3,clone:function(){var a=new THREE.Face3(this.a,this.b,this.c);a.normal.copy(this.normal);a.color.copy(this.color);a.centroid.copy(this.centroid);a.materialIndex=this.materialIndex;var b,c;for(b=0,c=this.vertexNormals.length;b<c;b++)a.vertexNormals[b]=this.vertexNormals[b].clone();for(b=0,c=this.vertexColors.length;b<c;b++)a.vertexColors[b]=this.vertexColors[b].clone();for(b=0,c=this.vertexTangents.length;b<c;b++)a.vertexTangents[b]=this.vertexTangents[b].clone();
return a}};THREE.Face4=function(a,b,c,d,e,f,g){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=f instanceof THREE.Color?f:new THREE.Color;this.vertexColors=f instanceof Array?f:[];this.vertexTangents=[];this.materialIndex=g;this.centroid=new THREE.Vector3};
THREE.Face4.prototype={constructor:THREE.Face4,clone:function(){var a=new THREE.Face4(this.a,this.b,this.c,this.d);a.normal.copy(this.normal);a.color.copy(this.color);a.centroid.copy(this.centroid);a.materialIndex=this.materialIndex;var b,c;for(b=0,c=this.vertexNormals.length;b<c;b++)a.vertexNormals[b]=this.vertexNormals[b].clone();for(b=0,c=this.vertexColors.length;b<c;b++)a.vertexColors[b]=this.vertexColors[b].clone();for(b=0,c=this.vertexTangents.length;b<c;b++)a.vertexTangents[b]=this.vertexTangents[b].clone();
return a}};THREE.UV=function(a,b){this.u=a||0;this.v=b||0};THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.u=a.u;this.v=a.v;return this},lerpSelf:function(a,b){this.u+=(a.u-this.u)*b;this.v+=(a.v-this.v)*b;return this},clone:function(){return new THREE.UV(this.u,this.v)}};
THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.materials=[];this.faces=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.morphNormals=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(a){var b=new THREE.Matrix4;b.extractRotation(a);for(var c=0,d=this.vertices.length;c<d;c++)a.multiplyVector3(this.vertices[c].position);c=0;for(d=this.faces.length;c<d;c++){var e=this.faces[c];b.multiplyVector3(e.normal);for(var f=0,g=e.vertexNormals.length;f<g;f++)b.multiplyVector3(e.vertexNormals[f]);a.multiplyVector3(e.centroid)}},computeCentroids:function(){var a,b,c;for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],c.centroid.set(0,
0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(){var a,b,c,d,e,f,g=new THREE.Vector3,
h=new THREE.Vector3;for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],d=this.vertices[c.a],e=this.vertices[c.b],f=this.vertices[c.c],g.sub(f.position,e.position),h.sub(d.position,e.position),g.crossSelf(h),g.isZero()||g.normalize(),c.normal.copy(g)},computeVertexNormals:function(){var a,b,c,d;if(void 0===this.__tmpVertices){d=this.__tmpVertices=Array(this.vertices.length);for(a=0,b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;for(a=0,b=this.faces.length;a<b;a++)if(c=this.faces[a],c instanceof
THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{d=this.__tmpVertices;for(a=0,b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),
d[c.c].addSelf(c.normal),d[c.d].addSelf(c.normal));for(a=0,b=this.vertices.length;a<b;a++)d[a].normalize();for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c]),c.vertexNormals[3].copy(d[c.d]))},computeMorphNormals:function(){var a,b,c,d,e;for(c=0,d=this.faces.length;c<
d;c++){e=this.faces[c];e.__originalFaceNormal?e.__originalFaceNormal.copy(e.normal):e.__originalFaceNormal=e.normal.clone();if(!e.__originalVertexNormals)e.__originalVertexNormals=[];for(a=0,b=e.vertexNormals.length;a<b;a++)e.__originalVertexNormals[a]?e.__originalVertexNormals[a].copy(e.vertexNormals[a]):e.__originalVertexNormals[a]=e.vertexNormals[a].clone()}var f=new THREE.Geometry;f.faces=this.faces;for(a=0,b=this.morphTargets.length;a<b;a++){if(!this.morphNormals[a]){this.morphNormals[a]={};
this.morphNormals[a].faceNormals=[];this.morphNormals[a].vertexNormals=[];var g=this.morphNormals[a].faceNormals,h=this.morphNormals[a].vertexNormals,l,i;for(c=0,d=this.faces.length;c<d;c++)e=this.faces[c],l=new THREE.Vector3,i=e instanceof THREE.Face3?{a:new THREE.Vector3,b:new THREE.Vector3,c:new THREE.Vector3}:{a:new THREE.Vector3,b:new THREE.Vector3,c:new THREE.Vector3,d:new THREE.Vector3},g.push(l),h.push(i)}g=this.morphNormals[a];f.vertices=this.morphTargets[a].vertices;f.computeFaceNormals();
f.computeVertexNormals();for(c=0,d=this.faces.length;c<d;c++)e=this.faces[c],l=g.faceNormals[c],i=g.vertexNormals[c],l.copy(e.normal),e instanceof THREE.Face3?(i.a.copy(e.vertexNormals[0]),i.b.copy(e.vertexNormals[1]),i.c.copy(e.vertexNormals[2])):(i.a.copy(e.vertexNormals[0]),i.b.copy(e.vertexNormals[1]),i.c.copy(e.vertexNormals[2]),i.d.copy(e.vertexNormals[3]))}for(c=0,d=this.faces.length;c<d;c++)e=this.faces[c],e.normal=e.__originalFaceNormal,e.vertexNormals=e.__originalVertexNormals},computeTangents:function(){function a(a,
b,c,d,e,f,A){h=a.vertices[b].position;l=a.vertices[c].position;i=a.vertices[d].position;j=g[e];n=g[f];m=g[A];o=l.x-h.x;p=i.x-h.x;k=l.y-h.y;u=i.y-h.y;H=l.z-h.z;C=i.z-h.z;L=n.u-j.u;F=m.u-j.u;t=n.v-j.v;G=m.v-j.v;z=1/(L*G-F*t);y.set((G*o-t*p)*z,(G*k-t*u)*z,(G*H-t*C)*z);K.set((L*p-F*o)*z,(L*u-F*k)*z,(L*C-F*H)*z);r[b].addSelf(y);r[c].addSelf(y);r[d].addSelf(y);v[b].addSelf(K);v[c].addSelf(K);v[d].addSelf(K)}var b,c,d,e,f,g,h,l,i,j,n,m,o,p,k,u,H,C,L,F,t,G,z,E,r=[],v=[],y=new THREE.Vector3,K=new THREE.Vector3,
$=new THREE.Vector3,da=new THREE.Vector3,O=new THREE.Vector3;for(b=0,c=this.vertices.length;b<c;b++)r[b]=new THREE.Vector3,v[b]=new THREE.Vector3;for(b=0,c=this.faces.length;b<c;b++)f=this.faces[b],g=this.faceVertexUvs[0][b],f instanceof THREE.Face3?a(this,f.a,f.b,f.c,0,1,2):f instanceof THREE.Face4&&(a(this,f.a,f.b,f.c,0,1,2),a(this,f.a,f.b,f.d,0,1,3));var I=["a","b","c","d"];for(b=0,c=this.faces.length;b<c;b++){f=this.faces[b];for(d=0;d<f.vertexNormals.length;d++)O.copy(f.vertexNormals[d]),e=f[I[d]],
E=r[e],$.copy(E),$.subSelf(O.multiplyScalar(O.dot(E))).normalize(),da.cross(f.vertexNormals[d],E),e=da.dot(v[e]),e=0>e?-1:1,f.vertexTangents[d]=new THREE.Vector4($.x,$.y,$.z,e)}this.hasTangents=!0},computeBoundingBox:function(){if(!this.boundingBox)this.boundingBox={min:new THREE.Vector3,max:new THREE.Vector3};if(0<this.vertices.length){var a;a=this.vertices[0].position;this.boundingBox.min.copy(a);this.boundingBox.max.copy(a);for(var b=this.boundingBox.min,c=this.boundingBox.max,d=1,e=this.vertices.length;d<
e;d++){a=this.vertices[d].position;if(a.x<b.x)b.x=a.x;else if(a.x>c.x)c.x=a.x;if(a.y<b.y)b.y=a.y;else if(a.y>c.y)c.y=a.y;if(a.z<b.z)b.z=a.z;else if(a.z>c.z)c.z=a.z}}else this.boundingBox.min.set(0,0,0),this.boundingBox.max.set(0,0,0)},computeBoundingSphere:function(){if(!this.boundingSphere)this.boundingSphere={radius:0};for(var a,b=0,c=0,d=this.vertices.length;c<d;c++)a=this.vertices[c].position.length(),a>b&&(b=a);this.boundingSphere.radius=b},mergeVertices:function(){var a={},b=[],c=[],d,e=Math.pow(10,
4),f,g;for(f=0,g=this.vertices.length;f<g;f++)d=this.vertices[f].position,d=[Math.round(d.x*e),Math.round(d.y*e),Math.round(d.z*e)].join("_"),void 0===a[d]?(a[d]=f,b.push(this.vertices[f]),c[f]=b.length-1):c[f]=c[a[d]];for(f=0,g=this.faces.length;f<g;f++)if(a=this.faces[f],a instanceof THREE.Face3)a.a=c[a.a],a.b=c[a.b],a.c=c[a.c];else if(a instanceof THREE.Face4)a.a=c[a.a],a.b=c[a.b],a.c=c[a.c],a.d=c[a.d];this.vertices=b}};THREE.GeometryCount=0;
THREE.Camera=function(){THREE.Object3D.call(this);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=new THREE.Matrix4;this.projectionMatrixInverse=new THREE.Matrix4};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.lookAt=function(a){this.matrix.lookAt(this.position,a,this.up);this.rotationAutoUpdate&&this.rotation.getRotationFromMatrix(this.matrix)};
THREE.OrthographicCamera=function(a,b,c,d,e,f){THREE.Camera.call(this);this.left=a;this.right=b;this.top=c;this.bottom=d;this.near=void 0!==e?e:0.1;this.far=void 0!==f?f:2E3;this.updateProjectionMatrix()};THREE.OrthographicCamera.prototype=new THREE.Camera;THREE.OrthographicCamera.prototype.constructor=THREE.OrthographicCamera;THREE.OrthographicCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makeOrtho(this.left,this.right,this.top,this.bottom,this.near,this.far)};
THREE.PerspectiveCamera=function(a,b,c,d){THREE.Camera.call(this);this.fov=void 0!==a?a:50;this.aspect=void 0!==b?b:1;this.near=void 0!==c?c:0.1;this.far=void 0!==d?d:2E3;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype=new THREE.Camera;THREE.PerspectiveCamera.prototype.constructor=THREE.PerspectiveCamera;THREE.PerspectiveCamera.prototype.setLens=function(a,b){this.fov=2*Math.atan((void 0!==b?b:24)/(2*a))*(180/Math.PI);this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.setViewOffset=function(a,b,c,d,e,f){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=e;this.height=f;this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,
this.far)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;
THREE.DirectionalLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=void 0!==b?b:1;this.distance=void 0!==c?c:0;this.onlyShadow=this.castShadow=!1;this.shadowCameraNear=50;this.shadowCameraFar=5E3;this.shadowCameraLeft=-500;this.shadowCameraTop=this.shadowCameraRight=500;this.shadowCameraBottom=-500;this.shadowCameraVisible=!1;this.shadowBias=0;this.shadowDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;this.shadowCascade=
!1;this.shadowCascadeOffset=new THREE.Vector3(0,0,-1E3);this.shadowCascadeCount=2;this.shadowCascadeBias=[0,0,0];this.shadowCascadeWidth=[512,512,512];this.shadowCascadeHeight=[512,512,512];this.shadowCascadeNearZ=[-1,0.99,0.998];this.shadowCascadeFarZ=[0.99,0.998,1];this.shadowCascadeArray=[];this.shadowMatrix=this.shadowCamera=this.shadowMapSize=this.shadowMap=null};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;
THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,0,0);this.intensity=void 0!==b?b:1;this.distance=void 0!==c?c:0};THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.Material=function(a){a=a||{};this.id=THREE.MaterialCount++;this.name="";this.opacity=void 0!==a.opacity?a.opacity:1;this.transparent=void 0!==a.transparent?a.transparent:!1;this.blending=void 0!==a.blending?a.blending:THREE.NormalBlending;this.depthTest=void 0!==a.depthTest?a.depthTest:!0;this.depthWrite=void 0!==a.depthWrite?a.depthWrite:!0;this.polygonOffset=void 0!==a.polygonOffset?a.polygonOffset:!1;this.polygonOffsetFactor=void 0!==a.polygonOffsetFactor?a.polygonOffsetFactor:0;this.polygonOffsetUnits=
void 0!==a.polygonOffsetUnits?a.polygonOffsetUnits:0;this.alphaTest=void 0!==a.alphaTest?a.alphaTest:0;this.overdraw=void 0!==a.overdraw?a.overdraw:!1};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NoBlending=0;THREE.NormalBlending=1;THREE.AdditiveBlending=2;THREE.SubtractiveBlending=3;THREE.MultiplyBlending=4;THREE.AdditiveAlphaBlending=5;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=void 0!==a.linewidth?a.linewidth:1;this.linecap=void 0!==a.linecap?a.linecap:"round";this.linejoin=void 0!==a.linejoin?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1;this.fog=void 0!==a.fog?a.fog:!0};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:
!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:
!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=void 0!==a.ambient?new THREE.Color(a.ambient):new THREE.Color(16777215);this.wrapAround=void 0!==a.wrapAround?a.wrapAround:!1;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:
THREE.MultiplyOperation;this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?
a.wireframeLinejoin:"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:!1;this.morphNormals=void 0!==a.morphNormals?a.morphNormals:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=void 0!==a.ambient?new THREE.Color(a.ambient):new THREE.Color(16777215);this.specular=void 0!==a.specular?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=void 0!==a.shininess?a.shininess:30;this.metal=void 0!==a.metal?a.metal:!1;this.perPixel=void 0!==a.perPixel?a.perPixel:!1;this.wrapAround=void 0!==a.wrapAround?a.wrapAround:
!1;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:
!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:!1;this.morphNormals=void 0!==a.morphNormals?a.morphNormals:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;
THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:null;this.size=void 0!==a.size?a.size:1;this.sizeAttenuation=void 0!==a.sizeAttenuation?a.sizeAttenuation:!0;this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.fog=void 0!==a.fog?a.fog:!0};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ParticleCanvasMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.program=void 0!==a.program?a.program:function(){}};THREE.ParticleCanvasMaterial.prototype=new THREE.Material;THREE.ParticleCanvasMaterial.prototype.constructor=THREE.ParticleCanvasMaterial;
THREE.Texture=function(a,b,c,d,e,f,g,h){this.id=THREE.TextureCount++;this.image=a;this.mapping=void 0!==b?b:new THREE.UVMapping;this.wrapS=void 0!==c?c:THREE.ClampToEdgeWrapping;this.wrapT=void 0!==d?d:THREE.ClampToEdgeWrapping;this.magFilter=void 0!==e?e:THREE.LinearFilter;this.minFilter=void 0!==f?f:THREE.LinearMipMapLinearFilter;this.format=void 0!==g?g:THREE.RGBAFormat;this.type=void 0!==h?h:THREE.UnsignedByteType;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.generateMipmaps=
!0;this.needsUpdate=!1;this.onUpdate=null};THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var a=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter,this.format,this.type);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};
THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;
THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.DataTexture=function(a,b,c,d,e,f,g,h,l,i){THREE.Texture.call(this,null,f,g,h,l,i,d,e);this.image={data:a,width:b,height:c}};THREE.DataTexture.prototype=new THREE.Texture;THREE.DataTexture.prototype.constructor=THREE.DataTexture;
THREE.DataTexture.prototype.clone=function(){var a=new THREE.DataTexture(this.image.data,this.image.width,this.image.height,this.format,this.type,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a};THREE.Particle=function(a){THREE.Object3D.call(this);this.material=a};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;
THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.material=void 0!==b?b:new THREE.LineBasicMaterial({color:16777215*Math.random()});this.type=void 0!==c?c:THREE.LineStrip;this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere())};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=void 0!==b?b:new THREE.MeshBasicMaterial({color:16777215*Math.random(),wireframe:!0});if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),
this.morphTargetDictionary[this.geometry.morphTargets[c].name]=c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(void 0!==this.morphTargetDictionary[a])return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var c,d=this.children.length;for(c=0;c<d;c++)this.children[c].update(this.skinMatrix,b)};
THREE.Sprite=function(a){THREE.Object3D.call(this);this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:new THREE.Texture;this.blending=void 0!==a.blending?a.blending:THREE.NormalBlending;this.useScreenCoordinates=void 0!==a.useScreenCoordinates?a.useScreenCoordinates:!0;this.mergeWith3D=void 0!==a.mergeWith3D?a.mergeWith3D:!this.useScreenCoordinates;this.affectedByDistance=void 0!==a.affectedByDistance?a.affectedByDistance:!this.useScreenCoordinates;
this.scaleByViewport=void 0!==a.scaleByViewport?a.scaleByViewport:!this.affectedByDistance;this.alignment=a.alignment instanceof THREE.Vector2?a.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;
THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(1!==this.scale.x||1!==this.scale.y)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,this.scale.y);this.matrixWorldNeedsUpdate=!0};THREE.SpriteAlignment={};THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);
THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);
THREE.Scene=function(){THREE.Object3D.call(this);this.overrideMaterial=this.fog=null;this.matrixAutoUpdate=!1;this.__objects=[];this.__lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.__addObject=function(a){if(a instanceof THREE.Light)-1===this.__lights.indexOf(a)&&this.__lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&-1===this.__objects.indexOf(a)){this.__objects.push(a);this.__objectsAdded.push(a);var b=this.__objectsRemoved.indexOf(a);-1!==b&&this.__objectsRemoved.splice(b,1)}for(b=0;b<a.children.length;b++)this.__addObject(a.children[b])};
THREE.Scene.prototype.__removeObject=function(a){if(a instanceof THREE.Light){var b=this.__lights.indexOf(a);-1!==b&&this.__lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.__objects.indexOf(a),-1!==b&&(this.__objects.splice(b,1),this.__objectsRemoved.push(a),b=this.__objectsAdded.indexOf(a),-1!==b&&this.__objectsAdded.splice(b,1)));for(b=0;b<a.children.length;b++)this.__removeObject(a.children[b])};
THREE.CanvasRenderer=function(a){function b(a){if(C!=a)k.globalAlpha=C=a}function c(a){if(L!=a){switch(a){case THREE.NormalBlending:k.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:k.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:k.globalCompositeOperation="darker"}L=a}}function d(a){if(F!=a)k.strokeStyle=F=a}function e(a){if(t!=a)k.fillStyle=t=a}var a=a||{},f=this,g,h,l,i=new THREE.Projector,j=void 0!==a.canvas?a.canvas:document.createElement("canvas"),
n,m,o,p,k=j.getContext("2d"),u=new THREE.Color(0),H=0,C=1,L=0,F=null,t=null,G=null,z=null,E=null,r,v,y,K,$=new THREE.RenderableVertex,da=new THREE.RenderableVertex,O,I,T,Q,U,D,J,R,A,P,N,V,s=new THREE.Color,x=new THREE.Color,w=new THREE.Color,B=new THREE.Color,M=new THREE.Color,la=[],fa=[],ga,ha,ea,aa,Ba,Ca,Da,Ea,Fa,Ga,ma=new THREE.Rectangle,Z=new THREE.Rectangle,Y=new THREE.Rectangle,ya=!1,X=new THREE.Color,na=new THREE.Color,oa=new THREE.Color,S=new THREE.Vector3,sa,ta,za,ba,ua,va,a=16;sa=document.createElement("canvas");
sa.width=sa.height=2;ta=sa.getContext("2d");ta.fillStyle="rgba(0,0,0,1)";ta.fillRect(0,0,2,2);za=ta.getImageData(0,0,2,2);ba=za.data;ua=document.createElement("canvas");ua.width=ua.height=a;va=ua.getContext("2d");va.translate(-a/2,-a/2);va.scale(a,a);a--;this.domElement=j;this.sortElements=this.sortObjects=this.autoClear=!0;this.info={render:{vertices:0,faces:0}};this.setSize=function(a,b){n=a;m=b;o=Math.floor(n/2);p=Math.floor(m/2);j.width=n;j.height=m;ma.set(-o,-p,o,p);Z.set(-o,-p,o,p);C=1;L=0;
E=z=G=t=F=null};this.setClearColor=function(a,b){u.copy(a);H=b;Z.set(-o,-p,o,p)};this.setClearColorHex=function(a,b){u.setHex(a);H=b;Z.set(-o,-p,o,p)};this.clear=function(){k.setTransform(1,0,0,-1,o,p);Z.isEmpty()||(Z.minSelf(ma),Z.inflate(2),1>H&&k.clearRect(Math.floor(Z.getX()),Math.floor(Z.getY()),Math.floor(Z.getWidth()),Math.floor(Z.getHeight())),0<H&&(c(THREE.NormalBlending),b(1),e("rgba("+Math.floor(255*u.r)+","+Math.floor(255*u.g)+","+Math.floor(255*u.b)+","+H+")"),k.fillRect(Math.floor(Z.getX()),
Math.floor(Z.getY()),Math.floor(Z.getWidth()),Math.floor(Z.getHeight()))),Z.empty())};this.render=function(a,j){function n(a){var b,c,d,e;X.setRGB(0,0,0);na.setRGB(0,0,0);oa.setRGB(0,0,0);for(b=0,c=a.length;b<c;b++)d=a[b],e=d.color,d instanceof THREE.AmbientLight?(X.r+=e.r,X.g+=e.g,X.b+=e.b):d instanceof THREE.DirectionalLight?(na.r+=e.r,na.g+=e.g,na.b+=e.b):d instanceof THREE.PointLight&&(oa.r+=e.r,oa.g+=e.g,oa.b+=e.b)}function m(a,b,c,d){var e,f,g,h,i,j;for(e=0,f=a.length;e<f;e++)g=a[e],h=g.color,
g instanceof THREE.DirectionalLight?(i=g.matrixWorld.getPosition(),j=c.dot(i),0>=j||(j*=g.intensity,d.r+=h.r*j,d.g+=h.g*j,d.b+=h.b*j)):g instanceof THREE.PointLight&&(i=g.matrixWorld.getPosition(),j=c.dot(S.sub(i,b).normalize()),0>=j||(j*=0==g.distance?1:1-Math.min(b.distanceTo(i)/g.distance,1),0!=j&&(j*=g.intensity,d.r+=h.r*j,d.g+=h.g*j,d.b+=h.b*j)))}function t(a,f,g){b(g.opacity);c(g.blending);var h,j,i,l,q,n;if(g instanceof THREE.ParticleBasicMaterial){if(g.map)l=g.map.image,q=l.width>>1,n=l.height>>
1,g=f.scale.x*o,i=f.scale.y*p,h=g*q,j=i*n,Y.set(a.x-h,a.y-j,a.x+h,a.y+j),ma.intersects(Y)&&(k.save(),k.translate(a.x,a.y),k.rotate(-f.rotation),k.scale(g,-i),k.translate(-q,-n),k.drawImage(l,0,0),k.restore())}else g instanceof THREE.ParticleCanvasMaterial&&(h=f.scale.x*o,j=f.scale.y*p,Y.set(a.x-h,a.y-j,a.x+h,a.y+j),ma.intersects(Y)&&(d(g.color.getContextStyle()),e(g.color.getContextStyle()),k.save(),k.translate(a.x,a.y),k.rotate(-f.rotation),k.scale(h,j),g.program(k),k.restore()))}function u(a,e,
f,g){b(g.opacity);c(g.blending);k.beginPath();k.moveTo(a.positionScreen.x,a.positionScreen.y);k.lineTo(e.positionScreen.x,e.positionScreen.y);k.closePath();if(g instanceof THREE.LineBasicMaterial){a=g.linewidth;if(G!=a)k.lineWidth=G=a;a=g.linecap;if(z!=a)k.lineCap=z=a;a=g.linejoin;if(E!=a)k.lineJoin=E=a;d(g.color.getContextStyle());k.stroke();Y.inflate(2*g.linewidth)}}function C(a,d,e,g,h,i,k,q){f.info.render.vertices+=3;f.info.render.faces++;b(q.opacity);c(q.blending);O=a.positionScreen.x;I=a.positionScreen.y;
T=d.positionScreen.x;Q=d.positionScreen.y;U=e.positionScreen.x;D=e.positionScreen.y;F(O,I,T,Q,U,D);if(q instanceof THREE.MeshBasicMaterial)if(q.map)q.map.mapping instanceof THREE.UVMapping&&(aa=k.uvs[0],Aa(O,I,T,Q,U,D,aa[g].u,aa[g].v,aa[h].u,aa[h].v,aa[i].u,aa[i].v,q.map));else if(q.envMap){if(q.envMap.mapping instanceof THREE.SphericalReflectionMapping)a=j.matrixWorldInverse,S.copy(k.vertexNormalsWorld[g]),Ba=0.5*(S.x*a.n11+S.y*a.n12+S.z*a.n13)+0.5,Ca=0.5*-(S.x*a.n21+S.y*a.n22+S.z*a.n23)+0.5,S.copy(k.vertexNormalsWorld[h]),
Da=0.5*(S.x*a.n11+S.y*a.n12+S.z*a.n13)+0.5,Ea=0.5*-(S.x*a.n21+S.y*a.n22+S.z*a.n23)+0.5,S.copy(k.vertexNormalsWorld[i]),Fa=0.5*(S.x*a.n11+S.y*a.n12+S.z*a.n13)+0.5,Ga=0.5*-(S.x*a.n21+S.y*a.n22+S.z*a.n23)+0.5,Aa(O,I,T,Q,U,D,Ba,Ca,Da,Ea,Fa,Ga,q.envMap)}else q.wireframe?ja(q.color,q.wireframeLinewidth,q.wireframeLinecap,q.wireframeLinejoin):ia(q.color);else if(q instanceof THREE.MeshLambertMaterial)q.map&&!q.wireframe&&(q.map.mapping instanceof THREE.UVMapping&&(aa=k.uvs[0],Aa(O,I,T,Q,U,D,aa[g].u,aa[g].v,
aa[h].u,aa[h].v,aa[i].u,aa[i].v,q.map)),c(THREE.SubtractiveBlending)),ya?!q.wireframe&&q.shading==THREE.SmoothShading&&3==k.vertexNormalsWorld.length?(x.r=w.r=B.r=X.r,x.g=w.g=B.g=X.g,x.b=w.b=B.b=X.b,m(l,k.v1.positionWorld,k.vertexNormalsWorld[0],x),m(l,k.v2.positionWorld,k.vertexNormalsWorld[1],w),m(l,k.v3.positionWorld,k.vertexNormalsWorld[2],B),x.r=Math.max(0,Math.min(q.color.r*x.r,1)),x.g=Math.max(0,Math.min(q.color.g*x.g,1)),x.b=Math.max(0,Math.min(q.color.b*x.b,1)),w.r=Math.max(0,Math.min(q.color.r*
w.r,1)),w.g=Math.max(0,Math.min(q.color.g*w.g,1)),w.b=Math.max(0,Math.min(q.color.b*w.b,1)),B.r=Math.max(0,Math.min(q.color.r*B.r,1)),B.g=Math.max(0,Math.min(q.color.g*B.g,1)),B.b=Math.max(0,Math.min(q.color.b*B.b,1)),M.r=0.5*(w.r+B.r),M.g=0.5*(w.g+B.g),M.b=0.5*(w.b+B.b),ea=wa(x,w,B,M),qa(O,I,T,Q,U,D,0,0,1,0,0,1,ea)):(s.r=X.r,s.g=X.g,s.b=X.b,m(l,k.centroidWorld,k.normalWorld,s),s.r=Math.max(0,Math.min(q.color.r*s.r,1)),s.g=Math.max(0,Math.min(q.color.g*s.g,1)),s.b=Math.max(0,Math.min(q.color.b*s.b,
1)),q.wireframe?ja(s,q.wireframeLinewidth,q.wireframeLinecap,q.wireframeLinejoin):ia(s)):q.wireframe?ja(q.color,q.wireframeLinewidth,q.wireframeLinecap,q.wireframeLinejoin):ia(q.color);else if(q instanceof THREE.MeshDepthMaterial)ga=j.near,ha=j.far,x.r=x.g=x.b=1-pa(a.positionScreen.z,ga,ha),w.r=w.g=w.b=1-pa(d.positionScreen.z,ga,ha),B.r=B.g=B.b=1-pa(e.positionScreen.z,ga,ha),M.r=0.5*(w.r+B.r),M.g=0.5*(w.g+B.g),M.b=0.5*(w.b+B.b),ea=wa(x,w,B,M),qa(O,I,T,Q,U,D,0,0,1,0,0,1,ea);else if(q instanceof THREE.MeshNormalMaterial)s.r=
ra(k.normalWorld.x),s.g=ra(k.normalWorld.y),s.b=ra(k.normalWorld.z),q.wireframe?ja(s,q.wireframeLinewidth,q.wireframeLinecap,q.wireframeLinejoin):ia(s)}function L(a,d,e,g,h,i,k,q,n){f.info.render.vertices+=4;f.info.render.faces++;b(q.opacity);c(q.blending);if(q.map||q.envMap)C(a,d,g,0,1,3,k,q,n),C(h,e,i,1,2,3,k,q,n);else if(O=a.positionScreen.x,I=a.positionScreen.y,T=d.positionScreen.x,Q=d.positionScreen.y,U=e.positionScreen.x,D=e.positionScreen.y,J=g.positionScreen.x,R=g.positionScreen.y,A=h.positionScreen.x,
P=h.positionScreen.y,N=i.positionScreen.x,V=i.positionScreen.y,q instanceof THREE.MeshBasicMaterial)H(O,I,T,Q,U,D,J,R),q.wireframe?ja(q.color,q.wireframeLinewidth,q.wireframeLinecap,q.wireframeLinejoin):ia(q.color);else if(q instanceof THREE.MeshLambertMaterial)ya?!q.wireframe&&q.shading==THREE.SmoothShading&&4==k.vertexNormalsWorld.length?(x.r=w.r=B.r=M.r=X.r,x.g=w.g=B.g=M.g=X.g,x.b=w.b=B.b=M.b=X.b,m(l,k.v1.positionWorld,k.vertexNormalsWorld[0],x),m(l,k.v2.positionWorld,k.vertexNormalsWorld[1],w),
m(l,k.v4.positionWorld,k.vertexNormalsWorld[3],B),m(l,k.v3.positionWorld,k.vertexNormalsWorld[2],M),x.r=Math.max(0,Math.min(q.color.r*x.r,1)),x.g=Math.max(0,Math.min(q.color.g*x.g,1)),x.b=Math.max(0,Math.min(q.color.b*x.b,1)),w.r=Math.max(0,Math.min(q.color.r*w.r,1)),w.g=Math.max(0,Math.min(q.color.g*w.g,1)),w.b=Math.max(0,Math.min(q.color.b*w.b,1)),B.r=Math.max(0,Math.min(q.color.r*B.r,1)),B.g=Math.max(0,Math.min(q.color.g*B.g,1)),B.b=Math.max(0,Math.min(q.color.b*B.b,1)),M.r=Math.max(0,Math.min(q.color.r*
M.r,1)),M.g=Math.max(0,Math.min(q.color.g*M.g,1)),M.b=Math.max(0,Math.min(q.color.b*M.b,1)),ea=wa(x,w,B,M),F(O,I,T,Q,J,R),qa(O,I,T,Q,J,R,0,0,1,0,0,1,ea),F(A,P,U,D,N,V),qa(A,P,U,D,N,V,1,0,1,1,0,1,ea)):(s.r=X.r,s.g=X.g,s.b=X.b,m(l,k.centroidWorld,k.normalWorld,s),s.r=Math.max(0,Math.min(q.color.r*s.r,1)),s.g=Math.max(0,Math.min(q.color.g*s.g,1)),s.b=Math.max(0,Math.min(q.color.b*s.b,1)),H(O,I,T,Q,U,D,J,R),q.wireframe?ja(s,q.wireframeLinewidth,q.wireframeLinecap,q.wireframeLinejoin):ia(s)):(H(O,I,T,
Q,U,D,J,R),q.wireframe?ja(q.color,q.wireframeLinewidth,q.wireframeLinecap,q.wireframeLinejoin):ia(q.color));else if(q instanceof THREE.MeshNormalMaterial)s.r=ra(k.normalWorld.x),s.g=ra(k.normalWorld.y),s.b=ra(k.normalWorld.z),H(O,I,T,Q,U,D,J,R),q.wireframe?ja(s,q.wireframeLinewidth,q.wireframeLinecap,q.wireframeLinejoin):ia(s);else if(q instanceof THREE.MeshDepthMaterial)ga=j.near,ha=j.far,x.r=x.g=x.b=1-pa(a.positionScreen.z,ga,ha),w.r=w.g=w.b=1-pa(d.positionScreen.z,ga,ha),B.r=B.g=B.b=1-pa(g.positionScreen.z,
ga,ha),M.r=M.g=M.b=1-pa(e.positionScreen.z,ga,ha),ea=wa(x,w,B,M),F(O,I,T,Q,J,R),qa(O,I,T,Q,J,R,0,0,1,0,0,1,ea),F(A,P,U,D,N,V),qa(A,P,U,D,N,V,1,0,1,1,0,1,ea)}function F(a,b,c,d,e,f){k.beginPath();k.moveTo(a,b);k.lineTo(c,d);k.lineTo(e,f);k.lineTo(a,b);k.closePath()}function H(a,b,c,d,e,f,g,h){k.beginPath();k.moveTo(a,b);k.lineTo(c,d);k.lineTo(e,f);k.lineTo(g,h);k.lineTo(a,b);k.closePath()}function ja(a,b,c,e){if(G!=b)k.lineWidth=G=b;if(z!=c)k.lineCap=z=c;if(E!=e)k.lineJoin=E=e;d(a.getContextStyle());
k.stroke();Y.inflate(2*b)}function ia(a){e(a.getContextStyle());k.fill()}function Aa(a,b,c,d,f,g,h,i,j,l,n,o,m){if(0!=m.image.width){if(!0==m.needsUpdate||void 0==la[m.id]){var p=m.wrapS==THREE.RepeatWrapping,r=m.wrapT==THREE.RepeatWrapping;la[m.id]=k.createPattern(m.image,p&&r?"repeat":p&&!r?"repeat-x":!p&&r?"repeat-y":"no-repeat");m.needsUpdate=!1}e(la[m.id]);var p=m.offset.x/m.repeat.x,r=m.offset.y/m.repeat.y,t=m.image.width*m.repeat.x,u=m.image.height*m.repeat.y,h=(h+p)*t,i=(i+r)*u,c=c-a,d=d-
b,f=f-a,g=g-b,j=(j+p)*t-h,l=(l+r)*u-i,n=(n+p)*t-h,o=(o+r)*u-i,p=j*o-n*l;if(0==p){if(void 0===fa[m.id])b=document.createElement("canvas"),b.width=m.image.width,b.height=m.image.height,b=b.getContext("2d"),b.drawImage(m.image,0,0),fa[m.id]=b.getImageData(0,0,m.image.width,m.image.height).data;b=fa[m.id];h=4*(Math.floor(h)+Math.floor(i)*m.image.width);s.setRGB(b[h]/255,b[h+1]/255,b[h+2]/255);ia(s)}else p=1/p,m=(o*c-l*f)*p,l=(o*d-l*g)*p,c=(j*f-n*c)*p,d=(j*g-n*d)*p,a=a-m*h-c*i,h=b-l*h-d*i,k.save(),k.transform(m,
l,c,d,a,h),k.fill(),k.restore()}}function qa(a,b,c,d,e,f,g,h,i,j,l,m,n){var o,p;o=n.width-1;p=n.height-1;g*=o;h*=p;c-=a;d-=b;e-=a;f-=b;i=i*o-g;j=j*p-h;l=l*o-g;m=m*p-h;p=1/(i*m-l*j);o=(m*c-j*e)*p;j=(m*d-j*f)*p;c=(i*e-l*c)*p;d=(i*f-l*d)*p;a=a-o*g-c*h;b=b-j*g-d*h;k.save();k.transform(o,j,c,d,a,b);k.clip();k.drawImage(n,0,0);k.restore()}function wa(a,b,c,d){var e=~~(255*a.r),f=~~(255*a.g),a=~~(255*a.b),g=~~(255*b.r),h=~~(255*b.g),b=~~(255*b.b),i=~~(255*c.r),j=~~(255*c.g),c=~~(255*c.b),k=~~(255*d.r),l=
~~(255*d.g),d=~~(255*d.b);ba[0]=0>e?0:255<e?255:e;ba[1]=0>f?0:255<f?255:f;ba[2]=0>a?0:255<a?255:a;ba[4]=0>g?0:255<g?255:g;ba[5]=0>h?0:255<h?255:h;ba[6]=0>b?0:255<b?255:b;ba[8]=0>i?0:255<i?255:i;ba[9]=0>j?0:255<j?255:j;ba[10]=0>c?0:255<c?255:c;ba[12]=0>k?0:255<k?255:k;ba[13]=0>l?0:255<l?255:l;ba[14]=0>d?0:255<d?255:d;ta.putImageData(za,0,0);va.drawImage(sa,0,0);return ua}function pa(a,b,c){a=(a-b)/(c-b);return a*a*(3-2*a)}function ra(a){a=0.5*(a+1);return 0>a?0:1<a?1:a}function ka(a,b){var c=b.x-a.x,
d=b.y-a.y,e=c*c+d*d;0!=e&&(e=1/Math.sqrt(e),c*=e,d*=e,b.x+=c,b.y+=d,a.x-=c,a.y-=d)}var xa,Ha,W,ca;this.autoClear?this.clear():k.setTransform(1,0,0,-1,o,p);f.info.render.vertices=0;f.info.render.faces=0;g=i.projectScene(a,j,this.sortElements);h=g.elements;l=g.lights;(ya=0<l.length)&&n(l);for(xa=0,Ha=h.length;xa<Ha;xa++)if(W=h[xa],ca=W.material,ca=ca instanceof THREE.MeshFaceMaterial?W.faceMaterial:ca,!(null==ca||0==ca.opacity)){Y.empty();if(W instanceof THREE.RenderableParticle)r=W,r.x*=o,r.y*=p,t(r,
W,ca,a);else if(W instanceof THREE.RenderableLine)r=W.v1,v=W.v2,r.positionScreen.x*=o,r.positionScreen.y*=p,v.positionScreen.x*=o,v.positionScreen.y*=p,Y.addPoint(r.positionScreen.x,r.positionScreen.y),Y.addPoint(v.positionScreen.x,v.positionScreen.y),ma.intersects(Y)&&u(r,v,W,ca,a);else if(W instanceof THREE.RenderableFace3)r=W.v1,v=W.v2,y=W.v3,r.positionScreen.x*=o,r.positionScreen.y*=p,v.positionScreen.x*=o,v.positionScreen.y*=p,y.positionScreen.x*=o,y.positionScreen.y*=p,ca.overdraw&&(ka(r.positionScreen,
v.positionScreen),ka(v.positionScreen,y.positionScreen),ka(y.positionScreen,r.positionScreen)),Y.add3Points(r.positionScreen.x,r.positionScreen.y,v.positionScreen.x,v.positionScreen.y,y.positionScreen.x,y.positionScreen.y),ma.intersects(Y)&&C(r,v,y,0,1,2,W,ca,a);else if(W instanceof THREE.RenderableFace4)r=W.v1,v=W.v2,y=W.v3,K=W.v4,r.positionScreen.x*=o,r.positionScreen.y*=p,v.positionScreen.x*=o,v.positionScreen.y*=p,y.positionScreen.x*=o,y.positionScreen.y*=p,K.positionScreen.x*=o,K.positionScreen.y*=
p,$.positionScreen.copy(v.positionScreen),da.positionScreen.copy(K.positionScreen),ca.overdraw&&(ka(r.positionScreen,v.positionScreen),ka(v.positionScreen,K.positionScreen),ka(K.positionScreen,r.positionScreen),ka(y.positionScreen,$.positionScreen),ka(y.positionScreen,da.positionScreen)),Y.addPoint(r.positionScreen.x,r.positionScreen.y),Y.addPoint(v.positionScreen.x,v.positionScreen.y),Y.addPoint(y.positionScreen.x,y.positionScreen.y),Y.addPoint(K.positionScreen.x,K.positionScreen.y),ma.intersects(Y)&&
L(r,v,y,K,$,da,W,ca,a);Z.addRectangle(Y)}k.setTransform(1,0,0,1,0,0)}};THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};THREE.RenderableObject=function(){this.z=this.object=null};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.material=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.material=null};
