# Copyright 2020-2023 the openage authors. See copying.md for legal info.
#
# pylint: disable=line-too-long

"""
Age of Empires games do not necessarily come with an english
translation. Therefore, we use the strings in this file to
figure out the names for a nyan object.
"""


# key: head unit id; value: (nyan object name, filename prefix)
# For unit lines with different graphics per civ only the unit line of
# the first civ (Empire) is stored
UNIT_LINE_LOOKUPS = {
    2: ("FambaaShieldGenerator", "fambaa_shield_generator"),
    4: ("RoyalCrusader", "royal_crusader"),
    6: ("Airspeeder", "airspeeder"),
    8: ("Berserker", "berserker"),
    13: ("UtilityTrawler", "utility_trawler"),
    48: ("WildFambaa", "wild_fambaa"),
    115: ("ForceMaster", "force_master"),
    118: ("Worker", "worker"),
    174: ("DestroyerDroid", "destroyer_droid"),
    180: ("ForceKnight", "force_knight"),
    307: ("Trooper", "trooper"),
    359: ("MountedTrooper", "mounted_trooper"),
    381: ("GrenadeTrooper", "grenade_trooper"),
    438: ("AntiAirTrooper", "anti_air_trooper"),
    469: ("StrikeMech", "strike_mech"),
    481: ("Ackley", "ackeley"),
    485: ("MechDestroyer", "mech_destroyer"),
    500: ("AssaultMech", "assault_mech"),
    550: ("Scout", "scout"),
    594: ("Nerf", "nerf"),
    625: ("AirCruiser", "air_cruiser"),
    641: ("JediStarfighter", "jedi_starfighter"),
    642: ("GeonosianWarrior", "geonosian_warrior"),
    691: ("Artillery", "artillery"),
    702: ("AntiAirMobile", "anti_air_mobile"),
    713: ("Pummel", "pummel"),
    762: ("Bomber", "bomber"),
    773: ("Fighter", "fighter"),
    815: ("Cruiser", "cruiser"),
    822: ("Falumpaset", "faumpaset"),
    833: ("Bantha", "bantha"),
    838: ("TransportShip", "transport_ship"),
    860: ("Nexu", "nexu"),
    868: ("Frigate", "frigate"),
    898: ("Destroyer", "destroyer"),
    918: ("AntiAirDestroyer", "anti_air_destroyer"),
    921: ("Reek", "reek"),
    931: ("CargoTrader", "cargo_trader"),
    939: ("Medic", "medic"),
    951: ("Cannon", "cannon"),
    961: ("BountyHunter", "bounty_hunter"),
    983: ("Cannon", "cannon"),
    993: ("DarkTrooper", "dark_trooper"),
    1009: ("PowerDroid", "power_droid"),
    1034: ("Probot", "probot"),
    1036: ("AirTransport", "air_transport"),
    1203: ("Mynock", "mynock"),
    1249: ("Dewback", "dewback"),
    1363: ("Kaadu", "kaadu"),
    1364: ("Ronto", "ronto"),
    1365: ("Eopie", "eopie"),
    1366: ("Tauntaun", "tauntaun"),
    1367: ("CuPa", "cu_pa"),
    1469: ("Massiff", "massiff"),
    1471: ("Orray", "orray"),
    1473: ("Shaak", "shaak"),
    1475: ("WompRat", "womp_rat"),
    1582: ("AWing", "a_wing"),
}


# key: head unit id; value: (head units of civ lines)
CIV_LINE_ASSOCS = {
    115: (89, 115, 125, 134, 136, 140, 643, 645),
    180: (52, 180, 183, 204, 232, 239, 647, 652),
    307: (238, 280, 282, 286, 307, 309, 1548, 1552),
    359: (289, 359, 361, 370, 376, 378, 1043, 1047),
    381: (292, 381, 383, 385, 387, 389, 1478, 1482),
    438: (305, 438, 440, 442, 444, 446, 1540, 1544),
    469: (244, 469, 471, 473, 475, 479, 903, 907),
    485: (246, 485, 489, 493, 495, 497, 911, 915),
    500: (249, 500, 502, 508, 514, 517, 919, 923),
    550: (258, 550, 552, 554, 556, 558, 927, 932),
    625: (619, 620, 625, 628, 630, 632, 634, 636),
    691: (203, 691, 693, 695, 698, 700, 1551, 1553),
    702: (207, 702, 704, 706, 708, 711, 1555, 1557),
    713: (231, 713, 715, 717, 719, 721, 1559, 1561),
    762: (127, 762, 764, 766, 769, 771, 1523, 1524),
    773: (158, 773, 775, 777, 779, 781, 1525, 1526),
    815: (190, 815, 818, 820, 823, 825, 1509, 1511),
    838: (191, 838, 839, 840, 841, 842, 1513, 1515),
    868: (187, 868, 870, 872, 874, 876, 1497, 1499),
    898: (186, 898, 900, 902, 904, 906, 1493, 1495),
    918: (188, 918, 920, 922, 924, 926, 1501, 1503),
    939: (167, 939, 941, 943, 945, 947, 996, 1005),
    961: (170, 961, 963, 965, 967, 969, 1533, 1535),
    951: (169, 951, 952, 953, 954, 955, 1531, 1532),
    1009: (1007, 1008, 1009, 1010, 1011, 1012, 1013, 1014),
    1036: (1036, 1038, 1040, 1042, 1044, 1046, 1521, 1522),
}

# There is one jedi/sith for every civ
# key: jedi/sith unit id; value: switch unit id
MONK_GROUP_ASSOCS = {
    # Jedi/Sith Knight
    52: 15,
    180: 151,
    183: 152,
    204: 154,
    232: 157,
    239: 178,
    647: 648,
    652: 649,

    # Jedi/sith Master
    89: 33,
    115: 98,
    125: 100,
    134: 107,
    136: 111,
    140: 114,
    643: 1564,
    645: 1566,
}


# key: head unit id; value: (nyan object name, filename prefix)
BUILDING_LINE_LOOKUPS = {
    12: ("PowerCore", "power_core"),
    45: ("Shipyard", "shipyard"),
    49: ("HeavyWeaponsFactory", "heavy_weapons_factory"),
    50: ("Farm", "farm"),
    68: ("FoodProcCenter", "food_proc_center"),
    70: ("PrefabShelter", "prefab_shelter"),
    72: ("LightWall", "light_wall"),
    79: ("LaserTurret", "laser_turret"),
    82: ("Fortress", "fortress"),
    84: ("Spaceport", "spaceport"),
    87: ("TroopCenter", "troop_center"),
    101: ("MechFactory", "mech_factory"),
    103: ("WarCenter", "war_center"),
    104: ("Temple", "temple"),
    109: ("CommandCenter", "command_center"),
    117: ("Wall", "wall"),
    199: ("AquaHarvester", "aqua_harvester"),
    209: ("ResearchCenter", "research_center"),
    236: ("AntiAirTurret", "anti_air_turret"),
    276: ("Monument", "monument"),
    317: ("Airbase", "airbase"),
    319: ("AnimalNursery", "animal_nursery"),
    323: ("NovaProcCenter", "nova_proc_center"),
    335: ("ShieldGenerator", "shield_generator"),
    487: ("Gate", "gate"),
    562: ("CarbonProcCenter", "carbon_proc_center"),
    584: ("OreProcCenter", "ore_proc_center"),
    598: ("SentryPost", "sentry_post"),
    1576: ("SensorBuoy", "sensor_buoy"),
}

# key: (head) unit id; value: (nyan object name, filename prefix)
AMBIENT_GROUP_LOOKUPS = {
    59: ("BerryBush", "berry_bush"),
    66: ("NovaMine", "nova_mine"),
    102: ("OreMine", "ore_mine"),
    217: ("CarbonRockRed", "carbon_rock_red"),
    285: ("Holocron", "holocron"),
    348: ("OakTree", "oak_tree"),
    349: ("PalmTree", "palm_tree"),
    350: ("ScrewedTree", "screwed_tree"),
    351: ("LeaflessTree", "leafless_tree"),
    411: ("TimberTree", "timber_tree"),
    413: ("PineTree", "pine_tree"),
    414: ("JungleTree", "jungle_tree"),
    1341: ("CarbonRock", "carbon_rock"),
}

# key: index; value: (nyan object name, filename prefix, units belonging to group, variant type)
VARIANT_GROUP_LOOKUPS = {
    69: ("Shorefish", "shore_fish", (69,), "misc"),
    96: ("Bird", "bird", (96, 816), "misc"),
    264: ("Cliff", "cliff", (264, 265, 266, 267, 268, 269, 270, 271, 272, 273), "angle"),
    450: ("BigOceanFish", "big_ocean_fish", (450, 451), "random"),
    455: ("OceanFish", "ocean_fish", (455, 456, 457, 458), "random"),
}

# key: head unit id; value: (nyan object name, filename prefix)
TECH_GROUP_LOOKUPS = {
    1: ("TechLevel2", "tech_level_2"),
    2: ("TechLevel3", "tech_level_3"),
    3: ("TechLevel4", "tech_level_4"),
    9: ("AWing", "a_wing"),
    33: ("BasicTraining", "basic_training"),
    61: ("HolonetTranceiver", "holonet_traceiver"),
    62: ("BothanSpynet", "bothan_spynet"),
    63: ("ElevationTracking", "elevation_tracking"),
    64: ("LightPlating", "light_plating"),
    65: ("BasicArmor", "basic_armor"),
    66: ("PrimaryFocusingCoils", "primary_focusing_coils"),
    67: ("HeavyArmor", "heavy_armor"),
    68: ("HeavyPlating", "heavy_plating"),
    69: ("TargetingSensors", "targeting_sensors"),
    70: ("EnlargedBombHold", "enlarged_bomb_hold"),
    71: ("FlightSchool", "flight_school"),
    72: ("EfficientManufactering", "efficient_manufacturing"),
    73: ("ShieldModifications", "shield_modifications"),
    74: ("CoolingSleeves", "cooling_sleeves"),
    75: ("ExternalSensorPod", "external_sensor_pod"),
    76: ("AdvancedFlightSchool", "advanced_flight_school"),
    77: ("ArmoredPlates", "armored_plates"),
    78: ("AdvancedEngines", "advanced_engines"),
    79: ("LightArmor", "light_armor"),
    80: ("MediumPlating", "medium_plating"),
    81: ("AdvancedPowerPack", "advanced_power_pack"),
    82: ("Stimulants", "stimulants"),
    83: ("Genetics", "genetics"),
    126: ("SensorBeacon", "sensor_beacon"),
    127: ("Cloning", "cloning"),
    128: ("UpgradedMotivator", "upgraded_motivator"),
    129: ("OptimizedMotivator", "optimized_motivator"),
    130: ("SensorArray", "sensor_array"),
    132: ("FusionExtractor", "fusion_extractor"),
    133: ("SelfRegeneraration", "self_regeneration"),
    134: ("Irrigation", "irrigation"),
    135: ("HarvestingProgram", "harvesting_program"),
    136: ("AdvancedHarvestingProgram", "advanced_harvesting_program"),
    137: ("BattleArmor", "battle_armor"),
    138: ("Taxation", "taxation"),
    139: ("AttackProgramming", "attack_programming"),
    141: ("Presidium", "presidium"),
    143: ("BerserkerJetPacks", "berserker_jet_packs"),
    144: ("StrengthenedFrame", "strengthened_frame"),
    145: ("CreatureTraining", "creature_training"),
    146: ("ReinforcedFrame", "reinforced_frame"),
    147: ("Mechanics", "mechanics"),
    148: ("ForestVision", "forest_vision"),
    149: ("NovaBeamdrillMining", "beamdrill_mining_nova"),
    150: ("HeavyNovaBeamdrill", "heavy_beamdrill_nova"),
    151: ("ForceAgility", "force_agility"),
    152: ("ForceConcentration", "force_concentration"),
    153: ("ForceRegeneration", "force_regeneration"),
    154: ("ForceStrength", "force_strength"),
    155: ("FaithInTheForce", "faith_in_the_force"),
    156: ("ForceInfluence", "force_influence"),
    157: ("ForceStrong", "force_strong"),
    158: ("ForcePerception", "force_perception"),
    159: ("JediMindTrick", "jedi_mind_trick"),
    160: ("HandheldCarbonExtractor", "handheld_carbon_extractor"),
    161: ("EnhancedCarbonExtractor", "enhanced_carbon_extractor"),
    162: ("HeavyCarbonExtractor", "heavy_carbon_extractor"),
    163: ("UpgradedGenerator", "upgraded_generator"),
    164: ("WalkerResearch", "walker_research"),
    166: ("AdvancedGenerator", "advanced_generator"),
    167: ("GunganCreatureArmor", "gungan_creature_armor"),
    168: ("AdvancedRedesign", "advanced_redesign"),
    169: ("WookieIngenuity", "wookie_ingenuity"),
    170: ("Technicians", "technicians"),
    171: ("OreBeamdrillMining", "beamdrill_mining_ore"),
    172: ("HeavyOreBeamdrill", "heavy_beamdrill_ore"),
    173: ("Durasteel", "durasteel"),
    174: ("IonAccelerator", "ion_accelerator"),
    175: ("PowerCalibrator", "power_calibrator"),
    176: ("RotationBearings", "rotation_bearings"),
    177: ("TrackingComputer", "tracking_computer"),
    178: ("HomingSensors", "homing_sensors"),
    179: ("HeavyWeaponsEngineers", "heavy_weapons_engineers"),
    180: ("PermacitePlating", "permacite_plating"),
    183: ("RedesignedSpecs", "redesigned_specs"),
    184: ("AdvancedPropulsion", "advanced_propulsion"),
    185: ("RedoubledEfforts", "redoubled_efforts"),
    186: ("AdvancedScanning", "advanced_scanning"),
    187: ("FasterGrowthChambers", "faster_growth_chambers"),
    188: ("HuttEndorsement", "hutt_endorsement"),
    189: ("NeimoidianEndorsement", "neimoidian_endorsement"),
    190: ("GalacticBanking", "galactic_banking"),
    192: ("InsiderTrading", "insider_trading"),
    193: ("GalacticTradeComission", "galactic_trade_comission"),
    194: ("AlteredBargains", "altered_bargains"),
    195: ("MarketControl", "market_control"),
    196: ("DroidAssistents", "droid_assistents"),
    197: ("MacroBinoculars", "macro_binoculars"),
    198: ("LighterArmor", "lighter_armor"),
    199: ("PortableScanner", "portable_scanner"),
    201: ("FarSeeInBinoculars", "far_see_in_binoculars"),
    202: ("IncreasedExplosiveYields", "increased_explosive_yields"),
    203: ("IntegratedRangefinder", "integrated_rangefinder"),
    204: ("TougherArmor", "tougher_armor"),
    205: ("Dexterity", "dexterity"),
    206: ("AutomatedProcesses", "automated_processes"),
    500: ("ForceMeditation", "force_meditation"),
    501: ("BactaTanks", "bacta_tanks"),
    535: ("GrenadierTraining", "grenadier_training"),
    568: ("AntiAirRetrofit", "anti_air_retrofit"),
    569: ("StrenghtenedSuperstructure", "streghtened_superstructure"),
    570: ("SuperconductingShields", "superconducting_shields"),
    571: ("EfficientBuildings", "efficient_buildings"),
    572: ("PowerCoreShielding", "power_core_shielding"),
    573: ("StregthenedAssembly", "strengthened_assembly"),
    574: ("GeonosianDiligence", "geonosian_diligence"),
    575: ("ConfederacyAlliance", "confederacy_alliance"),
    576: ("GeonosianEngineers", "geonosian_engineers"),
    577: ("DroidUpgrades", "droid_upgrades"),
    578: ("UpgradedMedicDroids", "upgraded_medic_droids"),
    579: ("KaminoanCloners", "kaminoan_cloners"),
    580: ("GalacticSenateHub", "galactic_senate_hub"),
    581: ("SightBeyondSight", "sight_beyond_sight"),
    582: ("KaminoanRefit", "kaminoan_refit"),
    583: ("AirCruiserBoost", "air_cruiser_boost"),

    # Unit/Building upgrades
    113: ("HeavyDestroyerDroid", "heavy_destroyer_droid"),
    222: ("ForceKnightUpgrade", "force_knight_upgrade"),
    236: ("AdvancedMountedTrooper", "advanced_mounted_trooper"),
    241: ("HeavyMountedTrooper", "heavy_mounted_trooper"),
    246: ("HeavyAntiAirTrooper", "heavy_anti_air_trooper"),
    251: ("HeavyTrooper", "heavy_trooper"),
    256: ("RepeaterTrooper", "repeater_trooper"),
    261: ("TrooperUpgrade", "trooper_upgrade"),
    301: ("HeavyStrikeMech", "heavy_strike_mech"),
    306: ("HeavyMechDestroyer", "heavy_mech_destroyer"),
    311: ("HeavyAssaultMech", "heavy_assault_mech"),
    331: ("HeavyArtillery", "heavy_artillery"),
    341: ("HeavyAntiAirMobile", "heavy_anti_air_mobile"),
    346: ("HeavyPummel", "heavy_pummel"),
    366: ("AdvancedBomber", "advanced_bomber"),
    371: ("AdvancedFighter", "advanced_fighter"),
    376: ("EnhancedBomber", "enhanced_bomber"),
    381: ("FastFighter", "fast_fighter"),
    416: ("AdvancedFrigate", "advanced_frigate"),
    421: ("AdvancedCruiser", "advanced_cruiser"),
    426: ("HeavyDestroyer", "heavy_destroyer"),
    431: ("HeavyAntiAirDestroyer", "heavy_anti_air_destroyer"),
    441: ("FrigateUpgrade", "frigate_upgrade"),
    447: ("AdvancedAntiAirTurret", "advanced_anti_air_turret"),
    472: ("DarkTrooperPhase2", "dark_trooper_phase2"),
    474: ("HeavyFambaaShieldGenerator", "heavy_fambaa_shield_generator"),
    475: ("EliteRoyalCrusader", "elite_royal_crusader"),
    476: ("ArmoredAirspeeder", "armored_airspeeder"),
    477: ("AdvancedBerserker", "advanced_berserker"),
    480: ("MediumTurret", "medium_turret"),
    481: ("AdvancedTurret", "advanced_turret"),
    483: ("HeavyWall", "heavy_wall"),
    484: ("ShieldWall", "shield_wall"),
    533: ("AdvancedJediStarfighter", "advanced_jedi_starfighter"),
    534: ("EliteGeonosianWarrior", "elite_geonosian_warrior"),
}

# key: tech id; value: (tech ids of civ line unlocks/upgrades)
CIV_TECH_ASSOCS = {
    222: (93, 222, 223, 224, 225, 226, 544, 545),
    236: (86, 236, 237, 238, 239, 240, 556, 557),
    241: (55, 241, 242, 243, 244, 245, 558, 559),
    246: (45, 246, 247, 248, 249, 250, 560, 561),
    251: (44, 251, 252, 253, 254, 255, 562, 563),
    256: (90, 256, 257, 258, 259, 260, 564, 565),
    261: (43, 261, 262, 263, 264, 265, 566, 567),
    301: (42, 301, 302, 303, 304, 305, 550, 551),
    306: (40, 306, 307, 308, 309, 310, 552, 553),
    311: (99, 311, 312, 313, 314, 315, 554, 555),
    331: (57, 331, 332, 333, 334, 335, 538, 539),
    341: (56, 341, 342, 343, 344, 345, 540, 541),
    346: (59, 346, 347, 348, 349, 350, 542, 543),
    366: (108, 366, 367, 368, 369, 370, 517, 518),
    371: (110, 371, 372, 373, 374, 375, 519, 520),
    376: (107, 376, 377, 378, 379, 380, 521, 522),
    381: (109, 381, 382, 383, 384, 385, 523, 524),
    416: (53, 416, 417, 418, 419, 420, 508, 537),
    421: (51, 421, 422, 423, 424, 425, 509, 510),
    426: (50, 426, 427, 428, 429, 430, 511, 512),
    431: (49, 431, 432, 433, 434, 435, 513, 514),
    441: (52, 441, 442, 443, 444, 445, 515, 516),
}

# key: civ index; value: (nyan object name, filename prefix)
CIV_GROUP_LOOKUPS = {
    0: ("Nature", "nature"),
    1: ("Empire", "empire"),
    2: ("Gungans", "gungans"),
    3: ("Rebels", "rebels"),
    4: ("Naboo", "naboo"),
    5: ("Federation", "federation"),
    6: ("Wookiees", "wokiees"),
    7: ("Republic", "republic"),
    8: ("Confederacy", "confederacy"),
}

# key: civ index; value: (civ ids, nyan object name, filename prefix)
GRAPHICS_SET_LOOKUPS = {
    0: ((0, 1), "Empire", "empire"),
    1: ((2,), "Gungan", "gungan"),
    2: ((3,), "Rebel", "rebel"),
    3: ((4,), "Naboo", "naboo"),
    4: ((5,), "Federation", "federate"),
    5: ((6,), "Wookiee", "wookiee"),
    6: ((7,), "Republican", "reppublican"),
    7: ((8,), "Confederate", "confederate"),
}

# key: terrain index; value: (unit terrain restrictions (manual), nyan object name, filename prefix)
# TODO: Use terrain restrictions from .dat
TERRAIN_GROUP_LOOKUPS = {
    0:  ((0,), "Grass0", "grass0"),
    1:  ((0,), "Water0", "water0"),
    2:  ((0,), "Shore", "shore"),
    3:  ((0,), "Dirt0", "dirt0"),
    4:  ((0,), "Swamp", "swamp"),
    5:  ((0,), "Leaves", "leaves"),
    6:  ((0,), "Dirt1", "dirt1"),
    7:  ((0,), "FarmCrops", "farm_crops"),
    8:  ((0,), "FarmHarvested", "farm_harvested"),
    9:  ((0,), "Grass1", "grass1"),
    10: ((0,), "Forest0", "forest0"),
    11: ((0,), "Dirt2", "dirt2"),
    12: ((0,), "Grass2", "grass2"),
    13: ((0,), "Forest1", "forest1"),
    14: ((0,), "Sand", "sand"),
    15: ((0,), "Clouds", "clouds"),
    16: ((0,), "Space", "space"),
    17: ((0,), "Forest2", "forest2"),
    18: ((0,), "Forest3", "forest3"),
    19: ((0,), "Forest4", "forest4"),
    20: ((0,), "Forest5", "forest5"),
    21: ((0,), "Forest6", "forest6"),
    22: ((0,), "Water1", "water1"),
    23: ((0,), "Water2", "water2"),
    24: ((0,), "Path0", "path0"),
    25: ((0,), "Path1", "path1"),
    26: ((0,), "Desert0", "desert0"),
    27: ((0,), "Foundation", "foundation"),
    28: ((0,), "Water3", "water3"),
    29: ((0,), "FarmConstruction3", "farm_construction3"),
    30: ((0,), "FarmConstruction2", "farm_construction2"),
    31: ((0,), "FarmConstruction1", "farm_construction1"),
    32: ((0,), "Snow0", "snow0"),
    33: ((0,), "Snow1", "snow1"),
    34: ((0,), "Snow2", "snow2"),
    35: ((0,), "Ice", "ice"),
    36: ((0,), "FoundationSnow", "foundation_snow"),
    37: ((0,), "ShoreIce", "shore_ice"),
    38: ((0,), "Path2", "path2"),
    39: ((0,), "Path3", "path3"),
    40: ((0,), "Path4", "path4"),
    41: ((0,), "Grass3", "grass3"),
    42: ((0,), "Rock0", "rock0"),
    43: ((0,), "Metal", "metal"),
    44: ((0,), "Rock1", "rock1"),
    45: ((0,), "Desert1", "desert1"),
    46: ((0,), "Desert2", "desert2"),
    47: ((0,), "Snow3", "snow3"),
    48: ((0,), "FarmGreen", "farm_green"),
    49: ((0,), "MetalCarb", "metal_carb"),
    50: ((0,), "Rock2", "rock2"),
    51: ((0,), "Lava", "lava"),
    52: ((0,), "Rock3", "rock3"),
}

# key: not relevant; value: (terrain indices, unit terrain restrictions (manual), nyan object name)
# TODO: Use terrain restrictions from .dat
TERRAIN_TYPE_LOOKUPS = {
}


CLASS_ID_LOOKUPS = {
    1: "Bantha",
    2: "Fambaa",
    4: "Animal",
    5: "Monster",
    6: "Wall",
    7: "Farm",
    8: "Gate",
    9: "AntiAirTurret",
    10: "LaserTurret",
    11: "Cruiser",
    13: "Destroyer",
    14: "UtilityTrawler",
    15: "Frigate",
    16: "AntiAirDestroyer",
    17: "TransportShip",
    18: "BuildingMisc",
    19: "Doppelganger",
    20: "DeadOrProjectile",     # do not use this as GameEntityType
    21: "HOLDTHIS",             # something from a scenario
    22: "Cliff",
    23: "OceanFish",
    25: "ShoreFish",
    26: "AmbientFlag",
    27: "BerryBush",
    28: "Holocron",
    29: "Nova",
    30: "Ore",
    31: "CarbonTree",
    32: "Artillery",
    33: "AntiAirMobile",
    34: "MobileCannon",
    35: "Pummel",
    36: "Cannon",
    39: "UnderwaterFrigate",
    40: "AntiAirDestroyer",
    42: "EyeCandy",
    43: "Bomber",
    44: "BountyHunter",
    45: "CargoHovercraft",
    46: "ScenarioUnit",                  # should not be present in final modpack
    47: "Scout",
    48: "Fighter",
    49: "GrenadeTrooper",
    50: "Jedi",
    51: "JediWithHolocron",
    52: "Trooper",
    53: "Mech",
    54: "Medic",
    55: "AntiAirTrooper",
    56: "MountedTrooper",
    57: "FambaaShieldGenerator",
    58: "Worker",
    59: "AirTransport",
    60: "Herdable",
    61: "PowerDroid",
    62: "AirCruiser",
    63: "GeonosianWarrior",
    64: "JediStarfighter",
}

# key: genie unit id; value: Gather ability name
GATHER_TASK_LOOKUPS = {
    13: ("Fish", "fish"),  # fishing ship
    56: ("Fish", "fish"),
    57: ("Fish", "fish"),
    120: ("CollectBerries", "collect_berries"),
    354: ("CollectBerries", "collect_berries"),
    122: ("HarvestGame", "harvest_game"),
    216: ("HarvestGame", "harvest_game"),
    123: ("ExtractCarbon", "extract_carbon"),
    218: ("ExtractCarbon", "extract_carbon"),
    124: ("MineOre", "mine_ore"),
    220: ("MineOre", "mine_ore"),
    214: ("FarmCrops", "farm_crops"),
    259: ("FarmCrops", "farm_crops"),
    579: ("MineNova", "mine_nova"),
    581: ("MineNova", "mine_nova"),
    590: ("HarvestLivestock", "harvest_livestock"),
    592: ("HarvestLivestock", "harvest_livestock"),
}

# key: restock target unit id; value: Gather ability name
RESTOCK_TARGET_LOOKUPS = {
    50: ("ReseedFarm", "reseed_farm"),
}

# key: armor class; value: Gather ability name
ARMOR_CLASS_LOOKUPS = {
    0: "AirCraft",
    1: "HeavyAssaultMech",
    2: "HeavyMech",
    3: "Energy",
    4: "Melee",
    5: "ForceUnit",
    6: "AssaultMachine",
    7: "Decimator",
    8: "Shielded",
    9: "Ship",
    10: "Submarine",
    11: "Building",
    13: "DefenseBuilding",
    14: "Trooper",
    15: "MountedTrooper",
    16: "Cruiser",
    17: "HeavySiege",
    19: "Worker",
    20: "Destroyer",
    21: "StandardBuilding",
    22: "Wall",
    23: "AirCruiser",
    24: "WildAnimal",
    26: "Fortress",
    30: "TameAnimal",
}

# key: command type; value: Apply*Effect ability name
COMMAND_TYPE_LOOKUPS = {
    7: ("Attack", "attack"),
    101: ("Construct", "construct"),
    104: ("Convert", "convert"),
    105: ("Heal", "heal"),
    106: ("Repair", "repair"),
    110: ("Hunt", "hunt"),
}
