# Copyright 2023-2024 the openage authors. See copying.md for legal info.

"""
Test whether the openage nyan API modpack is present.
"""
from __future__ import annotations
import typing

import toml

from ....log import info, dbg

from .modpack_search import get_modpack_info

if typing.TYPE_CHECKING:
    from openage.util.fslike.union import UnionPath


CURRENT_API_VERSION = "0.5.0"


def api_export_required(asset_dir: UnionPath) -> bool:
    """
    Returns true if the openage nyan API modpack cannot be found or is outdated.

    TODO: Remove once the API modpack is generated by default.

    :param asset_dir: The asset directory to search in.
    :type asset_dir: UnionPath
    :returns: True if the openage nyan API modpack cannot be found, else False.
    """
    modpack_dir = asset_dir / "converted" / "engine"

    try:
        modpack_info = get_modpack_info(modpack_dir)
        version = modpack_info["info"]["version"]

        if version != CURRENT_API_VERSION:
            info("openage nyan API modpack is outdated")
            dbg("version is %s, expected %s", version, CURRENT_API_VERSION)
            return True

        info("openage nyan API modpack is up to date")
        return False

    except (FileNotFoundError, TypeError, toml.TomlDecodeError):
        info("openage nyan API modpack not found")

    return True
