# [0.6.0] - 2024-11-26
All notable changes for version [0.6.0] are documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html) since release [0.4.0].

## Added

- Flow field pathfinder
- Activity system for controlling the behavior of game entities
- Drag selection of game entities in the UI
- `clang-format` comment formatting
- Log messages for creation of uniform buffers
- nix flake
- GDB pretty printers for various internal data types
  - Time types (`time::time_t`)
  - Fixed point values
  - Coordinate types
  - openage arrays (`util::Vector`)
  - Curve keyframes
  - Flow field types
- Support for multiple meshes per terrain
- Frustum culling
- Example screenshots for the renderer demos
- Check for outdated modpacks on startup
- Camera boundaries to prevent camera movement outside of the map terrain
- Creation of temporary files/directories
- [Windows] Default paths for DLL searching on startup
- [Windows] DLL manager class in converter to support loading DLLs in multi-threaded conversion

## Changed

- Use multithreading for media export in the converter
- Rework curve container `Queue` to be more user-friendly
  - `front(t)`/`pop_front(t)` now return the most recently added element before time `t`
  - track lifetime of elements by storing insertion time (`alive` time) and erasure time (`dead` time)
  - queue elements are now sorted by insertion time
- Curves now use `std::vector` for their keyframe storage to increase performance
- Window settings are passed as `struct` instead of arguments
- Sprite scaling is now handled in shader
- Replace `constexpr` with `consteval` where appropriate
- Optimize renderer
  - Vectorize shader uniform (buffer) input storage
  - Replace shared pointer usage with references
- Use raw pointers instead of shared pointers in pairing heap implementation


## Deprecated

- Old pathfnder code (`libopenage/pathfinding`)

## Removed

- Exception propagation to Python with `_PyTraceback_Add`

## Fixed

- Bullet point formatting in event system documentation
- Uniform alignment in uniform buffers
- Input contexts are now handled in the correct order (top to bottom)
- Support for GCC 14
- Support for Clang 19
- DE2 conversion
  - *The Mountain Royals* DLC
  - *Battle for Greece* DLC
- Thread-safety of render entity
- Documentation for the single file converter
- Numerous documentation typos and mistakes
- [Windows] Order of inclusion for `DbgHelp.h`
- [Windows] Build instructions
- [macOS] Build instructions


## Full commit log

https://github.com/SFTtech/openage/compare/v0.5.3...v0.6.0
