# [0.5.3] - 2023-12-15
All notable changes for version [0.5.3] are documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html) since release [0.4.0].

## Added

- Temporary file/directory support for Python files
- More debug info in converter
- More fixed-point math functions
- Dependencies
  - Qt Multimedia
  - `setuptools` is now conditional dependency for Python >= 3.12 && Cython < 3.1

## Changed

- Make `main` the default entrypoint command for openage binary

## Removed

- Legacy subsystem code
  - Asset management (yes, there were 3 deprecated asset managers)
    - `openage::AssetManager`
    - `openage::LegacyAssetManager`
    - `openage::presenter::AssetManager`
  - Deprecated Coordinate types (`libopenage/coord`)
    - CoordManager
    - Deprecated transformations between types
  - Gamedata dummy classes (`libopenage/gamedata`)
  - Old gamestate
    - Game logic (`libopenage/gamestate/old`)
    - Unit handling  (`libopenage/unit`)
  - Old input system (`libopenage/input/legacy`)
  - Old GUI (`libopenage/gui`)
  - Old renderer
    - Logic (`libopenage/presenter/legacy`)
    - Data classes (texure, etc.)
  - Old Terrain (`libopenage/terrain`)
- Dependencies
  - SDL2
  - SDL2 Image

## Fixed

- Version tag format without `--long` crashes on tagged commits
- Dangling reference in modpack info file loading
- No graphics visible on Wayland
- Wrong anchor positions when sprite is mirrored
- Several typos in documentation


## Full commit log

https://github.com/SFTtech/openage/compare/v0.5.2...v0.5.3
