# [0.2.3] - 2014-11-18
All notable changes for version [v0.2.3] are documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html) since release [v0.4.0].

Note that not all changes up until [v0.2.3] were tracked, since the project was not available on Github as an SFTtech/openage repository. The commit hiistory can be accessed via the git log though. Feel free to add missing changes to this file, if you have time to look through a thousand commits.

## Added
- `gperftools` profiler
- Reminder in `contributing.md` to add oneself when contributing for the first time
- Toggle HUD drawing with `F1` hotkey
- Toggle debug overlay with `F4` hotkey
- Add `contributing.md` with basic Pull Request how-to
- Add argument '--version' to executable
- `.desktop` file and placeholder icon
- Include GPL3+ legal headers in code files
- Draft for campaign editor
- Ideas for AI features
- Automatic asset updating with `inotify()`
- Include timestamp and numbering in screenshot filename
- Version number now displayed in lower left corner
- Basic unit behavior
    - Attack
    - Move
    - Gather
- A* pathfinding
- Build instructions for Ubuntu
- Build instructions for Arch Linux
- Build instructions for Fedora
- Build instructions for OpenSUSE
- Build instructions for Mac OS X
- Media conversion of AoE2: HD edition (patch 4.3)
- Feature demos of engine modules
- Add support for extracting `.cab` files

## Changed
- Split up game specification code generation
- Improve unknown enum value error message
- Change hotkeys for screenshot and blending toggle from `KEYDOWN` to `KEYUP`
- Load gamedata and UI separately
- Rewrite of DRS and SLP documentation files with more info
- Move terrain logic to own subfolder
- Use "British" as default civ instead of "Gaia"
- Change data directory location to `./assets` subfolder
- Use $(MAKE) variable in main Makefile instead of explicitely calling `make`
- Move platform specific includes to separate header file
- Refactor the opusfile CMake rules into own module
- Include `termios.h` instead of `termio.h`
- Move finding Python in separate CMake module
- Better documentation of project architecture structure
- Converted documentation to Markdown format
- Buildsystem overhaul

## Fixed
- Fix `path.cpp` compilation error in mac clang
- Fix warnings on 32 bit systems
- Divide negatives in renderer correctly
- Use platform-independent `gettempdir` instead of `/tmp/` in converter
- Play correct building creation and destruction sounds
- Add `-Wno-mismatched-tags` flag for llvm builds to prevent Travis warnings
- Cleanup of C++ code with `cppcheck`
- Fix include of OpenGL headers on OS X systems
- Fix reserved identifier violations
- Fix ambiguous call to `abs` for llvm compiler
- Fix `SDL2_image` include directory hints for OS X systems
- Fix inclusion of `pty.h` header
- Fix A* for Xcode 6.0
- Fix format specifier for `long long` data types
- Add AoE2: HD Edition to supported asset source versions
- Fix dead link to `milestones.md` in `development.md`
- Fix dead link to `milestones.md` in `tasks.md`
- Use capitals for headlines and first word of bullet points
- Various horrible typos (#13, #17, #19, #20, #21, #105, #119, #146)

## Full commit log

https://github.com/SFTtech/openage/compare/v0.2.2...v0.2.3
