# Market

Source: [here](http://ageofempires.wikia.com/wiki/Market_(Age_of_Empires_II)) for the first part - fixed through reverse engineering.

[here](https://www.youtube.com/watch?v=NvsM9B4ac2g) for the rest.

Gold from trading calculation, tribute system, buying/selling resources and the destruction of markets.

## Trade Cart gold calculation

The gold you receive from trading with a market depends on the *distance in tiles* (or *distance in tile width*) between the two markets. The further the markets are apart from each other, the more gold is generated by a trade cart.

Generated amount of gold is not linear to the distance in tiles. Note that the gold value shown when you select the market is rounded but the gold you receive is not. This means that in the case of two markets being placed next to each other, trade carts will still generate a tiny fraction of gold.

### Math

## Age of Kings

    (gold value) = (d/size + 0.3) * d * 0.46 + 0.5

with
`size`, the map size in tiles along the edge of the map and
`d` is calculated as follows:

    d = max(0.0, sqrt(max(0.0, deltaX-4)^2 + max(0.0, deltaY-4)^2))

with `deltaX` and `deltaY` the distances between the Markets in either axis-aligned direction, measured from the center of each Market.

## The Conquerors

    (gold value) = 2 * (d/size + 0.3) * d * A ) / B   + 0.5

`A` and `B` may depend on civilization attributes and on the speed of the trade vehicle (trade cog or cart), or its radius.

    d = max(0.1, sqrt(max(0.0, deltaX-5)^2 + max(0.0, deltaY-5)^2))

## Tribute

Tribute can be sent to other players using the tribute menu in the upper right corner. The number of resources you are sending to a player is shown on top of the buttons of the receiving player. On top of that the tributing player has to pay a fee. The amount of resources left *after sending tribute* can be seen in the line with the players name in it:

    (amount of resource) = (current stockpile) - ((tribute amount) + (tribute fee) * (tribute amount))

## Prices

All prices for buying/selling resources are global. Thus every player in a game sees the same price and is affected by price changes. If the market is selected, prices are shown in two rows, with the upper one being the selling price and the lower one being the price for buying. The number that is shown, represents the amount of gold that the player has to spent to buy 100 units of the resource.

Both buying and selling price are calculated from the same *base price*. Buying a resource always costs 30 % *more* gold than the base price. Selling it costs 30 % *less*. The base price at the beginning of a game ist always 100 for wood and food, while being 130 for stone.

    sell price = 70
    base price = 100
    buy  price = 130

Every time any player sells 100 resources of any kind, the base price of this resource decrements by 3. Buying a resource increments the base price by 3.

    sell price = 70  ---> sell price = 68
    base price = 100 ---> base price = 97
    buy  price = 130 ---> buy  price = 127

The lowest the base price can go is 20, while the highest base price is 9999.

    sell price = 70  ---> sell price = 68  ---> ... ---> sell price = 14
    base price = 100 ---> base price = 97  ---> ... ---> base price = 20
    buy  price = 130 ---> buy  price = 127 ---> ... ---> buy  price = 26

## Destroying a market

There are two possible scenarios.

### The trading partners' market is destroyed

Trade Carts will not seek an alternative market to trade with. As soon as the market is destroyed, all of you trade carts that are trading with it return to your own market and stay there. Trade carts that are already on their way back from your ally will still deliver the gold that they are carrying and then stop at your market.

### Your market is destroyed

If you only had one market, trade carts will stop and immediately lose all carried gold.

If you happen to have more than one market, trade carts will choose the market which is closest *from their current position* as their new trade destination.

## Weird AoE2 Quirks

* You can trade with enemy markets.
* Full trade carts cannot be loaded onto a transport ship. As soon as you give the order to board the ship, they change into an empty cart, dropping all of their gold.
