// Copyright 2013-2021 the openage authors. See copying.md for legal info.

// Warning: this file is a dummy file and was auto-generated by the v0.4.1 converter;
// its purpose is to keep the deprecated gamestate compilable and intact;
// these files keep only the minimum functionality and should not be changed;
// For details, see buildsystem/codegen.cmake and openage/codegen.


#include <cstdio>
#include <vector>
#include "error/error.h"
#include "texture_dummy.h"
#include "util/strings.h"


namespace openage {
namespace gamedata {

constexpr size_t subtexture::member_count;
int subtexture::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', subtexture::member_count
    );

    if (buf.size() != subtexture::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing subtexture led to "
            << buf.size()
            << " columns (expected "
            << subtexture::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%d", &this->x) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%d", &this->y) != 1) { return 1; }
    if (sscanf(buf[2].c_str(), "%d", &this->w) != 1) { return 2; }
    if (sscanf(buf[3].c_str(), "%d", &this->h) != 1) { return 3; }
    if (sscanf(buf[4].c_str(), "%d", &this->cx) != 1) { return 4; }
    if (sscanf(buf[5].c_str(), "%d", &this->cy) != 1) { return 5; }

    return -1;
}

bool subtexture::recurse(const openage::util::CSVCollection & /*storage*/, const std::string & /*basedir*/) {
    return true;
}

} // gamedata
} // openage
