// Copyright 2013-2021 the openage authors. See copying.md for legal info.

// Warning: this file is a dummy file and was auto-generated by the v0.4.1 converter;
// its purpose is to keep the deprecated gamestate compilable and intact;
// these files keep only the minimum functionality and should not be changed;
// For details, see buildsystem/codegen.cmake and openage/codegen.


#include <cstdio>
#include <vector>
#include "error/error.h"
#include "graphic_dummy.h"
#include "util/strings.h"


namespace openage {
namespace gamedata {

constexpr size_t graphic::member_count;
constexpr size_t graphic_attack_sound::member_count;
constexpr size_t graphic_delta::member_count;
constexpr size_t sound_prop::member_count;
int graphic_attack_sound::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', graphic_attack_sound::member_count
    );

    if (buf.size() != graphic_attack_sound::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing graphic_attack_sound led to "
            << buf.size()
            << " columns (expected "
            << graphic_attack_sound::member_count
            << ")!"
        );
    }

    this->sound_props.filename = buf[0];

    return -1;
}

bool graphic_attack_sound::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->sound_props.read(storage, basedir);

    return true;
}

int graphic_delta::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', graphic_delta::member_count
    );

    if (buf.size() != graphic_delta::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing graphic_delta led to "
            << buf.size()
            << " columns (expected "
            << graphic_delta::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%hd", &this->graphic_id) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%hd", &this->padding_1) != 1) { return 1; }
    if (sscanf(buf[2].c_str(), "%d", &this->sprite_ptr) != 1) { return 2; }
    if (sscanf(buf[3].c_str(), "%hd", &this->offset_x) != 1) { return 3; }
    if (sscanf(buf[4].c_str(), "%hd", &this->offset_y) != 1) { return 4; }
    if (sscanf(buf[5].c_str(), "%hd", &this->display_angle) != 1) { return 5; }
    if (sscanf(buf[6].c_str(), "%hd", &this->padding_2) != 1) { return 6; }

    return -1;
}

bool graphic_delta::recurse(const openage::util::CSVCollection & /*storage*/, const std::string & /*basedir*/) {
    return true;
}

int graphic::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', graphic::member_count
    );

    if (buf.size() != graphic::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing graphic led to "
            << buf.size()
            << " columns (expected "
            << graphic::member_count
            << ")!"
        );
    }

    this->name = buf[0];
    this->filename = buf[1];
    if (sscanf(buf[2].c_str(), "%d", &this->slp_id) != 1) { return 2; }
    if (sscanf(buf[3].c_str(), "%hhd", &this->is_loaded) != 1) { return 3; }
    if (sscanf(buf[4].c_str(), "%hhd", &this->old_color_flag) != 1) { return 4; }
    // parse enum graphics_layer
    if (buf[5] == "DUMMY") {
        this->layer = graphics_layer::DUMMY;
    }
    else {
    throw openage::error::Error(
        MSG(err)
        << "unknown enum value '" << buf[5]
        << "' encountered. valid are: "
           "DUMMY\n---\n"
    );}
    if (sscanf(buf[6].c_str(), "%hhd", &this->player_color_force_id) != 1) { return 6; }
    if (sscanf(buf[7].c_str(), "%hhd", &this->adapt_color) != 1) { return 7; }
    if (sscanf(buf[8].c_str(), "%hhu", &this->transparent_selection) != 1) { return 8; }
    if (sscanf(buf[9].c_str(), "%hd", &this->sound_id) != 1) { return 9; }
    if (sscanf(buf[10].c_str(), "%hu", &this->frame_count) != 1) { return 10; }
    if (sscanf(buf[11].c_str(), "%hu", &this->angle_count) != 1) { return 11; }
    if (sscanf(buf[12].c_str(), "%f", &this->speed_adjust) != 1) { return 12; }
    if (sscanf(buf[13].c_str(), "%f", &this->frame_rate) != 1) { return 13; }
    if (sscanf(buf[14].c_str(), "%f", &this->replay_delay) != 1) { return 14; }
    if (sscanf(buf[15].c_str(), "%hhd", &this->sequence_type) != 1) { return 15; }
    if (sscanf(buf[16].c_str(), "%hd", &this->graphic_id) != 1) { return 16; }
    if (sscanf(buf[17].c_str(), "%hhd", &this->mirroring_mode) != 1) { return 17; }
    if (sscanf(buf[18].c_str(), "%hhd", &this->editor_flag) != 1) { return 18; }
    this->graphic_deltas.filename = buf[19];
    this->graphic_attack_sounds.filename = buf[20];

    return -1;
}

bool graphic::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->graphic_deltas.read(storage, basedir);
    this->graphic_attack_sounds.read(storage, basedir);

    return true;
}

int sound_prop::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', sound_prop::member_count
    );

    if (buf.size() != sound_prop::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing sound_prop led to "
            << buf.size()
            << " columns (expected "
            << sound_prop::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%hd", &this->sound_delay) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%hd", &this->sound_id) != 1) { return 1; }

    return -1;
}

bool sound_prop::recurse(const openage::util::CSVCollection & /*storage*/, const std::string & /*basedir*/) {
    return true;
}

} // gamedata
} // openage
