// Copyright 2013-2021 the openage authors. See copying.md for legal info.

// Warning: this file is a dummy file and was auto-generated by the v0.4.1 converter;
// its purpose is to keep the deprecated gamestate compilable and intact;
// these files keep only the minimum functionality and should not be changed;
// For details, see buildsystem/codegen.cmake and openage/codegen.


#include <cstdio>
#include <vector>
#include "error/error.h"
#include "gamedata_dummy.h"
#include "util/strings.h"


namespace openage {
namespace gamedata {

constexpr size_t empiresdat::member_count;
int empiresdat::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', empiresdat::member_count
    );

    if (buf.size() != empiresdat::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing empiresdat led to "
            << buf.size()
            << " columns (expected "
            << empiresdat::member_count
            << ")!"
        );
    }

    this->versionstr = buf[0];
    this->terrain_restrictions.filename = buf[1];
    this->player_colors.filename = buf[2];
    this->sounds.filename = buf[3];
    this->graphics.filename = buf[4];
    if (sscanf(buf[5].c_str(), "%d", &this->virt_function_ptr) != 1) { return 5; }
    if (sscanf(buf[6].c_str(), "%d", &this->map_pointer) != 1) { return 6; }
    if (sscanf(buf[7].c_str(), "%d", &this->map_width) != 1) { return 7; }
    if (sscanf(buf[8].c_str(), "%d", &this->map_height) != 1) { return 8; }
    if (sscanf(buf[9].c_str(), "%d", &this->world_width) != 1) { return 9; }
    if (sscanf(buf[10].c_str(), "%d", &this->world_height) != 1) { return 10; }
    this->tile_sizes.filename = buf[11];
    if (sscanf(buf[12].c_str(), "%hd", &this->padding1) != 1) { return 12; }
    this->terrains.filename = buf[13];
    this->terrain_border.filename = buf[14];
    if (sscanf(buf[15].c_str(), "%d", &this->map_row_offset) != 1) { return 15; }
    if (sscanf(buf[16].c_str(), "%f", &this->map_min_x) != 1) { return 16; }
    if (sscanf(buf[17].c_str(), "%f", &this->map_min_y) != 1) { return 17; }
    if (sscanf(buf[18].c_str(), "%f", &this->map_max_x) != 1) { return 18; }
    if (sscanf(buf[19].c_str(), "%f", &this->map_max_y) != 1) { return 19; }
    if (sscanf(buf[20].c_str(), "%f", &this->map_max_xplus1) != 1) { return 20; }
    if (sscanf(buf[21].c_str(), "%f", &this->map_min_yplus1) != 1) { return 21; }
    if (sscanf(buf[22].c_str(), "%hd", &this->current_row) != 1) { return 22; }
    if (sscanf(buf[23].c_str(), "%hd", &this->current_column) != 1) { return 23; }
    if (sscanf(buf[24].c_str(), "%hd", &this->block_beginn_row) != 1) { return 24; }
    if (sscanf(buf[25].c_str(), "%hd", &this->block_end_row) != 1) { return 25; }
    if (sscanf(buf[26].c_str(), "%hd", &this->block_begin_column) != 1) { return 26; }
    if (sscanf(buf[27].c_str(), "%hd", &this->block_end_column) != 1) { return 27; }
    if (sscanf(buf[28].c_str(), "%d", &this->search_map_ptr) != 1) { return 28; }
    if (sscanf(buf[29].c_str(), "%d", &this->search_map_rows_ptr) != 1) { return 29; }
    if (sscanf(buf[30].c_str(), "%hhd", &this->any_frame_change) != 1) { return 30; }
    if (sscanf(buf[31].c_str(), "%hhd", &this->map_visible_flag) != 1) { return 31; }
    if (sscanf(buf[32].c_str(), "%hhd", &this->fog_flag) != 1) { return 32; }
    this->effect_bundles.filename = buf[33];
    this->unit_headers.filename = buf[34];
    this->civs.filename = buf[35];
    this->researches.filename = buf[36];
    if (sscanf(buf[37].c_str(), "%d", &this->time_slice) != 1) { return 37; }
    if (sscanf(buf[38].c_str(), "%d", &this->unit_kill_rate) != 1) { return 38; }
    if (sscanf(buf[39].c_str(), "%d", &this->unit_kill_total) != 1) { return 39; }
    if (sscanf(buf[40].c_str(), "%d", &this->unit_hitpoint_rate) != 1) { return 40; }
    if (sscanf(buf[41].c_str(), "%d", &this->unit_hitpoint_total) != 1) { return 41; }
    if (sscanf(buf[42].c_str(), "%d", &this->razing_kill_rate) != 1) { return 42; }
    if (sscanf(buf[43].c_str(), "%d", &this->razing_kill_total) != 1) { return 43; }
    if (sscanf(buf[44].c_str(), "%d", &this->total_unit_tech_groups) != 1) { return 44; }
    this->age_connections.filename = buf[45];
    this->building_connections.filename = buf[46];
    this->unit_connections.filename = buf[47];
    this->tech_connections.filename = buf[48];

    return -1;
}

bool empiresdat::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->terrain_restrictions.read(storage, basedir);
    this->player_colors.read(storage, basedir);
    this->sounds.read(storage, basedir);
    this->graphics.read(storage, basedir);
    this->tile_sizes.read(storage, basedir);
    this->terrains.read(storage, basedir);
    this->terrain_border.read(storage, basedir);
    this->effect_bundles.read(storage, basedir);
    this->unit_headers.read(storage, basedir);
    this->civs.read(storage, basedir);
    this->researches.read(storage, basedir);
    this->age_connections.read(storage, basedir);
    this->building_connections.read(storage, basedir);
    this->unit_connections.read(storage, basedir);
    this->tech_connections.read(storage, basedir);

    return true;
}

} // gamedata
} // openage
