# [0.5.0] - 2023-10-03
All notable changes for version [0.5.0] are documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html) since release [0.4.0].

## Added
- New converter to create nyan modpacks
- Support conversion for all game releases:
  - Age of Empires 1 (1997)
  - Age of Empires 1: Definitive Edition
  - Age of Empires 2 (1999)
  - Age of Empires 2: HD Edition
  - Age of Empires 2: Definitive Edition
  - Star Wars Galactic Battlegrounds
  - *Age of Empires 2 (Trial Version)* for demoing the engine
- Support for AoE1:DE and AoE2:DE graphic assets formats and documentation
    - SLP v4.2 (converter)
    - SMP
    - SMX
    - SLD
- Pattern files for decoding AoE graphic assets with imHex
  - SLP
  - SLD
- openage internal media formats documentation
  - modpack definition
  - sprite files (for animations)
  - texture files (for spritesheet textures)
  - palette files (for palette tables)
  - terrain files (for terrain graphics)
  - blendmask files (for terrain blending)
  - blendtable files (for terrain blending)
- Instructions for using vscode IDE
- New engine subsystem implementations
  - Presenter
  - Input System
  - Game Simulation
- Demos for showcasing new engine subsystems
  - 5 new renderer demos
  - 1 new presenter demo
  - 1 new input system demo
  - 2 new game simulation demos
- CI build status badges in README
- New dependencies
  - toml11 (C++)
  - include-what-you-use (CMake, optional)
  - lz4 (Python)
  - mako (Python)
  - toml (Python)
- Type hints for Python code
- NixOS packaging
- Python log messages support lazy evaluation of strings
- Add Ubuntu to optional CI build pipeline
- Progress bar for converter media conversion
- Integrate new renderer subsystem
  - Parsers for openage media formats
  - Game entity rendering
  - Terrain rendering (in 3D!)
  - Camera
  - Simulation clock
- New event-driven game simulation
  - Simulation with event system
  - generic game entities for objects in the game
  - components for game entity attributes
    - Idle
    - Live
    - Move
    - Turn
    - Activity
    - CommandQueue
    - Ownership
    - Position
  - systems for game logic
    - idle
    - move
  - activity implementation for game entity control flow
  - simulation event handlers
    - spawn entity
    - process command
    - send command
    - wait
- New input management
  - low level input handling from Qt
  - high-level controllers for processing inputs
    - game simulation controller
    - camera controller
- Coordinate system improvements
  - new `scene` coordinate type for usage in renderer
- nyan API interface
- Documentation overhaul
  - Documentation for new subsystems
    - renderer
    - GUI
    - game simulation
    - input system
    - time management
  - more guides
    - running the engine
    - optimizing code

## Changed

- Mark old game simulation implementation to legacy
- Update macOS build instructions
- Update dependencies
  - Python >=3.9
  - Cython >=0.29.32
  - gcc >= 10
  - clang >=10
  - qt6 >= 6.2
- Use Github Actions v3
- Exported PNG files are created in-memory
- Replace `unlikely`/`likely` macros with C++20 attributes `[[unlikely]]`/`[[likely]]`
- Integrate new renderer subsystem
  - Use presenter as main interface for graphical display
  - GUI code using Qt6 and new renderer
- Coordinate system improvements
  - deprecate unused coordinate types
    - CoordManager (replaced by camera class)
    - camgame_delta (replaced by camera class)
    - camgame (replaced by camera class)
  - deprecated forbidden coordinate transformations
- Update architecture documentation to reflect new engine architecture

## Removed

- Game simulation code generation from game data (replaced by nyan modpacks)
- Remove unusued dependencies
  - jinja2
  - pyreadline
- Integrate new renderer subsystem
  - Remove dependencies to SDL2 in renderer
- Remove Qt->SDL keybinding transformation from input system
- Obsolete documentation
  - milestones
  - pathfinding

## Fixed

- macOS build on ARM architecture
- Python version detection for Python>=3.10
- Replace Python `distutils` with something that isn't deprecated
- Compatibility with Cython 3.0
- Fix a lot of horrible typos as usual

## Full commit log

https://github.com/SFTtech/openage/compare/v0.4.1...v0.5.0
