# Copyright 2019-2023 the openage authors. See copying.md for legal info.
#
# pylint: disable=line-too-long

"""
Age of Empires games do not necessarily come with an english
translation. Therefore, we use the strings in this file to
figure out the names for a nyan object.
"""

# key: head unit id; value: (nyan object name, filename prefix)
UNIT_LINE_LOOKUPS = {
    4: ("Archer", "archer"),
    5: ("HandCannoneer", "hand_cannoneer"),
    7: ("Skirmisher", "skirmisher"),
    8: ("Longbowman", "longbowman"),
    11: ("Mangudai", "mangudai"),
    13: ("FishingShip", "fishing_ship"),
    17: ("TradeCog", "trade_cog"),
    25: ("TeutonicKnight", "teutonic_knight"),
    35: ("Ram", "ram"),
    36: ("BombardCannon", "bombard_cannon"),
    38: ("Knight", "knight"),
    39: ("HorseArcher", "horse_archer"),
    40: ("Cataphract", "cataphract"),
    41: ("Huscarl", "huscarl"),
    46: ("Janissary", "janissary"),
    48: ("Boar", "boar"),
    65: ("Deer", "deer"),
    73: ("ChuKoNu", "chu_ko_nu"),
    74: ("Militia", "militia"),
    93: ("Spearman", "spearman"),
    118: ("Villager", "villager"),
    125: ("Monk", "monk"),
    128: ("TradeCart", "trade_cart"),
    232: ("WoadRaider", "woad_raider"),
    239: ("WarElephant", "war_elephant"),
    250: ("Longboat", "longboat"),
    279: ("Scorpion", "scorpion"),
    280: ("Mangonel", "mangonel"),
    281: ("ThrowingAxeman", "throwing_axeman"),
    282: ("Mameluke", "mameluke"),
    291: ("Samurai", "samurai"),
    329: ("CamelRider", "camel_rider"),
    331: ("Trebuchet", "trebuchet"),
    420: ("CannonGalleon", "cannon_galleon"),
    440: ("Petard", "petard"),
    448: ("ScoutCavalry", "scout_cavalry"),
    527: ("DemolitionShip", "demo_ship"),
    529: ("FireTrireme", "fire_trireme"),
    539: ("Galley", "galley"),
    545: ("TransportShip", "transport_ship"),
    594: ("Sheep", "sheep"),
    692: ("Berserk", "berserk"),
    725: ("JaguarWarrior", "jaguar_warrior"),
    751: ("EagleWarrior", "eagle_warrior"),
    755: ("Tarkan", "tarkan"),
    763: ("PlumedArcher", "plumed_archer"),
    771: ("Conquistador", "conquistador"),
    775: ("Missionary", "missionary"),
    827: ("WarWaggon", "war_waggon"),
    831: ("TurtleShip", "turtle_ship"),
    833: ("Turkey", "turkey"),
}

# key: head unit id; value: (nyan object name, filename prefix)
BUILDING_LINE_LOOKUPS = {
    12: ("Barracks", "barracks"),
    45: ("Dock", "dock"),
    49: ("SiegeWorkshop", "siege_workshop"),
    50: ("Farm", "farm"),
    64: ("StoneGate", "stone_gate"),
    68: ("Mill", "mill"),
    70: ("House", "house"),
    72: ("PalisadeWall", "palisade"),
    79: ("Tower", "tower"),
    82: ("Castle", "castle"),
    84: ("Market", "market"),
    87: ("ArcheryRange", "archery_range"),
    101: ("Stable", "stable"),
    103: ("Blacksmith", "blacksmith"),
    104: ("Monastery", "monastery"),
    109: ("TownCenter", "town_center"),
    117: ("StoneWall", "stone_wall"),
    199: ("FishingTrap", "fishing_trap"),
    209: ("University", "university"),
    236: ("BombardTower", "bombard_tower"),
    276: ("Wonder", "wonder"),
    562: ("LumberCamp", "lumber_camp"),
    584: ("MiningCamp", "mining_camp"),
    598: ("Outpost", "outpost"),
}

# key: (head) unit id; value: (nyan object name, filename prefix)
AMBIENT_GROUP_LOOKUPS = {
    59: ("BerryBush", "berry_bush"),
    66: ("GoldMine", "gold_mine"),
    102: ("StoneMine", "stone_mine"),
    285: ("Relic", "relic"),
    348: ("BambooForest", "bamboo_forest"),
    349: ("OakTree", "oak_tree"),
    350: ("Conifer", "conifer"),
    351: ("PalmTree", "palm_tree"),
    411: ("ForestTree", "forest_tree"),
    413: ("SnowyConifer", "snowy_conifer"),
    414: ("JungleTree", "jungle_tree"),
    709: ("Cactus", "cactus"),
}

# key: index; value: (nyan object name, filename prefix, units belonging to group, variant type)
VARIANT_GROUP_LOOKUPS = {
    69: ("Shorefish", "shore_fish", (69,), "misc"),
    96: ("Bird", "bird", (96, 816), "misc"),
    264: ("Cliff", "cliff", (264, 265, 266, 267, 268, 269, 270, 271, 272, 273), "angle"),
    450: ("BigOceanFish", "big_ocean_fish", (450, 451), "random"),
    455: ("OceanFish", "ocean_fish", (455, 456, 457, 458), "random"),
}

# key: head unit id; value: (nyan object name, filename prefix)
TECH_GROUP_LOOKUPS = {
    2: ("EliteTarkan", "elite_tarkan"),
    3: ("Yeoman", "yeoman"),
    4: ("ElDorado", "el_dorado"),
    5: ("FurorCeltica", "furor_celtica"),
    6: ("SiegeDrill", "siege_drill"),
    7: ("Mahouts", "mahouts"),
    8: ("TownWatch", "town_watch"),
    9: ("Zealotry", "zealotry"),
    10: ("Artillery", "artillery"),
    11: ("Crenellations", "crenellations"),
    12: ("CropRotation", "crop_rotation"),
    13: ("HeavyPlow", "heavy_plow"),
    14: ("HorseCollar", "horse_collar"),
    15: ("Guilds", "guilds"),
    16: ("Anarchy", "anarchy"),
    17: ("Banking", "banking"),
    19: ("Cartography", "cartography"),
    21: ("Atheism", "atheism"),
    22: ("Loom", "loom"),
    23: ("Coinage", "coinage"),
    24: ("GarlandWars", "garland_wars"),
    27: ("ElitePlumedArcher", "elite_plumed_archer"),
    34: ("WarGalley", "war_galley"),
    35: ("Galleon", "galleon"),
    37: ("CannonGalleon", "cannon_galleon"),
    39: ("Husbandry", "husbandry"),
    45: ("Faith", "faith"),
    47: ("Chemistry", "chemistry"),
    48: ("Caravan", "caravan"),
    49: ("Berserkergang", "berserkergang"),
    50: ("Masonry", "masonry"),
    51: ("Architecture", "architecture"),
    52: ("Rocketry", "rocketry"),
    54: ("TreadmillCrane", "treadmill_crane"),
    55: ("GoldMining", "gold_mining"),
    59: ("Kataparuto", "kataparuto"),
    60: ("EliteConquistador", "elite_conquistador"),
    61: ("Logistica", "logistica"),
    63: ("Keep", "keep"),
    64: ("BombardTower", "bombard_tower"),
    67: ("Forging", "forging"),
    68: ("IronCasting", "iron_casting"),
    74: ("ScaleMailArmor", "scale_mail_armor"),
    75: ("BlastFurnace", "blast_furnace"),
    76: ("ChainMailArmor", "chain_mail_armor"),
    77: ("PlateMailArmor", "plate_mail_armor"),
    80: ("PlateBardingArmor", "plate_barding_armor"),
    81: ("ScaleBardingArmor", "scale_barding_armor"),
    82: ("ChainBardingArmor", "chain_barding_armor"),
    83: ("BeardedAxe", "bearded_axe"),
    90: ("Tracking", "tracking"),
    93: ("Ballistics", "ballistics"),
    96: ("CappedRam", "capped_ram"),
    98: ("EliteSkirmisher", "elite_skirmisher"),
    100: ("Crossbowman", "crossbowman"),
    101: ("FeudalAge", "feudal_age"),
    102: ("CastleAge", "castle_age"),
    103: ("ImperialAge", "imperial_age"),
    140: ("GuardTower", "guard_tower"),
    182: ("GoldShaftMining", "gold_shaft_mining"),
    194: ("FortifiedWall", "fortified_wall"),
    197: ("Pikeman", "pikeman"),
    199: ("Fletching", "fletching"),
    200: ("BodkinArrow", "bodkin_arrow"),
    201: ("Bracer", "bracer"),
    202: ("DoubleBitAxe", "double_bit_axe"),
    203: ("BowSaw", "bow_saw"),
    207: ("Longswordsman", "longswordsman"),
    209: ("Chevalier", "chevalier"),
    211: ("PaddedArcherArmor", "padded_archer_armor"),
    212: ("LeatherArcherArmor", "leather_archer_armor"),
    213: ("WheelBarrow", "wheel_barrow"),
    215: ("Squires", "squires"),
    217: ("TwoHandedSwordsman", "two_handed_swordsman"),
    218: ("HeavyCavalryArcher", "heavy_cavalry_archer"),
    219: ("RingArcherArmor", "ring_archer_armor"),
    221: ("TwoManSaw", "two_man_saw"),
    222: ("Swordsman", "swordsman"),
    230: ("BlockPrinting", "block_printing"),
    231: ("Sanctity", "sanctity"),
    233: ("Illumination", "illumination"),
    236: ("HeavyCamelRider", "heavy_camel_rider"),
    237: ("Arbalest", "arbalest"),
    239: ("HeavyScorpion", "heavy_scorpion"),
    244: ("HeavyDemolitionShip", "heavy_demolition_ship"),
    246: ("FastFireShip", "fast_fire_ship"),
    249: ("HandCart", "hand_cart"),
    252: ("Fervor", "fervor"),
    254: ("LightCavalry", "light_cavalry"),
    255: ("SiegeRam", "siege_ram"),
    257: ("Onager", "onager"),
    264: ("Champion", "champion"),
    265: ("Paladin", "paladin"),
    278: ("StoneMining", "stone_mining"),
    279: ("StoneShaftMining", "stone_shaft_mining"),
    280: ("TownPatrol", "town_patrol"),
    315: ("Conscription", "conscription"),
    316: ("Redemption", "redemption"),
    319: ("Atonement", "atonement"),
    320: ("SiegeOnager", "siege_onager"),
    321: ("Sappers", "sappers"),
    322: ("MurderHoles", "murder_holes"),
    360: ("EliteLongbowman", "elite_longbowman"),
    361: ("EliteCataphract", "elite_cataphract"),
    362: ("EliteChoKoNu", "elite_cho_ko_nu"),
    363: ("EliteThrowingAxeman", "elite_throwing_axeman"),
    364: ("EliteTeutonicKnight", "elite_teutonic_knight"),
    365: ("EliteHuscarl", "elite_huscarl"),
    366: ("EliteSamurai", "elite_samurai"),
    367: ("EliteWarElephant", "elite_war_elephant"),
    368: ("EliteMameluke", "elite_mameluke"),
    369: ("EliteJanissary", "elite_janissary"),
    370: ("EliteWoadRaider", "elite_woad_raider"),
    371: ("EliteMangudai", "elite_mangudai"),
    372: ("EliteLongboat", "elite_longboat"),
    373: ("Shipwright", "shipwright"),
    374: ("Careening", "careening"),
    375: ("DryDock", "dry_dock"),
    376: ("EliteWarGalley", "elite_war_galley"),
    377: ("SiegeEngineers", "siege_engineers"),
    379: ("Hoardings", "hoardings"),
    380: ("HeatedShot", "heated_shot"),
    398: ("EliteBerserk", "elite_berserk"),
    408: ("Spies", "spies"),
    428: ("Hussar", "hussar"),
    429: ("Helbardier", "helbardier"),
    432: ("EliteJaguarWarrior", "elite_jaguar_warrior"),
    434: ("EliteEagleWarrior", "elite_eagle_warrior"),
    435: ("Bloodlines", "bloodlines"),
    436: ("ParthianTactics", "parthian_tactics"),
    437: ("ThumbRing", "thumb_ring"),
    438: ("Theocracy", "theocracy"),
    439: ("Heresy", "heresy"),
    440: ("Supremacy", "supremacy"),
    441: ("HerbalMedicine", "herbal_medicine"),
    445: ("Shinkichon", "shinkichon"),
    448: ("EliteTurtleShip", "elite_turtle_ship"),
    450: ("EliteWarWaggon", "elite_war_waggon"),
    457: ("Perfusion", "perfusion"),
}

# key: civ index; value: (nyan object name, filename prefix)
CIV_GROUP_LOOKUPS = {
    0: ("Gaia", "gaia"),
    1: ("Britons", "britons"),
    2: ("Franks", "franks"),
    3: ("Goths", "goths"),
    4: ("Teutons", "teutons"),
    5: ("Japanese", "japanese"),
    6: ("Chinese", "chinese"),
    7: ("Byzantines", "byzantines"),
    8: ("Persians", "persians"),
    9: ("Saracens", "saracens"),
    10: ("Turks", "turks"),
    11: ("Vikings", "vikings"),
    12: ("Mongols", "mongols"),
    13: ("Celts", "celts"),
    14: ("Spanish", "spanish"),
    15: ("Aztecs", "aztecs"),
    16: ("Mayans", "mayans"),
    17: ("Huns", "huns"),
    18: ("Koreans", "koreans"),
}

# key: civ index; value: (civ ids, nyan object name, filename prefix)
GRAPHICS_SET_LOOKUPS = {
    0: ((0, 1, 2, 13, 14), "WesternEuropean", "western_european"),
    1: ((3, 4, 11, 17), "CentralEuropean", "central_european"),
    2: ((5, 6, 12, 18, 31), "EastAsian", "east_asian"),
    3: ((8, 9, 10), "MiddleEastern", "middle_eastern"),
    4: ((7,), "Byzantine", "byzantine"),
    5: ((15, 16, 21), "MesoAmerican", "meso"),
}

# key: terrain index; value: (unit terrain restrictions (manual), nyan object name, filename prefix)
# TODO: Use terrain restrictions from .dat
TERRAIN_GROUP_LOOKUPS = {
    0:  ((0, 1, 4, 7, 8, 10, 20,), "Grass", "grass"),
    1:  ((0, 3, 13, 15, 21,), "Water", "water"),
    2:  ((0, 2, 3, 6, 7,), "Beach", "beach"),
    3:  ((0, 1, 4, 7, 8, 10, 20,), "Dirt3", "dirt3"),
    4:  ((0, 1, 3, 6, 7, 21,), "Shallows", "shallows"),
    5:  ((0, 1, 4, 7, 8, 10, 20,), "Leaves", "leaves"),
    6:  ((0, 1, 4, 7, 8, 10, 20,), "Dirt", "dirt"),
    7:  ((0, 1, 4, 7, 10, 20,), "FarmCrops", "farm_crops"),
    8:  ((0, 1, 4, 7, 10, 20,), "FarmHarvested", "farm_harvested"),
    9:  ((0, 1, 4, 7, 8, 10, 20,), "Grass3", "grass3"),
    10: ((0, 1, 4, 7, 8, 10, 20,), "Forest", "forest"),
    11: ((0, 1, 4, 7, 8, 10, 20,), "Dirt2", "dirt2"),
    12: ((0, 1, 4, 7, 8, 10, 20,), "Grass2", "grass2"),
    13: ((0, 1, 4, 7, 8, 10, 20,), "PalmDesert", "palm_desert"),
    14: ((0, 1, 4, 7, 8, 10, 20,), "Desert", "desert"),
    15: ((0, 3, 13, 15, 21,), "WaterOld", "water_old"),
    16: ((0, 1, 4, 7, 8, 10, 20,), "GrassOld", "grass_old"),
    17: ((0, 4, 7, 8, 10, 20,), "Jungle", "jungle"),
    18: ((0, 1, 4, 7, 8, 10, 20,), "BambooForest", "bamboo_forest"),
    19: ((0, 1, 4, 7, 8, 10, 20,), "PineForest", "pine-forest"),
    20: ((0, 1, 4, 7, 8, 10, 20,), "OakForest", "oak_forest"),
    21: ((0, 1, 4, 7, 8, 10, 20,), "SnowForest", "snow_forest"),
    22: ((0, 3, 13, 15, 21,), "Water2", "water2"),
    23: ((0, 3, 13, 15, 21,), "Water3", "water3"),
    24: ((0, 1, 4, 7, 8, 10, 20,), "Road", "road"),
    25: ((0, 1, 4, 7, 8, 10, 20,), "RoadWeathered", "road_weathered"),
    26: ((0, 4, 7, 8, 10, 20,), "Ice", "ice"),
    27: ((0, 1, 4, 7, 8, 10, 20,), "Foundation", "foundation"),
    28: ((0, 3, 13, 15, 21,), "WaterBridge", "water_bridge"),
    29: ((0, 1, 4, 7, 10, 20,), "FarmConstruction1", "farm_construction1"),
    30: ((0, 1, 4, 7, 10, 20,), "FarmConstruction2", "farm_construction2"),
    31: ((0, 1, 4, 7, 10, 20,), "FarmConstruction3", "farm_construction3"),
    32: ((0, 1, 4, 7, 8, 10, 20,), "Snow", "snow"),
    33: ((0, 1, 4, 7, 8, 10, 20,), "SnowDesert", "snow_desert"),
    34: ((0, 1, 4, 7, 8, 10, 20,), "SnowGrass", "snow_grass"),
    35: ((0, 4, 7, 8, 10, 20,), "Ice2", "ice2"),
    36: ((0, 1, 4, 7, 8, 10, 20,), "SnowFoundation", "snow_foundation"),
    37: ((0, 2, 3, 6, 7,), "IceBeach", "ice_beach"),
    38: ((0, 1, 4, 7, 8, 10, 20,), "RoadSnow", "road_snow"),
    39: ((0, 1, 4, 7, 8, 10, 20,), "RoadMossy", "road_mossy"),
    40: ((0, 1, 4, 7, 8, 10, 20,), "KOH", "koh"),
}

# key: not relevant; value: (terrain indices, unit terrain restrictions (manual), nyan object name)
# TODO: Use terrain restrictions from .dat
TERRAIN_TYPE_LOOKUPS = {
    0: ((0, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 24,
         25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 38, 39, 40),
        (0, 1, 4, 7, 8, 10, 11, 12, 14, 16, 18, 20,),
        "Land",),
    1: ((1, 15, 22, 23, 28),
        (0, 3, 6, 13, 17, 19,),
        "Water",),
    2: ((2, 37),
        (0, 2, 7, 10, 12, 14, 16, 18, 20,),
        "Beach",),
    3: ((4,),
        (0, 1, 7, 12, 14, 18, 21,),
        "Shallow",),
    4: ((26, 35, 37),
        (0, 1, 4, 7, 8, 10, 11, 12, 14, 18, 19, 20,),
        "Ice",),
    5: ((7, 8, 29, 30, 31),
        (0, 1, 4, 7, 10, 12, 14, 18, 20),
        "Farm",),
}


CLASS_ID_LOOKUPS = {
    0: "Archer",
    1: "Artifact",
    2: "TradeBoat",
    3: "BuildingMisc",
    4: "Villager",
    5: "OceanFish",
    6: "Infantry",
    7: "BerryBush",
    8: "StoneMine",
    9: "AnimalPrey",
    10: "AnimalPredator",
    11: "DeadOrProjectileOrBird",     # do not use this as GameEntityType
    12: "Cavalry",
    13: "SiegeWeapon",
    14: "Ambient",
    15: "Tree",
    18: "Monk",
    19: "TradecCart",
    20: "TransportShip",
    21: "FishingShip",
    22: "Warship",
    23: "Conquistador",
    27: "Wall",
    28: "Phalanx",
    29: "DomesticAnimal",
    30: "AmbientFlag",
    31: "DeepSeaFish",
    32: "GoldMine",
    33: "ShoreFish",
    34: "Cliff",
    35: "Petard",
    36: "CavalryArcher",
    37: "Doppelgaenger",
    38: "Bird",
    39: "Gate",
    40: "AmbientPile",
    41: "AmbientResourcePile",
    42: "Relic",
    43: "MonkWithRelic",            # should not be present in final modpack
    44: "HandConnoneer",
    45: "TwoHandedSwordsman",       # should not be present in final modpack (unused anyway)
    46: "Pikeman",                  # should not be present in final modpack (unused anyway)
    47: "CavalryScout",
    48: "OreMine",
    49: "Restockable",
    50: "Spearman",
    51: "Trebuchet",                # packed
    52: "Tower",
    53: "BoardingShip",
    54: "Trebuchet",                # unpacked
    55: "Scorpion",
    56: "Raider",
    57: "CavalryRaider",
    58: "Herdable",
    59: "King",
    61: "Horse",
}

# key: genie unit id; value: Gather ability name
GATHER_TASK_LOOKUPS = {
    13: ("Fish", "fish"),  # fishing boat
    56: ("Fish", "fish"),  # male
    57: ("Fish", "fish"),  # female
    120: ("CollectBerries", "collect_berries"),  # male
    354: ("CollectBerries", "collect_berries"),  # female
    122: ("HarvestGame", "harvest_game"),  # male
    216: ("HarvestGame", "harvest_game"),  # female
    123: ("ChopWood", "chop_wood"),  # male
    218: ("ChopWood", "chop_wood"),  # female
    124: ("MineStone", "mine_stone"),  # male
    220: ("MineStone", "mine_stone"),  # female
    214: ("FarmCrops", "farm_crops"),  # male
    259: ("FarmCrops", "farm_crops"),  # female
    579: ("MineGold", "mine_gold"),  # male
    581: ("MineGold", "mine_gold"),  # female
    590: ("HarvestLivestock", "harvest_livestock"),  # male
    592: ("HarvestLivestock", "harvest_livestock"),  # female
}

# key: restock target unit id; value: Gather ability name
RESTOCK_TARGET_LOOKUPS = {
    50: ("ReseedFarm", "reseed_farm"),
}

# key: armor class; value: Gather ability name
ARMOR_CLASS_LOOKUPS = {
    1: "Infantry",
    2: "TurtleShip",
    3: "Pierce",
    4: "Melee",
    5: "WarElephant",
    8: "Cavalry",
    11: "BuildingNoPort",
    13: "StoneDefense",
    15: "Archer",
    16: "ShipCamelSaboteur",
    17: "Ram",
    18: "Tree",
    19: "UniqueUnit",
    20: "SiegeWeapon",
    21: "Building",
    22: "Wall",
    24: "Boar",
    25: "Monk",
    26: "Castle",
    27: "Spearman",
    28: "CavalryArchers",
    29: "EagleWarrior",
}

# key: command type; value: Apply*Effect ability name
COMMAND_TYPE_LOOKUPS = {
    7: ("Attack", "attack"),
    101: ("Construct", "construct"),
    104: ("Convert", "convert"),
    105: ("Heal", "heal"),
    106: ("Repair", "repair"),
    110: ("Hunt", "hunt"),
}
