// Copyright 2013-2021 the openage authors. See copying.md for legal info.

// Warning: this file is a dummy file and was auto-generated by the v0.4.1 converter;
// its purpose is to keep the deprecated gamestate compilable and intact;
// these files keep only the minimum functionality and should not be changed;
// For details, see buildsystem/codegen.cmake and openage/codegen.

#pragma once

#include <cstddef>
#include <cstdint>
#include <string>
#include "util/csv.h"



namespace openage {
namespace gamedata {

enum class attack_modes {
    DUMMY
};


enum class blast_types {
    DUMMY
};


enum class boundary_ids {
    DUMMY
};


/**
 * a possible building annex.
 */
struct building_annex {
	int16_t unit_id;
	float misplaced0;
	float misplaced1;
	static constexpr size_t member_count = 3;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

enum class combat_levels {
    DUMMY
};


enum class command_ability {
    DUMMY
};


enum class command_attributes {
    DUMMY
};


enum class creatable_types {
    DUMMY
};


enum class damage_draw_type {
    DUMMY
};


enum class elevation_modes {
    DUMMY
};


enum class fog_visibility {
    DUMMY
};


enum class garrison_types {
    DUMMY
};


enum class ground_type {
    DUMMY,
    WATER,
    WATER_0x0D,
    WATER_SHIP_0x03,
    WATER_SHIP_0x0F,
    SOLID,
    FOUNDATION,
    NO_ICE_0x08,
    FOREST
};


enum class hit_class {
    DUMMY
};


enum class interaction_modes {
    DUMMY
};


enum class minimap_modes {
    DUMMY
};


enum class obstruction_types {
    DUMMY
};


enum class range_damage_type {
    DUMMY
};


enum class resource_handling {
    DUMMY
};


enum class resource_types {
    DUMMY
};


enum class selection_effects {
    DUMMY
};


enum class selection_type {
    DUMMY
};


enum class unit_classes {
    DUMMY,
    BUILDING,
    CIVILIAN,
    TREES,
    HERDABLE,
    GOLD_MINE,
    STONE_MINE,
    BERRY_BUSH,
    PREY_ANIMAL,
    SEA_FISH,
    FISHING_BOAT
};


/**
 * stores one possible unit image that is displayed at a given damage percentage.
 */
struct damage_graphic {
	int16_t graphic_id;
	int8_t damage_percent;
	int8_t old_apply_mode;
	damage_draw_type apply_mode;
	static constexpr size_t member_count = 4;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * determines the resource storage capacity for one unit mode.
 */
struct resource_storage {
	int16_t type;
	float amount;
	resource_handling used_mode;
	static constexpr size_t member_count = 3;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * base properties for all units.
 */
struct unit_object {
	int16_t id0;
	uint16_t language_dll_name;
	uint16_t language_dll_creation;
	unit_classes unit_class;
	int16_t idle_graphic0;
	int16_t idle_graphic1;
	int16_t dying_graphic;
	int16_t undead_graphic;
	int8_t death_mode;
	int16_t hit_points;
	float line_of_sight;
	int8_t garrison_capacity;
	float radius_x;
	float radius_y;
	float radius_z;
	int16_t train_sound_id;
	int16_t damage_sound_id;
	int16_t dead_unit_id;
	int8_t placement_mode;
	int8_t can_be_built_on;
	int16_t icon_id;
	int8_t hidden_in_editor;
	int16_t old_portrait_icon_id;
	int8_t enabled;
	int16_t placement_side_terrain0;
	int16_t placement_side_terrain1;
	int16_t placement_terrain0;
	int16_t placement_terrain1;
	float clearance_size_x;
	float clearance_size_y;
	elevation_modes elevation_mode;
	fog_visibility visible_in_fog;
	ground_type terrain_restriction;
	int8_t fly_mode;
	int16_t resource_capacity;
	float resource_decay;
	blast_types blast_defense_level;
	combat_levels combat_level;
	interaction_modes interaction_mode;
	minimap_modes map_draw_level;
	command_attributes unit_level;
	float attack_reaction;
	int8_t minimap_color;
	int32_t language_dll_help;
	int32_t language_dll_hotkey_text;
	int32_t hot_keys;
	int8_t recyclable;
	int8_t enable_auto_gather;
	int8_t doppelgaenger_on_death;
	int8_t resource_gather_drop;
	uint8_t occlusion_mode;
	obstruction_types obstruction_type;
	int8_t obstruction_class;
	uint8_t trait;
	int8_t civilization_id;
	int16_t attribute_piece;
	selection_effects selection_effect;
	float selection_shape_x;
	float selection_shape_y;
	float selection_shape_z;
	openage::util::csv_subdata<openage::gamedata::resource_storage> resource_storage;
	openage::util::csv_subdata<openage::gamedata::damage_graphic> damage_graphics;
	int16_t selection_sound_id;
	int16_t dying_sound_id;
	attack_modes old_attack_mode;
	int8_t convert_terrain;
	std::string name;
	int16_t id1;
	int16_t id2;
	static constexpr size_t member_count = 69;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * adds speed property to units.
 */
struct animated_unit : unit_object {
	float speed;
	static constexpr size_t member_count = 70;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * weird doppelganger unit thats actually the same as an animated unit.
 */
struct doppelganger_unit : animated_unit {
	static constexpr size_t member_count = 70;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * adds walking graphics, rotations and tracking properties to units.
 */
struct moving_unit : doppelganger_unit {
	int16_t move_graphics;
	int16_t run_graphics;
	float turn_speed;
	int8_t old_size_class;
	int16_t trail_unit_id;
	uint8_t trail_opsions;
	float trail_spacing;
	int8_t old_move_algorithm;
	float turn_radius;
	float turn_radius_speed;
	float max_yaw_per_sec_moving;
	float stationary_yaw_revolution_time;
	float max_yaw_per_sec_stationary;
	static constexpr size_t member_count = 83;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * adds search radius and work properties, as well as movement sounds.
 */
struct action_unit : moving_unit {
	int16_t default_task_id;
	float search_radius;
	float work_rate;
	int8_t task_group;
	int16_t command_sound_id;
	int16_t stop_sound_id;
	int8_t run_pattern;
	static constexpr size_t member_count = 91;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * stores attack amount for a damage type.
 */
struct hit_type {
	hit_class type_id;
	int16_t amount;
	static constexpr size_t member_count = 2;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * adds attack and armor properties to units.
 */
struct projectile_unit : action_unit {
	int16_t default_armor;
	openage::util::csv_subdata<openage::gamedata::hit_type> attacks;
	openage::util::csv_subdata<openage::gamedata::hit_type> armors;
	boundary_ids boundary_id;
	float weapon_range_max;
	float blast_range;
	float attack_speed;
	int16_t attack_projectile_primary_unit_id;
	int16_t accuracy;
	int8_t break_off_combat;
	int16_t frame_delay;
	range_damage_type blast_level_offence;
	float weapon_range_min;
	float accuracy_dispersion;
	int16_t attack_sprite_id;
	int16_t melee_armor_displayed;
	int16_t attack_displayed;
	float range_displayed;
	float reload_time_displayed;
	static constexpr size_t member_count = 111;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * adds missile specific unit properties.
 */
struct missile_unit : projectile_unit {
	int8_t projectile_type;
	int8_t smart_mode;
	int8_t drop_animation_mode;
	int8_t penetration_mode;
	int8_t area_of_effect_special;
	float projectile_arc;
	static constexpr size_t member_count = 117;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * stores cost for one resource for creating the unit.
 */
struct resource_cost {
	resource_types type_id;
	int16_t amount;
	int16_t enabled;
	static constexpr size_t member_count = 3;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * just a tree unit.
 */
struct tree_unit : unit_object {
	static constexpr size_t member_count = 69;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * a command a single unit may receive by script or human.
 */
struct unit_command {
	int16_t command_used;
	int16_t command_id;
	int8_t is_default;
	command_ability type;
	int16_t class_id;
	int16_t unit_id;
	int16_t terrain_id;
	int16_t resource_in;
	int16_t resource_multiplier;
	int16_t resource_out;
	int16_t unused_resource;
	float work_value1;
	float work_value2;
	float work_range;
	int8_t search_mode;
	float search_time;
	int8_t enable_targeting;
	int8_t combat_level_flag;
	int16_t gather_type;
	selection_type owner_type;
	int8_t carry_check;
	int8_t state_build;
	int16_t move_sprite_id;
	int16_t proceed_sprite_id;
	int16_t work_sprite_id;
	int16_t carry_sprite_id;
	int16_t resource_gather_sound_id;
	int16_t resource_deposit_sound_id;
	static constexpr size_t member_count = 28;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * stores a bunch of unit commands.
 */
struct unit_header {
	uint8_t exists;
	openage::util::csv_subdata<openage::gamedata::unit_command> unit_commands;
	static constexpr size_t member_count = 2;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * adds creation location and garrison unit properties.
 */
struct living_unit : projectile_unit {
	openage::util::csv_subdata<openage::gamedata::resource_cost> resource_cost;
	int16_t creation_time;
	int16_t train_location_id;
	float rear_attack_modifier;
	float flank_attack_modifier;
	creatable_types creatable_type;
	int8_t hero_mode;
	int32_t garrison_graphic;
	float attack_projectile_count;
	int8_t attack_projectile_max_count;
	float attack_projectile_spawning_area_width;
	float attack_projectile_spawning_area_length;
	float attack_projectile_spawning_area_randomness;
	int32_t attack_projectile_secondary_unit_id;
	int32_t special_graphic_id;
	int8_t special_activation;
	int16_t pierce_armor_displayed;
	static constexpr size_t member_count = 128;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * construction graphics and garrison building properties for units.
 */
struct building_unit : living_unit {
	int16_t construction_graphic_id;
	int16_t snow_graphic_id;
	int8_t adjacent_mode;
	int16_t graphics_angle;
	int8_t disappears_when_built;
	int16_t stack_unit_id;
	int16_t foundation_terrain_id;
	int16_t old_overlay_id;
	int16_t research_id;
	int8_t can_burn;
	openage::util::csv_subdata<openage::gamedata::building_annex> building_annex;
	int16_t head_unit_id;
	int16_t transform_unit_id;
	int16_t transform_sound_id;
	int16_t construction_sound_id;
	garrison_types garrison_type;
	float garrison_heal_rate;
	float garrison_repair_rate;
	int16_t salvage_unit_id;
	static constexpr size_t member_count = 148;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

} // gamedata
} // openage
