// Copyright 2013-2021 the openage authors. See copying.md for legal info.

// Warning: this file is a dummy file and was auto-generated by the v0.4.1 converter;
// its purpose is to keep the deprecated gamestate compilable and intact;
// these files keep only the minimum functionality and should not be changed;
// For details, see buildsystem/codegen.cmake and openage/codegen.


#include <cstdio>
#include <vector>
#include "error/error.h"
#include "terrain_dummy.h"
#include "util/strings.h"


namespace openage {
namespace gamedata {

constexpr size_t frame_data::member_count;
constexpr size_t terrain_animation::member_count;
constexpr size_t terrain_border::member_count;
constexpr size_t terrain_pass_graphic::member_count;
constexpr size_t terrain_restriction::member_count;
constexpr size_t terrain_type::member_count;
constexpr size_t tile_size::member_count;
int frame_data::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', frame_data::member_count
    );

    if (buf.size() != frame_data::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing frame_data led to "
            << buf.size()
            << " columns (expected "
            << frame_data::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%hd", &this->frame_count) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%hd", &this->angle_count) != 1) { return 1; }
    if (sscanf(buf[2].c_str(), "%hd", &this->shape_id) != 1) { return 2; }

    return -1;
}

bool frame_data::recurse(const openage::util::CSVCollection & /*storage*/, const std::string & /*basedir*/) {
    return true;
}

int terrain_animation::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', terrain_animation::member_count
    );

    if (buf.size() != terrain_animation::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing terrain_animation led to "
            << buf.size()
            << " columns (expected "
            << terrain_animation::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%hhd", &this->is_animated) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%hd", &this->animation_frame_count) != 1) { return 1; }
    if (sscanf(buf[2].c_str(), "%hd", &this->pause_frame_count) != 1) { return 2; }
    if (sscanf(buf[3].c_str(), "%f", &this->interval) != 1) { return 3; }
    if (sscanf(buf[4].c_str(), "%f", &this->pause_between_loops) != 1) { return 4; }
    if (sscanf(buf[5].c_str(), "%hd", &this->frame) != 1) { return 5; }
    if (sscanf(buf[6].c_str(), "%hd", &this->draw_frame) != 1) { return 6; }
    if (sscanf(buf[7].c_str(), "%f", &this->animate_last) != 1) { return 7; }
    if (sscanf(buf[8].c_str(), "%hhd", &this->frame_changed) != 1) { return 8; }
    if (sscanf(buf[9].c_str(), "%hhd", &this->drawn) != 1) { return 9; }

    return -1;
}

bool terrain_animation::recurse(const openage::util::CSVCollection & /*storage*/, const std::string & /*basedir*/) {
    return true;
}

int terrain_border::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', terrain_border::member_count
    );

    if (buf.size() != terrain_border::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing terrain_border led to "
            << buf.size()
            << " columns (expected "
            << terrain_border::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%hhd", &this->enabled) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%hhd", &this->random) != 1) { return 1; }
    this->internal_name = buf[2];
    this->filename = buf[3];
    if (sscanf(buf[4].c_str(), "%d", &this->slp_id) != 1) { return 4; }
    if (sscanf(buf[5].c_str(), "%d", &this->shape_ptr) != 1) { return 5; }
    if (sscanf(buf[6].c_str(), "%d", &this->sound_id) != 1) { return 6; }
    if (sscanf(buf[8].c_str(), "%hhd", &this->is_animated) != 1) { return 8; }
    if (sscanf(buf[9].c_str(), "%hd", &this->animation_frame_count) != 1) { return 9; }
    if (sscanf(buf[10].c_str(), "%hd", &this->pause_frame_count) != 1) { return 10; }
    if (sscanf(buf[11].c_str(), "%f", &this->interval) != 1) { return 11; }
    if (sscanf(buf[12].c_str(), "%f", &this->pause_between_loops) != 1) { return 12; }
    if (sscanf(buf[13].c_str(), "%hd", &this->frame) != 1) { return 13; }
    if (sscanf(buf[14].c_str(), "%hd", &this->draw_frame) != 1) { return 14; }
    if (sscanf(buf[15].c_str(), "%f", &this->animate_last) != 1) { return 15; }
    if (sscanf(buf[16].c_str(), "%hhd", &this->frame_changed) != 1) { return 16; }
    if (sscanf(buf[17].c_str(), "%hhd", &this->drawn) != 1) { return 17; }
    this->frames.filename = buf[18];
    if (sscanf(buf[19].c_str(), "%hd", &this->draw_tile) != 1) { return 19; }
    if (sscanf(buf[20].c_str(), "%hd", &this->underlay_terrain) != 1) { return 20; }
    if (sscanf(buf[21].c_str(), "%hd", &this->border_style) != 1) { return 21; }

    return -1;
}

bool terrain_border::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->frames.read(storage, basedir);

    return true;
}

int terrain_pass_graphic::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', terrain_pass_graphic::member_count
    );

    if (buf.size() != terrain_pass_graphic::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing terrain_pass_graphic led to "
            << buf.size()
            << " columns (expected "
            << terrain_pass_graphic::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%d", &this->slp_id_exit_tile) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%d", &this->slp_id_enter_tile) != 1) { return 1; }
    if (sscanf(buf[2].c_str(), "%d", &this->slp_id_walk_tile) != 1) { return 2; }
    if (sscanf(buf[3].c_str(), "%d", &this->replication_amount) != 1) { return 3; }

    return -1;
}

bool terrain_pass_graphic::recurse(const openage::util::CSVCollection & /*storage*/, const std::string & /*basedir*/) {
    return true;
}

int terrain_restriction::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', terrain_restriction::member_count
    );

    if (buf.size() != terrain_restriction::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing terrain_restriction led to "
            << buf.size()
            << " columns (expected "
            << terrain_restriction::member_count
            << ")!"
        );
    }

    this->pass_graphics.filename = buf[1];

    return -1;
}

bool terrain_restriction::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->pass_graphics.read(storage, basedir);

    return true;
}

int terrain_type::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', terrain_type::member_count
    );

    if (buf.size() != terrain_type::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing terrain_type led to "
            << buf.size()
            << " columns (expected "
            << terrain_type::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%hhd", &this->enabled) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%hhd", &this->random) != 1) { return 1; }
    this->internal_name = buf[2];
    this->filename = buf[3];
    if (sscanf(buf[4].c_str(), "%d", &this->slp_id) != 1) { return 4; }
    if (sscanf(buf[5].c_str(), "%d", &this->shape_ptr) != 1) { return 5; }
    if (sscanf(buf[6].c_str(), "%d", &this->sound_id) != 1) { return 6; }
    if (sscanf(buf[7].c_str(), "%d", &this->blend_priority) != 1) { return 7; }
    if (sscanf(buf[8].c_str(), "%d", &this->blend_mode) != 1) { return 8; }
    if (sscanf(buf[9].c_str(), "%hhu", &this->map_color_hi) != 1) { return 9; }
    if (sscanf(buf[10].c_str(), "%hhu", &this->map_color_med) != 1) { return 10; }
    if (sscanf(buf[11].c_str(), "%hhu", &this->map_color_low) != 1) { return 11; }
    if (sscanf(buf[12].c_str(), "%hhu", &this->map_color_cliff_lt) != 1) { return 12; }
    if (sscanf(buf[13].c_str(), "%hhu", &this->map_color_cliff_rt) != 1) { return 13; }
    if (sscanf(buf[14].c_str(), "%hhd", &this->passable_terrain) != 1) { return 14; }
    if (sscanf(buf[15].c_str(), "%hhd", &this->impassable_terrain) != 1) { return 15; }
    if (sscanf(buf[16].c_str(), "%hhd", &this->is_animated) != 1) { return 16; }
    if (sscanf(buf[17].c_str(), "%hd", &this->animation_frame_count) != 1) { return 17; }
    if (sscanf(buf[18].c_str(), "%hd", &this->pause_frame_count) != 1) { return 18; }
    if (sscanf(buf[19].c_str(), "%f", &this->interval) != 1) { return 19; }
    if (sscanf(buf[20].c_str(), "%f", &this->pause_between_loops) != 1) { return 20; }
    if (sscanf(buf[21].c_str(), "%hd", &this->frame) != 1) { return 21; }
    if (sscanf(buf[22].c_str(), "%hd", &this->draw_frame) != 1) { return 22; }
    if (sscanf(buf[23].c_str(), "%f", &this->animate_last) != 1) { return 23; }
    if (sscanf(buf[24].c_str(), "%hhd", &this->frame_changed) != 1) { return 24; }
    if (sscanf(buf[25].c_str(), "%hhd", &this->drawn) != 1) { return 25; }
    this->elevation_graphics.filename = buf[26];
    if (sscanf(buf[27].c_str(), "%hd", &this->terrain_replacement_id) != 1) { return 27; }
    if (sscanf(buf[28].c_str(), "%hd", &this->terrain_to_draw0) != 1) { return 28; }
    if (sscanf(buf[29].c_str(), "%hd", &this->terrain_to_draw1) != 1) { return 29; }
    if (sscanf(buf[34].c_str(), "%hd", &this->terrain_units_used_count) != 1) { return 34; }

    return -1;
}

bool terrain_type::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->elevation_graphics.read(storage, basedir);

    return true;
}

int tile_size::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', tile_size::member_count
    );

    if (buf.size() != tile_size::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing tile_size led to "
            << buf.size()
            << " columns (expected "
            << tile_size::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%hd", &this->width) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%hd", &this->height) != 1) { return 1; }
    if (sscanf(buf[2].c_str(), "%hd", &this->delta_z) != 1) { return 2; }

    return -1;
}

bool tile_size::recurse(const openage::util::CSVCollection & /*storage*/, const std::string & /*basedir*/) {
    return true;
}

} // gamedata
} // openage
