// Copyright 2013-2021 the openage authors. See copying.md for legal info.

// Warning: this file is a dummy file and was auto-generated by the v0.4.1 converter;
// its purpose is to keep the deprecated gamestate compilable and intact;
// these files keep only the minimum functionality and should not be changed;
// For details, see buildsystem/codegen.cmake and openage/codegen.

#pragma once

#include <cstddef>
#include <cstdint>
#include <string>
#include "util/csv.h"



namespace openage {
namespace gamedata {

enum class connection_mode {
    DUMMY
};


enum class effect_apply_type {
    DUMMY
};


/**
 * misc connection for a building/unit/research connection
 */
struct other_connection {
	connection_mode other_connection;
	static constexpr size_t member_count = 1;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * items available when this age was reached.
 */
struct age_tech_tree {
	int32_t id;
	int8_t status;
	int32_t connected_slots_used;
	openage::util::csv_subdata<openage::gamedata::other_connection> other_connections;
	int8_t building_level_count;
	int8_t max_age_length;
	int32_t line_mode;
	static constexpr size_t member_count = 13;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * new available buildings/units/researches when this building was created.
 */
struct building_connection {
	int32_t id;
	int32_t connected_slots_used;
	openage::util::csv_subdata<openage::gamedata::other_connection> other_connections;
	int8_t location_in_age;
	int32_t line_mode;
	int32_t enabling_research;
	static constexpr size_t member_count = 12;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * applied effect for a research technology.
 */
struct tech_effect {
	effect_apply_type type_id;
	int16_t attr_a;
	int16_t attr_b;
	int16_t attr_c;
	float attr_d;
	static constexpr size_t member_count = 5;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * a bundle of effects.
 */
struct effect_bundle {
	std::string name;
	openage::util::csv_subdata<openage::gamedata::tech_effect> effects;
	static constexpr size_t member_count = 2;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * research updates to apply when activating the technology.
 */
struct research_connection {
	int32_t id;
	int8_t status;
	int32_t upper_building;
	int32_t connected_slots_used;
	openage::util::csv_subdata<openage::gamedata::other_connection> other_connections;
	int32_t vertical_line;
	int32_t location_in_age;
	int32_t line_mode;
	static constexpr size_t member_count = 12;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * unit updates to apply when activating the technology.
 */
struct unit_connection {
	int32_t id;
	int8_t status;
	int32_t upper_building;
	int32_t connected_slots_used;
	openage::util::csv_subdata<openage::gamedata::other_connection> other_connections;
	int32_t vertical_line;
	int32_t location_in_age;
	int32_t required_research;
	int32_t line_mode;
	int32_t enabling_research;
	static constexpr size_t member_count = 12;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

} // gamedata
} // openage
