// Copyright 2013-2021 the openage authors. See copying.md for legal info.

// Warning: this file is a dummy file and was auto-generated by the v0.4.1 converter;
// its purpose is to keep the deprecated gamestate compilable and intact;
// these files keep only the minimum functionality and should not be changed;
// For details, see buildsystem/codegen.cmake and openage/codegen.


#include <cstdio>
#include <vector>
#include "error/error.h"
#include "tech_dummy.h"
#include "util/strings.h"


namespace openage {
namespace gamedata {

constexpr size_t age_tech_tree::member_count;
constexpr size_t building_connection::member_count;
constexpr size_t effect_bundle::member_count;
constexpr size_t other_connection::member_count;
constexpr size_t research_connection::member_count;
constexpr size_t tech_effect::member_count;
constexpr size_t unit_connection::member_count;
int age_tech_tree::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', age_tech_tree::member_count
    );

    if (buf.size() != age_tech_tree::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing age_tech_tree led to "
            << buf.size()
            << " columns (expected "
            << age_tech_tree::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%d", &this->id) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%hhd", &this->status) != 1) { return 1; }
    if (sscanf(buf[5].c_str(), "%d", &this->connected_slots_used) != 1) { return 5; }
    this->other_connections.filename = buf[7];
    if (sscanf(buf[8].c_str(), "%hhd", &this->building_level_count) != 1) { return 8; }
    if (sscanf(buf[11].c_str(), "%hhd", &this->max_age_length) != 1) { return 11; }
    if (sscanf(buf[12].c_str(), "%d", &this->line_mode) != 1) { return 12; }

    return -1;
}

bool age_tech_tree::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->other_connections.read(storage, basedir);

    return true;
}

int building_connection::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', building_connection::member_count
    );

    if (buf.size() != building_connection::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing building_connection led to "
            << buf.size()
            << " columns (expected "
            << building_connection::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%d", &this->id) != 1) { return 0; }
    if (sscanf(buf[4].c_str(), "%d", &this->connected_slots_used) != 1) { return 4; }
    this->other_connections.filename = buf[6];
    if (sscanf(buf[7].c_str(), "%hhd", &this->location_in_age) != 1) { return 7; }
    if (sscanf(buf[10].c_str(), "%d", &this->line_mode) != 1) { return 10; }
    if (sscanf(buf[11].c_str(), "%d", &this->enabling_research) != 1) { return 11; }

    return -1;
}

bool building_connection::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->other_connections.read(storage, basedir);

    return true;
}

int effect_bundle::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', effect_bundle::member_count
    );

    if (buf.size() != effect_bundle::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing effect_bundle led to "
            << buf.size()
            << " columns (expected "
            << effect_bundle::member_count
            << ")!"
        );
    }

    this->name = buf[0];
    this->effects.filename = buf[1];

    return -1;
}

bool effect_bundle::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->effects.read(storage, basedir);

    return true;
}

int other_connection::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', other_connection::member_count
    );

    if (buf.size() != other_connection::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing other_connection led to "
            << buf.size()
            << " columns (expected "
            << other_connection::member_count
            << ")!"
        );
    }

    // parse enum connection_mode
    if (buf[0] == "DUMMY") {
        this->other_connection = connection_mode::DUMMY;
    }
    else {
    throw openage::error::Error(
        MSG(err)
        << "unknown enum value '" << buf[0]
        << "' encountered. valid are: "
           "DUMMY\n---\n"
    );}

    return -1;
}

bool other_connection::recurse(const openage::util::CSVCollection & /*storage*/, const std::string & /*basedir*/) {
    return true;
}

int research_connection::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', research_connection::member_count
    );

    if (buf.size() != research_connection::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing research_connection led to "
            << buf.size()
            << " columns (expected "
            << research_connection::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%d", &this->id) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%hhd", &this->status) != 1) { return 1; }
    if (sscanf(buf[2].c_str(), "%d", &this->upper_building) != 1) { return 2; }
    if (sscanf(buf[6].c_str(), "%d", &this->connected_slots_used) != 1) { return 6; }
    this->other_connections.filename = buf[8];
    if (sscanf(buf[9].c_str(), "%d", &this->vertical_line) != 1) { return 9; }
    if (sscanf(buf[10].c_str(), "%d", &this->location_in_age) != 1) { return 10; }
    if (sscanf(buf[11].c_str(), "%d", &this->line_mode) != 1) { return 11; }

    return -1;
}

bool research_connection::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->other_connections.read(storage, basedir);

    return true;
}

int tech_effect::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', tech_effect::member_count
    );

    if (buf.size() != tech_effect::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing tech_effect led to "
            << buf.size()
            << " columns (expected "
            << tech_effect::member_count
            << ")!"
        );
    }

    // parse enum effect_apply_type
    if (buf[0] == "DUMMY") {
        this->type_id = effect_apply_type::DUMMY;
    }
    else {
    throw openage::error::Error(
        MSG(err)
        << "unknown enum value '" << buf[0]
        << "' encountered. valid are: "
           "DUMMY\n---\n"
    );}
    if (sscanf(buf[1].c_str(), "%hd", &this->attr_a) != 1) { return 1; }
    if (sscanf(buf[2].c_str(), "%hd", &this->attr_b) != 1) { return 2; }
    if (sscanf(buf[3].c_str(), "%hd", &this->attr_c) != 1) { return 3; }
    if (sscanf(buf[4].c_str(), "%f", &this->attr_d) != 1) { return 4; }

    return -1;
}

bool tech_effect::recurse(const openage::util::CSVCollection & /*storage*/, const std::string & /*basedir*/) {
    return true;
}

int unit_connection::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', unit_connection::member_count
    );

    if (buf.size() != unit_connection::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing unit_connection led to "
            << buf.size()
            << " columns (expected "
            << unit_connection::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%d", &this->id) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%hhd", &this->status) != 1) { return 1; }
    if (sscanf(buf[2].c_str(), "%d", &this->upper_building) != 1) { return 2; }
    if (sscanf(buf[3].c_str(), "%d", &this->connected_slots_used) != 1) { return 3; }
    this->other_connections.filename = buf[5];
    if (sscanf(buf[6].c_str(), "%d", &this->vertical_line) != 1) { return 6; }
    if (sscanf(buf[8].c_str(), "%d", &this->location_in_age) != 1) { return 8; }
    if (sscanf(buf[9].c_str(), "%d", &this->required_research) != 1) { return 9; }
    if (sscanf(buf[10].c_str(), "%d", &this->line_mode) != 1) { return 10; }
    if (sscanf(buf[11].c_str(), "%d", &this->enabling_research) != 1) { return 11; }

    return -1;
}

bool unit_connection::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->other_connections.read(storage, basedir);

    return true;
}

} // gamedata
} // openage
