// Copyright 2013-2021 the openage authors. See copying.md for legal info.

// Warning: this file is a dummy file and was auto-generated by the v0.4.1 converter;
// its purpose is to keep the deprecated gamestate compilable and intact;
// these files keep only the minimum functionality and should not be changed;
// For details, see buildsystem/codegen.cmake and openage/codegen.


#include <cstdio>
#include <vector>
#include "error/error.h"
#include "research_dummy.h"
#include "util/strings.h"


namespace openage {
namespace gamedata {

constexpr size_t tech::member_count;
constexpr size_t tech_resource_cost::member_count;
int tech::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', tech::member_count
    );

    if (buf.size() != tech::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing tech led to "
            << buf.size()
            << " columns (expected "
            << tech::member_count
            << ")!"
        );
    }

    this->research_resource_costs.filename = buf[1];
    if (sscanf(buf[2].c_str(), "%hd", &this->required_tech_count) != 1) { return 2; }
    if (sscanf(buf[3].c_str(), "%hd", &this->civilization_id) != 1) { return 3; }
    if (sscanf(buf[4].c_str(), "%hd", &this->full_tech_mode) != 1) { return 4; }
    if (sscanf(buf[5].c_str(), "%hd", &this->research_location_id) != 1) { return 5; }
    if (sscanf(buf[6].c_str(), "%hu", &this->language_dll_name) != 1) { return 6; }
    if (sscanf(buf[7].c_str(), "%hu", &this->language_dll_description) != 1) { return 7; }
    if (sscanf(buf[8].c_str(), "%hd", &this->research_time) != 1) { return 8; }
    if (sscanf(buf[9].c_str(), "%hd", &this->tech_effect_id) != 1) { return 9; }
    if (sscanf(buf[10].c_str(), "%hd", &this->tech_type) != 1) { return 10; }
    if (sscanf(buf[11].c_str(), "%hd", &this->icon_id) != 1) { return 11; }
    if (sscanf(buf[12].c_str(), "%hhd", &this->button_id) != 1) { return 12; }
    if (sscanf(buf[13].c_str(), "%d", &this->language_dll_help) != 1) { return 13; }
    if (sscanf(buf[14].c_str(), "%d", &this->language_dll_techtree) != 1) { return 14; }
    if (sscanf(buf[15].c_str(), "%d", &this->hotkey) != 1) { return 15; }
    this->name = buf[16];

    return -1;
}

bool tech::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->research_resource_costs.read(storage, basedir);

    return true;
}

int tech_resource_cost::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', tech_resource_cost::member_count
    );

    if (buf.size() != tech_resource_cost::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing tech_resource_cost led to "
            << buf.size()
            << " columns (expected "
            << tech_resource_cost::member_count
            << ")!"
        );
    }

    // parse enum resource_types
    if (buf[0] == "DUMMY") {
        this->type_id = resource_types::DUMMY;
    }
    else {
    throw openage::error::Error(
        MSG(err)
        << "unknown enum value '" << buf[0]
        << "' encountered. valid are: "
           "DUMMY\n---\n"
    );}
    if (sscanf(buf[1].c_str(), "%hd", &this->amount) != 1) { return 1; }
    if (sscanf(buf[2].c_str(), "%hhd", &this->enabled) != 1) { return 2; }

    return -1;
}

bool tech_resource_cost::recurse(const openage::util::CSVCollection & /*storage*/, const std::string & /*basedir*/) {
    return true;
}

} // gamedata
} // openage
