// Copyright 2013-2021 the openage authors. See copying.md for legal info.

// Warning: this file is a dummy file and was auto-generated by the v0.4.1 converter;
// its purpose is to keep the deprecated gamestate compilable and intact;
// these files keep only the minimum functionality and should not be changed;
// For details, see buildsystem/codegen.cmake and openage/codegen.


#include <cstdio>
#include <vector>
#include "color_dummy.h"
#include "error/error.h"
#include "util/strings.h"


namespace openage {
namespace gamedata {

constexpr size_t palette_color::member_count;
int palette_color::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', palette_color::member_count
    );

    if (buf.size() != palette_color::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing palette_color led to "
            << buf.size()
            << " columns (expected "
            << palette_color::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%d", &this->idx) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%hhu", &this->r) != 1) { return 1; }
    if (sscanf(buf[2].c_str(), "%hhu", &this->g) != 1) { return 2; }
    if (sscanf(buf[3].c_str(), "%hhu", &this->b) != 1) { return 3; }
    if (sscanf(buf[4].c_str(), "%hhu", &this->a) != 1) { return 4; }

    return -1;
}

bool palette_color::recurse(const openage::util::CSVCollection & /*storage*/, const std::string & /*basedir*/) {
    return true;
}

} // gamedata
} // openage
