# [0.3.0] - 2015-07-28
All notable changes for version [v0.3.0] are documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html) since release [v0.4.0].

## Added
- New gameplay features
    - Projectile arcs and ranged attack
    - Dropsites
    - Garrisoning
    - Gathering from resource objects
    - Quicksave/Quickload
    - Selection boxes
    - Display HP bar
    - Switch to correct villager graphics when gathering
    - Auto-task idle units
    - Villager commands and building
    - Show building outlines on selected buildings
- cython-based C++-/Python interface
    - Handle openage as shared library
    - Move C++ source files to `./libopenage` subdirectory
    - Move Python source files to `./openage` subdirectory
    - Integrate cython into buildsystem
- New logging system
- Add testing for the coordinate system
- CI caching
- Customizable key bindings
- More ideas for AI
- Add documentation for buildings in AoE2
- Add a CMake 'doc' target that explains why doc generation will not work
- Add documentation and instructions for ingame development build hotkeys
- Star count in README
- Enable call graph generation in doxygen
- Test cases for job manager
- Add tests for pathfinder
- Use C++14 as new standard
- `for_each` function for containers
- Random number generator (XORShift)
- Introduce namespaced math constants available on all plattforms
- Add a mode indicator label in map view
- Color support for CMake
- Add new discovered variables in `empires.dat` gamedata to converter logic
- `TerrainObject`s handle building annexes using child/parent spaces
- `UnitTexture` class handles delta graphics

## Changed
- Change `./configure` instruction compiler argument to use `gcc` and `clang` instead of `gnu` and `llvm`
- Use SVG build status image instead of PNG in README
- Moved documentation files to `./doc` subdirectory
- Abort build on checkfull fail
- Replace GLEW with libepoxy
- Run `make checkfull` before compiling
- Improve check for C++14 and clang
- Align dependencies column in `building.md`
- Improve portability of the CMake detection of opus location
- use `unsigned int` C++ data type instead of non-standard `uint`
- Use `_WIN32` macros instead of `WIN32` in CMake
- Codestyle example updates and simplifications
- Assure that multiple jobs are executed on the same background thread
- Jobs can check whether they should be aborted and abort themselves
- Integrate new job groups into the dynamic audio loading implementation
- Load missing textures lazily
- Change uneeded `shared_ptr` references to `unique_ptr`
- Ensure `glew.h` is loaded before `gl.h`
- Use pairing heap in pathfinding
- Look for sound files in both `sounds.drs` and `sounds_x1.drs` folders

## Removed
- Duplicate code for accessing engine camera
- SDL memleak example
- Remove leftover config sections for coverity

## Fixed
- Gameplay fixes
    - Ungarrisoning no longer loses units
    - Prevent ranged units from freezing when garrisoning them
    - Make decaying units face correct direction and disappear after a short time
    - Stop segfaulting when gather target is removed
    - Garrison restricted to allied buildings
    - Siege now only placable on land
    - Buildings take time to train a unit
    - Units can ungarrison while the building is training something
- Clean annexed buildings properly from memory
- Visual fixes for dock/ships
- Fix the CMake `cmp0054` policy for using quoted if evaluation
- Fix segfault when shutting down
- Fix `Tile.get_pos_on_chunk()` to return the position of the tile on the chunk
- Case sensitivity fixes
- Fix crashes for missing arguments when calling executable
- Clean up comments in converter code
- Ignore empty `gamedata.drs` when converting
- Relocate phys3 hashing to correct file
- Fix wrong start offset of delta graphics
- Add forgotten comment line separators in csv output
- Fix judgement of `child_errno`
- Do not assign lambda to variable
- Fix new[]/delete mismatch
- Fix error messages for legal header copyright years
- Fix codecompliance script to be compatible with git rebase and cherry-pick
- Fix conversion of `empires.dat` file strings with garbage data past their \0 terminators
- Pass strings as `const` references instead of copying them
- Better pep8 compliance
- Various horrible typos (#301, #307)

## Full commit log

https://github.com/SFTtech/openage/compare/v0.2.3...v0.3.0
