# [0.3.0-alpha] - 2019-06-12
All notable changes for version [v0.3.0-alpha] are documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html) since release [v0.4.0].

## Added
- Add OpenSAGE to the list of related projects
- Check if cython modules were built and imported correctly
- Add new technical overview to README
- Add instructions to reproduce 'evolution video' on Youtube channel
- Add logo version optimized for printing
- Use GNU gold linker by default
- Add information in `stemplet-dat.md`
- Use C++17 as new code standard
- Out-of-source-tree builds
- Add proton/steam play as a way to obtain assets
- Support for building openage under a virtualenv
- Lazy log message formatting
- Add support for unpatched Age of Empires 2: The Conquerors
- Parallel cythonization for build process
- Initial implementation of new core simulation
- Add `readwrite` and `append` modes for opening files
- Add quit button
- Add donation button to README
- Option for automatic correction of copyright years
- Add new SLP draw commands to converter
- Show known compiler versions in CMake error message
- Bunch of new gameplay ideas
- Adapt converter to support all Genie Engine games
- Add Debian build instructions
- Link to nyan library
- Remember previous asset location
- Resource capacities
- Buildings limits
- Windows installer package
- Introduce interactive conversion shell
- Add convenience options for using ccache in CMake
- Support debugging with gdbgui
- Add Gentoo build instructions
- Troubleshooting guide
- Break into debugger on throwing an exception
- Add Windows documentation and build instructions
- Windows native support using MSVC - Visual Studio 2017
- Add FreeBSD build instructions
- Add FreeBSD support
- Add python profiling helper class
- New renderer (initial abstraction implementation)
- Add researching (aka technologies)
- Implement mouse controlled game window movement
- More enhanced filter options for converter: `--no-graphics` and `--no-scripts`
- Buildsystem benchmarks
- Allow customization of config and asset dir in buildysystem
- Prefix-matching for tests
- Documentation of blending mask lookup table (AoE2)
- Ignore compiled QML in `.gitignore`
- Obfuscation for Email addresses in `copying.md`
- Introduce Mac-specific shims for `utimenstat()` and for `stat.st_mtim`
- Tau as math constant
- Unit life cycle management
- Scores (AoE2)
- `separate-shared-context` mode in GUI
- Implement siphash
- Qualified QML imports for the openage objects
- Population logic
- Quaternion
- Log Qt version
- Add codecompliance check for Markdown
- Use multiprocessing with pylint
- Implement market pricing
- Documentation of original gameplay features
    - Accuracy formulas
    - Market prices
    - Monks
    - Rams
    - Alarm
    - Town Bell
    - Waypoints
    - Pathfinding
    - Villagers
    - Formations
    - AoE1 civilization/unit stats
    - Multiplayer chat messsaging in AoC
    - Multiplayer communication protocol
    - Selection mechanics
    - Better damage formula
    - Number of projectiles per garrisoned unit
- Caching of gamedata files
- Convert AoE2: African Kingdoms expansion
- Resource bundles
- Repair action
- Option to start game after assets have loaded
- Instructions for developing with Qt Creator
- Player teams
- Inform about the `gl-debug` option when `gl error` is detected
- Switch to other player via hotkey
- Build menus
- Keep building after finishing a building
- Check for .qml files for legal headers
- Add documentation about resuming construction of buildings
- GL debug option for better OpenGL backtrace
- Render the GUI into an FBO
- Selection box actions
- Show the color of the active player in building menu icons
- multiarch installdir and version for packaging
- Add documentation for openage nyan usage
- Optional FPS limiter
- Unit command queue
- GUI dynamic middle part of the HUD
- Adding CVar subsystem
- Dynamic key bindings
- Documentation updates to gamedata structs in converter logic
- Documentation for damage calculations in AoE2
- `ENSURE` macro for assertions
- Support for kevin CI
- GUI ingame background assets adaptation
- Add guide to download assets with SteamCMD
- Add asset downloading guide for Steam version to `media_convert.md`
- Option to convert a single SLP file from a DRS archive
- Draw all available hotkeys in the right corner
- Add QtQuick ingame GUI
- Introduce `GameVersion` enum for better game version checks
- Added OpenRCT2 as a likeminded project
- Villagers bring their resources to the correct buildings
- Support clang on Mac OS X
- Matrix class with artihmetics
- Vector class with arithmetics
- Text renderer with support for colors
- Ingame console UTF-8 backspace support
- Engine profiler
- New official logo
- Converter parses terrain blobs
- Source media versioning and simple diffing
- Media conversion for AoE2: HD Edition version 4.0

## Changed
- Consistently use `openage::util::hash_combine()`
- Convert source directory finding improvements
- Rearrange pyobject `pxd` annotations to enforce consistent style
- C++14 logic for `constexpr` functions
- Let converter use memoryviews in visgrep
- Register files generated by buildsystem as byproducts
- New simpler `Enum` implementation that also works on Windows
- Coordinate system rewrite
- Require C++ compiler to support C++17 features
- Rename mentions of "Mac OS X" to macOS
- Directly use `CMAKE_DL_LIBS` CMake variable for linked libraries
- Add the default Steam Linux AoE2 path to the media conversion examples
- `free_memory()` in `util/system.py` has single exit point now
- Use binary mode for files in C++
- Include other Genie Engine games (AoE1, SWGB) in README
- Test compilation in release mode too
- Use libpng directly to create screenshots
- Update C-style cast to `static_cast` in `program.cpp`
- Update DRS file format conversion
- Move contact table to the top of README
- Logo SVG improvements
- Save alpha channel in screenshots
- Add hint about restarting Steam for SteamCMD conversion
- Euclidean distance optimization
- Use libopus instead of opusenc binary for audio conversion
- Cleanup color logic in old renderer
- Update doxyfile with doxywizard
- Blacklist pythontex in buildsystem
- Check for A_S_D_F in codecompliance
- Require cython 0.25
- Surround `engine::run` with try catch block
- Doxygen generation improvements
- Make audio system optional
- Set verbosity level of spammy runtime messages to `debug` or `spam`
- Force colored CMake output in kevin builds
- Textfiles code compliance improvements
- Attributes system improvements
- Codestyle simplifications and extensions
- Handle pep8 module renaming to pycodestyle
- pylint is now imported, not invoked
- Rebind `STOP_GAME` to `SHIFT` + `ESC`
- Cleanup Python `include`s
- Propose paths for conversion `source_dir`, including Wine prefixes
- Depend on a newer cython 0.23 version
- Append selection with SHIFT key instead of CTRL
- Apply asset path expansion in both `AGE2DIR` var and input path
- Switch to `#pragma once` header guard instead of constructed unique preprocessor variables
- Cythonize rgba matrix calculation for converter palette lookups
- Use typedef `sighandler_t` for WIN32
- Use C++11 chrono for crossplatform timing
- Tweaks for configuring via cmake on MSYS2
- Use `math::PI` instead of `M_PI`
- Expanded the critical section in logger to include `init()`
- Texture bin packing improvements in SLP converter
- Optimize texture frame merging in SLP converter
- Change copyright dates to 2016
- Enable backtrace collection by default
- Expand environment variables and ~ in asset path of converter
- Let build steps depend on each other
- Better graphics handling for unit data
- Improvments to the team colors shader
- Do not enforce `release` or `debug` build in buildysystem
- Text rendering using HarfBuzz and vbo's, removing `FTGL`
- Clean up buildsystem
- Gameplay ideas restructured and extended with ideas from r/aoe2
- `Gamemain` split across several classes
- Seperate existing map rendering code into `GameRenderer`
- Input handling and UI rendering now done in `GameControl`
- `GameControl` splits existing input code into `EditorMode` and `ActionMode`
- `DataManager` renamed to `GameSpec`
- File loading for `Terrain` now done by `GameSpec` so it only needs loading once
- Construct `Terrain` objects by just using meta data
- Update Ubuntu instructions
- Update openSUSE build instructions
- Update Fedora build instructions for Fedora 22
- Update macOS build instructions
- Update Arch Linux build instructions

## Deprecated
- Complete engine rewrite in progress
    - Old lockstep gamestate will be replaced with curve-based event system
    - Data storage will change from CSV files to storage in `nyan` format
    - Data management will be replaced with a nyan database
    - Old OpenGL renderer due to being replaced with more efficient renderer using Vulkan and OpenGL

## Removed
- Remove `DoublyLinkedList` implementation
- Remove `--data=assets` argument from `.desktop` file command
- Remove user input (file path) from regular expression extension check
- Remove Travis CI support (replaced with kevin)
- Network and binary compatibility with original game as project goals
- Remove crossplatform folder and move everything to `util` subfolder
- Remove unsused lambda captures
- Remove usage of deprecated `std::hash::result_type`
- Remove deprecated `std::unary_function` usage
- Get rid of pylint workarounds
- No more transitive linking of internally used libraries

## Fixed
- Fix `path.relative_to` usage for pxdgen
- Fix mingw Windows build
- Fix cyclic dependency on unnecessary timefile in buildsystem
- Fix reference to openage directory to represent canonical form
- Fix table formatting in `terrain.md`
- Add missing `<algorithm>` inclusions for `std::min` and `std::max`
- Fix cythonization for cython 0.29
- Fix codegen error during cmake/configure phase
- Support directories that are symlinks for building
- Fix overly specific headerguard regex in buildsystem
- Ignore merge commit dates for copyright year
- Let automoc depend on codegen
- Fix case-ignoring-dir-test for caseignoring filesystems
- Fix font glyph memory allocations
- Fix cython calling static member method in C++
- Fix units getting stuck when dropsite is not found
- Fix a cvar python type
- Fix `ConstMap` type errors
- Fix python loglevels
- Fix older compiler invocations
- Fix build on macOS computers that don't have Sierra && XCode 8
- Build cython generated files with reduced warnings
- Fix building with GCC7
- Fix RGB endianness used in pixel transfer
- Fix missing braces warnings for subobject initialization
- Fix codegen path in comments
- Fix ownerless projectlies causing crash
- Fix broken audio log messages
- Fix pylint complaining about kevin
- Fix build with libbacktrace, clean up log includes
- Do not show version numbers if the gamespec hash changes
- Purge engine singleton
- `noexcept` annotation for all move constructors/assignment operators in GUI
- Fix wrong priority handling for union in `util` module
- Add `/usr/bin/env python3` to `FindPython.cmake`
- Limit building completion to 100%
- Set `cxx_standard` to fix qt bug
- Fix encoding error in data formatter of converter
- Drop invalid interpreters when finding Python
- Fix Mac OS X clang compile errors
- Add missing source reference in CMakeLists.txt
- Fix building placement segfault
- Added a missing call to call in the C++ examples
- Fix failure of automatic doc creation, if a parent directory has a white space
- Correct graphic for idle gathering villager carrying zero amount
- Fix missing `DEVMODE = True` line in config.py
- Check if executable of build dependencies was found
- Reset the amount gathered upon switching resource type
- Find language file location for AoE2: HD Edition version 3.X
- Fix runtime dependency check
- Fix python library dir finding
- Fix villagers not holding ressources when idle
- Fix dead units receiving damage
- Suppress false positives for pylint 1.5.1
- Check for compiler's `thread_local` support
- Fix villagers not stopping to gather resources when moved away
- Add missing dependencies `python-pygments`, `python-pylint` and `cython` under Arch Linux
- Fix broken link to `building.md` in `copying.md`
- Include `-L<dir>` flag for linking against python
- Fix confusion of AoE2: HD Edition with AoC 1.0c
- Remove deadlock in `JobManager`/`Worker`
- Fix SLP conversion issues from [v0.3.0] release
- Stub some unused/unimplemented stuff on WIN32, so it can compile
- Various horrible typos (#453, #496, #507, #639, #713, #757, #801, #823, #861, #925, #960, #1020, #1106)

## Full commit log

https://github.com/SFTtech/openage/compare/v0.3.0...v0.3.0-alpha
