# Copyright 2023-2023 the openage authors. See copying.md for legal info.

"""
Test whether the openage nyan API modpack is present.
"""
from __future__ import annotations
import typing

import toml

from ....log import info, dbg

from .modpack_search import get_modpack_info

if typing.TYPE_CHECKING:
    from openage.util.fslike.directory import Directory


CURRENT_API_VERSION = "0.4.0"


def api_export_required(asset_dir: Directory) -> bool:
    """
    Returns true if the openage nyan API modpack cannot be found.

    TODO: Remove once the API modpack is generated by default.
    """
    modpack_dir = asset_dir / "converted" / "engine"

    try:
        modpack_info = get_modpack_info(modpack_dir)
        version = modpack_info["info"]["version"]

        if version != CURRENT_API_VERSION:
            info("openage nyan API modpack is outdated")
            dbg("version is %s, expected %s", version, CURRENT_API_VERSION)
            return True

        info("openage nyan API modpack is up to date")
        return False

    except (FileNotFoundError, TypeError, toml.TomlDecodeError):
        info("openage nyan API modpack not found")

    return True
