// Copyright 2013-2021 the openage authors. See copying.md for legal info.

// Warning: this file is a dummy file and was auto-generated by the v0.4.1 converter;
// its purpose is to keep the deprecated gamestate compilable and intact;
// these files keep only the minimum functionality and should not be changed;
// For details, see buildsystem/codegen.cmake and openage/codegen.

#pragma once

#include <cstddef>
#include <cstdint>
#include <string>
#include "util/csv.h"



namespace openage {
namespace gamedata {

/**
 * specification of terrain frames.
 */
struct frame_data {
	int16_t frame_count;
	int16_t angle_count;
	int16_t shape_id;
	static constexpr size_t member_count = 3;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * describes animation properties of a terrain type
 */
struct terrain_animation {
	int8_t is_animated;
	int16_t animation_frame_count;
	int16_t pause_frame_count;
	float interval;
	float pause_between_loops;
	int16_t frame;
	int16_t draw_frame;
	float animate_last;
	int8_t frame_changed;
	int8_t drawn;
	static constexpr size_t member_count = 10;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

struct terrain_pass_graphic {
	int32_t slp_id_exit_tile;
	int32_t slp_id_enter_tile;
	int32_t slp_id_walk_tile;
	int32_t replication_amount;
	static constexpr size_t member_count = 4;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * size definition of one terrain tile.
 */
struct tile_size {
	int16_t width;
	int16_t height;
	int16_t delta_z;
	static constexpr size_t member_count = 3;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * TODO
 */
struct terrain_restriction {
	openage::util::csv_subdata<openage::gamedata::terrain_pass_graphic> pass_graphics;
	static constexpr size_t member_count = 2;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * one inter-terraintile border specification.
 */
struct terrain_border : terrain_animation {
	int8_t enabled;
	int8_t random;
	std::string internal_name;
	std::string filename;
	int32_t slp_id;
	int32_t shape_ptr;
	int32_t sound_id;
	openage::util::csv_subdata<openage::gamedata::frame_data> frames;
	int16_t draw_tile;
	int16_t underlay_terrain;
	int16_t border_style;
	static constexpr size_t member_count = 22;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

/**
 * describes a terrain type, like water, ice, etc.
 */
struct terrain_type : terrain_animation {
	int8_t enabled;
	int8_t random;
	std::string internal_name;
	std::string filename;
	int32_t slp_id;
	int32_t shape_ptr;
	int32_t sound_id;
	int32_t blend_priority;
	int32_t blend_mode;
	uint8_t map_color_hi;
	uint8_t map_color_med;
	uint8_t map_color_low;
	uint8_t map_color_cliff_lt;
	uint8_t map_color_cliff_rt;
	int8_t passable_terrain;
	int8_t impassable_terrain;
	openage::util::csv_subdata<openage::gamedata::frame_data> elevation_graphics;
	int16_t terrain_replacement_id;
	int16_t terrain_to_draw0;
	int16_t terrain_to_draw1;
	int16_t terrain_units_used_count;
	static constexpr size_t member_count = 35;
	int fill(const std::string &line);
	bool recurse(const openage::util::CSVCollection &storage, const std::string &basedir);

};

} // gamedata
} // openage
