// Copyright 2013-2021 the openage authors. See copying.md for legal info.

// Warning: this file is a dummy file and was auto-generated by the v0.4.1 converter;
// its purpose is to keep the deprecated gamestate compilable and intact;
// these files keep only the minimum functionality and should not be changed;
// For details, see buildsystem/codegen.cmake and openage/codegen.


#include <cstdio>
#include <vector>
#include "error/error.h"
#include "sound_dummy.h"
#include "util/strings.h"


namespace openage {
namespace gamedata {

constexpr size_t sound::member_count;
constexpr size_t sound_item::member_count;
int sound::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', sound::member_count
    );

    if (buf.size() != sound::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing sound led to "
            << buf.size()
            << " columns (expected "
            << sound::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%hd", &this->sound_id) != 1) { return 0; }
    if (sscanf(buf[1].c_str(), "%hd", &this->play_delay) != 1) { return 1; }
    if (sscanf(buf[2].c_str(), "%d", &this->cache_time) != 1) { return 2; }
    this->sound_items.filename = buf[3];

    return -1;
}

int sound_item::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', sound_item::member_count
    );

    if (buf.size() != sound_item::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing sound_item led to "
            << buf.size()
            << " columns (expected "
            << sound_item::member_count
            << ")!"
        );
    }

    this->filename = buf[0];
    if (sscanf(buf[1].c_str(), "%d", &this->resource_id) != 1) { return 1; }
    if (sscanf(buf[2].c_str(), "%hd", &this->probablilty) != 1) { return 2; }
    if (sscanf(buf[3].c_str(), "%hd", &this->civilization_id) != 1) { return 3; }
    if (sscanf(buf[4].c_str(), "%hd", &this->icon_set) != 1) { return 4; }

    return -1;
}

bool sound_item::recurse(const openage::util::CSVCollection & /*storage*/, const std::string & /*basedir*/) {
    return true;
}

bool sound::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->sound_items.read(storage, basedir);

    return true;
}

} // gamedata
} // openage
