// Copyright 2013-2021 the openage authors. See copying.md for legal info.

// Warning: this file is a dummy file and was auto-generated by the v0.4.1 converter;
// its purpose is to keep the deprecated gamestate compilable and intact;
// these files keep only the minimum functionality and should not be changed;
// For details, see buildsystem/codegen.cmake and openage/codegen.


#include <cstdio>
#include <string>
#include <vector>
#include "civilisation_dummy.h"
#include "error/error.h"
#include "unit_dummy.h"
#include "util_dummy.h"
#include "util/csv.h"
#include "util/path.h"
#include "util/strings.h"


namespace openage {
namespace gamedata {

constexpr size_t civilisation::member_count;
int civilisation::fill(const std::string &line) {
    std::vector<std::string> buf = openage::util::split_escape(
        line, ',', civilisation::member_count
    );

    if (buf.size() != civilisation::member_count) {
        throw openage::error::Error(
            ERR
            << "Tokenizing civilisation led to "
            << buf.size()
            << " columns (expected "
            << civilisation::member_count
            << ")!"
        );
    }

    if (sscanf(buf[0].c_str(), "%hhd", &this->player_type) != 1) { return 0; }
    this->name = buf[1];
    if (sscanf(buf[2].c_str(), "%hd", &this->tech_tree_id) != 1) { return 2; }
    if (sscanf(buf[3].c_str(), "%hd", &this->team_bonus_id) != 1) { return 3; }
    if (sscanf(buf[5].c_str(), "%hhd", &this->icon_set) != 1) { return 5; }
    this->units.subdata_meta.filename = buf[6];

    return -1;
}

bool civilisation::recurse(const openage::util::CSVCollection &storage, const std::string &basedir) {
    this->units.recurse(storage, basedir);

    return true;
}

int unit_types::fill(const std::string & /*line*/) {
    return -1;
}
bool unit_types::recurse(const openage::util::CSVCollection &storage,
                         const std::string &basedir) {

    // the .filename was set by the previous entry parser already
    // so now read the index-file entries
    this->subdata_meta.read(storage, basedir);

    int subtype_count = this->subdata_meta.data.size();
    if (subtype_count != 9) {
        throw openage::error::Error(
            ERR << "multisubtype index file entry count mismatched!"
            << subtype_count << " != 9"
        );
    }

    // the recursed data files are relative to the subdata_meta filename
    std::string metadata_dir = basedir + openage::util::fslike::PATHSEP + openage::util::dirname(this->subdata_meta.filename);
    int idx;
    int idxtry;

    // read subtype 'action'
    idx = -1;
    idxtry = 0;
    // find the index of the subdata in the metadata
    for (auto &file_reference : this->subdata_meta.data) {
        if (file_reference.subtype == "action") {
            idx = idxtry;
            break;
        }
        idxtry += 1;
    }
    if (idx == -1) {
        throw openage::error::Error(
            ERR << "multisubtype index file contains no entry for action!"
        );
    }

    // the filename is relative to the metadata file!
    this->action.filename = this->subdata_meta.data[idx].filename;
    this->action.read(storage, metadata_dir);

    // read subtype 'animated'
    idx = -1;
    idxtry = 0;
    // find the index of the subdata in the metadata
    for (auto &file_reference : this->subdata_meta.data) {
        if (file_reference.subtype == "animated") {
            idx = idxtry;
            break;
        }
        idxtry += 1;
    }
    if (idx == -1) {
        throw openage::error::Error(
            ERR << "multisubtype index file contains no entry for animated!"
        );
    }

    // the filename is relative to the metadata file!
    this->animated.filename = this->subdata_meta.data[idx].filename;
    this->animated.read(storage, metadata_dir);

    // read subtype 'building'
    idx = -1;
    idxtry = 0;
    // find the index of the subdata in the metadata
    for (auto &file_reference : this->subdata_meta.data) {
        if (file_reference.subtype == "building") {
            idx = idxtry;
            break;
        }
        idxtry += 1;
    }
    if (idx == -1) {
        throw openage::error::Error(
            ERR << "multisubtype index file contains no entry for building!"
        );
    }

    // the filename is relative to the metadata file!
    this->building.filename = this->subdata_meta.data[idx].filename;
    this->building.read(storage, metadata_dir);

    // read subtype 'doppelganger'
    idx = -1;
    idxtry = 0;
    // find the index of the subdata in the metadata
    for (auto &file_reference : this->subdata_meta.data) {
        if (file_reference.subtype == "doppelganger") {
            idx = idxtry;
            break;
        }
        idxtry += 1;
    }
    if (idx == -1) {
        throw openage::error::Error(
            ERR << "multisubtype index file contains no entry for doppelganger!"
        );
    }

    // the filename is relative to the metadata file!
    this->doppelganger.filename = this->subdata_meta.data[idx].filename;
    this->doppelganger.read(storage, metadata_dir);

    // read subtype 'living'
    idx = -1;
    idxtry = 0;
    // find the index of the subdata in the metadata
    for (auto &file_reference : this->subdata_meta.data) {
        if (file_reference.subtype == "living") {
            idx = idxtry;
            break;
        }
        idxtry += 1;
    }
    if (idx == -1) {
        throw openage::error::Error(
            ERR << "multisubtype index file contains no entry for living!"
        );
    }

    // the filename is relative to the metadata file!
    this->living.filename = this->subdata_meta.data[idx].filename;
    this->living.read(storage, metadata_dir);

    // read subtype 'missile'
    idx = -1;
    idxtry = 0;
    // find the index of the subdata in the metadata
    for (auto &file_reference : this->subdata_meta.data) {
        if (file_reference.subtype == "missile") {
            idx = idxtry;
            break;
        }
        idxtry += 1;
    }
    if (idx == -1) {
        throw openage::error::Error(
            ERR << "multisubtype index file contains no entry for missile!"
        );
    }

    // the filename is relative to the metadata file!
    this->missile.filename = this->subdata_meta.data[idx].filename;
    this->missile.read(storage, metadata_dir);

    // read subtype 'moving'
    idx = -1;
    idxtry = 0;
    // find the index of the subdata in the metadata
    for (auto &file_reference : this->subdata_meta.data) {
        if (file_reference.subtype == "moving") {
            idx = idxtry;
            break;
        }
        idxtry += 1;
    }
    if (idx == -1) {
        throw openage::error::Error(
            ERR << "multisubtype index file contains no entry for moving!"
        );
    }

    // the filename is relative to the metadata file!
    this->moving.filename = this->subdata_meta.data[idx].filename;
    this->moving.read(storage, metadata_dir);

    // read subtype 'object'
    idx = -1;
    idxtry = 0;
    // find the index of the subdata in the metadata
    for (auto &file_reference : this->subdata_meta.data) {
        if (file_reference.subtype == "object") {
            idx = idxtry;
            break;
        }
        idxtry += 1;
    }
    if (idx == -1) {
        throw openage::error::Error(
            ERR << "multisubtype index file contains no entry for object!"
        );
    }

    // the filename is relative to the metadata file!
    this->object.filename = this->subdata_meta.data[idx].filename;
    this->object.read(storage, metadata_dir);

    // read subtype 'tree'
    idx = -1;
    idxtry = 0;
    // find the index of the subdata in the metadata
    for (auto &file_reference : this->subdata_meta.data) {
        if (file_reference.subtype == "tree") {
            idx = idxtry;
            break;
        }
        idxtry += 1;
    }
    if (idx == -1) {
        throw openage::error::Error(
            ERR << "multisubtype index file contains no entry for tree!"
        );
    }

    // the filename is relative to the metadata file!
    this->tree.filename = this->subdata_meta.data[idx].filename;
    this->tree.read(storage, metadata_dir);

    return true;
}

} // gamedata
} // openage
