# [0.3.0] - 2021-03-03
All notable changes for version [v0.3.0] are documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## Renamed
### Ability module
- Rename `Damageable` object to `AttributeChangeTracker`
- Rename `Die` object to `PassiveTransformTo`
- Rename `TransformTo` object to `ActiveTransformTo`
- Rename `blacklisted_game_entities` member of `ApplyContinuousEffect` to `blacklisted_entities`
- Rename `blacklisted_game_entities` member of `ApplyDiscreteEffect` to `blacklisted_entities`
- Rename `damage_progress` member of `AttributeChangeTracker` to `change_progress`
- Rename `despawn_conditions` member of `Despawn` to `despawn_condition`
- Rename `blacklisted_game_entities` member of `DropResources` to `blacklisted_entities`
- Rename `blacklisted_game_entities` member of `EnterContainer` to `blacklisted_entities`
- Rename `exchange_mode` member of `ExchangeResources` to `exchange_modes`
- Rename `blacklisted_game_entities` member of `Herd` to `blacklisted_entities`
- Rename `death_conditions` member of `PassiveTransformTo` to `condition`
- Rename `blacklisted_game_entities` member of `SendBackToTask` to `blacklisted_entities`
- Rename `blacklisted_game_entities` member of `ShootProjectile` to `blacklisted_entities`
- Rename `empty_threshold` member of `Storage` to `empty_condition`
- Rename `allowed_trade_routes` member of `TradePost` to `trade_routes`

### Auxiliary module
- Rename `AvailabilityPrerequisite` object to `Literal`
- Rename `DamageProgress` object to `AttributeChangeProgress`
- Rename `Civilization` object to `PlayerSetup`
- Rename `ExchangePool` object to `PricePool`
- Rename `StorageElement` object to `StorageElementDefinition`
- Rename `creation_sound` member of `CreatableGameEntity` to `creation_sounds`
- Rename `placement_mode` member of `CreatableGameEntity` to `placement_modes`
- Rename `requirements` member of `CreatableGameEntity` to `condition`
- Rename `storage_elements` member of `Container` to `storage_element_defs`
- Rename `blacklisted_game_entities` member of `GameEntityScope(Entity)` to `blacklisted_entities`
- Rename `civ_setup` member of `PlayerSetup` to `game_setup`
- Rename `requirements` member of `ResearchableTech` to `condition`
- Rename `research_sound` member of `ResearchableTech` to `research_sounds`
- Rename `capacity` member of `ResourceSpot` to `max_amount`
- Rename all fqons starting with `aux.literal.*` to `aux.logic.literal.*`
- Rename all fqons starting with `aux.translated.*` to `aux.language.translated.*`

### Modifier module
- Rename `TimeRelativeProgress` object to `TimeRelativeProgressChange`
- Rename `RefundOnDeath` object to `RefundOnCondition`
- Rename `requirements` member of `InstantTechResearch` to `condition`
- Rename `blacklisted_game_entities` member of `FlyOver` to `blacklisted_entities`
- Rename `blacklisted_game_entities` member of `DepositResourcesOnProgress` to `blacklisted_entities`
- Rename `elevation_difference` member of `ElevationDifferenceHigh` to `min_elevation_difference`
- Rename `elevation_difference` member of `ElevationDifferenceLow` to `min_elevation_difference`
- Rename all fqons starting with `modifer.multiplier.*` to `modifier.*`
- Rename all fqons starting with `modifer.relative_projectile_amount.*` to `modifier.*`

### Effect module
- Rename `AttributeCostResistance` object to `CostResistance`
- Rename `TimeRelativeProgress` object to `TimeRelativeProgressChange`
- Rename fqon `engine.effect.continuous.type.Lure` to `engine.effect.continuous.lure.type.Lure`
- Rename fqon `engine.effect.discrete.type.MakeHarvestable` to `engine.effect.discrete.make_harvestable.type.MakeHarvestable`
- Rename fqon `engine.effect.discrete.type.SendToContainer` to `engine.effect.discrete.send_to_container.type.SendToContainer`

### Resistance module
- Rename `AttributeCostResistance` object to `CostResistance`
- Rename `TimeRelativeProgress` object to `TimeRelativeProgressChange`
- Rename `harved_conditions` member of `MakeHarvestable` to `resist_condition`
- Rename fqon `engine.resistance.continuous.type.Lure` to `engine.resistance.continuous.lure.type.Lure`
- Rename fqon `engine.resistance.discrete.type.MakeHarvestable` to `engine.resistance.discrete.make_harvestable.type.MakeHarvestable`
- Rename fqon `engine.resistance.discrete.type.SendToContainer` to `engine.resistance.discrete.send_to_container.type.SendToContainer`

## Added
### Ability module
- Add `AbilityProperty` object; replaces inherited `Ability` specializations
- Add `Animated(AbilityProperty)` object
- Add `AnimationOverride(AbilityProperty)` object
- Add `CommandSound(AbilityProperty)` object
- Add `Diplomatic(AbilityProperty)` object
- Add `ExecutionSound(AbilityProperty)` object
- Add `Lock(AbilityProperty)` object
- Add `DetectCloak(Ability)` object; enables game entity to discover cloaked units
- Add `Lock(Ability)` object; defines lock pools which can be used for preventing abilities from being active at the same time
- Add `ProductionQueue(Ability)` object; enables game entity to queue game entity or tech production
- Add `ResourceStorage(Ability)` object; stores resources from gathering
- Add `properties : dict(AbilityProperty, AbilityProperty)` member to `Ability`
- Add `batches : set(EffectBatch)` member to `ApplyDiscreteEffect`; stores the effects as transactions
- Add `activation_condition : set(LogicElement)` member to `Despawn`; activates the ability
- Add `containers : set(ResourceContainer)` member to `DropResources`
- Add `accepts_from : set(ResourceContainer)` member to `DropSite`
- Add `exchange_rate : ExchangeRate` member to `ExchangeResources`
- Add `resource_a : Resource` member to `ExchangeResources`
- Add `resource_b : Resource` member to `ExchangeResources`
- Add `container : ResourceContainer` member to `Gather`
- Add `gatherer_limit : int` member to `Harvestable`; moved from `ResourceSpot`
- Add `harvest_progress : set(HarvestProgress)` member to `Harvestable`; moved from `ResourceSpot`
- Add `harvestable_by_default : bool` member to `Harvestable`; moved from `ResourceSpot`
- Add `restock_progress : set(RestockProgress)` member to `Harvestable`; moved from `RestockableResourceSpot`
- Add `strength : int` member to `Herd`; Herders with higher strength will be prefered
- Add `mode : HerdableMode` member to `Herdable`; determines who gets ownership of the herdable game entity
- Add `hitbox : Hitbox` member to `Hitbox`; x, y, z dimensions
- Add `hitbox : Hitbox` member to `Passable`; references hitbox that is passable
- Add `mode : PassableMode` member to `Passable`; determines special passability
- Add `transform_progress : set(TransformProgress)` member to `PassiveTransformTo`
- Add `selection_box : SelectionBox` member to `Selectable`; determines at which relative coordinates the game entity can be selected
- Add `allowed_types : set(TerrainType)` member to `TerrainRequirement`; specifies which terrain types can be walked on by a game entity
- Add `blacklisted_terrains : set(Terrain)` member to `TerrainRequirement`; exceptions for allowed terrain types

### Auxiliary module
- Add `EffectBatch(Entity)` object
- Add `OrderedBatch(EffectBatch)` object
- Add `UnorderedBatch(EffectBatch)` object
- Add `ChainedBatch(EffectBatch)` object
- Add `BatchProperty(Entity)` object
- Add `Priority(BatchProperty)` object
- Add `Chance(BatchProperty)` object
- Add `OwnsGameEntity(Literal)` object
- Add `StateChangeActive(Literal)` object
- Add `Reset(StateChanger)` object
- Add `Reset(AnimationOverride)` object
- Add `ProgressProperty(Entity)` object; replaces inherited `Progress` specializations
- Add `AnimationOverlay(ProgressProperty)` object
- Add `Animated(ProgressProperty)` object
- Add `Terrain(ProgressProperty)` object
- Add `TerrainOverlay(ProgressProperty)` object
- Add `StateChange(ProgressProperty)` object
- Add `LockPool(Entity)` object
- Add `HerdableMode(Entity)` object; determines who gets ownership of the herdable game entity
- Add `ClosestHerding(HerdableMode)` object
- Add `LongestTimeInRange(HerdableMode)` object
- Add `MostHerding(HerdableMode)` object
- Add `Shadow(PaymentMode)` object; requires resources to be available but does not subtract them from payment resources
- Add `TerrainType(Entity)` object; can specify type of a terrain
- Add `CalculationType(Entity)` object; used for `StackedResistance`
- Add `NoStack(CalculationType)` object
- Add `Linear(CalculationType)` object
- Add `Hyperbolic(CalculationType)` object
- Add `DistributionType(Entity)` object; used for `StackedResistance`
- Add `Mean(DistributionType)` object
- Add `OwnStorage(PlacementMode)` object; allows created game entities to be store directly into container of creating game entity
- Add `ProductionMode(Entity)` object; used by `ProductionQueue` ability
- Add `Creatables(ProductionMode)` object
- Add `Researchables(ProductionMode)` object
- Add `Hitbox(Entity)` object; stores size arguments for `Hitbox(Ability)`
- Add `PassableMode(Entity)` object; determines special passable modes
- Add `Normal(PassableMode)` object
- Add `Gate(PassableMode)` object; hitbox is always passable to everyone with correct stance and passable with any other stance when any other unit is passing through
- Add `LiteralScope(Entity)` object; specifies where the literal has to be fulfilled
- Add `Any(LiteralScope)` object
- Add `Self(LiteralScope)` object
- Add `SelectionBox(Entity)` object; used by `Selectable` ability
- Add `MatchToSprite(SelectionBox)` object
- Add `Rectangle(SelectionBox)` object
- Add `TransformPool(Entity)` object; defines one explicit state machine that can have one state at a time
- Add `NyanPatch(Entity)` object; patches must inherit from this object now
- Add `PatchProperty(Entity)` object
- Add `Diplomatic(PatchProperty)` object
- Add `AttributeBelowValue(Literal)` object; replaces `AttributeInterval(Literal)`
- Add `AttributeAboveValue(Literal)` object; replaces `AttributeInterval(Literal)`
- Add `AttributeBelowPercentage(Literal)` object
- Add `AttributeAbovePercentage(Literal)` object
- Add `Palette(Entity)` object
- Add `Guard(MoveMode)` object
- Add `Replace(PlacementMode)` object
- Add `TechType(Entity)` object; defines types for techs
- Add `Any(GameEntityType)` object
- Add `Any(TechType)` object
- Add `Any(TerrainType)` object
- Add `Any(DiplomaticStance)` object
- Add `ResourceStorage(Entity)` object; manages resource capacity and carry progress
- Add `InternalDropSite(ResourceStorage)` object; resource storage that doesn't need a drop site
- Add `Sell(ExchangeMode)` object
- Add `Buy(ExchangeMode)` object
- Add `ExchangeRate(Entity)` object
- Add `PriceMode(Entity)` object
- Add `Fixed(PriceMode)` object
- Add `Dynamic(PriceMode)` object
- Add `LogicElement(Entity)` object; logic block for conditions
- Add `LogicGate(LogicElement)` object; boolean expression, circuit style
- Add `AND(LogicGate)` object
- Add `MULTIXOR(LogicGate)` object
- Add `NOT(LogicGate)` object
- Add `OR(LogicGate)` object
- Add `SUBSETMAX(LogicGate)` object
- Add `SUBSETMIN(LogicGate)` object
- Add `XOR(LogicGate)` object
- Add `True(LogicElement)` object
- Add `False(LogicElement)` object
- Add `variants : set(Variant)` member to `CreatableGameEntity` object
- Add `priority : int` member to `Mod` object; determines load order when multiple `Mod` objects are present
- Add `types: set(TerrainType)` member to `Terrain`; can specify type of a terrain
- Add `tile_snap_distance : float` member to `Place(PlacementMode)`; lets placed game entities snap to the tile grid
- Add `clearance_size_x : float` member to `Place(PlacementMode)`
- Add `clearance_size_y : float` member to `Place(PlacementMode)`
- Add `allow_rotation : bool` member to `Place(PlacementMode)`
- Add `max_elevation_difference : int` member to `Place(PlacementMode)`
- Add `scope : LiteralScope` member to `Literal(Entity)`; specifies where the literal has to be fulfilled
- Add `patch : NyanPatch` member to `Patch(Entity)`; objects now acts as engine wrapper for patches, previous functionality replaced by `NyanPatch(Entity)`
- Add `left_boundary: float` member to `Progress(Entity)`; boundary for progress interval
- Add `right_boundary: float` member to `Progress(Entity)`; boundary for progress interval
- Add `allowed_types: set(GameEntityType)` member to `Container(Entity)`; now defines which game entites can be stored in the container
- Add `blacklisted_entities : set(GameEntity)` member to `Container(Entity)`; now restricts which game entites can be stored in the container
- Add `types : set(TechType)` member to `Tech(Entity)`
- Add `ordering_priority: int` member to `Subformation(Entity)`; replaces `PreceedingSubformation` logic
- Add `transform_pool : optional(TransformPool)` member to `StateChanger(Entity)`
- Add `search_range : float` member to `GameEntityStance(Entity)`
- Add `fee_multiplier : float` member to `ExchangeMode(Entity)`

### Modifier module
- Add `ModifierProperty(Entity)` object; replaces inherited `Modifier` specializations
- Add `Multiplier(ModifierProperty)` object
- Add `Scoped(ModifierProperty)` object
- Add `Stacked(ModifierProperty)` object; allows defining how often a modifier is applied
- Add `properties : dict(ModifierProperty, ModifierProperty)` member to `Modifier`
- Add `condition : set(LogicElement)` member to `RefundOnCondition(Modifier)`

### Effect module
- Add `EffectProperty(Entity)` object; replaces inherited `Effect` specializations
- Add `AreaEffect(EffectProperty)` object
- Add `Cost(EffectProperty)` object
- Add `Diplomatic(EffectProperty)` object
- Add `Priority(EffectProperty)` object
- Add `properties : dict(EffectProperty, EffectProperty)` member to `Effect`

### Resistance module
- Add `ResistanceProperty(Entity)` object; replaces inherited `Resistance` specializations
- Add `Cost(ResistanceProperty)` object
- Add `Stacked(ResistanceProperty)` object; allows adjustment to effect calculation when multiple effectors are present
- Add `properties : dict(ResistanceProperty, ResistanceProperty)` member to `Resistance`

## Changed
### Ability module
- Change type of `despawn_condition` member in `Despawn` from `set(DespawnCondition)` to `set(LogicElement)`
- Change type of `state_change` member in `Despawn` from `StateChanger` to `optional(StateChanger)`
- Change type of `exchange_modes` member in `ExchangeResources` from `ExchangeMode` to `set(ExchangeMode)`
- Change type of `death_conditions` member in `PassiveTransformTo` from `set(DeathCondition)` to `set(LogicElement)`
- Change type of `target` member in `Restock` from `RestockableResourceSpot` to `ResourceSpot`
- Change type of `empty_threshold` member in `Storage` from `AttributeAmount` to `set(LogicElement)`

### Auxiliary module
- Change type of `condition` member in `ResearchableTech` from `set(AvailabilityRequirement)` to `set(LogicElement)`
- Change type of `condition` member in `CreatableGameEntity` from `set(AvailabilityRequirement)` to `set(LogicElement)`
- Change type of `creation_sounds` member in `CreatableGameEntity` from `Sound` to `set(Sound)`
- Change type of `research_sounds` member in `ResearchableTech` from `Sound` to `set(Sound)`
- Change type of `overrides` member in `Animated(ProgressProperty)` from `AnimationOverride` to `set(AnimationOverride)`
- Change type of `placement_modes` member in `CreatableGameEntity` from `PlacementMode` to `set(PlacementMode)`
- Change type of `object` member in `TerrainAmbient` from `Ambient` to `GameEntity`
- Change type of `conflicts` member in `StorageElementDefinition` from `set(StorageElement)` to `set(StorageElementDefinition)`
- Change parent of `Literal` from `Entity` to `LogicElement`
- Change parent of `ProjectilePassThrough` from `DeathCondition` to `Literal`
- Change parent of `ProjectileHitTerrain` from `DeathCondition` to `Literal`
- Change parent of `ResourceDepleted` from `DespawnCondition` to `Literal`
- Change parent of `Timer` from `DespawnCondition` to `Literal`

### Modifier module
- Change parent of `CreationTime` from `MultiplierModifier` to `Modifier`
- Change parent of `AttributeSettingsValue` from `MultiplierModifier` to `Modifier`
- Change parent of `MoveSpeed` from `MultiplierModifier` to `Modifier`
- Change parent of `ReloadTime` from `MultiplierModifier` to `Modifier`
- Change parent of `GatheringEfficiency` from `MultiplierModifier` to `Modifier`
- Change parent of `GatheringRate` from `MultiplierModifier` to `Modifier`
- Change parent of `StorageElementCapacity` from `MultiplierModifier` to `Modifier`
- Change parent of `ContainerCapacity` from `MultiplierModifier` to `Modifier`
- Change parent of `CreationResourceCost` from `MultiplierModifier` to `Modifier`
- Change parent of `CreationAttributeCost` from `MultiplierModifier` to `Modifier`
- Change parent of `ResearchTime` from `MultiplierModifier` to `Modifier`
- Change parent of `ResearchResourceCost` from `MultiplierModifier` to `Modifier`
- Change parent of `ResearchAttributeCost` from `MultiplierModifier` to `Modifier`
- Change parent of `Unconditional` from `FlatAttributeChangeModifier(EffectMultiplierModifier)` to `Modifier`
- Change parent of `ElevationDifferenceHigh` from `FlatAttributeChangeModifier(EffectMultiplierModifier)` to `Modifier`
- Change parent of `ElevationDifferenceLow` from `FlatAttributeChangeModifier(EffectMultiplierModifier)` to `Modifier`
- Change parent of `Flyover` from `FlatAttributeChangeModifier(EffectMultiplierModifier)` to `Modifier`
- Change parent of `Terrain` from `FlatAttributeChangeModifier(EffectMultiplierModifier)` to `Modifier`
- Change parent of `TimeRelativeProgressChange` from `EffectMultiplierModifier` to `Modifier`
- Change parent of `TimeRelativeAttributeChange` from `EffectMultiplierModifier` to `Modifier`
- Change parent of `Unconditional` from `FlatAttributeChangeModifier(ResistanceMultiplierModifier)` to `Modifier`
- Change parent of `ElevationDifferenceHigh` from `FlatAttributeChangeModifier(ResistanceMultiplierModifier)` to `Modifier`
- Change parent of `ElevationDifferenceLow` from `FlatAttributeChangeModifier(ResistanceMultiplierModifier)` to `Modifier`
- Change parent of `Stray` from `FlatAttributeChangeModifier(ResistanceMultiplierModifier)` to `Modifier`
- Change parent of `Terrain` from `FlatAttributeChangeModifier(ResistanceMultiplierModifier)` to `Modifier`
- Change parent of `AoE2ProjectileModifier` from `RelativeProjectileAmountModifier` to `Modifier`
- Change type of `storage_element` member in `StorageElementCapacity` from `StorageElement` to `StorageElementDefinition`
- Change type of `elevation_difference` member in `ElevationDifferenceHigh` from `float` to `optional(float)`
- Change type of `elevation_difference` member in `ElevationDifferenceLow` from `float` to `optional(float)`
- Change type of `condition` member in `InstantTechResearch` from `set(AvailabilityRequirement)` to `set(LogicElement)`

### Resistance module
- Change type of `resist_condition` member in `MakeHarvestable` from `set(HavestableRequirement)` to `set(LogicElement)`

## Removed
### Ability module
- Remove `AnimatedAbility` object; now handled by `Animated(AbilityProperty)`
- Remove `AnimationOverrideAbility` object; now handled by `AnimationOverride(AbilityProperty)`
- Remove `CommandSoundAbility` object; now handled by `CommandSound(AbilityProperty)`
- Remove `DiplomaticAbility` object; now handled by `Diplomatic(AbilityProperty)`
- Remove `ExecutionSound` object; now handled by `ExecutionSound(AbilityProperty)`
- Remove `TileRequirement` object; now handled by `Hitbox`
- Remove `Gate` object; now handled by `Passable`
- Remove `Deletable` object; now handled by `ActiveTransformTo`
- Remove `Transform` object
- Remove `effects` member from `ApplyDiscreteEffect`; superceded by `batches` member
- Remove `terrain_requirement` member from `TerrainRequirement`; superceded by `allowed_types` and `blacklisted_terrains` members
- Remove `radius_x` member from `Hitbox`; moved to referenced object
- Remove `radius_y` member from `Hitbox`; moved to referenced object
- Remove `radius_z` member from `Hitbox`; moved to referenced object
- Remove `indicator` member from `Ambient`; will use animation from `AnimatedAbility` from now on
- Remove `flatten_ground` member from `Foundation`
- Remove `carry_capacity` member from `Gather`; moved to `ResourceStorage(Entity)`
- Remove `carry_progress` member from `Gather`; moved to `ResourceStorage(Entity)`
- Remove `source_resources` member from `ExchangeResources`
- Remove `target_resources` member from `ExchangeResources`
- Remove `source_fee` member from `ExchangeResources`
- Remove `target_fee` member from `ExchangeResources`

### Auxiliary module
- Remove `DiplomaticPatch` object; now handled by `Diplomatic(PatchProperty)`
- Remove `AnimationOverrideProgress` object; now handled by `AnimationOverride(ProgressProperty)`
- Remove `AnimatedProgress` object; now handled by `Animated(ProgressProperty)`
- Remove `TerrainProgress` object; now handled by `Terrain(ProgressProperty)`
- Remove `TerrainOverlayProgress` object; now handled by `TerrainOverlay(ProgressProperty)`
- Remove `StateChangeProgress` object; now handled by `StateChange(ProgressProperty)`
- Remove `AvailabilityRequirement` object
- Remove `RestockableResourceSpot` object; restockable now possible for every resource spot
- Remove `DeathCondition` object; functionality merged with `LogicElement` and `Literal`
- Remove `DespawnCondition` object; functionality merged with `LogicElement` and `Literal`
- Remove `MultiPartBuilding` object; now fully replaced by generic `GameEntity`
- Remove `BuildingPart` object; now fully replaced by generic `GameEntity`
- Remove `Ambient` object; now fully replaced by generic `GameEntity`
- Remove `Building` object; now fully replaced by generic `GameEntity`
- Remove `Item` object; now fully replaced by generic `GameEntity`
- Remove `Projectile` object; now fully replaced by generic `GameEntity`
- Remove `Unit` object; now fully replaced by generic `GameEntity`
- Remove `AttributeInterval(Literal)` object; fully replaced by lower cealing `AttributeBelowValue` and higher cealing `AttributeAboveValue` literals
- Remove `ExchangeMode` object
- Remove `Fixed(ExchangeMode)` object
- Remove `Volatile(ExchangeMode)` object
- Remove `VolatileFlat(Volatile)` object
- Remove `PrecedingSubformation` object; replaced by `ordering_priority` member in `Subformation`
- Remove `allowed_types` member from `Terrain`; now handled by `TerrainRequirement` ability
- Remove `blacklisted_game_entities` member from `Terrain`; now handled by `TerrainRequirement` ability
- Remove `harvest_progress` member from `ResourceSpot`; now handled by `Harvestable` ability
- Remove `gatherer_limit` member from `ResourceSpot`; now handled by `Harvestable` ability
- Remove `harvestable_by_default` member from `ResourceSpot`; now handled by `Harvestable` ability
- Remove `progress: int` member from `Progress(Entity)`; progress is now defined by bounded interval with members `left_boundary : float`, `right_boundary : float`
- Remove `mode: bool` member from `Literal(LogicElement)`; negation now only supported by `NOT(LogicGate)`

### Modifier module
- Remove `EffectMultiplierModifier(MultiplierModifier)` object; specialization now implicit
- Remove `FlatAttributeChangeModifier(EffectMultiplierModifier)` object; specialization now implicit
- Remove `ResistanceMultiplierModifier(MultiplierModifier)` object; specialization now implicit
- Remove `FlatAttributeChangeModifier(EffectMultiplierModifier)` object; specialization now implicit
- Remove `MultiplierModifier` object; now handled by `Multiplier(ModifierProperty)`
- Remove `ScopedModifier` object; now handled by `Scoped(ModifierProperty)`
- Remove `StackedModifier` object; now handled by `Stacked(ModifierProperty)`
- Remove `RelativeProjectileAmountModifier` object
- Remove `AlwaysHerd` object; functionality now in `Herd` via `strength` member

### Effect module
- Remove `AreaEffect` object; now handled by `AreaEffect(EffectProperty)`
- Remove `Cost` object; now handled by `Cost(EffectProperty)`
- Remove `Diplomatic` object; now handled by `Diplomatic(EffectProperty)`

### Resistance module
- Remove `CostResistance` object; now handled by `Cost(ResistanceProperty)`
- Remove `StackedResistance` object; now handled by `Stacked(ResistanceProperty)`

## Reference visualization

* [Gamedata](https://github.com/SFTtech/openage/blob/b947ad39f10f54ebef8c7e7f732cea9c942f0521/doc/nyan/aoe2_nyan_tree.svg)
