# [0.4.1] - 2020-08-15
All notable changes for version [v0.4.1] are documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html) since release [v0.4.0].

## Added
- Release process documentation
- Changelogs for engine and modding API
- Support for AoE1:DE graphic assets formats and documentation
    - SLP v3.0
    - SLP v4.0
    - SLP v4.1
    - SLP v4.2 (only docs)
- New option in singlefile converter to convert loose SLP files
- CI builds for macOS
- Hints for macOS builds in `README.md`
- Favicon for webpages
- Increase verbosity of `openage --version` by adding version numbers of:
    - Eigen
    - Harfbuzz
    - libc
    - SDL
    - Qt
    - nyan
    - CI config
    - Python
    - Python C API
    - Cython
    - Jinja2
    - Numpy
    - Pillow
    - Pygments
- SMP file support and documentation
- SMX file support and documentation
- Add several SLP details about SWGB and 32-Bit SLPs from HD Edition
- More feature ideas in docs
- Add `make all` target
- Make `ConcurrentQueue` support both copy-constructible and move-constructible elements

## Changed
- GUI improvements
    - Move unit info to QML output
    - Clean player name and ability info
    - Set debug overlay to invisible by default
    - Update FPS counter at a slower rate for better readability
- Update macOS build instructions
- Minimize state changes in renderer
- Use GIthub workflow for macOS builds
- Use shared pointers for renderer resources
- Do not define `std::hash<QString>` for qt >= 5.14
- Buildsystem updated to use `FindPython3.cmake`
- Change the copyright year of `copying.md` to 2020
- Update windows MSVC build docs with info from latest attempts
- Bump CMake version to 3.16
- Improve buildsystem Python search

# Removed
- Remove outdated simple build script

## Fixed
- Fix `math` environment usage in modding API reference guide
- Fix typos and commands in AoE2 network protocol docs
- Fix packaging with prebuilt Qt
- Fix devastating `README.md` typos (#1163)
- Fix things found by clang-tidy
- Fix reading previous asst location
- `enum.h`: Add missing self-reference in assignment operator
- Request OpenGL explicitely on macOS instead of OpenGLES
- Fix crash because of missing null-initialization of pointer
- Correctly display SLP version string
- Fix incorrect next `cmd_byte` value in SLP lesser draw example
- Fix Clang-10 warnings in configure script
- Fix build errors on MingW and gcc10
- Fix instructions for running the engine after build


## Full commit log

https://github.com/SFTtech/openage/compare/v0.4.0...v0.4.1
