# [0.2.0] - 2019-06-29
All notable changes for version [v0.2.0] are documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## Added
### Ability module
- Add `CommandSoundAbility(Ability)` object; plays a sound when the ability is intiated by the player
- Add `ExecutionSoundAbility(Ability)` object; plays a sound while the ability is executed by the game entity
- Add `AnimationOverrideAbility(Ability)` object; overrides other abilities' animation with `AnimationOverride` objects
- Add `source_fee : float` member to `ExchangeResources`; multiplier for `source_resources` member
- Add `target_fee : float` member to `ExchangeResources`; multiplier for `target_resources` member
- Add `exchange_mode : ExchangeMode` member to `ExchangeResources`; multiplier for `target_resources` member
- Add `search_range : float` member to `DropResources`; used for limiting the search range for finding a drop site
- Add `allowed_types : set(GameEntityType)` member to `DropResources`; used to define the game entity types where the resources can be dropped off
- Add `blacklisted_game_entities : set(GameEntity)` member to `DropResources`; exceptions for allowed game entity types
- Add `carry_progress : set(CarryProgress)` member to `Gather`; used for carry amount progression
- Add `interrupt_cooldown : float` member to `Cloak`
- Add `allowed_types : set(GameEntityType)` member to `EnterContainer`
- Add `blacklisted_game_entities : set(GameEntity)` member to `EnterContainer`
- Add `allowed_types : set(GameEntityType)` member to `SendBackToTask`
- Add `blacklisted_game_entities : set(GameEntity)` member to `SendBackToTask`
- Add `spawning_area_offset_x : float` member to `ShootProjectile`; used for location of spawn area
- Add `spawning_area_offset_y : float` member to `ShootProjectile`; used for location of spawn area
- Add `spawning_area_offset_z : float` member to `ShootProjectile`; used for location of spawn area
- Add `starting_progress : int` member to `Constructable`; used for defining the construction progress when game entity is spawned
- Add `attribute : Attribute` member to `Damageable`; specifies the attribute whos progression is tracked
- Add `despawn_condition : set(DespawnCondition)` member to `Despawn`; used for triggering despawns
- Add `despawn_time : float` member to `Despawn`; used for duration of ability
- Add `state_change : StateChanger` member to `Despawn`; used for state change during despawning
- Add `death_time : float` member to `Die`; time until completion of ability
- Add `state_change : StateChanger` member to `Die`; used for state change during death

### Auxilary module
- Add `AdjacentTilesVariant(Variant)` object; variant based on adjacent game entities
- Add `LureType(Entity)` object; used by `Lure` effect/resistance for matching
- Add `ProgressType(Entity)` object; used by `TimeRelativeProgress` effect/resistance for matching
- Add `Contruct(ProgressType)` object; used for construction progress
- Add `SendToContainerType(Entity)` object; used by `SendToContainer` effect/resistance for matching
- Add `InverseLinar(DropoffType)` object; used for calculations influenced by dropoffs
- Add `Cost(Entity)` object; unifies previous approaches of referencing `ResourceAmount` or `AttributeAmount`
- Add `ResourceCost(Cost)` object; for payments with resources
- Add `AttributeCost(Cost)` object; for payments with attribute points
- Add `PaymentMode(Entity)` object; used by `Cost` object to determine payment due date
- Add `Advance(PaymentMode)` object
- Add `Adaptive(PaymentMode)` object
- Add `Arrear(PaymentMode)` object
- Add `StateChanger(Entity)` object; can influence the state of a game entity
- Add `TechResearched(AvailabilityPrerequisite)` object; is true if the referenced tech is researched by the player
- Add `GameEntityProgress(AvailabilityPrerequisite)` object; is true if the player owns a game entity that has reached this progress
- Add `ProgressStatus(Entity)` object; used by `GameEntityProgress` to define desired status for fulfillment
- Add `TerrainOverlay(Progress)` object; overlays `Terrain` stored in `OverlayTerrain` ability after a certain progress is reached
- Add `StateChangeProgress(Progress)` object; changes state of a game entity after a certain progress is reached
- Add `Normal(MoveMode)` object
- Add `ExchangeMode(Entity)` object; used by `ExchangeResources` ability to customize exchanges further
- Add `Fixed(ExchangeMode)` object; used for default resource exchanges
- Add `Volatile(ExchangeMode)` object; used for adjusting resource amounts after transactions
- Add `VolatileFlat(Volatile)` object; mimics AoE2 market behaviour
- Add `ExchangeScope(Entity)` object; used for global or local resource exchanges involving multiple players
- Add `AoE1TradeRoute(TradeRoute)` object; used for AoE1 trading machanics
- Add `AttributeSetting(Entity)` object; used for setting attribute values of game entities
- Add `DespawnCondition(Entity)` object; used for triggering despawn abilities
- Add `ResourceSpotsDepleted(DespawnCondition)` object; used for triggering despawn abilities when resource spots are empty
- Add `Timer(DespawnCondition)` object; used for triggering despawn abilities after a time limit
- Add `ProjectilePassThrough(DeathCondition)` object; used for triggering death for projectiles
- Add `ProjectileHitTerrain(DeathCondition)` object; used for triggering death for projectiles
- Add `priority : int` member to `Variant`; decides which variant is applied first
- Add `limit : int` member to `TerrainAmbiant`; limits the number of ambient objects created on a chunk of terrain
- Add `starting_amount : int` member to `ResourceSpot`; sets the starting amount of a resource spot
- Add `sound : Sound` member to `Cheat`; played on activation
- Add `ability_preference : orderedset(Ability)` member to `GameEntityStance`; indicates which abilities can be used when a game entity has a certain stance
- Add `type_preference : orderedset(GameEntityType)` member to `GameEntityStance`; indicates which game entity types are targeted with the abilities
- Add `range : float` member to `Follow(MoveMode)`; sets the range at which the game entity follows the target
- Add `creation_sound : Sound` member to `CreatableGameEntity`; plays when game entity is spawned
- Add `research_sound : Sound` member to `ResearchableTech`; plays when tech finishes researching
- Add `trade_resource : Resource` member to `TradeRoute`; defines the traded resource
- Add `start_trade_post : GameEntity` member to `TradeRoute`; defines the type of game entity that has to be the start of the trade route
- Add `end_trade_post : GameEntity` member to `TradeRoute`; defines the type of game entity that has to be the end of the trade route
- Add `carry_progress : set(CarryProgress)` member to `Container`; used for carry progression of container
- Add `state_change : StateChanger` member to `StorageElement`; changes state of a game entity if storage element is in container
- Add `dispersion_dropoff : DropoffType` member to `Accuracy`; dynamic multiplier for accuracy dispersion

### Effect module
- Add `TimeRelativeAttributeChange(ContinuousEffect)` object; changes attribute points in a fixed amount of time
- Add `TimeRelativeAttributeDecrease(TimeRelativeAttributeChange)` object; decreases attribute points in a fixed amount of time
- Add `TimeRelativeAttributeIncrease(TimeRelativeAttributeChange)` object; increases attribute points in a fixed amount of time
- Add `TimeRelativeProgress(ContinuousEffect)` object; changes progress in a fixed amount of time
- Add `TimeRelativeProgressDecrease(TimeRelativeProgress)` object; decreases progress in a fixed amount of time
- Add `TimeRelativeProgressIncrease(TimeRelativeProgress)` object; decreases progress in a fixed amount of time
- Add `type : LureType` member to `Lure`; used for matching with the corresponding resistance object
- Add `min_chance_success : optional(float)` member to `Convert`; defines minimum guaranteed chance for conversion to succeed
- Add `max_chance_success : optional(float)` member to `Convert`; defines maximum guaranteed chance for conversion to succeed
- Add `type : SendToContainerType` member to `SendToContainerType`; used for matching with the corresponding resistance object

### Modifier module
- Add `CreationAttributeCost` object; multiplier for creation attribute costs
- Add `CreationResourceCost` object; multiplier for creation resource costs
- Add `ResearchAttributeCost` object; multiplier for research attribute costs
- Add `ResearchResourceCost` object; multiplier for research resource costs
- Add `TimeRelativeProgress(EffectMultiplierModifier)` object; multiplier for effects
- Add `TimeRelativeAttributeChange(EffectMultiplierModifier)` object; multiplier for effects
- Add `Terrain(FlatAttributeChangeModifier)` object; multiplier for effects
- Add `ElevationDifferenceHigh(FlatAttributeChangeModifier)` object; multiplier for effects
- Add `Unconditional(FlatAttributeChangeModifier)` object; multiplier for effects
- Add `Terrain(FlatAttributeChangeModifier)` object; multiplier for resistances
- Add `ElevationDifferenceLow(FlatAttributeChangeModifier)` object; multiplier for resistances
- Add `Unconditional(FlatAttributeChangeModifier)` object; multiplier for resistances
- Add `DepositResourcesOnProgress(Modifier)` object; used for dropping off resources after building buildings
- Add `InContainerDiscreteEffect(Modifier)` object; used for applying effects to the game entity when in a container
- Add `InContainerContinuousEffect(Modifier)` object; used for applying effects to the game entity when in a container
- Add `RefundOnDeath(Modifier)` object; used for giving back resources on death
- Add `DiplomaticLineOfSight(Modifier)` object; used for diplomacy viewpoints
- Add `creatables : set(CreatableGameEntity)` member to `CreationTime`; used for limiting the bonus to specified creatables

### Resistance module
- Add `TimeRelativeAttributeChange(ContinuousResistance)` object; changes attribute points in a fixed amount of time
- Add `TimeRelativeAttributeDecrease(TimeRelativeAttributeChange)` object
- Add `TimeRelativeAttributeIncrease(TimeRelativeAttributeChange)` object
- Add `TimeRelativeProgress(ContinuousResistance)` object
- Add `TimeRelativeProgressDecrease(TimeRelativeProgress)` objectrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr
- Add `TimeRelativeProgressIncrease(TimeRelativeProgress)` object
- Add `type : LureType` member to `Lure`; used for matching with the corresponding effect object
- Add `type : SendToContainerType` member to `SendToContainer`; used for matching with the corresponding effect object
- Add `ignore_containers : set(Container)` member to `SendToContainer`; lets resistor ignore defined set of containers
- Add `resource_spot : resourceSpot` member to `MakeHarvestable`; used for matching with the corresponding effect object

## Changed
### Ability module
- Change type of `states` member in `Transform` from `set(TransformState)` to `set(StateChanger)`
- Change type of `initial_state` member in `Transform` from `TransformState` to `StateChanger`
- Change type of `target_state` member in `TransformTo` from `TransformState` to `StateChanger`
- Change type of `manual_cost` member in `Restock` from `set(ResourceAmount)` to `Cost`
- Change type of `auto_cost` member in `Restock` from `set(ResourceAmount)` to `Cost`
- Change type of `attributes` member in `Live` from `set(Attribute)` to `set(AttributeSetting)`
- Move `target_mode` member from `ShootProjectile` to `Projectile`
- Rename `UnitStance` object to `GameEntityStance`
- Rename `TradeResources` object to `ExchangeResources`
- Rename `RegenerateResource` object to `RegenerateResourceSpot`
- Rename `Stealth` object to `Cloak`
- Rename `Decay` object to `Despawn`
- Rename `mode` member of `Move` to `modes`
- Rename `flag` member of `RallyPoint` to `indicator`
- Rename `units` member of `Create` to `creatables`
- Rename `techs` member of `Research` to `researchables`
- Rename `sell_resources` member of `ExchangeResources` to `source_resources`
- Rename `receive_resources` member of `ExchangeResources` to `target_resources`
- Rename `ingame_help` member of `Named` to `long_description`
- Rename `tile_width` member of `TileRequirement` to `tiles_x`
- Rename `tile_height` member of `TileRequirement` to `tiles_y`
- Rename `flatten_terrain` member of `Foundation` to `flatten_ground`
- Rename `terrain` member of `OverlayTerrain` to `terrain_overlay`
- Rename `condition` member of `Die` to `death_conditions`

### Auxilary module
- Change type of `modifiers` member in `Civilization` from `Modifier` to `ScopedModifier`
- Change type of `progress_sprite` member in `AnimationProgress` from `Animation` to `AnimationOverride`
- Change type of `cost` member in `CreatableGameEntity` from `set(ResourceAmount)` to `Cost`
- Change type of `cost` member in `ResearchableTech` from `set(ResourceAmount)` to `Cost`
- Change type of `conflicts` member in `StorageElement` from `set(GameEntity)` to `set(StorageElement)`
- Rename `ChanceType` object to `ConvertType`
- Rename `Default` object to `Fallback`
- Rename `Prerequiste` object to `AvailabilityPrerequisite`
- Rename `AnimatedProgress` object to `AnimationProgress`
- Rename `UnitStance` object to `GameEntityStance`
- Rename `UnitFormation` object to `GameEntityFormation`
- Rename `AttributeDeathCondition` object to `AttributeInterval`
- Rename `Self(ModifierScope)` object to `Standard`
- Rename `chance` member of `RandomVariant` to `chance_share`
- Rename `tech_tree_help` member of `Civilization` to `long_description`
- Rename `ingame_help` member of `Tech` to `long_description`
- Rename `ambient` member of `Terrain` to `ambience` and change its type from `orderedset(TerrainAmbient)` to `set(TerrainAmbient)`
- Rename `max_density` member of `TerrainAmbient` to `density`
- Rename `type` member of `ResourceSpot` to `resource`
- Rename `impact` member of `Cheat` to `changes`
- Rename `negation` member of `AvailabilityPrerequisite` to `mode`

### Effect module
- Change type of `cost` member in `CostEffect` from `set(AttributeAmount)` to `Cost`
- Rename `ChanceEffect` object to `Convert` and change the type of its `type` member from `ChanceType` to `ConvertType`
- Rename `SendToStorage` object to `SendToContainer` and change its parent from `ContinuousEffect` to `DiscreteEffect`
- Rename `min_range_to_destination` member of `Lure` to `min_distance_to_destination`
- Rename `AoE2Conversion` object to `AoE2Convert`

### Modifier module
- Change type of `provider_abilities` member in `AoE2ProjectileAmount` from `ApplyDiscreteEffect` to `set(ApplyDiscreteEffect)`
- Change type of `receiver_abilities` member in `AoE2ProjectileAmount` from `ApplyDiscreteEffect` to `set(ApplyDiscreteEffect)`
- Rename `PercentageModifier` object to `MultiplierModifier`
- Rename `AttributeModifier` object to `AttributeSettingsValue`
- Rename `MoveSpeedModifier` object to `MoveSpeed`
- Rename `ReloadTimeModifier` object to `ReloadTime`
- Rename `GatheringEfficiencyModifier` object to `GatheringEfficiency`
- Rename `GatheringRateModifier` object to `GatheringRate`
- Rename `StorageElementModifier` object to `StorageElementCapacity`
- Rename `ContainerCapacityModifier` object to `ContainerCapacity`
- Rename `CreationTimeModifier` object to `CreationTime`
- Rename `EffectPercentageModifier` object to `EffectMultiplierModifier`
- Rename `ResistancePercentageModifier` object to `ResistanceMultiplierModifier`
- Rename `FlyoverModifier` object to `Flyover`
- Rename `StrayModifier` object to `Stray`
- Rename `RevealModifier` object to `Reveal`
- Rename `AlwaysHerdModifier` object to `AlwaysHerd`
- Rename `TechUnlockModifier` object to `InstantTechResearch`
- Rename `AbsoluteProjectileAmountModifier` object to `AbsoluteProjectileAmount`
- Rename `AoE2ProjectileAmountModifier` object to `AoE2ProjectileAmount`
- Rename `ContinuousResourceModifier` object to `ContinuousResource` and set `Modifier` as only direct parent
- Rename `rate` member of `ContinuousResource` to `rates`
- Rename `provider_ability` member of `AoE2ProjectileAmount` to `provider_abilities`
- Rename `receiver_ability` member of `AoE2ProjectileAmount` to `receiver_abilities`

### Resistance module
- Change type of `cost` member in `CostResistance` from `set(AttributeAmount)` to `Cost`
- Change type of `resist_condition` member in `MakeHarvestable` from `set(AvailabilityRequirement)` to `set(HarvestableRequirement)`
- Rename `FlatResistance(ContinuousResistance)` object to `FlatAttributeChange`
- Rename `FlatAttributeDecreaseResistance(FlatAttributeChange)` (continuous branch) object to `FlatAttributeDecrease`
- Rename `FlatAttributeIncreaseResistance(FlatAttributeChange)` (continuous branch) object to `FlatAttributeIncrease`
- Rename `FlatAttributeResistance(DiscreteResistance)` object to `FlatAttributeChange`
- Rename `FlatAttributeDecreaseResistance(FlatAttributeChange)` (discrete branch) object to `FlatAttributeDecrease`
- Rename `FlatAttributeIncreaseResistance(FlatAttributeChange)` (discrete branch) object to `FlatAttributeIncrease`
- Rename `LureResistance(ContinuousResistance)` object to `Lure`
- Rename `SendToStorageResistance(ContinuousResistance)` object to `SendToContainer` and change its parent from `ContinuousResistance` to `DiscreteResistance`
- Rename `HarvestableResistance(Discreteresistance)` object to `MakeHarvestable`
- Rename `ChanceResistance(Discreteresistance)` object to `Convert` and change the type of its `type` member from `ChanceType` to `ConvertType`
- Rename `AoE2ConversionResistance(Convert)` object to `AoE2Convert`
- Rename `protection_recharge_time` member of `AoE2Convert` to `protection_round_recharge_time`

## Removed
### Ability module
- Remove `SoundAbility(Ability)` object; functionality split into `ExecutionSoundAbility` and `CommandSoundAbility`
- Remove `Construct(Ability)` object; is now an effect
- Remove `TransferResourceWithModifier(Ability)` object; merged into `ExchangeResources`
- Remove `AttackGround(ShootProjectile)` object
- Remove `accept_on_construction` member from `DropSite`; now handled by a modifier
- Remove `die_on_hit` member from `Projectile`; now handled as death condition
- Remove `pass_through_range` member from `Projectile`; now handled as death condition
- Remove `progress` member from `OverlayTerrain`; any progress can now change terrain overlays

### Auxilary module
- Remove `DiplomaticSetup(Entity)` object; functionality replaced by `DiplomaticPatch`
- Remove `Exponential(DropoffType)` object; might be reintroduced in a later release
- Remove `AnimatedTerrain(Terrain)` object; now handled by .terrain definition file and renderer
- Remove `TechPrerequiste(Prerequisite)` object; functionality replaced by `TechResearched`
- Remove `BuildingPrerequiste(Prerequisite)` object; functionality replaced by `GameEntityProgress`
- Remove `TransformState(Entity)` object; functionality replaced by `StateChanger`
- Remove `Guard(MoveMode)` object; functionality integrated into `Follow`
- Remove `Constructable(Entity)` object
- Remove `NearestTradeRoute(Entity)` object
- Remove `graphic_set` member from `Civilization`; now handled by `civ_setup` member
- Remove `diplo_setup` member from `Civilization`; now handled by `civ_setup` member
- Remove `modifiers` member from `Cheat`
- Remove `enable_abilities` member from `Progress`; now handled by `StateChangeProgress` specialization
- Remove `disable_abilities` member from `Progress`; now handled by `StateChangeProgress` specialization
- Remove `enable_modifiers` member from `Progress`; now handled by `StateChangeProgress` specialization
- Remove `disable_modifiers` member from `Progress`; now handled by `StateChangeProgress` specialization
- Remove `attribute` member from `DamageProgress`; member was obselete
- Remove `min_value` member from `Attribute`; now stored in `AttributeSetting`
- Remove `max_value` member from `Attribute`; now stored in `AttributeSetting`
- Remove `enable_abilities` member from `StorageElement`; now handled by `state_change` member
- Remove `disable_abilities` member from `StorageElement`; now handled by `state_change` member
- Remove `enable_modifiers` member from `StorageElement`; now handled by `state_change` member
- Remove `disable_modifiers` member from `StorageElement`; now handled by `state_change` member

### Modifier module
- Remove `DiscreteModifier(Modifier)` object; might be introduced back later
- Remove `DiscreteResourceModifier(DiscreteModifier)` object; might be introduced back later
- Remove `CreationCostModifier(MultiplierModifier)` object; split into `CreationAttributeCost` and `CreationResourceCost`
- Remove `ResearchCostModifier(MultiplierModifier)` object; split into `ResearchAttributeCost` and `ResearchResourceCost`
- Remove `ConstructionTimeModifier(MultiplierModifier)` object; moved to effect bonus
- Remove `ElevationModifier(FlatAttributeChangeModifier)` object; replaced by `ElevationDifferenceHigh` modifier
- Remove `ContinuousModifier(Modifier)` object; might be introduced back later

## Reference visualization

* [Gamedata](https://github.com/SFTtech/openage/blob/45b8992dc836d239c9f22cae8404a8b2cc16c8ef/doc/nyan/aoe2_nyan_tree.svg)
