/*
 * libnl_link: Handle dynamic linking to netlink libraries 
 *
 * Authors:	P. Quentin Armitage <Quentin@Armitage.org.uk>
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *
 * Copyright (C) 2017-2017 Alexandre Cassen, <acassen@gmail.com>
 */

#ifndef _LIBNL_LINK_H
#define _LIBNL_LINK_H

#include "config.h"

#include <stdbool.h>

#include <netlink/socket.h>
#include <netlink/netlink.h>
#ifdef LIBIPVS_USE_NL
#include <netlink/genl/genl.h>
#include <netlink/genl/ctrl.h>
#endif
#if defined _WITH_VRRP_ && defined _HAVE_LIBNL3_ && defined _HAVE_IPV4_DEVCONF_
#include <netlink/route/link.h>
#include <netlink/route/link/inet.h>
#endif

/* The addresses of the functions we want */
extern struct nl_sock * (*nl_socket_alloc_addr)(void);
extern void (*nl_socket_free_addr)(struct nl_sock *);
#ifdef LIBIPVS_USE_NL
extern int (*genl_connect_addr)(struct nl_sock *);
extern int (*genl_ctrl_resolve_addr)(struct nl_sock *, const char *);
extern int (*genlmsg_parse_addr)(struct nlmsghdr *, int, struct nlattr **, int, struct nla_policy *);
extern void * (*genlmsg_put_addr)(struct nl_msg *, uint32_t, uint32_t, int, int, int, uint8_t, uint8_t);
extern int (*nla_nest_end_addr)(struct nl_msg *, struct nlattr *);
extern struct nlattr * (*nla_nest_start_addr)(struct nl_msg *, int);
extern int (*nla_put_daddr)(struct nl_msg *, int, int, const void *);
extern struct nl_msg * (*nlmsg_alloc_addr)(void);
extern void (*nlmsg_free_addr)(struct nl_msg *);
extern struct nlmsghdr * (*nlmsg_hdr_addr)(struct nl_msg *);
extern int (*nl_recvmsgs_default_addr)(struct nl_sock *);
extern int (*nl_send_auto_complete_addr)(struct nl_sock *,  struct nl_msg *);
extern int (*nl_socket_modify_cb_addr)(struct nl_sock *, enum nl_cb_type, enum nl_cb_kind, nl_recvmsg_msg_cb_t, void *);
#endif
#ifdef _HAVE_LIBNL3_
#if defined _WITH_VRRP_ && defined _HAVE_IPV4_DEVCONF_
extern struct rtnl_link *(*rtnl_link_alloc_addr)(void);
extern int (*rtnl_link_alloc_cache_addr)(struct nl_sock *, int, struct nl_cache **);
extern int (*rtnl_link_change_addr)(struct nl_sock *, struct rtnl_link *, struct rtnl_link *, int);
extern struct rtnl_link *(*rtnl_link_get_addr_l)(struct nl_cache *, int);
extern int (*rtnl_link_inet_get_conf_addr)(struct rtnl_link *, const unsigned int, uint32_t *);
extern int (*rtnl_link_inet_set_conf_addr)(struct rtnl_link *, const unsigned int, uint32_t);
extern void (*rtnl_link_put_addr)(struct rtnl_link *);
#endif
extern int (*nl_connect_addr)(struct nl_sock *, int);
extern int (*nl_socket_add_membership_addr)(struct nl_sock *, int);
extern int (*nl_socket_get_fd_addr)(const struct nl_sock *);
extern uint32_t (*nl_socket_get_local_port_addr)(const struct nl_sock *);
extern int (*nl_socket_set_buffer_size_addr)(struct nl_sock *, int, int);
extern int (*nl_socket_set_nonblocking_addr)(const struct nl_sock *);
#endif

/* We can make it look as though normal linking is being used */
#define nl_socket_alloc (*nl_socket_alloc_addr)
#define nl_socket_free (*nl_socket_free_addr)
#ifdef LIBIPVS_USE_NL
#define genl_connect (*genl_connect_addr)
#define genl_ctrl_resolve (*genl_ctrl_resolve_addr)
#define genlmsg_parse (*genlmsg_parse_addr)
#define genlmsg_put (*genlmsg_put_addr)
#define nla_nest_end (*nla_nest_end_addr)
#define nla_nest_start (*nla_nest_start_addr)
#define nla_put (*nla_put_daddr)
#define nlmsg_alloc (*nlmsg_alloc_addr)
#define nlmsg_free (*nlmsg_free_addr)
#define nlmsg_hdr (*nlmsg_hdr_addr)
#define nl_recvmsgs_default (*nl_recvmsgs_default_addr)
#define nl_send_auto_complete (*nl_send_auto_complete_addr)
#define nl_socket_modify_cb (*nl_socket_modify_cb_addr)
#endif
#ifdef _HAVE_LIBNL3_
#if defined _WITH_VRRP_ && defined _HAVE_IPV4_DEVCONF_
#define rtnl_link_alloc (*rtnl_link_alloc_addr)
#define rtnl_link_alloc_cache (*rtnl_link_alloc_cache_addr)
#define rtnl_link_change (*rtnl_link_change_addr)
#define rtnl_link_get (*rtnl_link_get_addr_l)
#define rtnl_link_inet_get_conf (*rtnl_link_inet_get_conf_addr)
#define rtnl_link_inet_set_conf (*rtnl_link_inet_set_conf_addr)
#define rtnl_link_put (*rtnl_link_put_addr)
#endif
#define nl_connect (*nl_connect_addr)
#define nl_socket_add_membership (*nl_socket_add_membership_addr)
#define nl_socket_get_fd (*nl_socket_get_fd_addr)
#define nl_socket_get_local_port (*nl_socket_get_local_port_addr)
#define nl_socket_set_buffer_size (*nl_socket_set_buffer_size_addr)
#define nl_socket_set_nonblocking (*nl_socket_set_nonblocking_addr)
#endif

extern bool use_nl;

extern bool libnl_init(void);

#endif
