//
// UserAPI.swift
//
// Generated by swagger-codegen
// https://github.com/swagger-api/swagger-codegen
//

import Alamofire
import PromiseKit

extension PetstoreClientAPI {
    
    class UserAPI: APIBase {
    
        /**
         
         Create user
         
         - POST /user
         - This can only be done by the logged in user.
         
         :param: body (body) Created user object

         :returns: Promise<Response<Void>> 
         */
        func createUser(#body: User?) -> RequestBuilder<Void> {
            let path = "/user"
            let url = PetstoreClientAPI.basePath + path
            
            let parameters = body?.encodeToJSON() as? [String:AnyObject]

            let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "POST", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         Creates list of users with given input array
         
         - POST /user/createWithArray
         - 
         
         :param: body (body) List of user object

         :returns: Promise<Response<Void>> 
         */
        func createUsersWithArrayInput(#body: [User]?) -> RequestBuilder<Void> {
            let path = "/user/createWithArray"
            let url = PetstoreClientAPI.basePath + path
            
            let parameters = body?.encodeToJSON() as? [String:AnyObject]

            let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "POST", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         Creates list of users with given input array
         
         - POST /user/createWithList
         - 
         
         :param: body (body) List of user object

         :returns: Promise<Response<Void>> 
         */
        func createUsersWithListInput(#body: [User]?) -> RequestBuilder<Void> {
            let path = "/user/createWithList"
            let url = PetstoreClientAPI.basePath + path
            
            let parameters = body?.encodeToJSON() as? [String:AnyObject]

            let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "POST", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         Logs user into the system
         
         - GET /user/login
         - 
         - examples: [{example="aeiou", contentType=application/json}, {example=string, contentType=application/xml}]
         - examples: [{example="aeiou", contentType=application/json}, {example=string, contentType=application/xml}]
         
         :param: username (query) The user name for login
         :param: password (query) The password for login in clear text

         :returns: Promise<Response<String>> 
         */
        func loginUser(#username: String?, password: String?) -> RequestBuilder<String> {
            let path = "/user/login"
            let url = PetstoreClientAPI.basePath + path
            
            let nillableParameters: [String:AnyObject?] = [
                "username": username,
                "password": password
            ]
            let parameters = APIHelper.rejectNil(nillableParameters)

            let requestBuilder: RequestBuilder<String>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "GET", URLString: url, parameters: parameters, isBody: false)
        }
    
        /**
         
         Logs out current logged in user session
         
         - GET /user/logout
         - 

         :returns: Promise<Response<Void>> 
         */
        func logoutUser() -> RequestBuilder<Void> {
            let path = "/user/logout"
            let url = PetstoreClientAPI.basePath + path
            
            let nillableParameters: [String:AnyObject?] = [:]
            let parameters = APIHelper.rejectNil(nillableParameters)

            let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "GET", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         Get user by user name
         
         - GET /user/{username}
         - 
         - examples: [{example={
  "id" : 1,
  "username" : "johnp",
  "firstName" : "John",
  "lastName" : "Public",
  "email" : "johnp@swagger.io",
  "password" : "-secret-",
  "phone" : "0123456789",
  "userStatus" : 0
}, contentType=application/json}]
         
         :param: username (path) The name that needs to be fetched. Use user1 for testing. 

         :returns: Promise<Response<User>> 
         */
        func getUserByName(#username: String) -> RequestBuilder<User> {
            var path = "/user/{username}"
            path = path.stringByReplacingOccurrencesOfString("{username}", withString: "\(username)", options: .LiteralSearch, range: nil)
            let url = PetstoreClientAPI.basePath + path
            
            let nillableParameters: [String:AnyObject?] = [:]
            let parameters = APIHelper.rejectNil(nillableParameters)

            let requestBuilder: RequestBuilder<User>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "GET", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         Updated user
         
         - PUT /user/{username}
         - This can only be done by the logged in user.
         
         :param: username (path) name that need to be deleted
         :param: body (body) Updated user object

         :returns: Promise<Response<Void>> 
         */
        func updateUser(#username: String, body: User?) -> RequestBuilder<Void> {
            var path = "/user/{username}"
            path = path.stringByReplacingOccurrencesOfString("{username}", withString: "\(username)", options: .LiteralSearch, range: nil)
            let url = PetstoreClientAPI.basePath + path
            
            let parameters = body?.encodeToJSON() as? [String:AnyObject]

            let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "PUT", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         Delete user
         
         - DELETE /user/{username}
         - This can only be done by the logged in user.
         
         :param: username (path) The name that needs to be deleted

         :returns: Promise<Response<Void>> 
         */
        func deleteUser(#username: String) -> RequestBuilder<Void> {
            var path = "/user/{username}"
            path = path.stringByReplacingOccurrencesOfString("{username}", withString: "\(username)", options: .LiteralSearch, range: nil)
            let url = PetstoreClientAPI.basePath + path
            
            let nillableParameters: [String:AnyObject?] = [:]
            let parameters = APIHelper.rejectNil(nillableParameters)

            let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "DELETE", URLString: url, parameters: parameters, isBody: true)
        }
    
    }
}
