//
// PetAPI.swift
//
// Generated by swagger-codegen
// https://github.com/swagger-api/swagger-codegen
//

import Alamofire
import PromiseKit

extension PetstoreClientAPI {
    
    class PetAPI: APIBase {
    
        /**
         
         Update an existing pet
         
         - PUT /pet
         - 
         - OAuth:
           - type: oauth2
           - name: petstore_auth
         
         :param: body (body) Pet object that needs to be added to the store

         :returns: Promise<Response<Void>> 
         */
        func updatePet(#body: Pet?) -> RequestBuilder<Void> {
            let path = "/pet"
            let url = PetstoreClientAPI.basePath + path
            
            let parameters = body?.encodeToJSON() as? [String:AnyObject]

            let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "PUT", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         Add a new pet to the store
         
         - POST /pet
         - 
         - OAuth:
           - type: oauth2
           - name: petstore_auth
         
         :param: body (body) Pet object that needs to be added to the store

         :returns: Promise<Response<Void>> 
         */
        func addPet(#body: Pet?) -> RequestBuilder<Void> {
            let path = "/pet"
            let url = PetstoreClientAPI.basePath + path
            
            let parameters = body?.encodeToJSON() as? [String:AnyObject]

            let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "POST", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         Finds Pets by status
         
         - GET /pet/findByStatus
         - Multiple status values can be provided with comma seperated strings
         - OAuth:
           - type: oauth2
           - name: petstore_auth
         - examples: [{example=[ {
  "tags" : [ {
    "id" : 123456789,
    "name" : "aeiou"
  } ],
  "id" : 123456789,
  "category" : {
    "id" : 123456789,
    "name" : "aeiou"
  },
  "status" : "aeiou",
  "name" : "doggie",
  "photoUrls" : [ "aeiou" ]
} ], contentType=application/json}, {example=<Pet>
  <id>123456</id>
  <name>doggie</name>
  <photoUrls>string</photoUrls>
  <status>string</status>
</Pet>, contentType=application/xml}]
         - examples: [{example=[ {
  "tags" : [ {
    "id" : 123456789,
    "name" : "aeiou"
  } ],
  "id" : 123456789,
  "category" : {
    "id" : 123456789,
    "name" : "aeiou"
  },
  "status" : "aeiou",
  "name" : "doggie",
  "photoUrls" : [ "aeiou" ]
} ], contentType=application/json}, {example=<Pet>
  <id>123456</id>
  <name>doggie</name>
  <photoUrls>string</photoUrls>
  <status>string</status>
</Pet>, contentType=application/xml}]
         
         :param: status (query) Status values that need to be considered for filter

         :returns: Promise<Response<[Pet]>> 
         */
        func findPetsByStatus(#status: [String]?) -> RequestBuilder<[Pet]> {
            let path = "/pet/findByStatus"
            let url = PetstoreClientAPI.basePath + path
            
            let nillableParameters: [String:AnyObject?] = [
                "status": status
            ]
            let parameters = APIHelper.rejectNil(nillableParameters)

            let requestBuilder: RequestBuilder<[Pet]>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "GET", URLString: url, parameters: parameters, isBody: false)
        }
    
        /**
         
         Finds Pets by tags
         
         - GET /pet/findByTags
         - Muliple tags can be provided with comma seperated strings. Use tag1, tag2, tag3 for testing.
         - OAuth:
           - type: oauth2
           - name: petstore_auth
         - examples: [{example=[ {
  "tags" : [ {
    "id" : 123456789,
    "name" : "aeiou"
  } ],
  "id" : 123456789,
  "category" : {
    "id" : 123456789,
    "name" : "aeiou"
  },
  "status" : "aeiou",
  "name" : "doggie",
  "photoUrls" : [ "aeiou" ]
} ], contentType=application/json}, {example=<Pet>
  <id>123456</id>
  <name>doggie</name>
  <photoUrls>string</photoUrls>
  <status>string</status>
</Pet>, contentType=application/xml}]
         - examples: [{example=[ {
  "tags" : [ {
    "id" : 123456789,
    "name" : "aeiou"
  } ],
  "id" : 123456789,
  "category" : {
    "id" : 123456789,
    "name" : "aeiou"
  },
  "status" : "aeiou",
  "name" : "doggie",
  "photoUrls" : [ "aeiou" ]
} ], contentType=application/json}, {example=<Pet>
  <id>123456</id>
  <name>doggie</name>
  <photoUrls>string</photoUrls>
  <status>string</status>
</Pet>, contentType=application/xml}]
         
         :param: tags (query) Tags to filter by

         :returns: Promise<Response<[Pet]>> 
         */
        func findPetsByTags(#tags: [String]?) -> RequestBuilder<[Pet]> {
            let path = "/pet/findByTags"
            let url = PetstoreClientAPI.basePath + path
            
            let nillableParameters: [String:AnyObject?] = [
                "tags": tags
            ]
            let parameters = APIHelper.rejectNil(nillableParameters)

            let requestBuilder: RequestBuilder<[Pet]>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "GET", URLString: url, parameters: parameters, isBody: false)
        }
    
        /**
         
         Find pet by ID
         
         - GET /pet/{petId}
         - Returns a pet when ID < 10.  ID > 10 or nonintegers will simulate API error conditions
         - API Key:
           - type: apiKey api_key 
           - name: api_key
         - OAuth:
           - type: oauth2
           - name: petstore_auth
         - examples: [{example={
  "tags" : [ {
    "id" : 123456789,
    "name" : "aeiou"
  } ],
  "id" : 123456789,
  "category" : {
    "id" : 123456789,
    "name" : "aeiou"
  },
  "status" : "aeiou",
  "name" : "doggie",
  "photoUrls" : [ "aeiou" ]
}, contentType=application/json}, {example=<Pet>
  <id>123456</id>
  <name>doggie</name>
  <photoUrls>string</photoUrls>
  <status>string</status>
</Pet>, contentType=application/xml}]
         - examples: [{example={
  "tags" : [ {
    "id" : 123456789,
    "name" : "aeiou"
  } ],
  "id" : 123456789,
  "category" : {
    "id" : 123456789,
    "name" : "aeiou"
  },
  "status" : "aeiou",
  "name" : "doggie",
  "photoUrls" : [ "aeiou" ]
}, contentType=application/json}, {example=<Pet>
  <id>123456</id>
  <name>doggie</name>
  <photoUrls>string</photoUrls>
  <status>string</status>
</Pet>, contentType=application/xml}]
         
         :param: petId (path) ID of pet that needs to be fetched

         :returns: Promise<Response<Pet>> 
         */
        func getPetById(#petId: Int) -> RequestBuilder<Pet> {
            var path = "/pet/{petId}"
            path = path.stringByReplacingOccurrencesOfString("{petId}", withString: "\(petId)", options: .LiteralSearch, range: nil)
            let url = PetstoreClientAPI.basePath + path
            
            let nillableParameters: [String:AnyObject?] = [:]
            let parameters = APIHelper.rejectNil(nillableParameters)

            let requestBuilder: RequestBuilder<Pet>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "GET", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         Updates a pet in the store with form data
         
         - POST /pet/{petId}
         - 
         - OAuth:
           - type: oauth2
           - name: petstore_auth
         
         :param: petId (path) ID of pet that needs to be updated
         :param: name (form) Updated name of the pet
         :param: status (form) Updated status of the pet

         :returns: Promise<Response<Void>> 
         */
        func updatePetWithForm(#petId: String, name: String?, status: String?) -> RequestBuilder<Void> {
            var path = "/pet/{petId}"
            path = path.stringByReplacingOccurrencesOfString("{petId}", withString: "\(petId)", options: .LiteralSearch, range: nil)
            let url = PetstoreClientAPI.basePath + path
            
            let nillableParameters: [String:AnyObject?] = [:]
            let parameters = APIHelper.rejectNil(nillableParameters)

            let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "POST", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         Deletes a pet
         
         - DELETE /pet/{petId}
         - 
         - OAuth:
           - type: oauth2
           - name: petstore_auth
         
         :param: petId (path) Pet id to delete

         :returns: Promise<Response<Void>> 
         */
        func deletePet(#petId: Int) -> RequestBuilder<Void> {
            var path = "/pet/{petId}"
            path = path.stringByReplacingOccurrencesOfString("{petId}", withString: "\(petId)", options: .LiteralSearch, range: nil)
            let url = PetstoreClientAPI.basePath + path
            
            let nillableParameters: [String:AnyObject?] = [:]
            let parameters = APIHelper.rejectNil(nillableParameters)

            let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "DELETE", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         uploads an image
         
         - POST /pet/{petId}/uploadImage
         - 
         - OAuth:
           - type: oauth2
           - name: petstore_auth
         
         :param: petId (path) ID of pet to update
         :param: additionalMetadata (form) Additional data to pass to server
         :param: file (form) file to upload

         :returns: Promise<Response<Void>> 
         */
        func uploadFile(#petId: Int, additionalMetadata: String?, file: NSData?) -> RequestBuilder<Void> {
            var path = "/pet/{petId}/uploadImage"
            path = path.stringByReplacingOccurrencesOfString("{petId}", withString: "\(petId)", options: .LiteralSearch, range: nil)
            let url = PetstoreClientAPI.basePath + path
            
            let nillableParameters: [String:AnyObject?] = [:]
            let parameters = APIHelper.rejectNil(nillableParameters)

            let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "POST", URLString: url, parameters: parameters, isBody: true)
        }
    
    }
}
