#!/usr/bin/env python
"""
PetApi.py
Copyright 2015 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from .models import *


class PetApi(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient

    
    
    def update_pet(self, **kwargs):
        """Update an existing pet
        

        Args:
            body, Pet: Pet object that needs to be added to the store (optional)
            

        Returns: 
        """

        allParams = ['body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method update_pet" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/pet'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        

        

        

        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        
        
        
    
    def add_pet(self, **kwargs):
        """Add a new pet to the store
        

        Args:
            body, Pet: Pet object that needs to be added to the store (optional)
            

        Returns: 
        """

        allParams = ['body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method add_pet" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/pet'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        

        

        

        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        
        
        
    
    def find_pets_by_status(self, **kwargs):
        """Finds Pets by status
        Multiple status values can be provided with comma seperated strings

        Args:
            status, list[str]: Status values that need to be considered for filter (optional)
            

        Returns: list[Pet]
        """

        allParams = ['status']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method find_pets_by_status" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/pet/findByStatus'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        
        if ('status' in params):
            queryParams['status'] = self.apiClient.toPathValue(params['status'])
        

        

        

        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        
        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[Pet]')
        return responseObject
        
        
        
    
    def find_pets_by_tags(self, **kwargs):
        """Finds Pets by tags
        Muliple tags can be provided with comma seperated strings. Use tag1, tag2, tag3 for testing.

        Args:
            tags, list[str]: Tags to filter by (optional)
            

        Returns: list[Pet]
        """

        allParams = ['tags']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method find_pets_by_tags" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/pet/findByTags'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        
        if ('tags' in params):
            queryParams['tags'] = self.apiClient.toPathValue(params['tags'])
        

        

        

        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        
        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[Pet]')
        return responseObject
        
        
        
    
    def get_pet_by_id(self, **kwargs):
        """Find pet by ID
        Returns a pet when ID < 10.  ID > 10 or nonintegers will simulate API error conditions

        Args:
            pet_id, int: ID of pet that needs to be fetched (required)
            

        Returns: Pet
        """

        allParams = ['pet_id']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_pet_by_id" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/pet/{petId}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        

        

        
        if ('pet_id' in params):
            replacement = str(self.apiClient.toPathValue(params['pet_id']))
            resourcePath = resourcePath.replace('{' + 'petId' + '}',
                                                replacement)
        

        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        
        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'Pet')
        return responseObject
        
        
        
    
    def update_pet_with_form(self, **kwargs):
        """Updates a pet in the store with form data
        

        Args:
            pet_id, str: ID of pet that needs to be updated (required)
            name, str: Updated name of the pet (optional)
            status, str: Updated status of the pet (optional)
            

        Returns: 
        """

        allParams = ['pet_id', 'name', 'status']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method update_pet_with_form" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/pet/{petId}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        

        

        
        if ('pet_id' in params):
            replacement = str(self.apiClient.toPathValue(params['pet_id']))
            resourcePath = resourcePath.replace('{' + 'petId' + '}',
                                                replacement)
        

        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        
        
        
    
    def delete_pet(self, **kwargs):
        """Deletes a pet
        

        Args:
            api_key, str:  (optional)
            pet_id, int: Pet id to delete (required)
            

        Returns: 
        """

        allParams = ['api_key', 'pet_id']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method delete_pet" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/pet/{petId}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        

        
        if ('api_key' in params):
            headerParams['api_key'] = params['api_key']
        

        
        if ('pet_id' in params):
            replacement = str(self.apiClient.toPathValue(params['pet_id']))
            resourcePath = resourcePath.replace('{' + 'petId' + '}',
                                                replacement)
        

        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        
        
        
    
    def upload_file(self, **kwargs):
        """uploads an image
        

        Args:
            pet_id, int: ID of pet to update (required)
            additional_metadata, str: Additional data to pass to server (optional)
            file, file: file to upload (optional)
            

        Returns: 
        """

        allParams = ['pet_id', 'additional_metadata', 'file']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method upload_file" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/pet/{petId}/uploadImage'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        

        

        
        if ('pet_id' in params):
            replacement = str(self.apiClient.toPathValue(params['pet_id']))
            resourcePath = resourcePath.replace('{' + 'petId' + '}',
                                                replacement)
        

        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        
        
        
    


