#!/usr/bin/env python
# coding: utf-8

"""
UserApi.py
Copyright 2015 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from .. import configuration
from ..api_client import ApiClient

class UserApi(object):

    def __init__(self, api_client=None):
        if api_client:
            self.api_client = api_client
        else:
            if not configuration.api_client:
                configuration.api_client = ApiClient('http://petstore.swagger.io/v2')
            self.api_client = configuration.api_client
    
    
    def create_user(self, **kwargs):
        """
        Create user
        This can only be done by the logged in user.

        :param User body: Created user object 
        
        :return: None
        """
        
        all_params = ['body']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method create_user" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/user'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        
        query_params = {}
        
        header_params = {}
        
        form_params = {}
        files = {}
        
        body_params = None
        
        if 'body' in params:
            body_params = params['body']
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json', 'application/xml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response=None, auth_settings=auth_settings)
        
    def create_users_with_array_input(self, **kwargs):
        """
        Creates list of users with given input array
        

        :param list[User] body: List of user object 
        
        :return: None
        """
        
        all_params = ['body']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method create_users_with_array_input" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/user/createWithArray'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        
        query_params = {}
        
        header_params = {}
        
        form_params = {}
        files = {}
        
        body_params = None
        
        if 'body' in params:
            body_params = params['body']
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json', 'application/xml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response=None, auth_settings=auth_settings)
        
    def create_users_with_list_input(self, **kwargs):
        """
        Creates list of users with given input array
        

        :param list[User] body: List of user object 
        
        :return: None
        """
        
        all_params = ['body']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method create_users_with_list_input" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/user/createWithList'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        
        query_params = {}
        
        header_params = {}
        
        form_params = {}
        files = {}
        
        body_params = None
        
        if 'body' in params:
            body_params = params['body']
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json', 'application/xml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response=None, auth_settings=auth_settings)
        
    def login_user(self, **kwargs):
        """
        Logs user into the system
        

        :param str username: The user name for login 
        :param str password: The password for login in clear text 
        
        :return: str
        """
        
        all_params = ['username', 'password']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method login_user" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/user/login'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        
        query_params = {}
        
        if 'username' in params:
            query_params['username'] = params['username']
        
        if 'password' in params:
            query_params['password'] = params['password']
        
        header_params = {}
        
        form_params = {}
        files = {}
        
        body_params = None
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json', 'application/xml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)
        
        return response
        
    def logout_user(self, **kwargs):
        """
        Logs out current logged in user session
        

        
        :return: None
        """
        
        all_params = []

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method logout_user" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/user/logout'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        
        query_params = {}
        
        header_params = {}
        
        form_params = {}
        files = {}
        
        body_params = None
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json', 'application/xml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response=None, auth_settings=auth_settings)
        
    def get_user_by_name(self, username, **kwargs):
        """
        Get user by user name
        

        :param str username: The name that needs to be fetched. Use user1 for testing.  (required)
        
        :return: User
        """
        
        # verify the required parameter 'username' is set
        if username is None:
            raise ValueError("Missing the required parameter `username` when calling `get_user_by_name`")
        
        all_params = ['username']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_user_by_name" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/user/{username}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        
        if 'username' in params:
            path_params['username'] = params['username']  
        
        query_params = {}
        
        header_params = {}
        
        form_params = {}
        files = {}
        
        body_params = None
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json', 'application/xml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='User', auth_settings=auth_settings)
        
        return response
        
    def update_user(self, username, **kwargs):
        """
        Updated user
        This can only be done by the logged in user.

        :param str username: name that need to be deleted (required)
        :param User body: Updated user object 
        
        :return: None
        """
        
        # verify the required parameter 'username' is set
        if username is None:
            raise ValueError("Missing the required parameter `username` when calling `update_user`")
        
        all_params = ['username', 'body']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method update_user" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/user/{username}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        
        if 'username' in params:
            path_params['username'] = params['username']  
        
        query_params = {}
        
        header_params = {}
        
        form_params = {}
        files = {}
        
        body_params = None
        
        if 'body' in params:
            body_params = params['body']
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json', 'application/xml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response=None, auth_settings=auth_settings)
        
    def delete_user(self, username, **kwargs):
        """
        Delete user
        This can only be done by the logged in user.

        :param str username: The name that needs to be deleted (required)
        
        :return: None
        """
        
        # verify the required parameter 'username' is set
        if username is None:
            raise ValueError("Missing the required parameter `username` when calling `delete_user`")
        
        all_params = ['username']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method delete_user" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/user/{username}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        
        if 'username' in params:
            path_params['username'] = params['username']  
        
        query_params = {}
        
        header_params = {}
        
        form_params = {}
        files = {}
        
        body_params = None
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json', 'application/xml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response=None, auth_settings=auth_settings)
        









