using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;

namespace IO.Swagger.Models
{
    /// <summary>
    /// 
    /// </summary>
    public partial class Pet :  IEquatable<Pet>
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Pet" /> class.
        /// </summary>
        /// <param name="Id">Id.</param>
        /// <param name="Category">Category.</param>
        /// <param name="Name">Name (required).</param>
        /// <param name="PhotoUrls">PhotoUrls (required).</param>
        /// <param name="Tags">Tags.</param>
        /// <param name="Status">pet status in the store.</param>
        public Pet(long? Id = null, Category Category = null, string Name = null, List<string> PhotoUrls = null, List<Tag> Tags = null, string Status = null)
        {
            // to ensure "Name" is required (not null)
            if (Name == null)
            {
                throw new InvalidDataException("Name is a required property for Pet and cannot be null");
            }
            else
            {
                this.Name = Name;
            }
            // to ensure "PhotoUrls" is required (not null)
            if (PhotoUrls == null)
            {
                throw new InvalidDataException("PhotoUrls is a required property for Pet and cannot be null");
            }
            else
            {
                this.PhotoUrls = PhotoUrls;
            }
            this.Id = Id;
            this.Category = Category;
            this.Tags = Tags;
            this.Status = Status;
            
        }

        
        /// <summary>
        /// Gets or Sets Id
        /// </summary>
        public long? Id { get; set; }

        
        /// <summary>
        /// Gets or Sets Category
        /// </summary>
        public Category Category { get; set; }

        
        /// <summary>
        /// Gets or Sets Name
        /// </summary>
        public string Name { get; set; }

        
        /// <summary>
        /// Gets or Sets PhotoUrls
        /// </summary>
        public List<string> PhotoUrls { get; set; }

        
        /// <summary>
        /// Gets or Sets Tags
        /// </summary>
        public List<Tag> Tags { get; set; }

        
        /// <summary>
        /// pet status in the store
        /// </summary>
        /// <value>pet status in the store</value>
        public string Status { get; set; }

        

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class Pet {\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Category: ").Append(Category).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  PhotoUrls: ").Append(PhotoUrls).Append("\n");
            sb.Append("  Tags: ").Append(Tags).Append("\n");
            sb.Append("  Status: ").Append(Status).Append("\n");
            
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj)) return false;
            if (ReferenceEquals(this, obj)) return true;
            if (obj.GetType() != GetType()) return false;
            return Equals((Pet)obj);
        }

        /// <summary>
        /// Returns true if Pet instances are equal
        /// </summary>
        /// <param name="other">Instance of Pet to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Pet other)
        {

            if (ReferenceEquals(null, other)) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    this.Id == other.Id ||
                    this.Id != null &&
                    this.Id.Equals(other.Id)
                ) && 
                (
                    this.Category == other.Category ||
                    this.Category != null &&
                    this.Category.Equals(other.Category)
                ) && 
                (
                    this.Name == other.Name ||
                    this.Name != null &&
                    this.Name.Equals(other.Name)
                ) && 
                (
                    this.PhotoUrls == other.PhotoUrls ||
                    this.PhotoUrls != null &&
                    this.PhotoUrls.SequenceEqual(other.PhotoUrls)
                ) && 
                (
                    this.Tags == other.Tags ||
                    this.Tags != null &&
                    this.Tags.SequenceEqual(other.Tags)
                ) && 
                (
                    this.Status == other.Status ||
                    this.Status != null &&
                    this.Status.Equals(other.Status)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                
                    if (this.Id != null)
                    hash = hash * 59 + this.Id.GetHashCode();
                
                    if (this.Category != null)
                    hash = hash * 59 + this.Category.GetHashCode();
                
                    if (this.Name != null)
                    hash = hash * 59 + this.Name.GetHashCode();
                
                    if (this.PhotoUrls != null)
                    hash = hash * 59 + this.PhotoUrls.GetHashCode();
                
                    if (this.Tags != null)
                    hash = hash * 59 + this.Tags.GetHashCode();
                
                    if (this.Status != null)
                    hash = hash * 59 + this.Status.GetHashCode();
                
                return hash;
            }
        }

        #region Operators

        public static bool operator ==(Pet left, Pet right)
        {
            return Equals(left, right);
        }

        public static bool operator !=(Pet left, Pet right)
        {
            return !Equals(left, right);
        }

        #endregion Operators

    }
}
