#import <Foundation/Foundation.h>
#import "SWGPet.h"
#import "SWGInlineResponse200.h"
#import "SWGObject.h"
#import "SWGApiClient.h"


/**
 * NOTE: This class is auto generated by the swagger code generator program. 
 * https://github.com/swagger-api/swagger-codegen 
 * Do not edit the class manually.
 */

@interface SWGPetApi: NSObject

@property(nonatomic, assign)SWGApiClient *apiClient;

-(instancetype) initWithApiClient:(SWGApiClient *)apiClient;
-(void) addHeader:(NSString*)value forKey:(NSString*)key;
-(unsigned long) requestQueueSize;
+(SWGPetApi*) apiWithHeader:(NSString*)headerValue key:(NSString*)key;
+(SWGPetApi*) sharedAPI;
///
///
/// Add a new pet to the store
/// 
///
/// @param body Pet object that needs to be added to the store
/// 
///
/// @return 
-(NSNumber*) addPetWithBody: (SWGPet*) body
    completionHandler: (void (^)(NSError* error)) handler;


///
///
/// Fake endpoint to test byte array in body parameter for adding a new pet to the store
/// 
///
/// @param body Pet object in the form of byte array
/// 
///
/// @return 
-(NSNumber*) addPetUsingByteArrayWithBody: (NSString*) body
    completionHandler: (void (^)(NSError* error)) handler;


///
///
/// Deletes a pet
/// 
///
/// @param petId Pet id to delete
/// @param apiKey 
/// 
///
/// @return 
-(NSNumber*) deletePetWithPetId: (NSNumber*) petId
    apiKey: (NSString*) apiKey
    completionHandler: (void (^)(NSError* error)) handler;


///
///
/// Finds Pets by status
/// Multiple status values can be provided with comma separated strings
///
/// @param status Status values that need to be considered for query
/// 
///
/// @return NSArray<SWGPet>*
-(NSNumber*) findPetsByStatusWithStatus: (NSArray* /* NSString */) status
    completionHandler: (void (^)(NSArray<SWGPet>* output, NSError* error)) handler;


///
///
/// Finds Pets by tags
/// Muliple tags can be provided with comma seperated strings. Use tag1, tag2, tag3 for testing.
///
/// @param tags Tags to filter by
/// 
///
/// @return NSArray<SWGPet>*
-(NSNumber*) findPetsByTagsWithTags: (NSArray* /* NSString */) tags
    completionHandler: (void (^)(NSArray<SWGPet>* output, NSError* error)) handler;


///
///
/// Find pet by ID
/// Returns a pet when ID < 10.  ID > 10 or nonintegers will simulate API error conditions
///
/// @param petId ID of pet that needs to be fetched
/// 
///
/// @return SWGPet*
-(NSNumber*) getPetByIdWithPetId: (NSNumber*) petId
    completionHandler: (void (^)(SWGPet* output, NSError* error)) handler;


///
///
/// Fake endpoint to test inline arbitrary object return by 'Find pet by ID'
/// Returns a pet when ID < 10.  ID > 10 or nonintegers will simulate API error conditions
///
/// @param petId ID of pet that needs to be fetched
/// 
///
/// @return SWGInlineResponse200*
-(NSNumber*) getPetByIdInObjectWithPetId: (NSNumber*) petId
    completionHandler: (void (^)(SWGInlineResponse200* output, NSError* error)) handler;


///
///
/// Fake endpoint to test byte array return by 'Find pet by ID'
/// Returns a pet when ID < 10.  ID > 10 or nonintegers will simulate API error conditions
///
/// @param petId ID of pet that needs to be fetched
/// 
///
/// @return NSString*
-(NSNumber*) petPetIdtestingByteArraytrueGetWithPetId: (NSNumber*) petId
    completionHandler: (void (^)(NSString* output, NSError* error)) handler;


///
///
/// Update an existing pet
/// 
///
/// @param body Pet object that needs to be added to the store
/// 
///
/// @return 
-(NSNumber*) updatePetWithBody: (SWGPet*) body
    completionHandler: (void (^)(NSError* error)) handler;


///
///
/// Updates a pet in the store with form data
/// 
///
/// @param petId ID of pet that needs to be updated
/// @param name Updated name of the pet
/// @param status Updated status of the pet
/// 
///
/// @return 
-(NSNumber*) updatePetWithFormWithPetId: (NSString*) petId
    name: (NSString*) name
    status: (NSString*) status
    completionHandler: (void (^)(NSError* error)) handler;


///
///
/// uploads an image
/// 
///
/// @param petId ID of pet to update
/// @param additionalMetadata Additional data to pass to server
/// @param file file to upload
/// 
///
/// @return 
-(NSNumber*) uploadFileWithPetId: (NSNumber*) petId
    additionalMetadata: (NSString*) additionalMetadata
    file: (NSURL*) file
    completionHandler: (void (^)(NSError* error)) handler;



@end
