<?php
/*
** Copyright (C) 2001-2025 Zabbix SIA
**
** This program is free software: you can redistribute it and/or modify it under the terms of
** the GNU Affero General Public License as published by the Free Software Foundation, version 3.
**
** This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
** without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** See the GNU Affero General Public License for more details.
**
** You should have received a copy of the GNU Affero General Public License along with this program.
** If not, see <https://www.gnu.org/licenses/>.
**/

require_once dirname(__FILE__).'/../include/CIntegrationTest.php';
require_once dirname(__FILE__).'/../include/helpers/CDataHelper.php';

/**
 * Test suite for data collection using both active and passive agents.
 *
 * @backup history, hosts, host_rtdata, proxy, proxy_rtdata, auditlog, changelog, config, ha_node, changelog, config
 * @backup config_autoreg_tls, expressions, globalmacro, hosts, interface, item_preproc, item_rtdata, items, regexps
 */
class testBinaryValueTypeDataCollection extends CIntegrationTest {

	private static $itemids = [];

	const base64_image = "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";

	const base64_empty = "";
	const base64_invalid = "a";

	const TEST_FILE_NAME_JSON_WITH_IMAGE="/tmp/json_with_image.txt";

	/**
	 * @inheritdoc
	 */
	public function prepareData() {

		$base64_image = self::base64_image;
		$base64_empty = self::base64_empty;
		$base64_invalid = self::base64_invalid;
		$json_with_image = <<<HEREA
		{
			"result": "fail",
			"error_message": "assertion failed: element id top-header not found",
			"http_response": "200",
			"start_time": {
			"value": "Nov 11 10:00:00 2022 GMT",
			"timestamp": 1668153600
			},
			"duration": 11628,
			"performance_timings": {
			"download": 1070,
			"tls_handshake": 230,
			"dns_lookup": 290
			},
			"screenshot_image": "$base64_image",
			"screenshot_empty": "$base64_empty",
			"screenshot_invalid": "$base64_invalid",
			"custom_result": {
			"broken_links": 0
			}
		}
		HEREA;

		$this->assertTrue(@file_put_contents(self::TEST_FILE_NAME_JSON_WITH_IMAGE, $json_with_image) !== false);

		CDataHelper::call('proxy.create', [
			'name' => 'proxy',
			'operating_mode' => PROXY_OPERATING_MODE_ACTIVE
		]);

		$proxyids = CDataHelper::getIds('name');

		$interfaces = [
			'type' => 1,
			'main' => 1,
			'useip' => 1,
			'ip' => '127.0.0.1',
			'dns' => '',
			'port' => $this->getConfigurationValue(self::COMPONENT_AGENT, 'ListenPort')
		];

		$groups = ['groupid' => 4];

		$result = CDataHelper::createHosts([
			[
				'host' => 'agent',
				'interfaces' => $interfaces,
				'groups' => $groups,
				'status' => HOST_STATUS_MONITORED,
				'items' => [
					[
						'name' => 'JSON_WITH_IMAGE',
						'key_' => 'vfs.file.contents['.self::TEST_FILE_NAME_JSON_WITH_IMAGE.',]',
						'type' => ITEM_TYPE_ZABBIX,
						'value_type' => ITEM_VALUE_TYPE_TEXT,
						'delay' => '1s'
					]
				]
			],
			[
				'host' => 'proxy_agent',
				'interfaces' => $interfaces,
				'groups' => $groups,
				'proxyid' => $proxyids['proxy'],
				'monitored_by' => ZBX_MONITORED_BY_PROXY,
				'status' => HOST_STATUS_MONITORED,
				'items' => [
					[
						'name' => 'JSON_WITH_IMAGE',
						'key_' => 'vfs.file.contents['.self::TEST_FILE_NAME_JSON_WITH_IMAGE.',]',
						'type' => ITEM_TYPE_ZABBIX,
						'value_type' => ITEM_VALUE_TYPE_TEXT,
						'delay' => '1s'
					]
				]
			]
		]);

		self::$itemids = $result['itemids'];

		$dep_items_create_result = CDataHelper::createItems('item',
			['agent' =>
				[
				[
						'name' => 'BINARY_IMAGE',
						'key_' => 'BINARY_IMAGE',
						'type' => ITEM_TYPE_DEPENDENT,
						'master_itemid' => self::$itemids['agent:vfs.file.contents['.self::TEST_FILE_NAME_JSON_WITH_IMAGE.',]'],
						'value_type' => ITEM_VALUE_TYPE_BINARY,
						'delay' => '0s',
						'preprocessing' => [['type' => 12, 'params' => '$.screenshot_image',
						'error_handler' => 0,
						'error_handler_params' => ''
							]]
				],
				[
					'name' => 'BINARY_IMAGE_EMPTY',
					'key_' => 'BINARY_IMAGE_EMPTY',
					'type' => ITEM_TYPE_DEPENDENT,
					'master_itemid' => self::$itemids['agent:vfs.file.contents['.self::TEST_FILE_NAME_JSON_WITH_IMAGE.',]'],
					'value_type' => ITEM_VALUE_TYPE_BINARY,
					'delay' => '0s',
					'preprocessing' =>
						[[
							'type' => 12,
							'params' => '$.screenshot_empty',
							'error_handler' => 0,
							'error_handler_params' => ''
						]]
				],
				[
					'name' => 'BINARY_IMAGE_INVALID',
					'key_' => 'BINARY_IMAGE_INVALID',
					'type' => ITEM_TYPE_DEPENDENT,
					'master_itemid' => self::$itemids['agent:vfs.file.contents['.self::TEST_FILE_NAME_JSON_WITH_IMAGE.',]'],
					'value_type' => ITEM_VALUE_TYPE_BINARY,
					'delay' => '0s',
					'preprocessing' =>
						[[
							'type' => 12,
							'params' => '$.screenshot_invalid',
							'error_handler' => 0,
							'error_handler_params' => ''
						]]
				]]
			]
		, $result['hostids']);

		self::$itemids = array_merge(self::$itemids, $dep_items_create_result);

		$dep_items_create_result = CDataHelper::createItems('item',
			['proxy_agent' =>
				[[
					'name' => 'BINARY_IMAGE',
					'key_' => 'BINARY_IMAGE',
					'type' => ITEM_TYPE_DEPENDENT,
					'master_itemid' => self::$itemids['proxy_agent:vfs.file.contents['.self::TEST_FILE_NAME_JSON_WITH_IMAGE.',]'],
					'value_type' => ITEM_VALUE_TYPE_BINARY,
					'delay' => '0s',
					'preprocessing' =>
						[[
							'type' => 12,
							'params' => '$.screenshot_image',
							'error_handler' => 0,
							'error_handler_params' => ''
						]]
				]]
			]
		, $result['hostids']);

		self::$itemids = array_merge(self::$itemids, $dep_items_create_result);

		return true;
	}

	/**
	 * Component configuration provider for agent related tests.
	 *
	 * @return array
	 */
	public function agentConfigurationProvider() {
		return [
			self::COMPONENT_SERVER => [
				'UnreachablePeriod' => 5,
				'UnavailableDelay' => 5,
				'UnreachableDelay' => 1,
				'DebugLevel' => 5,
				'LogFileSize' => 0
			],
			self::COMPONENT_AGENT => [
				'Hostname' => 'agent',
				'ServerActive' => '127.0.0.1'
			]
		];
	}

	public function checkItemState(string $name, int $state) {
		$wait_iterations = 5;
		$wait_iteration_delay = 1;

		for ($r = 0; $r < $wait_iterations; $r++) {
			$item = $this->call('item.get', [
			'output' => ['state', 'lastvalue'],
			'itemids' => self::$itemids[$name]
			])['result'][0];

			if ($item['state'] == $state && ($state == ITEM_STATE_NOTSUPPORTED)) {
				break;
			}

			sleep($wait_iteration_delay);
		}

		$this->assertEquals($state, $item['state'], 'User parameter failed to reload, item name: '.$name);
	}

	/**
	 * Test if both active and passive agent checks are processed.
	 *
	 * @required-components server, agent
	 * @configurationDataProvider agentConfigurationProvider
	 * @hosts agent
	 */
	public function testBinaryValueTypeDataCollection_checkAgentData() {

		self::waitForLogLineToBePresent(self::COMPONENT_SERVER, [
			'enabling Zabbix agent checks on host "agent": interface became available',
			'resuming Zabbix agent checks on host "agent": connection restored'
		]);

		$this->reloadConfigurationCache(self::COMPONENT_SERVER);
		$this->waitForLogLineToBePresent(self::COMPONENT_SERVER, "finished forced reloading of the configuration cache", true, 60, 1);

		// Retrieve history data from API as soon it is available.
		// image
		$active_data = $this->callUntilDataIsPresent('history.get', [
			'itemids'	=>	self::$itemids['agent:BINARY_IMAGE'],
			'history'	=>	ITEM_VALUE_TYPE_BINARY
		]);

		$base64_image = self::base64_image;
		foreach ($active_data['result'] as $item) {
			$this->assertEquals($base64_image, $item['value']);
		}

		// empty
		$active_data = $this->callUntilDataIsPresent('history.get', [
			'itemids'	=>	self::$itemids['agent:BINARY_IMAGE_EMPTY'],
			'history'	=>	ITEM_VALUE_TYPE_BINARY
		]);

		$base64_empty = self::base64_empty;
		foreach ($active_data['result'] as $item) {
			$this->assertEquals($base64_empty, $item['value']);
		}

		$this->checkItemState('agent:BINARY_IMAGE', ITEM_STATE_NORMAL);
		$this->checkItemState('agent:BINARY_IMAGE_EMPTY', ITEM_STATE_NORMAL);
		$this->checkItemState('agent:BINARY_IMAGE_INVALID', ITEM_STATE_NOTSUPPORTED);
	}

	/**
	 * Component configuration provider for proxy related tests.
	 *
	 * @return array
	 */
	public function proxyConfigurationProvider() {
		return [
			self::COMPONENT_SERVER => [
				'UnreachablePeriod' => 5,
				'UnavailableDelay' => 5,
				'UnreachableDelay' => 1,
				'DebugLevel' => 5,
				'LogFileSize' => 0
			],
			self::COMPONENT_PROXY => [
				'UnreachablePeriod' => 5,
				'UnavailableDelay' => 5,
				'UnreachableDelay' => 1,
				'DebugLevel' => 5,
				'LogFileSize' => 0,
				'Hostname' => 'proxy',
				'Server' => '127.0.0.1:'.self::getConfigurationValue(self::COMPONENT_SERVER, 'ListenPort')
			],
			self::COMPONENT_AGENT => [
				'Hostname' => 'proxy_agent',
				'ServerActive' => '127.0.0.1:'.self::getConfigurationValue(self::COMPONENT_PROXY, 'ListenPort')
			]
		];
	}

	/**
	 * Test if both active and passive agent checks are processed.
	 *
	 * @required-components server, proxy, agent
	 * @configurationDataProvider proxyConfigurationProvider
	 * @hosts proxy_agent
	 */
	public function testBinaryValueTypeDataCollection_checkProxyData() {
		self::waitForLogLineToBePresent(self::COMPONENT_SERVER, 'sending configuration data to proxy "proxy"');
		self::waitForLogLineToBePresent(self::COMPONENT_PROXY, 'received configuration data from server');
		self::waitForLogLineToBePresent(self::COMPONENT_PROXY, [
			'enabling Zabbix agent checks on host "proxy_agent": interface became available',
			'resuming Zabbix agent checks on host "proxy_agent": connection restored'
		]);

		$this->reloadConfigurationCache(self::COMPONENT_PROXY);

		$base64_image = self::base64_image;

		// Retrieve history data from API as soon it is available.
		$active_data = $this->callUntilDataIsPresent('history.get', [
			'itemids'	=> self::$itemids['proxy_agent:BINARY_IMAGE'],
			'history'	=> ITEM_VALUE_TYPE_BINARY
		]);

		foreach ($active_data['result'] as $item) {
			$this->assertEquals($base64_image, $item['value']);
		}
	}
}
