
# Zabbix proxy health

## Overview

This template is designed to monitor internal Zabbix metrics on the local Zabbix proxy.

## Requirements

Zabbix version: 7.2 and higher.

## Tested versions

This template has been tested on:
- Zabbix proxy 7.2

## Configuration

> Zabbix should be configured according to the instructions in the [Templates out of the box](https://www.zabbix.com/documentation/7.2/manual/config/templates_out_of_the_box) section.

## Setup

Link this template to the local Zabbix proxy host.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$ZABBIX.PROXY.UTIL.MAX}|<p>Default maximum threshold for percentage utilization triggers (use macro context for specification).</p>|`75`|
|{$ZABBIX.PROXY.UTIL.MIN}|<p>Default minimum threshold for percentage utilization triggers (use macro context for specification).</p>|`65`|

### Items

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Queue over 10 minutes|<p>The number of monitored items in the queue that are delayed by at least 10 minutes.</p>|Zabbix internal|zabbix[queue,10m]|
|Queue|<p>The number of monitored items in the queue that are delayed by at least 6 seconds.</p>|Zabbix internal|zabbix[queue]|
|Utilization of data sender internal processes, in %|<p>The average percentage of the time during which the data sender processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,data sender,avg,busy]|
|Utilization of availability manager internal processes, in %|<p>The average percentage of the time during which the availability manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,availability manager,avg,busy]|
|Utilization of configuration syncer internal processes, in %|<p>The average percentage of the time during which the configuration syncer processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,configuration syncer,avg,busy]|
|Utilization of discovery manager internal processes, in %|<p>The average percentage of the time during which the discovery manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,discovery manager,avg,busy]|
|Utilization of discovery worker internal processes, in %|<p>The average percentage of the time during which the discovery worker processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,discovery worker,avg,busy]|
|Utilization of ODBC poller data collector processes, in %|<p>The average percentage of the time during which the ODBC poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,odbc poller,avg,busy]|
|Utilization of history syncer internal processes, in %|<p>The average percentage of the time during which the history syncer processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,history syncer,avg,busy]|
|Utilization of housekeeper internal processes, in %|<p>The average percentage of the time during which the housekeeper processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,housekeeper,avg,busy]|
|Utilization of http poller data collector processes, in %|<p>The average percentage of the time during which the http poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,http poller,avg,busy]|
|Utilization of icmp pinger data collector processes, in %|<p>The average percentage of the time during which the icmp pinger processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,icmp pinger,avg,busy]|
|Utilization of ipmi manager internal processes, in %|<p>The average percentage of the time during which the ipmi manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,ipmi manager,avg,busy]|
|Utilization of ipmi poller data collector processes, in %|<p>The average percentage of the time during which the ipmi poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,ipmi poller,avg,busy]|
|Utilization of java poller data collector processes, in %|<p>The average percentage of the time during which the java poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,java poller,avg,busy]|
|Utilization of poller data collector processes, in %|<p>The average percentage of the time during which the poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,poller,avg,busy]|
|Utilization of preprocessing worker internal processes, in %|<p>The average percentage of the time during which the preprocessing worker processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,preprocessing worker,avg,busy]|
|Utilization of preprocessing manager internal processes, in %|<p>The average percentage of the time during which the preprocessing manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,preprocessing manager,avg,busy]|
|Utilization of self-monitoring internal processes, in %|<p>The average percentage of the time during which the self-monitoring processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,self-monitoring,avg,busy]|
|Utilization of snmp trapper data collector processes, in %|<p>The average percentage of the time during which the snmp trapper processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,snmp trapper,avg,busy]|
|Utilization of task manager internal processes, in %|<p>The average percentage of the time during which the task manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,task manager,avg,busy]|
|Utilization of trapper data collector processes, in %|<p>The average percentage of the time during which the trapper processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,trapper,avg,busy]|
|Utilization of unreachable poller data collector processes, in %|<p>The average percentage of the time during which the unreachable poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,unreachable poller,avg,busy]|
|Utilization of vmware collector data collector processes, in %|<p>The average percentage of the time during which the vmware collector processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,vmware collector,avg,busy]|
|Utilization of agent poller data collector processes, in %|<p>The average percentage of the time during which the agent poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,agent poller,avg,busy]|
|Utilization of http agent poller data collector processes, in %|<p>The average percentage of the time during which the http agent poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,http agent poller,avg,busy]|
|Utilization of snmp poller data collector processes, in %|<p>The average percentage of the time during which the snmp poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,snmp poller,avg,busy]|
|Utilization of internal poller data collector processes, in %|<p>The average percentage of the time during which the internal poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,internal poller,avg,busy]|
|Utilization of browser poller data collector processes, in %|<p>The average percentage of the time during which the browser poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,browser poller,avg,busy]|
|Configuration cache, % used|<p>The availability statistics of Zabbix configuration cache. The percentage of used data buffer.</p>|Zabbix internal|zabbix[rcache,buffer,pused]|
|Zabbix proxy check|<p>Flag indicating whether it is a proxy or not.</p>|Zabbix internal|zabbix[triggers]<p>**Preprocessing**</p><ul><li><p>Check for not supported value: `any error`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>In range: ` -> 0`</p><p>⛔️Custom on fail: Set value to: `1`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Version|<p>The version of Zabbix proxy.</p>|Zabbix internal|zabbix[version]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|VMware cache, % used|<p>The availability statistics of Zabbix vmware cache. The percentage of used data buffer.</p>|Zabbix internal|zabbix[vmware,buffer,pused]|
|History write cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history buffer.</p><p>The history cache is used to store item values. A high number indicates database performance problems.</p>|Zabbix internal|zabbix[wcache,history,pused]|
|History index cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history index buffer.</p><p>The history index cache is used to index values stored in the history cache.</p>|Zabbix internal|zabbix[wcache,index,pused]|
|Proxy memory buffer, % used|<p>Statistics and availability of Zabbix proxy memory buffer usage statistics. Percentage of used proxy memory buffer.</p><p>Proxy memory buffer is used to store the new historical data and upload from it without accessing database.</p>|Zabbix internal|zabbix[proxy_buffer,buffer,pused]|
|Proxy buffer, state|<p>The current working state of proxy buffer where the new data is being stored. Possible values:</p><p></p><p>  0 - disk (also returned when memory buffer is disabled);</p><p>  1 - memory.</p>|Zabbix internal|zabbix[proxy_buffer,state,current]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|Proxy buffer, state changes|<p>The number of state changes between disk/memory buffer modes since proxy start.</p>|Zabbix internal|zabbix[proxy_buffer,state,changes]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|Number of processed values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The total number of values processed by Zabbix server or Zabbix proxy, except unsupported items.</p>|Zabbix internal|zabbix[wcache,values]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Number of processed numeric (unsigned) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (unsigned) values.</p>|Zabbix internal|zabbix[wcache,values,uint]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Number of processed numeric (float) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (float) values.</p>|Zabbix internal|zabbix[wcache,values,float]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Number of processed log values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed log values.</p>|Zabbix internal|zabbix[wcache,values,log]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Number of processed not supported values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of times the item processing resulted in an item becoming unsupported or remaining in that state.</p>|Zabbix internal|zabbix[wcache,values,not supported]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Number of processed character values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed character values.</p>|Zabbix internal|zabbix[wcache,values,str]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Number of processed text values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed text values.</p>|Zabbix internal|zabbix[wcache,values,text]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Preprocessing queue|<p>The number of values enqueued in the preprocessing queue.</p>|Zabbix internal|zabbix[preprocessing_queue]|
|Discovery queue|<p>The count of values enqueued in the discovery queue.</p>|Zabbix internal|zabbix[discovery_queue]|
|Values waiting to be sent|<p>The number of values in the proxy history table waiting to be sent to the server.</p>|Zabbix internal|zabbix[proxy_history]|
|Required VPS|<p>The required performance of a proxy (the number of values that need to be collected per second).</p>|Zabbix internal|zabbix[requiredperformance]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Uptime|<p>Uptime of the Zabbix proxy process in seconds.</p>|Zabbix internal|zabbix[uptime]|

### Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix proxy: More than 100 items have been missing data for over 10 minutes|<p>Indicates potential issues with network connectivity, agent failures, or unresponsive monitored resources that require attention.</p>|`min(/Zabbix proxy health/zabbix[queue,10m],10m)>100`|Warning|**Manual close**: Yes|
|Zabbix proxy: Utilization of data sender processes is high|<p>Indicates potential performance issues with the data sender, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,data sender,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"data sender"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of availability manager processes is high|<p>Indicates potential performance issues with the availability manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,availability manager,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"availability manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of configuration syncer processes is high|<p>Indicates potential performance issues with the configuration syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,configuration syncer,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"configuration syncer"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of discovery manager processes is high|<p>Indicates potential performance issues with the discovery manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,discovery manager,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"discovery manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of discovery worker processes is high|<p>Indicates potential performance issues with the discovery worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,discovery worker,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"discovery worker"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of ODBC poller processes is high|<p>Indicates potential performance issues with the ODBC poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,odbc poller,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"ODBC poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of history syncer processes is high|<p>Indicates potential performance issues with the history syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,history syncer,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"history syncer"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of housekeeper processes is high|<p>Indicates potential performance issues with the housekeeper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,housekeeper,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"housekeeper"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of http poller processes is high|<p>Indicates potential performance issues with the http poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,http poller,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"http poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of icmp pinger processes is high|<p>Indicates potential performance issues with the icmp pinger, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,icmp pinger,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"icmp pinger"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of ipmi manager processes is high|<p>Indicates potential performance issues with the ipmi manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,ipmi manager,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"ipmi manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of ipmi poller processes is high|<p>Indicates potential performance issues with the ipmi poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,ipmi poller,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"ipmi poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of java poller processes is high|<p>Indicates potential performance issues with the java poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,java poller,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"java poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of poller processes is high|<p>Indicates potential performance issues with the poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,poller,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of preprocessing worker processes is high|<p>Indicates potential performance issues with the preprocessing worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,preprocessing worker,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"preprocessing worker"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of preprocessing manager processes is high|<p>Indicates potential performance issues with the preprocessing manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,preprocessing manager,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"preprocessing manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of self-monitoring processes is high|<p>Indicates potential performance issues with the self-monitoring, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,self-monitoring,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"self-monitoring"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of snmp trapper processes is high|<p>Indicates potential performance issues with the snmp trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,snmp trapper,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"snmp trapper"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of task manager processes is high|<p>Indicates potential performance issues with the task manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,task manager,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"task manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of trapper processes is high|<p>Indicates potential performance issues with the trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,trapper,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"trapper"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of unreachable poller processes is high|<p>Indicates potential performance issues with the unreachable poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,unreachable poller,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"unreachable poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of vmware collector processes is high|<p>Indicates potential performance issues with the vmware collector, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,vmware collector,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"vmware collector"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of agent poller processes is high|<p>Indicates potential performance issues with the agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,agent poller,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"agent poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of http agent poller processes is high|<p>Indicates potential performance issues with the http agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,http agent poller,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"http agent poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of snmp poller processes is high|<p>Indicates potential performance issues with the snmp poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,snmp poller,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"snmp poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of internal poller processes is high|<p>Indicates potential performance issues with the internal poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,internal poller,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"internal poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of browser poller processes is high|<p>Indicates potential performance issues with the browser poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health/zabbix[process,browser poller,avg,busy],10m)>{$ZABBIX.PROXY.UTIL.MAX:"browser poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive configuration cache usage|<p>Consider increasing `CacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Zabbix proxy health/zabbix[rcache,buffer,pused],10m)>{$ZABBIX.PROXY.UTIL.MAX:"configuration cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Wrong template assigned|<p>Check that the template has been selected correctly.</p>|`last(/Zabbix proxy health/zabbix[triggers])=1`|Disaster|**Manual close**: Yes|
|Zabbix proxy: Version has changed|<p>Zabbix proxy version has changed. Acknowledge to close the problem manually.</p>|`last(/Zabbix proxy health/zabbix[version],#1)<>last(/Zabbix proxy health/zabbix[version],#2) and length(last(/Zabbix proxy health/zabbix[version]))>0`|Info|**Manual close**: Yes|
|Zabbix proxy: Excessive vmware cache usage|<p>Consider increasing `VMwareCacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Zabbix proxy health/zabbix[vmware,buffer,pused],10m)>{$ZABBIX.PROXY.UTIL.MAX:"vmware cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive history cache usage|<p>Consider increasing `HistoryCacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Zabbix proxy health/zabbix[wcache,history,pused],10m)>{$ZABBIX.PROXY.UTIL.MAX:"history cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive history index cache usage|<p>Consider increasing `HistoryIndexCacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Zabbix proxy health/zabbix[wcache,index,pused],10m)>{$ZABBIX.PROXY.UTIL.MAX:"index cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive proxy memory buffer usage|<p>Consider increasing ProxyMemoryBufferSize in the zabbix_proxy.conf configuration file.</p>|`max(/Zabbix proxy health/zabbix[proxy_buffer,buffer,pused],10m)>{$ZABBIX.PROXY.UTIL.MAX:"proxy buffer"}`|Average|**Manual close**: Yes|
|Zabbix proxy: {HOST.NAME} has been restarted|<p>Uptime is less than 10 minutes.</p>|`last(/Zabbix proxy health/zabbix[uptime])<10m`|Info|**Manual close**: Yes|

# Remote Zabbix proxy health

## Overview

This template is designed to monitor internal Zabbix metrics on the remote Zabbix proxy.

## Requirements

Zabbix version: 7.2 and higher.

## Tested versions

This template has been tested on:
- Zabbix proxy 7.2

## Configuration

> Zabbix should be configured according to the instructions in the [Templates out of the box](https://www.zabbix.com/documentation/7.2/manual/config/templates_out_of_the_box) section.

## Setup

Specify the address of the remote Zabbix proxy by updating the `{$ZABBIX.PROXY.ADDRESS}` and `{$ZABBIX.PROXY.PORT}` macros. Don't forget to adjust the `StatsAllowedIP` parameter in the remote proxy's configuration file to allow the collection of statistics.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$ZABBIX.PROXY.ADDRESS}|<p>IP/DNS/network mask list of proxies to be remotely queried (default is 127.0.0.1).</p>||
|{$ZABBIX.PROXY.PORT}|<p>Port of proxy to be remotely queried (default is 10051).</p>||
|{$ZABBIX.PROXY.UTIL.MAX}|<p>Default maximum threshold for percentage utilization triggers (use macro context for specification).</p>|`75`|
|{$ZABBIX.PROXY.UTIL.MIN}|<p>Default minimum threshold for percentage utilization triggers (use macro context for specification).</p>|`65`|
|{$ZABBIX.PROXY.NODATA_TIMEOUT}|<p>The time threshold after which statistics are considered unavailable. Used in trigger expressions.</p>|`5m`|

### Items

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Zabbix stats|<p>Zabbix server statistics master item.</p>|Zabbix internal|zabbix[stats,{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT}]|
|Queue over 10 minutes|<p>The number of monitored items in the queue that are delayed by at least 10 minutes.</p>|Zabbix internal|zabbix[stats,{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT},queue,10m]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.queue`</p></li></ul>|
|Queue|<p>The number of monitored items in the queue that are delayed by at least 6 seconds.</p>|Zabbix internal|zabbix[stats,{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT},queue]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.queue`</p></li></ul>|
|Utilization of data sender internal processes, in %|<p>The average percentage of the time during which the data sender processes have been busy for the last minute.</p>|Dependent item|process.data_sender.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['data sender'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes data sender not started`</p></li></ul>|
|Utilization of availability manager internal processes, in %|<p>The average percentage of the time during which the availability manager processes have been busy for the last minute.</p>|Dependent item|process.availability_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['availability manager'].busy.avg`</p></li></ul>|
|Utilization of configuration syncer internal processes, in %|<p>The average percentage of the time during which the configuration syncer processes have been busy for the last minute.</p>|Dependent item|process.configuration_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['configuration syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes configuration syncer not started`</p></li></ul>|
|Utilization of discovery manager internal processes, in %|<p>The average percentage of the time during which the discovery manager processes have been busy for the last minute.</p>|Dependent item|process.discovery_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['discovery manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "discovery manager" processes started.`</p></li></ul>|
|Utilization of discovery worker internal processes, in %|<p>The average percentage of the time during which the discovery worker processes have been busy for the last minute.</p>|Dependent item|process.discovery_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['discovery worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "discovery worker" processes started.`</p></li></ul>|
|Utilization of ODBC poller data collector processes, in %|<p>The average percentage of the time during which the ODBC poller processes have been busy for the last minute.</p>|Dependent item|process.odbc_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['odbc poller'].busy.avg`</p></li></ul>|
|Utilization of history syncer internal processes, in %|<p>The average percentage of the time during which the history syncer processes have been busy for the last minute.</p>|Dependent item|process.history_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['history syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes history syncer not started`</p></li></ul>|
|Utilization of housekeeper internal processes, in %|<p>The average percentage of the time during which the housekeeper processes have been busy for the last minute.</p>|Dependent item|process.housekeeper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['housekeeper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes housekeeper not started`</p></li></ul>|
|Utilization of http poller data collector processes, in %|<p>The average percentage of the time during which the http poller processes have been busy for the last minute.</p>|Dependent item|process.http_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['http poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes http poller not started`</p></li></ul>|
|Utilization of icmp pinger data collector processes, in %|<p>The average percentage of the time during which the icmp pinger processes have been busy for the last minute.</p>|Dependent item|process.icmp_pinger.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['icmp pinger'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes icmp pinger not started`</p></li></ul>|
|Utilization of ipmi manager internal processes, in %|<p>The average percentage of the time during which the ipmi manager processes have been busy for the last minute.</p>|Dependent item|process.ipmi_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['ipmi manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes ipmi manager not started`</p></li></ul>|
|Utilization of ipmi poller data collector processes, in %|<p>The average percentage of the time during which the ipmi poller processes have been busy for the last minute.</p>|Dependent item|process.ipmi_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['ipmi poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes ipmi poller not started`</p></li></ul>|
|Utilization of java poller data collector processes, in %|<p>The average percentage of the time during which the java poller processes have been busy for the last minute.</p>|Dependent item|process.java_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['java poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes java poller not started`</p></li></ul>|
|Utilization of poller data collector processes, in %|<p>The average percentage of the time during which the poller processes have been busy for the last minute.</p>|Dependent item|process.poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes poller not started`</p></li></ul>|
|Utilization of preprocessing worker internal processes, in %|<p>The average percentage of the time during which the preprocessing worker processes have been busy for the last minute.</p>|Dependent item|process.preprocessing_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['preprocessing worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes preprocessing worker not started`</p></li></ul>|
|Utilization of preprocessing manager internal processes, in %|<p>The average percentage of the time during which the preprocessing manager processes have been busy for the last minute.</p>|Dependent item|process.preprocessing_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['preprocessing manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes preprocessing manager not started`</p></li></ul>|
|Utilization of self-monitoring internal processes, in %|<p>The average percentage of the time during which the self-monitoring processes have been busy for the last minute.</p>|Dependent item|process.self-monitoring.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['self-monitoring'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes self-monitoring not started`</p></li></ul>|
|Utilization of snmp trapper data collector processes, in %|<p>The average percentage of the time during which the snmp trapper processes have been busy for the last minute.</p>|Dependent item|process.snmp_trapper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['snmp trapper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes snmp trapper not started`</p></li></ul>|
|Utilization of task manager internal processes, in %|<p>The average percentage of the time during which the task manager processes have been busy for the last minute.</p>|Dependent item|process.task_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['task manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes task manager not started`</p></li></ul>|
|Utilization of trapper data collector processes, in %|<p>The average percentage of the time during which the trapper processes have been busy for the last minute.</p>|Dependent item|process.trapper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['trapper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes trapper not started`</p></li></ul>|
|Utilization of unreachable poller data collector processes, in %|<p>The average percentage of the time during which the unreachable poller processes have been busy for the last minute.</p>|Dependent item|process.unreachable_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['unreachable poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes unreachable poller not started`</p></li></ul>|
|Utilization of vmware collector data collector processes, in %|<p>The average percentage of the time during which the vmware collector processes have been busy for the last minute.</p>|Dependent item|process.vmware_collector.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['vmware collector'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes vmware collector not started`</p></li></ul>|
|Utilization of agent poller data collector processes, in %|<p>The average percentage of the time during which the agent poller processes have been busy for the last minute.</p>|Dependent item|process.agent_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['agent poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes agent poller not started`</p></li></ul>|
|Utilization of http agent poller data collector processes, in %|<p>The average percentage of the time during which the http agent poller processes have been busy for the last minute.</p>|Dependent item|process.http_agent_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['http agent poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes http agent poller not started`</p></li></ul>|
|Utilization of snmp poller data collector processes, in %|<p>The average percentage of the time during which the snmp poller processes have been busy for the last minute.</p>|Dependent item|process.snmp_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['snmp poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes snmp poller not started`</p></li></ul>|
|Utilization of internal poller data collector processes, in %|<p>The average percentage of the time during which the internal poller processes have been busy for the last minute.</p>|Dependent item|process.internal_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['internal poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "internal poller" processes started.`</p></li></ul>|
|Utilization of browser poller data collector processes, in %|<p>The average percentage of the time during which the browser poller processes have been busy for the last minute.</p>|Dependent item|process.browser_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['browser poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "browser poller" processes started.`</p></li></ul>|
|Configuration cache, % used|<p>The availability statistics of Zabbix configuration cache. The percentage of used data buffer.</p>|Dependent item|rcache.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.rcache.pused`</p></li></ul>|
|Zabbix proxy check|<p>Flag indicating whether it is a proxy or not.</p>|Dependent item|proxy_check<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.triggers`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>In range: ` -> 0`</p><p>⛔️Custom on fail: Set value to: `1`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Version|<p>The version of Zabbix proxy.</p>|Dependent item|version<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.version`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|VMware cache, % used|<p>The availability statistics of Zabbix vmware cache. The percentage of used data buffer.</p>|Dependent item|vmware.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vmware.pused`</p><p>⛔️Custom on fail: Set error to: `No vmware collector processes started`</p></li></ul>|
|History write cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history buffer.</p><p>The history cache is used to store item values. A high number indicates database performance problems.</p>|Dependent item|wcache.history.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.history.pused`</p></li></ul>|
|History index cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history index buffer.</p><p>The history index cache is used to index values stored in the history cache.</p>|Dependent item|wcache.index.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.index.pused`</p></li></ul>|
|Proxy memory buffer, % used|<p>Statistics and availability of Zabbix proxy memory buffer usage statistics. Percentage of used proxy memory buffer.</p><p>Proxy memory buffer is used to store the new historical data and upload from it without accessing database.</p>|Dependent item|proxy_buffer.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.['proxy buffer'].memory.pused`</p><p>⛔️Custom on fail: Set error to: `Proxy memory buffer is disabled.`</p></li></ul>|
|Proxy buffer, state|<p>The current working state of proxy buffer where the new data is being stored. Possible values:</p><p></p><p>  0 - disk (also returned when memory buffer is disabled);</p><p>  1 - memory.</p>|Dependent item|proxy_buffer.state.current<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.['proxy buffer'].state`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|Proxy buffer, state changes|<p>The number of state changes between disk/memory buffer modes since proxy start.</p>|Dependent item|proxy_buffer.state.changes<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.['proxy buffer'].['state change']`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|Number of processed values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The total number of values processed by Zabbix server or Zabbix proxy, except unsupported items.</p>|Dependent item|wcache.values<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.all`</p></li><li>Change per second</li></ul>|
|Number of processed numeric (unsigned) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (unsigned) values.</p>|Dependent item|wcache.values.uint<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.uint`</p></li><li>Change per second</li></ul>|
|Number of processed numeric (float) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (float) values.</p>|Dependent item|wcache.values.float<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.float`</p></li><li>Change per second</li></ul>|
|Number of processed log values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed log values.</p>|Dependent item|wcache.values.log<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.log`</p></li><li>Change per second</li></ul>|
|Number of processed not supported values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of times the item processing resulted in an item becoming unsupported or remaining in that state.</p>|Dependent item|wcache.values.not_supported<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values['not supported']`</p></li><li>Change per second</li></ul>|
|Number of processed character values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed character values.</p>|Dependent item|wcache.values.str<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.str`</p></li><li>Change per second</li></ul>|
|Number of processed text values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed text values.</p>|Dependent item|wcache.values.text<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.text`</p></li><li>Change per second</li></ul>|
|Preprocessing queue|<p>The number of values enqueued in the preprocessing queue.</p>|Dependent item|preprocessing_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing_queue`</p></li></ul>|
|Discovery queue|<p>The count of values enqueued in the discovery queue.</p>|Dependent item|discovery_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.discovery_queue`</p><p>⛔️Custom on fail: Set error to: `No "discoverer" processes started. Please check "StartDiscoverers" parameter in the server configuration file.`</p></li></ul>|
|Required VPS|<p>The required performance of a proxy (the number of values that need to be collected per second).</p>|Dependent item|requiredperformance<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.requiredperformance`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Uptime|<p>Uptime of the Zabbix proxy process in seconds.</p>|Dependent item|uptime<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.uptime`</p></li></ul>|

### Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix proxy: More than 100 items have been missing data for over 10 minutes|<p>Indicates potential issues with network connectivity, agent failures, or unresponsive monitored resources that require attention.</p>|`min(/Remote Zabbix proxy health/zabbix[stats,{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT},queue,10m],10m)>100`|Warning|**Manual close**: Yes|
|Zabbix proxy: Utilization of data sender processes is high|<p>Indicates potential performance issues with the data sender, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.data_sender.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"data sender"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of availability manager processes is high|<p>Indicates potential performance issues with the availability manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.availability_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"availability manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of configuration syncer processes is high|<p>Indicates potential performance issues with the configuration syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.configuration_syncer.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"configuration syncer"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of discovery manager processes is high|<p>Indicates potential performance issues with the discovery manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.discovery_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"discovery manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of discovery worker processes is high|<p>Indicates potential performance issues with the discovery worker, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.discovery_worker.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"discovery worker"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of ODBC poller processes is high|<p>Indicates potential performance issues with the ODBC poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.odbc_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"ODBC poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of history syncer processes is high|<p>Indicates potential performance issues with the history syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.history_syncer.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"history syncer"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of housekeeper processes is high|<p>Indicates potential performance issues with the housekeeper, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.housekeeper.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"housekeeper"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of http poller processes is high|<p>Indicates potential performance issues with the http poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.http_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"http poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of icmp pinger processes is high|<p>Indicates potential performance issues with the icmp pinger, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.icmp_pinger.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"icmp pinger"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of ipmi manager processes is high|<p>Indicates potential performance issues with the ipmi manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.ipmi_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"ipmi manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of ipmi poller processes is high|<p>Indicates potential performance issues with the ipmi poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.ipmi_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"ipmi poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of java poller processes is high|<p>Indicates potential performance issues with the java poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.java_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"java poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of poller processes is high|<p>Indicates potential performance issues with the poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of preprocessing worker processes is high|<p>Indicates potential performance issues with the preprocessing worker, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.preprocessing_worker.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"preprocessing worker"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of preprocessing manager processes is high|<p>Indicates potential performance issues with the preprocessing manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.preprocessing_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"preprocessing manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of self-monitoring processes is high|<p>Indicates potential performance issues with the self-monitoring, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.self-monitoring.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"self-monitoring"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of snmp trapper processes is high|<p>Indicates potential performance issues with the snmp trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.snmp_trapper.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"snmp trapper"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of task manager processes is high|<p>Indicates potential performance issues with the task manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.task_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"task manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of trapper processes is high|<p>Indicates potential performance issues with the trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.trapper.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"trapper"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of unreachable poller processes is high|<p>Indicates potential performance issues with the unreachable poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.unreachable_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"unreachable poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of vmware collector processes is high|<p>Indicates potential performance issues with the vmware collector, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.vmware_collector.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"vmware collector"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of agent poller processes is high|<p>Indicates potential performance issues with the agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.agent_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"agent poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of http agent poller processes is high|<p>Indicates potential performance issues with the http agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.http_agent_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"http agent poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of snmp poller processes is high|<p>Indicates potential performance issues with the snmp poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.snmp_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"snmp poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of internal poller processes is high|<p>Indicates potential performance issues with the internal poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.internal_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"internal poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of browser poller processes is high|<p>Indicates potential performance issues with the browser poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix proxy health/process.browser_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"browser poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive configuration cache usage|<p>Consider increasing `CacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Remote Zabbix proxy health/rcache.buffer.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"configuration cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Failed to fetch stats data|<p>Zabbix has not received statistics data for `{$ZABBIX.PROXY.NODATA_TIMEOUT}`.</p>|`nodata(/Remote Zabbix proxy health/rcache.buffer.pused,{$ZABBIX.PROXY.NODATA_TIMEOUT})=1`|Warning||
|Zabbix proxy: Wrong template assigned|<p>Check that the template has been selected correctly.</p>|`last(/Remote Zabbix proxy health/proxy_check)=1`|Disaster|**Manual close**: Yes|
|Zabbix proxy: Version has changed|<p>Zabbix proxy version has changed. Acknowledge to close the problem manually.</p>|`last(/Remote Zabbix proxy health/version,#1)<>last(/Remote Zabbix proxy health/version,#2) and length(last(/Remote Zabbix proxy health/version))>0`|Info|**Manual close**: Yes|
|Zabbix proxy: Excessive vmware cache usage|<p>Consider increasing `VMwareCacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Remote Zabbix proxy health/vmware.buffer.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"vmware cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive history cache usage|<p>Consider increasing `HistoryCacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Remote Zabbix proxy health/wcache.history.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"history cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive history index cache usage|<p>Consider increasing `HistoryIndexCacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Remote Zabbix proxy health/wcache.index.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"index cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive proxy memory buffer usage|<p>Consider increasing ProxyMemoryBufferSize in the zabbix_proxy.conf configuration file.</p>|`max(/Remote Zabbix proxy health/proxy_buffer.buffer.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"proxy buffer"}`|Average|**Manual close**: Yes|
|Zabbix proxy: {HOST.NAME} has been restarted|<p>Uptime is less than 10 minutes.</p>|`last(/Remote Zabbix proxy health/uptime)<10m`|Info|**Manual close**: Yes|

# Zabbix proxy health by Zabbix agent

## Overview

This template is designed to monitor internal Zabbix metrics on the remote Zabbix proxy via the passive Zabbix agent.

## Requirements

Zabbix version: 7.2 and higher.

## Tested versions

This template has been tested on:
- Zabbix proxy 7.2

## Configuration

> Zabbix should be configured according to the instructions in the [Templates out of the box](https://www.zabbix.com/documentation/7.2/manual/config/templates_out_of_the_box) section.

## Setup

Specify the address of the remote Zabbix proxy by changing the `{$ZABBIX.PROXY.ADDRESS}` and `{$ZABBIX.PROXY.PORT}` macros. Don't forget to adjust the `StatsAllowedIP` parameter in the remote proxy's configuration file to allow the collection of statistics.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$ZABBIX.PROXY.ADDRESS}|<p>IP/DNS/network mask list of proxies to be remotely queried (default is 127.0.0.1).</p>||
|{$ZABBIX.PROXY.PORT}|<p>Port of proxy to be remotely queried (default is 10051).</p>||
|{$ZABBIX.PROXY.UTIL.MAX}|<p>Default maximum threshold for percentage utilization triggers (use macro context for specification).</p>|`75`|
|{$ZABBIX.PROXY.UTIL.MIN}|<p>Default minimum threshold for percentage utilization triggers (use macro context for specification).</p>|`65`|
|{$ZABBIX.PROXY.NODATA_TIMEOUT}|<p>The time threshold after which statistics are considered unavailable. Used in trigger expressions.</p>|`5m`|

### Items

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Zabbix stats|<p>The master item of Zabbix proxy statistics.</p>|Zabbix agent|zabbix.stats[{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT}]|
|Queue over 10 minutes|<p>The number of monitored items in the queue that are delayed by at least 10 minutes.</p>|Zabbix agent|zabbix.stats[{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT},queue,10m]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.queue`</p></li></ul>|
|Queue|<p>The number of monitored items in the queue that are delayed by at least 6 seconds.</p>|Zabbix agent|zabbix.stats[{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT},queue]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.queue`</p></li></ul>|
|Utilization of data sender internal processes, in %|<p>The average percentage of the time during which the data sender processes have been busy for the last minute.</p>|Dependent item|process.data_sender.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['data sender'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes data sender not started`</p></li></ul>|
|Utilization of availability manager internal processes, in %|<p>The average percentage of the time during which the availability manager processes have been busy for the last minute.</p>|Dependent item|process.availability_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['availability manager'].busy.avg`</p></li></ul>|
|Utilization of configuration syncer internal processes, in %|<p>The average percentage of the time during which the configuration syncer processes have been busy for the last minute.</p>|Dependent item|process.configuration_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['configuration syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes configuration syncer not started`</p></li></ul>|
|Utilization of discovery manager internal processes, in %|<p>The average percentage of the time during which the discovery manager processes have been busy for the last minute.</p>|Dependent item|process.discovery_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['discovery manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "discovery manager" processes started.`</p></li></ul>|
|Utilization of discovery worker internal processes, in %|<p>The average percentage of the time during which the discovery worker processes have been busy for the last minute.</p>|Dependent item|process.discovery_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['discovery worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "discovery worker" processes started.`</p></li></ul>|
|Utilization of ODBC poller data collector processes, in %|<p>The average percentage of the time during which the ODBC poller processes have been busy for the last minute.</p>|Dependent item|process.odbc_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['odbc poller'].busy.avg`</p></li></ul>|
|Utilization of history syncer internal processes, in %|<p>The average percentage of the time during which the history syncer processes have been busy for the last minute.</p>|Dependent item|process.history_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['history syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes history syncer not started`</p></li></ul>|
|Utilization of housekeeper internal processes, in %|<p>The average percentage of the time during which the housekeeper processes have been busy for the last minute.</p>|Dependent item|process.housekeeper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['housekeeper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes housekeeper not started`</p></li></ul>|
|Utilization of http poller data collector processes, in %|<p>The average percentage of the time during which the http poller processes have been busy for the last minute.</p>|Dependent item|process.http_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['http poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes http poller not started`</p></li></ul>|
|Utilization of icmp pinger data collector processes, in %|<p>The average percentage of the time during which the icmp pinger processes have been busy for the last minute.</p>|Dependent item|process.icmp_pinger.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['icmp pinger'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes icmp pinger not started`</p></li></ul>|
|Utilization of ipmi manager internal processes, in %|<p>The average percentage of the time during which the ipmi manager processes have been busy for the last minute.</p>|Dependent item|process.ipmi_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['ipmi manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes ipmi manager not started`</p></li></ul>|
|Utilization of ipmi poller data collector processes, in %|<p>The average percentage of the time during which the ipmi poller processes have been busy for the last minute.</p>|Dependent item|process.ipmi_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['ipmi poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes ipmi poller not started`</p></li></ul>|
|Utilization of java poller data collector processes, in %|<p>The average percentage of the time during which the java poller processes have been busy for the last minute.</p>|Dependent item|process.java_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['java poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes java poller not started`</p></li></ul>|
|Utilization of poller data collector processes, in %|<p>The average percentage of the time during which the poller processes have been busy for the last minute.</p>|Dependent item|process.poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes poller not started`</p></li></ul>|
|Utilization of preprocessing worker internal processes, in %|<p>The average percentage of the time during which the preprocessing worker processes have been busy for the last minute.</p>|Dependent item|process.preprocessing_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['preprocessing worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes preprocessing worker not started`</p></li></ul>|
|Utilization of preprocessing manager internal processes, in %|<p>The average percentage of the time during which the preprocessing manager processes have been busy for the last minute.</p>|Dependent item|process.preprocessing_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['preprocessing manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes preprocessing manager not started`</p></li></ul>|
|Utilization of self-monitoring internal processes, in %|<p>The average percentage of the time during which the self-monitoring processes have been busy for the last minute.</p>|Dependent item|process.self-monitoring.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['self-monitoring'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes self-monitoring not started`</p></li></ul>|
|Utilization of snmp trapper data collector processes, in %|<p>The average percentage of the time during which the snmp trapper processes have been busy for the last minute.</p>|Dependent item|process.snmp_trapper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['snmp trapper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes snmp trapper not started`</p></li></ul>|
|Utilization of task manager internal processes, in %|<p>The average percentage of the time during which the task manager processes have been busy for the last minute.</p>|Dependent item|process.task_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['task manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes task manager not started`</p></li></ul>|
|Utilization of trapper data collector processes, in %|<p>The average percentage of the time during which the trapper processes have been busy for the last minute.</p>|Dependent item|process.trapper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['trapper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes trapper not started`</p></li></ul>|
|Utilization of unreachable poller data collector processes, in %|<p>The average percentage of the time during which the unreachable poller processes have been busy for the last minute.</p>|Dependent item|process.unreachable_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['unreachable poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes unreachable poller not started`</p></li></ul>|
|Utilization of vmware collector data collector processes, in %|<p>The average percentage of the time during which the vmware collector processes have been busy for the last minute.</p>|Dependent item|process.vmware_collector.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['vmware collector'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes vmware collector not started`</p></li></ul>|
|Utilization of agent poller data collector processes, in %|<p>The average percentage of the time during which the agent poller processes have been busy for the last minute.</p>|Dependent item|process.agent_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['agent poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes agent poller not started`</p></li></ul>|
|Utilization of http agent poller data collector processes, in %|<p>The average percentage of the time during which the http agent poller processes have been busy for the last minute.</p>|Dependent item|process.http_agent_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['http agent poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes http agent poller not started`</p></li></ul>|
|Utilization of snmp poller data collector processes, in %|<p>The average percentage of the time during which the snmp poller processes have been busy for the last minute.</p>|Dependent item|process.snmp_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['snmp poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes snmp poller not started`</p></li></ul>|
|Utilization of internal poller data collector processes, in %|<p>The average percentage of the time during which the internal poller processes have been busy for the last minute.</p>|Dependent item|process.internal_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['internal poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "internal poller" processes started.`</p></li></ul>|
|Utilization of browser poller data collector processes, in %|<p>The average percentage of the time during which the browser poller processes have been busy for the last minute.</p>|Dependent item|process.browser_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['browser poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "browser poller" processes started.`</p></li></ul>|
|Configuration cache, % used|<p>The availability statistics of Zabbix configuration cache. The percentage of used data buffer.</p>|Dependent item|rcache.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.rcache.pused`</p></li></ul>|
|Zabbix proxy check|<p>Flag indicating whether it is a proxy or not.</p>|Dependent item|proxy_check<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.triggers`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>In range: ` -> 0`</p><p>⛔️Custom on fail: Set value to: `1`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Version|<p>The version of Zabbix proxy.</p>|Dependent item|version<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.version`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|VMware cache, % used|<p>The availability statistics of Zabbix vmware cache. The percentage of used data buffer.</p>|Dependent item|vmware.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vmware.pused`</p><p>⛔️Custom on fail: Set error to: `No vmware collector processes started`</p></li></ul>|
|History write cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history buffer.</p><p>The history cache is used to store item values. A high number indicates database performance problems.</p>|Dependent item|wcache.history.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.history.pused`</p></li></ul>|
|History index cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history index buffer.</p><p>The history index cache is used to index values stored in the history cache.</p>|Dependent item|wcache.index.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.index.pused`</p></li></ul>|
|Proxy memory buffer, % used|<p>Statistics and availability of Zabbix proxy memory buffer usage statistics. Percentage of used proxy memory buffer.</p><p>Proxy memory buffer is used to store the new historical data and upload from it without accessing database.</p>|Dependent item|proxy_buffer.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.['proxy buffer'].memory.pused`</p><p>⛔️Custom on fail: Set error to: `Proxy memory buffer is disabled.`</p></li></ul>|
|Proxy buffer, state|<p>The current working state of proxy buffer where the new data is being stored. Possible values:</p><p></p><p>  0 - disk (also returned when memory buffer is disabled);</p><p>  1 - memory.</p>|Dependent item|proxy_buffer.state.current<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.['proxy buffer'].state`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|Proxy buffer, state changes|<p>The number of state changes between disk/memory buffer modes since proxy start.</p>|Dependent item|proxy_buffer.state.changes<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.['proxy buffer'].['state change']`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|Number of processed values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The total number of values processed by Zabbix server or Zabbix proxy, except unsupported items.</p>|Dependent item|wcache.values<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.all`</p></li><li>Change per second</li></ul>|
|Number of processed numeric (unsigned) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (unsigned) values.</p>|Dependent item|wcache.values.uint<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.uint`</p></li><li>Change per second</li></ul>|
|Number of processed numeric (float) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (float) values.</p>|Dependent item|wcache.values.float<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.float`</p></li><li>Change per second</li></ul>|
|Number of processed log values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed log values.</p>|Dependent item|wcache.values.log<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.log`</p></li><li>Change per second</li></ul>|
|Number of processed not supported values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of times the item processing resulted in an item becoming unsupported or remaining in that state.</p>|Dependent item|wcache.values.not_supported<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values['not supported']`</p></li><li>Change per second</li></ul>|
|Number of processed character values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed character values.</p>|Dependent item|wcache.values.str<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.str`</p></li><li>Change per second</li></ul>|
|Number of processed text values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed text values.</p>|Dependent item|wcache.values.text<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.text`</p></li><li>Change per second</li></ul>|
|Preprocessing queue|<p>The number of values enqueued in the preprocessing queue.</p>|Dependent item|preprocessing_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing_queue`</p></li></ul>|
|Discovery queue|<p>The count of values enqueued in the discovery queue.</p>|Dependent item|discovery_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.discovery_queue`</p><p>⛔️Custom on fail: Set error to: `No "discoverer" processes started. Please check "StartDiscoverers" parameter in the server configuration file.`</p></li></ul>|
|Required VPS|<p>The required performance of a proxy (the number of values that need to be collected per second).</p>|Dependent item|requiredperformance<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.requiredperformance`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Uptime|<p>Uptime of the Zabbix proxy process in seconds.</p>|Dependent item|uptime<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.uptime`</p></li></ul>|

### Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix proxy: More than 100 items have been missing data for over 10 minutes|<p>Indicates potential issues with network connectivity, agent failures, or unresponsive monitored resources that require attention.</p>|`min(/Zabbix proxy health by Zabbix agent/zabbix.stats[{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT},queue,10m],10m)>100`|Warning|**Manual close**: Yes|
|Zabbix proxy: Utilization of data sender processes is high|<p>Indicates potential performance issues with the data sender, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.data_sender.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"data sender"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of availability manager processes is high|<p>Indicates potential performance issues with the availability manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.availability_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"availability manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of configuration syncer processes is high|<p>Indicates potential performance issues with the configuration syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.configuration_syncer.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"configuration syncer"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of discovery manager processes is high|<p>Indicates potential performance issues with the discovery manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.discovery_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"discovery manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of discovery worker processes is high|<p>Indicates potential performance issues with the discovery worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.discovery_worker.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"discovery worker"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of ODBC poller processes is high|<p>Indicates potential performance issues with the ODBC poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.odbc_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"ODBC poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of history syncer processes is high|<p>Indicates potential performance issues with the history syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.history_syncer.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"history syncer"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of housekeeper processes is high|<p>Indicates potential performance issues with the housekeeper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.housekeeper.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"housekeeper"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of http poller processes is high|<p>Indicates potential performance issues with the http poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.http_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"http poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of icmp pinger processes is high|<p>Indicates potential performance issues with the icmp pinger, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.icmp_pinger.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"icmp pinger"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of ipmi manager processes is high|<p>Indicates potential performance issues with the ipmi manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.ipmi_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"ipmi manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of ipmi poller processes is high|<p>Indicates potential performance issues with the ipmi poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.ipmi_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"ipmi poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of java poller processes is high|<p>Indicates potential performance issues with the java poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.java_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"java poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of poller processes is high|<p>Indicates potential performance issues with the poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of preprocessing worker processes is high|<p>Indicates potential performance issues with the preprocessing worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.preprocessing_worker.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"preprocessing worker"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of preprocessing manager processes is high|<p>Indicates potential performance issues with the preprocessing manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.preprocessing_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"preprocessing manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of self-monitoring processes is high|<p>Indicates potential performance issues with the self-monitoring, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.self-monitoring.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"self-monitoring"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of snmp trapper processes is high|<p>Indicates potential performance issues with the snmp trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.snmp_trapper.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"snmp trapper"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of task manager processes is high|<p>Indicates potential performance issues with the task manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.task_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"task manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of trapper processes is high|<p>Indicates potential performance issues with the trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.trapper.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"trapper"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of unreachable poller processes is high|<p>Indicates potential performance issues with the unreachable poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.unreachable_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"unreachable poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of vmware collector processes is high|<p>Indicates potential performance issues with the vmware collector, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.vmware_collector.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"vmware collector"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of agent poller processes is high|<p>Indicates potential performance issues with the agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.agent_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"agent poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of http agent poller processes is high|<p>Indicates potential performance issues with the http agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.http_agent_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"http agent poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of snmp poller processes is high|<p>Indicates potential performance issues with the snmp poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.snmp_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"snmp poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of internal poller processes is high|<p>Indicates potential performance issues with the internal poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.internal_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"internal poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of browser poller processes is high|<p>Indicates potential performance issues with the browser poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent/process.browser_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"browser poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive configuration cache usage|<p>Consider increasing `CacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Zabbix proxy health by Zabbix agent/rcache.buffer.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"configuration cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Failed to fetch stats data|<p>Zabbix has not received statistics data for `{$ZABBIX.PROXY.NODATA_TIMEOUT}`.</p>|`nodata(/Zabbix proxy health by Zabbix agent/rcache.buffer.pused,{$ZABBIX.PROXY.NODATA_TIMEOUT})=1`|Warning||
|Zabbix proxy: Wrong template assigned|<p>Check that the template has been selected correctly.</p>|`last(/Zabbix proxy health by Zabbix agent/proxy_check)=1`|Disaster|**Manual close**: Yes|
|Zabbix proxy: Version has changed|<p>Zabbix proxy version has changed. Acknowledge to close the problem manually.</p>|`last(/Zabbix proxy health by Zabbix agent/version,#1)<>last(/Zabbix proxy health by Zabbix agent/version,#2) and length(last(/Zabbix proxy health by Zabbix agent/version))>0`|Info|**Manual close**: Yes|
|Zabbix proxy: Excessive vmware cache usage|<p>Consider increasing `VMwareCacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Zabbix proxy health by Zabbix agent/vmware.buffer.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"vmware cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive history cache usage|<p>Consider increasing `HistoryCacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Zabbix proxy health by Zabbix agent/wcache.history.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"history cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive history index cache usage|<p>Consider increasing `HistoryIndexCacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Zabbix proxy health by Zabbix agent/wcache.index.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"index cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive proxy memory buffer usage|<p>Consider increasing ProxyMemoryBufferSize in the zabbix_proxy.conf configuration file.</p>|`max(/Zabbix proxy health by Zabbix agent/proxy_buffer.buffer.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"proxy buffer"}`|Average|**Manual close**: Yes|
|Zabbix proxy: {HOST.NAME} has been restarted|<p>Uptime is less than 10 minutes.</p>|`last(/Zabbix proxy health by Zabbix agent/uptime)<10m`|Info|**Manual close**: Yes|

# Zabbix proxy health by Zabbix agent active

## Overview

This template is designed to monitor internal Zabbix metrics on the remote Zabbix proxy via the active Zabbix agent.

## Requirements

Zabbix version: 7.2 and higher.

## Tested versions

This template has been tested on:
- Zabbix proxy 7.2

## Configuration

> Zabbix should be configured according to the instructions in the [Templates out of the box](https://www.zabbix.com/documentation/7.2/manual/config/templates_out_of_the_box) section.

## Setup

Specify the address of the remote Zabbix proxy by changing the `{$ZABBIX.PROXY.ADDRESS}` and `{$ZABBIX.PROXY.PORT}` macros. Don't forget to adjust the `StatsAllowedIP` parameter in the remote proxy's configuration file to allow the collection of statistics.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$ZABBIX.PROXY.ADDRESS}|<p>IP/DNS/network mask list of proxies to be remotely queried (default is 127.0.0.1).</p>||
|{$ZABBIX.PROXY.PORT}|<p>Port of proxy to be remotely queried (default is 10051).</p>||
|{$ZABBIX.PROXY.UTIL.MAX}|<p>Default maximum threshold for percentage utilization triggers (use macro context for specification).</p>|`75`|
|{$ZABBIX.PROXY.UTIL.MIN}|<p>Default minimum threshold for percentage utilization triggers (use macro context for specification).</p>|`65`|
|{$ZABBIX.PROXY.NODATA_TIMEOUT}|<p>The time threshold after which statistics are considered unavailable. Used in trigger expressions.</p>|`5m`|

### Items

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Zabbix stats|<p>The master item of Zabbix proxy statistics.</p>|Zabbix agent (active)|zabbix.stats[{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT}]|
|Queue over 10 minutes|<p>The number of monitored items in the queue that are delayed by at least 10 minutes.</p>|Zabbix agent (active)|zabbix.stats[{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT},queue,10m]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.queue`</p></li></ul>|
|Queue|<p>The number of monitored items in the queue that are delayed by at least 6 seconds.</p>|Zabbix agent (active)|zabbix.stats[{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT},queue]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.queue`</p></li></ul>|
|Utilization of data sender internal processes, in %|<p>The average percentage of the time during which the data sender processes have been busy for the last minute.</p>|Dependent item|process.data_sender.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['data sender'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes data sender not started`</p></li></ul>|
|Utilization of availability manager internal processes, in %|<p>The average percentage of the time during which the availability manager processes have been busy for the last minute.</p>|Dependent item|process.availability_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['availability manager'].busy.avg`</p></li></ul>|
|Utilization of configuration syncer internal processes, in %|<p>The average percentage of the time during which the configuration syncer processes have been busy for the last minute.</p>|Dependent item|process.configuration_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['configuration syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes configuration syncer not started`</p></li></ul>|
|Utilization of discovery manager internal processes, in %|<p>The average percentage of the time during which the discovery manager processes have been busy for the last minute.</p>|Dependent item|process.discovery_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['discovery manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "discovery manager" processes started.`</p></li></ul>|
|Utilization of discovery worker internal processes, in %|<p>The average percentage of the time during which the discovery worker processes have been busy for the last minute.</p>|Dependent item|process.discovery_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['discovery worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "discovery worker" processes started.`</p></li></ul>|
|Utilization of ODBC poller data collector processes, in %|<p>The average percentage of the time during which the ODBC poller processes have been busy for the last minute.</p>|Dependent item|process.odbc_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['odbc poller'].busy.avg`</p></li></ul>|
|Utilization of history syncer internal processes, in %|<p>The average percentage of the time during which the history syncer processes have been busy for the last minute.</p>|Dependent item|process.history_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['history syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes history syncer not started`</p></li></ul>|
|Utilization of housekeeper internal processes, in %|<p>The average percentage of the time during which the housekeeper processes have been busy for the last minute.</p>|Dependent item|process.housekeeper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['housekeeper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes housekeeper not started`</p></li></ul>|
|Utilization of http poller data collector processes, in %|<p>The average percentage of the time during which the http poller processes have been busy for the last minute.</p>|Dependent item|process.http_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['http poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes http poller not started`</p></li></ul>|
|Utilization of icmp pinger data collector processes, in %|<p>The average percentage of the time during which the icmp pinger processes have been busy for the last minute.</p>|Dependent item|process.icmp_pinger.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['icmp pinger'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes icmp pinger not started`</p></li></ul>|
|Utilization of ipmi manager internal processes, in %|<p>The average percentage of the time during which the ipmi manager processes have been busy for the last minute.</p>|Dependent item|process.ipmi_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['ipmi manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes ipmi manager not started`</p></li></ul>|
|Utilization of ipmi poller data collector processes, in %|<p>The average percentage of the time during which the ipmi poller processes have been busy for the last minute.</p>|Dependent item|process.ipmi_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['ipmi poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes ipmi poller not started`</p></li></ul>|
|Utilization of java poller data collector processes, in %|<p>The average percentage of the time during which the java poller processes have been busy for the last minute.</p>|Dependent item|process.java_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['java poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes java poller not started`</p></li></ul>|
|Utilization of poller data collector processes, in %|<p>The average percentage of the time during which the poller processes have been busy for the last minute.</p>|Dependent item|process.poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes poller not started`</p></li></ul>|
|Utilization of preprocessing worker internal processes, in %|<p>The average percentage of the time during which the preprocessing worker processes have been busy for the last minute.</p>|Dependent item|process.preprocessing_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['preprocessing worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes preprocessing worker not started`</p></li></ul>|
|Utilization of preprocessing manager internal processes, in %|<p>The average percentage of the time during which the preprocessing manager processes have been busy for the last minute.</p>|Dependent item|process.preprocessing_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['preprocessing manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes preprocessing manager not started`</p></li></ul>|
|Utilization of self-monitoring internal processes, in %|<p>The average percentage of the time during which the self-monitoring processes have been busy for the last minute.</p>|Dependent item|process.self-monitoring.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['self-monitoring'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes self-monitoring not started`</p></li></ul>|
|Utilization of snmp trapper data collector processes, in %|<p>The average percentage of the time during which the snmp trapper processes have been busy for the last minute.</p>|Dependent item|process.snmp_trapper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['snmp trapper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes snmp trapper not started`</p></li></ul>|
|Utilization of task manager internal processes, in %|<p>The average percentage of the time during which the task manager processes have been busy for the last minute.</p>|Dependent item|process.task_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['task manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes task manager not started`</p></li></ul>|
|Utilization of trapper data collector processes, in %|<p>The average percentage of the time during which the trapper processes have been busy for the last minute.</p>|Dependent item|process.trapper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['trapper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes trapper not started`</p></li></ul>|
|Utilization of unreachable poller data collector processes, in %|<p>The average percentage of the time during which the unreachable poller processes have been busy for the last minute.</p>|Dependent item|process.unreachable_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['unreachable poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes unreachable poller not started`</p></li></ul>|
|Utilization of vmware collector data collector processes, in %|<p>The average percentage of the time during which the vmware collector processes have been busy for the last minute.</p>|Dependent item|process.vmware_collector.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['vmware collector'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes vmware collector not started`</p></li></ul>|
|Utilization of agent poller data collector processes, in %|<p>The average percentage of the time during which the agent poller processes have been busy for the last minute.</p>|Dependent item|process.agent_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['agent poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes agent poller not started`</p></li></ul>|
|Utilization of http agent poller data collector processes, in %|<p>The average percentage of the time during which the http agent poller processes have been busy for the last minute.</p>|Dependent item|process.http_agent_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['http agent poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes http agent poller not started`</p></li></ul>|
|Utilization of snmp poller data collector processes, in %|<p>The average percentage of the time during which the snmp poller processes have been busy for the last minute.</p>|Dependent item|process.snmp_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['snmp poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes snmp poller not started`</p></li></ul>|
|Utilization of internal poller data collector processes, in %|<p>The average percentage of the time during which the internal poller processes have been busy for the last minute.</p>|Dependent item|process.internal_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['internal poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "internal poller" processes started.`</p></li></ul>|
|Utilization of browser poller data collector processes, in %|<p>The average percentage of the time during which the browser poller processes have been busy for the last minute.</p>|Dependent item|process.browser_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['browser poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "browser poller" processes started.`</p></li></ul>|
|Configuration cache, % used|<p>The availability statistics of Zabbix configuration cache. The percentage of used data buffer.</p>|Dependent item|rcache.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.rcache.pused`</p></li></ul>|
|Zabbix proxy check|<p>Flag indicating whether it is a proxy or not.</p>|Dependent item|proxy_check<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.triggers`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>In range: ` -> 0`</p><p>⛔️Custom on fail: Set value to: `1`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Version|<p>The version of Zabbix proxy.</p>|Dependent item|version<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.version`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|VMware cache, % used|<p>The availability statistics of Zabbix vmware cache. The percentage of used data buffer.</p>|Dependent item|vmware.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vmware.pused`</p><p>⛔️Custom on fail: Set error to: `No vmware collector processes started`</p></li></ul>|
|History write cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history buffer.</p><p>The history cache is used to store item values. A high number indicates database performance problems.</p>|Dependent item|wcache.history.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.history.pused`</p></li></ul>|
|History index cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history index buffer.</p><p>The history index cache is used to index values stored in the history cache.</p>|Dependent item|wcache.index.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.index.pused`</p></li></ul>|
|Proxy memory buffer, % used|<p>Statistics and availability of Zabbix proxy memory buffer usage statistics. Percentage of used proxy memory buffer.</p><p>Proxy memory buffer is used to store the new historical data and upload from it without accessing database.</p>|Dependent item|proxy_buffer.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.['proxy buffer'].memory.pused`</p><p>⛔️Custom on fail: Set error to: `Proxy memory buffer is disabled.`</p></li></ul>|
|Proxy buffer, state|<p>The current working state of proxy buffer where the new data is being stored. Possible values:</p><p></p><p>  0 - disk (also returned when memory buffer is disabled);</p><p>  1 - memory.</p>|Dependent item|proxy_buffer.state.current<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.['proxy buffer'].state`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|Proxy buffer, state changes|<p>The number of state changes between disk/memory buffer modes since proxy start.</p>|Dependent item|proxy_buffer.state.changes<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.['proxy buffer'].['state change']`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|Number of processed values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The total number of values processed by Zabbix server or Zabbix proxy, except unsupported items.</p>|Dependent item|wcache.values<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.all`</p></li><li>Change per second</li></ul>|
|Number of processed numeric (unsigned) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (unsigned) values.</p>|Dependent item|wcache.values.uint<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.uint`</p></li><li>Change per second</li></ul>|
|Number of processed numeric (float) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (float) values.</p>|Dependent item|wcache.values.float<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.float`</p></li><li>Change per second</li></ul>|
|Number of processed log values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed log values.</p>|Dependent item|wcache.values.log<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.log`</p></li><li>Change per second</li></ul>|
|Number of processed not supported values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of times the item processing resulted in an item becoming unsupported or remaining in that state.</p>|Dependent item|wcache.values.not_supported<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values['not supported']`</p></li><li>Change per second</li></ul>|
|Number of processed character values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed character values.</p>|Dependent item|wcache.values.str<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.str`</p></li><li>Change per second</li></ul>|
|Number of processed text values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed text values.</p>|Dependent item|wcache.values.text<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.text`</p></li><li>Change per second</li></ul>|
|Preprocessing queue|<p>The number of values enqueued in the preprocessing queue.</p>|Dependent item|preprocessing_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing_queue`</p></li></ul>|
|Discovery queue|<p>The count of values enqueued in the discovery queue.</p>|Dependent item|discovery_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.discovery_queue`</p><p>⛔️Custom on fail: Set error to: `No "discoverer" processes started. Please check "StartDiscoverers" parameter in the server configuration file.`</p></li></ul>|
|Required VPS|<p>The required performance of a proxy (the number of values that need to be collected per second).</p>|Dependent item|requiredperformance<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.requiredperformance`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Uptime|<p>Uptime of the Zabbix proxy process in seconds.</p>|Dependent item|uptime<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.uptime`</p></li></ul>|

### Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix proxy: More than 100 items have been missing data for over 10 minutes|<p>Indicates potential issues with network connectivity, agent failures, or unresponsive monitored resources that require attention.</p>|`min(/Zabbix proxy health by Zabbix agent active/zabbix.stats[{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT},queue,10m],10m)>100`|Warning|**Manual close**: Yes|
|Zabbix proxy: Utilization of data sender processes is high|<p>Indicates potential performance issues with the data sender, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.data_sender.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"data sender"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of availability manager processes is high|<p>Indicates potential performance issues with the availability manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.availability_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"availability manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of configuration syncer processes is high|<p>Indicates potential performance issues with the configuration syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.configuration_syncer.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"configuration syncer"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of discovery manager processes is high|<p>Indicates potential performance issues with the discovery manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.discovery_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"discovery manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of discovery worker processes is high|<p>Indicates potential performance issues with the discovery worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.discovery_worker.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"discovery worker"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of ODBC poller processes is high|<p>Indicates potential performance issues with the ODBC poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.odbc_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"ODBC poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of history syncer processes is high|<p>Indicates potential performance issues with the history syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.history_syncer.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"history syncer"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of housekeeper processes is high|<p>Indicates potential performance issues with the housekeeper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.housekeeper.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"housekeeper"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of http poller processes is high|<p>Indicates potential performance issues with the http poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.http_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"http poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of icmp pinger processes is high|<p>Indicates potential performance issues with the icmp pinger, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.icmp_pinger.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"icmp pinger"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of ipmi manager processes is high|<p>Indicates potential performance issues with the ipmi manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.ipmi_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"ipmi manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of ipmi poller processes is high|<p>Indicates potential performance issues with the ipmi poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.ipmi_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"ipmi poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of java poller processes is high|<p>Indicates potential performance issues with the java poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.java_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"java poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of poller processes is high|<p>Indicates potential performance issues with the poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of preprocessing worker processes is high|<p>Indicates potential performance issues with the preprocessing worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.preprocessing_worker.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"preprocessing worker"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of preprocessing manager processes is high|<p>Indicates potential performance issues with the preprocessing manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.preprocessing_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"preprocessing manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of self-monitoring processes is high|<p>Indicates potential performance issues with the self-monitoring, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.self-monitoring.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"self-monitoring"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of snmp trapper processes is high|<p>Indicates potential performance issues with the snmp trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.snmp_trapper.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"snmp trapper"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of task manager processes is high|<p>Indicates potential performance issues with the task manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.task_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"task manager"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of trapper processes is high|<p>Indicates potential performance issues with the trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.trapper.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"trapper"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of unreachable poller processes is high|<p>Indicates potential performance issues with the unreachable poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.unreachable_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"unreachable poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of vmware collector processes is high|<p>Indicates potential performance issues with the vmware collector, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.vmware_collector.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"vmware collector"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of agent poller processes is high|<p>Indicates potential performance issues with the agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.agent_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"agent poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of http agent poller processes is high|<p>Indicates potential performance issues with the http agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.http_agent_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"http agent poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of snmp poller processes is high|<p>Indicates potential performance issues with the snmp poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.snmp_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"snmp poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of internal poller processes is high|<p>Indicates potential performance issues with the internal poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.internal_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"internal poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Utilization of browser poller processes is high|<p>Indicates potential performance issues with the browser poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix proxy health by Zabbix agent active/process.browser_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"browser poller"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive configuration cache usage|<p>Consider increasing `CacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Zabbix proxy health by Zabbix agent active/rcache.buffer.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"configuration cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Failed to fetch stats data|<p>Zabbix has not received statistics data for `{$ZABBIX.PROXY.NODATA_TIMEOUT}`.</p>|`nodata(/Zabbix proxy health by Zabbix agent active/rcache.buffer.pused,{$ZABBIX.PROXY.NODATA_TIMEOUT})=1`|Warning||
|Zabbix proxy: Wrong template assigned|<p>Check that the template has been selected correctly.</p>|`last(/Zabbix proxy health by Zabbix agent active/proxy_check)=1`|Disaster|**Manual close**: Yes|
|Zabbix proxy: Version has changed|<p>Zabbix proxy version has changed. Acknowledge to close the problem manually.</p>|`last(/Zabbix proxy health by Zabbix agent active/version,#1)<>last(/Zabbix proxy health by Zabbix agent active/version,#2) and length(last(/Zabbix proxy health by Zabbix agent active/version))>0`|Info|**Manual close**: Yes|
|Zabbix proxy: Excessive vmware cache usage|<p>Consider increasing `VMwareCacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Zabbix proxy health by Zabbix agent active/vmware.buffer.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"vmware cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive history cache usage|<p>Consider increasing `HistoryCacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Zabbix proxy health by Zabbix agent active/wcache.history.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"history cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive history index cache usage|<p>Consider increasing `HistoryIndexCacheSize` in the `zabbix_proxy.conf` configuration file.</p>|`max(/Zabbix proxy health by Zabbix agent active/wcache.index.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"index cache"}`|Average|**Manual close**: Yes|
|Zabbix proxy: Excessive proxy memory buffer usage|<p>Consider increasing ProxyMemoryBufferSize in the zabbix_proxy.conf configuration file.</p>|`max(/Zabbix proxy health by Zabbix agent active/proxy_buffer.buffer.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX:"proxy buffer"}`|Average|**Manual close**: Yes|
|Zabbix proxy: {HOST.NAME} has been restarted|<p>Uptime is less than 10 minutes.</p>|`last(/Zabbix proxy health by Zabbix agent active/uptime)<10m`|Info|**Manual close**: Yes|

## Feedback

Please report any issues with the template at [`https://support.zabbix.com`](https://support.zabbix.com)

You can also provide feedback, discuss the template, or ask for help at [`ZABBIX forums`](https://www.zabbix.com/forum/zabbix-suggestions-and-feedback)

