
# Microsoft 365 reports by HTTP

## Overview

- This template is designed to monitor Microsoft 365 by HTTP. It works without any external scripts and uses script items.
- The template uses endpoints in the Microsoft Graph API to gather daily metrics from weekly reports.
- The template is meant to be used as a long-term trend monitoring tool.

## Requirements

Zabbix version: 7.2 and higher.

## Tested versions

This template has been tested on:
- Microsoft 365

## Configuration

> Zabbix should be configured according to the instructions in the [Templates out of the box](https://www.zabbix.com/documentation/7.2/manual/config/templates_out_of_the_box) section.

## Setup

1. Register the app with your Microsoft Entra ID.
2. Configure Microsoft Graph application permissions on the app ID:
    - `Reports.Read.All` - required for app usage and activity metrics
    - `ServiceHealth.Read.All` - required for service discovery and service status metrics
3. Request administrator consent.
4. Configure the macros: `{$MS365.APP.ID}`, `{$MS365.PASSWORD}`, `{$MS365.TENANT.ID}`.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$MS365.APP.ID}|<p>Microsoft application ID.</p>||
|{$MS365.PASSWORD}|<p>The secret for the registered Microsoft application.</p>||
|{$MS365.TENANT.ID}|<p>Microsoft tenant ID.</p>||
|{$MS365.SERVICE.NAME.MATCHES}|<p>This macro is used in the Microsoft cloud service discovery rule.</p>|`.*`|
|{$MS365.SERVICE.NAME.NOT.MATCHES}|<p>This macro is used in the Microsoft cloud service discovery rule.</p>|`CHANGE_IF_NEEDED`|
|{$MS365.HTTP.PROXY}|<p>Sets the HTTP proxy value. If this macro is empty, then no proxy is used.</p>||
|{$MS365.API.TIMEOUT}|<p>API response timeout.</p>|`15s`|

### Items

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Services: Get services|<p>The list of Microsoft cloud services and their health statuses subscribed by a tenant.</p><p>More information:</p><p>https://learn.microsoft.com/en-us/graph/api/servicehealth-get?view=graph-rest-beta&tabs=http</p>|Script|ms365.services.get|
|Teams: Get reports|<p>Accumulated data from the Microsoft Graph API "reports" endpoints.</p><p>More information:</p><p>https://learn.microsoft.com/en-us/graph/api/resources/report?view=graph-rest-beta</p>|Script|ms365.teams.reports.get|
|Outlook: Get reports|<p>Accumulated data from the Microsoft Graph API "reports" endpoints.</p><p>More information:</p><p>https://learn.microsoft.com/en-us/graph/api/resources/report?view=graph-rest-beta</p>|Script|ms365.outlook.reports.get|
|OneDrive: Get reports|<p>Accumulated data from the Microsoft Graph API "reports" endpoints.</p><p>More information:</p><p>https://learn.microsoft.com/en-us/graph/api/resources/report?view=graph-rest-beta</p>|Script|ms365.onedrive.reports.get|
|SharePoint: Get reports|<p>Accumulated data from the Microsoft Graph API "reports" endpoints.</p><p>More information:</p><p>https://learn.microsoft.com/en-us/graph/api/resources/report?view=graph-rest-beta</p>|Script|ms365.sharepoint.reports.get|
|Apps: Get reports|<p>Accumulated data from the Microsoft Graph API "reports" endpoints.</p><p>More information:</p><p>https://learn.microsoft.com/en-us/graph/api/resources/report?view=graph-rest-beta</p>|Script|ms365.apps.reports.get|
|Services: Get errors|<p>A list of errors from API requests for Services metrics.</p>|Dependent item|ms365.services.errors<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.error`</p><p>⛔️Custom on fail: Set value to: ``</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|Teams: Get errors|<p>A list of errors from API requests for Teams metrics.</p>|Dependent item|ms365.teams.errors<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.error`</p><p>⛔️Custom on fail: Set value to: ``</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|Outlook: Get errors|<p>A list of errors from API requests for Outlook metrics.</p>|Dependent item|ms365.outlook.errors<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.error`</p><p>⛔️Custom on fail: Set value to: ``</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|OneDrive: Get errors|<p>A list of errors from API requests for OneDrive metrics.</p>|Dependent item|ms365.onedrive.errors<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.error`</p><p>⛔️Custom on fail: Set value to: ``</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|SharePoint: Get errors|<p>A list of errors from API requests for SharePoint metrics.</p>|Dependent item|ms365.sharepoint.errors<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.error`</p><p>⛔️Custom on fail: Set value to: ``</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|Apps: Get errors|<p>A list of errors from API requests for Apps metrics.</p>|Dependent item|ms365.apps.errors<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.error`</p><p>⛔️Custom on fail: Set value to: ``</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|Teams: Device usage (users), web client|<p>The number of unique licensed Microsoft Teams users recorded via the Teams web client over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.users.web<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getTeamsDeviceUsageDistributionUserCounts[0].web`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (users), Android|<p>The number of unique licensed Microsoft Teams users recorded via the Teams mobile client for Android over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.users.android<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (users), iOS|<p>The number of unique licensed Microsoft Teams users recorded via the Teams mobile client for iOS over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.users.ios<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getTeamsDeviceUsageDistributionUserCounts[0].ios`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (users), Mac|<p>The number of unique licensed Microsoft Teams users recorded via the Teams desktop client on a macOS computer over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.users.mac<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getTeamsDeviceUsageDistributionUserCounts[0].mac`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (users), Windows|<p>The number of unique licensed Microsoft Teams users recorded via the Teams desktop client on a Windows-based computer over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.users.windows<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (users), Chrome OS|<p>The number of unique licensed Microsoft Teams users recorded via the Teams desktop client on a ChromeOS computer over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.users.chromeos<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (users), Linux|<p>The number of unique licensed Microsoft Teams users recorded via the Teams desktop client on a Linux computer over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.users.linux<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getTeamsDeviceUsageDistributionUserCounts[0].linux`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (total), report date|<p>The date of the report of device usage of both licensed and non-licensed users.</p>|Dependent item|ms365.teams.device.total.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (total), web client|<p>The number of unique Microsoft Teams users (licensed or non-licensed) recorded via the Teams web client over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.total.web<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (total), Android|<p>The number of unique Microsoft Teams users (licensed or non-licensed) recorded via the Teams mobile client for Android over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.total.android<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (total), iOS|<p>The number of unique Microsoft Teams users (licensed or non-licensed) recorded via the Teams mobile client for iOS over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.total.ios<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (total), Mac|<p>The number of unique Microsoft Teams users (licensed or non-licensed) recorded via the Teams desktop client on a macOS computer over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.total.mac<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (total), Windows|<p>The number of unique Microsoft Teams users (licensed or non-licensed) recorded via the Teams desktop client on a Windows-based computer over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.total.windows<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (total), Chrome OS|<p>The number of unique Microsoft Teams users (licensed or non-licensed) recorded via the Teams desktop client on a ChromeOS computer over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.total.chromeos<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (total), Linux|<p>The number of unique Microsoft Teams users (licensed or non-licensed) recorded via the Teams desktop client on a Linux computer over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.total.linux<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (guests), web client|<p>The number of unique non-licensed Microsoft Teams users (guests) recorded via the Teams web client over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.guests.web<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (guests), Android|<p>The number of unique non-licensed Microsoft Teams users (guests) recorded via the Teams mobile client for Android over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.guests.android<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (guests), iOS|<p>The number of unique non-licensed Microsoft Teams users (guests) recorded via the Teams mobile client for iOS over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.guests.ios<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (guests), Mac|<p>The number of unique non-licensed Microsoft Teams users (guests) recorded via the Teams desktop client on a macOS computer over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.guests.mac<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (guests), Windows|<p>The number of unique non-licensed Microsoft Teams users (guests) recorded via the Teams desktop client on a Windows-based computer over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.guests.windows<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (guests), Chrome OS|<p>The number of unique non-licensed Microsoft Teams users (guests) recorded via the Teams desktop client on a ChromeOS computer over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.guests.chromeos<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Device usage (guests), Linux|<p>The number of unique non-licensed Microsoft Teams users (guests) recorded via the Teams desktop client on a Linux computer over the week before the report refresh date.</p>|Dependent item|ms365.teams.device.guests.linux<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User activity, report date|<p>The date of the report of the number of activities by all users.</p>|Dependent item|ms365.teams.activity.user.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User activity, team chat messages|<p>The number of unique messages that were posted in team chats by licensed or non-licensed Microsoft Teams users during the week before the report refresh date. This includes original posts and replies.</p>|Dependent item|ms365.teams.activity.user.messages.in_team<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User activity, private chat messages|<p>The number of unique messages that were posted in private chats by licensed or non-licensed Microsoft Teams users during the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.user.messages.private<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User activity, calls|<p>The number of 1:1 calls licensed or non-licensed Microsoft Teams users participated in during the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.user.calls<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User activity, meetings|<p>The sum of the scheduled one-time and recurring, ad-hoc, and unclassified meetings licensed or non-licensed Microsoft Teams users participated in during the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.user.meetings.total<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User activity, organized meetings|<p>The sum of the scheduled one-time and recurring, ad-hoc, and unclassified meetings organized by licensed or non-licensed Microsoft Teams users during the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.user.meetings.organized<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User activity, attended meetings|<p>The sum of the scheduled one-time and recurring, ad-hoc, and unclassified meetings attended by licensed or non-licensed Microsoft Teams users during the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.user.meetings.attended<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User activity, audio duration|<p>The sum of the audio duration of licensed or non-licensed Microsoft Teams users during the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.user.duration.audio<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li><li><p>JavaScript: `The text is too long. Please see the template.`</p></li></ul>|
|Teams: User activity, video duration|<p>The sum of the video duration of licensed or non-licensed Microsoft Teams users during the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.user.duration.video<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li><li><p>JavaScript: `The text is too long. Please see the template.`</p></li></ul>|
|Teams: User activity, screen share duration|<p>The sum of the screen share duration of licensed or non-licensed Microsoft Teams users during the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.user.duration.screen_share<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li><li><p>JavaScript: `The text is too long. Please see the template.`</p></li></ul>|
|Teams: User activity, post messages|<p>The number of post messages in all channels made by licensed or non-licensed Microsoft Teams users during the week before the report refresh date. A post is the original message in a teams chat.</p>|Dependent item|ms365.teams.activity.user.messages.posts<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User activity, reply messages|<p>The number of reply messages in all channels made by licensed or non-licensed Microsoft Teams users during the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.user.messages.replies<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User count (users), team chat messages|<p>The number of licensed Microsoft Teams users who posted or replied in team chats during the week before the report refresh date.</p>|Dependent item|ms365.teams.user_count.users.messages.in_team<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User count (users), private chat messages|<p>The number of licensed Microsoft Teams users who posted or replied in private chats during the week before the report refresh date.</p>|Dependent item|ms365.teams.user_count.users.messages.private<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User count (users), calls|<p>The number of licensed Microsoft Teams users who participated in calls during the week before the report refresh date.</p>|Dependent item|ms365.teams.user_count.users.calls<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User count (users), meetings|<p>The number of licensed Microsoft Teams users who participated in meetings during the week before the report refresh date.</p>|Dependent item|ms365.teams.user_count.users.meetings<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User count (total), report date|<p>The date of the report of the number of licensed or non-licensed Microsoft Teams users in activity.</p>|Dependent item|ms365.teams.user_count.total.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User count (total), team chat messages|<p>The number of licensed or non-licensed Microsoft Teams users who posted or replied in team chats during the week before the report refresh date.</p>|Dependent item|ms365.teams.user_count.total.messages.in_team<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User count (total), private chat messages|<p>The number of licensed or non-licensed Microsoft Teams users who posted or replied in private chats during the week before the report refresh date.</p>|Dependent item|ms365.teams.user_count.total.messages.private<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User count (total), calls|<p>The number of licensed or non-licensed Microsoft Teams users who participated in calls during the week before the report refresh date.</p>|Dependent item|ms365.teams.user_count.total.calls<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User count (total), meetings|<p>The number of licensed or non-licensed Microsoft Teams users who participated in meetings during the week before the report refresh date.</p>|Dependent item|ms365.teams.user_count.total.meetings<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User count (guests), team chat messages|<p>The number of non-licensed Microsoft Teams users (guests) who posted or replied in team chats during the week before the report refresh date.</p>|Dependent item|ms365.teams.user_count.guests.messages.in_team<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User count (guests), private chat messages|<p>The number of non-licensed Microsoft Teams users (guests) who posted or replied in private chats during the week before the report refresh date.</p>|Dependent item|ms365.teams.user_count.guests.messages.private<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User count (guests), calls|<p>The number of non-licensed Microsoft Teams users (guests) who participated in calls during the week before the report refresh date.</p>|Dependent item|ms365.teams.user_count.guests.calls<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: User count (guests), meetings|<p>The number of non-licensed Microsoft Teams users (guests) who participated in meetings during the week before the report refresh date.</p>|Dependent item|ms365.teams.user_count.guests.meetings<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Team activity, report date|<p>The date of the report of the number of team activities.</p>|Dependent item|ms365.teams.activity.team.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Team activity, active shared channels|<p>The number of active shared channels across Microsoft Teams over the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.team.active_shared_channels<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Team activity, active external users|<p>The number of active external users across Microsoft Teams over the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.team.active_external_users<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Team activity, active users|<p>The number of active users across Microsoft Teams over the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.team.active_users<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Team activity, active channels|<p>The number of active channels across Microsoft Teams over the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.team.active_channels<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Team activity, channel messages|<p>The number of channel messages across Microsoft Teams over the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.team.channel_messages<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Team activity, guests|<p>The number of guests across Microsoft Teams over the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.team.guests<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Team activity, reactions|<p>The number of reactions across Microsoft Teams over the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.team.reactions<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Team activity, meetings organized|<p>The number of organized meetings across Microsoft Teams over the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.team.meetings_organized<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Team activity, post messages|<p>The number of post messages across Microsoft Teams over the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.team.messages.posts<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Team activity, reply messages|<p>The number of reply messages across Microsoft Teams over the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.team.messages.replies<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Team activity, urgent messages|<p>The number of urgent messages across Microsoft Teams over the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.team.urgent_messages<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Teams: Team activity, mentions|<p>The number of mentions across Microsoft Teams over the week before the report refresh date.</p>|Dependent item|ms365.teams.activity.team.mentions<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: Activity, report date|<p>The date of the Outlook activity count report.</p>|Dependent item|ms365.outlook.activity.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailActivityCounts[0].reportRefreshDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: Activity, emails sent|<p>The number of times an "Email sent" action was recorded.</p>|Dependent item|ms365.outlook.activity.sent<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailActivityCounts[0].send`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: Activity, emails received|<p>The number of times an "Email received" action was recorded.</p>|Dependent item|ms365.outlook.activity.received<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailActivityCounts[0].receive`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: Activity, emails read|<p>The number of times an "Email read" action was recorded.</p>|Dependent item|ms365.outlook.activity.read<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailActivityCounts[0].read`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: Activity, meetings created|<p>The number of times a "Meeting request sent" action was recorded.</p>|Dependent item|ms365.outlook.activity.meetings_created<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailActivityCounts[0].meetingCreated`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: Activity, meetings interacted|<p>The number of times a meeting request accept, tentative, decline, or cancel action was recorded.</p>|Dependent item|ms365.outlook.activity.meetings_interacted<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailActivityCounts[0].meetingInteracted`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, report date|<p>The date of the Outlook activity user count report.</p>|Dependent item|ms365.outlook.user_count.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailActivityUserCounts[0].reportRefreshDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, emails sent|<p>The number of users an "Email sent" action was recorded for.</p>|Dependent item|ms365.outlook.user_count.sent<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailActivityUserCounts[0].send`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, emails received|<p>The number of users an "Email received" action was recorded for.</p>|Dependent item|ms365.outlook.user_count.received<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailActivityUserCounts[0].receive`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, emails read|<p>The number of users an "Email read" action was recorded for.</p>|Dependent item|ms365.outlook.user_count.read<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailActivityUserCounts[0].read`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, meetings created|<p>The number of users a "Meeting request sent" action was recorded for.</p>|Dependent item|ms365.outlook.user_count.meetings_created<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailActivityUserCounts[0].meetingCreated`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, meetings interacted|<p>The number of users a meeting request accept, tentative, decline, or cancel action was recorded for.</p>|Dependent item|ms365.outlook.user_count.meetings_interacted<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailActivityUserCounts[0].meetingInteracted`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, app usage, report date|<p>The date of the report of the unique user count per app.</p>|Dependent item|ms365.outlook.user_count.report_date.app<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailAppUsageUserCounts[6].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, mail for Mac|<p>The number of unique users of mail for Mac.</p>|Dependent item|ms365.outlook.user_count.mail_for_mac<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailAppUsageUserCounts[6].mailForMac`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, Outlook for Mac|<p>The number of unique users of Outlook for Mac.</p>|Dependent item|ms365.outlook.user_count.mac<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailAppUsageUserCounts[6].outlookForMac`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, Outlook for Windows|<p>The number of unique users of Outlook for Windows.</p>|Dependent item|ms365.outlook.user_count.windows<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailAppUsageUserCounts[6].outlookForWindows`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, Outlook for mobile|<p>The number of unique users of Outlook for mobile.</p>|Dependent item|ms365.outlook.user_count.mobile<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailAppUsageUserCounts[6].outlookForMobile`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, Outlook for web|<p>The number of unique users of Outlook for web.</p>|Dependent item|ms365.outlook.user_count.web<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailAppUsageUserCounts[6].outlookForWeb`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, POP3 applications|<p>The number of unique users of other POP3 applications.</p>|Dependent item|ms365.outlook.user_count.pop3app<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailAppUsageUserCounts[6].pop3App`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, IMAP4 applications|<p>The number of unique users of other IMAP4 applications.</p>|Dependent item|ms365.outlook.user_count.imap4app<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailAppUsageUserCounts[6].imap4App`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: User count, SMTP applications|<p>The number of unique users of other SMTP applications.</p>|Dependent item|ms365.outlook.user_count.smtpapp<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getEmailAppUsageUserCounts[6].smtpApp`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: Mailbox, report date|<p>The date of the report of the unique user count per app.</p>|Dependent item|ms365.outlook.mailbox.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getMailboxUsageMailboxCounts[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: Mailbox, total|<p>The total number of user mailboxes in your organization.</p>|Dependent item|ms365.outlook.mailbox.total<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getMailboxUsageMailboxCounts[0].total`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: Mailbox, active|<p>The number of active user mailboxes in your organization. A mailbox is considered active if the user has sent or read any emails.</p>|Dependent item|ms365.outlook.mailbox.active<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getMailboxUsageMailboxCounts[0].active`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: Mailbox, active in %|<p>Percentage of active user mailboxes in your organization. A mailbox is considered active if the user has sent or read any emails.</p>|Dependent item|ms365.outlook.mailbox.active.percentage<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: Mailbox, storage, report date|<p>The date of the mailbox storage report.</p>|Dependent item|ms365.outlook.storage.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getMailboxUsageStorage[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Outlook: Mailbox, storage used|<p>The amount of mailbox storage used in your organization.</p>|Dependent item|ms365.outlook.storage.used<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getMailboxUsageStorage[0].storageUsedInBytes`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Users, report date|<p>The date of the report of the number of active OneDrive users.</p>|Dependent item|ms365.onedrive.users.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveActivityUserCounts[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Users, viewed or edited|<p>The number of users who have viewed or edited OneDrive files.</p>|Dependent item|ms365.onedrive.users.viewed_or_edited<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveActivityUserCounts[0].viewedOrEdited`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Users, synced|<p>The number of users who have synced OneDrive files.</p>|Dependent item|ms365.onedrive.users.synced<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveActivityUserCounts[0].synced`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Users, shared internally|<p>The number of users who have shared OneDrive files internally.</p>|Dependent item|ms365.onedrive.users.shared_internally<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveActivityUserCounts[0].sharedInternally`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Users, shared externally|<p>The number of users who have shared OneDrive files externally.</p>|Dependent item|ms365.onedrive.users.shared_externally<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveActivityUserCounts[0].sharedExternally`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Files, activity, report date|<p>The date of report of the number of active OneDrive files.</p>|Dependent item|ms365.onedrive.files.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveActivityFileCounts[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Files, viewed or edited|<p>The number of viewed or edited OneDrive files.</p>|Dependent item|ms365.onedrive.files.viewed_or_edited<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveActivityFileCounts[0].viewedOrEdited`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Files, synced|<p>The number of synced OneDrive files.</p>|Dependent item|ms365.onedrive.files.synced<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveActivityFileCounts[0].synced`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Files, shared internally|<p>The number of internally shared OneDrive files.</p>|Dependent item|ms365.onedrive.files.shared_internally<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveActivityFileCounts[0].sharedInternally`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Files, shared externally|<p>The number of externally shared OneDrive files.</p>|Dependent item|ms365.onedrive.files.shared_externally<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveActivityFileCounts[0].sharedExternally`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Business sites, report date|<p>The date of the number of OneDrive for Business sites report.</p>|Dependent item|ms365.onedrive.sites.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveUsageAccountCounts[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Business sites, total|<p>The number of OneDrive for Business sites.</p>|Dependent item|ms365.onedrive.sites.total<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveUsageAccountCounts[0].total`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Business sites, active|<p>The number of active OneDrive for Business sites. Any site on which users have viewed, modified, uploaded, downloaded, shared, or synced files is considered an active site.</p>|Dependent item|ms365.onedrive.sites.active<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveUsageAccountCounts[0].active`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: File count, report date|<p>The date of the OneDrive file count report.</p>|Dependent item|ms365.onedrive.file_count.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveUsageFileCounts[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: File count, total|<p>The total number of files across all sites.</p>|Dependent item|ms365.onedrive.file_count.total<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveUsageFileCounts[0].total`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: File count, active|<p>The total number of active files across all sites. A file is considered active if it has been saved, synced, modified, or shared.</p>|Dependent item|ms365.onedrive.file_count.active<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveUsageFileCounts[0].active`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Storage, report date|<p>The date of the report of the amount of storage used in OneDrive for Business.</p>|Dependent item|ms365.onedrive.storage.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOneDriveUsageStorage[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|OneDrive: Storage, total|<p>The total amount of storage used in OneDrive for Business.</p>|Dependent item|ms365.onedrive.storage.total<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Files, activity, report date|<p>The date of the report of the number of active SharePoint files.</p>|Dependent item|ms365.sharepoint.files.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointActivityFileCounts[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Files, viewed or edited|<p>The number of viewed or edited SharePoint files.</p>|Dependent item|ms365.sharepoint.files.viewed_or_edited<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointActivityFileCounts[0].viewedOrEdited`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Files, synced|<p>The number of files synced to a SharePoint site.</p>|Dependent item|ms365.sharepoint.files.synced<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointActivityFileCounts[0].synced`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Files, shared internally|<p>The number of internally shared SharePoint files.</p>|Dependent item|ms365.sharepoint.files.shared_internally<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Files, shared externally|<p>The number of externally shared SharePoint files.</p>|Dependent item|ms365.sharepoint.files.shared_externally<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Users, report date|<p>The date of the report of the number of active SharePoint users.</p>|Dependent item|ms365.sharepoint.user_count.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointActivityUserCounts[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Users, viewed or edited|<p>The number of users who have viewed or edited SharePoint files.</p>|Dependent item|ms365.sharepoint.user_count.viewed_or_edited<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointActivityUserCounts[0].viewedOrEdited`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Users, synced|<p>The number of users who have synced SharePoint files.</p>|Dependent item|ms365.sharepoint.user_count.synced<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointActivityUserCounts[0].synced`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Users, shared internally|<p>The number of users who have shared SharePoint files internally.</p>|Dependent item|ms365.sharepoint.user_count.shared_internally<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Users, shared externally|<p>The number of users who have shared SharePoint files externally.</p>|Dependent item|ms365.sharepoint.user_count.shared_externally<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Users, pages visited|<p>The number of users who have visited unique pages.</p>|Dependent item|ms365.sharepoint.user_count.visited_page<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointActivityUserCounts[0].visitedPage`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Pages, visited, report date|<p>The date of the report of the number of pages visited.</p>|Dependent item|ms365.sharepoint.pages_visited.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointActivityPages[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Pages, visited|<p>The number of unique pages visited by users.</p>|Dependent item|ms365.sharepoint.pages_visited.count<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointActivityPages[0].visitedPageCount`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: File count, report date|<p>The date of the SharePoint file count report.</p>|Dependent item|ms365.sharepoint.file_count.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointSiteUsageFileCounts[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: File count, total|<p>The total number of files across all sites.</p>|Dependent item|ms365.sharepoint.file_count.total<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointSiteUsageFileCounts[0].total`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: File count, active|<p>The total number of active files across all sites. A file is considered active if it has been saved, synced, modified, or shared.</p>|Dependent item|ms365.sharepoint.file_count.active<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointSiteUsageFileCounts[0].active`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Sites, report date|<p>The date of the report of the number of SharePoint sites.</p>|Dependent item|ms365.sharepoint.site.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointSiteUsageSiteCounts[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Sites, total|<p>The number of SharePoint sites.</p>|Dependent item|ms365.sharepoint.sites.total<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointSiteUsageSiteCounts[0].total`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Sites, active|<p>The number of active SharePoint sites.</p>|Dependent item|ms365.sharepoint.sites.active<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointSiteUsageSiteCounts[0].active`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Storage, report date|<p>The date of the report of the amount of storage used in SharePoint.</p>|Dependent item|ms365.sharepoint.storage.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointSiteUsageStorage[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Storage, total|<p>The total amount of storage used in SharePoint.</p>|Dependent item|ms365.sharepoint.storage.total<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Pages, viewed, report date|<p>The date of the report of the number of pages viewed.</p>|Dependent item|ms365.sharepoint.pages_viewed.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointSiteUsagePages[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|SharePoint: Pages, view count|<p>The number of pages viewed across all sites.</p>|Dependent item|ms365.sharepoint.pages_viewed.count<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getSharePointSiteUsagePages[0].pageViewCount`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Users, report date|<p>The date of the active user count report.</p>|Dependent item|ms365.apps.users.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ActiveUserCounts[6].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Users, Office 365|<p>The number of daily Office 365 users.</p>|Dependent item|ms365.apps.users.office365<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ActiveUserCounts[6].office365`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Users, Exchange|<p>The number of daily Exchange users.</p>|Dependent item|ms365.apps.users.exchange<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ActiveUserCounts[6].exchange`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Users, OneDrive|<p>The number of daily OneDrive users.</p>|Dependent item|ms365.apps.users.onedrive<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ActiveUserCounts[6].oneDrive`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Users, SharePoint|<p>The number of daily SharePoint users.</p>|Dependent item|ms365.apps.users.sharepoint<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ActiveUserCounts[6].sharePoint`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Users, Skype for Business|<p>The number of daily Skype for Business users.</p>|Dependent item|ms365.apps.users.skype<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ActiveUserCounts[6].skypeForBusiness`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Users, Yammer|<p>The number of daily Yammer users.</p>|Dependent item|ms365.apps.users.yammer<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ActiveUserCounts[6].yammer`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Users, Teams|<p>The number of daily Teams users.</p>|Dependent item|ms365.apps.users.teams<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ActiveUserCounts[6].teams`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, report date|<p>The date of the report of the user count by activity.</p>|Dependent item|ms365.apps.activity.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, Exchange active users|<p>The number of active Exchange users during the week before the report date.</p>|Dependent item|ms365.apps.activity.exchange.users.active<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ServicesUserCounts[0].exchangeActive`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, Exchange inactive users|<p>The number of inactive Exchange users during the week before the report date.</p>|Dependent item|ms365.apps.activity.exchange.users.inactive<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ServicesUserCounts[0].exchangeInactive`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, OneDrive active users|<p>The number of active OneDrive users during the week before the report date.</p>|Dependent item|ms365.apps.activity.onedrive.users.active<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ServicesUserCounts[0].oneDriveActive`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, OneDrive inactive users|<p>The number of inactive OneDrive users during the week before the report date.</p>|Dependent item|ms365.apps.activity.onedrive.users.inactive<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ServicesUserCounts[0].oneDriveInactive`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, SharePoint active users|<p>The number of active SharePoint users during the week before the report date.</p>|Dependent item|ms365.apps.activity.sharepoint.users.active<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ServicesUserCounts[0].sharePointActive`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, SharePoint inactive users|<p>The number of inactive SharePoint users during the week before the report date.</p>|Dependent item|ms365.apps.activity.sharepoint.users.inactive<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, Skype for Business active users|<p>The number of active Skype for Business users during the week before the report date.</p>|Dependent item|ms365.apps.activity.skypeforbusiness.users.active<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, Skype for Business inactive users|<p>The number of inactive Skype for Business users during the week before the report date.</p>|Dependent item|ms365.apps.activity.skypeforbusiness.users.inactive<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, Yammer active users|<p>The number of active Yammer users during the week before the report date.</p>|Dependent item|ms365.apps.activity.yammer.users.active<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ServicesUserCounts[0].yammerActive`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, Yammer inactive users|<p>The number of inactive Yammer users during the week before the report date.</p>|Dependent item|ms365.apps.activity.yammer.users.inactive<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ServicesUserCounts[0].yammerInactive`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, Teams active users|<p>The number of active Teams users during the week before the report date.</p>|Dependent item|ms365.apps.activity.teams.users.active<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ServicesUserCounts[0].teamsActive`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, Teams inactive users|<p>The number of inactive Teams users during the week before the report date.</p>|Dependent item|ms365.apps.activity.teams.users.inactive<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ServicesUserCounts[0].teamsInactive`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, Office 365 active users|<p>The number of active Office 365 users during the week before the report date.</p>|Dependent item|ms365.apps.activity.office365.users.active<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getOffice365ServicesUserCounts[0].office365Active`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Activity, Office 365 inactive users|<p>The number of inactive Office 365 users during the week before the report date.</p>|Dependent item|ms365.apps.activity.office365.users.inactive<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Office, user count report date|<p>The date of the report of the number of active users for each app.</p>|Dependent item|ms365.apps.office.user_count.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getM365AppUserCounts[0].userCounts[0].reportDate`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Office, Outlook user count|<p>The number of active Outlook users.</p>|Dependent item|ms365.apps.office.user_count.outlook<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getM365AppUserCounts[0].userCounts[0].outlook`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Office, Word user count|<p>The number of active Word users.</p>|Dependent item|ms365.apps.office.user_count.word<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getM365AppUserCounts[0].userCounts[0].word`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Office, Excel user count|<p>The number of active Excel users.</p>|Dependent item|ms365.apps.office.user_count.excel<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getM365AppUserCounts[0].userCounts[0].excel`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Office, PowerPoint user count|<p>The number of active PowerPoint users.</p>|Dependent item|ms365.apps.office.user_count.powerpoint<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getM365AppUserCounts[0].userCounts[0].powerPoint`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Office, OneNote user count|<p>The number of active OneNote users.</p>|Dependent item|ms365.apps.office.user_count.onenote<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getM365AppUserCounts[0].userCounts[0].oneNote`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Office, Teams user count|<p>The number of active Teams users.</p>|Dependent item|ms365.apps.office.user_count.teams<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getM365AppUserCounts[0].userCounts[0].teams`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Platform, user count report date|<p>The date of the report of the number of active users per platform.</p>|Dependent item|ms365.apps.platform.user_count.report_date<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Platform, Windows user count|<p>The number of active users on the Windows platform.</p>|Dependent item|ms365.apps.platform.user_count.windows<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Platform, Mac user count|<p>The number of active users on the Mac platform.</p>|Dependent item|ms365.apps.platform.user_count.mac<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getM365AppPlatformUserCounts[0].userCounts[0].mac`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Platform, mobile user count|<p>The number of active users on the mobile platform.</p>|Dependent item|ms365.apps.platform.user_count.mobile<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Apps: Platform, web user count|<p>The number of active users on the web platform.</p>|Dependent item|ms365.apps.platform.user_count.web<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.metrics.getM365AppPlatformUserCounts[0].userCounts[0].web`</p><p>⛔️Custom on fail: Discard value</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|

### Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Microsoft 365: Services: There are errors in requests to API|<p>Zabbix has received errors in response to API requests.</p>|`length(last(/Microsoft 365 reports by HTTP/ms365.services.errors))>0`|Average||
|Microsoft 365: Teams: There are errors in requests to API|<p>Zabbix has received errors in response to API requests.</p>|`length(last(/Microsoft 365 reports by HTTP/ms365.teams.errors))>0`|Average||
|Microsoft 365: Outlook: There are errors in requests to API|<p>Zabbix has received errors in response to API requests.</p>|`length(last(/Microsoft 365 reports by HTTP/ms365.outlook.errors))>0`|Average||
|Microsoft 365: OneDrive: There are errors in requests to API|<p>Zabbix has received errors in response to API requests.</p>|`length(last(/Microsoft 365 reports by HTTP/ms365.onedrive.errors))>0`|Average||
|Microsoft 365: SharePoint: There are errors in requests to API|<p>Zabbix has received errors in response to API requests.</p>|`length(last(/Microsoft 365 reports by HTTP/ms365.sharepoint.errors))>0`|Average||
|Microsoft 365: Apps: There are errors in requests to API|<p>Zabbix has received errors in response to API requests.</p>|`length(last(/Microsoft 365 reports by HTTP/ms365.apps.errors))>0`|Average||

### LLD rule Microsoft cloud service discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Microsoft cloud service discovery|<p>The list of Microsoft cloud services subscribed by a tenant.</p>|Dependent item|ms365.service.discovery<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.services.value`</p></li><li><p>Discard unchanged with heartbeat: `6h`</p></li></ul>|

### Item prototypes for Microsoft cloud service discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Services: {#NAME} health status|<p>Overall service health status of `[{#NAME}]`.</p><p>More information about health status values can be found here:</p><p>https://learn.microsoft.com/en-us/graph/api/resources/servicehealthissue?view=graph-rest-beta#servicehealthstatus-values</p>|Dependent item|ms365.service.health[{#NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.services.value[?(@.service == '{#NAME}')].status.first()`</p></li><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|

### Trigger prototypes for Microsoft cloud service discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Microsoft 365: Services: {#NAME} is degraded.|<p>The service has the "Degraded" health status.<br>An issue is confirmed that may affect the use of a service or feature. You might see this status if a service is performing slower than usual, there are intermittent interruptions, or if a feature isn't working.</p>|`last(/Microsoft 365 reports by HTTP/ms365.service.health[{#NAME}])=6`|Warning|**Manual close**: Yes|
|Microsoft 365: Services: {#NAME} is interrupted.|<p>The service has the "Interruption" health status.<br>An issue was determined that affects users being able to access the service. In this case, the issue is significant and can be reproduced consistently.</p>|`last(/Microsoft 365 reports by HTTP/ms365.service.health[{#NAME}])=7`|Average|**Manual close**: Yes|

## Feedback

Please report any issues with the template at [`https://support.zabbix.com`](https://support.zabbix.com)

You can also provide feedback, discuss the template, or ask for help at [`ZABBIX forums`](https://www.zabbix.com/forum/zabbix-suggestions-and-feedback)

