完整教程以语法描述为主，兼以举例约定所有的查询方式

## 查询语句语法

| 语法           | 含义                         |
| -------------- | ---------------------------- |
| [str]          | 标题                         |
| #[str]         | 标签                         |
| @[str \| num]  | 作者                         |
| +[const]       | 正约束                       |
| -[const]       | 反约束                       |
| i:[int-range]  | 筛选作品的序号               |
| l:[int-range]  | 筛选作品的收藏数             |
| r:[frac-range] | 筛选插画的横纵比，对小说无效 |
| s:[date]       | 开始发布日期                 |
| e:[date]       | 截至发布日期                 |

## 值语法

### [str] 字符串  

| 语法    | 含义                                 |
| ------- | ------------------------------------ |
| abc     | 普通的字符串                         |
| "ab# c" | 带空格或转义字符的字符串             |
| abc$    | 完全匹配的字符串                     |
| "ab c$" | 完全匹配并且带空格或转义字符的字符串 |

### [num] 数字

| 语法  | 含义       |
| ----- | ---------- |
| 12345 | 普通的数字 |

### [const] 约束

| 语法 | 含义              |
| ---- | ----------------- |
| r18  | R18内容，包含R18G |
| r18g | R18G内容          |
| gif  | 动图              |
| ai   | ai生成内容        |

### [int-range] 正整数范围/集合

| 语法   | 含义                           |
| ------ | ------------------------------ |
| 2-     | 大于等于2                      |
| -3     | 小于等于3                      |
| 2-3    | 大于等于2且小于等于3           |
| [2,3]  | 数学集合，大于等于2且小于等于3 |
| \[2,3) | 数学集合，大于等于2且小于3     |

> 数学集合不支持类似"2-"、"-3"的半开无穷集

### [frac-range] 正实数范围

| 语法    | 含义                     |
| ------- | ------------------------ |
| 2-      | 大于等于2                |
| -1.5    | 小于等于1.5              |
| -1/2    | 小于等于1/2              |
| 1/2-3   | 大于等于1/2且小于等于3   |
| 0.3-1/2 | 大于等于0.3且小于等于1/2 |

### [date] 日期

| 语法       | 含义         |
| ---------- | ------------ |
| MM-dd      | 今年某月某日 |
| MM.dd      | 今年某月某日 |
| yyyy-MM-dd | 某年某月某日 |
| yyyy.MM.dd | 某年某月某日 |

> "."和"-"可以混用

## 序列

| 语法                        | 含义   |
| --------------------------- | ------ |
| !\<segment>                 | 反模式 |
| (and \<segment> \<segment>) | 和模式 |
| (or \<segment> \<segment>)  | 或模式 |

> 三种模式可以任意嵌套，顶层序列默认使用和模式
