Простое руководство по распространенным методам запросов с примерами

## Простые запросы

| Синтаксис                                 | Значение                                                                                                                                          |
| ----------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------- |
| abc                                       | Поиск заголовков, содержащих строку `abc` (частичное совпадение)                                                               |
| #abc                                      | Поиск тегов, содержащих строку `abc` (частичное совпадение)                                                                    |
| @имяАвтораИлиID              | Поиск произведений, автором которых является пользователь с указанным именем или ID                                                               |
| -r18g                                     | Исключить произведения с рейтингом R18G                                                                                                           |
| +gif                                      | Включить произведения с анимацией (GIF)                                                                                        |
| i:10-                     | Начать просмотр с 10-го элемента в результатах поиска                                                                                             |
| l:100-200                 | Поиск произведений с количеством добавлений в избранное от 100 до 200 (включительно)                                           |
| s:MM-dd                   | Поиск произведений, опубликованных после указанной даты (месяц-день текущего года)                                             |
| e:yyyy-MM-dd              | Поиск произведений, опубликованных до указанной даты (год-месяц-день)                                                          |
| r:1.2-3/2 | Поиск иллюстраций с соотношением сторон больше 1.2 и меньше 1.5 (3/2), для новелл не действует |

## Комбинированные запросы

| Синтаксис                         | Значение                                                                                                 |
| --------------------------------- | -------------------------------------------------------------------------------------------------------- |
| abc #def                          | Поиск произведений, заголовок которых содержит `abc` **И** тег содержит `def`                            |
| !#def                             | Поиск произведений, **ни один** из тегов которых **не** содержит `def`                                   |
| "ab c"                            | Поиск по строке, содержащей пробелы (например, "ab c")                                |
| abc$ "ab c$"                      | Поиск по точному совпадению строк `abc` **И** `"ab c"`                                                   |
| (or abc$ #def) | Поиск произведений, заголовок которых точно совпадает со строкой `abc` **ИЛИ** тег содержит строку `def` |
