Полное руководство по синтаксису запросов с примерами

## Синтаксис запросов

| Синтаксис                                                                          | Значение                                                                                  |
| ---------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------- |
| [str]                          | Заголовок                                                                                 |
| #[str]                         | Тег                                                                                       |
| @[str \\| num]   | Автор (имя пользователя или ID)                                        |
| +[const]                       | Положительное условие (должно присутствовать)                          |
| -[const]                       | Отрицательное условие (должно отсутствовать)                           |
| i:[int-range]  | Фильтрация по индексу (порядковому номеру в серии работ)               |
| l:[int-range]  | Фильтрация по количеству добавлений в избранное                                           |
| r:[frac-range] | Фильтрация по соотношению сторон иллюстрации (не действует для новелл) |
| s:[date]       | Дата начала публикации                                                                    |
| e:[date]       | Дата окончания публикации                                                                 |

## Синтаксис значений

### `[str]` Строка

| Синтаксис | Значение                                                             |
| --------- | -------------------------------------------------------------------- |
| abc       | Обычная строка (поиск по частичному совпадению)   |
| "ab# c"   | Строка с пробелами или специальными символами (#) |
| abc$      | Точное совпадение строки                                             |
| "ab c$"   | Точное совпадение строки с пробелами или специальными символами      |

### `[num]` Число

| Синтаксис | Значение      |
| --------- | ------------- |
| 12345     | Обычное число |

### `[const]` Условие (константа)

| Синтаксис | Значение                          |
| --------- | --------------------------------- |
| r18       | Содержимое R18, включая R18G      |
| r18g      | Содержимое R18G                   |
| gif       | Анимация (GIF) |
| ai        | AI-сгенерированное содержимое     |

### `[int-range]` Диапазон целых чисел / Множество

| Синтаксис                                                 | Значение                                        |
| --------------------------------------------------------- | ----------------------------------------------- |
| 2-                                                        | Больше или равно 2                              |
| -3                                                        | Меньше или равно 3                              |
| 2-3                                                       | Больше или равно 2 и меньше или равно 3         |
| [2,3] | Математический интервал, включая 2 и 3          |
| \[2,3)                         | Математический интервал, включая 2 и исключая 3 |

> Математические интервалы не поддерживают полубесконечные множества, такие как "2-" или "-3"

### `[frac-range]` Диапазон дробных чисел

| Синтаксис               | Значение                                                    |
| ----------------------- | ----------------------------------------------------------- |
| 2-                      | Больше или равно 2                                          |
| -1.5    | Меньше или равно 1.5                        |
| -1/2                    | Меньше или равно 1/2                                        |
| 1/2-3                   | Больше или равно 1/2 и меньше или равно 3                   |
| 0.3-1/2 | Больше или равно 0.3 и меньше или равно 1/2 |

### `[date]` Дата

| Синтаксис                                  | Значение                   |
| ------------------------------------------ | -------------------------- |
| MM-dd                                      | День и месяц текущего года |
| MM.dd                      | День и месяц текущего года |
| yyyy-MM-dd                                 | День, месяц и год          |
| yyyy.MM.dd | День, месяц и год          |

> "." и "-" можно использовать взаимозаменяемо

## Последовательности (Булевы операторы)

| Синтаксис                   | Значение                          |
| --------------------------- | --------------------------------- |
| `!<segment>`                | Отрицание (НЕ) |
| `(and <segment> <segment>)` | Логическое И                      |
| `(or <segment> <segment>)`  | Логическое ИЛИ                    |

> Все три оператора могут быть вложены любым образом. На верхнем уровне по умолчанию используется логическое "И".
