package meterexporters

import (
	"fmt"

	"go.opentelemetry.io/otel/sdk/metric"
)

// ExporterFactory - Create meter exporter according to given params
func ExporterFactory(name, endpoint string, insecure bool, urlpath string, headers map[string]string, protocol string) (metric.Exporter, error) { // Create meter exporter
	switch name { // Determine exporter type
	case "otlp", "otlp-http", "otlp-grpc": // OTLP exporters
		return NewOTLP(endpoint, insecure, urlpath, headers, protocol) // Create OTLP exporter
	case "gcp":
		return NewGCP(headers)
	default:
		return nil, fmt.Errorf("%s meter exporter is unsupported", name)
	}
}
