// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             (unknown)
// source: base/v1/service.proto

package basev1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	Permission_Check_FullMethodName              = "/base.v1.Permission/Check"
	Permission_Expand_FullMethodName             = "/base.v1.Permission/Expand"
	Permission_LookupEntity_FullMethodName       = "/base.v1.Permission/LookupEntity"
	Permission_LookupEntityStream_FullMethodName = "/base.v1.Permission/LookupEntityStream"
	Permission_LookupSubject_FullMethodName      = "/base.v1.Permission/LookupSubject"
	Permission_SubjectPermission_FullMethodName  = "/base.v1.Permission/SubjectPermission"
)

// PermissionClient is the client API for Permission service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// ** PERMISSION SERVICE **
// Permission service contains methods to interact with permissions.
type PermissionClient interface {
	// Check method receives a PermissionCheckRequest and returns a PermissionCheckResponse.
	// It is used to determine whether a specific user has permission to perform an action on a resource.
	// For example, "Can the user 1 push to repository 1?"
	Check(ctx context.Context, in *PermissionCheckRequest, opts ...grpc.CallOption) (*PermissionCheckResponse, error)
	// Expand method receives a PermissionExpandRequest and returns a PermissionExpandResponse.
	// It expands relationships according to the schema provided.
	Expand(ctx context.Context, in *PermissionExpandRequest, opts ...grpc.CallOption) (*PermissionExpandResponse, error)
	// LookupEntity method receives a PermissionLookupEntityRequest and returns a PermissionLookupEntityResponse.
	// It is used to retrieve an entity by its identifier.
	LookupEntity(ctx context.Context, in *PermissionLookupEntityRequest, opts ...grpc.CallOption) (*PermissionLookupEntityResponse, error)
	// LookupEntityStream method receives a PermissionLookupEntityRequest and streams a series of PermissionLookupEntityStreamResponse messages.
	// It is used to retrieve entities by their identifiers in a streaming fashion.
	LookupEntityStream(ctx context.Context, in *PermissionLookupEntityRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[PermissionLookupEntityStreamResponse], error)
	// LookupSubject method receives a PermissionLookupSubjectRequest and returns a PermissionLookupSubjectResponse.
	// It is used to retrieve a subject by its identifier.
	LookupSubject(ctx context.Context, in *PermissionLookupSubjectRequest, opts ...grpc.CallOption) (*PermissionLookupSubjectResponse, error)
	// SubjectPermission method receives a PermissionSubjectPermissionRequest and returns a PermissionSubjectPermissionResponse.
	// It is used to retrieve permissions related to a specific subject.
	SubjectPermission(ctx context.Context, in *PermissionSubjectPermissionRequest, opts ...grpc.CallOption) (*PermissionSubjectPermissionResponse, error)
}

type permissionClient struct {
	cc grpc.ClientConnInterface
}

func NewPermissionClient(cc grpc.ClientConnInterface) PermissionClient {
	return &permissionClient{cc}
}

func (c *permissionClient) Check(ctx context.Context, in *PermissionCheckRequest, opts ...grpc.CallOption) (*PermissionCheckResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PermissionCheckResponse)
	err := c.cc.Invoke(ctx, Permission_Check_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *permissionClient) Expand(ctx context.Context, in *PermissionExpandRequest, opts ...grpc.CallOption) (*PermissionExpandResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PermissionExpandResponse)
	err := c.cc.Invoke(ctx, Permission_Expand_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *permissionClient) LookupEntity(ctx context.Context, in *PermissionLookupEntityRequest, opts ...grpc.CallOption) (*PermissionLookupEntityResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PermissionLookupEntityResponse)
	err := c.cc.Invoke(ctx, Permission_LookupEntity_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *permissionClient) LookupEntityStream(ctx context.Context, in *PermissionLookupEntityRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[PermissionLookupEntityStreamResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &Permission_ServiceDesc.Streams[0], Permission_LookupEntityStream_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[PermissionLookupEntityRequest, PermissionLookupEntityStreamResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type Permission_LookupEntityStreamClient = grpc.ServerStreamingClient[PermissionLookupEntityStreamResponse]

func (c *permissionClient) LookupSubject(ctx context.Context, in *PermissionLookupSubjectRequest, opts ...grpc.CallOption) (*PermissionLookupSubjectResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PermissionLookupSubjectResponse)
	err := c.cc.Invoke(ctx, Permission_LookupSubject_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *permissionClient) SubjectPermission(ctx context.Context, in *PermissionSubjectPermissionRequest, opts ...grpc.CallOption) (*PermissionSubjectPermissionResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PermissionSubjectPermissionResponse)
	err := c.cc.Invoke(ctx, Permission_SubjectPermission_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PermissionServer is the server API for Permission service.
// All implementations must embed UnimplementedPermissionServer
// for forward compatibility.
//
// ** PERMISSION SERVICE **
// Permission service contains methods to interact with permissions.
type PermissionServer interface {
	// Check method receives a PermissionCheckRequest and returns a PermissionCheckResponse.
	// It is used to determine whether a specific user has permission to perform an action on a resource.
	// For example, "Can the user 1 push to repository 1?"
	Check(context.Context, *PermissionCheckRequest) (*PermissionCheckResponse, error)
	// Expand method receives a PermissionExpandRequest and returns a PermissionExpandResponse.
	// It expands relationships according to the schema provided.
	Expand(context.Context, *PermissionExpandRequest) (*PermissionExpandResponse, error)
	// LookupEntity method receives a PermissionLookupEntityRequest and returns a PermissionLookupEntityResponse.
	// It is used to retrieve an entity by its identifier.
	LookupEntity(context.Context, *PermissionLookupEntityRequest) (*PermissionLookupEntityResponse, error)
	// LookupEntityStream method receives a PermissionLookupEntityRequest and streams a series of PermissionLookupEntityStreamResponse messages.
	// It is used to retrieve entities by their identifiers in a streaming fashion.
	LookupEntityStream(*PermissionLookupEntityRequest, grpc.ServerStreamingServer[PermissionLookupEntityStreamResponse]) error
	// LookupSubject method receives a PermissionLookupSubjectRequest and returns a PermissionLookupSubjectResponse.
	// It is used to retrieve a subject by its identifier.
	LookupSubject(context.Context, *PermissionLookupSubjectRequest) (*PermissionLookupSubjectResponse, error)
	// SubjectPermission method receives a PermissionSubjectPermissionRequest and returns a PermissionSubjectPermissionResponse.
	// It is used to retrieve permissions related to a specific subject.
	SubjectPermission(context.Context, *PermissionSubjectPermissionRequest) (*PermissionSubjectPermissionResponse, error)
	mustEmbedUnimplementedPermissionServer()
}

// UnimplementedPermissionServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedPermissionServer struct{}

func (UnimplementedPermissionServer) Check(context.Context, *PermissionCheckRequest) (*PermissionCheckResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Check not implemented")
}
func (UnimplementedPermissionServer) Expand(context.Context, *PermissionExpandRequest) (*PermissionExpandResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Expand not implemented")
}
func (UnimplementedPermissionServer) LookupEntity(context.Context, *PermissionLookupEntityRequest) (*PermissionLookupEntityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupEntity not implemented")
}
func (UnimplementedPermissionServer) LookupEntityStream(*PermissionLookupEntityRequest, grpc.ServerStreamingServer[PermissionLookupEntityStreamResponse]) error {
	return status.Errorf(codes.Unimplemented, "method LookupEntityStream not implemented")
}
func (UnimplementedPermissionServer) LookupSubject(context.Context, *PermissionLookupSubjectRequest) (*PermissionLookupSubjectResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupSubject not implemented")
}
func (UnimplementedPermissionServer) SubjectPermission(context.Context, *PermissionSubjectPermissionRequest) (*PermissionSubjectPermissionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubjectPermission not implemented")
}
func (UnimplementedPermissionServer) mustEmbedUnimplementedPermissionServer() {}
func (UnimplementedPermissionServer) testEmbeddedByValue()                    {}

// UnsafePermissionServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PermissionServer will
// result in compilation errors.
type UnsafePermissionServer interface {
	mustEmbedUnimplementedPermissionServer()
}

func RegisterPermissionServer(s grpc.ServiceRegistrar, srv PermissionServer) {
	// If the following call pancis, it indicates UnimplementedPermissionServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Permission_ServiceDesc, srv)
}

func _Permission_Check_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PermissionCheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PermissionServer).Check(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Permission_Check_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PermissionServer).Check(ctx, req.(*PermissionCheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Permission_Expand_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PermissionExpandRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PermissionServer).Expand(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Permission_Expand_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PermissionServer).Expand(ctx, req.(*PermissionExpandRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Permission_LookupEntity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PermissionLookupEntityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PermissionServer).LookupEntity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Permission_LookupEntity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PermissionServer).LookupEntity(ctx, req.(*PermissionLookupEntityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Permission_LookupEntityStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PermissionLookupEntityRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(PermissionServer).LookupEntityStream(m, &grpc.GenericServerStream[PermissionLookupEntityRequest, PermissionLookupEntityStreamResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type Permission_LookupEntityStreamServer = grpc.ServerStreamingServer[PermissionLookupEntityStreamResponse]

func _Permission_LookupSubject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PermissionLookupSubjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PermissionServer).LookupSubject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Permission_LookupSubject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PermissionServer).LookupSubject(ctx, req.(*PermissionLookupSubjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Permission_SubjectPermission_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PermissionSubjectPermissionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PermissionServer).SubjectPermission(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Permission_SubjectPermission_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PermissionServer).SubjectPermission(ctx, req.(*PermissionSubjectPermissionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Permission_ServiceDesc is the grpc.ServiceDesc for Permission service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Permission_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "base.v1.Permission",
	HandlerType: (*PermissionServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Check",
			Handler:    _Permission_Check_Handler,
		},
		{
			MethodName: "Expand",
			Handler:    _Permission_Expand_Handler,
		},
		{
			MethodName: "LookupEntity",
			Handler:    _Permission_LookupEntity_Handler,
		},
		{
			MethodName: "LookupSubject",
			Handler:    _Permission_LookupSubject_Handler,
		},
		{
			MethodName: "SubjectPermission",
			Handler:    _Permission_SubjectPermission_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "LookupEntityStream",
			Handler:       _Permission_LookupEntityStream_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "base/v1/service.proto",
}

const (
	Watch_Watch_FullMethodName = "/base.v1.Watch/Watch"
)

// WatchClient is the client API for Watch service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Watch is the main RPC in the Watch service. It establishes a stream between
// the client and the server. The server pushes data changes into this stream
// and the client can read those in real time.
type WatchClient interface {
	Watch(ctx context.Context, in *WatchRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[WatchResponse], error)
}

type watchClient struct {
	cc grpc.ClientConnInterface
}

func NewWatchClient(cc grpc.ClientConnInterface) WatchClient {
	return &watchClient{cc}
}

func (c *watchClient) Watch(ctx context.Context, in *WatchRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[WatchResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &Watch_ServiceDesc.Streams[0], Watch_Watch_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[WatchRequest, WatchResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type Watch_WatchClient = grpc.ServerStreamingClient[WatchResponse]

// WatchServer is the server API for Watch service.
// All implementations must embed UnimplementedWatchServer
// for forward compatibility.
//
// Watch is the main RPC in the Watch service. It establishes a stream between
// the client and the server. The server pushes data changes into this stream
// and the client can read those in real time.
type WatchServer interface {
	Watch(*WatchRequest, grpc.ServerStreamingServer[WatchResponse]) error
	mustEmbedUnimplementedWatchServer()
}

// UnimplementedWatchServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedWatchServer struct{}

func (UnimplementedWatchServer) Watch(*WatchRequest, grpc.ServerStreamingServer[WatchResponse]) error {
	return status.Errorf(codes.Unimplemented, "method Watch not implemented")
}
func (UnimplementedWatchServer) mustEmbedUnimplementedWatchServer() {}
func (UnimplementedWatchServer) testEmbeddedByValue()               {}

// UnsafeWatchServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WatchServer will
// result in compilation errors.
type UnsafeWatchServer interface {
	mustEmbedUnimplementedWatchServer()
}

func RegisterWatchServer(s grpc.ServiceRegistrar, srv WatchServer) {
	// If the following call pancis, it indicates UnimplementedWatchServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Watch_ServiceDesc, srv)
}

func _Watch_Watch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(WatchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(WatchServer).Watch(m, &grpc.GenericServerStream[WatchRequest, WatchResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type Watch_WatchServer = grpc.ServerStreamingServer[WatchResponse]

// Watch_ServiceDesc is the grpc.ServiceDesc for Watch service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Watch_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "base.v1.Watch",
	HandlerType: (*WatchServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Watch",
			Handler:       _Watch_Watch_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "base/v1/service.proto",
}

const (
	Schema_Write_FullMethodName        = "/base.v1.Schema/Write"
	Schema_PartialWrite_FullMethodName = "/base.v1.Schema/PartialWrite"
	Schema_Read_FullMethodName         = "/base.v1.Schema/Read"
	Schema_List_FullMethodName         = "/base.v1.Schema/List"
)

// SchemaClient is the client API for Schema service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// The Schema service definition.
type SchemaClient interface {
	// Write is an RPC that allows you to write your authorization model.
	Write(ctx context.Context, in *SchemaWriteRequest, opts ...grpc.CallOption) (*SchemaWriteResponse, error)
	// PartialWrite is an RPC that allows you to partially update an existing authorization model.
	PartialWrite(ctx context.Context, in *SchemaPartialWriteRequest, opts ...grpc.CallOption) (*SchemaPartialWriteResponse, error)
	// Read is an RPC that allows you to read your authorization model.
	Read(ctx context.Context, in *SchemaReadRequest, opts ...grpc.CallOption) (*SchemaReadResponse, error)
	// List is an RPC that allows you to list all authorization models.
	List(ctx context.Context, in *SchemaListRequest, opts ...grpc.CallOption) (*SchemaListResponse, error)
}

type schemaClient struct {
	cc grpc.ClientConnInterface
}

func NewSchemaClient(cc grpc.ClientConnInterface) SchemaClient {
	return &schemaClient{cc}
}

func (c *schemaClient) Write(ctx context.Context, in *SchemaWriteRequest, opts ...grpc.CallOption) (*SchemaWriteResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SchemaWriteResponse)
	err := c.cc.Invoke(ctx, Schema_Write_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *schemaClient) PartialWrite(ctx context.Context, in *SchemaPartialWriteRequest, opts ...grpc.CallOption) (*SchemaPartialWriteResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SchemaPartialWriteResponse)
	err := c.cc.Invoke(ctx, Schema_PartialWrite_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *schemaClient) Read(ctx context.Context, in *SchemaReadRequest, opts ...grpc.CallOption) (*SchemaReadResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SchemaReadResponse)
	err := c.cc.Invoke(ctx, Schema_Read_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *schemaClient) List(ctx context.Context, in *SchemaListRequest, opts ...grpc.CallOption) (*SchemaListResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SchemaListResponse)
	err := c.cc.Invoke(ctx, Schema_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SchemaServer is the server API for Schema service.
// All implementations must embed UnimplementedSchemaServer
// for forward compatibility.
//
// The Schema service definition.
type SchemaServer interface {
	// Write is an RPC that allows you to write your authorization model.
	Write(context.Context, *SchemaWriteRequest) (*SchemaWriteResponse, error)
	// PartialWrite is an RPC that allows you to partially update an existing authorization model.
	PartialWrite(context.Context, *SchemaPartialWriteRequest) (*SchemaPartialWriteResponse, error)
	// Read is an RPC that allows you to read your authorization model.
	Read(context.Context, *SchemaReadRequest) (*SchemaReadResponse, error)
	// List is an RPC that allows you to list all authorization models.
	List(context.Context, *SchemaListRequest) (*SchemaListResponse, error)
	mustEmbedUnimplementedSchemaServer()
}

// UnimplementedSchemaServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedSchemaServer struct{}

func (UnimplementedSchemaServer) Write(context.Context, *SchemaWriteRequest) (*SchemaWriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Write not implemented")
}
func (UnimplementedSchemaServer) PartialWrite(context.Context, *SchemaPartialWriteRequest) (*SchemaPartialWriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PartialWrite not implemented")
}
func (UnimplementedSchemaServer) Read(context.Context, *SchemaReadRequest) (*SchemaReadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Read not implemented")
}
func (UnimplementedSchemaServer) List(context.Context, *SchemaListRequest) (*SchemaListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedSchemaServer) mustEmbedUnimplementedSchemaServer() {}
func (UnimplementedSchemaServer) testEmbeddedByValue()                {}

// UnsafeSchemaServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SchemaServer will
// result in compilation errors.
type UnsafeSchemaServer interface {
	mustEmbedUnimplementedSchemaServer()
}

func RegisterSchemaServer(s grpc.ServiceRegistrar, srv SchemaServer) {
	// If the following call pancis, it indicates UnimplementedSchemaServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Schema_ServiceDesc, srv)
}

func _Schema_Write_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SchemaWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SchemaServer).Write(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Schema_Write_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SchemaServer).Write(ctx, req.(*SchemaWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Schema_PartialWrite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SchemaPartialWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SchemaServer).PartialWrite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Schema_PartialWrite_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SchemaServer).PartialWrite(ctx, req.(*SchemaPartialWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Schema_Read_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SchemaReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SchemaServer).Read(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Schema_Read_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SchemaServer).Read(ctx, req.(*SchemaReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Schema_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SchemaListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SchemaServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Schema_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SchemaServer).List(ctx, req.(*SchemaListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Schema_ServiceDesc is the grpc.ServiceDesc for Schema service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Schema_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "base.v1.Schema",
	HandlerType: (*SchemaServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Write",
			Handler:    _Schema_Write_Handler,
		},
		{
			MethodName: "PartialWrite",
			Handler:    _Schema_PartialWrite_Handler,
		},
		{
			MethodName: "Read",
			Handler:    _Schema_Read_Handler,
		},
		{
			MethodName: "List",
			Handler:    _Schema_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "base/v1/service.proto",
}

const (
	Data_Write_FullMethodName               = "/base.v1.Data/Write"
	Data_WriteRelationships_FullMethodName  = "/base.v1.Data/WriteRelationships"
	Data_ReadRelationships_FullMethodName   = "/base.v1.Data/ReadRelationships"
	Data_ReadAttributes_FullMethodName      = "/base.v1.Data/ReadAttributes"
	Data_Delete_FullMethodName              = "/base.v1.Data/Delete"
	Data_DeleteRelationships_FullMethodName = "/base.v1.Data/DeleteRelationships"
	Data_RunBundle_FullMethodName           = "/base.v1.Data/RunBundle"
)

// DataClient is the client API for Data service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// The Data service provides RPC methods for managing data in the context of relationships and attributes.
type DataClient interface {
	// The Write RPC method creates a new relation tuple.
	Write(ctx context.Context, in *DataWriteRequest, opts ...grpc.CallOption) (*DataWriteResponse, error)
	// RPC method to write relationships for a tenant. This can be accessed via a POST request to the given HTTP path. It's tagged under "Data" in OpenAPI documentation.
	WriteRelationships(ctx context.Context, in *RelationshipWriteRequest, opts ...grpc.CallOption) (*RelationshipWriteResponse, error)
	// The ReadRelationships RPC method reads relation tuple(s).
	ReadRelationships(ctx context.Context, in *RelationshipReadRequest, opts ...grpc.CallOption) (*RelationshipReadResponse, error)
	// The ReadAttributes RPC method reads attribute(s) of a relation.
	ReadAttributes(ctx context.Context, in *AttributeReadRequest, opts ...grpc.CallOption) (*AttributeReadResponse, error)
	// The Delete RPC method deletes a relation tuple.
	Delete(ctx context.Context, in *DataDeleteRequest, opts ...grpc.CallOption) (*DataDeleteResponse, error)
	// RPC method to delete relationships for a tenant, accessed via a POST request to the specified path, tagged as "Data" in OpenAPI documentation.
	DeleteRelationships(ctx context.Context, in *RelationshipDeleteRequest, opts ...grpc.CallOption) (*RelationshipDeleteResponse, error)
	// Executes or runs a specific bundle. This method is useful for processing or triggering actions based on the bundle's data.
	RunBundle(ctx context.Context, in *BundleRunRequest, opts ...grpc.CallOption) (*BundleRunResponse, error)
}

type dataClient struct {
	cc grpc.ClientConnInterface
}

func NewDataClient(cc grpc.ClientConnInterface) DataClient {
	return &dataClient{cc}
}

func (c *dataClient) Write(ctx context.Context, in *DataWriteRequest, opts ...grpc.CallOption) (*DataWriteResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DataWriteResponse)
	err := c.cc.Invoke(ctx, Data_Write_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataClient) WriteRelationships(ctx context.Context, in *RelationshipWriteRequest, opts ...grpc.CallOption) (*RelationshipWriteResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RelationshipWriteResponse)
	err := c.cc.Invoke(ctx, Data_WriteRelationships_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataClient) ReadRelationships(ctx context.Context, in *RelationshipReadRequest, opts ...grpc.CallOption) (*RelationshipReadResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RelationshipReadResponse)
	err := c.cc.Invoke(ctx, Data_ReadRelationships_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataClient) ReadAttributes(ctx context.Context, in *AttributeReadRequest, opts ...grpc.CallOption) (*AttributeReadResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(AttributeReadResponse)
	err := c.cc.Invoke(ctx, Data_ReadAttributes_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataClient) Delete(ctx context.Context, in *DataDeleteRequest, opts ...grpc.CallOption) (*DataDeleteResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DataDeleteResponse)
	err := c.cc.Invoke(ctx, Data_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataClient) DeleteRelationships(ctx context.Context, in *RelationshipDeleteRequest, opts ...grpc.CallOption) (*RelationshipDeleteResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RelationshipDeleteResponse)
	err := c.cc.Invoke(ctx, Data_DeleteRelationships_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataClient) RunBundle(ctx context.Context, in *BundleRunRequest, opts ...grpc.CallOption) (*BundleRunResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BundleRunResponse)
	err := c.cc.Invoke(ctx, Data_RunBundle_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataServer is the server API for Data service.
// All implementations must embed UnimplementedDataServer
// for forward compatibility.
//
// The Data service provides RPC methods for managing data in the context of relationships and attributes.
type DataServer interface {
	// The Write RPC method creates a new relation tuple.
	Write(context.Context, *DataWriteRequest) (*DataWriteResponse, error)
	// RPC method to write relationships for a tenant. This can be accessed via a POST request to the given HTTP path. It's tagged under "Data" in OpenAPI documentation.
	WriteRelationships(context.Context, *RelationshipWriteRequest) (*RelationshipWriteResponse, error)
	// The ReadRelationships RPC method reads relation tuple(s).
	ReadRelationships(context.Context, *RelationshipReadRequest) (*RelationshipReadResponse, error)
	// The ReadAttributes RPC method reads attribute(s) of a relation.
	ReadAttributes(context.Context, *AttributeReadRequest) (*AttributeReadResponse, error)
	// The Delete RPC method deletes a relation tuple.
	Delete(context.Context, *DataDeleteRequest) (*DataDeleteResponse, error)
	// RPC method to delete relationships for a tenant, accessed via a POST request to the specified path, tagged as "Data" in OpenAPI documentation.
	DeleteRelationships(context.Context, *RelationshipDeleteRequest) (*RelationshipDeleteResponse, error)
	// Executes or runs a specific bundle. This method is useful for processing or triggering actions based on the bundle's data.
	RunBundle(context.Context, *BundleRunRequest) (*BundleRunResponse, error)
	mustEmbedUnimplementedDataServer()
}

// UnimplementedDataServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedDataServer struct{}

func (UnimplementedDataServer) Write(context.Context, *DataWriteRequest) (*DataWriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Write not implemented")
}
func (UnimplementedDataServer) WriteRelationships(context.Context, *RelationshipWriteRequest) (*RelationshipWriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteRelationships not implemented")
}
func (UnimplementedDataServer) ReadRelationships(context.Context, *RelationshipReadRequest) (*RelationshipReadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadRelationships not implemented")
}
func (UnimplementedDataServer) ReadAttributes(context.Context, *AttributeReadRequest) (*AttributeReadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadAttributes not implemented")
}
func (UnimplementedDataServer) Delete(context.Context, *DataDeleteRequest) (*DataDeleteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedDataServer) DeleteRelationships(context.Context, *RelationshipDeleteRequest) (*RelationshipDeleteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRelationships not implemented")
}
func (UnimplementedDataServer) RunBundle(context.Context, *BundleRunRequest) (*BundleRunResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunBundle not implemented")
}
func (UnimplementedDataServer) mustEmbedUnimplementedDataServer() {}
func (UnimplementedDataServer) testEmbeddedByValue()              {}

// UnsafeDataServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataServer will
// result in compilation errors.
type UnsafeDataServer interface {
	mustEmbedUnimplementedDataServer()
}

func RegisterDataServer(s grpc.ServiceRegistrar, srv DataServer) {
	// If the following call pancis, it indicates UnimplementedDataServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Data_ServiceDesc, srv)
}

func _Data_Write_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DataWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServer).Write(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Data_Write_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServer).Write(ctx, req.(*DataWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Data_WriteRelationships_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RelationshipWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServer).WriteRelationships(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Data_WriteRelationships_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServer).WriteRelationships(ctx, req.(*RelationshipWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Data_ReadRelationships_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RelationshipReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServer).ReadRelationships(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Data_ReadRelationships_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServer).ReadRelationships(ctx, req.(*RelationshipReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Data_ReadAttributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttributeReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServer).ReadAttributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Data_ReadAttributes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServer).ReadAttributes(ctx, req.(*AttributeReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Data_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DataDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Data_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServer).Delete(ctx, req.(*DataDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Data_DeleteRelationships_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RelationshipDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServer).DeleteRelationships(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Data_DeleteRelationships_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServer).DeleteRelationships(ctx, req.(*RelationshipDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Data_RunBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BundleRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServer).RunBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Data_RunBundle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServer).RunBundle(ctx, req.(*BundleRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Data_ServiceDesc is the grpc.ServiceDesc for Data service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Data_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "base.v1.Data",
	HandlerType: (*DataServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Write",
			Handler:    _Data_Write_Handler,
		},
		{
			MethodName: "WriteRelationships",
			Handler:    _Data_WriteRelationships_Handler,
		},
		{
			MethodName: "ReadRelationships",
			Handler:    _Data_ReadRelationships_Handler,
		},
		{
			MethodName: "ReadAttributes",
			Handler:    _Data_ReadAttributes_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _Data_Delete_Handler,
		},
		{
			MethodName: "DeleteRelationships",
			Handler:    _Data_DeleteRelationships_Handler,
		},
		{
			MethodName: "RunBundle",
			Handler:    _Data_RunBundle_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "base/v1/service.proto",
}

const (
	Bundle_Write_FullMethodName  = "/base.v1.Bundle/Write"
	Bundle_Read_FullMethodName   = "/base.v1.Bundle/Read"
	Bundle_Delete_FullMethodName = "/base.v1.Bundle/Delete"
)

// BundleClient is the client API for Bundle service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BundleClient interface {
	// Writes a bundle of data for a specific operation. This is a general purpose method to handle writing data bundles.
	Write(ctx context.Context, in *BundleWriteRequest, opts ...grpc.CallOption) (*BundleWriteResponse, error)
	// Reads a data bundle based on a specified request. This method is tailored for retrieving data bundles.
	Read(ctx context.Context, in *BundleReadRequest, opts ...grpc.CallOption) (*BundleReadResponse, error)
	// Deletes a specific data bundle. This method is used to remove existing bundles from the system.
	Delete(ctx context.Context, in *BundleDeleteRequest, opts ...grpc.CallOption) (*BundleDeleteResponse, error)
}

type bundleClient struct {
	cc grpc.ClientConnInterface
}

func NewBundleClient(cc grpc.ClientConnInterface) BundleClient {
	return &bundleClient{cc}
}

func (c *bundleClient) Write(ctx context.Context, in *BundleWriteRequest, opts ...grpc.CallOption) (*BundleWriteResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BundleWriteResponse)
	err := c.cc.Invoke(ctx, Bundle_Write_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bundleClient) Read(ctx context.Context, in *BundleReadRequest, opts ...grpc.CallOption) (*BundleReadResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BundleReadResponse)
	err := c.cc.Invoke(ctx, Bundle_Read_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bundleClient) Delete(ctx context.Context, in *BundleDeleteRequest, opts ...grpc.CallOption) (*BundleDeleteResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BundleDeleteResponse)
	err := c.cc.Invoke(ctx, Bundle_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BundleServer is the server API for Bundle service.
// All implementations must embed UnimplementedBundleServer
// for forward compatibility.
type BundleServer interface {
	// Writes a bundle of data for a specific operation. This is a general purpose method to handle writing data bundles.
	Write(context.Context, *BundleWriteRequest) (*BundleWriteResponse, error)
	// Reads a data bundle based on a specified request. This method is tailored for retrieving data bundles.
	Read(context.Context, *BundleReadRequest) (*BundleReadResponse, error)
	// Deletes a specific data bundle. This method is used to remove existing bundles from the system.
	Delete(context.Context, *BundleDeleteRequest) (*BundleDeleteResponse, error)
	mustEmbedUnimplementedBundleServer()
}

// UnimplementedBundleServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedBundleServer struct{}

func (UnimplementedBundleServer) Write(context.Context, *BundleWriteRequest) (*BundleWriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Write not implemented")
}
func (UnimplementedBundleServer) Read(context.Context, *BundleReadRequest) (*BundleReadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Read not implemented")
}
func (UnimplementedBundleServer) Delete(context.Context, *BundleDeleteRequest) (*BundleDeleteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedBundleServer) mustEmbedUnimplementedBundleServer() {}
func (UnimplementedBundleServer) testEmbeddedByValue()                {}

// UnsafeBundleServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BundleServer will
// result in compilation errors.
type UnsafeBundleServer interface {
	mustEmbedUnimplementedBundleServer()
}

func RegisterBundleServer(s grpc.ServiceRegistrar, srv BundleServer) {
	// If the following call pancis, it indicates UnimplementedBundleServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Bundle_ServiceDesc, srv)
}

func _Bundle_Write_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BundleWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BundleServer).Write(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bundle_Write_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BundleServer).Write(ctx, req.(*BundleWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bundle_Read_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BundleReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BundleServer).Read(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bundle_Read_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BundleServer).Read(ctx, req.(*BundleReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bundle_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BundleDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BundleServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bundle_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BundleServer).Delete(ctx, req.(*BundleDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Bundle_ServiceDesc is the grpc.ServiceDesc for Bundle service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Bundle_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "base.v1.Bundle",
	HandlerType: (*BundleServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Write",
			Handler:    _Bundle_Write_Handler,
		},
		{
			MethodName: "Read",
			Handler:    _Bundle_Read_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _Bundle_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "base/v1/service.proto",
}

const (
	Tenancy_Create_FullMethodName = "/base.v1.Tenancy/Create"
	Tenancy_Delete_FullMethodName = "/base.v1.Tenancy/Delete"
	Tenancy_List_FullMethodName   = "/base.v1.Tenancy/List"
)

// TenancyClient is the client API for Tenancy service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TenancyClient interface {
	// Create is a unary RPC to create a new tenant.
	// It requires a TenantCreateRequest and returns a TenantCreateResponse.
	Create(ctx context.Context, in *TenantCreateRequest, opts ...grpc.CallOption) (*TenantCreateResponse, error)
	// Delete is a unary RPC to delete an existing tenant.
	// It requires a TenantDeleteRequest and returns a TenantDeleteResponse.
	Delete(ctx context.Context, in *TenantDeleteRequest, opts ...grpc.CallOption) (*TenantDeleteResponse, error)
	// List is a unary RPC to get a list of all tenants.
	// It requires a TenantListRequest and returns a TenantListResponse.
	List(ctx context.Context, in *TenantListRequest, opts ...grpc.CallOption) (*TenantListResponse, error)
}

type tenancyClient struct {
	cc grpc.ClientConnInterface
}

func NewTenancyClient(cc grpc.ClientConnInterface) TenancyClient {
	return &tenancyClient{cc}
}

func (c *tenancyClient) Create(ctx context.Context, in *TenantCreateRequest, opts ...grpc.CallOption) (*TenantCreateResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(TenantCreateResponse)
	err := c.cc.Invoke(ctx, Tenancy_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tenancyClient) Delete(ctx context.Context, in *TenantDeleteRequest, opts ...grpc.CallOption) (*TenantDeleteResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(TenantDeleteResponse)
	err := c.cc.Invoke(ctx, Tenancy_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tenancyClient) List(ctx context.Context, in *TenantListRequest, opts ...grpc.CallOption) (*TenantListResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(TenantListResponse)
	err := c.cc.Invoke(ctx, Tenancy_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TenancyServer is the server API for Tenancy service.
// All implementations must embed UnimplementedTenancyServer
// for forward compatibility.
type TenancyServer interface {
	// Create is a unary RPC to create a new tenant.
	// It requires a TenantCreateRequest and returns a TenantCreateResponse.
	Create(context.Context, *TenantCreateRequest) (*TenantCreateResponse, error)
	// Delete is a unary RPC to delete an existing tenant.
	// It requires a TenantDeleteRequest and returns a TenantDeleteResponse.
	Delete(context.Context, *TenantDeleteRequest) (*TenantDeleteResponse, error)
	// List is a unary RPC to get a list of all tenants.
	// It requires a TenantListRequest and returns a TenantListResponse.
	List(context.Context, *TenantListRequest) (*TenantListResponse, error)
	mustEmbedUnimplementedTenancyServer()
}

// UnimplementedTenancyServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedTenancyServer struct{}

func (UnimplementedTenancyServer) Create(context.Context, *TenantCreateRequest) (*TenantCreateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedTenancyServer) Delete(context.Context, *TenantDeleteRequest) (*TenantDeleteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedTenancyServer) List(context.Context, *TenantListRequest) (*TenantListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedTenancyServer) mustEmbedUnimplementedTenancyServer() {}
func (UnimplementedTenancyServer) testEmbeddedByValue()                 {}

// UnsafeTenancyServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TenancyServer will
// result in compilation errors.
type UnsafeTenancyServer interface {
	mustEmbedUnimplementedTenancyServer()
}

func RegisterTenancyServer(s grpc.ServiceRegistrar, srv TenancyServer) {
	// If the following call pancis, it indicates UnimplementedTenancyServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Tenancy_ServiceDesc, srv)
}

func _Tenancy_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TenantCreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenancyServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tenancy_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenancyServer).Create(ctx, req.(*TenantCreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tenancy_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TenantDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenancyServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tenancy_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenancyServer).Delete(ctx, req.(*TenantDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tenancy_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TenantListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenancyServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tenancy_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenancyServer).List(ctx, req.(*TenantListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Tenancy_ServiceDesc is the grpc.ServiceDesc for Tenancy service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Tenancy_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "base.v1.Tenancy",
	HandlerType: (*TenancyServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _Tenancy_Create_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _Tenancy_Delete_Handler,
		},
		{
			MethodName: "List",
			Handler:    _Tenancy_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "base/v1/service.proto",
}
