// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: base/v1/service.proto

package basev1

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on PermissionCheckRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PermissionCheckRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionCheckRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// PermissionCheckRequestMultiError, or nil if none found.
func (m *PermissionCheckRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionCheckRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := PermissionCheckRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_PermissionCheckRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := PermissionCheckRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadata() == nil {
		err := PermissionCheckRequestValidationError{
			field:  "Metadata",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionCheckRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionCheckRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionCheckRequestValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetEntity() == nil {
		err := PermissionCheckRequestValidationError{
			field:  "Entity",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetEntity()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionCheckRequestValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionCheckRequestValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEntity()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionCheckRequestValidationError{
				field:  "Entity",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetPermission()) > 64 {
		err := PermissionCheckRequestValidationError{
			field:  "Permission",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_PermissionCheckRequest_Permission_Pattern.MatchString(m.GetPermission()) {
		err := PermissionCheckRequestValidationError{
			field:  "Permission",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetSubject() == nil {
		err := PermissionCheckRequestValidationError{
			field:  "Subject",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetSubject()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionCheckRequestValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionCheckRequestValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSubject()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionCheckRequestValidationError{
				field:  "Subject",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionCheckRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionCheckRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionCheckRequestValidationError{
				field:  "Context",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetArguments() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, PermissionCheckRequestValidationError{
						field:  fmt.Sprintf("Arguments[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, PermissionCheckRequestValidationError{
						field:  fmt.Sprintf("Arguments[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return PermissionCheckRequestValidationError{
					field:  fmt.Sprintf("Arguments[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return PermissionCheckRequestMultiError(errors)
	}

	return nil
}

// PermissionCheckRequestMultiError is an error wrapping multiple validation
// errors returned by PermissionCheckRequest.ValidateAll() if the designated
// constraints aren't met.
type PermissionCheckRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionCheckRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionCheckRequestMultiError) AllErrors() []error { return m }

// PermissionCheckRequestValidationError is the validation error returned by
// PermissionCheckRequest.Validate if the designated constraints aren't met.
type PermissionCheckRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionCheckRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionCheckRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionCheckRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionCheckRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionCheckRequestValidationError) ErrorName() string {
	return "PermissionCheckRequestValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionCheckRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionCheckRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionCheckRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionCheckRequestValidationError{}

var _PermissionCheckRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

var _PermissionCheckRequest_Permission_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on PermissionCheckRequestMetadata with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PermissionCheckRequestMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionCheckRequestMetadata with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// PermissionCheckRequestMetadataMultiError, or nil if none found.
func (m *PermissionCheckRequestMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionCheckRequestMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SchemaVersion

	// no validation rules for SnapToken

	if m.GetDepth() < 3 {
		err := PermissionCheckRequestMetadataValidationError{
			field:  "Depth",
			reason: "value must be greater than or equal to 3",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return PermissionCheckRequestMetadataMultiError(errors)
	}

	return nil
}

// PermissionCheckRequestMetadataMultiError is an error wrapping multiple
// validation errors returned by PermissionCheckRequestMetadata.ValidateAll()
// if the designated constraints aren't met.
type PermissionCheckRequestMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionCheckRequestMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionCheckRequestMetadataMultiError) AllErrors() []error { return m }

// PermissionCheckRequestMetadataValidationError is the validation error
// returned by PermissionCheckRequestMetadata.Validate if the designated
// constraints aren't met.
type PermissionCheckRequestMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionCheckRequestMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionCheckRequestMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionCheckRequestMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionCheckRequestMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionCheckRequestMetadataValidationError) ErrorName() string {
	return "PermissionCheckRequestMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionCheckRequestMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionCheckRequestMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionCheckRequestMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionCheckRequestMetadataValidationError{}

// Validate checks the field values on PermissionCheckResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PermissionCheckResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionCheckResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// PermissionCheckResponseMultiError, or nil if none found.
func (m *PermissionCheckResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionCheckResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Can

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionCheckResponseValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionCheckResponseValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionCheckResponseValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return PermissionCheckResponseMultiError(errors)
	}

	return nil
}

// PermissionCheckResponseMultiError is an error wrapping multiple validation
// errors returned by PermissionCheckResponse.ValidateAll() if the designated
// constraints aren't met.
type PermissionCheckResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionCheckResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionCheckResponseMultiError) AllErrors() []error { return m }

// PermissionCheckResponseValidationError is the validation error returned by
// PermissionCheckResponse.Validate if the designated constraints aren't met.
type PermissionCheckResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionCheckResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionCheckResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionCheckResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionCheckResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionCheckResponseValidationError) ErrorName() string {
	return "PermissionCheckResponseValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionCheckResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionCheckResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionCheckResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionCheckResponseValidationError{}

// Validate checks the field values on PermissionCheckResponseMetadata with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PermissionCheckResponseMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionCheckResponseMetadata with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// PermissionCheckResponseMetadataMultiError, or nil if none found.
func (m *PermissionCheckResponseMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionCheckResponseMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for CheckCount

	if len(errors) > 0 {
		return PermissionCheckResponseMetadataMultiError(errors)
	}

	return nil
}

// PermissionCheckResponseMetadataMultiError is an error wrapping multiple
// validation errors returned by PermissionCheckResponseMetadata.ValidateAll()
// if the designated constraints aren't met.
type PermissionCheckResponseMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionCheckResponseMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionCheckResponseMetadataMultiError) AllErrors() []error { return m }

// PermissionCheckResponseMetadataValidationError is the validation error
// returned by PermissionCheckResponseMetadata.Validate if the designated
// constraints aren't met.
type PermissionCheckResponseMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionCheckResponseMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionCheckResponseMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionCheckResponseMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionCheckResponseMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionCheckResponseMetadataValidationError) ErrorName() string {
	return "PermissionCheckResponseMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionCheckResponseMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionCheckResponseMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionCheckResponseMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionCheckResponseMetadataValidationError{}

// Validate checks the field values on PermissionExpandRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PermissionExpandRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionExpandRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// PermissionExpandRequestMultiError, or nil if none found.
func (m *PermissionExpandRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionExpandRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := PermissionExpandRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_PermissionExpandRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := PermissionExpandRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadata() == nil {
		err := PermissionExpandRequestValidationError{
			field:  "Metadata",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionExpandRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionExpandRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionExpandRequestValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetEntity() == nil {
		err := PermissionExpandRequestValidationError{
			field:  "Entity",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetEntity()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionExpandRequestValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionExpandRequestValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEntity()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionExpandRequestValidationError{
				field:  "Entity",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetPermission() != "" {

		if len(m.GetPermission()) > 64 {
			err := PermissionExpandRequestValidationError{
				field:  "Permission",
				reason: "value length must be at most 64 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_PermissionExpandRequest_Permission_Pattern.MatchString(m.GetPermission()) {
			err := PermissionExpandRequestValidationError{
				field:  "Permission",
				reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionExpandRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionExpandRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionExpandRequestValidationError{
				field:  "Context",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetArguments() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, PermissionExpandRequestValidationError{
						field:  fmt.Sprintf("Arguments[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, PermissionExpandRequestValidationError{
						field:  fmt.Sprintf("Arguments[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return PermissionExpandRequestValidationError{
					field:  fmt.Sprintf("Arguments[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return PermissionExpandRequestMultiError(errors)
	}

	return nil
}

// PermissionExpandRequestMultiError is an error wrapping multiple validation
// errors returned by PermissionExpandRequest.ValidateAll() if the designated
// constraints aren't met.
type PermissionExpandRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionExpandRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionExpandRequestMultiError) AllErrors() []error { return m }

// PermissionExpandRequestValidationError is the validation error returned by
// PermissionExpandRequest.Validate if the designated constraints aren't met.
type PermissionExpandRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionExpandRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionExpandRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionExpandRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionExpandRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionExpandRequestValidationError) ErrorName() string {
	return "PermissionExpandRequestValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionExpandRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionExpandRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionExpandRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionExpandRequestValidationError{}

var _PermissionExpandRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

var _PermissionExpandRequest_Permission_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on PermissionExpandRequestMetadata with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PermissionExpandRequestMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionExpandRequestMetadata with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// PermissionExpandRequestMetadataMultiError, or nil if none found.
func (m *PermissionExpandRequestMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionExpandRequestMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SchemaVersion

	// no validation rules for SnapToken

	if len(errors) > 0 {
		return PermissionExpandRequestMetadataMultiError(errors)
	}

	return nil
}

// PermissionExpandRequestMetadataMultiError is an error wrapping multiple
// validation errors returned by PermissionExpandRequestMetadata.ValidateAll()
// if the designated constraints aren't met.
type PermissionExpandRequestMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionExpandRequestMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionExpandRequestMetadataMultiError) AllErrors() []error { return m }

// PermissionExpandRequestMetadataValidationError is the validation error
// returned by PermissionExpandRequestMetadata.Validate if the designated
// constraints aren't met.
type PermissionExpandRequestMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionExpandRequestMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionExpandRequestMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionExpandRequestMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionExpandRequestMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionExpandRequestMetadataValidationError) ErrorName() string {
	return "PermissionExpandRequestMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionExpandRequestMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionExpandRequestMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionExpandRequestMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionExpandRequestMetadataValidationError{}

// Validate checks the field values on PermissionExpandResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PermissionExpandResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionExpandResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// PermissionExpandResponseMultiError, or nil if none found.
func (m *PermissionExpandResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionExpandResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetTree()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionExpandResponseValidationError{
					field:  "Tree",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionExpandResponseValidationError{
					field:  "Tree",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTree()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionExpandResponseValidationError{
				field:  "Tree",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return PermissionExpandResponseMultiError(errors)
	}

	return nil
}

// PermissionExpandResponseMultiError is an error wrapping multiple validation
// errors returned by PermissionExpandResponse.ValidateAll() if the designated
// constraints aren't met.
type PermissionExpandResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionExpandResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionExpandResponseMultiError) AllErrors() []error { return m }

// PermissionExpandResponseValidationError is the validation error returned by
// PermissionExpandResponse.Validate if the designated constraints aren't met.
type PermissionExpandResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionExpandResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionExpandResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionExpandResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionExpandResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionExpandResponseValidationError) ErrorName() string {
	return "PermissionExpandResponseValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionExpandResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionExpandResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionExpandResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionExpandResponseValidationError{}

// Validate checks the field values on PermissionLookupEntityRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PermissionLookupEntityRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionLookupEntityRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// PermissionLookupEntityRequestMultiError, or nil if none found.
func (m *PermissionLookupEntityRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionLookupEntityRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := PermissionLookupEntityRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_PermissionLookupEntityRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := PermissionLookupEntityRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadata() == nil {
		err := PermissionLookupEntityRequestValidationError{
			field:  "Metadata",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionLookupEntityRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionLookupEntityRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionLookupEntityRequestValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetEntityType()) > 64 {
		err := PermissionLookupEntityRequestValidationError{
			field:  "EntityType",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_PermissionLookupEntityRequest_EntityType_Pattern.MatchString(m.GetEntityType()) {
		err := PermissionLookupEntityRequestValidationError{
			field:  "EntityType",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetPermission()) > 64 {
		err := PermissionLookupEntityRequestValidationError{
			field:  "Permission",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_PermissionLookupEntityRequest_Permission_Pattern.MatchString(m.GetPermission()) {
		err := PermissionLookupEntityRequestValidationError{
			field:  "Permission",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetSubject() == nil {
		err := PermissionLookupEntityRequestValidationError{
			field:  "Subject",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetSubject()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionLookupEntityRequestValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionLookupEntityRequestValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSubject()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionLookupEntityRequestValidationError{
				field:  "Subject",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionLookupEntityRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionLookupEntityRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionLookupEntityRequestValidationError{
				field:  "Context",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	{
		sorted_keys := make([]string, len(m.GetScope()))
		i := 0
		for key := range m.GetScope() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetScope()[key]
			_ = val

			// no validation rules for Scope[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, PermissionLookupEntityRequestValidationError{
							field:  fmt.Sprintf("Scope[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, PermissionLookupEntityRequestValidationError{
							field:  fmt.Sprintf("Scope[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return PermissionLookupEntityRequestValidationError{
						field:  fmt.Sprintf("Scope[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if m.GetPageSize() != 0 {

		if m.GetPageSize() < 1 {
			err := PermissionLookupEntityRequestValidationError{
				field:  "PageSize",
				reason: "value must be greater than or equal to 1",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.GetContinuousToken() != "" {

	}

	if len(errors) > 0 {
		return PermissionLookupEntityRequestMultiError(errors)
	}

	return nil
}

// PermissionLookupEntityRequestMultiError is an error wrapping multiple
// validation errors returned by PermissionLookupEntityRequest.ValidateAll()
// if the designated constraints aren't met.
type PermissionLookupEntityRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionLookupEntityRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionLookupEntityRequestMultiError) AllErrors() []error { return m }

// PermissionLookupEntityRequestValidationError is the validation error
// returned by PermissionLookupEntityRequest.Validate if the designated
// constraints aren't met.
type PermissionLookupEntityRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionLookupEntityRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionLookupEntityRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionLookupEntityRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionLookupEntityRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionLookupEntityRequestValidationError) ErrorName() string {
	return "PermissionLookupEntityRequestValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionLookupEntityRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionLookupEntityRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionLookupEntityRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionLookupEntityRequestValidationError{}

var _PermissionLookupEntityRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

var _PermissionLookupEntityRequest_EntityType_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

var _PermissionLookupEntityRequest_Permission_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on PermissionLookupEntityRequestMetadata
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *PermissionLookupEntityRequestMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionLookupEntityRequestMetadata
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// PermissionLookupEntityRequestMetadataMultiError, or nil if none found.
func (m *PermissionLookupEntityRequestMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionLookupEntityRequestMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SchemaVersion

	// no validation rules for SnapToken

	if m.GetDepth() < 3 {
		err := PermissionLookupEntityRequestMetadataValidationError{
			field:  "Depth",
			reason: "value must be greater than or equal to 3",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return PermissionLookupEntityRequestMetadataMultiError(errors)
	}

	return nil
}

// PermissionLookupEntityRequestMetadataMultiError is an error wrapping
// multiple validation errors returned by
// PermissionLookupEntityRequestMetadata.ValidateAll() if the designated
// constraints aren't met.
type PermissionLookupEntityRequestMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionLookupEntityRequestMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionLookupEntityRequestMetadataMultiError) AllErrors() []error { return m }

// PermissionLookupEntityRequestMetadataValidationError is the validation error
// returned by PermissionLookupEntityRequestMetadata.Validate if the
// designated constraints aren't met.
type PermissionLookupEntityRequestMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionLookupEntityRequestMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionLookupEntityRequestMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionLookupEntityRequestMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionLookupEntityRequestMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionLookupEntityRequestMetadataValidationError) ErrorName() string {
	return "PermissionLookupEntityRequestMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionLookupEntityRequestMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionLookupEntityRequestMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionLookupEntityRequestMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionLookupEntityRequestMetadataValidationError{}

// Validate checks the field values on PermissionLookupEntityResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PermissionLookupEntityResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionLookupEntityResponse with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// PermissionLookupEntityResponseMultiError, or nil if none found.
func (m *PermissionLookupEntityResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionLookupEntityResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for ContinuousToken

	if len(errors) > 0 {
		return PermissionLookupEntityResponseMultiError(errors)
	}

	return nil
}

// PermissionLookupEntityResponseMultiError is an error wrapping multiple
// validation errors returned by PermissionLookupEntityResponse.ValidateAll()
// if the designated constraints aren't met.
type PermissionLookupEntityResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionLookupEntityResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionLookupEntityResponseMultiError) AllErrors() []error { return m }

// PermissionLookupEntityResponseValidationError is the validation error
// returned by PermissionLookupEntityResponse.Validate if the designated
// constraints aren't met.
type PermissionLookupEntityResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionLookupEntityResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionLookupEntityResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionLookupEntityResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionLookupEntityResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionLookupEntityResponseValidationError) ErrorName() string {
	return "PermissionLookupEntityResponseValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionLookupEntityResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionLookupEntityResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionLookupEntityResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionLookupEntityResponseValidationError{}

// Validate checks the field values on PermissionLookupEntityStreamResponse
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *PermissionLookupEntityStreamResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionLookupEntityStreamResponse
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// PermissionLookupEntityStreamResponseMultiError, or nil if none found.
func (m *PermissionLookupEntityStreamResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionLookupEntityStreamResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for EntityId

	// no validation rules for ContinuousToken

	if len(errors) > 0 {
		return PermissionLookupEntityStreamResponseMultiError(errors)
	}

	return nil
}

// PermissionLookupEntityStreamResponseMultiError is an error wrapping multiple
// validation errors returned by
// PermissionLookupEntityStreamResponse.ValidateAll() if the designated
// constraints aren't met.
type PermissionLookupEntityStreamResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionLookupEntityStreamResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionLookupEntityStreamResponseMultiError) AllErrors() []error { return m }

// PermissionLookupEntityStreamResponseValidationError is the validation error
// returned by PermissionLookupEntityStreamResponse.Validate if the designated
// constraints aren't met.
type PermissionLookupEntityStreamResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionLookupEntityStreamResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionLookupEntityStreamResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionLookupEntityStreamResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionLookupEntityStreamResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionLookupEntityStreamResponseValidationError) ErrorName() string {
	return "PermissionLookupEntityStreamResponseValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionLookupEntityStreamResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionLookupEntityStreamResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionLookupEntityStreamResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionLookupEntityStreamResponseValidationError{}

// Validate checks the field values on PermissionEntityFilterRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PermissionEntityFilterRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionEntityFilterRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// PermissionEntityFilterRequestMultiError, or nil if none found.
func (m *PermissionEntityFilterRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionEntityFilterRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := PermissionEntityFilterRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_PermissionEntityFilterRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := PermissionEntityFilterRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadata() == nil {
		err := PermissionEntityFilterRequestValidationError{
			field:  "Metadata",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionEntityFilterRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionEntityFilterRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionEntityFilterRequestValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetEntrance()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionEntityFilterRequestValidationError{
					field:  "Entrance",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionEntityFilterRequestValidationError{
					field:  "Entrance",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEntrance()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionEntityFilterRequestValidationError{
				field:  "Entrance",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetSubject()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionEntityFilterRequestValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionEntityFilterRequestValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSubject()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionEntityFilterRequestValidationError{
				field:  "Subject",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionEntityFilterRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionEntityFilterRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionEntityFilterRequestValidationError{
				field:  "Context",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	{
		sorted_keys := make([]string, len(m.GetScope()))
		i := 0
		for key := range m.GetScope() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetScope()[key]
			_ = val

			// no validation rules for Scope[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, PermissionEntityFilterRequestValidationError{
							field:  fmt.Sprintf("Scope[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, PermissionEntityFilterRequestValidationError{
							field:  fmt.Sprintf("Scope[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return PermissionEntityFilterRequestValidationError{
						field:  fmt.Sprintf("Scope[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if m.GetCursor() != "" {

	}

	if len(errors) > 0 {
		return PermissionEntityFilterRequestMultiError(errors)
	}

	return nil
}

// PermissionEntityFilterRequestMultiError is an error wrapping multiple
// validation errors returned by PermissionEntityFilterRequest.ValidateAll()
// if the designated constraints aren't met.
type PermissionEntityFilterRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionEntityFilterRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionEntityFilterRequestMultiError) AllErrors() []error { return m }

// PermissionEntityFilterRequestValidationError is the validation error
// returned by PermissionEntityFilterRequest.Validate if the designated
// constraints aren't met.
type PermissionEntityFilterRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionEntityFilterRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionEntityFilterRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionEntityFilterRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionEntityFilterRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionEntityFilterRequestValidationError) ErrorName() string {
	return "PermissionEntityFilterRequestValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionEntityFilterRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionEntityFilterRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionEntityFilterRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionEntityFilterRequestValidationError{}

var _PermissionEntityFilterRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on PermissionEntityFilterRequestMetadata
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *PermissionEntityFilterRequestMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionEntityFilterRequestMetadata
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// PermissionEntityFilterRequestMetadataMultiError, or nil if none found.
func (m *PermissionEntityFilterRequestMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionEntityFilterRequestMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SchemaVersion

	// no validation rules for SnapToken

	if m.GetDepth() < 3 {
		err := PermissionEntityFilterRequestMetadataValidationError{
			field:  "Depth",
			reason: "value must be greater than or equal to 3",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return PermissionEntityFilterRequestMetadataMultiError(errors)
	}

	return nil
}

// PermissionEntityFilterRequestMetadataMultiError is an error wrapping
// multiple validation errors returned by
// PermissionEntityFilterRequestMetadata.ValidateAll() if the designated
// constraints aren't met.
type PermissionEntityFilterRequestMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionEntityFilterRequestMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionEntityFilterRequestMetadataMultiError) AllErrors() []error { return m }

// PermissionEntityFilterRequestMetadataValidationError is the validation error
// returned by PermissionEntityFilterRequestMetadata.Validate if the
// designated constraints aren't met.
type PermissionEntityFilterRequestMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionEntityFilterRequestMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionEntityFilterRequestMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionEntityFilterRequestMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionEntityFilterRequestMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionEntityFilterRequestMetadataValidationError) ErrorName() string {
	return "PermissionEntityFilterRequestMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionEntityFilterRequestMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionEntityFilterRequestMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionEntityFilterRequestMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionEntityFilterRequestMetadataValidationError{}

// Validate checks the field values on PermissionLookupSubjectRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PermissionLookupSubjectRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionLookupSubjectRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// PermissionLookupSubjectRequestMultiError, or nil if none found.
func (m *PermissionLookupSubjectRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionLookupSubjectRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := PermissionLookupSubjectRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_PermissionLookupSubjectRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := PermissionLookupSubjectRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadata() == nil {
		err := PermissionLookupSubjectRequestValidationError{
			field:  "Metadata",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionLookupSubjectRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionLookupSubjectRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionLookupSubjectRequestValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetEntity() == nil {
		err := PermissionLookupSubjectRequestValidationError{
			field:  "Entity",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetEntity()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionLookupSubjectRequestValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionLookupSubjectRequestValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEntity()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionLookupSubjectRequestValidationError{
				field:  "Entity",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetPermission()) > 64 {
		err := PermissionLookupSubjectRequestValidationError{
			field:  "Permission",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_PermissionLookupSubjectRequest_Permission_Pattern.MatchString(m.GetPermission()) {
		err := PermissionLookupSubjectRequestValidationError{
			field:  "Permission",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetSubjectReference() == nil {
		err := PermissionLookupSubjectRequestValidationError{
			field:  "SubjectReference",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetSubjectReference()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionLookupSubjectRequestValidationError{
					field:  "SubjectReference",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionLookupSubjectRequestValidationError{
					field:  "SubjectReference",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSubjectReference()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionLookupSubjectRequestValidationError{
				field:  "SubjectReference",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionLookupSubjectRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionLookupSubjectRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionLookupSubjectRequestValidationError{
				field:  "Context",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetArguments() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, PermissionLookupSubjectRequestValidationError{
						field:  fmt.Sprintf("Arguments[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, PermissionLookupSubjectRequestValidationError{
						field:  fmt.Sprintf("Arguments[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return PermissionLookupSubjectRequestValidationError{
					field:  fmt.Sprintf("Arguments[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if m.GetPageSize() != 0 {

		if m.GetPageSize() < 1 {
			err := PermissionLookupSubjectRequestValidationError{
				field:  "PageSize",
				reason: "value must be greater than or equal to 1",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.GetContinuousToken() != "" {

	}

	if len(errors) > 0 {
		return PermissionLookupSubjectRequestMultiError(errors)
	}

	return nil
}

// PermissionLookupSubjectRequestMultiError is an error wrapping multiple
// validation errors returned by PermissionLookupSubjectRequest.ValidateAll()
// if the designated constraints aren't met.
type PermissionLookupSubjectRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionLookupSubjectRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionLookupSubjectRequestMultiError) AllErrors() []error { return m }

// PermissionLookupSubjectRequestValidationError is the validation error
// returned by PermissionLookupSubjectRequest.Validate if the designated
// constraints aren't met.
type PermissionLookupSubjectRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionLookupSubjectRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionLookupSubjectRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionLookupSubjectRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionLookupSubjectRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionLookupSubjectRequestValidationError) ErrorName() string {
	return "PermissionLookupSubjectRequestValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionLookupSubjectRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionLookupSubjectRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionLookupSubjectRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionLookupSubjectRequestValidationError{}

var _PermissionLookupSubjectRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

var _PermissionLookupSubjectRequest_Permission_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on PermissionLookupSubjectRequestMetadata
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *PermissionLookupSubjectRequestMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// PermissionLookupSubjectRequestMetadata with the rules defined in the proto
// definition for this message. If any rules are violated, the result is a
// list of violation errors wrapped in
// PermissionLookupSubjectRequestMetadataMultiError, or nil if none found.
func (m *PermissionLookupSubjectRequestMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionLookupSubjectRequestMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SchemaVersion

	// no validation rules for SnapToken

	if m.GetDepth() < 3 {
		err := PermissionLookupSubjectRequestMetadataValidationError{
			field:  "Depth",
			reason: "value must be greater than or equal to 3",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return PermissionLookupSubjectRequestMetadataMultiError(errors)
	}

	return nil
}

// PermissionLookupSubjectRequestMetadataMultiError is an error wrapping
// multiple validation errors returned by
// PermissionLookupSubjectRequestMetadata.ValidateAll() if the designated
// constraints aren't met.
type PermissionLookupSubjectRequestMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionLookupSubjectRequestMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionLookupSubjectRequestMetadataMultiError) AllErrors() []error { return m }

// PermissionLookupSubjectRequestMetadataValidationError is the validation
// error returned by PermissionLookupSubjectRequestMetadata.Validate if the
// designated constraints aren't met.
type PermissionLookupSubjectRequestMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionLookupSubjectRequestMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionLookupSubjectRequestMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionLookupSubjectRequestMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionLookupSubjectRequestMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionLookupSubjectRequestMetadataValidationError) ErrorName() string {
	return "PermissionLookupSubjectRequestMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionLookupSubjectRequestMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionLookupSubjectRequestMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionLookupSubjectRequestMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionLookupSubjectRequestMetadataValidationError{}

// Validate checks the field values on PermissionLookupSubjectResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PermissionLookupSubjectResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionLookupSubjectResponse with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// PermissionLookupSubjectResponseMultiError, or nil if none found.
func (m *PermissionLookupSubjectResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionLookupSubjectResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for ContinuousToken

	if len(errors) > 0 {
		return PermissionLookupSubjectResponseMultiError(errors)
	}

	return nil
}

// PermissionLookupSubjectResponseMultiError is an error wrapping multiple
// validation errors returned by PermissionLookupSubjectResponse.ValidateAll()
// if the designated constraints aren't met.
type PermissionLookupSubjectResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionLookupSubjectResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionLookupSubjectResponseMultiError) AllErrors() []error { return m }

// PermissionLookupSubjectResponseValidationError is the validation error
// returned by PermissionLookupSubjectResponse.Validate if the designated
// constraints aren't met.
type PermissionLookupSubjectResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionLookupSubjectResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionLookupSubjectResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionLookupSubjectResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionLookupSubjectResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionLookupSubjectResponseValidationError) ErrorName() string {
	return "PermissionLookupSubjectResponseValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionLookupSubjectResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionLookupSubjectResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionLookupSubjectResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionLookupSubjectResponseValidationError{}

// Validate checks the field values on PermissionSubjectPermissionRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *PermissionSubjectPermissionRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionSubjectPermissionRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// PermissionSubjectPermissionRequestMultiError, or nil if none found.
func (m *PermissionSubjectPermissionRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionSubjectPermissionRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := PermissionSubjectPermissionRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_PermissionSubjectPermissionRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := PermissionSubjectPermissionRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadata() == nil {
		err := PermissionSubjectPermissionRequestValidationError{
			field:  "Metadata",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionSubjectPermissionRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionSubjectPermissionRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionSubjectPermissionRequestValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetEntity() == nil {
		err := PermissionSubjectPermissionRequestValidationError{
			field:  "Entity",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetEntity()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionSubjectPermissionRequestValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionSubjectPermissionRequestValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEntity()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionSubjectPermissionRequestValidationError{
				field:  "Entity",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetSubject() == nil {
		err := PermissionSubjectPermissionRequestValidationError{
			field:  "Subject",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetSubject()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionSubjectPermissionRequestValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionSubjectPermissionRequestValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSubject()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionSubjectPermissionRequestValidationError{
				field:  "Subject",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionSubjectPermissionRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionSubjectPermissionRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionSubjectPermissionRequestValidationError{
				field:  "Context",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return PermissionSubjectPermissionRequestMultiError(errors)
	}

	return nil
}

// PermissionSubjectPermissionRequestMultiError is an error wrapping multiple
// validation errors returned by
// PermissionSubjectPermissionRequest.ValidateAll() if the designated
// constraints aren't met.
type PermissionSubjectPermissionRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionSubjectPermissionRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionSubjectPermissionRequestMultiError) AllErrors() []error { return m }

// PermissionSubjectPermissionRequestValidationError is the validation error
// returned by PermissionSubjectPermissionRequest.Validate if the designated
// constraints aren't met.
type PermissionSubjectPermissionRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionSubjectPermissionRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionSubjectPermissionRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionSubjectPermissionRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionSubjectPermissionRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionSubjectPermissionRequestValidationError) ErrorName() string {
	return "PermissionSubjectPermissionRequestValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionSubjectPermissionRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionSubjectPermissionRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionSubjectPermissionRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionSubjectPermissionRequestValidationError{}

var _PermissionSubjectPermissionRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on
// PermissionSubjectPermissionRequestMetadata with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *PermissionSubjectPermissionRequestMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// PermissionSubjectPermissionRequestMetadata with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// PermissionSubjectPermissionRequestMetadataMultiError, or nil if none found.
func (m *PermissionSubjectPermissionRequestMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionSubjectPermissionRequestMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SchemaVersion

	// no validation rules for SnapToken

	// no validation rules for OnlyPermission

	if m.GetDepth() < 3 {
		err := PermissionSubjectPermissionRequestMetadataValidationError{
			field:  "Depth",
			reason: "value must be greater than or equal to 3",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return PermissionSubjectPermissionRequestMetadataMultiError(errors)
	}

	return nil
}

// PermissionSubjectPermissionRequestMetadataMultiError is an error wrapping
// multiple validation errors returned by
// PermissionSubjectPermissionRequestMetadata.ValidateAll() if the designated
// constraints aren't met.
type PermissionSubjectPermissionRequestMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionSubjectPermissionRequestMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionSubjectPermissionRequestMetadataMultiError) AllErrors() []error { return m }

// PermissionSubjectPermissionRequestMetadataValidationError is the validation
// error returned by PermissionSubjectPermissionRequestMetadata.Validate if
// the designated constraints aren't met.
type PermissionSubjectPermissionRequestMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionSubjectPermissionRequestMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionSubjectPermissionRequestMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionSubjectPermissionRequestMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionSubjectPermissionRequestMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionSubjectPermissionRequestMetadataValidationError) ErrorName() string {
	return "PermissionSubjectPermissionRequestMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionSubjectPermissionRequestMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionSubjectPermissionRequestMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionSubjectPermissionRequestMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionSubjectPermissionRequestMetadataValidationError{}

// Validate checks the field values on PermissionSubjectPermissionResponse with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *PermissionSubjectPermissionResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionSubjectPermissionResponse
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// PermissionSubjectPermissionResponseMultiError, or nil if none found.
func (m *PermissionSubjectPermissionResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionSubjectPermissionResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Results

	if len(errors) > 0 {
		return PermissionSubjectPermissionResponseMultiError(errors)
	}

	return nil
}

// PermissionSubjectPermissionResponseMultiError is an error wrapping multiple
// validation errors returned by
// PermissionSubjectPermissionResponse.ValidateAll() if the designated
// constraints aren't met.
type PermissionSubjectPermissionResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionSubjectPermissionResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionSubjectPermissionResponseMultiError) AllErrors() []error { return m }

// PermissionSubjectPermissionResponseValidationError is the validation error
// returned by PermissionSubjectPermissionResponse.Validate if the designated
// constraints aren't met.
type PermissionSubjectPermissionResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionSubjectPermissionResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionSubjectPermissionResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionSubjectPermissionResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionSubjectPermissionResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionSubjectPermissionResponseValidationError) ErrorName() string {
	return "PermissionSubjectPermissionResponseValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionSubjectPermissionResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionSubjectPermissionResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionSubjectPermissionResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionSubjectPermissionResponseValidationError{}

// Validate checks the field values on WatchRequest with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *WatchRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on WatchRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in WatchRequestMultiError, or
// nil if none found.
func (m *WatchRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *WatchRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := WatchRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_WatchRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := WatchRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for SnapToken

	if len(errors) > 0 {
		return WatchRequestMultiError(errors)
	}

	return nil
}

// WatchRequestMultiError is an error wrapping multiple validation errors
// returned by WatchRequest.ValidateAll() if the designated constraints aren't met.
type WatchRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WatchRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WatchRequestMultiError) AllErrors() []error { return m }

// WatchRequestValidationError is the validation error returned by
// WatchRequest.Validate if the designated constraints aren't met.
type WatchRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WatchRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WatchRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WatchRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WatchRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WatchRequestValidationError) ErrorName() string { return "WatchRequestValidationError" }

// Error satisfies the builtin error interface
func (e WatchRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWatchRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WatchRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WatchRequestValidationError{}

var _WatchRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on WatchResponse with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *WatchResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on WatchResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in WatchResponseMultiError, or
// nil if none found.
func (m *WatchResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *WatchResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetChanges()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, WatchResponseValidationError{
					field:  "Changes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, WatchResponseValidationError{
					field:  "Changes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetChanges()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WatchResponseValidationError{
				field:  "Changes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return WatchResponseMultiError(errors)
	}

	return nil
}

// WatchResponseMultiError is an error wrapping multiple validation errors
// returned by WatchResponse.ValidateAll() if the designated constraints
// aren't met.
type WatchResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WatchResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WatchResponseMultiError) AllErrors() []error { return m }

// WatchResponseValidationError is the validation error returned by
// WatchResponse.Validate if the designated constraints aren't met.
type WatchResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WatchResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WatchResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WatchResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WatchResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WatchResponseValidationError) ErrorName() string { return "WatchResponseValidationError" }

// Error satisfies the builtin error interface
func (e WatchResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWatchResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WatchResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WatchResponseValidationError{}

// Validate checks the field values on SchemaWriteRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *SchemaWriteRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SchemaWriteRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// SchemaWriteRequestMultiError, or nil if none found.
func (m *SchemaWriteRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *SchemaWriteRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := SchemaWriteRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_SchemaWriteRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := SchemaWriteRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Schema

	if len(errors) > 0 {
		return SchemaWriteRequestMultiError(errors)
	}

	return nil
}

// SchemaWriteRequestMultiError is an error wrapping multiple validation errors
// returned by SchemaWriteRequest.ValidateAll() if the designated constraints
// aren't met.
type SchemaWriteRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SchemaWriteRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SchemaWriteRequestMultiError) AllErrors() []error { return m }

// SchemaWriteRequestValidationError is the validation error returned by
// SchemaWriteRequest.Validate if the designated constraints aren't met.
type SchemaWriteRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SchemaWriteRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SchemaWriteRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SchemaWriteRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SchemaWriteRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SchemaWriteRequestValidationError) ErrorName() string {
	return "SchemaWriteRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SchemaWriteRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSchemaWriteRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SchemaWriteRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SchemaWriteRequestValidationError{}

var _SchemaWriteRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on SchemaWriteResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *SchemaWriteResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SchemaWriteResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// SchemaWriteResponseMultiError, or nil if none found.
func (m *SchemaWriteResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *SchemaWriteResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SchemaVersion

	if len(errors) > 0 {
		return SchemaWriteResponseMultiError(errors)
	}

	return nil
}

// SchemaWriteResponseMultiError is an error wrapping multiple validation
// errors returned by SchemaWriteResponse.ValidateAll() if the designated
// constraints aren't met.
type SchemaWriteResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SchemaWriteResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SchemaWriteResponseMultiError) AllErrors() []error { return m }

// SchemaWriteResponseValidationError is the validation error returned by
// SchemaWriteResponse.Validate if the designated constraints aren't met.
type SchemaWriteResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SchemaWriteResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SchemaWriteResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SchemaWriteResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SchemaWriteResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SchemaWriteResponseValidationError) ErrorName() string {
	return "SchemaWriteResponseValidationError"
}

// Error satisfies the builtin error interface
func (e SchemaWriteResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSchemaWriteResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SchemaWriteResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SchemaWriteResponseValidationError{}

// Validate checks the field values on SchemaPartialWriteRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *SchemaPartialWriteRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SchemaPartialWriteRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// SchemaPartialWriteRequestMultiError, or nil if none found.
func (m *SchemaPartialWriteRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *SchemaPartialWriteRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := SchemaPartialWriteRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_SchemaPartialWriteRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := SchemaPartialWriteRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadata() == nil {
		err := SchemaPartialWriteRequestValidationError{
			field:  "Metadata",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, SchemaPartialWriteRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, SchemaPartialWriteRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return SchemaPartialWriteRequestValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	{
		sorted_keys := make([]string, len(m.GetPartials()))
		i := 0
		for key := range m.GetPartials() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetPartials()[key]
			_ = val

			// no validation rules for Partials[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, SchemaPartialWriteRequestValidationError{
							field:  fmt.Sprintf("Partials[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, SchemaPartialWriteRequestValidationError{
							field:  fmt.Sprintf("Partials[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return SchemaPartialWriteRequestValidationError{
						field:  fmt.Sprintf("Partials[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if len(errors) > 0 {
		return SchemaPartialWriteRequestMultiError(errors)
	}

	return nil
}

// SchemaPartialWriteRequestMultiError is an error wrapping multiple validation
// errors returned by SchemaPartialWriteRequest.ValidateAll() if the
// designated constraints aren't met.
type SchemaPartialWriteRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SchemaPartialWriteRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SchemaPartialWriteRequestMultiError) AllErrors() []error { return m }

// SchemaPartialWriteRequestValidationError is the validation error returned by
// SchemaPartialWriteRequest.Validate if the designated constraints aren't met.
type SchemaPartialWriteRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SchemaPartialWriteRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SchemaPartialWriteRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SchemaPartialWriteRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SchemaPartialWriteRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SchemaPartialWriteRequestValidationError) ErrorName() string {
	return "SchemaPartialWriteRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SchemaPartialWriteRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSchemaPartialWriteRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SchemaPartialWriteRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SchemaPartialWriteRequestValidationError{}

var _SchemaPartialWriteRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on SchemaPartialWriteRequestMetadata with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *SchemaPartialWriteRequestMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SchemaPartialWriteRequestMetadata
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// SchemaPartialWriteRequestMetadataMultiError, or nil if none found.
func (m *SchemaPartialWriteRequestMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *SchemaPartialWriteRequestMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SchemaVersion

	if len(errors) > 0 {
		return SchemaPartialWriteRequestMetadataMultiError(errors)
	}

	return nil
}

// SchemaPartialWriteRequestMetadataMultiError is an error wrapping multiple
// validation errors returned by
// SchemaPartialWriteRequestMetadata.ValidateAll() if the designated
// constraints aren't met.
type SchemaPartialWriteRequestMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SchemaPartialWriteRequestMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SchemaPartialWriteRequestMetadataMultiError) AllErrors() []error { return m }

// SchemaPartialWriteRequestMetadataValidationError is the validation error
// returned by SchemaPartialWriteRequestMetadata.Validate if the designated
// constraints aren't met.
type SchemaPartialWriteRequestMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SchemaPartialWriteRequestMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SchemaPartialWriteRequestMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SchemaPartialWriteRequestMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SchemaPartialWriteRequestMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SchemaPartialWriteRequestMetadataValidationError) ErrorName() string {
	return "SchemaPartialWriteRequestMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e SchemaPartialWriteRequestMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSchemaPartialWriteRequestMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SchemaPartialWriteRequestMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SchemaPartialWriteRequestMetadataValidationError{}

// Validate checks the field values on SchemaPartialWriteResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *SchemaPartialWriteResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SchemaPartialWriteResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// SchemaPartialWriteResponseMultiError, or nil if none found.
func (m *SchemaPartialWriteResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *SchemaPartialWriteResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SchemaVersion

	if len(errors) > 0 {
		return SchemaPartialWriteResponseMultiError(errors)
	}

	return nil
}

// SchemaPartialWriteResponseMultiError is an error wrapping multiple
// validation errors returned by SchemaPartialWriteResponse.ValidateAll() if
// the designated constraints aren't met.
type SchemaPartialWriteResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SchemaPartialWriteResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SchemaPartialWriteResponseMultiError) AllErrors() []error { return m }

// SchemaPartialWriteResponseValidationError is the validation error returned
// by SchemaPartialWriteResponse.Validate if the designated constraints aren't met.
type SchemaPartialWriteResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SchemaPartialWriteResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SchemaPartialWriteResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SchemaPartialWriteResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SchemaPartialWriteResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SchemaPartialWriteResponseValidationError) ErrorName() string {
	return "SchemaPartialWriteResponseValidationError"
}

// Error satisfies the builtin error interface
func (e SchemaPartialWriteResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSchemaPartialWriteResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SchemaPartialWriteResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SchemaPartialWriteResponseValidationError{}

// Validate checks the field values on SchemaReadRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *SchemaReadRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SchemaReadRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// SchemaReadRequestMultiError, or nil if none found.
func (m *SchemaReadRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *SchemaReadRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := SchemaReadRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_SchemaReadRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := SchemaReadRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadata() == nil {
		err := SchemaReadRequestValidationError{
			field:  "Metadata",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, SchemaReadRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, SchemaReadRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return SchemaReadRequestValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return SchemaReadRequestMultiError(errors)
	}

	return nil
}

// SchemaReadRequestMultiError is an error wrapping multiple validation errors
// returned by SchemaReadRequest.ValidateAll() if the designated constraints
// aren't met.
type SchemaReadRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SchemaReadRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SchemaReadRequestMultiError) AllErrors() []error { return m }

// SchemaReadRequestValidationError is the validation error returned by
// SchemaReadRequest.Validate if the designated constraints aren't met.
type SchemaReadRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SchemaReadRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SchemaReadRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SchemaReadRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SchemaReadRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SchemaReadRequestValidationError) ErrorName() string {
	return "SchemaReadRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SchemaReadRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSchemaReadRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SchemaReadRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SchemaReadRequestValidationError{}

var _SchemaReadRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on SchemaReadRequestMetadata with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *SchemaReadRequestMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SchemaReadRequestMetadata with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// SchemaReadRequestMetadataMultiError, or nil if none found.
func (m *SchemaReadRequestMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *SchemaReadRequestMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SchemaVersion

	if len(errors) > 0 {
		return SchemaReadRequestMetadataMultiError(errors)
	}

	return nil
}

// SchemaReadRequestMetadataMultiError is an error wrapping multiple validation
// errors returned by SchemaReadRequestMetadata.ValidateAll() if the
// designated constraints aren't met.
type SchemaReadRequestMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SchemaReadRequestMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SchemaReadRequestMetadataMultiError) AllErrors() []error { return m }

// SchemaReadRequestMetadataValidationError is the validation error returned by
// SchemaReadRequestMetadata.Validate if the designated constraints aren't met.
type SchemaReadRequestMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SchemaReadRequestMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SchemaReadRequestMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SchemaReadRequestMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SchemaReadRequestMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SchemaReadRequestMetadataValidationError) ErrorName() string {
	return "SchemaReadRequestMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e SchemaReadRequestMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSchemaReadRequestMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SchemaReadRequestMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SchemaReadRequestMetadataValidationError{}

// Validate checks the field values on SchemaReadResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *SchemaReadResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SchemaReadResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// SchemaReadResponseMultiError, or nil if none found.
func (m *SchemaReadResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *SchemaReadResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetSchema()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, SchemaReadResponseValidationError{
					field:  "Schema",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, SchemaReadResponseValidationError{
					field:  "Schema",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSchema()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return SchemaReadResponseValidationError{
				field:  "Schema",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return SchemaReadResponseMultiError(errors)
	}

	return nil
}

// SchemaReadResponseMultiError is an error wrapping multiple validation errors
// returned by SchemaReadResponse.ValidateAll() if the designated constraints
// aren't met.
type SchemaReadResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SchemaReadResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SchemaReadResponseMultiError) AllErrors() []error { return m }

// SchemaReadResponseValidationError is the validation error returned by
// SchemaReadResponse.Validate if the designated constraints aren't met.
type SchemaReadResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SchemaReadResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SchemaReadResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SchemaReadResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SchemaReadResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SchemaReadResponseValidationError) ErrorName() string {
	return "SchemaReadResponseValidationError"
}

// Error satisfies the builtin error interface
func (e SchemaReadResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSchemaReadResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SchemaReadResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SchemaReadResponseValidationError{}

// Validate checks the field values on SchemaListRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *SchemaListRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SchemaListRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// SchemaListRequestMultiError, or nil if none found.
func (m *SchemaListRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *SchemaListRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := SchemaListRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_SchemaListRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := SchemaListRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetPageSize() != 0 {

		if m.GetPageSize() < 1 {
			err := SchemaListRequestValidationError{
				field:  "PageSize",
				reason: "value must be greater than or equal to 1",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.GetContinuousToken() != "" {

	}

	if len(errors) > 0 {
		return SchemaListRequestMultiError(errors)
	}

	return nil
}

// SchemaListRequestMultiError is an error wrapping multiple validation errors
// returned by SchemaListRequest.ValidateAll() if the designated constraints
// aren't met.
type SchemaListRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SchemaListRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SchemaListRequestMultiError) AllErrors() []error { return m }

// SchemaListRequestValidationError is the validation error returned by
// SchemaListRequest.Validate if the designated constraints aren't met.
type SchemaListRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SchemaListRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SchemaListRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SchemaListRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SchemaListRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SchemaListRequestValidationError) ErrorName() string {
	return "SchemaListRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SchemaListRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSchemaListRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SchemaListRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SchemaListRequestValidationError{}

var _SchemaListRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on SchemaListResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *SchemaListResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SchemaListResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// SchemaListResponseMultiError, or nil if none found.
func (m *SchemaListResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *SchemaListResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Head

	for idx, item := range m.GetSchemas() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, SchemaListResponseValidationError{
						field:  fmt.Sprintf("Schemas[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, SchemaListResponseValidationError{
						field:  fmt.Sprintf("Schemas[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return SchemaListResponseValidationError{
					field:  fmt.Sprintf("Schemas[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for ContinuousToken

	if len(errors) > 0 {
		return SchemaListResponseMultiError(errors)
	}

	return nil
}

// SchemaListResponseMultiError is an error wrapping multiple validation errors
// returned by SchemaListResponse.ValidateAll() if the designated constraints
// aren't met.
type SchemaListResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SchemaListResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SchemaListResponseMultiError) AllErrors() []error { return m }

// SchemaListResponseValidationError is the validation error returned by
// SchemaListResponse.Validate if the designated constraints aren't met.
type SchemaListResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SchemaListResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SchemaListResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SchemaListResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SchemaListResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SchemaListResponseValidationError) ErrorName() string {
	return "SchemaListResponseValidationError"
}

// Error satisfies the builtin error interface
func (e SchemaListResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSchemaListResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SchemaListResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SchemaListResponseValidationError{}

// Validate checks the field values on SchemaList with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *SchemaList) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SchemaList with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in SchemaListMultiError, or
// nil if none found.
func (m *SchemaList) ValidateAll() error {
	return m.validate(true)
}

func (m *SchemaList) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Version

	// no validation rules for CreatedAt

	if len(errors) > 0 {
		return SchemaListMultiError(errors)
	}

	return nil
}

// SchemaListMultiError is an error wrapping multiple validation errors
// returned by SchemaList.ValidateAll() if the designated constraints aren't met.
type SchemaListMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SchemaListMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SchemaListMultiError) AllErrors() []error { return m }

// SchemaListValidationError is the validation error returned by
// SchemaList.Validate if the designated constraints aren't met.
type SchemaListValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SchemaListValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SchemaListValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SchemaListValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SchemaListValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SchemaListValidationError) ErrorName() string { return "SchemaListValidationError" }

// Error satisfies the builtin error interface
func (e SchemaListValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSchemaList.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SchemaListValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SchemaListValidationError{}

// Validate checks the field values on DataWriteRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *DataWriteRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DataWriteRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DataWriteRequestMultiError, or nil if none found.
func (m *DataWriteRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *DataWriteRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := DataWriteRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_DataWriteRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := DataWriteRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadata() == nil {
		err := DataWriteRequestValidationError{
			field:  "Metadata",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, DataWriteRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, DataWriteRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DataWriteRequestValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetTuples() {
		_, _ = idx, item

		if item == nil {
			err := DataWriteRequestValidationError{
				field:  fmt.Sprintf("Tuples[%v]", idx),
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DataWriteRequestValidationError{
						field:  fmt.Sprintf("Tuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DataWriteRequestValidationError{
						field:  fmt.Sprintf("Tuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DataWriteRequestValidationError{
					field:  fmt.Sprintf("Tuples[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetAttributes() {
		_, _ = idx, item

		if item == nil {
			err := DataWriteRequestValidationError{
				field:  fmt.Sprintf("Attributes[%v]", idx),
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DataWriteRequestValidationError{
						field:  fmt.Sprintf("Attributes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DataWriteRequestValidationError{
						field:  fmt.Sprintf("Attributes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DataWriteRequestValidationError{
					field:  fmt.Sprintf("Attributes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return DataWriteRequestMultiError(errors)
	}

	return nil
}

// DataWriteRequestMultiError is an error wrapping multiple validation errors
// returned by DataWriteRequest.ValidateAll() if the designated constraints
// aren't met.
type DataWriteRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DataWriteRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DataWriteRequestMultiError) AllErrors() []error { return m }

// DataWriteRequestValidationError is the validation error returned by
// DataWriteRequest.Validate if the designated constraints aren't met.
type DataWriteRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DataWriteRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DataWriteRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DataWriteRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DataWriteRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DataWriteRequestValidationError) ErrorName() string { return "DataWriteRequestValidationError" }

// Error satisfies the builtin error interface
func (e DataWriteRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDataWriteRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DataWriteRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DataWriteRequestValidationError{}

var _DataWriteRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on DataWriteRequestMetadata with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DataWriteRequestMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DataWriteRequestMetadata with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DataWriteRequestMetadataMultiError, or nil if none found.
func (m *DataWriteRequestMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *DataWriteRequestMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SchemaVersion

	if len(errors) > 0 {
		return DataWriteRequestMetadataMultiError(errors)
	}

	return nil
}

// DataWriteRequestMetadataMultiError is an error wrapping multiple validation
// errors returned by DataWriteRequestMetadata.ValidateAll() if the designated
// constraints aren't met.
type DataWriteRequestMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DataWriteRequestMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DataWriteRequestMetadataMultiError) AllErrors() []error { return m }

// DataWriteRequestMetadataValidationError is the validation error returned by
// DataWriteRequestMetadata.Validate if the designated constraints aren't met.
type DataWriteRequestMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DataWriteRequestMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DataWriteRequestMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DataWriteRequestMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DataWriteRequestMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DataWriteRequestMetadataValidationError) ErrorName() string {
	return "DataWriteRequestMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e DataWriteRequestMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDataWriteRequestMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DataWriteRequestMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DataWriteRequestMetadataValidationError{}

// Validate checks the field values on DataWriteResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *DataWriteResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DataWriteResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DataWriteResponseMultiError, or nil if none found.
func (m *DataWriteResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *DataWriteResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SnapToken

	if len(errors) > 0 {
		return DataWriteResponseMultiError(errors)
	}

	return nil
}

// DataWriteResponseMultiError is an error wrapping multiple validation errors
// returned by DataWriteResponse.ValidateAll() if the designated constraints
// aren't met.
type DataWriteResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DataWriteResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DataWriteResponseMultiError) AllErrors() []error { return m }

// DataWriteResponseValidationError is the validation error returned by
// DataWriteResponse.Validate if the designated constraints aren't met.
type DataWriteResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DataWriteResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DataWriteResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DataWriteResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DataWriteResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DataWriteResponseValidationError) ErrorName() string {
	return "DataWriteResponseValidationError"
}

// Error satisfies the builtin error interface
func (e DataWriteResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDataWriteResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DataWriteResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DataWriteResponseValidationError{}

// Validate checks the field values on RelationshipWriteRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RelationshipWriteRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationshipWriteRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RelationshipWriteRequestMultiError, or nil if none found.
func (m *RelationshipWriteRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationshipWriteRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := RelationshipWriteRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_RelationshipWriteRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := RelationshipWriteRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadata() == nil {
		err := RelationshipWriteRequestValidationError{
			field:  "Metadata",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RelationshipWriteRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RelationshipWriteRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RelationshipWriteRequestValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetTuples()) < 1 {
		err := RelationshipWriteRequestValidationError{
			field:  "Tuples",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetTuples() {
		_, _ = idx, item

		if item == nil {
			err := RelationshipWriteRequestValidationError{
				field:  fmt.Sprintf("Tuples[%v]", idx),
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RelationshipWriteRequestValidationError{
						field:  fmt.Sprintf("Tuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RelationshipWriteRequestValidationError{
						field:  fmt.Sprintf("Tuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RelationshipWriteRequestValidationError{
					field:  fmt.Sprintf("Tuples[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return RelationshipWriteRequestMultiError(errors)
	}

	return nil
}

// RelationshipWriteRequestMultiError is an error wrapping multiple validation
// errors returned by RelationshipWriteRequest.ValidateAll() if the designated
// constraints aren't met.
type RelationshipWriteRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationshipWriteRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationshipWriteRequestMultiError) AllErrors() []error { return m }

// RelationshipWriteRequestValidationError is the validation error returned by
// RelationshipWriteRequest.Validate if the designated constraints aren't met.
type RelationshipWriteRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationshipWriteRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationshipWriteRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationshipWriteRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationshipWriteRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationshipWriteRequestValidationError) ErrorName() string {
	return "RelationshipWriteRequestValidationError"
}

// Error satisfies the builtin error interface
func (e RelationshipWriteRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationshipWriteRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationshipWriteRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationshipWriteRequestValidationError{}

var _RelationshipWriteRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on RelationshipWriteRequestMetadata with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *RelationshipWriteRequestMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationshipWriteRequestMetadata with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RelationshipWriteRequestMetadataMultiError, or nil if none found.
func (m *RelationshipWriteRequestMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationshipWriteRequestMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SchemaVersion

	if len(errors) > 0 {
		return RelationshipWriteRequestMetadataMultiError(errors)
	}

	return nil
}

// RelationshipWriteRequestMetadataMultiError is an error wrapping multiple
// validation errors returned by
// RelationshipWriteRequestMetadata.ValidateAll() if the designated
// constraints aren't met.
type RelationshipWriteRequestMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationshipWriteRequestMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationshipWriteRequestMetadataMultiError) AllErrors() []error { return m }

// RelationshipWriteRequestMetadataValidationError is the validation error
// returned by RelationshipWriteRequestMetadata.Validate if the designated
// constraints aren't met.
type RelationshipWriteRequestMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationshipWriteRequestMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationshipWriteRequestMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationshipWriteRequestMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationshipWriteRequestMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationshipWriteRequestMetadataValidationError) ErrorName() string {
	return "RelationshipWriteRequestMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e RelationshipWriteRequestMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationshipWriteRequestMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationshipWriteRequestMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationshipWriteRequestMetadataValidationError{}

// Validate checks the field values on RelationshipWriteResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RelationshipWriteResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationshipWriteResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RelationshipWriteResponseMultiError, or nil if none found.
func (m *RelationshipWriteResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationshipWriteResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SnapToken

	if len(errors) > 0 {
		return RelationshipWriteResponseMultiError(errors)
	}

	return nil
}

// RelationshipWriteResponseMultiError is an error wrapping multiple validation
// errors returned by RelationshipWriteResponse.ValidateAll() if the
// designated constraints aren't met.
type RelationshipWriteResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationshipWriteResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationshipWriteResponseMultiError) AllErrors() []error { return m }

// RelationshipWriteResponseValidationError is the validation error returned by
// RelationshipWriteResponse.Validate if the designated constraints aren't met.
type RelationshipWriteResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationshipWriteResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationshipWriteResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationshipWriteResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationshipWriteResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationshipWriteResponseValidationError) ErrorName() string {
	return "RelationshipWriteResponseValidationError"
}

// Error satisfies the builtin error interface
func (e RelationshipWriteResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationshipWriteResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationshipWriteResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationshipWriteResponseValidationError{}

// Validate checks the field values on RelationshipReadRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RelationshipReadRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationshipReadRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RelationshipReadRequestMultiError, or nil if none found.
func (m *RelationshipReadRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationshipReadRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := RelationshipReadRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_RelationshipReadRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := RelationshipReadRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadata() == nil {
		err := RelationshipReadRequestValidationError{
			field:  "Metadata",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RelationshipReadRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RelationshipReadRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RelationshipReadRequestValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetFilter() == nil {
		err := RelationshipReadRequestValidationError{
			field:  "Filter",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetFilter()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RelationshipReadRequestValidationError{
					field:  "Filter",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RelationshipReadRequestValidationError{
					field:  "Filter",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFilter()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RelationshipReadRequestValidationError{
				field:  "Filter",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetPageSize() != 0 {

		if m.GetPageSize() < 1 {
			err := RelationshipReadRequestValidationError{
				field:  "PageSize",
				reason: "value must be greater than or equal to 1",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.GetContinuousToken() != "" {

	}

	if len(errors) > 0 {
		return RelationshipReadRequestMultiError(errors)
	}

	return nil
}

// RelationshipReadRequestMultiError is an error wrapping multiple validation
// errors returned by RelationshipReadRequest.ValidateAll() if the designated
// constraints aren't met.
type RelationshipReadRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationshipReadRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationshipReadRequestMultiError) AllErrors() []error { return m }

// RelationshipReadRequestValidationError is the validation error returned by
// RelationshipReadRequest.Validate if the designated constraints aren't met.
type RelationshipReadRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationshipReadRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationshipReadRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationshipReadRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationshipReadRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationshipReadRequestValidationError) ErrorName() string {
	return "RelationshipReadRequestValidationError"
}

// Error satisfies the builtin error interface
func (e RelationshipReadRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationshipReadRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationshipReadRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationshipReadRequestValidationError{}

var _RelationshipReadRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on RelationshipReadRequestMetadata with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RelationshipReadRequestMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationshipReadRequestMetadata with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RelationshipReadRequestMetadataMultiError, or nil if none found.
func (m *RelationshipReadRequestMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationshipReadRequestMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SnapToken

	if len(errors) > 0 {
		return RelationshipReadRequestMetadataMultiError(errors)
	}

	return nil
}

// RelationshipReadRequestMetadataMultiError is an error wrapping multiple
// validation errors returned by RelationshipReadRequestMetadata.ValidateAll()
// if the designated constraints aren't met.
type RelationshipReadRequestMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationshipReadRequestMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationshipReadRequestMetadataMultiError) AllErrors() []error { return m }

// RelationshipReadRequestMetadataValidationError is the validation error
// returned by RelationshipReadRequestMetadata.Validate if the designated
// constraints aren't met.
type RelationshipReadRequestMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationshipReadRequestMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationshipReadRequestMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationshipReadRequestMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationshipReadRequestMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationshipReadRequestMetadataValidationError) ErrorName() string {
	return "RelationshipReadRequestMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e RelationshipReadRequestMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationshipReadRequestMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationshipReadRequestMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationshipReadRequestMetadataValidationError{}

// Validate checks the field values on RelationshipReadResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RelationshipReadResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationshipReadResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RelationshipReadResponseMultiError, or nil if none found.
func (m *RelationshipReadResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationshipReadResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetTuples() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RelationshipReadResponseValidationError{
						field:  fmt.Sprintf("Tuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RelationshipReadResponseValidationError{
						field:  fmt.Sprintf("Tuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RelationshipReadResponseValidationError{
					field:  fmt.Sprintf("Tuples[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for ContinuousToken

	if len(errors) > 0 {
		return RelationshipReadResponseMultiError(errors)
	}

	return nil
}

// RelationshipReadResponseMultiError is an error wrapping multiple validation
// errors returned by RelationshipReadResponse.ValidateAll() if the designated
// constraints aren't met.
type RelationshipReadResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationshipReadResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationshipReadResponseMultiError) AllErrors() []error { return m }

// RelationshipReadResponseValidationError is the validation error returned by
// RelationshipReadResponse.Validate if the designated constraints aren't met.
type RelationshipReadResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationshipReadResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationshipReadResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationshipReadResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationshipReadResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationshipReadResponseValidationError) ErrorName() string {
	return "RelationshipReadResponseValidationError"
}

// Error satisfies the builtin error interface
func (e RelationshipReadResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationshipReadResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationshipReadResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationshipReadResponseValidationError{}

// Validate checks the field values on AttributeReadRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AttributeReadRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AttributeReadRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AttributeReadRequestMultiError, or nil if none found.
func (m *AttributeReadRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *AttributeReadRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := AttributeReadRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_AttributeReadRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := AttributeReadRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadata() == nil {
		err := AttributeReadRequestValidationError{
			field:  "Metadata",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AttributeReadRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AttributeReadRequestValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AttributeReadRequestValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetFilter() == nil {
		err := AttributeReadRequestValidationError{
			field:  "Filter",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetFilter()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AttributeReadRequestValidationError{
					field:  "Filter",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AttributeReadRequestValidationError{
					field:  "Filter",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFilter()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AttributeReadRequestValidationError{
				field:  "Filter",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetPageSize() != 0 {

		if m.GetPageSize() < 1 {
			err := AttributeReadRequestValidationError{
				field:  "PageSize",
				reason: "value must be greater than or equal to 1",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.GetContinuousToken() != "" {

	}

	if len(errors) > 0 {
		return AttributeReadRequestMultiError(errors)
	}

	return nil
}

// AttributeReadRequestMultiError is an error wrapping multiple validation
// errors returned by AttributeReadRequest.ValidateAll() if the designated
// constraints aren't met.
type AttributeReadRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AttributeReadRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AttributeReadRequestMultiError) AllErrors() []error { return m }

// AttributeReadRequestValidationError is the validation error returned by
// AttributeReadRequest.Validate if the designated constraints aren't met.
type AttributeReadRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AttributeReadRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AttributeReadRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AttributeReadRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AttributeReadRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AttributeReadRequestValidationError) ErrorName() string {
	return "AttributeReadRequestValidationError"
}

// Error satisfies the builtin error interface
func (e AttributeReadRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAttributeReadRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AttributeReadRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AttributeReadRequestValidationError{}

var _AttributeReadRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on AttributeReadRequestMetadata with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AttributeReadRequestMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AttributeReadRequestMetadata with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AttributeReadRequestMetadataMultiError, or nil if none found.
func (m *AttributeReadRequestMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *AttributeReadRequestMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SnapToken

	if len(errors) > 0 {
		return AttributeReadRequestMetadataMultiError(errors)
	}

	return nil
}

// AttributeReadRequestMetadataMultiError is an error wrapping multiple
// validation errors returned by AttributeReadRequestMetadata.ValidateAll() if
// the designated constraints aren't met.
type AttributeReadRequestMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AttributeReadRequestMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AttributeReadRequestMetadataMultiError) AllErrors() []error { return m }

// AttributeReadRequestMetadataValidationError is the validation error returned
// by AttributeReadRequestMetadata.Validate if the designated constraints
// aren't met.
type AttributeReadRequestMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AttributeReadRequestMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AttributeReadRequestMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AttributeReadRequestMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AttributeReadRequestMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AttributeReadRequestMetadataValidationError) ErrorName() string {
	return "AttributeReadRequestMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e AttributeReadRequestMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAttributeReadRequestMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AttributeReadRequestMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AttributeReadRequestMetadataValidationError{}

// Validate checks the field values on AttributeReadResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AttributeReadResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AttributeReadResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AttributeReadResponseMultiError, or nil if none found.
func (m *AttributeReadResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *AttributeReadResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetAttributes() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AttributeReadResponseValidationError{
						field:  fmt.Sprintf("Attributes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AttributeReadResponseValidationError{
						field:  fmt.Sprintf("Attributes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AttributeReadResponseValidationError{
					field:  fmt.Sprintf("Attributes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for ContinuousToken

	if len(errors) > 0 {
		return AttributeReadResponseMultiError(errors)
	}

	return nil
}

// AttributeReadResponseMultiError is an error wrapping multiple validation
// errors returned by AttributeReadResponse.ValidateAll() if the designated
// constraints aren't met.
type AttributeReadResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AttributeReadResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AttributeReadResponseMultiError) AllErrors() []error { return m }

// AttributeReadResponseValidationError is the validation error returned by
// AttributeReadResponse.Validate if the designated constraints aren't met.
type AttributeReadResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AttributeReadResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AttributeReadResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AttributeReadResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AttributeReadResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AttributeReadResponseValidationError) ErrorName() string {
	return "AttributeReadResponseValidationError"
}

// Error satisfies the builtin error interface
func (e AttributeReadResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAttributeReadResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AttributeReadResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AttributeReadResponseValidationError{}

// Validate checks the field values on DataDeleteRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *DataDeleteRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DataDeleteRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DataDeleteRequestMultiError, or nil if none found.
func (m *DataDeleteRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *DataDeleteRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := DataDeleteRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_DataDeleteRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := DataDeleteRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetTupleFilter() == nil {
		err := DataDeleteRequestValidationError{
			field:  "TupleFilter",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetTupleFilter()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, DataDeleteRequestValidationError{
					field:  "TupleFilter",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, DataDeleteRequestValidationError{
					field:  "TupleFilter",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTupleFilter()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DataDeleteRequestValidationError{
				field:  "TupleFilter",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetAttributeFilter() == nil {
		err := DataDeleteRequestValidationError{
			field:  "AttributeFilter",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetAttributeFilter()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, DataDeleteRequestValidationError{
					field:  "AttributeFilter",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, DataDeleteRequestValidationError{
					field:  "AttributeFilter",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAttributeFilter()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DataDeleteRequestValidationError{
				field:  "AttributeFilter",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return DataDeleteRequestMultiError(errors)
	}

	return nil
}

// DataDeleteRequestMultiError is an error wrapping multiple validation errors
// returned by DataDeleteRequest.ValidateAll() if the designated constraints
// aren't met.
type DataDeleteRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DataDeleteRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DataDeleteRequestMultiError) AllErrors() []error { return m }

// DataDeleteRequestValidationError is the validation error returned by
// DataDeleteRequest.Validate if the designated constraints aren't met.
type DataDeleteRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DataDeleteRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DataDeleteRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DataDeleteRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DataDeleteRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DataDeleteRequestValidationError) ErrorName() string {
	return "DataDeleteRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DataDeleteRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDataDeleteRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DataDeleteRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DataDeleteRequestValidationError{}

var _DataDeleteRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on DataDeleteResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DataDeleteResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DataDeleteResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DataDeleteResponseMultiError, or nil if none found.
func (m *DataDeleteResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *DataDeleteResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SnapToken

	if len(errors) > 0 {
		return DataDeleteResponseMultiError(errors)
	}

	return nil
}

// DataDeleteResponseMultiError is an error wrapping multiple validation errors
// returned by DataDeleteResponse.ValidateAll() if the designated constraints
// aren't met.
type DataDeleteResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DataDeleteResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DataDeleteResponseMultiError) AllErrors() []error { return m }

// DataDeleteResponseValidationError is the validation error returned by
// DataDeleteResponse.Validate if the designated constraints aren't met.
type DataDeleteResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DataDeleteResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DataDeleteResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DataDeleteResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DataDeleteResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DataDeleteResponseValidationError) ErrorName() string {
	return "DataDeleteResponseValidationError"
}

// Error satisfies the builtin error interface
func (e DataDeleteResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDataDeleteResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DataDeleteResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DataDeleteResponseValidationError{}

// Validate checks the field values on RelationshipDeleteRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RelationshipDeleteRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationshipDeleteRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RelationshipDeleteRequestMultiError, or nil if none found.
func (m *RelationshipDeleteRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationshipDeleteRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := RelationshipDeleteRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_RelationshipDeleteRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := RelationshipDeleteRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetFilter()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RelationshipDeleteRequestValidationError{
					field:  "Filter",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RelationshipDeleteRequestValidationError{
					field:  "Filter",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFilter()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RelationshipDeleteRequestValidationError{
				field:  "Filter",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RelationshipDeleteRequestMultiError(errors)
	}

	return nil
}

// RelationshipDeleteRequestMultiError is an error wrapping multiple validation
// errors returned by RelationshipDeleteRequest.ValidateAll() if the
// designated constraints aren't met.
type RelationshipDeleteRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationshipDeleteRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationshipDeleteRequestMultiError) AllErrors() []error { return m }

// RelationshipDeleteRequestValidationError is the validation error returned by
// RelationshipDeleteRequest.Validate if the designated constraints aren't met.
type RelationshipDeleteRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationshipDeleteRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationshipDeleteRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationshipDeleteRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationshipDeleteRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationshipDeleteRequestValidationError) ErrorName() string {
	return "RelationshipDeleteRequestValidationError"
}

// Error satisfies the builtin error interface
func (e RelationshipDeleteRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationshipDeleteRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationshipDeleteRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationshipDeleteRequestValidationError{}

var _RelationshipDeleteRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on RelationshipDeleteResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RelationshipDeleteResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationshipDeleteResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RelationshipDeleteResponseMultiError, or nil if none found.
func (m *RelationshipDeleteResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationshipDeleteResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SnapToken

	if len(errors) > 0 {
		return RelationshipDeleteResponseMultiError(errors)
	}

	return nil
}

// RelationshipDeleteResponseMultiError is an error wrapping multiple
// validation errors returned by RelationshipDeleteResponse.ValidateAll() if
// the designated constraints aren't met.
type RelationshipDeleteResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationshipDeleteResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationshipDeleteResponseMultiError) AllErrors() []error { return m }

// RelationshipDeleteResponseValidationError is the validation error returned
// by RelationshipDeleteResponse.Validate if the designated constraints aren't met.
type RelationshipDeleteResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationshipDeleteResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationshipDeleteResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationshipDeleteResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationshipDeleteResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationshipDeleteResponseValidationError) ErrorName() string {
	return "RelationshipDeleteResponseValidationError"
}

// Error satisfies the builtin error interface
func (e RelationshipDeleteResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationshipDeleteResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationshipDeleteResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationshipDeleteResponseValidationError{}

// Validate checks the field values on BundleRunRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *BundleRunRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BundleRunRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BundleRunRequestMultiError, or nil if none found.
func (m *BundleRunRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *BundleRunRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := BundleRunRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_BundleRunRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := BundleRunRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Name

	// no validation rules for Arguments

	if len(errors) > 0 {
		return BundleRunRequestMultiError(errors)
	}

	return nil
}

// BundleRunRequestMultiError is an error wrapping multiple validation errors
// returned by BundleRunRequest.ValidateAll() if the designated constraints
// aren't met.
type BundleRunRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BundleRunRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BundleRunRequestMultiError) AllErrors() []error { return m }

// BundleRunRequestValidationError is the validation error returned by
// BundleRunRequest.Validate if the designated constraints aren't met.
type BundleRunRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BundleRunRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BundleRunRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BundleRunRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BundleRunRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BundleRunRequestValidationError) ErrorName() string { return "BundleRunRequestValidationError" }

// Error satisfies the builtin error interface
func (e BundleRunRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBundleRunRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BundleRunRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BundleRunRequestValidationError{}

var _BundleRunRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on BundleRunResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *BundleRunResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BundleRunResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BundleRunResponseMultiError, or nil if none found.
func (m *BundleRunResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *BundleRunResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SnapToken

	if len(errors) > 0 {
		return BundleRunResponseMultiError(errors)
	}

	return nil
}

// BundleRunResponseMultiError is an error wrapping multiple validation errors
// returned by BundleRunResponse.ValidateAll() if the designated constraints
// aren't met.
type BundleRunResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BundleRunResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BundleRunResponseMultiError) AllErrors() []error { return m }

// BundleRunResponseValidationError is the validation error returned by
// BundleRunResponse.Validate if the designated constraints aren't met.
type BundleRunResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BundleRunResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BundleRunResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BundleRunResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BundleRunResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BundleRunResponseValidationError) ErrorName() string {
	return "BundleRunResponseValidationError"
}

// Error satisfies the builtin error interface
func (e BundleRunResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBundleRunResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BundleRunResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BundleRunResponseValidationError{}

// Validate checks the field values on BundleWriteRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *BundleWriteRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BundleWriteRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BundleWriteRequestMultiError, or nil if none found.
func (m *BundleWriteRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *BundleWriteRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := BundleWriteRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_BundleWriteRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := BundleWriteRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetBundles() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, BundleWriteRequestValidationError{
						field:  fmt.Sprintf("Bundles[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, BundleWriteRequestValidationError{
						field:  fmt.Sprintf("Bundles[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return BundleWriteRequestValidationError{
					field:  fmt.Sprintf("Bundles[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return BundleWriteRequestMultiError(errors)
	}

	return nil
}

// BundleWriteRequestMultiError is an error wrapping multiple validation errors
// returned by BundleWriteRequest.ValidateAll() if the designated constraints
// aren't met.
type BundleWriteRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BundleWriteRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BundleWriteRequestMultiError) AllErrors() []error { return m }

// BundleWriteRequestValidationError is the validation error returned by
// BundleWriteRequest.Validate if the designated constraints aren't met.
type BundleWriteRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BundleWriteRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BundleWriteRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BundleWriteRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BundleWriteRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BundleWriteRequestValidationError) ErrorName() string {
	return "BundleWriteRequestValidationError"
}

// Error satisfies the builtin error interface
func (e BundleWriteRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBundleWriteRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BundleWriteRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BundleWriteRequestValidationError{}

var _BundleWriteRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on BundleWriteResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *BundleWriteResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BundleWriteResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BundleWriteResponseMultiError, or nil if none found.
func (m *BundleWriteResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *BundleWriteResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return BundleWriteResponseMultiError(errors)
	}

	return nil
}

// BundleWriteResponseMultiError is an error wrapping multiple validation
// errors returned by BundleWriteResponse.ValidateAll() if the designated
// constraints aren't met.
type BundleWriteResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BundleWriteResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BundleWriteResponseMultiError) AllErrors() []error { return m }

// BundleWriteResponseValidationError is the validation error returned by
// BundleWriteResponse.Validate if the designated constraints aren't met.
type BundleWriteResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BundleWriteResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BundleWriteResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BundleWriteResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BundleWriteResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BundleWriteResponseValidationError) ErrorName() string {
	return "BundleWriteResponseValidationError"
}

// Error satisfies the builtin error interface
func (e BundleWriteResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBundleWriteResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BundleWriteResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BundleWriteResponseValidationError{}

// Validate checks the field values on BundleReadRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *BundleReadRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BundleReadRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BundleReadRequestMultiError, or nil if none found.
func (m *BundleReadRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *BundleReadRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := BundleReadRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_BundleReadRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := BundleReadRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Name

	if len(errors) > 0 {
		return BundleReadRequestMultiError(errors)
	}

	return nil
}

// BundleReadRequestMultiError is an error wrapping multiple validation errors
// returned by BundleReadRequest.ValidateAll() if the designated constraints
// aren't met.
type BundleReadRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BundleReadRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BundleReadRequestMultiError) AllErrors() []error { return m }

// BundleReadRequestValidationError is the validation error returned by
// BundleReadRequest.Validate if the designated constraints aren't met.
type BundleReadRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BundleReadRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BundleReadRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BundleReadRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BundleReadRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BundleReadRequestValidationError) ErrorName() string {
	return "BundleReadRequestValidationError"
}

// Error satisfies the builtin error interface
func (e BundleReadRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBundleReadRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BundleReadRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BundleReadRequestValidationError{}

var _BundleReadRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on BundleReadResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *BundleReadResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BundleReadResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BundleReadResponseMultiError, or nil if none found.
func (m *BundleReadResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *BundleReadResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetBundle()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BundleReadResponseValidationError{
					field:  "Bundle",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BundleReadResponseValidationError{
					field:  "Bundle",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBundle()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BundleReadResponseValidationError{
				field:  "Bundle",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return BundleReadResponseMultiError(errors)
	}

	return nil
}

// BundleReadResponseMultiError is an error wrapping multiple validation errors
// returned by BundleReadResponse.ValidateAll() if the designated constraints
// aren't met.
type BundleReadResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BundleReadResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BundleReadResponseMultiError) AllErrors() []error { return m }

// BundleReadResponseValidationError is the validation error returned by
// BundleReadResponse.Validate if the designated constraints aren't met.
type BundleReadResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BundleReadResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BundleReadResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BundleReadResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BundleReadResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BundleReadResponseValidationError) ErrorName() string {
	return "BundleReadResponseValidationError"
}

// Error satisfies the builtin error interface
func (e BundleReadResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBundleReadResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BundleReadResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BundleReadResponseValidationError{}

// Validate checks the field values on BundleDeleteRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *BundleDeleteRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BundleDeleteRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BundleDeleteRequestMultiError, or nil if none found.
func (m *BundleDeleteRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *BundleDeleteRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTenantId()) > 128 {
		err := BundleDeleteRequestValidationError{
			field:  "TenantId",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_BundleDeleteRequest_TenantId_Pattern.MatchString(m.GetTenantId()) {
		err := BundleDeleteRequestValidationError{
			field:  "TenantId",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Name

	if len(errors) > 0 {
		return BundleDeleteRequestMultiError(errors)
	}

	return nil
}

// BundleDeleteRequestMultiError is an error wrapping multiple validation
// errors returned by BundleDeleteRequest.ValidateAll() if the designated
// constraints aren't met.
type BundleDeleteRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BundleDeleteRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BundleDeleteRequestMultiError) AllErrors() []error { return m }

// BundleDeleteRequestValidationError is the validation error returned by
// BundleDeleteRequest.Validate if the designated constraints aren't met.
type BundleDeleteRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BundleDeleteRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BundleDeleteRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BundleDeleteRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BundleDeleteRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BundleDeleteRequestValidationError) ErrorName() string {
	return "BundleDeleteRequestValidationError"
}

// Error satisfies the builtin error interface
func (e BundleDeleteRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBundleDeleteRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BundleDeleteRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BundleDeleteRequestValidationError{}

var _BundleDeleteRequest_TenantId_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on BundleDeleteResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *BundleDeleteResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BundleDeleteResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BundleDeleteResponseMultiError, or nil if none found.
func (m *BundleDeleteResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *BundleDeleteResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Name

	if len(errors) > 0 {
		return BundleDeleteResponseMultiError(errors)
	}

	return nil
}

// BundleDeleteResponseMultiError is an error wrapping multiple validation
// errors returned by BundleDeleteResponse.ValidateAll() if the designated
// constraints aren't met.
type BundleDeleteResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BundleDeleteResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BundleDeleteResponseMultiError) AllErrors() []error { return m }

// BundleDeleteResponseValidationError is the validation error returned by
// BundleDeleteResponse.Validate if the designated constraints aren't met.
type BundleDeleteResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BundleDeleteResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BundleDeleteResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BundleDeleteResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BundleDeleteResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BundleDeleteResponseValidationError) ErrorName() string {
	return "BundleDeleteResponseValidationError"
}

// Error satisfies the builtin error interface
func (e BundleDeleteResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBundleDeleteResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BundleDeleteResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BundleDeleteResponseValidationError{}

// Validate checks the field values on TenantCreateRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *TenantCreateRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TenantCreateRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TenantCreateRequestMultiError, or nil if none found.
func (m *TenantCreateRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *TenantCreateRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetId()) > 64 {
		err := TenantCreateRequestValidationError{
			field:  "Id",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_TenantCreateRequest_Id_Pattern.MatchString(m.GetId()) {
		err := TenantCreateRequestValidationError{
			field:  "Id",
			reason: "value does not match regex pattern \"[a-zA-Z0-9-,]+\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetName()) > 64 {
		err := TenantCreateRequestValidationError{
			field:  "Name",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return TenantCreateRequestMultiError(errors)
	}

	return nil
}

// TenantCreateRequestMultiError is an error wrapping multiple validation
// errors returned by TenantCreateRequest.ValidateAll() if the designated
// constraints aren't met.
type TenantCreateRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TenantCreateRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TenantCreateRequestMultiError) AllErrors() []error { return m }

// TenantCreateRequestValidationError is the validation error returned by
// TenantCreateRequest.Validate if the designated constraints aren't met.
type TenantCreateRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TenantCreateRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TenantCreateRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TenantCreateRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TenantCreateRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TenantCreateRequestValidationError) ErrorName() string {
	return "TenantCreateRequestValidationError"
}

// Error satisfies the builtin error interface
func (e TenantCreateRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTenantCreateRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TenantCreateRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TenantCreateRequestValidationError{}

var _TenantCreateRequest_Id_Pattern = regexp.MustCompile("[a-zA-Z0-9-,]+")

// Validate checks the field values on TenantCreateResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *TenantCreateResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TenantCreateResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TenantCreateResponseMultiError, or nil if none found.
func (m *TenantCreateResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *TenantCreateResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetTenant()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TenantCreateResponseValidationError{
					field:  "Tenant",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TenantCreateResponseValidationError{
					field:  "Tenant",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTenant()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TenantCreateResponseValidationError{
				field:  "Tenant",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return TenantCreateResponseMultiError(errors)
	}

	return nil
}

// TenantCreateResponseMultiError is an error wrapping multiple validation
// errors returned by TenantCreateResponse.ValidateAll() if the designated
// constraints aren't met.
type TenantCreateResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TenantCreateResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TenantCreateResponseMultiError) AllErrors() []error { return m }

// TenantCreateResponseValidationError is the validation error returned by
// TenantCreateResponse.Validate if the designated constraints aren't met.
type TenantCreateResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TenantCreateResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TenantCreateResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TenantCreateResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TenantCreateResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TenantCreateResponseValidationError) ErrorName() string {
	return "TenantCreateResponseValidationError"
}

// Error satisfies the builtin error interface
func (e TenantCreateResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTenantCreateResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TenantCreateResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TenantCreateResponseValidationError{}

// Validate checks the field values on TenantDeleteRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *TenantDeleteRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TenantDeleteRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TenantDeleteRequestMultiError, or nil if none found.
func (m *TenantDeleteRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *TenantDeleteRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return TenantDeleteRequestMultiError(errors)
	}

	return nil
}

// TenantDeleteRequestMultiError is an error wrapping multiple validation
// errors returned by TenantDeleteRequest.ValidateAll() if the designated
// constraints aren't met.
type TenantDeleteRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TenantDeleteRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TenantDeleteRequestMultiError) AllErrors() []error { return m }

// TenantDeleteRequestValidationError is the validation error returned by
// TenantDeleteRequest.Validate if the designated constraints aren't met.
type TenantDeleteRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TenantDeleteRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TenantDeleteRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TenantDeleteRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TenantDeleteRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TenantDeleteRequestValidationError) ErrorName() string {
	return "TenantDeleteRequestValidationError"
}

// Error satisfies the builtin error interface
func (e TenantDeleteRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTenantDeleteRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TenantDeleteRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TenantDeleteRequestValidationError{}

// Validate checks the field values on TenantDeleteResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *TenantDeleteResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TenantDeleteResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TenantDeleteResponseMultiError, or nil if none found.
func (m *TenantDeleteResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *TenantDeleteResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for TenantId

	if len(errors) > 0 {
		return TenantDeleteResponseMultiError(errors)
	}

	return nil
}

// TenantDeleteResponseMultiError is an error wrapping multiple validation
// errors returned by TenantDeleteResponse.ValidateAll() if the designated
// constraints aren't met.
type TenantDeleteResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TenantDeleteResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TenantDeleteResponseMultiError) AllErrors() []error { return m }

// TenantDeleteResponseValidationError is the validation error returned by
// TenantDeleteResponse.Validate if the designated constraints aren't met.
type TenantDeleteResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TenantDeleteResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TenantDeleteResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TenantDeleteResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TenantDeleteResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TenantDeleteResponseValidationError) ErrorName() string {
	return "TenantDeleteResponseValidationError"
}

// Error satisfies the builtin error interface
func (e TenantDeleteResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTenantDeleteResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TenantDeleteResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TenantDeleteResponseValidationError{}

// Validate checks the field values on TenantListRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *TenantListRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TenantListRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TenantListRequestMultiError, or nil if none found.
func (m *TenantListRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *TenantListRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetPageSize() != 0 {

		if m.GetPageSize() < 1 {
			err := TenantListRequestValidationError{
				field:  "PageSize",
				reason: "value must be greater than or equal to 1",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.GetContinuousToken() != "" {

	}

	if len(errors) > 0 {
		return TenantListRequestMultiError(errors)
	}

	return nil
}

// TenantListRequestMultiError is an error wrapping multiple validation errors
// returned by TenantListRequest.ValidateAll() if the designated constraints
// aren't met.
type TenantListRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TenantListRequestMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TenantListRequestMultiError) AllErrors() []error { return m }

// TenantListRequestValidationError is the validation error returned by
// TenantListRequest.Validate if the designated constraints aren't met.
type TenantListRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TenantListRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TenantListRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TenantListRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TenantListRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TenantListRequestValidationError) ErrorName() string {
	return "TenantListRequestValidationError"
}

// Error satisfies the builtin error interface
func (e TenantListRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTenantListRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TenantListRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TenantListRequestValidationError{}

// Validate checks the field values on TenantListResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *TenantListResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TenantListResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TenantListResponseMultiError, or nil if none found.
func (m *TenantListResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *TenantListResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetTenants() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, TenantListResponseValidationError{
						field:  fmt.Sprintf("Tenants[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, TenantListResponseValidationError{
						field:  fmt.Sprintf("Tenants[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return TenantListResponseValidationError{
					field:  fmt.Sprintf("Tenants[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for ContinuousToken

	if len(errors) > 0 {
		return TenantListResponseMultiError(errors)
	}

	return nil
}

// TenantListResponseMultiError is an error wrapping multiple validation errors
// returned by TenantListResponse.ValidateAll() if the designated constraints
// aren't met.
type TenantListResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TenantListResponseMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TenantListResponseMultiError) AllErrors() []error { return m }

// TenantListResponseValidationError is the validation error returned by
// TenantListResponse.Validate if the designated constraints aren't met.
type TenantListResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TenantListResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TenantListResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TenantListResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TenantListResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TenantListResponseValidationError) ErrorName() string {
	return "TenantListResponseValidationError"
}

// Error satisfies the builtin error interface
func (e TenantListResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTenantListResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TenantListResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TenantListResponseValidationError{}
